package media

// Code generated by cdproto-gen. DO NOT EDIT.

import (
	"fmt"

	"github.com/mailru/easyjson"
	"github.com/mailru/easyjson/jlexer"
	"github.com/mailru/easyjson/jwriter"
)

// PlayerID players will get an ID that is unique within the agent context.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Media#type-PlayerId
type PlayerID string

// String returns the PlayerID as string value.
func (t PlayerID) String() string {
	return string(t)
}

// Timestamp [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Media#type-Timestamp
type Timestamp float64

// Float64 returns the Timestamp as float64 value.
func (t Timestamp) Float64() float64 {
	return float64(t)
}

// PlayerMessage have one type per entry in MediaLogRecord::Type Corresponds
// to kMessage.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Media#type-PlayerMessage
type PlayerMessage struct {
	Level   PlayerMessageLevel `json:"level"` // Keep in sync with MediaLogMessageLevel We are currently keeping the message level 'error' separate from the PlayerError type because right now they represent different things, this one being a DVLOG(ERROR) style log message that gets printed based on what log level is selected in the UI, and the other is a representation of a media::PipelineStatus object. Soon however we're going to be moving away from using PipelineStatus for errors and introducing a new error type which should hopefully let us integrate the error log level into the PlayerError type.
	Message string             `json:"message"`
}

// PlayerProperty corresponds to kMediaPropertyChange.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Media#type-PlayerProperty
type PlayerProperty struct {
	Name  string `json:"name"`
	Value string `json:"value"`
}

// PlayerEvent corresponds to kMediaEventTriggered.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Media#type-PlayerEvent
type PlayerEvent struct {
	Timestamp Timestamp `json:"timestamp"`
	Value     string    `json:"value"`
}

// PlayerErrorSourceLocation represents logged source line numbers reported
// in an error. NOTE: file and line are from chromium c++ implementation code,
// not js.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Media#type-PlayerErrorSourceLocation
type PlayerErrorSourceLocation struct {
	File string `json:"file"`
	Line int64  `json:"line"`
}

// PlayerError corresponds to kMediaError.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Media#type-PlayerError
type PlayerError struct {
	ErrorType string                       `json:"errorType"`
	Code      int64                        `json:"code"`  // Code is the numeric enum entry for a specific set of error codes, such as PipelineStatusCodes in media/base/pipeline_status.h
	Stack     []*PlayerErrorSourceLocation `json:"stack"` // A trace of where this error was caused / where it passed through.
	Cause     []*PlayerError               `json:"cause"` // Errors potentially have a root cause error, ie, a DecoderError might be caused by an WindowsError
	Data      easyjson.RawMessage          `json:"data"`
}

// PlayerMessageLevel keep in sync with MediaLogMessageLevel We are currently
// keeping the message level 'error' separate from the PlayerError type because
// right now they represent different things, this one being a DVLOG(ERROR)
// style log message that gets printed based on what log level is selected in
// the UI, and the other is a representation of a media::PipelineStatus object.
// Soon however we're going to be moving away from using PipelineStatus for
// errors and introducing a new error type which should hopefully let us
// integrate the error log level into the PlayerError type.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Media#type-PlayerMessage
type PlayerMessageLevel string

// String returns the PlayerMessageLevel as string value.
func (t PlayerMessageLevel) String() string {
	return string(t)
}

// PlayerMessageLevel values.
const (
	PlayerMessageLevelError   PlayerMessageLevel = "error"
	PlayerMessageLevelWarning PlayerMessageLevel = "warning"
	PlayerMessageLevelInfo    PlayerMessageLevel = "info"
	PlayerMessageLevelDebug   PlayerMessageLevel = "debug"
)

// MarshalEasyJSON satisfies easyjson.Marshaler.
func (t PlayerMessageLevel) MarshalEasyJSON(out *jwriter.Writer) {
	out.String(string(t))
}

// MarshalJSON satisfies json.Marshaler.
func (t PlayerMessageLevel) MarshalJSON() ([]byte, error) {
	return easyjson.Marshal(t)
}

// UnmarshalEasyJSON satisfies easyjson.Unmarshaler.
func (t *PlayerMessageLevel) UnmarshalEasyJSON(in *jlexer.Lexer) {
	v := in.String()
	switch PlayerMessageLevel(v) {
	case PlayerMessageLevelError:
		*t = PlayerMessageLevelError
	case PlayerMessageLevelWarning:
		*t = PlayerMessageLevelWarning
	case PlayerMessageLevelInfo:
		*t = PlayerMessageLevelInfo
	case PlayerMessageLevelDebug:
		*t = PlayerMessageLevelDebug

	default:
		in.AddError(fmt.Errorf("unknown PlayerMessageLevel value: %v", v))
	}
}

// UnmarshalJSON satisfies json.Unmarshaler.
func (t *PlayerMessageLevel) UnmarshalJSON(buf []byte) error {
	return easyjson.Unmarshal(buf, t)
}
