/*
 * Decompiled with CFR 0.152.
 */
package xalanjdoc;

import com.sun.javadoc.DocErrorReporter;
import com.sun.javadoc.PackageDoc;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import xalanjdoc.ConfigurationStandard;
import xalanjdoc.Standard;

public class Group {
    private static Map regExpGroupMap = new HashMap();
    private static List sortedRegExpList = new ArrayList();
    private static List groupList = new ArrayList();
    private static Map pkgNameGroupMap = new HashMap();

    static List asList(Object[] arr) {
        ArrayList<Object> list = new ArrayList<Object>();
        int i = 0;
        while (i < arr.length) {
            list.add(arr[i]);
            ++i;
        }
        return list;
    }

    public static boolean checkPackageGroups(String groupname, String pkgNameFormList, DocErrorReporter reporter) {
        StringTokenizer strtok = new StringTokenizer(pkgNameFormList, ":");
        if (groupList.contains(groupname)) {
            reporter.printError(Group.getText("doclet.Groupname_already_used", groupname));
            return false;
        }
        groupList.add(groupname);
        while (strtok.hasMoreTokens()) {
            String id = strtok.nextToken();
            if (id.length() == 0) {
                reporter.printError(Group.getText("doclet.Error_in_packagelist", groupname, pkgNameFormList));
                return false;
            }
            if (id.endsWith("*")) {
                if (Group.foundGroupFormat(regExpGroupMap, id = id.substring(0, id.length() - 1), reporter)) {
                    return false;
                }
                regExpGroupMap.put(id, groupname);
                sortedRegExpList.add(id);
                continue;
            }
            if (Group.foundGroupFormat(pkgNameGroupMap, id, reporter)) {
                return false;
            }
            pkgNameGroupMap.put(id, groupname);
        }
        Collections.sort(sortedRegExpList, new MapKeyComparator());
        return true;
    }

    static boolean foundGroupFormat(Map map, String pkgFormat, DocErrorReporter reporter) {
        if (map.containsKey(pkgFormat)) {
            reporter.printError(Group.getText("doclet.Same_package_name_used", pkgFormat));
            return true;
        }
        return false;
    }

    public static List getGroupList() {
        return groupList;
    }

    static List getPkgList(Map map, String groupname) {
        ArrayList list = (ArrayList)map.get(groupname);
        if (list == null) {
            list = new ArrayList();
            map.put(groupname, list);
        }
        return list;
    }

    private static String getText(String text) {
        Standard.configuration();
        return ConfigurationStandard.standardmessage.getText(text);
    }

    private static String getText(String text, String arg) {
        Standard.configuration();
        return ConfigurationStandard.standardmessage.getText(text, arg);
    }

    private static String getText(String text, String arg1, String arg2) {
        Standard.configuration();
        return ConfigurationStandard.standardmessage.getText(text, arg1, arg2);
    }

    public static Map groupPackages(PackageDoc[] packages) {
        String defaultGroupName;
        HashMap groupPackageMap = new HashMap();
        String string = defaultGroupName = pkgNameGroupMap.isEmpty() && regExpGroupMap.isEmpty() ? Group.getText("doclet.Packages") : Group.getText("doclet.Other_Packages");
        if (!groupList.contains(defaultGroupName)) {
            groupList.add(defaultGroupName);
        }
        int i = 0;
        while (i < packages.length) {
            PackageDoc pkg = packages[i];
            String pkgName = pkg.name();
            String groupName = (String)pkgNameGroupMap.get(pkgName);
            if (groupName == null) {
                groupName = Group.regExpGroupName(pkgName);
            }
            if (groupName == null) {
                groupName = defaultGroupName;
            }
            Group.getPkgList(groupPackageMap, groupName).add(pkg);
            ++i;
        }
        return groupPackageMap;
    }

    static String regExpGroupName(String pkgName) {
        int j = 0;
        while (j < sortedRegExpList.size()) {
            String regexp = (String)sortedRegExpList.get(j);
            if (pkgName.startsWith(regexp)) {
                return (String)regExpGroupMap.get(regexp);
            }
            ++j;
        }
        return null;
    }

    private static class MapKeyComparator
    implements Comparator {
        MapKeyComparator() {
        }

        public int compare(Object key1, Object key2) {
            return ((String)key2).length() - ((String)key1).length();
        }
    }
}

