/*
 * Decompiled with CFR 0.152.
 */
package xalanjdoc;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.ConstructorDoc;
import com.sun.javadoc.ExecutableMemberDoc;
import com.sun.javadoc.FieldDoc;
import com.sun.javadoc.MemberDoc;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.PackageDoc;
import com.sun.javadoc.Parameter;
import com.sun.javadoc.ProgramElementDoc;
import com.sun.javadoc.RootDoc;
import com.sun.tools.doclets.ClassTree;
import com.sun.tools.doclets.DocletAbortException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SequencedCollection;
import java.util.Set;
import java.util.TreeSet;
import xalanjdoc.ClassUseWriter;
import xalanjdoc.PackageUseWriter;
import xalanjdoc.Standard;

public class ClassUseMapper {
    private final ClassTree classtree;
    public Map classToPackage = new HashMap();
    public Map classToClass = new HashMap();
    public Map classToSubclass = new HashMap();
    public Map classToSubinterface = new HashMap();
    public Map classToImplementingClass = new HashMap();
    public Map classToField = new HashMap();
    public Map classToMethodReturn = new HashMap();
    public Map classToMethodArgs = new HashMap();
    public Map classToMethodThrows = new HashMap();
    public Map classToConstructorArgs = new HashMap();
    public Map classToConstructorThrows = new HashMap();

    private ClassUseMapper(RootDoc root, ClassTree classtree) {
        this.classtree = classtree;
        Iterator it = classtree.baseclasses().iterator();
        while (it.hasNext()) {
            this.subclasses((ClassDoc)it.next());
        }
        Iterator it2 = classtree.baseinterfaces().iterator();
        while (it2.hasNext()) {
            this.implementingClasses((ClassDoc)it2.next());
        }
        ClassDoc[] classes = root.classes();
        int i = 0;
        while (i < classes.length) {
            ClassDoc cd = classes[i];
            FieldDoc[] fields = cd.fields();
            int j = 0;
            while (j < fields.length) {
                FieldDoc fd = fields[j];
                ClassDoc tcd = fd.type().asClassDoc();
                if (tcd != null) {
                    this.add(this.classToField, tcd, (ProgramElementDoc)fd);
                }
                ++j;
            }
            ConstructorDoc[] cons = cd.constructors();
            int j2 = 0;
            while (j2 < cons.length) {
                this.mapExecutable((ExecutableMemberDoc)cons[j2]);
                ++j2;
            }
            MethodDoc[] meths = cd.methods();
            int j3 = 0;
            while (j3 < meths.length) {
                MethodDoc md = meths[j3];
                this.mapExecutable((ExecutableMemberDoc)md);
                ClassDoc tcd = md.returnType().asClassDoc();
                if (tcd != null) {
                    this.add(this.classToMethodReturn, tcd, (ProgramElementDoc)md);
                }
                ++j3;
            }
            ++i;
        }
    }

    private void add(Map map, ClassDoc cd, ProgramElementDoc ref) {
        this.refList(map, cd).add(ref);
        this.packageSet(cd).add(ref.containingPackage());
        this.classSet(cd).add(ref instanceof MemberDoc ? ((MemberDoc)ref).containingClass() : ref);
    }

    private void addAll(Map map, ClassDoc cd, Collection refs) {
        if (refs == null) {
            return;
        }
        this.refList(map, cd).addAll(refs);
        Set pkgSet = this.packageSet(cd);
        Set clsSet = this.classSet(cd);
        Iterator it = refs.iterator();
        while (it.hasNext()) {
            ProgramElementDoc pedoc = (ProgramElementDoc)it.next();
            pkgSet.add(pedoc.containingPackage());
            clsSet.add(pedoc instanceof MemberDoc ? ((MemberDoc)pedoc).containingClass() : pedoc);
        }
    }

    private Set classSet(ClassDoc cd) {
        TreeSet clsSet = (TreeSet)this.classToClass.get(cd);
        if (clsSet == null) {
            clsSet = new TreeSet();
            this.classToClass.put(cd, clsSet);
        }
        return clsSet;
    }

    public static void generate(RootDoc root, ClassTree classtree) throws DocletAbortException {
        ClassUseMapper mapper = new ClassUseMapper(root, classtree);
        ClassDoc[] classes = root.classes();
        int i = 0;
        while (i < classes.length) {
            ClassUseWriter.generate(mapper, classes[i]);
            ++i;
        }
        PackageDoc[] pkgs = Standard.configuration().packages;
        int i2 = 0;
        while (i2 < pkgs.length) {
            PackageUseWriter.generate(mapper, pkgs[i2]);
            ++i2;
        }
    }

    private Collection implementingClasses(ClassDoc cd) {
        SequencedCollection ret = (List)this.classToImplementingClass.get(cd);
        if (ret == null) {
            Iterator it;
            ret = new TreeSet();
            List impl = this.classtree.implementingclasses(cd);
            if (impl != null) {
                ret.addAll(impl);
                it = impl.iterator();
                while (it.hasNext()) {
                    ret.addAll(this.subclasses((ClassDoc)it.next()));
                }
            }
            it = this.subinterfaces(cd).iterator();
            while (it.hasNext()) {
                ret.addAll(this.implementingClasses((ClassDoc)it.next()));
            }
            this.addAll(this.classToImplementingClass, cd, ret);
        }
        return ret;
    }

    private void mapExecutable(ExecutableMemberDoc em) {
        Parameter[] params = em.parameters();
        boolean isConstructor = em.isConstructor();
        ArrayList<ClassDoc> classArgs = new ArrayList<ClassDoc>();
        int k = 0;
        while (k < params.length) {
            ClassDoc pcd = params[k].type().asClassDoc();
            if (pcd != null && !classArgs.contains(pcd)) {
                this.add(isConstructor ? this.classToConstructorArgs : this.classToMethodArgs, pcd, (ProgramElementDoc)em);
                classArgs.add(pcd);
            }
            ++k;
        }
        ClassDoc[] thr = em.thrownExceptions();
        int k2 = 0;
        while (k2 < thr.length) {
            this.add(isConstructor ? this.classToConstructorThrows : this.classToMethodThrows, thr[k2], (ProgramElementDoc)em);
            ++k2;
        }
    }

    private Set packageSet(ClassDoc cd) {
        TreeSet pkgSet = (TreeSet)this.classToPackage.get(cd);
        if (pkgSet == null) {
            pkgSet = new TreeSet();
            this.classToPackage.put(cd, pkgSet);
        }
        return pkgSet;
    }

    private List refList(Map map, ClassDoc cd) {
        ArrayList list = (ArrayList)map.get(cd);
        if (list == null) {
            list = new ArrayList();
            map.put(cd, list);
        }
        return list;
    }

    private Collection subclasses(ClassDoc cd) {
        TreeSet ret = (TreeSet)this.classToSubclass.get(cd);
        if (ret == null) {
            ret = new TreeSet();
            List subs = this.classtree.subclasses(cd);
            if (subs != null) {
                ret.addAll(subs);
                Iterator it = subs.iterator();
                while (it.hasNext()) {
                    ret.addAll(this.subclasses((ClassDoc)it.next()));
                }
            }
            this.addAll(this.classToSubclass, cd, ret);
        }
        return ret;
    }

    private Collection subinterfaces(ClassDoc cd) {
        TreeSet ret = (TreeSet)this.classToSubinterface.get(cd);
        if (ret == null) {
            ret = new TreeSet();
            List subs = this.classtree.subinterfaces(cd);
            if (subs != null) {
                ret.addAll(subs);
                Iterator it = subs.iterator();
                while (it.hasNext()) {
                    ret.addAll(this.subinterfaces((ClassDoc)it.next()));
                }
            }
            this.addAll(this.classToSubinterface, cd, ret);
        }
        return ret;
    }
}

