/*
 * Decompiled with CFR 0.152.
 */
package org.xmldb.api.reference;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Random;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.Resource;
import org.xmldb.api.base.Service;
import org.xmldb.api.base.XMLDBException;
import org.xmldb.api.reference.DirectoryFilter;
import org.xmldb.api.reference.FileFilter;
import org.xmldb.api.reference.modules.BinaryResourceImpl;
import org.xmldb.api.reference.modules.CollectionManagementServiceImpl;
import org.xmldb.api.reference.modules.XMLResourceImpl;
import org.xmldb.api.reference.modules.XPathQueryServiceImpl;
import org.xmldb.api.sdk.SimpleCollection;

public class CollectionImpl
extends SimpleCollection {
    protected File collection = null;

    public CollectionImpl(String string) throws FileNotFoundException, XMLDBException {
        this.collection = new File(string);
        if (!this.collection.isDirectory()) {
            throw new FileNotFoundException();
        }
        this.registerService((Service)new XPathQueryServiceImpl());
        this.registerService((Service)new CollectionManagementServiceImpl(string));
    }

    public String getName() throws XMLDBException {
        return this.collection.getName();
    }

    public Collection getParentCollection() throws XMLDBException {
        if (this.collection.getParent() == null) {
            return null;
        }
        try {
            return new CollectionImpl(this.collection.getParent());
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
    }

    public int getChildCollectionCount() throws XMLDBException {
        return this.collection.list(new DirectoryFilter()).length;
    }

    public String[] listChildCollections() throws XMLDBException {
        return this.collection.list(new DirectoryFilter());
    }

    public Collection getChildCollection(String string) throws XMLDBException {
        try {
            return new CollectionImpl(this.collection.getPath() + File.separator + string);
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
    }

    public int getResourceCount() throws XMLDBException {
        return this.collection.list(new FileFilter()).length;
    }

    public String[] listResources() throws XMLDBException {
        return this.collection.list(new FileFilter());
    }

    public Resource createResource(String string, String string2) throws XMLDBException {
        if (string == null || string.equals("")) {
            string = this.createId();
        }
        if (string2.equals("XMLResource")) {
            return new XMLResourceImpl(this, string, string);
        }
        if (string2.equals("BinaryResource")) {
            return new BinaryResourceImpl(this, string);
        }
        throw new XMLDBException(302);
    }

    public void removeResource(Resource resource) throws XMLDBException {
        if (resource.getId() == null || resource.getId().equals("")) {
            throw new XMLDBException(301);
        }
        File file = new File(this.collection, resource.getId());
        if (file == null || file.isDirectory()) {
            throw new XMLDBException(300);
        }
        file.delete();
    }

    public void storeResource(Resource resource) throws XMLDBException {
        try {
            this.validateResource(resource);
            File file = new File(this.collection, resource.getId());
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            if (resource.getResourceType().equals("XMLResource")) {
                fileOutputStream.write(((String)resource.getContent()).getBytes());
            } else if (resource.getResourceType().equals("BinaryResource")) {
                fileOutputStream.write((byte[])resource.getContent());
            } else {
                throw new XMLDBException(301);
            }
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public Resource getResource(String string) throws XMLDBException {
        try {
            File file = new File(this.collection, string);
            if (file.isFile()) {
                FileInputStream fileInputStream = new FileInputStream(file);
                byte[] byArray = new byte[fileInputStream.available()];
                fileInputStream.read(byArray);
                fileInputStream.close();
                if (byArray[0] == 60) {
                    return new XMLResourceImpl(this, string, string, new String(byArray));
                }
                return new BinaryResourceImpl((Collection)this, string, byArray);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return null;
    }

    public String createId() throws XMLDBException {
        return this.collection.getName() + System.currentTimeMillis() + new Random().nextLong();
    }

    public void close() throws XMLDBException {
    }

    protected void validateResource(Resource resource) throws XMLDBException {
        if (resource.getId() == null || resource.getId().equals("") || resource.getContent() == null) {
            throw new XMLDBException(301);
        }
    }
}

