// *** THIS FILE IS GENERATED - DO NOT EDIT ***
// See helper_file_generator.py for modifications


/***************************************************************************
 *
 * Copyright (c) 2015-2019 The Khronos Group Inc.
 * Copyright (c) 2015-2019 Valve Corporation
 * Copyright (c) 2015-2019 LunarG, Inc.
 * Copyright (c) 2015-2019 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Author: Mark Lobodzinski <mark@lunarg.com>
 * Author: Courtney Goeltzenleuchter <courtneygo@google.com>
 * Author: Tobin Ehlis <tobine@google.com>
 * Author: Chris Forbes <chrisforbes@google.com>
 * Author: John Zulauf<jzulauf@lunarg.com>
 *
 ****************************************************************************/


#include "vk_safe_struct.h"

#include <string.h>
#include <cassert>
#include <cstring>

#include <vulkan/vk_layer.h>


safe_VkApplicationInfo::safe_VkApplicationInfo(const VkApplicationInfo* in_struct) :
    sType(in_struct->sType),
    applicationVersion(in_struct->applicationVersion),
    engineVersion(in_struct->engineVersion),
    apiVersion(in_struct->apiVersion)
{
    pNext = SafePnextCopy(in_struct->pNext);
    pApplicationName = SafeStringCopy(in_struct->pApplicationName);
    pEngineName = SafeStringCopy(in_struct->pEngineName);
}

safe_VkApplicationInfo::safe_VkApplicationInfo() :
    pNext(nullptr),
    pApplicationName(nullptr),
    pEngineName(nullptr)
{}

safe_VkApplicationInfo::safe_VkApplicationInfo(const safe_VkApplicationInfo& src)
{
    sType = src.sType;
    applicationVersion = src.applicationVersion;
    engineVersion = src.engineVersion;
    apiVersion = src.apiVersion;
    pNext = SafePnextCopy(src.pNext);
    pApplicationName = SafeStringCopy(src.pApplicationName);
    pEngineName = SafeStringCopy(src.pEngineName);
}

safe_VkApplicationInfo& safe_VkApplicationInfo::operator=(const safe_VkApplicationInfo& src)
{
    if (&src == this) return *this;

    if (pApplicationName) delete [] pApplicationName;
    if (pEngineName) delete [] pEngineName;
    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    applicationVersion = src.applicationVersion;
    engineVersion = src.engineVersion;
    apiVersion = src.apiVersion;
    pNext = SafePnextCopy(src.pNext);
    pApplicationName = SafeStringCopy(src.pApplicationName);
    pEngineName = SafeStringCopy(src.pEngineName);

    return *this;
}

safe_VkApplicationInfo::~safe_VkApplicationInfo()
{
    if (pApplicationName) delete [] pApplicationName;
    if (pEngineName) delete [] pEngineName;
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkApplicationInfo::initialize(const VkApplicationInfo* in_struct)
{
    sType = in_struct->sType;
    applicationVersion = in_struct->applicationVersion;
    engineVersion = in_struct->engineVersion;
    apiVersion = in_struct->apiVersion;
    pNext = SafePnextCopy(in_struct->pNext);
    pApplicationName = SafeStringCopy(in_struct->pApplicationName);
    pEngineName = SafeStringCopy(in_struct->pEngineName);
}

void safe_VkApplicationInfo::initialize(const safe_VkApplicationInfo* src)
{
    sType = src->sType;
    applicationVersion = src->applicationVersion;
    engineVersion = src->engineVersion;
    apiVersion = src->apiVersion;
    pNext = SafePnextCopy(src->pNext);
    pApplicationName = SafeStringCopy(src->pApplicationName);
    pEngineName = SafeStringCopy(src->pEngineName);
}

safe_VkInstanceCreateInfo::safe_VkInstanceCreateInfo(const VkInstanceCreateInfo* in_struct) :
    sType(in_struct->sType),
    flags(in_struct->flags),
    pApplicationInfo(nullptr),
    enabledLayerCount(in_struct->enabledLayerCount),
    enabledExtensionCount(in_struct->enabledExtensionCount)
{
    pNext = SafePnextCopy(in_struct->pNext);
    char **tmp_ppEnabledLayerNames = new char *[in_struct->enabledLayerCount];
    for (uint32_t i = 0; i < enabledLayerCount; ++i) {
        tmp_ppEnabledLayerNames[i] = SafeStringCopy(in_struct->ppEnabledLayerNames[i]);
    }
    ppEnabledLayerNames = tmp_ppEnabledLayerNames;
    char **tmp_ppEnabledExtensionNames = new char *[in_struct->enabledExtensionCount];
    for (uint32_t i = 0; i < enabledExtensionCount; ++i) {
        tmp_ppEnabledExtensionNames[i] = SafeStringCopy(in_struct->ppEnabledExtensionNames[i]);
    }
    ppEnabledExtensionNames = tmp_ppEnabledExtensionNames;
    if (in_struct->pApplicationInfo)
        pApplicationInfo = new safe_VkApplicationInfo(in_struct->pApplicationInfo);
}

safe_VkInstanceCreateInfo::safe_VkInstanceCreateInfo() :
    pNext(nullptr),
    pApplicationInfo(nullptr),
    ppEnabledLayerNames(nullptr),
    ppEnabledExtensionNames(nullptr)
{}

safe_VkInstanceCreateInfo::safe_VkInstanceCreateInfo(const safe_VkInstanceCreateInfo& src)
{
    sType = src.sType;
    flags = src.flags;
    pApplicationInfo = nullptr;
    enabledLayerCount = src.enabledLayerCount;
    enabledExtensionCount = src.enabledExtensionCount;
    pNext = SafePnextCopy(src.pNext);
    char **tmp_ppEnabledLayerNames = new char *[src.enabledLayerCount];
    for (uint32_t i = 0; i < enabledLayerCount; ++i) {
        tmp_ppEnabledLayerNames[i] = SafeStringCopy(src.ppEnabledLayerNames[i]);
    }
    ppEnabledLayerNames = tmp_ppEnabledLayerNames;
    char **tmp_ppEnabledExtensionNames = new char *[src.enabledExtensionCount];
    for (uint32_t i = 0; i < enabledExtensionCount; ++i) {
        tmp_ppEnabledExtensionNames[i] = SafeStringCopy(src.ppEnabledExtensionNames[i]);
    }
    ppEnabledExtensionNames = tmp_ppEnabledExtensionNames;
    if (src.pApplicationInfo)
        pApplicationInfo = new safe_VkApplicationInfo(*src.pApplicationInfo);
}

safe_VkInstanceCreateInfo& safe_VkInstanceCreateInfo::operator=(const safe_VkInstanceCreateInfo& src)
{
    if (&src == this) return *this;

    if (pApplicationInfo)
        delete pApplicationInfo;
    if (ppEnabledLayerNames) {
        for (uint32_t i = 0; i < enabledLayerCount; ++i) {
            delete [] ppEnabledLayerNames[i];
        }
        delete [] ppEnabledLayerNames;
    }
    if (ppEnabledExtensionNames) {
        for (uint32_t i = 0; i < enabledExtensionCount; ++i) {
            delete [] ppEnabledExtensionNames[i];
        }
        delete [] ppEnabledExtensionNames;
    }
    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    flags = src.flags;
    pApplicationInfo = nullptr;
    enabledLayerCount = src.enabledLayerCount;
    enabledExtensionCount = src.enabledExtensionCount;
    pNext = SafePnextCopy(src.pNext);
    char **tmp_ppEnabledLayerNames = new char *[src.enabledLayerCount];
    for (uint32_t i = 0; i < enabledLayerCount; ++i) {
        tmp_ppEnabledLayerNames[i] = SafeStringCopy(src.ppEnabledLayerNames[i]);
    }
    ppEnabledLayerNames = tmp_ppEnabledLayerNames;
    char **tmp_ppEnabledExtensionNames = new char *[src.enabledExtensionCount];
    for (uint32_t i = 0; i < enabledExtensionCount; ++i) {
        tmp_ppEnabledExtensionNames[i] = SafeStringCopy(src.ppEnabledExtensionNames[i]);
    }
    ppEnabledExtensionNames = tmp_ppEnabledExtensionNames;
    if (src.pApplicationInfo)
        pApplicationInfo = new safe_VkApplicationInfo(*src.pApplicationInfo);

    return *this;
}

safe_VkInstanceCreateInfo::~safe_VkInstanceCreateInfo()
{
    if (pApplicationInfo)
        delete pApplicationInfo;
    if (ppEnabledLayerNames) {
        for (uint32_t i = 0; i < enabledLayerCount; ++i) {
            delete [] ppEnabledLayerNames[i];
        }
        delete [] ppEnabledLayerNames;
    }
    if (ppEnabledExtensionNames) {
        for (uint32_t i = 0; i < enabledExtensionCount; ++i) {
            delete [] ppEnabledExtensionNames[i];
        }
        delete [] ppEnabledExtensionNames;
    }
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkInstanceCreateInfo::initialize(const VkInstanceCreateInfo* in_struct)
{
    sType = in_struct->sType;
    flags = in_struct->flags;
    pApplicationInfo = nullptr;
    enabledLayerCount = in_struct->enabledLayerCount;
    enabledExtensionCount = in_struct->enabledExtensionCount;
    pNext = SafePnextCopy(in_struct->pNext);
    char **tmp_ppEnabledLayerNames = new char *[in_struct->enabledLayerCount];
    for (uint32_t i = 0; i < enabledLayerCount; ++i) {
        tmp_ppEnabledLayerNames[i] = SafeStringCopy(in_struct->ppEnabledLayerNames[i]);
    }
    ppEnabledLayerNames = tmp_ppEnabledLayerNames;
    char **tmp_ppEnabledExtensionNames = new char *[in_struct->enabledExtensionCount];
    for (uint32_t i = 0; i < enabledExtensionCount; ++i) {
        tmp_ppEnabledExtensionNames[i] = SafeStringCopy(in_struct->ppEnabledExtensionNames[i]);
    }
    ppEnabledExtensionNames = tmp_ppEnabledExtensionNames;
    if (in_struct->pApplicationInfo)
        pApplicationInfo = new safe_VkApplicationInfo(in_struct->pApplicationInfo);
}

void safe_VkInstanceCreateInfo::initialize(const safe_VkInstanceCreateInfo* src)
{
    sType = src->sType;
    flags = src->flags;
    pApplicationInfo = nullptr;
    enabledLayerCount = src->enabledLayerCount;
    enabledExtensionCount = src->enabledExtensionCount;
    pNext = SafePnextCopy(src->pNext);
    char **tmp_ppEnabledLayerNames = new char *[src->enabledLayerCount];
    for (uint32_t i = 0; i < enabledLayerCount; ++i) {
        tmp_ppEnabledLayerNames[i] = SafeStringCopy(src->ppEnabledLayerNames[i]);
    }
    ppEnabledLayerNames = tmp_ppEnabledLayerNames;
    char **tmp_ppEnabledExtensionNames = new char *[src->enabledExtensionCount];
    for (uint32_t i = 0; i < enabledExtensionCount; ++i) {
        tmp_ppEnabledExtensionNames[i] = SafeStringCopy(src->ppEnabledExtensionNames[i]);
    }
    ppEnabledExtensionNames = tmp_ppEnabledExtensionNames;
    if (src->pApplicationInfo)
        pApplicationInfo = new safe_VkApplicationInfo(*src->pApplicationInfo);
}

safe_VkAllocationCallbacks::safe_VkAllocationCallbacks(const VkAllocationCallbacks* in_struct) :
    pUserData(in_struct->pUserData),
    pfnAllocation(in_struct->pfnAllocation),
    pfnReallocation(in_struct->pfnReallocation),
    pfnFree(in_struct->pfnFree),
    pfnInternalAllocation(in_struct->pfnInternalAllocation),
    pfnInternalFree(in_struct->pfnInternalFree)
{
}

safe_VkAllocationCallbacks::safe_VkAllocationCallbacks() :
    pUserData(nullptr)
{}

safe_VkAllocationCallbacks::safe_VkAllocationCallbacks(const safe_VkAllocationCallbacks& src)
{
    pUserData = src.pUserData;
    pfnAllocation = src.pfnAllocation;
    pfnReallocation = src.pfnReallocation;
    pfnFree = src.pfnFree;
    pfnInternalAllocation = src.pfnInternalAllocation;
    pfnInternalFree = src.pfnInternalFree;
}

safe_VkAllocationCallbacks& safe_VkAllocationCallbacks::operator=(const safe_VkAllocationCallbacks& src)
{
    if (&src == this) return *this;


    pUserData = src.pUserData;
    pfnAllocation = src.pfnAllocation;
    pfnReallocation = src.pfnReallocation;
    pfnFree = src.pfnFree;
    pfnInternalAllocation = src.pfnInternalAllocation;
    pfnInternalFree = src.pfnInternalFree;

    return *this;
}

safe_VkAllocationCallbacks::~safe_VkAllocationCallbacks()
{
}

void safe_VkAllocationCallbacks::initialize(const VkAllocationCallbacks* in_struct)
{
    pUserData = in_struct->pUserData;
    pfnAllocation = in_struct->pfnAllocation;
    pfnReallocation = in_struct->pfnReallocation;
    pfnFree = in_struct->pfnFree;
    pfnInternalAllocation = in_struct->pfnInternalAllocation;
    pfnInternalFree = in_struct->pfnInternalFree;
}

void safe_VkAllocationCallbacks::initialize(const safe_VkAllocationCallbacks* src)
{
    pUserData = src->pUserData;
    pfnAllocation = src->pfnAllocation;
    pfnReallocation = src->pfnReallocation;
    pfnFree = src->pfnFree;
    pfnInternalAllocation = src->pfnInternalAllocation;
    pfnInternalFree = src->pfnInternalFree;
}

safe_VkDeviceQueueCreateInfo::safe_VkDeviceQueueCreateInfo(const VkDeviceQueueCreateInfo* in_struct) :
    sType(in_struct->sType),
    flags(in_struct->flags),
    queueFamilyIndex(in_struct->queueFamilyIndex),
    queueCount(in_struct->queueCount),
    pQueuePriorities(nullptr)
{
    pNext = SafePnextCopy(in_struct->pNext);
    if (in_struct->pQueuePriorities) {
        pQueuePriorities = new float[in_struct->queueCount];
        memcpy ((void *)pQueuePriorities, (void *)in_struct->pQueuePriorities, sizeof(float)*in_struct->queueCount);
    }
}

safe_VkDeviceQueueCreateInfo::safe_VkDeviceQueueCreateInfo() :
    pNext(nullptr),
    pQueuePriorities(nullptr)
{}

safe_VkDeviceQueueCreateInfo::safe_VkDeviceQueueCreateInfo(const safe_VkDeviceQueueCreateInfo& src)
{
    sType = src.sType;
    flags = src.flags;
    queueFamilyIndex = src.queueFamilyIndex;
    queueCount = src.queueCount;
    pQueuePriorities = nullptr;
    pNext = SafePnextCopy(src.pNext);
    if (src.pQueuePriorities) {
        pQueuePriorities = new float[src.queueCount];
        memcpy ((void *)pQueuePriorities, (void *)src.pQueuePriorities, sizeof(float)*src.queueCount);
    }
}

safe_VkDeviceQueueCreateInfo& safe_VkDeviceQueueCreateInfo::operator=(const safe_VkDeviceQueueCreateInfo& src)
{
    if (&src == this) return *this;

    if (pQueuePriorities)
        delete[] pQueuePriorities;
    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    flags = src.flags;
    queueFamilyIndex = src.queueFamilyIndex;
    queueCount = src.queueCount;
    pQueuePriorities = nullptr;
    pNext = SafePnextCopy(src.pNext);
    if (src.pQueuePriorities) {
        pQueuePriorities = new float[src.queueCount];
        memcpy ((void *)pQueuePriorities, (void *)src.pQueuePriorities, sizeof(float)*src.queueCount);
    }

    return *this;
}

safe_VkDeviceQueueCreateInfo::~safe_VkDeviceQueueCreateInfo()
{
    if (pQueuePriorities)
        delete[] pQueuePriorities;
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkDeviceQueueCreateInfo::initialize(const VkDeviceQueueCreateInfo* in_struct)
{
    sType = in_struct->sType;
    flags = in_struct->flags;
    queueFamilyIndex = in_struct->queueFamilyIndex;
    queueCount = in_struct->queueCount;
    pQueuePriorities = nullptr;
    pNext = SafePnextCopy(in_struct->pNext);
    if (in_struct->pQueuePriorities) {
        pQueuePriorities = new float[in_struct->queueCount];
        memcpy ((void *)pQueuePriorities, (void *)in_struct->pQueuePriorities, sizeof(float)*in_struct->queueCount);
    }
}

void safe_VkDeviceQueueCreateInfo::initialize(const safe_VkDeviceQueueCreateInfo* src)
{
    sType = src->sType;
    flags = src->flags;
    queueFamilyIndex = src->queueFamilyIndex;
    queueCount = src->queueCount;
    pQueuePriorities = nullptr;
    pNext = SafePnextCopy(src->pNext);
    if (src->pQueuePriorities) {
        pQueuePriorities = new float[src->queueCount];
        memcpy ((void *)pQueuePriorities, (void *)src->pQueuePriorities, sizeof(float)*src->queueCount);
    }
}

safe_VkDeviceCreateInfo::safe_VkDeviceCreateInfo(const VkDeviceCreateInfo* in_struct) :
    sType(in_struct->sType),
    flags(in_struct->flags),
    queueCreateInfoCount(in_struct->queueCreateInfoCount),
    pQueueCreateInfos(nullptr),
    enabledLayerCount(in_struct->enabledLayerCount),
    enabledExtensionCount(in_struct->enabledExtensionCount),
    pEnabledFeatures(nullptr)
{
    pNext = SafePnextCopy(in_struct->pNext);
    char **tmp_ppEnabledLayerNames = new char *[in_struct->enabledLayerCount];
    for (uint32_t i = 0; i < enabledLayerCount; ++i) {
        tmp_ppEnabledLayerNames[i] = SafeStringCopy(in_struct->ppEnabledLayerNames[i]);
    }
    ppEnabledLayerNames = tmp_ppEnabledLayerNames;
    char **tmp_ppEnabledExtensionNames = new char *[in_struct->enabledExtensionCount];
    for (uint32_t i = 0; i < enabledExtensionCount; ++i) {
        tmp_ppEnabledExtensionNames[i] = SafeStringCopy(in_struct->ppEnabledExtensionNames[i]);
    }
    ppEnabledExtensionNames = tmp_ppEnabledExtensionNames;
    if (queueCreateInfoCount && in_struct->pQueueCreateInfos) {
        pQueueCreateInfos = new safe_VkDeviceQueueCreateInfo[queueCreateInfoCount];
        for (uint32_t i = 0; i < queueCreateInfoCount; ++i) {
            pQueueCreateInfos[i].initialize(&in_struct->pQueueCreateInfos[i]);
        }
    }
    if (in_struct->pEnabledFeatures) {
        pEnabledFeatures = new VkPhysicalDeviceFeatures(*in_struct->pEnabledFeatures);
    }
}

safe_VkDeviceCreateInfo::safe_VkDeviceCreateInfo() :
    pNext(nullptr),
    pQueueCreateInfos(nullptr),
    ppEnabledLayerNames(nullptr),
    ppEnabledExtensionNames(nullptr),
    pEnabledFeatures(nullptr)
{}

safe_VkDeviceCreateInfo::safe_VkDeviceCreateInfo(const safe_VkDeviceCreateInfo& src)
{
    sType = src.sType;
    flags = src.flags;
    queueCreateInfoCount = src.queueCreateInfoCount;
    pQueueCreateInfos = nullptr;
    enabledLayerCount = src.enabledLayerCount;
    enabledExtensionCount = src.enabledExtensionCount;
    pEnabledFeatures = nullptr;
    pNext = SafePnextCopy(src.pNext);
    char **tmp_ppEnabledLayerNames = new char *[src.enabledLayerCount];
    for (uint32_t i = 0; i < enabledLayerCount; ++i) {
        tmp_ppEnabledLayerNames[i] = SafeStringCopy(src.ppEnabledLayerNames[i]);
    }
    ppEnabledLayerNames = tmp_ppEnabledLayerNames;
    char **tmp_ppEnabledExtensionNames = new char *[src.enabledExtensionCount];
    for (uint32_t i = 0; i < enabledExtensionCount; ++i) {
        tmp_ppEnabledExtensionNames[i] = SafeStringCopy(src.ppEnabledExtensionNames[i]);
    }
    ppEnabledExtensionNames = tmp_ppEnabledExtensionNames;
    if (queueCreateInfoCount && src.pQueueCreateInfos) {
        pQueueCreateInfos = new safe_VkDeviceQueueCreateInfo[queueCreateInfoCount];
        for (uint32_t i = 0; i < queueCreateInfoCount; ++i) {
            pQueueCreateInfos[i].initialize(&src.pQueueCreateInfos[i]);
        }
    }
    if (src.pEnabledFeatures) {
        pEnabledFeatures = new VkPhysicalDeviceFeatures(*src.pEnabledFeatures);
    }
}

safe_VkDeviceCreateInfo& safe_VkDeviceCreateInfo::operator=(const safe_VkDeviceCreateInfo& src)
{
    if (&src == this) return *this;

    if (pQueueCreateInfos)
        delete[] pQueueCreateInfos;
    if (ppEnabledLayerNames) {
        for (uint32_t i = 0; i < enabledLayerCount; ++i) {
            delete [] ppEnabledLayerNames[i];
        }
        delete [] ppEnabledLayerNames;
    }
    if (ppEnabledExtensionNames) {
        for (uint32_t i = 0; i < enabledExtensionCount; ++i) {
            delete [] ppEnabledExtensionNames[i];
        }
        delete [] ppEnabledExtensionNames;
    }
    if (pEnabledFeatures)
        delete pEnabledFeatures;
    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    flags = src.flags;
    queueCreateInfoCount = src.queueCreateInfoCount;
    pQueueCreateInfos = nullptr;
    enabledLayerCount = src.enabledLayerCount;
    enabledExtensionCount = src.enabledExtensionCount;
    pEnabledFeatures = nullptr;
    pNext = SafePnextCopy(src.pNext);
    char **tmp_ppEnabledLayerNames = new char *[src.enabledLayerCount];
    for (uint32_t i = 0; i < enabledLayerCount; ++i) {
        tmp_ppEnabledLayerNames[i] = SafeStringCopy(src.ppEnabledLayerNames[i]);
    }
    ppEnabledLayerNames = tmp_ppEnabledLayerNames;
    char **tmp_ppEnabledExtensionNames = new char *[src.enabledExtensionCount];
    for (uint32_t i = 0; i < enabledExtensionCount; ++i) {
        tmp_ppEnabledExtensionNames[i] = SafeStringCopy(src.ppEnabledExtensionNames[i]);
    }
    ppEnabledExtensionNames = tmp_ppEnabledExtensionNames;
    if (queueCreateInfoCount && src.pQueueCreateInfos) {
        pQueueCreateInfos = new safe_VkDeviceQueueCreateInfo[queueCreateInfoCount];
        for (uint32_t i = 0; i < queueCreateInfoCount; ++i) {
            pQueueCreateInfos[i].initialize(&src.pQueueCreateInfos[i]);
        }
    }
    if (src.pEnabledFeatures) {
        pEnabledFeatures = new VkPhysicalDeviceFeatures(*src.pEnabledFeatures);
    }

    return *this;
}

safe_VkDeviceCreateInfo::~safe_VkDeviceCreateInfo()
{
    if (pQueueCreateInfos)
        delete[] pQueueCreateInfos;
    if (ppEnabledLayerNames) {
        for (uint32_t i = 0; i < enabledLayerCount; ++i) {
            delete [] ppEnabledLayerNames[i];
        }
        delete [] ppEnabledLayerNames;
    }
    if (ppEnabledExtensionNames) {
        for (uint32_t i = 0; i < enabledExtensionCount; ++i) {
            delete [] ppEnabledExtensionNames[i];
        }
        delete [] ppEnabledExtensionNames;
    }
    if (pEnabledFeatures)
        delete pEnabledFeatures;
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkDeviceCreateInfo::initialize(const VkDeviceCreateInfo* in_struct)
{
    sType = in_struct->sType;
    flags = in_struct->flags;
    queueCreateInfoCount = in_struct->queueCreateInfoCount;
    pQueueCreateInfos = nullptr;
    enabledLayerCount = in_struct->enabledLayerCount;
    enabledExtensionCount = in_struct->enabledExtensionCount;
    pEnabledFeatures = nullptr;
    pNext = SafePnextCopy(in_struct->pNext);
    char **tmp_ppEnabledLayerNames = new char *[in_struct->enabledLayerCount];
    for (uint32_t i = 0; i < enabledLayerCount; ++i) {
        tmp_ppEnabledLayerNames[i] = SafeStringCopy(in_struct->ppEnabledLayerNames[i]);
    }
    ppEnabledLayerNames = tmp_ppEnabledLayerNames;
    char **tmp_ppEnabledExtensionNames = new char *[in_struct->enabledExtensionCount];
    for (uint32_t i = 0; i < enabledExtensionCount; ++i) {
        tmp_ppEnabledExtensionNames[i] = SafeStringCopy(in_struct->ppEnabledExtensionNames[i]);
    }
    ppEnabledExtensionNames = tmp_ppEnabledExtensionNames;
    if (queueCreateInfoCount && in_struct->pQueueCreateInfos) {
        pQueueCreateInfos = new safe_VkDeviceQueueCreateInfo[queueCreateInfoCount];
        for (uint32_t i = 0; i < queueCreateInfoCount; ++i) {
            pQueueCreateInfos[i].initialize(&in_struct->pQueueCreateInfos[i]);
        }
    }
    if (in_struct->pEnabledFeatures) {
        pEnabledFeatures = new VkPhysicalDeviceFeatures(*in_struct->pEnabledFeatures);
    }
}

void safe_VkDeviceCreateInfo::initialize(const safe_VkDeviceCreateInfo* src)
{
    sType = src->sType;
    flags = src->flags;
    queueCreateInfoCount = src->queueCreateInfoCount;
    pQueueCreateInfos = nullptr;
    enabledLayerCount = src->enabledLayerCount;
    enabledExtensionCount = src->enabledExtensionCount;
    pEnabledFeatures = nullptr;
    pNext = SafePnextCopy(src->pNext);
    char **tmp_ppEnabledLayerNames = new char *[src->enabledLayerCount];
    for (uint32_t i = 0; i < enabledLayerCount; ++i) {
        tmp_ppEnabledLayerNames[i] = SafeStringCopy(src->ppEnabledLayerNames[i]);
    }
    ppEnabledLayerNames = tmp_ppEnabledLayerNames;
    char **tmp_ppEnabledExtensionNames = new char *[src->enabledExtensionCount];
    for (uint32_t i = 0; i < enabledExtensionCount; ++i) {
        tmp_ppEnabledExtensionNames[i] = SafeStringCopy(src->ppEnabledExtensionNames[i]);
    }
    ppEnabledExtensionNames = tmp_ppEnabledExtensionNames;
    if (queueCreateInfoCount && src->pQueueCreateInfos) {
        pQueueCreateInfos = new safe_VkDeviceQueueCreateInfo[queueCreateInfoCount];
        for (uint32_t i = 0; i < queueCreateInfoCount; ++i) {
            pQueueCreateInfos[i].initialize(&src->pQueueCreateInfos[i]);
        }
    }
    if (src->pEnabledFeatures) {
        pEnabledFeatures = new VkPhysicalDeviceFeatures(*src->pEnabledFeatures);
    }
}

safe_VkSubmitInfo::safe_VkSubmitInfo(const VkSubmitInfo* in_struct) :
    sType(in_struct->sType),
    waitSemaphoreCount(in_struct->waitSemaphoreCount),
    pWaitSemaphores(nullptr),
    pWaitDstStageMask(nullptr),
    commandBufferCount(in_struct->commandBufferCount),
    pCommandBuffers(nullptr),
    signalSemaphoreCount(in_struct->signalSemaphoreCount),
    pSignalSemaphores(nullptr)
{
    pNext = SafePnextCopy(in_struct->pNext);
    if (waitSemaphoreCount && in_struct->pWaitSemaphores) {
        pWaitSemaphores = new VkSemaphore[waitSemaphoreCount];
        for (uint32_t i = 0; i < waitSemaphoreCount; ++i) {
            pWaitSemaphores[i] = in_struct->pWaitSemaphores[i];
        }
    }
    if (in_struct->pWaitDstStageMask) {
        pWaitDstStageMask = new VkPipelineStageFlags[in_struct->waitSemaphoreCount];
        memcpy ((void *)pWaitDstStageMask, (void *)in_struct->pWaitDstStageMask, sizeof(VkPipelineStageFlags)*in_struct->waitSemaphoreCount);
    }
    if (in_struct->pCommandBuffers) {
        pCommandBuffers = new VkCommandBuffer[in_struct->commandBufferCount];
        memcpy ((void *)pCommandBuffers, (void *)in_struct->pCommandBuffers, sizeof(VkCommandBuffer)*in_struct->commandBufferCount);
    }
    if (signalSemaphoreCount && in_struct->pSignalSemaphores) {
        pSignalSemaphores = new VkSemaphore[signalSemaphoreCount];
        for (uint32_t i = 0; i < signalSemaphoreCount; ++i) {
            pSignalSemaphores[i] = in_struct->pSignalSemaphores[i];
        }
    }
}

safe_VkSubmitInfo::safe_VkSubmitInfo() :
    pNext(nullptr),
    pWaitSemaphores(nullptr),
    pWaitDstStageMask(nullptr),
    pCommandBuffers(nullptr),
    pSignalSemaphores(nullptr)
{}

safe_VkSubmitInfo::safe_VkSubmitInfo(const safe_VkSubmitInfo& src)
{
    sType = src.sType;
    waitSemaphoreCount = src.waitSemaphoreCount;
    pWaitSemaphores = nullptr;
    pWaitDstStageMask = nullptr;
    commandBufferCount = src.commandBufferCount;
    pCommandBuffers = nullptr;
    signalSemaphoreCount = src.signalSemaphoreCount;
    pSignalSemaphores = nullptr;
    pNext = SafePnextCopy(src.pNext);
    if (waitSemaphoreCount && src.pWaitSemaphores) {
        pWaitSemaphores = new VkSemaphore[waitSemaphoreCount];
        for (uint32_t i = 0; i < waitSemaphoreCount; ++i) {
            pWaitSemaphores[i] = src.pWaitSemaphores[i];
        }
    }
    if (src.pWaitDstStageMask) {
        pWaitDstStageMask = new VkPipelineStageFlags[src.waitSemaphoreCount];
        memcpy ((void *)pWaitDstStageMask, (void *)src.pWaitDstStageMask, sizeof(VkPipelineStageFlags)*src.waitSemaphoreCount);
    }
    if (src.pCommandBuffers) {
        pCommandBuffers = new VkCommandBuffer[src.commandBufferCount];
        memcpy ((void *)pCommandBuffers, (void *)src.pCommandBuffers, sizeof(VkCommandBuffer)*src.commandBufferCount);
    }
    if (signalSemaphoreCount && src.pSignalSemaphores) {
        pSignalSemaphores = new VkSemaphore[signalSemaphoreCount];
        for (uint32_t i = 0; i < signalSemaphoreCount; ++i) {
            pSignalSemaphores[i] = src.pSignalSemaphores[i];
        }
    }
}

safe_VkSubmitInfo& safe_VkSubmitInfo::operator=(const safe_VkSubmitInfo& src)
{
    if (&src == this) return *this;

    if (pWaitSemaphores)
        delete[] pWaitSemaphores;
    if (pWaitDstStageMask)
        delete[] pWaitDstStageMask;
    if (pCommandBuffers)
        delete[] pCommandBuffers;
    if (pSignalSemaphores)
        delete[] pSignalSemaphores;
    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    waitSemaphoreCount = src.waitSemaphoreCount;
    pWaitSemaphores = nullptr;
    pWaitDstStageMask = nullptr;
    commandBufferCount = src.commandBufferCount;
    pCommandBuffers = nullptr;
    signalSemaphoreCount = src.signalSemaphoreCount;
    pSignalSemaphores = nullptr;
    pNext = SafePnextCopy(src.pNext);
    if (waitSemaphoreCount && src.pWaitSemaphores) {
        pWaitSemaphores = new VkSemaphore[waitSemaphoreCount];
        for (uint32_t i = 0; i < waitSemaphoreCount; ++i) {
            pWaitSemaphores[i] = src.pWaitSemaphores[i];
        }
    }
    if (src.pWaitDstStageMask) {
        pWaitDstStageMask = new VkPipelineStageFlags[src.waitSemaphoreCount];
        memcpy ((void *)pWaitDstStageMask, (void *)src.pWaitDstStageMask, sizeof(VkPipelineStageFlags)*src.waitSemaphoreCount);
    }
    if (src.pCommandBuffers) {
        pCommandBuffers = new VkCommandBuffer[src.commandBufferCount];
        memcpy ((void *)pCommandBuffers, (void *)src.pCommandBuffers, sizeof(VkCommandBuffer)*src.commandBufferCount);
    }
    if (signalSemaphoreCount && src.pSignalSemaphores) {
        pSignalSemaphores = new VkSemaphore[signalSemaphoreCount];
        for (uint32_t i = 0; i < signalSemaphoreCount; ++i) {
            pSignalSemaphores[i] = src.pSignalSemaphores[i];
        }
    }

    return *this;
}

safe_VkSubmitInfo::~safe_VkSubmitInfo()
{
    if (pWaitSemaphores)
        delete[] pWaitSemaphores;
    if (pWaitDstStageMask)
        delete[] pWaitDstStageMask;
    if (pCommandBuffers)
        delete[] pCommandBuffers;
    if (pSignalSemaphores)
        delete[] pSignalSemaphores;
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkSubmitInfo::initialize(const VkSubmitInfo* in_struct)
{
    sType = in_struct->sType;
    waitSemaphoreCount = in_struct->waitSemaphoreCount;
    pWaitSemaphores = nullptr;
    pWaitDstStageMask = nullptr;
    commandBufferCount = in_struct->commandBufferCount;
    pCommandBuffers = nullptr;
    signalSemaphoreCount = in_struct->signalSemaphoreCount;
    pSignalSemaphores = nullptr;
    pNext = SafePnextCopy(in_struct->pNext);
    if (waitSemaphoreCount && in_struct->pWaitSemaphores) {
        pWaitSemaphores = new VkSemaphore[waitSemaphoreCount];
        for (uint32_t i = 0; i < waitSemaphoreCount; ++i) {
            pWaitSemaphores[i] = in_struct->pWaitSemaphores[i];
        }
    }
    if (in_struct->pWaitDstStageMask) {
        pWaitDstStageMask = new VkPipelineStageFlags[in_struct->waitSemaphoreCount];
        memcpy ((void *)pWaitDstStageMask, (void *)in_struct->pWaitDstStageMask, sizeof(VkPipelineStageFlags)*in_struct->waitSemaphoreCount);
    }
    if (in_struct->pCommandBuffers) {
        pCommandBuffers = new VkCommandBuffer[in_struct->commandBufferCount];
        memcpy ((void *)pCommandBuffers, (void *)in_struct->pCommandBuffers, sizeof(VkCommandBuffer)*in_struct->commandBufferCount);
    }
    if (signalSemaphoreCount && in_struct->pSignalSemaphores) {
        pSignalSemaphores = new VkSemaphore[signalSemaphoreCount];
        for (uint32_t i = 0; i < signalSemaphoreCount; ++i) {
            pSignalSemaphores[i] = in_struct->pSignalSemaphores[i];
        }
    }
}

void safe_VkSubmitInfo::initialize(const safe_VkSubmitInfo* src)
{
    sType = src->sType;
    waitSemaphoreCount = src->waitSemaphoreCount;
    pWaitSemaphores = nullptr;
    pWaitDstStageMask = nullptr;
    commandBufferCount = src->commandBufferCount;
    pCommandBuffers = nullptr;
    signalSemaphoreCount = src->signalSemaphoreCount;
    pSignalSemaphores = nullptr;
    pNext = SafePnextCopy(src->pNext);
    if (waitSemaphoreCount && src->pWaitSemaphores) {
        pWaitSemaphores = new VkSemaphore[waitSemaphoreCount];
        for (uint32_t i = 0; i < waitSemaphoreCount; ++i) {
            pWaitSemaphores[i] = src->pWaitSemaphores[i];
        }
    }
    if (src->pWaitDstStageMask) {
        pWaitDstStageMask = new VkPipelineStageFlags[src->waitSemaphoreCount];
        memcpy ((void *)pWaitDstStageMask, (void *)src->pWaitDstStageMask, sizeof(VkPipelineStageFlags)*src->waitSemaphoreCount);
    }
    if (src->pCommandBuffers) {
        pCommandBuffers = new VkCommandBuffer[src->commandBufferCount];
        memcpy ((void *)pCommandBuffers, (void *)src->pCommandBuffers, sizeof(VkCommandBuffer)*src->commandBufferCount);
    }
    if (signalSemaphoreCount && src->pSignalSemaphores) {
        pSignalSemaphores = new VkSemaphore[signalSemaphoreCount];
        for (uint32_t i = 0; i < signalSemaphoreCount; ++i) {
            pSignalSemaphores[i] = src->pSignalSemaphores[i];
        }
    }
}

safe_VkMemoryAllocateInfo::safe_VkMemoryAllocateInfo(const VkMemoryAllocateInfo* in_struct) :
    sType(in_struct->sType),
    allocationSize(in_struct->allocationSize),
    memoryTypeIndex(in_struct->memoryTypeIndex)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkMemoryAllocateInfo::safe_VkMemoryAllocateInfo() :
    pNext(nullptr)
{}

safe_VkMemoryAllocateInfo::safe_VkMemoryAllocateInfo(const safe_VkMemoryAllocateInfo& src)
{
    sType = src.sType;
    allocationSize = src.allocationSize;
    memoryTypeIndex = src.memoryTypeIndex;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkMemoryAllocateInfo& safe_VkMemoryAllocateInfo::operator=(const safe_VkMemoryAllocateInfo& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    allocationSize = src.allocationSize;
    memoryTypeIndex = src.memoryTypeIndex;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkMemoryAllocateInfo::~safe_VkMemoryAllocateInfo()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkMemoryAllocateInfo::initialize(const VkMemoryAllocateInfo* in_struct)
{
    sType = in_struct->sType;
    allocationSize = in_struct->allocationSize;
    memoryTypeIndex = in_struct->memoryTypeIndex;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkMemoryAllocateInfo::initialize(const safe_VkMemoryAllocateInfo* src)
{
    sType = src->sType;
    allocationSize = src->allocationSize;
    memoryTypeIndex = src->memoryTypeIndex;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkMappedMemoryRange::safe_VkMappedMemoryRange(const VkMappedMemoryRange* in_struct) :
    sType(in_struct->sType),
    memory(in_struct->memory),
    offset(in_struct->offset),
    size(in_struct->size)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkMappedMemoryRange::safe_VkMappedMemoryRange() :
    pNext(nullptr)
{}

safe_VkMappedMemoryRange::safe_VkMappedMemoryRange(const safe_VkMappedMemoryRange& src)
{
    sType = src.sType;
    memory = src.memory;
    offset = src.offset;
    size = src.size;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkMappedMemoryRange& safe_VkMappedMemoryRange::operator=(const safe_VkMappedMemoryRange& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    memory = src.memory;
    offset = src.offset;
    size = src.size;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkMappedMemoryRange::~safe_VkMappedMemoryRange()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkMappedMemoryRange::initialize(const VkMappedMemoryRange* in_struct)
{
    sType = in_struct->sType;
    memory = in_struct->memory;
    offset = in_struct->offset;
    size = in_struct->size;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkMappedMemoryRange::initialize(const safe_VkMappedMemoryRange* src)
{
    sType = src->sType;
    memory = src->memory;
    offset = src->offset;
    size = src->size;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkSparseBufferMemoryBindInfo::safe_VkSparseBufferMemoryBindInfo(const VkSparseBufferMemoryBindInfo* in_struct) :
    buffer(in_struct->buffer),
    bindCount(in_struct->bindCount),
    pBinds(nullptr)
{
    if (bindCount && in_struct->pBinds) {
        pBinds = new VkSparseMemoryBind[bindCount];
        for (uint32_t i = 0; i < bindCount; ++i) {
            pBinds[i] = in_struct->pBinds[i];
        }
    }
}

safe_VkSparseBufferMemoryBindInfo::safe_VkSparseBufferMemoryBindInfo() :
    pBinds(nullptr)
{}

safe_VkSparseBufferMemoryBindInfo::safe_VkSparseBufferMemoryBindInfo(const safe_VkSparseBufferMemoryBindInfo& src)
{
    buffer = src.buffer;
    bindCount = src.bindCount;
    pBinds = nullptr;
    if (bindCount && src.pBinds) {
        pBinds = new VkSparseMemoryBind[bindCount];
        for (uint32_t i = 0; i < bindCount; ++i) {
            pBinds[i] = src.pBinds[i];
        }
    }
}

safe_VkSparseBufferMemoryBindInfo& safe_VkSparseBufferMemoryBindInfo::operator=(const safe_VkSparseBufferMemoryBindInfo& src)
{
    if (&src == this) return *this;

    if (pBinds)
        delete[] pBinds;

    buffer = src.buffer;
    bindCount = src.bindCount;
    pBinds = nullptr;
    if (bindCount && src.pBinds) {
        pBinds = new VkSparseMemoryBind[bindCount];
        for (uint32_t i = 0; i < bindCount; ++i) {
            pBinds[i] = src.pBinds[i];
        }
    }

    return *this;
}

safe_VkSparseBufferMemoryBindInfo::~safe_VkSparseBufferMemoryBindInfo()
{
    if (pBinds)
        delete[] pBinds;
}

void safe_VkSparseBufferMemoryBindInfo::initialize(const VkSparseBufferMemoryBindInfo* in_struct)
{
    buffer = in_struct->buffer;
    bindCount = in_struct->bindCount;
    pBinds = nullptr;
    if (bindCount && in_struct->pBinds) {
        pBinds = new VkSparseMemoryBind[bindCount];
        for (uint32_t i = 0; i < bindCount; ++i) {
            pBinds[i] = in_struct->pBinds[i];
        }
    }
}

void safe_VkSparseBufferMemoryBindInfo::initialize(const safe_VkSparseBufferMemoryBindInfo* src)
{
    buffer = src->buffer;
    bindCount = src->bindCount;
    pBinds = nullptr;
    if (bindCount && src->pBinds) {
        pBinds = new VkSparseMemoryBind[bindCount];
        for (uint32_t i = 0; i < bindCount; ++i) {
            pBinds[i] = src->pBinds[i];
        }
    }
}

safe_VkSparseImageOpaqueMemoryBindInfo::safe_VkSparseImageOpaqueMemoryBindInfo(const VkSparseImageOpaqueMemoryBindInfo* in_struct) :
    image(in_struct->image),
    bindCount(in_struct->bindCount),
    pBinds(nullptr)
{
    if (bindCount && in_struct->pBinds) {
        pBinds = new VkSparseMemoryBind[bindCount];
        for (uint32_t i = 0; i < bindCount; ++i) {
            pBinds[i] = in_struct->pBinds[i];
        }
    }
}

safe_VkSparseImageOpaqueMemoryBindInfo::safe_VkSparseImageOpaqueMemoryBindInfo() :
    pBinds(nullptr)
{}

safe_VkSparseImageOpaqueMemoryBindInfo::safe_VkSparseImageOpaqueMemoryBindInfo(const safe_VkSparseImageOpaqueMemoryBindInfo& src)
{
    image = src.image;
    bindCount = src.bindCount;
    pBinds = nullptr;
    if (bindCount && src.pBinds) {
        pBinds = new VkSparseMemoryBind[bindCount];
        for (uint32_t i = 0; i < bindCount; ++i) {
            pBinds[i] = src.pBinds[i];
        }
    }
}

safe_VkSparseImageOpaqueMemoryBindInfo& safe_VkSparseImageOpaqueMemoryBindInfo::operator=(const safe_VkSparseImageOpaqueMemoryBindInfo& src)
{
    if (&src == this) return *this;

    if (pBinds)
        delete[] pBinds;

    image = src.image;
    bindCount = src.bindCount;
    pBinds = nullptr;
    if (bindCount && src.pBinds) {
        pBinds = new VkSparseMemoryBind[bindCount];
        for (uint32_t i = 0; i < bindCount; ++i) {
            pBinds[i] = src.pBinds[i];
        }
    }

    return *this;
}

safe_VkSparseImageOpaqueMemoryBindInfo::~safe_VkSparseImageOpaqueMemoryBindInfo()
{
    if (pBinds)
        delete[] pBinds;
}

void safe_VkSparseImageOpaqueMemoryBindInfo::initialize(const VkSparseImageOpaqueMemoryBindInfo* in_struct)
{
    image = in_struct->image;
    bindCount = in_struct->bindCount;
    pBinds = nullptr;
    if (bindCount && in_struct->pBinds) {
        pBinds = new VkSparseMemoryBind[bindCount];
        for (uint32_t i = 0; i < bindCount; ++i) {
            pBinds[i] = in_struct->pBinds[i];
        }
    }
}

void safe_VkSparseImageOpaqueMemoryBindInfo::initialize(const safe_VkSparseImageOpaqueMemoryBindInfo* src)
{
    image = src->image;
    bindCount = src->bindCount;
    pBinds = nullptr;
    if (bindCount && src->pBinds) {
        pBinds = new VkSparseMemoryBind[bindCount];
        for (uint32_t i = 0; i < bindCount; ++i) {
            pBinds[i] = src->pBinds[i];
        }
    }
}

safe_VkSparseImageMemoryBindInfo::safe_VkSparseImageMemoryBindInfo(const VkSparseImageMemoryBindInfo* in_struct) :
    image(in_struct->image),
    bindCount(in_struct->bindCount),
    pBinds(nullptr)
{
    if (bindCount && in_struct->pBinds) {
        pBinds = new VkSparseImageMemoryBind[bindCount];
        for (uint32_t i = 0; i < bindCount; ++i) {
            pBinds[i] = in_struct->pBinds[i];
        }
    }
}

safe_VkSparseImageMemoryBindInfo::safe_VkSparseImageMemoryBindInfo() :
    pBinds(nullptr)
{}

safe_VkSparseImageMemoryBindInfo::safe_VkSparseImageMemoryBindInfo(const safe_VkSparseImageMemoryBindInfo& src)
{
    image = src.image;
    bindCount = src.bindCount;
    pBinds = nullptr;
    if (bindCount && src.pBinds) {
        pBinds = new VkSparseImageMemoryBind[bindCount];
        for (uint32_t i = 0; i < bindCount; ++i) {
            pBinds[i] = src.pBinds[i];
        }
    }
}

safe_VkSparseImageMemoryBindInfo& safe_VkSparseImageMemoryBindInfo::operator=(const safe_VkSparseImageMemoryBindInfo& src)
{
    if (&src == this) return *this;

    if (pBinds)
        delete[] pBinds;

    image = src.image;
    bindCount = src.bindCount;
    pBinds = nullptr;
    if (bindCount && src.pBinds) {
        pBinds = new VkSparseImageMemoryBind[bindCount];
        for (uint32_t i = 0; i < bindCount; ++i) {
            pBinds[i] = src.pBinds[i];
        }
    }

    return *this;
}

safe_VkSparseImageMemoryBindInfo::~safe_VkSparseImageMemoryBindInfo()
{
    if (pBinds)
        delete[] pBinds;
}

void safe_VkSparseImageMemoryBindInfo::initialize(const VkSparseImageMemoryBindInfo* in_struct)
{
    image = in_struct->image;
    bindCount = in_struct->bindCount;
    pBinds = nullptr;
    if (bindCount && in_struct->pBinds) {
        pBinds = new VkSparseImageMemoryBind[bindCount];
        for (uint32_t i = 0; i < bindCount; ++i) {
            pBinds[i] = in_struct->pBinds[i];
        }
    }
}

void safe_VkSparseImageMemoryBindInfo::initialize(const safe_VkSparseImageMemoryBindInfo* src)
{
    image = src->image;
    bindCount = src->bindCount;
    pBinds = nullptr;
    if (bindCount && src->pBinds) {
        pBinds = new VkSparseImageMemoryBind[bindCount];
        for (uint32_t i = 0; i < bindCount; ++i) {
            pBinds[i] = src->pBinds[i];
        }
    }
}

safe_VkBindSparseInfo::safe_VkBindSparseInfo(const VkBindSparseInfo* in_struct) :
    sType(in_struct->sType),
    waitSemaphoreCount(in_struct->waitSemaphoreCount),
    pWaitSemaphores(nullptr),
    bufferBindCount(in_struct->bufferBindCount),
    pBufferBinds(nullptr),
    imageOpaqueBindCount(in_struct->imageOpaqueBindCount),
    pImageOpaqueBinds(nullptr),
    imageBindCount(in_struct->imageBindCount),
    pImageBinds(nullptr),
    signalSemaphoreCount(in_struct->signalSemaphoreCount),
    pSignalSemaphores(nullptr)
{
    pNext = SafePnextCopy(in_struct->pNext);
    if (waitSemaphoreCount && in_struct->pWaitSemaphores) {
        pWaitSemaphores = new VkSemaphore[waitSemaphoreCount];
        for (uint32_t i = 0; i < waitSemaphoreCount; ++i) {
            pWaitSemaphores[i] = in_struct->pWaitSemaphores[i];
        }
    }
    if (bufferBindCount && in_struct->pBufferBinds) {
        pBufferBinds = new safe_VkSparseBufferMemoryBindInfo[bufferBindCount];
        for (uint32_t i = 0; i < bufferBindCount; ++i) {
            pBufferBinds[i].initialize(&in_struct->pBufferBinds[i]);
        }
    }
    if (imageOpaqueBindCount && in_struct->pImageOpaqueBinds) {
        pImageOpaqueBinds = new safe_VkSparseImageOpaqueMemoryBindInfo[imageOpaqueBindCount];
        for (uint32_t i = 0; i < imageOpaqueBindCount; ++i) {
            pImageOpaqueBinds[i].initialize(&in_struct->pImageOpaqueBinds[i]);
        }
    }
    if (imageBindCount && in_struct->pImageBinds) {
        pImageBinds = new safe_VkSparseImageMemoryBindInfo[imageBindCount];
        for (uint32_t i = 0; i < imageBindCount; ++i) {
            pImageBinds[i].initialize(&in_struct->pImageBinds[i]);
        }
    }
    if (signalSemaphoreCount && in_struct->pSignalSemaphores) {
        pSignalSemaphores = new VkSemaphore[signalSemaphoreCount];
        for (uint32_t i = 0; i < signalSemaphoreCount; ++i) {
            pSignalSemaphores[i] = in_struct->pSignalSemaphores[i];
        }
    }
}

safe_VkBindSparseInfo::safe_VkBindSparseInfo() :
    pNext(nullptr),
    pWaitSemaphores(nullptr),
    pBufferBinds(nullptr),
    pImageOpaqueBinds(nullptr),
    pImageBinds(nullptr),
    pSignalSemaphores(nullptr)
{}

safe_VkBindSparseInfo::safe_VkBindSparseInfo(const safe_VkBindSparseInfo& src)
{
    sType = src.sType;
    waitSemaphoreCount = src.waitSemaphoreCount;
    pWaitSemaphores = nullptr;
    bufferBindCount = src.bufferBindCount;
    pBufferBinds = nullptr;
    imageOpaqueBindCount = src.imageOpaqueBindCount;
    pImageOpaqueBinds = nullptr;
    imageBindCount = src.imageBindCount;
    pImageBinds = nullptr;
    signalSemaphoreCount = src.signalSemaphoreCount;
    pSignalSemaphores = nullptr;
    pNext = SafePnextCopy(src.pNext);
    if (waitSemaphoreCount && src.pWaitSemaphores) {
        pWaitSemaphores = new VkSemaphore[waitSemaphoreCount];
        for (uint32_t i = 0; i < waitSemaphoreCount; ++i) {
            pWaitSemaphores[i] = src.pWaitSemaphores[i];
        }
    }
    if (bufferBindCount && src.pBufferBinds) {
        pBufferBinds = new safe_VkSparseBufferMemoryBindInfo[bufferBindCount];
        for (uint32_t i = 0; i < bufferBindCount; ++i) {
            pBufferBinds[i].initialize(&src.pBufferBinds[i]);
        }
    }
    if (imageOpaqueBindCount && src.pImageOpaqueBinds) {
        pImageOpaqueBinds = new safe_VkSparseImageOpaqueMemoryBindInfo[imageOpaqueBindCount];
        for (uint32_t i = 0; i < imageOpaqueBindCount; ++i) {
            pImageOpaqueBinds[i].initialize(&src.pImageOpaqueBinds[i]);
        }
    }
    if (imageBindCount && src.pImageBinds) {
        pImageBinds = new safe_VkSparseImageMemoryBindInfo[imageBindCount];
        for (uint32_t i = 0; i < imageBindCount; ++i) {
            pImageBinds[i].initialize(&src.pImageBinds[i]);
        }
    }
    if (signalSemaphoreCount && src.pSignalSemaphores) {
        pSignalSemaphores = new VkSemaphore[signalSemaphoreCount];
        for (uint32_t i = 0; i < signalSemaphoreCount; ++i) {
            pSignalSemaphores[i] = src.pSignalSemaphores[i];
        }
    }
}

safe_VkBindSparseInfo& safe_VkBindSparseInfo::operator=(const safe_VkBindSparseInfo& src)
{
    if (&src == this) return *this;

    if (pWaitSemaphores)
        delete[] pWaitSemaphores;
    if (pBufferBinds)
        delete[] pBufferBinds;
    if (pImageOpaqueBinds)
        delete[] pImageOpaqueBinds;
    if (pImageBinds)
        delete[] pImageBinds;
    if (pSignalSemaphores)
        delete[] pSignalSemaphores;
    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    waitSemaphoreCount = src.waitSemaphoreCount;
    pWaitSemaphores = nullptr;
    bufferBindCount = src.bufferBindCount;
    pBufferBinds = nullptr;
    imageOpaqueBindCount = src.imageOpaqueBindCount;
    pImageOpaqueBinds = nullptr;
    imageBindCount = src.imageBindCount;
    pImageBinds = nullptr;
    signalSemaphoreCount = src.signalSemaphoreCount;
    pSignalSemaphores = nullptr;
    pNext = SafePnextCopy(src.pNext);
    if (waitSemaphoreCount && src.pWaitSemaphores) {
        pWaitSemaphores = new VkSemaphore[waitSemaphoreCount];
        for (uint32_t i = 0; i < waitSemaphoreCount; ++i) {
            pWaitSemaphores[i] = src.pWaitSemaphores[i];
        }
    }
    if (bufferBindCount && src.pBufferBinds) {
        pBufferBinds = new safe_VkSparseBufferMemoryBindInfo[bufferBindCount];
        for (uint32_t i = 0; i < bufferBindCount; ++i) {
            pBufferBinds[i].initialize(&src.pBufferBinds[i]);
        }
    }
    if (imageOpaqueBindCount && src.pImageOpaqueBinds) {
        pImageOpaqueBinds = new safe_VkSparseImageOpaqueMemoryBindInfo[imageOpaqueBindCount];
        for (uint32_t i = 0; i < imageOpaqueBindCount; ++i) {
            pImageOpaqueBinds[i].initialize(&src.pImageOpaqueBinds[i]);
        }
    }
    if (imageBindCount && src.pImageBinds) {
        pImageBinds = new safe_VkSparseImageMemoryBindInfo[imageBindCount];
        for (uint32_t i = 0; i < imageBindCount; ++i) {
            pImageBinds[i].initialize(&src.pImageBinds[i]);
        }
    }
    if (signalSemaphoreCount && src.pSignalSemaphores) {
        pSignalSemaphores = new VkSemaphore[signalSemaphoreCount];
        for (uint32_t i = 0; i < signalSemaphoreCount; ++i) {
            pSignalSemaphores[i] = src.pSignalSemaphores[i];
        }
    }

    return *this;
}

safe_VkBindSparseInfo::~safe_VkBindSparseInfo()
{
    if (pWaitSemaphores)
        delete[] pWaitSemaphores;
    if (pBufferBinds)
        delete[] pBufferBinds;
    if (pImageOpaqueBinds)
        delete[] pImageOpaqueBinds;
    if (pImageBinds)
        delete[] pImageBinds;
    if (pSignalSemaphores)
        delete[] pSignalSemaphores;
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkBindSparseInfo::initialize(const VkBindSparseInfo* in_struct)
{
    sType = in_struct->sType;
    waitSemaphoreCount = in_struct->waitSemaphoreCount;
    pWaitSemaphores = nullptr;
    bufferBindCount = in_struct->bufferBindCount;
    pBufferBinds = nullptr;
    imageOpaqueBindCount = in_struct->imageOpaqueBindCount;
    pImageOpaqueBinds = nullptr;
    imageBindCount = in_struct->imageBindCount;
    pImageBinds = nullptr;
    signalSemaphoreCount = in_struct->signalSemaphoreCount;
    pSignalSemaphores = nullptr;
    pNext = SafePnextCopy(in_struct->pNext);
    if (waitSemaphoreCount && in_struct->pWaitSemaphores) {
        pWaitSemaphores = new VkSemaphore[waitSemaphoreCount];
        for (uint32_t i = 0; i < waitSemaphoreCount; ++i) {
            pWaitSemaphores[i] = in_struct->pWaitSemaphores[i];
        }
    }
    if (bufferBindCount && in_struct->pBufferBinds) {
        pBufferBinds = new safe_VkSparseBufferMemoryBindInfo[bufferBindCount];
        for (uint32_t i = 0; i < bufferBindCount; ++i) {
            pBufferBinds[i].initialize(&in_struct->pBufferBinds[i]);
        }
    }
    if (imageOpaqueBindCount && in_struct->pImageOpaqueBinds) {
        pImageOpaqueBinds = new safe_VkSparseImageOpaqueMemoryBindInfo[imageOpaqueBindCount];
        for (uint32_t i = 0; i < imageOpaqueBindCount; ++i) {
            pImageOpaqueBinds[i].initialize(&in_struct->pImageOpaqueBinds[i]);
        }
    }
    if (imageBindCount && in_struct->pImageBinds) {
        pImageBinds = new safe_VkSparseImageMemoryBindInfo[imageBindCount];
        for (uint32_t i = 0; i < imageBindCount; ++i) {
            pImageBinds[i].initialize(&in_struct->pImageBinds[i]);
        }
    }
    if (signalSemaphoreCount && in_struct->pSignalSemaphores) {
        pSignalSemaphores = new VkSemaphore[signalSemaphoreCount];
        for (uint32_t i = 0; i < signalSemaphoreCount; ++i) {
            pSignalSemaphores[i] = in_struct->pSignalSemaphores[i];
        }
    }
}

void safe_VkBindSparseInfo::initialize(const safe_VkBindSparseInfo* src)
{
    sType = src->sType;
    waitSemaphoreCount = src->waitSemaphoreCount;
    pWaitSemaphores = nullptr;
    bufferBindCount = src->bufferBindCount;
    pBufferBinds = nullptr;
    imageOpaqueBindCount = src->imageOpaqueBindCount;
    pImageOpaqueBinds = nullptr;
    imageBindCount = src->imageBindCount;
    pImageBinds = nullptr;
    signalSemaphoreCount = src->signalSemaphoreCount;
    pSignalSemaphores = nullptr;
    pNext = SafePnextCopy(src->pNext);
    if (waitSemaphoreCount && src->pWaitSemaphores) {
        pWaitSemaphores = new VkSemaphore[waitSemaphoreCount];
        for (uint32_t i = 0; i < waitSemaphoreCount; ++i) {
            pWaitSemaphores[i] = src->pWaitSemaphores[i];
        }
    }
    if (bufferBindCount && src->pBufferBinds) {
        pBufferBinds = new safe_VkSparseBufferMemoryBindInfo[bufferBindCount];
        for (uint32_t i = 0; i < bufferBindCount; ++i) {
            pBufferBinds[i].initialize(&src->pBufferBinds[i]);
        }
    }
    if (imageOpaqueBindCount && src->pImageOpaqueBinds) {
        pImageOpaqueBinds = new safe_VkSparseImageOpaqueMemoryBindInfo[imageOpaqueBindCount];
        for (uint32_t i = 0; i < imageOpaqueBindCount; ++i) {
            pImageOpaqueBinds[i].initialize(&src->pImageOpaqueBinds[i]);
        }
    }
    if (imageBindCount && src->pImageBinds) {
        pImageBinds = new safe_VkSparseImageMemoryBindInfo[imageBindCount];
        for (uint32_t i = 0; i < imageBindCount; ++i) {
            pImageBinds[i].initialize(&src->pImageBinds[i]);
        }
    }
    if (signalSemaphoreCount && src->pSignalSemaphores) {
        pSignalSemaphores = new VkSemaphore[signalSemaphoreCount];
        for (uint32_t i = 0; i < signalSemaphoreCount; ++i) {
            pSignalSemaphores[i] = src->pSignalSemaphores[i];
        }
    }
}

safe_VkFenceCreateInfo::safe_VkFenceCreateInfo(const VkFenceCreateInfo* in_struct) :
    sType(in_struct->sType),
    flags(in_struct->flags)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkFenceCreateInfo::safe_VkFenceCreateInfo() :
    pNext(nullptr)
{}

safe_VkFenceCreateInfo::safe_VkFenceCreateInfo(const safe_VkFenceCreateInfo& src)
{
    sType = src.sType;
    flags = src.flags;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkFenceCreateInfo& safe_VkFenceCreateInfo::operator=(const safe_VkFenceCreateInfo& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    flags = src.flags;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkFenceCreateInfo::~safe_VkFenceCreateInfo()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkFenceCreateInfo::initialize(const VkFenceCreateInfo* in_struct)
{
    sType = in_struct->sType;
    flags = in_struct->flags;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkFenceCreateInfo::initialize(const safe_VkFenceCreateInfo* src)
{
    sType = src->sType;
    flags = src->flags;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkSemaphoreCreateInfo::safe_VkSemaphoreCreateInfo(const VkSemaphoreCreateInfo* in_struct) :
    sType(in_struct->sType),
    flags(in_struct->flags)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkSemaphoreCreateInfo::safe_VkSemaphoreCreateInfo() :
    pNext(nullptr)
{}

safe_VkSemaphoreCreateInfo::safe_VkSemaphoreCreateInfo(const safe_VkSemaphoreCreateInfo& src)
{
    sType = src.sType;
    flags = src.flags;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkSemaphoreCreateInfo& safe_VkSemaphoreCreateInfo::operator=(const safe_VkSemaphoreCreateInfo& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    flags = src.flags;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkSemaphoreCreateInfo::~safe_VkSemaphoreCreateInfo()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkSemaphoreCreateInfo::initialize(const VkSemaphoreCreateInfo* in_struct)
{
    sType = in_struct->sType;
    flags = in_struct->flags;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkSemaphoreCreateInfo::initialize(const safe_VkSemaphoreCreateInfo* src)
{
    sType = src->sType;
    flags = src->flags;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkEventCreateInfo::safe_VkEventCreateInfo(const VkEventCreateInfo* in_struct) :
    sType(in_struct->sType),
    flags(in_struct->flags)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkEventCreateInfo::safe_VkEventCreateInfo() :
    pNext(nullptr)
{}

safe_VkEventCreateInfo::safe_VkEventCreateInfo(const safe_VkEventCreateInfo& src)
{
    sType = src.sType;
    flags = src.flags;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkEventCreateInfo& safe_VkEventCreateInfo::operator=(const safe_VkEventCreateInfo& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    flags = src.flags;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkEventCreateInfo::~safe_VkEventCreateInfo()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkEventCreateInfo::initialize(const VkEventCreateInfo* in_struct)
{
    sType = in_struct->sType;
    flags = in_struct->flags;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkEventCreateInfo::initialize(const safe_VkEventCreateInfo* src)
{
    sType = src->sType;
    flags = src->flags;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkQueryPoolCreateInfo::safe_VkQueryPoolCreateInfo(const VkQueryPoolCreateInfo* in_struct) :
    sType(in_struct->sType),
    flags(in_struct->flags),
    queryType(in_struct->queryType),
    queryCount(in_struct->queryCount),
    pipelineStatistics(in_struct->pipelineStatistics)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkQueryPoolCreateInfo::safe_VkQueryPoolCreateInfo() :
    pNext(nullptr)
{}

safe_VkQueryPoolCreateInfo::safe_VkQueryPoolCreateInfo(const safe_VkQueryPoolCreateInfo& src)
{
    sType = src.sType;
    flags = src.flags;
    queryType = src.queryType;
    queryCount = src.queryCount;
    pipelineStatistics = src.pipelineStatistics;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkQueryPoolCreateInfo& safe_VkQueryPoolCreateInfo::operator=(const safe_VkQueryPoolCreateInfo& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    flags = src.flags;
    queryType = src.queryType;
    queryCount = src.queryCount;
    pipelineStatistics = src.pipelineStatistics;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkQueryPoolCreateInfo::~safe_VkQueryPoolCreateInfo()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkQueryPoolCreateInfo::initialize(const VkQueryPoolCreateInfo* in_struct)
{
    sType = in_struct->sType;
    flags = in_struct->flags;
    queryType = in_struct->queryType;
    queryCount = in_struct->queryCount;
    pipelineStatistics = in_struct->pipelineStatistics;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkQueryPoolCreateInfo::initialize(const safe_VkQueryPoolCreateInfo* src)
{
    sType = src->sType;
    flags = src->flags;
    queryType = src->queryType;
    queryCount = src->queryCount;
    pipelineStatistics = src->pipelineStatistics;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkBufferCreateInfo::safe_VkBufferCreateInfo(const VkBufferCreateInfo* in_struct) :
    sType(in_struct->sType),
    flags(in_struct->flags),
    size(in_struct->size),
    usage(in_struct->usage),
    sharingMode(in_struct->sharingMode),
    queueFamilyIndexCount(in_struct->queueFamilyIndexCount),
    pQueueFamilyIndices(nullptr)
{
    pNext = SafePnextCopy(in_struct->pNext);
    if (in_struct->pQueueFamilyIndices) {
        pQueueFamilyIndices = new uint32_t[in_struct->queueFamilyIndexCount];
        memcpy ((void *)pQueueFamilyIndices, (void *)in_struct->pQueueFamilyIndices, sizeof(uint32_t)*in_struct->queueFamilyIndexCount);
    }
}

safe_VkBufferCreateInfo::safe_VkBufferCreateInfo() :
    pNext(nullptr),
    pQueueFamilyIndices(nullptr)
{}

safe_VkBufferCreateInfo::safe_VkBufferCreateInfo(const safe_VkBufferCreateInfo& src)
{
    sType = src.sType;
    flags = src.flags;
    size = src.size;
    usage = src.usage;
    sharingMode = src.sharingMode;
    queueFamilyIndexCount = src.queueFamilyIndexCount;
    pQueueFamilyIndices = nullptr;
    pNext = SafePnextCopy(src.pNext);
    if (src.pQueueFamilyIndices) {
        pQueueFamilyIndices = new uint32_t[src.queueFamilyIndexCount];
        memcpy ((void *)pQueueFamilyIndices, (void *)src.pQueueFamilyIndices, sizeof(uint32_t)*src.queueFamilyIndexCount);
    }
}

safe_VkBufferCreateInfo& safe_VkBufferCreateInfo::operator=(const safe_VkBufferCreateInfo& src)
{
    if (&src == this) return *this;

    if (pQueueFamilyIndices)
        delete[] pQueueFamilyIndices;
    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    flags = src.flags;
    size = src.size;
    usage = src.usage;
    sharingMode = src.sharingMode;
    queueFamilyIndexCount = src.queueFamilyIndexCount;
    pQueueFamilyIndices = nullptr;
    pNext = SafePnextCopy(src.pNext);
    if (src.pQueueFamilyIndices) {
        pQueueFamilyIndices = new uint32_t[src.queueFamilyIndexCount];
        memcpy ((void *)pQueueFamilyIndices, (void *)src.pQueueFamilyIndices, sizeof(uint32_t)*src.queueFamilyIndexCount);
    }

    return *this;
}

safe_VkBufferCreateInfo::~safe_VkBufferCreateInfo()
{
    if (pQueueFamilyIndices)
        delete[] pQueueFamilyIndices;
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkBufferCreateInfo::initialize(const VkBufferCreateInfo* in_struct)
{
    sType = in_struct->sType;
    flags = in_struct->flags;
    size = in_struct->size;
    usage = in_struct->usage;
    sharingMode = in_struct->sharingMode;
    queueFamilyIndexCount = in_struct->queueFamilyIndexCount;
    pQueueFamilyIndices = nullptr;
    pNext = SafePnextCopy(in_struct->pNext);
    if (in_struct->pQueueFamilyIndices) {
        pQueueFamilyIndices = new uint32_t[in_struct->queueFamilyIndexCount];
        memcpy ((void *)pQueueFamilyIndices, (void *)in_struct->pQueueFamilyIndices, sizeof(uint32_t)*in_struct->queueFamilyIndexCount);
    }
}

void safe_VkBufferCreateInfo::initialize(const safe_VkBufferCreateInfo* src)
{
    sType = src->sType;
    flags = src->flags;
    size = src->size;
    usage = src->usage;
    sharingMode = src->sharingMode;
    queueFamilyIndexCount = src->queueFamilyIndexCount;
    pQueueFamilyIndices = nullptr;
    pNext = SafePnextCopy(src->pNext);
    if (src->pQueueFamilyIndices) {
        pQueueFamilyIndices = new uint32_t[src->queueFamilyIndexCount];
        memcpy ((void *)pQueueFamilyIndices, (void *)src->pQueueFamilyIndices, sizeof(uint32_t)*src->queueFamilyIndexCount);
    }
}

safe_VkBufferViewCreateInfo::safe_VkBufferViewCreateInfo(const VkBufferViewCreateInfo* in_struct) :
    sType(in_struct->sType),
    flags(in_struct->flags),
    buffer(in_struct->buffer),
    format(in_struct->format),
    offset(in_struct->offset),
    range(in_struct->range)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkBufferViewCreateInfo::safe_VkBufferViewCreateInfo() :
    pNext(nullptr)
{}

safe_VkBufferViewCreateInfo::safe_VkBufferViewCreateInfo(const safe_VkBufferViewCreateInfo& src)
{
    sType = src.sType;
    flags = src.flags;
    buffer = src.buffer;
    format = src.format;
    offset = src.offset;
    range = src.range;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkBufferViewCreateInfo& safe_VkBufferViewCreateInfo::operator=(const safe_VkBufferViewCreateInfo& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    flags = src.flags;
    buffer = src.buffer;
    format = src.format;
    offset = src.offset;
    range = src.range;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkBufferViewCreateInfo::~safe_VkBufferViewCreateInfo()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkBufferViewCreateInfo::initialize(const VkBufferViewCreateInfo* in_struct)
{
    sType = in_struct->sType;
    flags = in_struct->flags;
    buffer = in_struct->buffer;
    format = in_struct->format;
    offset = in_struct->offset;
    range = in_struct->range;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkBufferViewCreateInfo::initialize(const safe_VkBufferViewCreateInfo* src)
{
    sType = src->sType;
    flags = src->flags;
    buffer = src->buffer;
    format = src->format;
    offset = src->offset;
    range = src->range;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkImageCreateInfo::safe_VkImageCreateInfo(const VkImageCreateInfo* in_struct) :
    sType(in_struct->sType),
    flags(in_struct->flags),
    imageType(in_struct->imageType),
    format(in_struct->format),
    extent(in_struct->extent),
    mipLevels(in_struct->mipLevels),
    arrayLayers(in_struct->arrayLayers),
    samples(in_struct->samples),
    tiling(in_struct->tiling),
    usage(in_struct->usage),
    sharingMode(in_struct->sharingMode),
    queueFamilyIndexCount(in_struct->queueFamilyIndexCount),
    pQueueFamilyIndices(nullptr),
    initialLayout(in_struct->initialLayout)
{
    pNext = SafePnextCopy(in_struct->pNext);
    if (in_struct->pQueueFamilyIndices) {
        pQueueFamilyIndices = new uint32_t[in_struct->queueFamilyIndexCount];
        memcpy ((void *)pQueueFamilyIndices, (void *)in_struct->pQueueFamilyIndices, sizeof(uint32_t)*in_struct->queueFamilyIndexCount);
    }
}

safe_VkImageCreateInfo::safe_VkImageCreateInfo() :
    pNext(nullptr),
    pQueueFamilyIndices(nullptr)
{}

safe_VkImageCreateInfo::safe_VkImageCreateInfo(const safe_VkImageCreateInfo& src)
{
    sType = src.sType;
    flags = src.flags;
    imageType = src.imageType;
    format = src.format;
    extent = src.extent;
    mipLevels = src.mipLevels;
    arrayLayers = src.arrayLayers;
    samples = src.samples;
    tiling = src.tiling;
    usage = src.usage;
    sharingMode = src.sharingMode;
    queueFamilyIndexCount = src.queueFamilyIndexCount;
    pQueueFamilyIndices = nullptr;
    initialLayout = src.initialLayout;
    pNext = SafePnextCopy(src.pNext);
    if (src.pQueueFamilyIndices) {
        pQueueFamilyIndices = new uint32_t[src.queueFamilyIndexCount];
        memcpy ((void *)pQueueFamilyIndices, (void *)src.pQueueFamilyIndices, sizeof(uint32_t)*src.queueFamilyIndexCount);
    }
}

safe_VkImageCreateInfo& safe_VkImageCreateInfo::operator=(const safe_VkImageCreateInfo& src)
{
    if (&src == this) return *this;

    if (pQueueFamilyIndices)
        delete[] pQueueFamilyIndices;
    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    flags = src.flags;
    imageType = src.imageType;
    format = src.format;
    extent = src.extent;
    mipLevels = src.mipLevels;
    arrayLayers = src.arrayLayers;
    samples = src.samples;
    tiling = src.tiling;
    usage = src.usage;
    sharingMode = src.sharingMode;
    queueFamilyIndexCount = src.queueFamilyIndexCount;
    pQueueFamilyIndices = nullptr;
    initialLayout = src.initialLayout;
    pNext = SafePnextCopy(src.pNext);
    if (src.pQueueFamilyIndices) {
        pQueueFamilyIndices = new uint32_t[src.queueFamilyIndexCount];
        memcpy ((void *)pQueueFamilyIndices, (void *)src.pQueueFamilyIndices, sizeof(uint32_t)*src.queueFamilyIndexCount);
    }

    return *this;
}

safe_VkImageCreateInfo::~safe_VkImageCreateInfo()
{
    if (pQueueFamilyIndices)
        delete[] pQueueFamilyIndices;
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkImageCreateInfo::initialize(const VkImageCreateInfo* in_struct)
{
    sType = in_struct->sType;
    flags = in_struct->flags;
    imageType = in_struct->imageType;
    format = in_struct->format;
    extent = in_struct->extent;
    mipLevels = in_struct->mipLevels;
    arrayLayers = in_struct->arrayLayers;
    samples = in_struct->samples;
    tiling = in_struct->tiling;
    usage = in_struct->usage;
    sharingMode = in_struct->sharingMode;
    queueFamilyIndexCount = in_struct->queueFamilyIndexCount;
    pQueueFamilyIndices = nullptr;
    initialLayout = in_struct->initialLayout;
    pNext = SafePnextCopy(in_struct->pNext);
    if (in_struct->pQueueFamilyIndices) {
        pQueueFamilyIndices = new uint32_t[in_struct->queueFamilyIndexCount];
        memcpy ((void *)pQueueFamilyIndices, (void *)in_struct->pQueueFamilyIndices, sizeof(uint32_t)*in_struct->queueFamilyIndexCount);
    }
}

void safe_VkImageCreateInfo::initialize(const safe_VkImageCreateInfo* src)
{
    sType = src->sType;
    flags = src->flags;
    imageType = src->imageType;
    format = src->format;
    extent = src->extent;
    mipLevels = src->mipLevels;
    arrayLayers = src->arrayLayers;
    samples = src->samples;
    tiling = src->tiling;
    usage = src->usage;
    sharingMode = src->sharingMode;
    queueFamilyIndexCount = src->queueFamilyIndexCount;
    pQueueFamilyIndices = nullptr;
    initialLayout = src->initialLayout;
    pNext = SafePnextCopy(src->pNext);
    if (src->pQueueFamilyIndices) {
        pQueueFamilyIndices = new uint32_t[src->queueFamilyIndexCount];
        memcpy ((void *)pQueueFamilyIndices, (void *)src->pQueueFamilyIndices, sizeof(uint32_t)*src->queueFamilyIndexCount);
    }
}

safe_VkImageViewCreateInfo::safe_VkImageViewCreateInfo(const VkImageViewCreateInfo* in_struct) :
    sType(in_struct->sType),
    flags(in_struct->flags),
    image(in_struct->image),
    viewType(in_struct->viewType),
    format(in_struct->format),
    components(in_struct->components),
    subresourceRange(in_struct->subresourceRange)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkImageViewCreateInfo::safe_VkImageViewCreateInfo() :
    pNext(nullptr)
{}

safe_VkImageViewCreateInfo::safe_VkImageViewCreateInfo(const safe_VkImageViewCreateInfo& src)
{
    sType = src.sType;
    flags = src.flags;
    image = src.image;
    viewType = src.viewType;
    format = src.format;
    components = src.components;
    subresourceRange = src.subresourceRange;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkImageViewCreateInfo& safe_VkImageViewCreateInfo::operator=(const safe_VkImageViewCreateInfo& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    flags = src.flags;
    image = src.image;
    viewType = src.viewType;
    format = src.format;
    components = src.components;
    subresourceRange = src.subresourceRange;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkImageViewCreateInfo::~safe_VkImageViewCreateInfo()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkImageViewCreateInfo::initialize(const VkImageViewCreateInfo* in_struct)
{
    sType = in_struct->sType;
    flags = in_struct->flags;
    image = in_struct->image;
    viewType = in_struct->viewType;
    format = in_struct->format;
    components = in_struct->components;
    subresourceRange = in_struct->subresourceRange;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkImageViewCreateInfo::initialize(const safe_VkImageViewCreateInfo* src)
{
    sType = src->sType;
    flags = src->flags;
    image = src->image;
    viewType = src->viewType;
    format = src->format;
    components = src->components;
    subresourceRange = src->subresourceRange;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkShaderModuleCreateInfo::safe_VkShaderModuleCreateInfo(const VkShaderModuleCreateInfo* in_struct) :
    sType(in_struct->sType),
    flags(in_struct->flags),
    codeSize(in_struct->codeSize),
    pCode(nullptr)
{
    pNext = SafePnextCopy(in_struct->pNext);
    if (in_struct->pCode) {
        pCode = reinterpret_cast<uint32_t *>(new uint8_t[codeSize]);
        memcpy((void *)pCode, (void *)in_struct->pCode, codeSize);
    }
}

safe_VkShaderModuleCreateInfo::safe_VkShaderModuleCreateInfo() :
    pNext(nullptr),
    pCode(nullptr)
{}

safe_VkShaderModuleCreateInfo::safe_VkShaderModuleCreateInfo(const safe_VkShaderModuleCreateInfo& src)
{
    sType = src.sType;
    flags = src.flags;
    codeSize = src.codeSize;
    pCode = nullptr;
    pNext = SafePnextCopy(src.pNext);
    if (src.pCode) {
        pCode = reinterpret_cast<uint32_t *>(new uint8_t[codeSize]);
        memcpy((void *)pCode, (void *)src.pCode, codeSize);
    }
}

safe_VkShaderModuleCreateInfo& safe_VkShaderModuleCreateInfo::operator=(const safe_VkShaderModuleCreateInfo& src)
{
    if (&src == this) return *this;

    if (pCode)
        delete[] reinterpret_cast<const uint8_t *>(pCode);
    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    flags = src.flags;
    codeSize = src.codeSize;
    pCode = nullptr;
    pNext = SafePnextCopy(src.pNext);
    if (src.pCode) {
        pCode = reinterpret_cast<uint32_t *>(new uint8_t[codeSize]);
        memcpy((void *)pCode, (void *)src.pCode, codeSize);
    }

    return *this;
}

safe_VkShaderModuleCreateInfo::~safe_VkShaderModuleCreateInfo()
{
    if (pCode)
        delete[] reinterpret_cast<const uint8_t *>(pCode);
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkShaderModuleCreateInfo::initialize(const VkShaderModuleCreateInfo* in_struct)
{
    sType = in_struct->sType;
    flags = in_struct->flags;
    codeSize = in_struct->codeSize;
    pCode = nullptr;
    pNext = SafePnextCopy(in_struct->pNext);
    if (in_struct->pCode) {
        pCode = reinterpret_cast<uint32_t *>(new uint8_t[codeSize]);
        memcpy((void *)pCode, (void *)in_struct->pCode, codeSize);
    }
}

void safe_VkShaderModuleCreateInfo::initialize(const safe_VkShaderModuleCreateInfo* src)
{
    sType = src->sType;
    flags = src->flags;
    codeSize = src->codeSize;
    pCode = nullptr;
    pNext = SafePnextCopy(src->pNext);
    if (src->pCode) {
        pCode = reinterpret_cast<uint32_t *>(new uint8_t[codeSize]);
        memcpy((void *)pCode, (void *)src->pCode, codeSize);
    }
}

safe_VkPipelineCacheCreateInfo::safe_VkPipelineCacheCreateInfo(const VkPipelineCacheCreateInfo* in_struct) :
    sType(in_struct->sType),
    flags(in_struct->flags),
    initialDataSize(in_struct->initialDataSize),
    pInitialData(in_struct->pInitialData)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkPipelineCacheCreateInfo::safe_VkPipelineCacheCreateInfo() :
    pNext(nullptr),
    pInitialData(nullptr)
{}

safe_VkPipelineCacheCreateInfo::safe_VkPipelineCacheCreateInfo(const safe_VkPipelineCacheCreateInfo& src)
{
    sType = src.sType;
    flags = src.flags;
    initialDataSize = src.initialDataSize;
    pInitialData = src.pInitialData;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkPipelineCacheCreateInfo& safe_VkPipelineCacheCreateInfo::operator=(const safe_VkPipelineCacheCreateInfo& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    flags = src.flags;
    initialDataSize = src.initialDataSize;
    pInitialData = src.pInitialData;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkPipelineCacheCreateInfo::~safe_VkPipelineCacheCreateInfo()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPipelineCacheCreateInfo::initialize(const VkPipelineCacheCreateInfo* in_struct)
{
    sType = in_struct->sType;
    flags = in_struct->flags;
    initialDataSize = in_struct->initialDataSize;
    pInitialData = in_struct->pInitialData;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkPipelineCacheCreateInfo::initialize(const safe_VkPipelineCacheCreateInfo* src)
{
    sType = src->sType;
    flags = src->flags;
    initialDataSize = src->initialDataSize;
    pInitialData = src->pInitialData;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkSpecializationInfo::safe_VkSpecializationInfo(const VkSpecializationInfo* in_struct) :
    mapEntryCount(in_struct->mapEntryCount),
    pMapEntries(nullptr),
    dataSize(in_struct->dataSize),
    pData(in_struct->pData)
{
    if (in_struct->pMapEntries) {
        pMapEntries = new VkSpecializationMapEntry[in_struct->mapEntryCount];
        memcpy ((void *)pMapEntries, (void *)in_struct->pMapEntries, sizeof(VkSpecializationMapEntry)*in_struct->mapEntryCount);
    }
}

safe_VkSpecializationInfo::safe_VkSpecializationInfo() :
    pMapEntries(nullptr),
    pData(nullptr)
{}

safe_VkSpecializationInfo::safe_VkSpecializationInfo(const safe_VkSpecializationInfo& src)
{
    mapEntryCount = src.mapEntryCount;
    pMapEntries = nullptr;
    dataSize = src.dataSize;
    pData = src.pData;
    if (src.pMapEntries) {
        pMapEntries = new VkSpecializationMapEntry[src.mapEntryCount];
        memcpy ((void *)pMapEntries, (void *)src.pMapEntries, sizeof(VkSpecializationMapEntry)*src.mapEntryCount);
    }
}

safe_VkSpecializationInfo& safe_VkSpecializationInfo::operator=(const safe_VkSpecializationInfo& src)
{
    if (&src == this) return *this;

    if (pMapEntries)
        delete[] pMapEntries;

    mapEntryCount = src.mapEntryCount;
    pMapEntries = nullptr;
    dataSize = src.dataSize;
    pData = src.pData;
    if (src.pMapEntries) {
        pMapEntries = new VkSpecializationMapEntry[src.mapEntryCount];
        memcpy ((void *)pMapEntries, (void *)src.pMapEntries, sizeof(VkSpecializationMapEntry)*src.mapEntryCount);
    }

    return *this;
}

safe_VkSpecializationInfo::~safe_VkSpecializationInfo()
{
    if (pMapEntries)
        delete[] pMapEntries;
}

void safe_VkSpecializationInfo::initialize(const VkSpecializationInfo* in_struct)
{
    mapEntryCount = in_struct->mapEntryCount;
    pMapEntries = nullptr;
    dataSize = in_struct->dataSize;
    pData = in_struct->pData;
    if (in_struct->pMapEntries) {
        pMapEntries = new VkSpecializationMapEntry[in_struct->mapEntryCount];
        memcpy ((void *)pMapEntries, (void *)in_struct->pMapEntries, sizeof(VkSpecializationMapEntry)*in_struct->mapEntryCount);
    }
}

void safe_VkSpecializationInfo::initialize(const safe_VkSpecializationInfo* src)
{
    mapEntryCount = src->mapEntryCount;
    pMapEntries = nullptr;
    dataSize = src->dataSize;
    pData = src->pData;
    if (src->pMapEntries) {
        pMapEntries = new VkSpecializationMapEntry[src->mapEntryCount];
        memcpy ((void *)pMapEntries, (void *)src->pMapEntries, sizeof(VkSpecializationMapEntry)*src->mapEntryCount);
    }
}

safe_VkPipelineShaderStageCreateInfo::safe_VkPipelineShaderStageCreateInfo(const VkPipelineShaderStageCreateInfo* in_struct) :
    sType(in_struct->sType),
    flags(in_struct->flags),
    stage(in_struct->stage),
    module(in_struct->module),
    pSpecializationInfo(nullptr)
{
    pNext = SafePnextCopy(in_struct->pNext);
    pName = SafeStringCopy(in_struct->pName);
    if (in_struct->pSpecializationInfo)
        pSpecializationInfo = new safe_VkSpecializationInfo(in_struct->pSpecializationInfo);
}

safe_VkPipelineShaderStageCreateInfo::safe_VkPipelineShaderStageCreateInfo() :
    pNext(nullptr),
    pName(nullptr),
    pSpecializationInfo(nullptr)
{}

safe_VkPipelineShaderStageCreateInfo::safe_VkPipelineShaderStageCreateInfo(const safe_VkPipelineShaderStageCreateInfo& src)
{
    sType = src.sType;
    flags = src.flags;
    stage = src.stage;
    module = src.module;
    pSpecializationInfo = nullptr;
    pNext = SafePnextCopy(src.pNext);
    pName = SafeStringCopy(src.pName);
    if (src.pSpecializationInfo)
        pSpecializationInfo = new safe_VkSpecializationInfo(*src.pSpecializationInfo);
}

safe_VkPipelineShaderStageCreateInfo& safe_VkPipelineShaderStageCreateInfo::operator=(const safe_VkPipelineShaderStageCreateInfo& src)
{
    if (&src == this) return *this;

    if (pName) delete [] pName;
    if (pSpecializationInfo)
        delete pSpecializationInfo;
    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    flags = src.flags;
    stage = src.stage;
    module = src.module;
    pSpecializationInfo = nullptr;
    pNext = SafePnextCopy(src.pNext);
    pName = SafeStringCopy(src.pName);
    if (src.pSpecializationInfo)
        pSpecializationInfo = new safe_VkSpecializationInfo(*src.pSpecializationInfo);

    return *this;
}

safe_VkPipelineShaderStageCreateInfo::~safe_VkPipelineShaderStageCreateInfo()
{
    if (pName) delete [] pName;
    if (pSpecializationInfo)
        delete pSpecializationInfo;
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPipelineShaderStageCreateInfo::initialize(const VkPipelineShaderStageCreateInfo* in_struct)
{
    sType = in_struct->sType;
    flags = in_struct->flags;
    stage = in_struct->stage;
    module = in_struct->module;
    pSpecializationInfo = nullptr;
    pNext = SafePnextCopy(in_struct->pNext);
    pName = SafeStringCopy(in_struct->pName);
    if (in_struct->pSpecializationInfo)
        pSpecializationInfo = new safe_VkSpecializationInfo(in_struct->pSpecializationInfo);
}

void safe_VkPipelineShaderStageCreateInfo::initialize(const safe_VkPipelineShaderStageCreateInfo* src)
{
    sType = src->sType;
    flags = src->flags;
    stage = src->stage;
    module = src->module;
    pSpecializationInfo = nullptr;
    pNext = SafePnextCopy(src->pNext);
    pName = SafeStringCopy(src->pName);
    if (src->pSpecializationInfo)
        pSpecializationInfo = new safe_VkSpecializationInfo(*src->pSpecializationInfo);
}

safe_VkPipelineVertexInputStateCreateInfo::safe_VkPipelineVertexInputStateCreateInfo(const VkPipelineVertexInputStateCreateInfo* in_struct) :
    sType(in_struct->sType),
    flags(in_struct->flags),
    vertexBindingDescriptionCount(in_struct->vertexBindingDescriptionCount),
    pVertexBindingDescriptions(nullptr),
    vertexAttributeDescriptionCount(in_struct->vertexAttributeDescriptionCount),
    pVertexAttributeDescriptions(nullptr)
{
    pNext = SafePnextCopy(in_struct->pNext);
    if (in_struct->pVertexBindingDescriptions) {
        pVertexBindingDescriptions = new VkVertexInputBindingDescription[in_struct->vertexBindingDescriptionCount];
        memcpy ((void *)pVertexBindingDescriptions, (void *)in_struct->pVertexBindingDescriptions, sizeof(VkVertexInputBindingDescription)*in_struct->vertexBindingDescriptionCount);
    }
    if (in_struct->pVertexAttributeDescriptions) {
        pVertexAttributeDescriptions = new VkVertexInputAttributeDescription[in_struct->vertexAttributeDescriptionCount];
        memcpy ((void *)pVertexAttributeDescriptions, (void *)in_struct->pVertexAttributeDescriptions, sizeof(VkVertexInputAttributeDescription)*in_struct->vertexAttributeDescriptionCount);
    }
}

safe_VkPipelineVertexInputStateCreateInfo::safe_VkPipelineVertexInputStateCreateInfo() :
    pNext(nullptr),
    pVertexBindingDescriptions(nullptr),
    pVertexAttributeDescriptions(nullptr)
{}

safe_VkPipelineVertexInputStateCreateInfo::safe_VkPipelineVertexInputStateCreateInfo(const safe_VkPipelineVertexInputStateCreateInfo& src)
{
    sType = src.sType;
    flags = src.flags;
    vertexBindingDescriptionCount = src.vertexBindingDescriptionCount;
    pVertexBindingDescriptions = nullptr;
    vertexAttributeDescriptionCount = src.vertexAttributeDescriptionCount;
    pVertexAttributeDescriptions = nullptr;
    pNext = SafePnextCopy(src.pNext);
    if (src.pVertexBindingDescriptions) {
        pVertexBindingDescriptions = new VkVertexInputBindingDescription[src.vertexBindingDescriptionCount];
        memcpy ((void *)pVertexBindingDescriptions, (void *)src.pVertexBindingDescriptions, sizeof(VkVertexInputBindingDescription)*src.vertexBindingDescriptionCount);
    }
    if (src.pVertexAttributeDescriptions) {
        pVertexAttributeDescriptions = new VkVertexInputAttributeDescription[src.vertexAttributeDescriptionCount];
        memcpy ((void *)pVertexAttributeDescriptions, (void *)src.pVertexAttributeDescriptions, sizeof(VkVertexInputAttributeDescription)*src.vertexAttributeDescriptionCount);
    }
}

safe_VkPipelineVertexInputStateCreateInfo& safe_VkPipelineVertexInputStateCreateInfo::operator=(const safe_VkPipelineVertexInputStateCreateInfo& src)
{
    if (&src == this) return *this;

    if (pVertexBindingDescriptions)
        delete[] pVertexBindingDescriptions;
    if (pVertexAttributeDescriptions)
        delete[] pVertexAttributeDescriptions;
    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    flags = src.flags;
    vertexBindingDescriptionCount = src.vertexBindingDescriptionCount;
    pVertexBindingDescriptions = nullptr;
    vertexAttributeDescriptionCount = src.vertexAttributeDescriptionCount;
    pVertexAttributeDescriptions = nullptr;
    pNext = SafePnextCopy(src.pNext);
    if (src.pVertexBindingDescriptions) {
        pVertexBindingDescriptions = new VkVertexInputBindingDescription[src.vertexBindingDescriptionCount];
        memcpy ((void *)pVertexBindingDescriptions, (void *)src.pVertexBindingDescriptions, sizeof(VkVertexInputBindingDescription)*src.vertexBindingDescriptionCount);
    }
    if (src.pVertexAttributeDescriptions) {
        pVertexAttributeDescriptions = new VkVertexInputAttributeDescription[src.vertexAttributeDescriptionCount];
        memcpy ((void *)pVertexAttributeDescriptions, (void *)src.pVertexAttributeDescriptions, sizeof(VkVertexInputAttributeDescription)*src.vertexAttributeDescriptionCount);
    }

    return *this;
}

safe_VkPipelineVertexInputStateCreateInfo::~safe_VkPipelineVertexInputStateCreateInfo()
{
    if (pVertexBindingDescriptions)
        delete[] pVertexBindingDescriptions;
    if (pVertexAttributeDescriptions)
        delete[] pVertexAttributeDescriptions;
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPipelineVertexInputStateCreateInfo::initialize(const VkPipelineVertexInputStateCreateInfo* in_struct)
{
    sType = in_struct->sType;
    flags = in_struct->flags;
    vertexBindingDescriptionCount = in_struct->vertexBindingDescriptionCount;
    pVertexBindingDescriptions = nullptr;
    vertexAttributeDescriptionCount = in_struct->vertexAttributeDescriptionCount;
    pVertexAttributeDescriptions = nullptr;
    pNext = SafePnextCopy(in_struct->pNext);
    if (in_struct->pVertexBindingDescriptions) {
        pVertexBindingDescriptions = new VkVertexInputBindingDescription[in_struct->vertexBindingDescriptionCount];
        memcpy ((void *)pVertexBindingDescriptions, (void *)in_struct->pVertexBindingDescriptions, sizeof(VkVertexInputBindingDescription)*in_struct->vertexBindingDescriptionCount);
    }
    if (in_struct->pVertexAttributeDescriptions) {
        pVertexAttributeDescriptions = new VkVertexInputAttributeDescription[in_struct->vertexAttributeDescriptionCount];
        memcpy ((void *)pVertexAttributeDescriptions, (void *)in_struct->pVertexAttributeDescriptions, sizeof(VkVertexInputAttributeDescription)*in_struct->vertexAttributeDescriptionCount);
    }
}

void safe_VkPipelineVertexInputStateCreateInfo::initialize(const safe_VkPipelineVertexInputStateCreateInfo* src)
{
    sType = src->sType;
    flags = src->flags;
    vertexBindingDescriptionCount = src->vertexBindingDescriptionCount;
    pVertexBindingDescriptions = nullptr;
    vertexAttributeDescriptionCount = src->vertexAttributeDescriptionCount;
    pVertexAttributeDescriptions = nullptr;
    pNext = SafePnextCopy(src->pNext);
    if (src->pVertexBindingDescriptions) {
        pVertexBindingDescriptions = new VkVertexInputBindingDescription[src->vertexBindingDescriptionCount];
        memcpy ((void *)pVertexBindingDescriptions, (void *)src->pVertexBindingDescriptions, sizeof(VkVertexInputBindingDescription)*src->vertexBindingDescriptionCount);
    }
    if (src->pVertexAttributeDescriptions) {
        pVertexAttributeDescriptions = new VkVertexInputAttributeDescription[src->vertexAttributeDescriptionCount];
        memcpy ((void *)pVertexAttributeDescriptions, (void *)src->pVertexAttributeDescriptions, sizeof(VkVertexInputAttributeDescription)*src->vertexAttributeDescriptionCount);
    }
}

safe_VkPipelineInputAssemblyStateCreateInfo::safe_VkPipelineInputAssemblyStateCreateInfo(const VkPipelineInputAssemblyStateCreateInfo* in_struct) :
    sType(in_struct->sType),
    flags(in_struct->flags),
    topology(in_struct->topology),
    primitiveRestartEnable(in_struct->primitiveRestartEnable)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkPipelineInputAssemblyStateCreateInfo::safe_VkPipelineInputAssemblyStateCreateInfo() :
    pNext(nullptr)
{}

safe_VkPipelineInputAssemblyStateCreateInfo::safe_VkPipelineInputAssemblyStateCreateInfo(const safe_VkPipelineInputAssemblyStateCreateInfo& src)
{
    sType = src.sType;
    flags = src.flags;
    topology = src.topology;
    primitiveRestartEnable = src.primitiveRestartEnable;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkPipelineInputAssemblyStateCreateInfo& safe_VkPipelineInputAssemblyStateCreateInfo::operator=(const safe_VkPipelineInputAssemblyStateCreateInfo& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    flags = src.flags;
    topology = src.topology;
    primitiveRestartEnable = src.primitiveRestartEnable;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkPipelineInputAssemblyStateCreateInfo::~safe_VkPipelineInputAssemblyStateCreateInfo()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPipelineInputAssemblyStateCreateInfo::initialize(const VkPipelineInputAssemblyStateCreateInfo* in_struct)
{
    sType = in_struct->sType;
    flags = in_struct->flags;
    topology = in_struct->topology;
    primitiveRestartEnable = in_struct->primitiveRestartEnable;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkPipelineInputAssemblyStateCreateInfo::initialize(const safe_VkPipelineInputAssemblyStateCreateInfo* src)
{
    sType = src->sType;
    flags = src->flags;
    topology = src->topology;
    primitiveRestartEnable = src->primitiveRestartEnable;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkPipelineTessellationStateCreateInfo::safe_VkPipelineTessellationStateCreateInfo(const VkPipelineTessellationStateCreateInfo* in_struct) :
    sType(in_struct->sType),
    flags(in_struct->flags),
    patchControlPoints(in_struct->patchControlPoints)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkPipelineTessellationStateCreateInfo::safe_VkPipelineTessellationStateCreateInfo() :
    pNext(nullptr)
{}

safe_VkPipelineTessellationStateCreateInfo::safe_VkPipelineTessellationStateCreateInfo(const safe_VkPipelineTessellationStateCreateInfo& src)
{
    sType = src.sType;
    flags = src.flags;
    patchControlPoints = src.patchControlPoints;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkPipelineTessellationStateCreateInfo& safe_VkPipelineTessellationStateCreateInfo::operator=(const safe_VkPipelineTessellationStateCreateInfo& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    flags = src.flags;
    patchControlPoints = src.patchControlPoints;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkPipelineTessellationStateCreateInfo::~safe_VkPipelineTessellationStateCreateInfo()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPipelineTessellationStateCreateInfo::initialize(const VkPipelineTessellationStateCreateInfo* in_struct)
{
    sType = in_struct->sType;
    flags = in_struct->flags;
    patchControlPoints = in_struct->patchControlPoints;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkPipelineTessellationStateCreateInfo::initialize(const safe_VkPipelineTessellationStateCreateInfo* src)
{
    sType = src->sType;
    flags = src->flags;
    patchControlPoints = src->patchControlPoints;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkPipelineViewportStateCreateInfo::safe_VkPipelineViewportStateCreateInfo(const VkPipelineViewportStateCreateInfo* in_struct, const bool is_dynamic_viewports, const bool is_dynamic_scissors) :
    sType(in_struct->sType),
    flags(in_struct->flags),
    viewportCount(in_struct->viewportCount),
    pViewports(nullptr),
    scissorCount(in_struct->scissorCount),
    pScissors(nullptr)
{
    pNext = SafePnextCopy(in_struct->pNext);
    if (in_struct->pViewports && !is_dynamic_viewports) {
        pViewports = new VkViewport[in_struct->viewportCount];
        memcpy ((void *)pViewports, (void *)in_struct->pViewports, sizeof(VkViewport)*in_struct->viewportCount);
    }
    else
        pViewports = NULL;
    if (in_struct->pScissors && !is_dynamic_scissors) {
        pScissors = new VkRect2D[in_struct->scissorCount];
        memcpy ((void *)pScissors, (void *)in_struct->pScissors, sizeof(VkRect2D)*in_struct->scissorCount);
    }
    else
        pScissors = NULL;
}

safe_VkPipelineViewportStateCreateInfo::safe_VkPipelineViewportStateCreateInfo() :
    pNext(nullptr),
    pViewports(nullptr),
    pScissors(nullptr)
{}

safe_VkPipelineViewportStateCreateInfo::safe_VkPipelineViewportStateCreateInfo(const safe_VkPipelineViewportStateCreateInfo& src)
{
    sType = src.sType;
    flags = src.flags;
    viewportCount = src.viewportCount;
    pViewports = nullptr;
    scissorCount = src.scissorCount;
    pScissors = nullptr;
    pNext = SafePnextCopy(src.pNext);
    if (src.pViewports) {
        pViewports = new VkViewport[src.viewportCount];
        memcpy ((void *)pViewports, (void *)src.pViewports, sizeof(VkViewport)*src.viewportCount);
    }
    else
        pViewports = NULL;
    if (src.pScissors) {
        pScissors = new VkRect2D[src.scissorCount];
        memcpy ((void *)pScissors, (void *)src.pScissors, sizeof(VkRect2D)*src.scissorCount);
    }
    else
        pScissors = NULL;
}

safe_VkPipelineViewportStateCreateInfo& safe_VkPipelineViewportStateCreateInfo::operator=(const safe_VkPipelineViewportStateCreateInfo& src)
{
    if (&src == this) return *this;

    if (pViewports)
        delete[] pViewports;
    if (pScissors)
        delete[] pScissors;
    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    flags = src.flags;
    viewportCount = src.viewportCount;
    pViewports = nullptr;
    scissorCount = src.scissorCount;
    pScissors = nullptr;
    pNext = SafePnextCopy(src.pNext);
    if (src.pViewports) {
        pViewports = new VkViewport[src.viewportCount];
        memcpy ((void *)pViewports, (void *)src.pViewports, sizeof(VkViewport)*src.viewportCount);
    }
    else
        pViewports = NULL;
    if (src.pScissors) {
        pScissors = new VkRect2D[src.scissorCount];
        memcpy ((void *)pScissors, (void *)src.pScissors, sizeof(VkRect2D)*src.scissorCount);
    }
    else
        pScissors = NULL;

    return *this;
}

safe_VkPipelineViewportStateCreateInfo::~safe_VkPipelineViewportStateCreateInfo()
{
    if (pViewports)
        delete[] pViewports;
    if (pScissors)
        delete[] pScissors;
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPipelineViewportStateCreateInfo::initialize(const VkPipelineViewportStateCreateInfo* in_struct, const bool is_dynamic_viewports, const bool is_dynamic_scissors)
{
    sType = in_struct->sType;
    flags = in_struct->flags;
    viewportCount = in_struct->viewportCount;
    pViewports = nullptr;
    scissorCount = in_struct->scissorCount;
    pScissors = nullptr;
    pNext = SafePnextCopy(in_struct->pNext);
    if (in_struct->pViewports && !is_dynamic_viewports) {
        pViewports = new VkViewport[in_struct->viewportCount];
        memcpy ((void *)pViewports, (void *)in_struct->pViewports, sizeof(VkViewport)*in_struct->viewportCount);
    }
    else
        pViewports = NULL;
    if (in_struct->pScissors && !is_dynamic_scissors) {
        pScissors = new VkRect2D[in_struct->scissorCount];
        memcpy ((void *)pScissors, (void *)in_struct->pScissors, sizeof(VkRect2D)*in_struct->scissorCount);
    }
    else
        pScissors = NULL;
}

void safe_VkPipelineViewportStateCreateInfo::initialize(const safe_VkPipelineViewportStateCreateInfo* src)
{
    sType = src->sType;
    flags = src->flags;
    viewportCount = src->viewportCount;
    pViewports = nullptr;
    scissorCount = src->scissorCount;
    pScissors = nullptr;
    pNext = SafePnextCopy(src->pNext);
    if (src->pViewports) {
        pViewports = new VkViewport[src->viewportCount];
        memcpy ((void *)pViewports, (void *)src->pViewports, sizeof(VkViewport)*src->viewportCount);
    }
    else
        pViewports = NULL;
    if (src->pScissors) {
        pScissors = new VkRect2D[src->scissorCount];
        memcpy ((void *)pScissors, (void *)src->pScissors, sizeof(VkRect2D)*src->scissorCount);
    }
    else
        pScissors = NULL;
}

safe_VkPipelineRasterizationStateCreateInfo::safe_VkPipelineRasterizationStateCreateInfo(const VkPipelineRasterizationStateCreateInfo* in_struct) :
    sType(in_struct->sType),
    flags(in_struct->flags),
    depthClampEnable(in_struct->depthClampEnable),
    rasterizerDiscardEnable(in_struct->rasterizerDiscardEnable),
    polygonMode(in_struct->polygonMode),
    cullMode(in_struct->cullMode),
    frontFace(in_struct->frontFace),
    depthBiasEnable(in_struct->depthBiasEnable),
    depthBiasConstantFactor(in_struct->depthBiasConstantFactor),
    depthBiasClamp(in_struct->depthBiasClamp),
    depthBiasSlopeFactor(in_struct->depthBiasSlopeFactor),
    lineWidth(in_struct->lineWidth)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkPipelineRasterizationStateCreateInfo::safe_VkPipelineRasterizationStateCreateInfo() :
    pNext(nullptr)
{}

safe_VkPipelineRasterizationStateCreateInfo::safe_VkPipelineRasterizationStateCreateInfo(const safe_VkPipelineRasterizationStateCreateInfo& src)
{
    sType = src.sType;
    flags = src.flags;
    depthClampEnable = src.depthClampEnable;
    rasterizerDiscardEnable = src.rasterizerDiscardEnable;
    polygonMode = src.polygonMode;
    cullMode = src.cullMode;
    frontFace = src.frontFace;
    depthBiasEnable = src.depthBiasEnable;
    depthBiasConstantFactor = src.depthBiasConstantFactor;
    depthBiasClamp = src.depthBiasClamp;
    depthBiasSlopeFactor = src.depthBiasSlopeFactor;
    lineWidth = src.lineWidth;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkPipelineRasterizationStateCreateInfo& safe_VkPipelineRasterizationStateCreateInfo::operator=(const safe_VkPipelineRasterizationStateCreateInfo& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    flags = src.flags;
    depthClampEnable = src.depthClampEnable;
    rasterizerDiscardEnable = src.rasterizerDiscardEnable;
    polygonMode = src.polygonMode;
    cullMode = src.cullMode;
    frontFace = src.frontFace;
    depthBiasEnable = src.depthBiasEnable;
    depthBiasConstantFactor = src.depthBiasConstantFactor;
    depthBiasClamp = src.depthBiasClamp;
    depthBiasSlopeFactor = src.depthBiasSlopeFactor;
    lineWidth = src.lineWidth;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkPipelineRasterizationStateCreateInfo::~safe_VkPipelineRasterizationStateCreateInfo()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPipelineRasterizationStateCreateInfo::initialize(const VkPipelineRasterizationStateCreateInfo* in_struct)
{
    sType = in_struct->sType;
    flags = in_struct->flags;
    depthClampEnable = in_struct->depthClampEnable;
    rasterizerDiscardEnable = in_struct->rasterizerDiscardEnable;
    polygonMode = in_struct->polygonMode;
    cullMode = in_struct->cullMode;
    frontFace = in_struct->frontFace;
    depthBiasEnable = in_struct->depthBiasEnable;
    depthBiasConstantFactor = in_struct->depthBiasConstantFactor;
    depthBiasClamp = in_struct->depthBiasClamp;
    depthBiasSlopeFactor = in_struct->depthBiasSlopeFactor;
    lineWidth = in_struct->lineWidth;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkPipelineRasterizationStateCreateInfo::initialize(const safe_VkPipelineRasterizationStateCreateInfo* src)
{
    sType = src->sType;
    flags = src->flags;
    depthClampEnable = src->depthClampEnable;
    rasterizerDiscardEnable = src->rasterizerDiscardEnable;
    polygonMode = src->polygonMode;
    cullMode = src->cullMode;
    frontFace = src->frontFace;
    depthBiasEnable = src->depthBiasEnable;
    depthBiasConstantFactor = src->depthBiasConstantFactor;
    depthBiasClamp = src->depthBiasClamp;
    depthBiasSlopeFactor = src->depthBiasSlopeFactor;
    lineWidth = src->lineWidth;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkPipelineMultisampleStateCreateInfo::safe_VkPipelineMultisampleStateCreateInfo(const VkPipelineMultisampleStateCreateInfo* in_struct) :
    sType(in_struct->sType),
    flags(in_struct->flags),
    rasterizationSamples(in_struct->rasterizationSamples),
    sampleShadingEnable(in_struct->sampleShadingEnable),
    minSampleShading(in_struct->minSampleShading),
    pSampleMask(nullptr),
    alphaToCoverageEnable(in_struct->alphaToCoverageEnable),
    alphaToOneEnable(in_struct->alphaToOneEnable)
{
    pNext = SafePnextCopy(in_struct->pNext);
    if (in_struct->pSampleMask) {
        pSampleMask = new VkSampleMask(*in_struct->pSampleMask);
    }
}

safe_VkPipelineMultisampleStateCreateInfo::safe_VkPipelineMultisampleStateCreateInfo() :
    pNext(nullptr),
    pSampleMask(nullptr)
{}

safe_VkPipelineMultisampleStateCreateInfo::safe_VkPipelineMultisampleStateCreateInfo(const safe_VkPipelineMultisampleStateCreateInfo& src)
{
    sType = src.sType;
    flags = src.flags;
    rasterizationSamples = src.rasterizationSamples;
    sampleShadingEnable = src.sampleShadingEnable;
    minSampleShading = src.minSampleShading;
    pSampleMask = nullptr;
    alphaToCoverageEnable = src.alphaToCoverageEnable;
    alphaToOneEnable = src.alphaToOneEnable;
    pNext = SafePnextCopy(src.pNext);
    if (src.pSampleMask) {
        pSampleMask = new VkSampleMask(*src.pSampleMask);
    }
}

safe_VkPipelineMultisampleStateCreateInfo& safe_VkPipelineMultisampleStateCreateInfo::operator=(const safe_VkPipelineMultisampleStateCreateInfo& src)
{
    if (&src == this) return *this;

    if (pSampleMask)
        delete pSampleMask;
    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    flags = src.flags;
    rasterizationSamples = src.rasterizationSamples;
    sampleShadingEnable = src.sampleShadingEnable;
    minSampleShading = src.minSampleShading;
    pSampleMask = nullptr;
    alphaToCoverageEnable = src.alphaToCoverageEnable;
    alphaToOneEnable = src.alphaToOneEnable;
    pNext = SafePnextCopy(src.pNext);
    if (src.pSampleMask) {
        pSampleMask = new VkSampleMask(*src.pSampleMask);
    }

    return *this;
}

safe_VkPipelineMultisampleStateCreateInfo::~safe_VkPipelineMultisampleStateCreateInfo()
{
    if (pSampleMask)
        delete pSampleMask;
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPipelineMultisampleStateCreateInfo::initialize(const VkPipelineMultisampleStateCreateInfo* in_struct)
{
    sType = in_struct->sType;
    flags = in_struct->flags;
    rasterizationSamples = in_struct->rasterizationSamples;
    sampleShadingEnable = in_struct->sampleShadingEnable;
    minSampleShading = in_struct->minSampleShading;
    pSampleMask = nullptr;
    alphaToCoverageEnable = in_struct->alphaToCoverageEnable;
    alphaToOneEnable = in_struct->alphaToOneEnable;
    pNext = SafePnextCopy(in_struct->pNext);
    if (in_struct->pSampleMask) {
        pSampleMask = new VkSampleMask(*in_struct->pSampleMask);
    }
}

void safe_VkPipelineMultisampleStateCreateInfo::initialize(const safe_VkPipelineMultisampleStateCreateInfo* src)
{
    sType = src->sType;
    flags = src->flags;
    rasterizationSamples = src->rasterizationSamples;
    sampleShadingEnable = src->sampleShadingEnable;
    minSampleShading = src->minSampleShading;
    pSampleMask = nullptr;
    alphaToCoverageEnable = src->alphaToCoverageEnable;
    alphaToOneEnable = src->alphaToOneEnable;
    pNext = SafePnextCopy(src->pNext);
    if (src->pSampleMask) {
        pSampleMask = new VkSampleMask(*src->pSampleMask);
    }
}

safe_VkPipelineDepthStencilStateCreateInfo::safe_VkPipelineDepthStencilStateCreateInfo(const VkPipelineDepthStencilStateCreateInfo* in_struct) :
    sType(in_struct->sType),
    flags(in_struct->flags),
    depthTestEnable(in_struct->depthTestEnable),
    depthWriteEnable(in_struct->depthWriteEnable),
    depthCompareOp(in_struct->depthCompareOp),
    depthBoundsTestEnable(in_struct->depthBoundsTestEnable),
    stencilTestEnable(in_struct->stencilTestEnable),
    front(in_struct->front),
    back(in_struct->back),
    minDepthBounds(in_struct->minDepthBounds),
    maxDepthBounds(in_struct->maxDepthBounds)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkPipelineDepthStencilStateCreateInfo::safe_VkPipelineDepthStencilStateCreateInfo() :
    pNext(nullptr)
{}

safe_VkPipelineDepthStencilStateCreateInfo::safe_VkPipelineDepthStencilStateCreateInfo(const safe_VkPipelineDepthStencilStateCreateInfo& src)
{
    sType = src.sType;
    flags = src.flags;
    depthTestEnable = src.depthTestEnable;
    depthWriteEnable = src.depthWriteEnable;
    depthCompareOp = src.depthCompareOp;
    depthBoundsTestEnable = src.depthBoundsTestEnable;
    stencilTestEnable = src.stencilTestEnable;
    front = src.front;
    back = src.back;
    minDepthBounds = src.minDepthBounds;
    maxDepthBounds = src.maxDepthBounds;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkPipelineDepthStencilStateCreateInfo& safe_VkPipelineDepthStencilStateCreateInfo::operator=(const safe_VkPipelineDepthStencilStateCreateInfo& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    flags = src.flags;
    depthTestEnable = src.depthTestEnable;
    depthWriteEnable = src.depthWriteEnable;
    depthCompareOp = src.depthCompareOp;
    depthBoundsTestEnable = src.depthBoundsTestEnable;
    stencilTestEnable = src.stencilTestEnable;
    front = src.front;
    back = src.back;
    minDepthBounds = src.minDepthBounds;
    maxDepthBounds = src.maxDepthBounds;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkPipelineDepthStencilStateCreateInfo::~safe_VkPipelineDepthStencilStateCreateInfo()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPipelineDepthStencilStateCreateInfo::initialize(const VkPipelineDepthStencilStateCreateInfo* in_struct)
{
    sType = in_struct->sType;
    flags = in_struct->flags;
    depthTestEnable = in_struct->depthTestEnable;
    depthWriteEnable = in_struct->depthWriteEnable;
    depthCompareOp = in_struct->depthCompareOp;
    depthBoundsTestEnable = in_struct->depthBoundsTestEnable;
    stencilTestEnable = in_struct->stencilTestEnable;
    front = in_struct->front;
    back = in_struct->back;
    minDepthBounds = in_struct->minDepthBounds;
    maxDepthBounds = in_struct->maxDepthBounds;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkPipelineDepthStencilStateCreateInfo::initialize(const safe_VkPipelineDepthStencilStateCreateInfo* src)
{
    sType = src->sType;
    flags = src->flags;
    depthTestEnable = src->depthTestEnable;
    depthWriteEnable = src->depthWriteEnable;
    depthCompareOp = src->depthCompareOp;
    depthBoundsTestEnable = src->depthBoundsTestEnable;
    stencilTestEnable = src->stencilTestEnable;
    front = src->front;
    back = src->back;
    minDepthBounds = src->minDepthBounds;
    maxDepthBounds = src->maxDepthBounds;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkPipelineColorBlendStateCreateInfo::safe_VkPipelineColorBlendStateCreateInfo(const VkPipelineColorBlendStateCreateInfo* in_struct) :
    sType(in_struct->sType),
    flags(in_struct->flags),
    logicOpEnable(in_struct->logicOpEnable),
    logicOp(in_struct->logicOp),
    attachmentCount(in_struct->attachmentCount),
    pAttachments(nullptr)
{
    pNext = SafePnextCopy(in_struct->pNext);
    if (in_struct->pAttachments) {
        pAttachments = new VkPipelineColorBlendAttachmentState[in_struct->attachmentCount];
        memcpy ((void *)pAttachments, (void *)in_struct->pAttachments, sizeof(VkPipelineColorBlendAttachmentState)*in_struct->attachmentCount);
    }
    for (uint32_t i = 0; i < 4; ++i) {
        blendConstants[i] = in_struct->blendConstants[i];
    }
}

safe_VkPipelineColorBlendStateCreateInfo::safe_VkPipelineColorBlendStateCreateInfo() :
    pNext(nullptr),
    pAttachments(nullptr)
{}

safe_VkPipelineColorBlendStateCreateInfo::safe_VkPipelineColorBlendStateCreateInfo(const safe_VkPipelineColorBlendStateCreateInfo& src)
{
    sType = src.sType;
    flags = src.flags;
    logicOpEnable = src.logicOpEnable;
    logicOp = src.logicOp;
    attachmentCount = src.attachmentCount;
    pAttachments = nullptr;
    pNext = SafePnextCopy(src.pNext);
    if (src.pAttachments) {
        pAttachments = new VkPipelineColorBlendAttachmentState[src.attachmentCount];
        memcpy ((void *)pAttachments, (void *)src.pAttachments, sizeof(VkPipelineColorBlendAttachmentState)*src.attachmentCount);
    }
    for (uint32_t i = 0; i < 4; ++i) {
        blendConstants[i] = src.blendConstants[i];
    }
}

safe_VkPipelineColorBlendStateCreateInfo& safe_VkPipelineColorBlendStateCreateInfo::operator=(const safe_VkPipelineColorBlendStateCreateInfo& src)
{
    if (&src == this) return *this;

    if (pAttachments)
        delete[] pAttachments;
    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    flags = src.flags;
    logicOpEnable = src.logicOpEnable;
    logicOp = src.logicOp;
    attachmentCount = src.attachmentCount;
    pAttachments = nullptr;
    pNext = SafePnextCopy(src.pNext);
    if (src.pAttachments) {
        pAttachments = new VkPipelineColorBlendAttachmentState[src.attachmentCount];
        memcpy ((void *)pAttachments, (void *)src.pAttachments, sizeof(VkPipelineColorBlendAttachmentState)*src.attachmentCount);
    }
    for (uint32_t i = 0; i < 4; ++i) {
        blendConstants[i] = src.blendConstants[i];
    }

    return *this;
}

safe_VkPipelineColorBlendStateCreateInfo::~safe_VkPipelineColorBlendStateCreateInfo()
{
    if (pAttachments)
        delete[] pAttachments;
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPipelineColorBlendStateCreateInfo::initialize(const VkPipelineColorBlendStateCreateInfo* in_struct)
{
    sType = in_struct->sType;
    flags = in_struct->flags;
    logicOpEnable = in_struct->logicOpEnable;
    logicOp = in_struct->logicOp;
    attachmentCount = in_struct->attachmentCount;
    pAttachments = nullptr;
    pNext = SafePnextCopy(in_struct->pNext);
    if (in_struct->pAttachments) {
        pAttachments = new VkPipelineColorBlendAttachmentState[in_struct->attachmentCount];
        memcpy ((void *)pAttachments, (void *)in_struct->pAttachments, sizeof(VkPipelineColorBlendAttachmentState)*in_struct->attachmentCount);
    }
    for (uint32_t i = 0; i < 4; ++i) {
        blendConstants[i] = in_struct->blendConstants[i];
    }
}

void safe_VkPipelineColorBlendStateCreateInfo::initialize(const safe_VkPipelineColorBlendStateCreateInfo* src)
{
    sType = src->sType;
    flags = src->flags;
    logicOpEnable = src->logicOpEnable;
    logicOp = src->logicOp;
    attachmentCount = src->attachmentCount;
    pAttachments = nullptr;
    pNext = SafePnextCopy(src->pNext);
    if (src->pAttachments) {
        pAttachments = new VkPipelineColorBlendAttachmentState[src->attachmentCount];
        memcpy ((void *)pAttachments, (void *)src->pAttachments, sizeof(VkPipelineColorBlendAttachmentState)*src->attachmentCount);
    }
    for (uint32_t i = 0; i < 4; ++i) {
        blendConstants[i] = src->blendConstants[i];
    }
}

safe_VkPipelineDynamicStateCreateInfo::safe_VkPipelineDynamicStateCreateInfo(const VkPipelineDynamicStateCreateInfo* in_struct) :
    sType(in_struct->sType),
    flags(in_struct->flags),
    dynamicStateCount(in_struct->dynamicStateCount),
    pDynamicStates(nullptr)
{
    pNext = SafePnextCopy(in_struct->pNext);
    if (in_struct->pDynamicStates) {
        pDynamicStates = new VkDynamicState[in_struct->dynamicStateCount];
        memcpy ((void *)pDynamicStates, (void *)in_struct->pDynamicStates, sizeof(VkDynamicState)*in_struct->dynamicStateCount);
    }
}

safe_VkPipelineDynamicStateCreateInfo::safe_VkPipelineDynamicStateCreateInfo() :
    pNext(nullptr),
    pDynamicStates(nullptr)
{}

safe_VkPipelineDynamicStateCreateInfo::safe_VkPipelineDynamicStateCreateInfo(const safe_VkPipelineDynamicStateCreateInfo& src)
{
    sType = src.sType;
    flags = src.flags;
    dynamicStateCount = src.dynamicStateCount;
    pDynamicStates = nullptr;
    pNext = SafePnextCopy(src.pNext);
    if (src.pDynamicStates) {
        pDynamicStates = new VkDynamicState[src.dynamicStateCount];
        memcpy ((void *)pDynamicStates, (void *)src.pDynamicStates, sizeof(VkDynamicState)*src.dynamicStateCount);
    }
}

safe_VkPipelineDynamicStateCreateInfo& safe_VkPipelineDynamicStateCreateInfo::operator=(const safe_VkPipelineDynamicStateCreateInfo& src)
{
    if (&src == this) return *this;

    if (pDynamicStates)
        delete[] pDynamicStates;
    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    flags = src.flags;
    dynamicStateCount = src.dynamicStateCount;
    pDynamicStates = nullptr;
    pNext = SafePnextCopy(src.pNext);
    if (src.pDynamicStates) {
        pDynamicStates = new VkDynamicState[src.dynamicStateCount];
        memcpy ((void *)pDynamicStates, (void *)src.pDynamicStates, sizeof(VkDynamicState)*src.dynamicStateCount);
    }

    return *this;
}

safe_VkPipelineDynamicStateCreateInfo::~safe_VkPipelineDynamicStateCreateInfo()
{
    if (pDynamicStates)
        delete[] pDynamicStates;
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPipelineDynamicStateCreateInfo::initialize(const VkPipelineDynamicStateCreateInfo* in_struct)
{
    sType = in_struct->sType;
    flags = in_struct->flags;
    dynamicStateCount = in_struct->dynamicStateCount;
    pDynamicStates = nullptr;
    pNext = SafePnextCopy(in_struct->pNext);
    if (in_struct->pDynamicStates) {
        pDynamicStates = new VkDynamicState[in_struct->dynamicStateCount];
        memcpy ((void *)pDynamicStates, (void *)in_struct->pDynamicStates, sizeof(VkDynamicState)*in_struct->dynamicStateCount);
    }
}

void safe_VkPipelineDynamicStateCreateInfo::initialize(const safe_VkPipelineDynamicStateCreateInfo* src)
{
    sType = src->sType;
    flags = src->flags;
    dynamicStateCount = src->dynamicStateCount;
    pDynamicStates = nullptr;
    pNext = SafePnextCopy(src->pNext);
    if (src->pDynamicStates) {
        pDynamicStates = new VkDynamicState[src->dynamicStateCount];
        memcpy ((void *)pDynamicStates, (void *)src->pDynamicStates, sizeof(VkDynamicState)*src->dynamicStateCount);
    }
}

safe_VkGraphicsPipelineCreateInfo::safe_VkGraphicsPipelineCreateInfo(const VkGraphicsPipelineCreateInfo* in_struct, const bool uses_color_attachment, const bool uses_depthstencil_attachment) :
    sType(in_struct->sType),
    flags(in_struct->flags),
    stageCount(in_struct->stageCount),
    pStages(nullptr),
    pVertexInputState(nullptr),
    pInputAssemblyState(nullptr),
    pTessellationState(nullptr),
    pViewportState(nullptr),
    pRasterizationState(nullptr),
    pMultisampleState(nullptr),
    pDepthStencilState(nullptr),
    pColorBlendState(nullptr),
    pDynamicState(nullptr),
    layout(in_struct->layout),
    renderPass(in_struct->renderPass),
    subpass(in_struct->subpass),
    basePipelineHandle(in_struct->basePipelineHandle),
    basePipelineIndex(in_struct->basePipelineIndex)
{
    pNext = SafePnextCopy(in_struct->pNext);
    if (stageCount && in_struct->pStages) {
        pStages = new safe_VkPipelineShaderStageCreateInfo[stageCount];
        for (uint32_t i = 0; i < stageCount; ++i) {
            pStages[i].initialize(&in_struct->pStages[i]);
        }
    }
    if (in_struct->pVertexInputState)
        pVertexInputState = new safe_VkPipelineVertexInputStateCreateInfo(in_struct->pVertexInputState);
    else
        pVertexInputState = NULL;
    if (in_struct->pInputAssemblyState)
        pInputAssemblyState = new safe_VkPipelineInputAssemblyStateCreateInfo(in_struct->pInputAssemblyState);
    else
        pInputAssemblyState = NULL;
    bool has_tessellation_stage = false;
    if (stageCount && pStages)
        for (uint32_t i = 0; i < stageCount && !has_tessellation_stage; ++i)
            if (pStages[i].stage == VK_SHADER_STAGE_TESSELLATION_CONTROL_BIT || pStages[i].stage == VK_SHADER_STAGE_TESSELLATION_EVALUATION_BIT)
                has_tessellation_stage = true;
    if (in_struct->pTessellationState && has_tessellation_stage)
        pTessellationState = new safe_VkPipelineTessellationStateCreateInfo(in_struct->pTessellationState);
    else
        pTessellationState = NULL; // original pTessellationState pointer ignored
    bool has_rasterization = in_struct->pRasterizationState ? !in_struct->pRasterizationState->rasterizerDiscardEnable : false;
    if (in_struct->pViewportState && has_rasterization) {
        bool is_dynamic_viewports = false;
        bool is_dynamic_scissors = false;
        if (in_struct->pDynamicState && in_struct->pDynamicState->pDynamicStates) {
            for (uint32_t i = 0; i < in_struct->pDynamicState->dynamicStateCount && !is_dynamic_viewports; ++i)
                if (in_struct->pDynamicState->pDynamicStates[i] == VK_DYNAMIC_STATE_VIEWPORT)
                    is_dynamic_viewports = true;
            for (uint32_t i = 0; i < in_struct->pDynamicState->dynamicStateCount && !is_dynamic_scissors; ++i)
                if (in_struct->pDynamicState->pDynamicStates[i] == VK_DYNAMIC_STATE_SCISSOR)
                    is_dynamic_scissors = true;
        }
        pViewportState = new safe_VkPipelineViewportStateCreateInfo(in_struct->pViewportState, is_dynamic_viewports, is_dynamic_scissors);
    } else
        pViewportState = NULL; // original pViewportState pointer ignored
    if (in_struct->pRasterizationState)
        pRasterizationState = new safe_VkPipelineRasterizationStateCreateInfo(in_struct->pRasterizationState);
    else
        pRasterizationState = NULL;
    if (in_struct->pMultisampleState && has_rasterization)
        pMultisampleState = new safe_VkPipelineMultisampleStateCreateInfo(in_struct->pMultisampleState);
    else
        pMultisampleState = NULL; // original pMultisampleState pointer ignored
    // needs a tracked subpass state uses_depthstencil_attachment
    if (in_struct->pDepthStencilState && has_rasterization && uses_depthstencil_attachment)
        pDepthStencilState = new safe_VkPipelineDepthStencilStateCreateInfo(in_struct->pDepthStencilState);
    else
        pDepthStencilState = NULL; // original pDepthStencilState pointer ignored
    // needs a tracked subpass state usesColorAttachment
    if (in_struct->pColorBlendState && has_rasterization && uses_color_attachment)
        pColorBlendState = new safe_VkPipelineColorBlendStateCreateInfo(in_struct->pColorBlendState);
    else
        pColorBlendState = NULL; // original pColorBlendState pointer ignored
    if (in_struct->pDynamicState)
        pDynamicState = new safe_VkPipelineDynamicStateCreateInfo(in_struct->pDynamicState);
    else
        pDynamicState = NULL;
}

safe_VkGraphicsPipelineCreateInfo::safe_VkGraphicsPipelineCreateInfo() :
    pNext(nullptr),
    pStages(nullptr),
    pVertexInputState(nullptr),
    pInputAssemblyState(nullptr),
    pTessellationState(nullptr),
    pViewportState(nullptr),
    pRasterizationState(nullptr),
    pMultisampleState(nullptr),
    pDepthStencilState(nullptr),
    pColorBlendState(nullptr),
    pDynamicState(nullptr)
{}

safe_VkGraphicsPipelineCreateInfo::safe_VkGraphicsPipelineCreateInfo(const safe_VkGraphicsPipelineCreateInfo& src)
{
    sType = src.sType;
    flags = src.flags;
    stageCount = src.stageCount;
    pStages = nullptr;
    pVertexInputState = nullptr;
    pInputAssemblyState = nullptr;
    pTessellationState = nullptr;
    pViewportState = nullptr;
    pRasterizationState = nullptr;
    pMultisampleState = nullptr;
    pDepthStencilState = nullptr;
    pColorBlendState = nullptr;
    pDynamicState = nullptr;
    layout = src.layout;
    renderPass = src.renderPass;
    subpass = src.subpass;
    basePipelineHandle = src.basePipelineHandle;
    basePipelineIndex = src.basePipelineIndex;
    pNext = SafePnextCopy(src.pNext);
    if (stageCount && src.pStages) {
        pStages = new safe_VkPipelineShaderStageCreateInfo[stageCount];
        for (uint32_t i = 0; i < stageCount; ++i) {
            pStages[i].initialize(&src.pStages[i]);
        }
    }
    if (src.pVertexInputState)
        pVertexInputState = new safe_VkPipelineVertexInputStateCreateInfo(*src.pVertexInputState);
    else
        pVertexInputState = NULL;
    if (src.pInputAssemblyState)
        pInputAssemblyState = new safe_VkPipelineInputAssemblyStateCreateInfo(*src.pInputAssemblyState);
    else
        pInputAssemblyState = NULL;
    bool has_tessellation_stage = false;
    if (stageCount && pStages)
        for (uint32_t i = 0; i < stageCount && !has_tessellation_stage; ++i)
            if (pStages[i].stage == VK_SHADER_STAGE_TESSELLATION_CONTROL_BIT || pStages[i].stage == VK_SHADER_STAGE_TESSELLATION_EVALUATION_BIT)
                has_tessellation_stage = true;
    if (src.pTessellationState && has_tessellation_stage)
        pTessellationState = new safe_VkPipelineTessellationStateCreateInfo(*src.pTessellationState);
    else
        pTessellationState = NULL; // original pTessellationState pointer ignored
    bool has_rasterization = src.pRasterizationState ? !src.pRasterizationState->rasterizerDiscardEnable : false;
    if (src.pViewportState && has_rasterization) {
        pViewportState = new safe_VkPipelineViewportStateCreateInfo(*src.pViewportState);
    } else
        pViewportState = NULL; // original pViewportState pointer ignored
    if (src.pRasterizationState)
        pRasterizationState = new safe_VkPipelineRasterizationStateCreateInfo(*src.pRasterizationState);
    else
        pRasterizationState = NULL;
    if (src.pMultisampleState && has_rasterization)
        pMultisampleState = new safe_VkPipelineMultisampleStateCreateInfo(*src.pMultisampleState);
    else
        pMultisampleState = NULL; // original pMultisampleState pointer ignored
    if (src.pDepthStencilState && has_rasterization)
        pDepthStencilState = new safe_VkPipelineDepthStencilStateCreateInfo(*src.pDepthStencilState);
    else
        pDepthStencilState = NULL; // original pDepthStencilState pointer ignored
    if (src.pColorBlendState && has_rasterization)
        pColorBlendState = new safe_VkPipelineColorBlendStateCreateInfo(*src.pColorBlendState);
    else
        pColorBlendState = NULL; // original pColorBlendState pointer ignored
    if (src.pDynamicState)
        pDynamicState = new safe_VkPipelineDynamicStateCreateInfo(*src.pDynamicState);
    else
        pDynamicState = NULL;
}

safe_VkGraphicsPipelineCreateInfo& safe_VkGraphicsPipelineCreateInfo::operator=(const safe_VkGraphicsPipelineCreateInfo& src)
{
    if (&src == this) return *this;

    if (pStages)
        delete[] pStages;
    if (pVertexInputState)
        delete pVertexInputState;
    if (pInputAssemblyState)
        delete pInputAssemblyState;
    if (pTessellationState)
        delete pTessellationState;
    if (pViewportState)
        delete pViewportState;
    if (pRasterizationState)
        delete pRasterizationState;
    if (pMultisampleState)
        delete pMultisampleState;
    if (pDepthStencilState)
        delete pDepthStencilState;
    if (pColorBlendState)
        delete pColorBlendState;
    if (pDynamicState)
        delete pDynamicState;
    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    flags = src.flags;
    stageCount = src.stageCount;
    pStages = nullptr;
    pVertexInputState = nullptr;
    pInputAssemblyState = nullptr;
    pTessellationState = nullptr;
    pViewportState = nullptr;
    pRasterizationState = nullptr;
    pMultisampleState = nullptr;
    pDepthStencilState = nullptr;
    pColorBlendState = nullptr;
    pDynamicState = nullptr;
    layout = src.layout;
    renderPass = src.renderPass;
    subpass = src.subpass;
    basePipelineHandle = src.basePipelineHandle;
    basePipelineIndex = src.basePipelineIndex;
    pNext = SafePnextCopy(src.pNext);
    if (stageCount && src.pStages) {
        pStages = new safe_VkPipelineShaderStageCreateInfo[stageCount];
        for (uint32_t i = 0; i < stageCount; ++i) {
            pStages[i].initialize(&src.pStages[i]);
        }
    }
    if (src.pVertexInputState)
        pVertexInputState = new safe_VkPipelineVertexInputStateCreateInfo(*src.pVertexInputState);
    else
        pVertexInputState = NULL;
    if (src.pInputAssemblyState)
        pInputAssemblyState = new safe_VkPipelineInputAssemblyStateCreateInfo(*src.pInputAssemblyState);
    else
        pInputAssemblyState = NULL;
    bool has_tessellation_stage = false;
    if (stageCount && pStages)
        for (uint32_t i = 0; i < stageCount && !has_tessellation_stage; ++i)
            if (pStages[i].stage == VK_SHADER_STAGE_TESSELLATION_CONTROL_BIT || pStages[i].stage == VK_SHADER_STAGE_TESSELLATION_EVALUATION_BIT)
                has_tessellation_stage = true;
    if (src.pTessellationState && has_tessellation_stage)
        pTessellationState = new safe_VkPipelineTessellationStateCreateInfo(*src.pTessellationState);
    else
        pTessellationState = NULL; // original pTessellationState pointer ignored
    bool has_rasterization = src.pRasterizationState ? !src.pRasterizationState->rasterizerDiscardEnable : false;
    if (src.pViewportState && has_rasterization) {
        pViewportState = new safe_VkPipelineViewportStateCreateInfo(*src.pViewportState);
    } else
        pViewportState = NULL; // original pViewportState pointer ignored
    if (src.pRasterizationState)
        pRasterizationState = new safe_VkPipelineRasterizationStateCreateInfo(*src.pRasterizationState);
    else
        pRasterizationState = NULL;
    if (src.pMultisampleState && has_rasterization)
        pMultisampleState = new safe_VkPipelineMultisampleStateCreateInfo(*src.pMultisampleState);
    else
        pMultisampleState = NULL; // original pMultisampleState pointer ignored
    if (src.pDepthStencilState && has_rasterization)
        pDepthStencilState = new safe_VkPipelineDepthStencilStateCreateInfo(*src.pDepthStencilState);
    else
        pDepthStencilState = NULL; // original pDepthStencilState pointer ignored
    if (src.pColorBlendState && has_rasterization)
        pColorBlendState = new safe_VkPipelineColorBlendStateCreateInfo(*src.pColorBlendState);
    else
        pColorBlendState = NULL; // original pColorBlendState pointer ignored
    if (src.pDynamicState)
        pDynamicState = new safe_VkPipelineDynamicStateCreateInfo(*src.pDynamicState);
    else
        pDynamicState = NULL;

    return *this;
}

safe_VkGraphicsPipelineCreateInfo::~safe_VkGraphicsPipelineCreateInfo()
{
    if (pStages)
        delete[] pStages;
    if (pVertexInputState)
        delete pVertexInputState;
    if (pInputAssemblyState)
        delete pInputAssemblyState;
    if (pTessellationState)
        delete pTessellationState;
    if (pViewportState)
        delete pViewportState;
    if (pRasterizationState)
        delete pRasterizationState;
    if (pMultisampleState)
        delete pMultisampleState;
    if (pDepthStencilState)
        delete pDepthStencilState;
    if (pColorBlendState)
        delete pColorBlendState;
    if (pDynamicState)
        delete pDynamicState;
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkGraphicsPipelineCreateInfo::initialize(const VkGraphicsPipelineCreateInfo* in_struct, const bool uses_color_attachment, const bool uses_depthstencil_attachment)
{
    sType = in_struct->sType;
    flags = in_struct->flags;
    stageCount = in_struct->stageCount;
    pStages = nullptr;
    pVertexInputState = nullptr;
    pInputAssemblyState = nullptr;
    pTessellationState = nullptr;
    pViewportState = nullptr;
    pRasterizationState = nullptr;
    pMultisampleState = nullptr;
    pDepthStencilState = nullptr;
    pColorBlendState = nullptr;
    pDynamicState = nullptr;
    layout = in_struct->layout;
    renderPass = in_struct->renderPass;
    subpass = in_struct->subpass;
    basePipelineHandle = in_struct->basePipelineHandle;
    basePipelineIndex = in_struct->basePipelineIndex;
    pNext = SafePnextCopy(in_struct->pNext);
    if (stageCount && in_struct->pStages) {
        pStages = new safe_VkPipelineShaderStageCreateInfo[stageCount];
        for (uint32_t i = 0; i < stageCount; ++i) {
            pStages[i].initialize(&in_struct->pStages[i]);
        }
    }
    if (in_struct->pVertexInputState)
        pVertexInputState = new safe_VkPipelineVertexInputStateCreateInfo(in_struct->pVertexInputState);
    else
        pVertexInputState = NULL;
    if (in_struct->pInputAssemblyState)
        pInputAssemblyState = new safe_VkPipelineInputAssemblyStateCreateInfo(in_struct->pInputAssemblyState);
    else
        pInputAssemblyState = NULL;
    bool has_tessellation_stage = false;
    if (stageCount && pStages)
        for (uint32_t i = 0; i < stageCount && !has_tessellation_stage; ++i)
            if (pStages[i].stage == VK_SHADER_STAGE_TESSELLATION_CONTROL_BIT || pStages[i].stage == VK_SHADER_STAGE_TESSELLATION_EVALUATION_BIT)
                has_tessellation_stage = true;
    if (in_struct->pTessellationState && has_tessellation_stage)
        pTessellationState = new safe_VkPipelineTessellationStateCreateInfo(in_struct->pTessellationState);
    else
        pTessellationState = NULL; // original pTessellationState pointer ignored
    bool has_rasterization = in_struct->pRasterizationState ? !in_struct->pRasterizationState->rasterizerDiscardEnable : false;
    if (in_struct->pViewportState && has_rasterization) {
        bool is_dynamic_viewports = false;
        bool is_dynamic_scissors = false;
        if (in_struct->pDynamicState && in_struct->pDynamicState->pDynamicStates) {
            for (uint32_t i = 0; i < in_struct->pDynamicState->dynamicStateCount && !is_dynamic_viewports; ++i)
                if (in_struct->pDynamicState->pDynamicStates[i] == VK_DYNAMIC_STATE_VIEWPORT)
                    is_dynamic_viewports = true;
            for (uint32_t i = 0; i < in_struct->pDynamicState->dynamicStateCount && !is_dynamic_scissors; ++i)
                if (in_struct->pDynamicState->pDynamicStates[i] == VK_DYNAMIC_STATE_SCISSOR)
                    is_dynamic_scissors = true;
        }
        pViewportState = new safe_VkPipelineViewportStateCreateInfo(in_struct->pViewportState, is_dynamic_viewports, is_dynamic_scissors);
    } else
        pViewportState = NULL; // original pViewportState pointer ignored
    if (in_struct->pRasterizationState)
        pRasterizationState = new safe_VkPipelineRasterizationStateCreateInfo(in_struct->pRasterizationState);
    else
        pRasterizationState = NULL;
    if (in_struct->pMultisampleState && has_rasterization)
        pMultisampleState = new safe_VkPipelineMultisampleStateCreateInfo(in_struct->pMultisampleState);
    else
        pMultisampleState = NULL; // original pMultisampleState pointer ignored
    // needs a tracked subpass state uses_depthstencil_attachment
    if (in_struct->pDepthStencilState && has_rasterization && uses_depthstencil_attachment)
        pDepthStencilState = new safe_VkPipelineDepthStencilStateCreateInfo(in_struct->pDepthStencilState);
    else
        pDepthStencilState = NULL; // original pDepthStencilState pointer ignored
    // needs a tracked subpass state usesColorAttachment
    if (in_struct->pColorBlendState && has_rasterization && uses_color_attachment)
        pColorBlendState = new safe_VkPipelineColorBlendStateCreateInfo(in_struct->pColorBlendState);
    else
        pColorBlendState = NULL; // original pColorBlendState pointer ignored
    if (in_struct->pDynamicState)
        pDynamicState = new safe_VkPipelineDynamicStateCreateInfo(in_struct->pDynamicState);
    else
        pDynamicState = NULL;
}

void safe_VkGraphicsPipelineCreateInfo::initialize(const safe_VkGraphicsPipelineCreateInfo* src)
{
    sType = src->sType;
    flags = src->flags;
    stageCount = src->stageCount;
    pStages = nullptr;
    pVertexInputState = nullptr;
    pInputAssemblyState = nullptr;
    pTessellationState = nullptr;
    pViewportState = nullptr;
    pRasterizationState = nullptr;
    pMultisampleState = nullptr;
    pDepthStencilState = nullptr;
    pColorBlendState = nullptr;
    pDynamicState = nullptr;
    layout = src->layout;
    renderPass = src->renderPass;
    subpass = src->subpass;
    basePipelineHandle = src->basePipelineHandle;
    basePipelineIndex = src->basePipelineIndex;
    pNext = SafePnextCopy(src->pNext);
    if (stageCount && src->pStages) {
        pStages = new safe_VkPipelineShaderStageCreateInfo[stageCount];
        for (uint32_t i = 0; i < stageCount; ++i) {
            pStages[i].initialize(&src->pStages[i]);
        }
    }
    if (src->pVertexInputState)
        pVertexInputState = new safe_VkPipelineVertexInputStateCreateInfo(*src->pVertexInputState);
    else
        pVertexInputState = NULL;
    if (src->pInputAssemblyState)
        pInputAssemblyState = new safe_VkPipelineInputAssemblyStateCreateInfo(*src->pInputAssemblyState);
    else
        pInputAssemblyState = NULL;
    bool has_tessellation_stage = false;
    if (stageCount && pStages)
        for (uint32_t i = 0; i < stageCount && !has_tessellation_stage; ++i)
            if (pStages[i].stage == VK_SHADER_STAGE_TESSELLATION_CONTROL_BIT || pStages[i].stage == VK_SHADER_STAGE_TESSELLATION_EVALUATION_BIT)
                has_tessellation_stage = true;
    if (src->pTessellationState && has_tessellation_stage)
        pTessellationState = new safe_VkPipelineTessellationStateCreateInfo(*src->pTessellationState);
    else
        pTessellationState = NULL; // original pTessellationState pointer ignored
    bool has_rasterization = src->pRasterizationState ? !src->pRasterizationState->rasterizerDiscardEnable : false;
    if (src->pViewportState && has_rasterization) {
        pViewportState = new safe_VkPipelineViewportStateCreateInfo(*src->pViewportState);
    } else
        pViewportState = NULL; // original pViewportState pointer ignored
    if (src->pRasterizationState)
        pRasterizationState = new safe_VkPipelineRasterizationStateCreateInfo(*src->pRasterizationState);
    else
        pRasterizationState = NULL;
    if (src->pMultisampleState && has_rasterization)
        pMultisampleState = new safe_VkPipelineMultisampleStateCreateInfo(*src->pMultisampleState);
    else
        pMultisampleState = NULL; // original pMultisampleState pointer ignored
    if (src->pDepthStencilState && has_rasterization)
        pDepthStencilState = new safe_VkPipelineDepthStencilStateCreateInfo(*src->pDepthStencilState);
    else
        pDepthStencilState = NULL; // original pDepthStencilState pointer ignored
    if (src->pColorBlendState && has_rasterization)
        pColorBlendState = new safe_VkPipelineColorBlendStateCreateInfo(*src->pColorBlendState);
    else
        pColorBlendState = NULL; // original pColorBlendState pointer ignored
    if (src->pDynamicState)
        pDynamicState = new safe_VkPipelineDynamicStateCreateInfo(*src->pDynamicState);
    else
        pDynamicState = NULL;
}

safe_VkComputePipelineCreateInfo::safe_VkComputePipelineCreateInfo(const VkComputePipelineCreateInfo* in_struct) :
    sType(in_struct->sType),
    flags(in_struct->flags),
    stage(&in_struct->stage),
    layout(in_struct->layout),
    basePipelineHandle(in_struct->basePipelineHandle),
    basePipelineIndex(in_struct->basePipelineIndex)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkComputePipelineCreateInfo::safe_VkComputePipelineCreateInfo() :
    pNext(nullptr)
{}

safe_VkComputePipelineCreateInfo::safe_VkComputePipelineCreateInfo(const safe_VkComputePipelineCreateInfo& src)
{
    sType = src.sType;
    flags = src.flags;
    stage.initialize(&src.stage);
    layout = src.layout;
    basePipelineHandle = src.basePipelineHandle;
    basePipelineIndex = src.basePipelineIndex;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkComputePipelineCreateInfo& safe_VkComputePipelineCreateInfo::operator=(const safe_VkComputePipelineCreateInfo& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    flags = src.flags;
    stage.initialize(&src.stage);
    layout = src.layout;
    basePipelineHandle = src.basePipelineHandle;
    basePipelineIndex = src.basePipelineIndex;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkComputePipelineCreateInfo::~safe_VkComputePipelineCreateInfo()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkComputePipelineCreateInfo::initialize(const VkComputePipelineCreateInfo* in_struct)
{
    sType = in_struct->sType;
    flags = in_struct->flags;
    stage.initialize(&in_struct->stage);
    layout = in_struct->layout;
    basePipelineHandle = in_struct->basePipelineHandle;
    basePipelineIndex = in_struct->basePipelineIndex;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkComputePipelineCreateInfo::initialize(const safe_VkComputePipelineCreateInfo* src)
{
    sType = src->sType;
    flags = src->flags;
    stage.initialize(&src->stage);
    layout = src->layout;
    basePipelineHandle = src->basePipelineHandle;
    basePipelineIndex = src->basePipelineIndex;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkPipelineLayoutCreateInfo::safe_VkPipelineLayoutCreateInfo(const VkPipelineLayoutCreateInfo* in_struct) :
    sType(in_struct->sType),
    flags(in_struct->flags),
    setLayoutCount(in_struct->setLayoutCount),
    pSetLayouts(nullptr),
    pushConstantRangeCount(in_struct->pushConstantRangeCount),
    pPushConstantRanges(nullptr)
{
    pNext = SafePnextCopy(in_struct->pNext);
    if (setLayoutCount && in_struct->pSetLayouts) {
        pSetLayouts = new VkDescriptorSetLayout[setLayoutCount];
        for (uint32_t i = 0; i < setLayoutCount; ++i) {
            pSetLayouts[i] = in_struct->pSetLayouts[i];
        }
    }
    if (in_struct->pPushConstantRanges) {
        pPushConstantRanges = new VkPushConstantRange[in_struct->pushConstantRangeCount];
        memcpy ((void *)pPushConstantRanges, (void *)in_struct->pPushConstantRanges, sizeof(VkPushConstantRange)*in_struct->pushConstantRangeCount);
    }
}

safe_VkPipelineLayoutCreateInfo::safe_VkPipelineLayoutCreateInfo() :
    pNext(nullptr),
    pSetLayouts(nullptr),
    pPushConstantRanges(nullptr)
{}

safe_VkPipelineLayoutCreateInfo::safe_VkPipelineLayoutCreateInfo(const safe_VkPipelineLayoutCreateInfo& src)
{
    sType = src.sType;
    flags = src.flags;
    setLayoutCount = src.setLayoutCount;
    pSetLayouts = nullptr;
    pushConstantRangeCount = src.pushConstantRangeCount;
    pPushConstantRanges = nullptr;
    pNext = SafePnextCopy(src.pNext);
    if (setLayoutCount && src.pSetLayouts) {
        pSetLayouts = new VkDescriptorSetLayout[setLayoutCount];
        for (uint32_t i = 0; i < setLayoutCount; ++i) {
            pSetLayouts[i] = src.pSetLayouts[i];
        }
    }
    if (src.pPushConstantRanges) {
        pPushConstantRanges = new VkPushConstantRange[src.pushConstantRangeCount];
        memcpy ((void *)pPushConstantRanges, (void *)src.pPushConstantRanges, sizeof(VkPushConstantRange)*src.pushConstantRangeCount);
    }
}

safe_VkPipelineLayoutCreateInfo& safe_VkPipelineLayoutCreateInfo::operator=(const safe_VkPipelineLayoutCreateInfo& src)
{
    if (&src == this) return *this;

    if (pSetLayouts)
        delete[] pSetLayouts;
    if (pPushConstantRanges)
        delete[] pPushConstantRanges;
    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    flags = src.flags;
    setLayoutCount = src.setLayoutCount;
    pSetLayouts = nullptr;
    pushConstantRangeCount = src.pushConstantRangeCount;
    pPushConstantRanges = nullptr;
    pNext = SafePnextCopy(src.pNext);
    if (setLayoutCount && src.pSetLayouts) {
        pSetLayouts = new VkDescriptorSetLayout[setLayoutCount];
        for (uint32_t i = 0; i < setLayoutCount; ++i) {
            pSetLayouts[i] = src.pSetLayouts[i];
        }
    }
    if (src.pPushConstantRanges) {
        pPushConstantRanges = new VkPushConstantRange[src.pushConstantRangeCount];
        memcpy ((void *)pPushConstantRanges, (void *)src.pPushConstantRanges, sizeof(VkPushConstantRange)*src.pushConstantRangeCount);
    }

    return *this;
}

safe_VkPipelineLayoutCreateInfo::~safe_VkPipelineLayoutCreateInfo()
{
    if (pSetLayouts)
        delete[] pSetLayouts;
    if (pPushConstantRanges)
        delete[] pPushConstantRanges;
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPipelineLayoutCreateInfo::initialize(const VkPipelineLayoutCreateInfo* in_struct)
{
    sType = in_struct->sType;
    flags = in_struct->flags;
    setLayoutCount = in_struct->setLayoutCount;
    pSetLayouts = nullptr;
    pushConstantRangeCount = in_struct->pushConstantRangeCount;
    pPushConstantRanges = nullptr;
    pNext = SafePnextCopy(in_struct->pNext);
    if (setLayoutCount && in_struct->pSetLayouts) {
        pSetLayouts = new VkDescriptorSetLayout[setLayoutCount];
        for (uint32_t i = 0; i < setLayoutCount; ++i) {
            pSetLayouts[i] = in_struct->pSetLayouts[i];
        }
    }
    if (in_struct->pPushConstantRanges) {
        pPushConstantRanges = new VkPushConstantRange[in_struct->pushConstantRangeCount];
        memcpy ((void *)pPushConstantRanges, (void *)in_struct->pPushConstantRanges, sizeof(VkPushConstantRange)*in_struct->pushConstantRangeCount);
    }
}

void safe_VkPipelineLayoutCreateInfo::initialize(const safe_VkPipelineLayoutCreateInfo* src)
{
    sType = src->sType;
    flags = src->flags;
    setLayoutCount = src->setLayoutCount;
    pSetLayouts = nullptr;
    pushConstantRangeCount = src->pushConstantRangeCount;
    pPushConstantRanges = nullptr;
    pNext = SafePnextCopy(src->pNext);
    if (setLayoutCount && src->pSetLayouts) {
        pSetLayouts = new VkDescriptorSetLayout[setLayoutCount];
        for (uint32_t i = 0; i < setLayoutCount; ++i) {
            pSetLayouts[i] = src->pSetLayouts[i];
        }
    }
    if (src->pPushConstantRanges) {
        pPushConstantRanges = new VkPushConstantRange[src->pushConstantRangeCount];
        memcpy ((void *)pPushConstantRanges, (void *)src->pPushConstantRanges, sizeof(VkPushConstantRange)*src->pushConstantRangeCount);
    }
}

safe_VkSamplerCreateInfo::safe_VkSamplerCreateInfo(const VkSamplerCreateInfo* in_struct) :
    sType(in_struct->sType),
    flags(in_struct->flags),
    magFilter(in_struct->magFilter),
    minFilter(in_struct->minFilter),
    mipmapMode(in_struct->mipmapMode),
    addressModeU(in_struct->addressModeU),
    addressModeV(in_struct->addressModeV),
    addressModeW(in_struct->addressModeW),
    mipLodBias(in_struct->mipLodBias),
    anisotropyEnable(in_struct->anisotropyEnable),
    maxAnisotropy(in_struct->maxAnisotropy),
    compareEnable(in_struct->compareEnable),
    compareOp(in_struct->compareOp),
    minLod(in_struct->minLod),
    maxLod(in_struct->maxLod),
    borderColor(in_struct->borderColor),
    unnormalizedCoordinates(in_struct->unnormalizedCoordinates)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkSamplerCreateInfo::safe_VkSamplerCreateInfo() :
    pNext(nullptr)
{}

safe_VkSamplerCreateInfo::safe_VkSamplerCreateInfo(const safe_VkSamplerCreateInfo& src)
{
    sType = src.sType;
    flags = src.flags;
    magFilter = src.magFilter;
    minFilter = src.minFilter;
    mipmapMode = src.mipmapMode;
    addressModeU = src.addressModeU;
    addressModeV = src.addressModeV;
    addressModeW = src.addressModeW;
    mipLodBias = src.mipLodBias;
    anisotropyEnable = src.anisotropyEnable;
    maxAnisotropy = src.maxAnisotropy;
    compareEnable = src.compareEnable;
    compareOp = src.compareOp;
    minLod = src.minLod;
    maxLod = src.maxLod;
    borderColor = src.borderColor;
    unnormalizedCoordinates = src.unnormalizedCoordinates;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkSamplerCreateInfo& safe_VkSamplerCreateInfo::operator=(const safe_VkSamplerCreateInfo& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    flags = src.flags;
    magFilter = src.magFilter;
    minFilter = src.minFilter;
    mipmapMode = src.mipmapMode;
    addressModeU = src.addressModeU;
    addressModeV = src.addressModeV;
    addressModeW = src.addressModeW;
    mipLodBias = src.mipLodBias;
    anisotropyEnable = src.anisotropyEnable;
    maxAnisotropy = src.maxAnisotropy;
    compareEnable = src.compareEnable;
    compareOp = src.compareOp;
    minLod = src.minLod;
    maxLod = src.maxLod;
    borderColor = src.borderColor;
    unnormalizedCoordinates = src.unnormalizedCoordinates;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkSamplerCreateInfo::~safe_VkSamplerCreateInfo()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkSamplerCreateInfo::initialize(const VkSamplerCreateInfo* in_struct)
{
    sType = in_struct->sType;
    flags = in_struct->flags;
    magFilter = in_struct->magFilter;
    minFilter = in_struct->minFilter;
    mipmapMode = in_struct->mipmapMode;
    addressModeU = in_struct->addressModeU;
    addressModeV = in_struct->addressModeV;
    addressModeW = in_struct->addressModeW;
    mipLodBias = in_struct->mipLodBias;
    anisotropyEnable = in_struct->anisotropyEnable;
    maxAnisotropy = in_struct->maxAnisotropy;
    compareEnable = in_struct->compareEnable;
    compareOp = in_struct->compareOp;
    minLod = in_struct->minLod;
    maxLod = in_struct->maxLod;
    borderColor = in_struct->borderColor;
    unnormalizedCoordinates = in_struct->unnormalizedCoordinates;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkSamplerCreateInfo::initialize(const safe_VkSamplerCreateInfo* src)
{
    sType = src->sType;
    flags = src->flags;
    magFilter = src->magFilter;
    minFilter = src->minFilter;
    mipmapMode = src->mipmapMode;
    addressModeU = src->addressModeU;
    addressModeV = src->addressModeV;
    addressModeW = src->addressModeW;
    mipLodBias = src->mipLodBias;
    anisotropyEnable = src->anisotropyEnable;
    maxAnisotropy = src->maxAnisotropy;
    compareEnable = src->compareEnable;
    compareOp = src->compareOp;
    minLod = src->minLod;
    maxLod = src->maxLod;
    borderColor = src->borderColor;
    unnormalizedCoordinates = src->unnormalizedCoordinates;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkDescriptorSetLayoutBinding::safe_VkDescriptorSetLayoutBinding(const VkDescriptorSetLayoutBinding* in_struct) :
    binding(in_struct->binding),
    descriptorType(in_struct->descriptorType),
    descriptorCount(in_struct->descriptorCount),
    stageFlags(in_struct->stageFlags),
    pImmutableSamplers(nullptr)
{
    const bool sampler_type = in_struct->descriptorType == VK_DESCRIPTOR_TYPE_SAMPLER || in_struct->descriptorType == VK_DESCRIPTOR_TYPE_COMBINED_IMAGE_SAMPLER;
    if (descriptorCount && in_struct->pImmutableSamplers && sampler_type) {
        pImmutableSamplers = new VkSampler[descriptorCount];
        for (uint32_t i = 0; i < descriptorCount; ++i) {
            pImmutableSamplers[i] = in_struct->pImmutableSamplers[i];
        }
    }
}

safe_VkDescriptorSetLayoutBinding::safe_VkDescriptorSetLayoutBinding() :
    pImmutableSamplers(nullptr)
{}

safe_VkDescriptorSetLayoutBinding::safe_VkDescriptorSetLayoutBinding(const safe_VkDescriptorSetLayoutBinding& src)
{
    binding = src.binding;
    descriptorType = src.descriptorType;
    descriptorCount = src.descriptorCount;
    stageFlags = src.stageFlags;
    pImmutableSamplers = nullptr;
    const bool sampler_type = src.descriptorType == VK_DESCRIPTOR_TYPE_SAMPLER || src.descriptorType == VK_DESCRIPTOR_TYPE_COMBINED_IMAGE_SAMPLER;
    if (descriptorCount && src.pImmutableSamplers && sampler_type) {
        pImmutableSamplers = new VkSampler[descriptorCount];
        for (uint32_t i = 0; i < descriptorCount; ++i) {
            pImmutableSamplers[i] = src.pImmutableSamplers[i];
        }
    }
}

safe_VkDescriptorSetLayoutBinding& safe_VkDescriptorSetLayoutBinding::operator=(const safe_VkDescriptorSetLayoutBinding& src)
{
    if (&src == this) return *this;

    if (pImmutableSamplers)
        delete[] pImmutableSamplers;

    binding = src.binding;
    descriptorType = src.descriptorType;
    descriptorCount = src.descriptorCount;
    stageFlags = src.stageFlags;
    pImmutableSamplers = nullptr;
    const bool sampler_type = src.descriptorType == VK_DESCRIPTOR_TYPE_SAMPLER || src.descriptorType == VK_DESCRIPTOR_TYPE_COMBINED_IMAGE_SAMPLER;
    if (descriptorCount && src.pImmutableSamplers && sampler_type) {
        pImmutableSamplers = new VkSampler[descriptorCount];
        for (uint32_t i = 0; i < descriptorCount; ++i) {
            pImmutableSamplers[i] = src.pImmutableSamplers[i];
        }
    }

    return *this;
}

safe_VkDescriptorSetLayoutBinding::~safe_VkDescriptorSetLayoutBinding()
{
    if (pImmutableSamplers)
        delete[] pImmutableSamplers;
}

void safe_VkDescriptorSetLayoutBinding::initialize(const VkDescriptorSetLayoutBinding* in_struct)
{
    binding = in_struct->binding;
    descriptorType = in_struct->descriptorType;
    descriptorCount = in_struct->descriptorCount;
    stageFlags = in_struct->stageFlags;
    pImmutableSamplers = nullptr;
    const bool sampler_type = in_struct->descriptorType == VK_DESCRIPTOR_TYPE_SAMPLER || in_struct->descriptorType == VK_DESCRIPTOR_TYPE_COMBINED_IMAGE_SAMPLER;
    if (descriptorCount && in_struct->pImmutableSamplers && sampler_type) {
        pImmutableSamplers = new VkSampler[descriptorCount];
        for (uint32_t i = 0; i < descriptorCount; ++i) {
            pImmutableSamplers[i] = in_struct->pImmutableSamplers[i];
        }
    }
}

void safe_VkDescriptorSetLayoutBinding::initialize(const safe_VkDescriptorSetLayoutBinding* src)
{
    binding = src->binding;
    descriptorType = src->descriptorType;
    descriptorCount = src->descriptorCount;
    stageFlags = src->stageFlags;
    pImmutableSamplers = nullptr;
    const bool sampler_type = src->descriptorType == VK_DESCRIPTOR_TYPE_SAMPLER || src->descriptorType == VK_DESCRIPTOR_TYPE_COMBINED_IMAGE_SAMPLER;
    if (descriptorCount && src->pImmutableSamplers && sampler_type) {
        pImmutableSamplers = new VkSampler[descriptorCount];
        for (uint32_t i = 0; i < descriptorCount; ++i) {
            pImmutableSamplers[i] = src->pImmutableSamplers[i];
        }
    }
}

safe_VkDescriptorSetLayoutCreateInfo::safe_VkDescriptorSetLayoutCreateInfo(const VkDescriptorSetLayoutCreateInfo* in_struct) :
    sType(in_struct->sType),
    flags(in_struct->flags),
    bindingCount(in_struct->bindingCount),
    pBindings(nullptr)
{
    pNext = SafePnextCopy(in_struct->pNext);
    if (bindingCount && in_struct->pBindings) {
        pBindings = new safe_VkDescriptorSetLayoutBinding[bindingCount];
        for (uint32_t i = 0; i < bindingCount; ++i) {
            pBindings[i].initialize(&in_struct->pBindings[i]);
        }
    }
}

safe_VkDescriptorSetLayoutCreateInfo::safe_VkDescriptorSetLayoutCreateInfo() :
    pNext(nullptr),
    pBindings(nullptr)
{}

safe_VkDescriptorSetLayoutCreateInfo::safe_VkDescriptorSetLayoutCreateInfo(const safe_VkDescriptorSetLayoutCreateInfo& src)
{
    sType = src.sType;
    flags = src.flags;
    bindingCount = src.bindingCount;
    pBindings = nullptr;
    pNext = SafePnextCopy(src.pNext);
    if (bindingCount && src.pBindings) {
        pBindings = new safe_VkDescriptorSetLayoutBinding[bindingCount];
        for (uint32_t i = 0; i < bindingCount; ++i) {
            pBindings[i].initialize(&src.pBindings[i]);
        }
    }
}

safe_VkDescriptorSetLayoutCreateInfo& safe_VkDescriptorSetLayoutCreateInfo::operator=(const safe_VkDescriptorSetLayoutCreateInfo& src)
{
    if (&src == this) return *this;

    if (pBindings)
        delete[] pBindings;
    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    flags = src.flags;
    bindingCount = src.bindingCount;
    pBindings = nullptr;
    pNext = SafePnextCopy(src.pNext);
    if (bindingCount && src.pBindings) {
        pBindings = new safe_VkDescriptorSetLayoutBinding[bindingCount];
        for (uint32_t i = 0; i < bindingCount; ++i) {
            pBindings[i].initialize(&src.pBindings[i]);
        }
    }

    return *this;
}

safe_VkDescriptorSetLayoutCreateInfo::~safe_VkDescriptorSetLayoutCreateInfo()
{
    if (pBindings)
        delete[] pBindings;
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkDescriptorSetLayoutCreateInfo::initialize(const VkDescriptorSetLayoutCreateInfo* in_struct)
{
    sType = in_struct->sType;
    flags = in_struct->flags;
    bindingCount = in_struct->bindingCount;
    pBindings = nullptr;
    pNext = SafePnextCopy(in_struct->pNext);
    if (bindingCount && in_struct->pBindings) {
        pBindings = new safe_VkDescriptorSetLayoutBinding[bindingCount];
        for (uint32_t i = 0; i < bindingCount; ++i) {
            pBindings[i].initialize(&in_struct->pBindings[i]);
        }
    }
}

void safe_VkDescriptorSetLayoutCreateInfo::initialize(const safe_VkDescriptorSetLayoutCreateInfo* src)
{
    sType = src->sType;
    flags = src->flags;
    bindingCount = src->bindingCount;
    pBindings = nullptr;
    pNext = SafePnextCopy(src->pNext);
    if (bindingCount && src->pBindings) {
        pBindings = new safe_VkDescriptorSetLayoutBinding[bindingCount];
        for (uint32_t i = 0; i < bindingCount; ++i) {
            pBindings[i].initialize(&src->pBindings[i]);
        }
    }
}

safe_VkDescriptorPoolCreateInfo::safe_VkDescriptorPoolCreateInfo(const VkDescriptorPoolCreateInfo* in_struct) :
    sType(in_struct->sType),
    flags(in_struct->flags),
    maxSets(in_struct->maxSets),
    poolSizeCount(in_struct->poolSizeCount),
    pPoolSizes(nullptr)
{
    pNext = SafePnextCopy(in_struct->pNext);
    if (in_struct->pPoolSizes) {
        pPoolSizes = new VkDescriptorPoolSize[in_struct->poolSizeCount];
        memcpy ((void *)pPoolSizes, (void *)in_struct->pPoolSizes, sizeof(VkDescriptorPoolSize)*in_struct->poolSizeCount);
    }
}

safe_VkDescriptorPoolCreateInfo::safe_VkDescriptorPoolCreateInfo() :
    pNext(nullptr),
    pPoolSizes(nullptr)
{}

safe_VkDescriptorPoolCreateInfo::safe_VkDescriptorPoolCreateInfo(const safe_VkDescriptorPoolCreateInfo& src)
{
    sType = src.sType;
    flags = src.flags;
    maxSets = src.maxSets;
    poolSizeCount = src.poolSizeCount;
    pPoolSizes = nullptr;
    pNext = SafePnextCopy(src.pNext);
    if (src.pPoolSizes) {
        pPoolSizes = new VkDescriptorPoolSize[src.poolSizeCount];
        memcpy ((void *)pPoolSizes, (void *)src.pPoolSizes, sizeof(VkDescriptorPoolSize)*src.poolSizeCount);
    }
}

safe_VkDescriptorPoolCreateInfo& safe_VkDescriptorPoolCreateInfo::operator=(const safe_VkDescriptorPoolCreateInfo& src)
{
    if (&src == this) return *this;

    if (pPoolSizes)
        delete[] pPoolSizes;
    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    flags = src.flags;
    maxSets = src.maxSets;
    poolSizeCount = src.poolSizeCount;
    pPoolSizes = nullptr;
    pNext = SafePnextCopy(src.pNext);
    if (src.pPoolSizes) {
        pPoolSizes = new VkDescriptorPoolSize[src.poolSizeCount];
        memcpy ((void *)pPoolSizes, (void *)src.pPoolSizes, sizeof(VkDescriptorPoolSize)*src.poolSizeCount);
    }

    return *this;
}

safe_VkDescriptorPoolCreateInfo::~safe_VkDescriptorPoolCreateInfo()
{
    if (pPoolSizes)
        delete[] pPoolSizes;
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkDescriptorPoolCreateInfo::initialize(const VkDescriptorPoolCreateInfo* in_struct)
{
    sType = in_struct->sType;
    flags = in_struct->flags;
    maxSets = in_struct->maxSets;
    poolSizeCount = in_struct->poolSizeCount;
    pPoolSizes = nullptr;
    pNext = SafePnextCopy(in_struct->pNext);
    if (in_struct->pPoolSizes) {
        pPoolSizes = new VkDescriptorPoolSize[in_struct->poolSizeCount];
        memcpy ((void *)pPoolSizes, (void *)in_struct->pPoolSizes, sizeof(VkDescriptorPoolSize)*in_struct->poolSizeCount);
    }
}

void safe_VkDescriptorPoolCreateInfo::initialize(const safe_VkDescriptorPoolCreateInfo* src)
{
    sType = src->sType;
    flags = src->flags;
    maxSets = src->maxSets;
    poolSizeCount = src->poolSizeCount;
    pPoolSizes = nullptr;
    pNext = SafePnextCopy(src->pNext);
    if (src->pPoolSizes) {
        pPoolSizes = new VkDescriptorPoolSize[src->poolSizeCount];
        memcpy ((void *)pPoolSizes, (void *)src->pPoolSizes, sizeof(VkDescriptorPoolSize)*src->poolSizeCount);
    }
}

safe_VkDescriptorSetAllocateInfo::safe_VkDescriptorSetAllocateInfo(const VkDescriptorSetAllocateInfo* in_struct) :
    sType(in_struct->sType),
    descriptorPool(in_struct->descriptorPool),
    descriptorSetCount(in_struct->descriptorSetCount),
    pSetLayouts(nullptr)
{
    pNext = SafePnextCopy(in_struct->pNext);
    if (descriptorSetCount && in_struct->pSetLayouts) {
        pSetLayouts = new VkDescriptorSetLayout[descriptorSetCount];
        for (uint32_t i = 0; i < descriptorSetCount; ++i) {
            pSetLayouts[i] = in_struct->pSetLayouts[i];
        }
    }
}

safe_VkDescriptorSetAllocateInfo::safe_VkDescriptorSetAllocateInfo() :
    pNext(nullptr),
    pSetLayouts(nullptr)
{}

safe_VkDescriptorSetAllocateInfo::safe_VkDescriptorSetAllocateInfo(const safe_VkDescriptorSetAllocateInfo& src)
{
    sType = src.sType;
    descriptorPool = src.descriptorPool;
    descriptorSetCount = src.descriptorSetCount;
    pSetLayouts = nullptr;
    pNext = SafePnextCopy(src.pNext);
    if (descriptorSetCount && src.pSetLayouts) {
        pSetLayouts = new VkDescriptorSetLayout[descriptorSetCount];
        for (uint32_t i = 0; i < descriptorSetCount; ++i) {
            pSetLayouts[i] = src.pSetLayouts[i];
        }
    }
}

safe_VkDescriptorSetAllocateInfo& safe_VkDescriptorSetAllocateInfo::operator=(const safe_VkDescriptorSetAllocateInfo& src)
{
    if (&src == this) return *this;

    if (pSetLayouts)
        delete[] pSetLayouts;
    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    descriptorPool = src.descriptorPool;
    descriptorSetCount = src.descriptorSetCount;
    pSetLayouts = nullptr;
    pNext = SafePnextCopy(src.pNext);
    if (descriptorSetCount && src.pSetLayouts) {
        pSetLayouts = new VkDescriptorSetLayout[descriptorSetCount];
        for (uint32_t i = 0; i < descriptorSetCount; ++i) {
            pSetLayouts[i] = src.pSetLayouts[i];
        }
    }

    return *this;
}

safe_VkDescriptorSetAllocateInfo::~safe_VkDescriptorSetAllocateInfo()
{
    if (pSetLayouts)
        delete[] pSetLayouts;
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkDescriptorSetAllocateInfo::initialize(const VkDescriptorSetAllocateInfo* in_struct)
{
    sType = in_struct->sType;
    descriptorPool = in_struct->descriptorPool;
    descriptorSetCount = in_struct->descriptorSetCount;
    pSetLayouts = nullptr;
    pNext = SafePnextCopy(in_struct->pNext);
    if (descriptorSetCount && in_struct->pSetLayouts) {
        pSetLayouts = new VkDescriptorSetLayout[descriptorSetCount];
        for (uint32_t i = 0; i < descriptorSetCount; ++i) {
            pSetLayouts[i] = in_struct->pSetLayouts[i];
        }
    }
}

void safe_VkDescriptorSetAllocateInfo::initialize(const safe_VkDescriptorSetAllocateInfo* src)
{
    sType = src->sType;
    descriptorPool = src->descriptorPool;
    descriptorSetCount = src->descriptorSetCount;
    pSetLayouts = nullptr;
    pNext = SafePnextCopy(src->pNext);
    if (descriptorSetCount && src->pSetLayouts) {
        pSetLayouts = new VkDescriptorSetLayout[descriptorSetCount];
        for (uint32_t i = 0; i < descriptorSetCount; ++i) {
            pSetLayouts[i] = src->pSetLayouts[i];
        }
    }
}

safe_VkWriteDescriptorSet::safe_VkWriteDescriptorSet(const VkWriteDescriptorSet* in_struct) :
    sType(in_struct->sType),
    dstSet(in_struct->dstSet),
    dstBinding(in_struct->dstBinding),
    dstArrayElement(in_struct->dstArrayElement),
    descriptorCount(in_struct->descriptorCount),
    descriptorType(in_struct->descriptorType),
    pImageInfo(nullptr),
    pBufferInfo(nullptr),
    pTexelBufferView(nullptr)
{
    pNext = SafePnextCopy(in_struct->pNext);
    switch (descriptorType) {
        case VK_DESCRIPTOR_TYPE_SAMPLER:
        case VK_DESCRIPTOR_TYPE_COMBINED_IMAGE_SAMPLER:
        case VK_DESCRIPTOR_TYPE_SAMPLED_IMAGE:
        case VK_DESCRIPTOR_TYPE_STORAGE_IMAGE:
        case VK_DESCRIPTOR_TYPE_INPUT_ATTACHMENT:
        if (descriptorCount && in_struct->pImageInfo) {
            pImageInfo = new VkDescriptorImageInfo[descriptorCount];
            for (uint32_t i = 0; i < descriptorCount; ++i) {
                pImageInfo[i] = in_struct->pImageInfo[i];
            }
        }
        break;
        case VK_DESCRIPTOR_TYPE_UNIFORM_BUFFER:
        case VK_DESCRIPTOR_TYPE_STORAGE_BUFFER:
        case VK_DESCRIPTOR_TYPE_UNIFORM_BUFFER_DYNAMIC:
        case VK_DESCRIPTOR_TYPE_STORAGE_BUFFER_DYNAMIC:
        if (descriptorCount && in_struct->pBufferInfo) {
            pBufferInfo = new VkDescriptorBufferInfo[descriptorCount];
            for (uint32_t i = 0; i < descriptorCount; ++i) {
                pBufferInfo[i] = in_struct->pBufferInfo[i];
            }
        }
        break;
        case VK_DESCRIPTOR_TYPE_UNIFORM_TEXEL_BUFFER:
        case VK_DESCRIPTOR_TYPE_STORAGE_TEXEL_BUFFER:
        if (descriptorCount && in_struct->pTexelBufferView) {
            pTexelBufferView = new VkBufferView[descriptorCount];
            for (uint32_t i = 0; i < descriptorCount; ++i) {
                pTexelBufferView[i] = in_struct->pTexelBufferView[i];
            }
        }
        break;
        default:
        break;
    }
}

safe_VkWriteDescriptorSet::safe_VkWriteDescriptorSet() :
    pNext(nullptr),
    pImageInfo(nullptr),
    pBufferInfo(nullptr),
    pTexelBufferView(nullptr)
{}

safe_VkWriteDescriptorSet::safe_VkWriteDescriptorSet(const safe_VkWriteDescriptorSet& src)
{
    sType = src.sType;
    dstSet = src.dstSet;
    dstBinding = src.dstBinding;
    dstArrayElement = src.dstArrayElement;
    descriptorCount = src.descriptorCount;
    descriptorType = src.descriptorType;
    pImageInfo = nullptr;
    pBufferInfo = nullptr;
    pTexelBufferView = nullptr;
    pNext = SafePnextCopy(src.pNext);
    switch (descriptorType) {
        case VK_DESCRIPTOR_TYPE_SAMPLER:
        case VK_DESCRIPTOR_TYPE_COMBINED_IMAGE_SAMPLER:
        case VK_DESCRIPTOR_TYPE_SAMPLED_IMAGE:
        case VK_DESCRIPTOR_TYPE_STORAGE_IMAGE:
        case VK_DESCRIPTOR_TYPE_INPUT_ATTACHMENT:
        if (descriptorCount && src.pImageInfo) {
            pImageInfo = new VkDescriptorImageInfo[descriptorCount];
            for (uint32_t i = 0; i < descriptorCount; ++i) {
                pImageInfo[i] = src.pImageInfo[i];
            }
        }
        break;
        case VK_DESCRIPTOR_TYPE_UNIFORM_BUFFER:
        case VK_DESCRIPTOR_TYPE_STORAGE_BUFFER:
        case VK_DESCRIPTOR_TYPE_UNIFORM_BUFFER_DYNAMIC:
        case VK_DESCRIPTOR_TYPE_STORAGE_BUFFER_DYNAMIC:
        if (descriptorCount && src.pBufferInfo) {
            pBufferInfo = new VkDescriptorBufferInfo[descriptorCount];
            for (uint32_t i = 0; i < descriptorCount; ++i) {
                pBufferInfo[i] = src.pBufferInfo[i];
            }
        }
        break;
        case VK_DESCRIPTOR_TYPE_UNIFORM_TEXEL_BUFFER:
        case VK_DESCRIPTOR_TYPE_STORAGE_TEXEL_BUFFER:
        if (descriptorCount && src.pTexelBufferView) {
            pTexelBufferView = new VkBufferView[descriptorCount];
            for (uint32_t i = 0; i < descriptorCount; ++i) {
                pTexelBufferView[i] = src.pTexelBufferView[i];
            }
        }
        break;
        default:
        break;
    }
}

safe_VkWriteDescriptorSet& safe_VkWriteDescriptorSet::operator=(const safe_VkWriteDescriptorSet& src)
{
    if (&src == this) return *this;

    if (pImageInfo)
        delete[] pImageInfo;
    if (pBufferInfo)
        delete[] pBufferInfo;
    if (pTexelBufferView)
        delete[] pTexelBufferView;
    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    dstSet = src.dstSet;
    dstBinding = src.dstBinding;
    dstArrayElement = src.dstArrayElement;
    descriptorCount = src.descriptorCount;
    descriptorType = src.descriptorType;
    pImageInfo = nullptr;
    pBufferInfo = nullptr;
    pTexelBufferView = nullptr;
    pNext = SafePnextCopy(src.pNext);
    switch (descriptorType) {
        case VK_DESCRIPTOR_TYPE_SAMPLER:
        case VK_DESCRIPTOR_TYPE_COMBINED_IMAGE_SAMPLER:
        case VK_DESCRIPTOR_TYPE_SAMPLED_IMAGE:
        case VK_DESCRIPTOR_TYPE_STORAGE_IMAGE:
        case VK_DESCRIPTOR_TYPE_INPUT_ATTACHMENT:
        if (descriptorCount && src.pImageInfo) {
            pImageInfo = new VkDescriptorImageInfo[descriptorCount];
            for (uint32_t i = 0; i < descriptorCount; ++i) {
                pImageInfo[i] = src.pImageInfo[i];
            }
        }
        break;
        case VK_DESCRIPTOR_TYPE_UNIFORM_BUFFER:
        case VK_DESCRIPTOR_TYPE_STORAGE_BUFFER:
        case VK_DESCRIPTOR_TYPE_UNIFORM_BUFFER_DYNAMIC:
        case VK_DESCRIPTOR_TYPE_STORAGE_BUFFER_DYNAMIC:
        if (descriptorCount && src.pBufferInfo) {
            pBufferInfo = new VkDescriptorBufferInfo[descriptorCount];
            for (uint32_t i = 0; i < descriptorCount; ++i) {
                pBufferInfo[i] = src.pBufferInfo[i];
            }
        }
        break;
        case VK_DESCRIPTOR_TYPE_UNIFORM_TEXEL_BUFFER:
        case VK_DESCRIPTOR_TYPE_STORAGE_TEXEL_BUFFER:
        if (descriptorCount && src.pTexelBufferView) {
            pTexelBufferView = new VkBufferView[descriptorCount];
            for (uint32_t i = 0; i < descriptorCount; ++i) {
                pTexelBufferView[i] = src.pTexelBufferView[i];
            }
        }
        break;
        default:
        break;
    }

    return *this;
}

safe_VkWriteDescriptorSet::~safe_VkWriteDescriptorSet()
{
    if (pImageInfo)
        delete[] pImageInfo;
    if (pBufferInfo)
        delete[] pBufferInfo;
    if (pTexelBufferView)
        delete[] pTexelBufferView;
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkWriteDescriptorSet::initialize(const VkWriteDescriptorSet* in_struct)
{
    sType = in_struct->sType;
    dstSet = in_struct->dstSet;
    dstBinding = in_struct->dstBinding;
    dstArrayElement = in_struct->dstArrayElement;
    descriptorCount = in_struct->descriptorCount;
    descriptorType = in_struct->descriptorType;
    pImageInfo = nullptr;
    pBufferInfo = nullptr;
    pTexelBufferView = nullptr;
    pNext = SafePnextCopy(in_struct->pNext);
    switch (descriptorType) {
        case VK_DESCRIPTOR_TYPE_SAMPLER:
        case VK_DESCRIPTOR_TYPE_COMBINED_IMAGE_SAMPLER:
        case VK_DESCRIPTOR_TYPE_SAMPLED_IMAGE:
        case VK_DESCRIPTOR_TYPE_STORAGE_IMAGE:
        case VK_DESCRIPTOR_TYPE_INPUT_ATTACHMENT:
        if (descriptorCount && in_struct->pImageInfo) {
            pImageInfo = new VkDescriptorImageInfo[descriptorCount];
            for (uint32_t i = 0; i < descriptorCount; ++i) {
                pImageInfo[i] = in_struct->pImageInfo[i];
            }
        }
        break;
        case VK_DESCRIPTOR_TYPE_UNIFORM_BUFFER:
        case VK_DESCRIPTOR_TYPE_STORAGE_BUFFER:
        case VK_DESCRIPTOR_TYPE_UNIFORM_BUFFER_DYNAMIC:
        case VK_DESCRIPTOR_TYPE_STORAGE_BUFFER_DYNAMIC:
        if (descriptorCount && in_struct->pBufferInfo) {
            pBufferInfo = new VkDescriptorBufferInfo[descriptorCount];
            for (uint32_t i = 0; i < descriptorCount; ++i) {
                pBufferInfo[i] = in_struct->pBufferInfo[i];
            }
        }
        break;
        case VK_DESCRIPTOR_TYPE_UNIFORM_TEXEL_BUFFER:
        case VK_DESCRIPTOR_TYPE_STORAGE_TEXEL_BUFFER:
        if (descriptorCount && in_struct->pTexelBufferView) {
            pTexelBufferView = new VkBufferView[descriptorCount];
            for (uint32_t i = 0; i < descriptorCount; ++i) {
                pTexelBufferView[i] = in_struct->pTexelBufferView[i];
            }
        }
        break;
        default:
        break;
    }
}

void safe_VkWriteDescriptorSet::initialize(const safe_VkWriteDescriptorSet* src)
{
    sType = src->sType;
    dstSet = src->dstSet;
    dstBinding = src->dstBinding;
    dstArrayElement = src->dstArrayElement;
    descriptorCount = src->descriptorCount;
    descriptorType = src->descriptorType;
    pImageInfo = nullptr;
    pBufferInfo = nullptr;
    pTexelBufferView = nullptr;
    pNext = SafePnextCopy(src->pNext);
    switch (descriptorType) {
        case VK_DESCRIPTOR_TYPE_SAMPLER:
        case VK_DESCRIPTOR_TYPE_COMBINED_IMAGE_SAMPLER:
        case VK_DESCRIPTOR_TYPE_SAMPLED_IMAGE:
        case VK_DESCRIPTOR_TYPE_STORAGE_IMAGE:
        case VK_DESCRIPTOR_TYPE_INPUT_ATTACHMENT:
        if (descriptorCount && src->pImageInfo) {
            pImageInfo = new VkDescriptorImageInfo[descriptorCount];
            for (uint32_t i = 0; i < descriptorCount; ++i) {
                pImageInfo[i] = src->pImageInfo[i];
            }
        }
        break;
        case VK_DESCRIPTOR_TYPE_UNIFORM_BUFFER:
        case VK_DESCRIPTOR_TYPE_STORAGE_BUFFER:
        case VK_DESCRIPTOR_TYPE_UNIFORM_BUFFER_DYNAMIC:
        case VK_DESCRIPTOR_TYPE_STORAGE_BUFFER_DYNAMIC:
        if (descriptorCount && src->pBufferInfo) {
            pBufferInfo = new VkDescriptorBufferInfo[descriptorCount];
            for (uint32_t i = 0; i < descriptorCount; ++i) {
                pBufferInfo[i] = src->pBufferInfo[i];
            }
        }
        break;
        case VK_DESCRIPTOR_TYPE_UNIFORM_TEXEL_BUFFER:
        case VK_DESCRIPTOR_TYPE_STORAGE_TEXEL_BUFFER:
        if (descriptorCount && src->pTexelBufferView) {
            pTexelBufferView = new VkBufferView[descriptorCount];
            for (uint32_t i = 0; i < descriptorCount; ++i) {
                pTexelBufferView[i] = src->pTexelBufferView[i];
            }
        }
        break;
        default:
        break;
    }
}

safe_VkCopyDescriptorSet::safe_VkCopyDescriptorSet(const VkCopyDescriptorSet* in_struct) :
    sType(in_struct->sType),
    srcSet(in_struct->srcSet),
    srcBinding(in_struct->srcBinding),
    srcArrayElement(in_struct->srcArrayElement),
    dstSet(in_struct->dstSet),
    dstBinding(in_struct->dstBinding),
    dstArrayElement(in_struct->dstArrayElement),
    descriptorCount(in_struct->descriptorCount)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkCopyDescriptorSet::safe_VkCopyDescriptorSet() :
    pNext(nullptr)
{}

safe_VkCopyDescriptorSet::safe_VkCopyDescriptorSet(const safe_VkCopyDescriptorSet& src)
{
    sType = src.sType;
    srcSet = src.srcSet;
    srcBinding = src.srcBinding;
    srcArrayElement = src.srcArrayElement;
    dstSet = src.dstSet;
    dstBinding = src.dstBinding;
    dstArrayElement = src.dstArrayElement;
    descriptorCount = src.descriptorCount;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkCopyDescriptorSet& safe_VkCopyDescriptorSet::operator=(const safe_VkCopyDescriptorSet& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    srcSet = src.srcSet;
    srcBinding = src.srcBinding;
    srcArrayElement = src.srcArrayElement;
    dstSet = src.dstSet;
    dstBinding = src.dstBinding;
    dstArrayElement = src.dstArrayElement;
    descriptorCount = src.descriptorCount;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkCopyDescriptorSet::~safe_VkCopyDescriptorSet()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkCopyDescriptorSet::initialize(const VkCopyDescriptorSet* in_struct)
{
    sType = in_struct->sType;
    srcSet = in_struct->srcSet;
    srcBinding = in_struct->srcBinding;
    srcArrayElement = in_struct->srcArrayElement;
    dstSet = in_struct->dstSet;
    dstBinding = in_struct->dstBinding;
    dstArrayElement = in_struct->dstArrayElement;
    descriptorCount = in_struct->descriptorCount;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkCopyDescriptorSet::initialize(const safe_VkCopyDescriptorSet* src)
{
    sType = src->sType;
    srcSet = src->srcSet;
    srcBinding = src->srcBinding;
    srcArrayElement = src->srcArrayElement;
    dstSet = src->dstSet;
    dstBinding = src->dstBinding;
    dstArrayElement = src->dstArrayElement;
    descriptorCount = src->descriptorCount;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkFramebufferCreateInfo::safe_VkFramebufferCreateInfo(const VkFramebufferCreateInfo* in_struct) :
    sType(in_struct->sType),
    flags(in_struct->flags),
    renderPass(in_struct->renderPass),
    attachmentCount(in_struct->attachmentCount),
    pAttachments(nullptr),
    width(in_struct->width),
    height(in_struct->height),
    layers(in_struct->layers)
{
    pNext = SafePnextCopy(in_struct->pNext);
    if (attachmentCount && in_struct->pAttachments) {
        pAttachments = new VkImageView[attachmentCount];
        for (uint32_t i = 0; i < attachmentCount; ++i) {
            pAttachments[i] = in_struct->pAttachments[i];
        }
    }
}

safe_VkFramebufferCreateInfo::safe_VkFramebufferCreateInfo() :
    pNext(nullptr),
    pAttachments(nullptr)
{}

safe_VkFramebufferCreateInfo::safe_VkFramebufferCreateInfo(const safe_VkFramebufferCreateInfo& src)
{
    sType = src.sType;
    flags = src.flags;
    renderPass = src.renderPass;
    attachmentCount = src.attachmentCount;
    pAttachments = nullptr;
    width = src.width;
    height = src.height;
    layers = src.layers;
    pNext = SafePnextCopy(src.pNext);
    if (attachmentCount && src.pAttachments) {
        pAttachments = new VkImageView[attachmentCount];
        for (uint32_t i = 0; i < attachmentCount; ++i) {
            pAttachments[i] = src.pAttachments[i];
        }
    }
}

safe_VkFramebufferCreateInfo& safe_VkFramebufferCreateInfo::operator=(const safe_VkFramebufferCreateInfo& src)
{
    if (&src == this) return *this;

    if (pAttachments)
        delete[] pAttachments;
    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    flags = src.flags;
    renderPass = src.renderPass;
    attachmentCount = src.attachmentCount;
    pAttachments = nullptr;
    width = src.width;
    height = src.height;
    layers = src.layers;
    pNext = SafePnextCopy(src.pNext);
    if (attachmentCount && src.pAttachments) {
        pAttachments = new VkImageView[attachmentCount];
        for (uint32_t i = 0; i < attachmentCount; ++i) {
            pAttachments[i] = src.pAttachments[i];
        }
    }

    return *this;
}

safe_VkFramebufferCreateInfo::~safe_VkFramebufferCreateInfo()
{
    if (pAttachments)
        delete[] pAttachments;
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkFramebufferCreateInfo::initialize(const VkFramebufferCreateInfo* in_struct)
{
    sType = in_struct->sType;
    flags = in_struct->flags;
    renderPass = in_struct->renderPass;
    attachmentCount = in_struct->attachmentCount;
    pAttachments = nullptr;
    width = in_struct->width;
    height = in_struct->height;
    layers = in_struct->layers;
    pNext = SafePnextCopy(in_struct->pNext);
    if (attachmentCount && in_struct->pAttachments) {
        pAttachments = new VkImageView[attachmentCount];
        for (uint32_t i = 0; i < attachmentCount; ++i) {
            pAttachments[i] = in_struct->pAttachments[i];
        }
    }
}

void safe_VkFramebufferCreateInfo::initialize(const safe_VkFramebufferCreateInfo* src)
{
    sType = src->sType;
    flags = src->flags;
    renderPass = src->renderPass;
    attachmentCount = src->attachmentCount;
    pAttachments = nullptr;
    width = src->width;
    height = src->height;
    layers = src->layers;
    pNext = SafePnextCopy(src->pNext);
    if (attachmentCount && src->pAttachments) {
        pAttachments = new VkImageView[attachmentCount];
        for (uint32_t i = 0; i < attachmentCount; ++i) {
            pAttachments[i] = src->pAttachments[i];
        }
    }
}

safe_VkSubpassDescription::safe_VkSubpassDescription(const VkSubpassDescription* in_struct) :
    flags(in_struct->flags),
    pipelineBindPoint(in_struct->pipelineBindPoint),
    inputAttachmentCount(in_struct->inputAttachmentCount),
    pInputAttachments(nullptr),
    colorAttachmentCount(in_struct->colorAttachmentCount),
    pColorAttachments(nullptr),
    pResolveAttachments(nullptr),
    pDepthStencilAttachment(nullptr),
    preserveAttachmentCount(in_struct->preserveAttachmentCount),
    pPreserveAttachments(nullptr)
{
    if (in_struct->pInputAttachments) {
        pInputAttachments = new VkAttachmentReference[in_struct->inputAttachmentCount];
        memcpy ((void *)pInputAttachments, (void *)in_struct->pInputAttachments, sizeof(VkAttachmentReference)*in_struct->inputAttachmentCount);
    }
    if (in_struct->pColorAttachments) {
        pColorAttachments = new VkAttachmentReference[in_struct->colorAttachmentCount];
        memcpy ((void *)pColorAttachments, (void *)in_struct->pColorAttachments, sizeof(VkAttachmentReference)*in_struct->colorAttachmentCount);
    }
    if (in_struct->pResolveAttachments) {
        pResolveAttachments = new VkAttachmentReference[in_struct->colorAttachmentCount];
        memcpy ((void *)pResolveAttachments, (void *)in_struct->pResolveAttachments, sizeof(VkAttachmentReference)*in_struct->colorAttachmentCount);
    }
    if (in_struct->pDepthStencilAttachment) {
        pDepthStencilAttachment = new VkAttachmentReference(*in_struct->pDepthStencilAttachment);
    }
    if (in_struct->pPreserveAttachments) {
        pPreserveAttachments = new uint32_t[in_struct->preserveAttachmentCount];
        memcpy ((void *)pPreserveAttachments, (void *)in_struct->pPreserveAttachments, sizeof(uint32_t)*in_struct->preserveAttachmentCount);
    }
}

safe_VkSubpassDescription::safe_VkSubpassDescription() :
    pInputAttachments(nullptr),
    pColorAttachments(nullptr),
    pResolveAttachments(nullptr),
    pDepthStencilAttachment(nullptr),
    pPreserveAttachments(nullptr)
{}

safe_VkSubpassDescription::safe_VkSubpassDescription(const safe_VkSubpassDescription& src)
{
    flags = src.flags;
    pipelineBindPoint = src.pipelineBindPoint;
    inputAttachmentCount = src.inputAttachmentCount;
    pInputAttachments = nullptr;
    colorAttachmentCount = src.colorAttachmentCount;
    pColorAttachments = nullptr;
    pResolveAttachments = nullptr;
    pDepthStencilAttachment = nullptr;
    preserveAttachmentCount = src.preserveAttachmentCount;
    pPreserveAttachments = nullptr;
    if (src.pInputAttachments) {
        pInputAttachments = new VkAttachmentReference[src.inputAttachmentCount];
        memcpy ((void *)pInputAttachments, (void *)src.pInputAttachments, sizeof(VkAttachmentReference)*src.inputAttachmentCount);
    }
    if (src.pColorAttachments) {
        pColorAttachments = new VkAttachmentReference[src.colorAttachmentCount];
        memcpy ((void *)pColorAttachments, (void *)src.pColorAttachments, sizeof(VkAttachmentReference)*src.colorAttachmentCount);
    }
    if (src.pResolveAttachments) {
        pResolveAttachments = new VkAttachmentReference[src.colorAttachmentCount];
        memcpy ((void *)pResolveAttachments, (void *)src.pResolveAttachments, sizeof(VkAttachmentReference)*src.colorAttachmentCount);
    }
    if (src.pDepthStencilAttachment) {
        pDepthStencilAttachment = new VkAttachmentReference(*src.pDepthStencilAttachment);
    }
    if (src.pPreserveAttachments) {
        pPreserveAttachments = new uint32_t[src.preserveAttachmentCount];
        memcpy ((void *)pPreserveAttachments, (void *)src.pPreserveAttachments, sizeof(uint32_t)*src.preserveAttachmentCount);
    }
}

safe_VkSubpassDescription& safe_VkSubpassDescription::operator=(const safe_VkSubpassDescription& src)
{
    if (&src == this) return *this;

    if (pInputAttachments)
        delete[] pInputAttachments;
    if (pColorAttachments)
        delete[] pColorAttachments;
    if (pResolveAttachments)
        delete[] pResolveAttachments;
    if (pDepthStencilAttachment)
        delete pDepthStencilAttachment;
    if (pPreserveAttachments)
        delete[] pPreserveAttachments;

    flags = src.flags;
    pipelineBindPoint = src.pipelineBindPoint;
    inputAttachmentCount = src.inputAttachmentCount;
    pInputAttachments = nullptr;
    colorAttachmentCount = src.colorAttachmentCount;
    pColorAttachments = nullptr;
    pResolveAttachments = nullptr;
    pDepthStencilAttachment = nullptr;
    preserveAttachmentCount = src.preserveAttachmentCount;
    pPreserveAttachments = nullptr;
    if (src.pInputAttachments) {
        pInputAttachments = new VkAttachmentReference[src.inputAttachmentCount];
        memcpy ((void *)pInputAttachments, (void *)src.pInputAttachments, sizeof(VkAttachmentReference)*src.inputAttachmentCount);
    }
    if (src.pColorAttachments) {
        pColorAttachments = new VkAttachmentReference[src.colorAttachmentCount];
        memcpy ((void *)pColorAttachments, (void *)src.pColorAttachments, sizeof(VkAttachmentReference)*src.colorAttachmentCount);
    }
    if (src.pResolveAttachments) {
        pResolveAttachments = new VkAttachmentReference[src.colorAttachmentCount];
        memcpy ((void *)pResolveAttachments, (void *)src.pResolveAttachments, sizeof(VkAttachmentReference)*src.colorAttachmentCount);
    }
    if (src.pDepthStencilAttachment) {
        pDepthStencilAttachment = new VkAttachmentReference(*src.pDepthStencilAttachment);
    }
    if (src.pPreserveAttachments) {
        pPreserveAttachments = new uint32_t[src.preserveAttachmentCount];
        memcpy ((void *)pPreserveAttachments, (void *)src.pPreserveAttachments, sizeof(uint32_t)*src.preserveAttachmentCount);
    }

    return *this;
}

safe_VkSubpassDescription::~safe_VkSubpassDescription()
{
    if (pInputAttachments)
        delete[] pInputAttachments;
    if (pColorAttachments)
        delete[] pColorAttachments;
    if (pResolveAttachments)
        delete[] pResolveAttachments;
    if (pDepthStencilAttachment)
        delete pDepthStencilAttachment;
    if (pPreserveAttachments)
        delete[] pPreserveAttachments;
}

void safe_VkSubpassDescription::initialize(const VkSubpassDescription* in_struct)
{
    flags = in_struct->flags;
    pipelineBindPoint = in_struct->pipelineBindPoint;
    inputAttachmentCount = in_struct->inputAttachmentCount;
    pInputAttachments = nullptr;
    colorAttachmentCount = in_struct->colorAttachmentCount;
    pColorAttachments = nullptr;
    pResolveAttachments = nullptr;
    pDepthStencilAttachment = nullptr;
    preserveAttachmentCount = in_struct->preserveAttachmentCount;
    pPreserveAttachments = nullptr;
    if (in_struct->pInputAttachments) {
        pInputAttachments = new VkAttachmentReference[in_struct->inputAttachmentCount];
        memcpy ((void *)pInputAttachments, (void *)in_struct->pInputAttachments, sizeof(VkAttachmentReference)*in_struct->inputAttachmentCount);
    }
    if (in_struct->pColorAttachments) {
        pColorAttachments = new VkAttachmentReference[in_struct->colorAttachmentCount];
        memcpy ((void *)pColorAttachments, (void *)in_struct->pColorAttachments, sizeof(VkAttachmentReference)*in_struct->colorAttachmentCount);
    }
    if (in_struct->pResolveAttachments) {
        pResolveAttachments = new VkAttachmentReference[in_struct->colorAttachmentCount];
        memcpy ((void *)pResolveAttachments, (void *)in_struct->pResolveAttachments, sizeof(VkAttachmentReference)*in_struct->colorAttachmentCount);
    }
    if (in_struct->pDepthStencilAttachment) {
        pDepthStencilAttachment = new VkAttachmentReference(*in_struct->pDepthStencilAttachment);
    }
    if (in_struct->pPreserveAttachments) {
        pPreserveAttachments = new uint32_t[in_struct->preserveAttachmentCount];
        memcpy ((void *)pPreserveAttachments, (void *)in_struct->pPreserveAttachments, sizeof(uint32_t)*in_struct->preserveAttachmentCount);
    }
}

void safe_VkSubpassDescription::initialize(const safe_VkSubpassDescription* src)
{
    flags = src->flags;
    pipelineBindPoint = src->pipelineBindPoint;
    inputAttachmentCount = src->inputAttachmentCount;
    pInputAttachments = nullptr;
    colorAttachmentCount = src->colorAttachmentCount;
    pColorAttachments = nullptr;
    pResolveAttachments = nullptr;
    pDepthStencilAttachment = nullptr;
    preserveAttachmentCount = src->preserveAttachmentCount;
    pPreserveAttachments = nullptr;
    if (src->pInputAttachments) {
        pInputAttachments = new VkAttachmentReference[src->inputAttachmentCount];
        memcpy ((void *)pInputAttachments, (void *)src->pInputAttachments, sizeof(VkAttachmentReference)*src->inputAttachmentCount);
    }
    if (src->pColorAttachments) {
        pColorAttachments = new VkAttachmentReference[src->colorAttachmentCount];
        memcpy ((void *)pColorAttachments, (void *)src->pColorAttachments, sizeof(VkAttachmentReference)*src->colorAttachmentCount);
    }
    if (src->pResolveAttachments) {
        pResolveAttachments = new VkAttachmentReference[src->colorAttachmentCount];
        memcpy ((void *)pResolveAttachments, (void *)src->pResolveAttachments, sizeof(VkAttachmentReference)*src->colorAttachmentCount);
    }
    if (src->pDepthStencilAttachment) {
        pDepthStencilAttachment = new VkAttachmentReference(*src->pDepthStencilAttachment);
    }
    if (src->pPreserveAttachments) {
        pPreserveAttachments = new uint32_t[src->preserveAttachmentCount];
        memcpy ((void *)pPreserveAttachments, (void *)src->pPreserveAttachments, sizeof(uint32_t)*src->preserveAttachmentCount);
    }
}

safe_VkRenderPassCreateInfo::safe_VkRenderPassCreateInfo(const VkRenderPassCreateInfo* in_struct) :
    sType(in_struct->sType),
    flags(in_struct->flags),
    attachmentCount(in_struct->attachmentCount),
    pAttachments(nullptr),
    subpassCount(in_struct->subpassCount),
    pSubpasses(nullptr),
    dependencyCount(in_struct->dependencyCount),
    pDependencies(nullptr)
{
    pNext = SafePnextCopy(in_struct->pNext);
    if (in_struct->pAttachments) {
        pAttachments = new VkAttachmentDescription[in_struct->attachmentCount];
        memcpy ((void *)pAttachments, (void *)in_struct->pAttachments, sizeof(VkAttachmentDescription)*in_struct->attachmentCount);
    }
    if (subpassCount && in_struct->pSubpasses) {
        pSubpasses = new safe_VkSubpassDescription[subpassCount];
        for (uint32_t i = 0; i < subpassCount; ++i) {
            pSubpasses[i].initialize(&in_struct->pSubpasses[i]);
        }
    }
    if (in_struct->pDependencies) {
        pDependencies = new VkSubpassDependency[in_struct->dependencyCount];
        memcpy ((void *)pDependencies, (void *)in_struct->pDependencies, sizeof(VkSubpassDependency)*in_struct->dependencyCount);
    }
}

safe_VkRenderPassCreateInfo::safe_VkRenderPassCreateInfo() :
    pNext(nullptr),
    pAttachments(nullptr),
    pSubpasses(nullptr),
    pDependencies(nullptr)
{}

safe_VkRenderPassCreateInfo::safe_VkRenderPassCreateInfo(const safe_VkRenderPassCreateInfo& src)
{
    sType = src.sType;
    flags = src.flags;
    attachmentCount = src.attachmentCount;
    pAttachments = nullptr;
    subpassCount = src.subpassCount;
    pSubpasses = nullptr;
    dependencyCount = src.dependencyCount;
    pDependencies = nullptr;
    pNext = SafePnextCopy(src.pNext);
    if (src.pAttachments) {
        pAttachments = new VkAttachmentDescription[src.attachmentCount];
        memcpy ((void *)pAttachments, (void *)src.pAttachments, sizeof(VkAttachmentDescription)*src.attachmentCount);
    }
    if (subpassCount && src.pSubpasses) {
        pSubpasses = new safe_VkSubpassDescription[subpassCount];
        for (uint32_t i = 0; i < subpassCount; ++i) {
            pSubpasses[i].initialize(&src.pSubpasses[i]);
        }
    }
    if (src.pDependencies) {
        pDependencies = new VkSubpassDependency[src.dependencyCount];
        memcpy ((void *)pDependencies, (void *)src.pDependencies, sizeof(VkSubpassDependency)*src.dependencyCount);
    }
}

safe_VkRenderPassCreateInfo& safe_VkRenderPassCreateInfo::operator=(const safe_VkRenderPassCreateInfo& src)
{
    if (&src == this) return *this;

    if (pAttachments)
        delete[] pAttachments;
    if (pSubpasses)
        delete[] pSubpasses;
    if (pDependencies)
        delete[] pDependencies;
    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    flags = src.flags;
    attachmentCount = src.attachmentCount;
    pAttachments = nullptr;
    subpassCount = src.subpassCount;
    pSubpasses = nullptr;
    dependencyCount = src.dependencyCount;
    pDependencies = nullptr;
    pNext = SafePnextCopy(src.pNext);
    if (src.pAttachments) {
        pAttachments = new VkAttachmentDescription[src.attachmentCount];
        memcpy ((void *)pAttachments, (void *)src.pAttachments, sizeof(VkAttachmentDescription)*src.attachmentCount);
    }
    if (subpassCount && src.pSubpasses) {
        pSubpasses = new safe_VkSubpassDescription[subpassCount];
        for (uint32_t i = 0; i < subpassCount; ++i) {
            pSubpasses[i].initialize(&src.pSubpasses[i]);
        }
    }
    if (src.pDependencies) {
        pDependencies = new VkSubpassDependency[src.dependencyCount];
        memcpy ((void *)pDependencies, (void *)src.pDependencies, sizeof(VkSubpassDependency)*src.dependencyCount);
    }

    return *this;
}

safe_VkRenderPassCreateInfo::~safe_VkRenderPassCreateInfo()
{
    if (pAttachments)
        delete[] pAttachments;
    if (pSubpasses)
        delete[] pSubpasses;
    if (pDependencies)
        delete[] pDependencies;
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkRenderPassCreateInfo::initialize(const VkRenderPassCreateInfo* in_struct)
{
    sType = in_struct->sType;
    flags = in_struct->flags;
    attachmentCount = in_struct->attachmentCount;
    pAttachments = nullptr;
    subpassCount = in_struct->subpassCount;
    pSubpasses = nullptr;
    dependencyCount = in_struct->dependencyCount;
    pDependencies = nullptr;
    pNext = SafePnextCopy(in_struct->pNext);
    if (in_struct->pAttachments) {
        pAttachments = new VkAttachmentDescription[in_struct->attachmentCount];
        memcpy ((void *)pAttachments, (void *)in_struct->pAttachments, sizeof(VkAttachmentDescription)*in_struct->attachmentCount);
    }
    if (subpassCount && in_struct->pSubpasses) {
        pSubpasses = new safe_VkSubpassDescription[subpassCount];
        for (uint32_t i = 0; i < subpassCount; ++i) {
            pSubpasses[i].initialize(&in_struct->pSubpasses[i]);
        }
    }
    if (in_struct->pDependencies) {
        pDependencies = new VkSubpassDependency[in_struct->dependencyCount];
        memcpy ((void *)pDependencies, (void *)in_struct->pDependencies, sizeof(VkSubpassDependency)*in_struct->dependencyCount);
    }
}

void safe_VkRenderPassCreateInfo::initialize(const safe_VkRenderPassCreateInfo* src)
{
    sType = src->sType;
    flags = src->flags;
    attachmentCount = src->attachmentCount;
    pAttachments = nullptr;
    subpassCount = src->subpassCount;
    pSubpasses = nullptr;
    dependencyCount = src->dependencyCount;
    pDependencies = nullptr;
    pNext = SafePnextCopy(src->pNext);
    if (src->pAttachments) {
        pAttachments = new VkAttachmentDescription[src->attachmentCount];
        memcpy ((void *)pAttachments, (void *)src->pAttachments, sizeof(VkAttachmentDescription)*src->attachmentCount);
    }
    if (subpassCount && src->pSubpasses) {
        pSubpasses = new safe_VkSubpassDescription[subpassCount];
        for (uint32_t i = 0; i < subpassCount; ++i) {
            pSubpasses[i].initialize(&src->pSubpasses[i]);
        }
    }
    if (src->pDependencies) {
        pDependencies = new VkSubpassDependency[src->dependencyCount];
        memcpy ((void *)pDependencies, (void *)src->pDependencies, sizeof(VkSubpassDependency)*src->dependencyCount);
    }
}

safe_VkCommandPoolCreateInfo::safe_VkCommandPoolCreateInfo(const VkCommandPoolCreateInfo* in_struct) :
    sType(in_struct->sType),
    flags(in_struct->flags),
    queueFamilyIndex(in_struct->queueFamilyIndex)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkCommandPoolCreateInfo::safe_VkCommandPoolCreateInfo() :
    pNext(nullptr)
{}

safe_VkCommandPoolCreateInfo::safe_VkCommandPoolCreateInfo(const safe_VkCommandPoolCreateInfo& src)
{
    sType = src.sType;
    flags = src.flags;
    queueFamilyIndex = src.queueFamilyIndex;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkCommandPoolCreateInfo& safe_VkCommandPoolCreateInfo::operator=(const safe_VkCommandPoolCreateInfo& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    flags = src.flags;
    queueFamilyIndex = src.queueFamilyIndex;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkCommandPoolCreateInfo::~safe_VkCommandPoolCreateInfo()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkCommandPoolCreateInfo::initialize(const VkCommandPoolCreateInfo* in_struct)
{
    sType = in_struct->sType;
    flags = in_struct->flags;
    queueFamilyIndex = in_struct->queueFamilyIndex;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkCommandPoolCreateInfo::initialize(const safe_VkCommandPoolCreateInfo* src)
{
    sType = src->sType;
    flags = src->flags;
    queueFamilyIndex = src->queueFamilyIndex;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkCommandBufferAllocateInfo::safe_VkCommandBufferAllocateInfo(const VkCommandBufferAllocateInfo* in_struct) :
    sType(in_struct->sType),
    commandPool(in_struct->commandPool),
    level(in_struct->level),
    commandBufferCount(in_struct->commandBufferCount)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkCommandBufferAllocateInfo::safe_VkCommandBufferAllocateInfo() :
    pNext(nullptr)
{}

safe_VkCommandBufferAllocateInfo::safe_VkCommandBufferAllocateInfo(const safe_VkCommandBufferAllocateInfo& src)
{
    sType = src.sType;
    commandPool = src.commandPool;
    level = src.level;
    commandBufferCount = src.commandBufferCount;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkCommandBufferAllocateInfo& safe_VkCommandBufferAllocateInfo::operator=(const safe_VkCommandBufferAllocateInfo& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    commandPool = src.commandPool;
    level = src.level;
    commandBufferCount = src.commandBufferCount;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkCommandBufferAllocateInfo::~safe_VkCommandBufferAllocateInfo()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkCommandBufferAllocateInfo::initialize(const VkCommandBufferAllocateInfo* in_struct)
{
    sType = in_struct->sType;
    commandPool = in_struct->commandPool;
    level = in_struct->level;
    commandBufferCount = in_struct->commandBufferCount;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkCommandBufferAllocateInfo::initialize(const safe_VkCommandBufferAllocateInfo* src)
{
    sType = src->sType;
    commandPool = src->commandPool;
    level = src->level;
    commandBufferCount = src->commandBufferCount;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkCommandBufferInheritanceInfo::safe_VkCommandBufferInheritanceInfo(const VkCommandBufferInheritanceInfo* in_struct) :
    sType(in_struct->sType),
    renderPass(in_struct->renderPass),
    subpass(in_struct->subpass),
    framebuffer(in_struct->framebuffer),
    occlusionQueryEnable(in_struct->occlusionQueryEnable),
    queryFlags(in_struct->queryFlags),
    pipelineStatistics(in_struct->pipelineStatistics)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkCommandBufferInheritanceInfo::safe_VkCommandBufferInheritanceInfo() :
    pNext(nullptr)
{}

safe_VkCommandBufferInheritanceInfo::safe_VkCommandBufferInheritanceInfo(const safe_VkCommandBufferInheritanceInfo& src)
{
    sType = src.sType;
    renderPass = src.renderPass;
    subpass = src.subpass;
    framebuffer = src.framebuffer;
    occlusionQueryEnable = src.occlusionQueryEnable;
    queryFlags = src.queryFlags;
    pipelineStatistics = src.pipelineStatistics;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkCommandBufferInheritanceInfo& safe_VkCommandBufferInheritanceInfo::operator=(const safe_VkCommandBufferInheritanceInfo& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    renderPass = src.renderPass;
    subpass = src.subpass;
    framebuffer = src.framebuffer;
    occlusionQueryEnable = src.occlusionQueryEnable;
    queryFlags = src.queryFlags;
    pipelineStatistics = src.pipelineStatistics;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkCommandBufferInheritanceInfo::~safe_VkCommandBufferInheritanceInfo()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkCommandBufferInheritanceInfo::initialize(const VkCommandBufferInheritanceInfo* in_struct)
{
    sType = in_struct->sType;
    renderPass = in_struct->renderPass;
    subpass = in_struct->subpass;
    framebuffer = in_struct->framebuffer;
    occlusionQueryEnable = in_struct->occlusionQueryEnable;
    queryFlags = in_struct->queryFlags;
    pipelineStatistics = in_struct->pipelineStatistics;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkCommandBufferInheritanceInfo::initialize(const safe_VkCommandBufferInheritanceInfo* src)
{
    sType = src->sType;
    renderPass = src->renderPass;
    subpass = src->subpass;
    framebuffer = src->framebuffer;
    occlusionQueryEnable = src->occlusionQueryEnable;
    queryFlags = src->queryFlags;
    pipelineStatistics = src->pipelineStatistics;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkCommandBufferBeginInfo::safe_VkCommandBufferBeginInfo(const VkCommandBufferBeginInfo* in_struct) :
    sType(in_struct->sType),
    flags(in_struct->flags),
    pInheritanceInfo(nullptr)
{
    pNext = SafePnextCopy(in_struct->pNext);
    if (in_struct->pInheritanceInfo)
        pInheritanceInfo = new safe_VkCommandBufferInheritanceInfo(in_struct->pInheritanceInfo);
}

safe_VkCommandBufferBeginInfo::safe_VkCommandBufferBeginInfo() :
    pNext(nullptr),
    pInheritanceInfo(nullptr)
{}

safe_VkCommandBufferBeginInfo::safe_VkCommandBufferBeginInfo(const safe_VkCommandBufferBeginInfo& src)
{
    sType = src.sType;
    flags = src.flags;
    pInheritanceInfo = nullptr;
    pNext = SafePnextCopy(src.pNext);
    if (src.pInheritanceInfo)
        pInheritanceInfo = new safe_VkCommandBufferInheritanceInfo(*src.pInheritanceInfo);
}

safe_VkCommandBufferBeginInfo& safe_VkCommandBufferBeginInfo::operator=(const safe_VkCommandBufferBeginInfo& src)
{
    if (&src == this) return *this;

    if (pInheritanceInfo)
        delete pInheritanceInfo;
    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    flags = src.flags;
    pInheritanceInfo = nullptr;
    pNext = SafePnextCopy(src.pNext);
    if (src.pInheritanceInfo)
        pInheritanceInfo = new safe_VkCommandBufferInheritanceInfo(*src.pInheritanceInfo);

    return *this;
}

safe_VkCommandBufferBeginInfo::~safe_VkCommandBufferBeginInfo()
{
    if (pInheritanceInfo)
        delete pInheritanceInfo;
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkCommandBufferBeginInfo::initialize(const VkCommandBufferBeginInfo* in_struct)
{
    sType = in_struct->sType;
    flags = in_struct->flags;
    pInheritanceInfo = nullptr;
    pNext = SafePnextCopy(in_struct->pNext);
    if (in_struct->pInheritanceInfo)
        pInheritanceInfo = new safe_VkCommandBufferInheritanceInfo(in_struct->pInheritanceInfo);
}

void safe_VkCommandBufferBeginInfo::initialize(const safe_VkCommandBufferBeginInfo* src)
{
    sType = src->sType;
    flags = src->flags;
    pInheritanceInfo = nullptr;
    pNext = SafePnextCopy(src->pNext);
    if (src->pInheritanceInfo)
        pInheritanceInfo = new safe_VkCommandBufferInheritanceInfo(*src->pInheritanceInfo);
}

safe_VkMemoryBarrier::safe_VkMemoryBarrier(const VkMemoryBarrier* in_struct) :
    sType(in_struct->sType),
    srcAccessMask(in_struct->srcAccessMask),
    dstAccessMask(in_struct->dstAccessMask)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkMemoryBarrier::safe_VkMemoryBarrier() :
    pNext(nullptr)
{}

safe_VkMemoryBarrier::safe_VkMemoryBarrier(const safe_VkMemoryBarrier& src)
{
    sType = src.sType;
    srcAccessMask = src.srcAccessMask;
    dstAccessMask = src.dstAccessMask;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkMemoryBarrier& safe_VkMemoryBarrier::operator=(const safe_VkMemoryBarrier& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    srcAccessMask = src.srcAccessMask;
    dstAccessMask = src.dstAccessMask;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkMemoryBarrier::~safe_VkMemoryBarrier()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkMemoryBarrier::initialize(const VkMemoryBarrier* in_struct)
{
    sType = in_struct->sType;
    srcAccessMask = in_struct->srcAccessMask;
    dstAccessMask = in_struct->dstAccessMask;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkMemoryBarrier::initialize(const safe_VkMemoryBarrier* src)
{
    sType = src->sType;
    srcAccessMask = src->srcAccessMask;
    dstAccessMask = src->dstAccessMask;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkBufferMemoryBarrier::safe_VkBufferMemoryBarrier(const VkBufferMemoryBarrier* in_struct) :
    sType(in_struct->sType),
    srcAccessMask(in_struct->srcAccessMask),
    dstAccessMask(in_struct->dstAccessMask),
    srcQueueFamilyIndex(in_struct->srcQueueFamilyIndex),
    dstQueueFamilyIndex(in_struct->dstQueueFamilyIndex),
    buffer(in_struct->buffer),
    offset(in_struct->offset),
    size(in_struct->size)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkBufferMemoryBarrier::safe_VkBufferMemoryBarrier() :
    pNext(nullptr)
{}

safe_VkBufferMemoryBarrier::safe_VkBufferMemoryBarrier(const safe_VkBufferMemoryBarrier& src)
{
    sType = src.sType;
    srcAccessMask = src.srcAccessMask;
    dstAccessMask = src.dstAccessMask;
    srcQueueFamilyIndex = src.srcQueueFamilyIndex;
    dstQueueFamilyIndex = src.dstQueueFamilyIndex;
    buffer = src.buffer;
    offset = src.offset;
    size = src.size;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkBufferMemoryBarrier& safe_VkBufferMemoryBarrier::operator=(const safe_VkBufferMemoryBarrier& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    srcAccessMask = src.srcAccessMask;
    dstAccessMask = src.dstAccessMask;
    srcQueueFamilyIndex = src.srcQueueFamilyIndex;
    dstQueueFamilyIndex = src.dstQueueFamilyIndex;
    buffer = src.buffer;
    offset = src.offset;
    size = src.size;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkBufferMemoryBarrier::~safe_VkBufferMemoryBarrier()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkBufferMemoryBarrier::initialize(const VkBufferMemoryBarrier* in_struct)
{
    sType = in_struct->sType;
    srcAccessMask = in_struct->srcAccessMask;
    dstAccessMask = in_struct->dstAccessMask;
    srcQueueFamilyIndex = in_struct->srcQueueFamilyIndex;
    dstQueueFamilyIndex = in_struct->dstQueueFamilyIndex;
    buffer = in_struct->buffer;
    offset = in_struct->offset;
    size = in_struct->size;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkBufferMemoryBarrier::initialize(const safe_VkBufferMemoryBarrier* src)
{
    sType = src->sType;
    srcAccessMask = src->srcAccessMask;
    dstAccessMask = src->dstAccessMask;
    srcQueueFamilyIndex = src->srcQueueFamilyIndex;
    dstQueueFamilyIndex = src->dstQueueFamilyIndex;
    buffer = src->buffer;
    offset = src->offset;
    size = src->size;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkImageMemoryBarrier::safe_VkImageMemoryBarrier(const VkImageMemoryBarrier* in_struct) :
    sType(in_struct->sType),
    srcAccessMask(in_struct->srcAccessMask),
    dstAccessMask(in_struct->dstAccessMask),
    oldLayout(in_struct->oldLayout),
    newLayout(in_struct->newLayout),
    srcQueueFamilyIndex(in_struct->srcQueueFamilyIndex),
    dstQueueFamilyIndex(in_struct->dstQueueFamilyIndex),
    image(in_struct->image),
    subresourceRange(in_struct->subresourceRange)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkImageMemoryBarrier::safe_VkImageMemoryBarrier() :
    pNext(nullptr)
{}

safe_VkImageMemoryBarrier::safe_VkImageMemoryBarrier(const safe_VkImageMemoryBarrier& src)
{
    sType = src.sType;
    srcAccessMask = src.srcAccessMask;
    dstAccessMask = src.dstAccessMask;
    oldLayout = src.oldLayout;
    newLayout = src.newLayout;
    srcQueueFamilyIndex = src.srcQueueFamilyIndex;
    dstQueueFamilyIndex = src.dstQueueFamilyIndex;
    image = src.image;
    subresourceRange = src.subresourceRange;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkImageMemoryBarrier& safe_VkImageMemoryBarrier::operator=(const safe_VkImageMemoryBarrier& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    srcAccessMask = src.srcAccessMask;
    dstAccessMask = src.dstAccessMask;
    oldLayout = src.oldLayout;
    newLayout = src.newLayout;
    srcQueueFamilyIndex = src.srcQueueFamilyIndex;
    dstQueueFamilyIndex = src.dstQueueFamilyIndex;
    image = src.image;
    subresourceRange = src.subresourceRange;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkImageMemoryBarrier::~safe_VkImageMemoryBarrier()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkImageMemoryBarrier::initialize(const VkImageMemoryBarrier* in_struct)
{
    sType = in_struct->sType;
    srcAccessMask = in_struct->srcAccessMask;
    dstAccessMask = in_struct->dstAccessMask;
    oldLayout = in_struct->oldLayout;
    newLayout = in_struct->newLayout;
    srcQueueFamilyIndex = in_struct->srcQueueFamilyIndex;
    dstQueueFamilyIndex = in_struct->dstQueueFamilyIndex;
    image = in_struct->image;
    subresourceRange = in_struct->subresourceRange;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkImageMemoryBarrier::initialize(const safe_VkImageMemoryBarrier* src)
{
    sType = src->sType;
    srcAccessMask = src->srcAccessMask;
    dstAccessMask = src->dstAccessMask;
    oldLayout = src->oldLayout;
    newLayout = src->newLayout;
    srcQueueFamilyIndex = src->srcQueueFamilyIndex;
    dstQueueFamilyIndex = src->dstQueueFamilyIndex;
    image = src->image;
    subresourceRange = src->subresourceRange;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkRenderPassBeginInfo::safe_VkRenderPassBeginInfo(const VkRenderPassBeginInfo* in_struct) :
    sType(in_struct->sType),
    renderPass(in_struct->renderPass),
    framebuffer(in_struct->framebuffer),
    renderArea(in_struct->renderArea),
    clearValueCount(in_struct->clearValueCount),
    pClearValues(nullptr)
{
    pNext = SafePnextCopy(in_struct->pNext);
    if (in_struct->pClearValues) {
        pClearValues = new VkClearValue[in_struct->clearValueCount];
        memcpy ((void *)pClearValues, (void *)in_struct->pClearValues, sizeof(VkClearValue)*in_struct->clearValueCount);
    }
}

safe_VkRenderPassBeginInfo::safe_VkRenderPassBeginInfo() :
    pNext(nullptr),
    pClearValues(nullptr)
{}

safe_VkRenderPassBeginInfo::safe_VkRenderPassBeginInfo(const safe_VkRenderPassBeginInfo& src)
{
    sType = src.sType;
    renderPass = src.renderPass;
    framebuffer = src.framebuffer;
    renderArea = src.renderArea;
    clearValueCount = src.clearValueCount;
    pClearValues = nullptr;
    pNext = SafePnextCopy(src.pNext);
    if (src.pClearValues) {
        pClearValues = new VkClearValue[src.clearValueCount];
        memcpy ((void *)pClearValues, (void *)src.pClearValues, sizeof(VkClearValue)*src.clearValueCount);
    }
}

safe_VkRenderPassBeginInfo& safe_VkRenderPassBeginInfo::operator=(const safe_VkRenderPassBeginInfo& src)
{
    if (&src == this) return *this;

    if (pClearValues)
        delete[] pClearValues;
    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    renderPass = src.renderPass;
    framebuffer = src.framebuffer;
    renderArea = src.renderArea;
    clearValueCount = src.clearValueCount;
    pClearValues = nullptr;
    pNext = SafePnextCopy(src.pNext);
    if (src.pClearValues) {
        pClearValues = new VkClearValue[src.clearValueCount];
        memcpy ((void *)pClearValues, (void *)src.pClearValues, sizeof(VkClearValue)*src.clearValueCount);
    }

    return *this;
}

safe_VkRenderPassBeginInfo::~safe_VkRenderPassBeginInfo()
{
    if (pClearValues)
        delete[] pClearValues;
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkRenderPassBeginInfo::initialize(const VkRenderPassBeginInfo* in_struct)
{
    sType = in_struct->sType;
    renderPass = in_struct->renderPass;
    framebuffer = in_struct->framebuffer;
    renderArea = in_struct->renderArea;
    clearValueCount = in_struct->clearValueCount;
    pClearValues = nullptr;
    pNext = SafePnextCopy(in_struct->pNext);
    if (in_struct->pClearValues) {
        pClearValues = new VkClearValue[in_struct->clearValueCount];
        memcpy ((void *)pClearValues, (void *)in_struct->pClearValues, sizeof(VkClearValue)*in_struct->clearValueCount);
    }
}

void safe_VkRenderPassBeginInfo::initialize(const safe_VkRenderPassBeginInfo* src)
{
    sType = src->sType;
    renderPass = src->renderPass;
    framebuffer = src->framebuffer;
    renderArea = src->renderArea;
    clearValueCount = src->clearValueCount;
    pClearValues = nullptr;
    pNext = SafePnextCopy(src->pNext);
    if (src->pClearValues) {
        pClearValues = new VkClearValue[src->clearValueCount];
        memcpy ((void *)pClearValues, (void *)src->pClearValues, sizeof(VkClearValue)*src->clearValueCount);
    }
}

safe_VkPhysicalDeviceSubgroupProperties::safe_VkPhysicalDeviceSubgroupProperties(const VkPhysicalDeviceSubgroupProperties* in_struct) :
    sType(in_struct->sType),
    subgroupSize(in_struct->subgroupSize),
    supportedStages(in_struct->supportedStages),
    supportedOperations(in_struct->supportedOperations),
    quadOperationsInAllStages(in_struct->quadOperationsInAllStages)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkPhysicalDeviceSubgroupProperties::safe_VkPhysicalDeviceSubgroupProperties() :
    pNext(nullptr)
{}

safe_VkPhysicalDeviceSubgroupProperties::safe_VkPhysicalDeviceSubgroupProperties(const safe_VkPhysicalDeviceSubgroupProperties& src)
{
    sType = src.sType;
    subgroupSize = src.subgroupSize;
    supportedStages = src.supportedStages;
    supportedOperations = src.supportedOperations;
    quadOperationsInAllStages = src.quadOperationsInAllStages;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkPhysicalDeviceSubgroupProperties& safe_VkPhysicalDeviceSubgroupProperties::operator=(const safe_VkPhysicalDeviceSubgroupProperties& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    subgroupSize = src.subgroupSize;
    supportedStages = src.supportedStages;
    supportedOperations = src.supportedOperations;
    quadOperationsInAllStages = src.quadOperationsInAllStages;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkPhysicalDeviceSubgroupProperties::~safe_VkPhysicalDeviceSubgroupProperties()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPhysicalDeviceSubgroupProperties::initialize(const VkPhysicalDeviceSubgroupProperties* in_struct)
{
    sType = in_struct->sType;
    subgroupSize = in_struct->subgroupSize;
    supportedStages = in_struct->supportedStages;
    supportedOperations = in_struct->supportedOperations;
    quadOperationsInAllStages = in_struct->quadOperationsInAllStages;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkPhysicalDeviceSubgroupProperties::initialize(const safe_VkPhysicalDeviceSubgroupProperties* src)
{
    sType = src->sType;
    subgroupSize = src->subgroupSize;
    supportedStages = src->supportedStages;
    supportedOperations = src->supportedOperations;
    quadOperationsInAllStages = src->quadOperationsInAllStages;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkBindBufferMemoryInfo::safe_VkBindBufferMemoryInfo(const VkBindBufferMemoryInfo* in_struct) :
    sType(in_struct->sType),
    buffer(in_struct->buffer),
    memory(in_struct->memory),
    memoryOffset(in_struct->memoryOffset)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkBindBufferMemoryInfo::safe_VkBindBufferMemoryInfo() :
    pNext(nullptr)
{}

safe_VkBindBufferMemoryInfo::safe_VkBindBufferMemoryInfo(const safe_VkBindBufferMemoryInfo& src)
{
    sType = src.sType;
    buffer = src.buffer;
    memory = src.memory;
    memoryOffset = src.memoryOffset;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkBindBufferMemoryInfo& safe_VkBindBufferMemoryInfo::operator=(const safe_VkBindBufferMemoryInfo& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    buffer = src.buffer;
    memory = src.memory;
    memoryOffset = src.memoryOffset;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkBindBufferMemoryInfo::~safe_VkBindBufferMemoryInfo()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkBindBufferMemoryInfo::initialize(const VkBindBufferMemoryInfo* in_struct)
{
    sType = in_struct->sType;
    buffer = in_struct->buffer;
    memory = in_struct->memory;
    memoryOffset = in_struct->memoryOffset;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkBindBufferMemoryInfo::initialize(const safe_VkBindBufferMemoryInfo* src)
{
    sType = src->sType;
    buffer = src->buffer;
    memory = src->memory;
    memoryOffset = src->memoryOffset;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkBindImageMemoryInfo::safe_VkBindImageMemoryInfo(const VkBindImageMemoryInfo* in_struct) :
    sType(in_struct->sType),
    image(in_struct->image),
    memory(in_struct->memory),
    memoryOffset(in_struct->memoryOffset)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkBindImageMemoryInfo::safe_VkBindImageMemoryInfo() :
    pNext(nullptr)
{}

safe_VkBindImageMemoryInfo::safe_VkBindImageMemoryInfo(const safe_VkBindImageMemoryInfo& src)
{
    sType = src.sType;
    image = src.image;
    memory = src.memory;
    memoryOffset = src.memoryOffset;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkBindImageMemoryInfo& safe_VkBindImageMemoryInfo::operator=(const safe_VkBindImageMemoryInfo& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    image = src.image;
    memory = src.memory;
    memoryOffset = src.memoryOffset;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkBindImageMemoryInfo::~safe_VkBindImageMemoryInfo()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkBindImageMemoryInfo::initialize(const VkBindImageMemoryInfo* in_struct)
{
    sType = in_struct->sType;
    image = in_struct->image;
    memory = in_struct->memory;
    memoryOffset = in_struct->memoryOffset;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkBindImageMemoryInfo::initialize(const safe_VkBindImageMemoryInfo* src)
{
    sType = src->sType;
    image = src->image;
    memory = src->memory;
    memoryOffset = src->memoryOffset;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkPhysicalDevice16BitStorageFeatures::safe_VkPhysicalDevice16BitStorageFeatures(const VkPhysicalDevice16BitStorageFeatures* in_struct) :
    sType(in_struct->sType),
    storageBuffer16BitAccess(in_struct->storageBuffer16BitAccess),
    uniformAndStorageBuffer16BitAccess(in_struct->uniformAndStorageBuffer16BitAccess),
    storagePushConstant16(in_struct->storagePushConstant16),
    storageInputOutput16(in_struct->storageInputOutput16)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkPhysicalDevice16BitStorageFeatures::safe_VkPhysicalDevice16BitStorageFeatures() :
    pNext(nullptr)
{}

safe_VkPhysicalDevice16BitStorageFeatures::safe_VkPhysicalDevice16BitStorageFeatures(const safe_VkPhysicalDevice16BitStorageFeatures& src)
{
    sType = src.sType;
    storageBuffer16BitAccess = src.storageBuffer16BitAccess;
    uniformAndStorageBuffer16BitAccess = src.uniformAndStorageBuffer16BitAccess;
    storagePushConstant16 = src.storagePushConstant16;
    storageInputOutput16 = src.storageInputOutput16;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkPhysicalDevice16BitStorageFeatures& safe_VkPhysicalDevice16BitStorageFeatures::operator=(const safe_VkPhysicalDevice16BitStorageFeatures& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    storageBuffer16BitAccess = src.storageBuffer16BitAccess;
    uniformAndStorageBuffer16BitAccess = src.uniformAndStorageBuffer16BitAccess;
    storagePushConstant16 = src.storagePushConstant16;
    storageInputOutput16 = src.storageInputOutput16;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkPhysicalDevice16BitStorageFeatures::~safe_VkPhysicalDevice16BitStorageFeatures()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPhysicalDevice16BitStorageFeatures::initialize(const VkPhysicalDevice16BitStorageFeatures* in_struct)
{
    sType = in_struct->sType;
    storageBuffer16BitAccess = in_struct->storageBuffer16BitAccess;
    uniformAndStorageBuffer16BitAccess = in_struct->uniformAndStorageBuffer16BitAccess;
    storagePushConstant16 = in_struct->storagePushConstant16;
    storageInputOutput16 = in_struct->storageInputOutput16;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkPhysicalDevice16BitStorageFeatures::initialize(const safe_VkPhysicalDevice16BitStorageFeatures* src)
{
    sType = src->sType;
    storageBuffer16BitAccess = src->storageBuffer16BitAccess;
    uniformAndStorageBuffer16BitAccess = src->uniformAndStorageBuffer16BitAccess;
    storagePushConstant16 = src->storagePushConstant16;
    storageInputOutput16 = src->storageInputOutput16;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkMemoryDedicatedRequirements::safe_VkMemoryDedicatedRequirements(const VkMemoryDedicatedRequirements* in_struct) :
    sType(in_struct->sType),
    prefersDedicatedAllocation(in_struct->prefersDedicatedAllocation),
    requiresDedicatedAllocation(in_struct->requiresDedicatedAllocation)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkMemoryDedicatedRequirements::safe_VkMemoryDedicatedRequirements() :
    pNext(nullptr)
{}

safe_VkMemoryDedicatedRequirements::safe_VkMemoryDedicatedRequirements(const safe_VkMemoryDedicatedRequirements& src)
{
    sType = src.sType;
    prefersDedicatedAllocation = src.prefersDedicatedAllocation;
    requiresDedicatedAllocation = src.requiresDedicatedAllocation;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkMemoryDedicatedRequirements& safe_VkMemoryDedicatedRequirements::operator=(const safe_VkMemoryDedicatedRequirements& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    prefersDedicatedAllocation = src.prefersDedicatedAllocation;
    requiresDedicatedAllocation = src.requiresDedicatedAllocation;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkMemoryDedicatedRequirements::~safe_VkMemoryDedicatedRequirements()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkMemoryDedicatedRequirements::initialize(const VkMemoryDedicatedRequirements* in_struct)
{
    sType = in_struct->sType;
    prefersDedicatedAllocation = in_struct->prefersDedicatedAllocation;
    requiresDedicatedAllocation = in_struct->requiresDedicatedAllocation;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkMemoryDedicatedRequirements::initialize(const safe_VkMemoryDedicatedRequirements* src)
{
    sType = src->sType;
    prefersDedicatedAllocation = src->prefersDedicatedAllocation;
    requiresDedicatedAllocation = src->requiresDedicatedAllocation;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkMemoryDedicatedAllocateInfo::safe_VkMemoryDedicatedAllocateInfo(const VkMemoryDedicatedAllocateInfo* in_struct) :
    sType(in_struct->sType),
    image(in_struct->image),
    buffer(in_struct->buffer)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkMemoryDedicatedAllocateInfo::safe_VkMemoryDedicatedAllocateInfo() :
    pNext(nullptr)
{}

safe_VkMemoryDedicatedAllocateInfo::safe_VkMemoryDedicatedAllocateInfo(const safe_VkMemoryDedicatedAllocateInfo& src)
{
    sType = src.sType;
    image = src.image;
    buffer = src.buffer;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkMemoryDedicatedAllocateInfo& safe_VkMemoryDedicatedAllocateInfo::operator=(const safe_VkMemoryDedicatedAllocateInfo& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    image = src.image;
    buffer = src.buffer;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkMemoryDedicatedAllocateInfo::~safe_VkMemoryDedicatedAllocateInfo()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkMemoryDedicatedAllocateInfo::initialize(const VkMemoryDedicatedAllocateInfo* in_struct)
{
    sType = in_struct->sType;
    image = in_struct->image;
    buffer = in_struct->buffer;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkMemoryDedicatedAllocateInfo::initialize(const safe_VkMemoryDedicatedAllocateInfo* src)
{
    sType = src->sType;
    image = src->image;
    buffer = src->buffer;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkMemoryAllocateFlagsInfo::safe_VkMemoryAllocateFlagsInfo(const VkMemoryAllocateFlagsInfo* in_struct) :
    sType(in_struct->sType),
    flags(in_struct->flags),
    deviceMask(in_struct->deviceMask)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkMemoryAllocateFlagsInfo::safe_VkMemoryAllocateFlagsInfo() :
    pNext(nullptr)
{}

safe_VkMemoryAllocateFlagsInfo::safe_VkMemoryAllocateFlagsInfo(const safe_VkMemoryAllocateFlagsInfo& src)
{
    sType = src.sType;
    flags = src.flags;
    deviceMask = src.deviceMask;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkMemoryAllocateFlagsInfo& safe_VkMemoryAllocateFlagsInfo::operator=(const safe_VkMemoryAllocateFlagsInfo& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    flags = src.flags;
    deviceMask = src.deviceMask;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkMemoryAllocateFlagsInfo::~safe_VkMemoryAllocateFlagsInfo()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkMemoryAllocateFlagsInfo::initialize(const VkMemoryAllocateFlagsInfo* in_struct)
{
    sType = in_struct->sType;
    flags = in_struct->flags;
    deviceMask = in_struct->deviceMask;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkMemoryAllocateFlagsInfo::initialize(const safe_VkMemoryAllocateFlagsInfo* src)
{
    sType = src->sType;
    flags = src->flags;
    deviceMask = src->deviceMask;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkDeviceGroupRenderPassBeginInfo::safe_VkDeviceGroupRenderPassBeginInfo(const VkDeviceGroupRenderPassBeginInfo* in_struct) :
    sType(in_struct->sType),
    deviceMask(in_struct->deviceMask),
    deviceRenderAreaCount(in_struct->deviceRenderAreaCount),
    pDeviceRenderAreas(nullptr)
{
    pNext = SafePnextCopy(in_struct->pNext);
    if (in_struct->pDeviceRenderAreas) {
        pDeviceRenderAreas = new VkRect2D[in_struct->deviceRenderAreaCount];
        memcpy ((void *)pDeviceRenderAreas, (void *)in_struct->pDeviceRenderAreas, sizeof(VkRect2D)*in_struct->deviceRenderAreaCount);
    }
}

safe_VkDeviceGroupRenderPassBeginInfo::safe_VkDeviceGroupRenderPassBeginInfo() :
    pNext(nullptr),
    pDeviceRenderAreas(nullptr)
{}

safe_VkDeviceGroupRenderPassBeginInfo::safe_VkDeviceGroupRenderPassBeginInfo(const safe_VkDeviceGroupRenderPassBeginInfo& src)
{
    sType = src.sType;
    deviceMask = src.deviceMask;
    deviceRenderAreaCount = src.deviceRenderAreaCount;
    pDeviceRenderAreas = nullptr;
    pNext = SafePnextCopy(src.pNext);
    if (src.pDeviceRenderAreas) {
        pDeviceRenderAreas = new VkRect2D[src.deviceRenderAreaCount];
        memcpy ((void *)pDeviceRenderAreas, (void *)src.pDeviceRenderAreas, sizeof(VkRect2D)*src.deviceRenderAreaCount);
    }
}

safe_VkDeviceGroupRenderPassBeginInfo& safe_VkDeviceGroupRenderPassBeginInfo::operator=(const safe_VkDeviceGroupRenderPassBeginInfo& src)
{
    if (&src == this) return *this;

    if (pDeviceRenderAreas)
        delete[] pDeviceRenderAreas;
    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    deviceMask = src.deviceMask;
    deviceRenderAreaCount = src.deviceRenderAreaCount;
    pDeviceRenderAreas = nullptr;
    pNext = SafePnextCopy(src.pNext);
    if (src.pDeviceRenderAreas) {
        pDeviceRenderAreas = new VkRect2D[src.deviceRenderAreaCount];
        memcpy ((void *)pDeviceRenderAreas, (void *)src.pDeviceRenderAreas, sizeof(VkRect2D)*src.deviceRenderAreaCount);
    }

    return *this;
}

safe_VkDeviceGroupRenderPassBeginInfo::~safe_VkDeviceGroupRenderPassBeginInfo()
{
    if (pDeviceRenderAreas)
        delete[] pDeviceRenderAreas;
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkDeviceGroupRenderPassBeginInfo::initialize(const VkDeviceGroupRenderPassBeginInfo* in_struct)
{
    sType = in_struct->sType;
    deviceMask = in_struct->deviceMask;
    deviceRenderAreaCount = in_struct->deviceRenderAreaCount;
    pDeviceRenderAreas = nullptr;
    pNext = SafePnextCopy(in_struct->pNext);
    if (in_struct->pDeviceRenderAreas) {
        pDeviceRenderAreas = new VkRect2D[in_struct->deviceRenderAreaCount];
        memcpy ((void *)pDeviceRenderAreas, (void *)in_struct->pDeviceRenderAreas, sizeof(VkRect2D)*in_struct->deviceRenderAreaCount);
    }
}

void safe_VkDeviceGroupRenderPassBeginInfo::initialize(const safe_VkDeviceGroupRenderPassBeginInfo* src)
{
    sType = src->sType;
    deviceMask = src->deviceMask;
    deviceRenderAreaCount = src->deviceRenderAreaCount;
    pDeviceRenderAreas = nullptr;
    pNext = SafePnextCopy(src->pNext);
    if (src->pDeviceRenderAreas) {
        pDeviceRenderAreas = new VkRect2D[src->deviceRenderAreaCount];
        memcpy ((void *)pDeviceRenderAreas, (void *)src->pDeviceRenderAreas, sizeof(VkRect2D)*src->deviceRenderAreaCount);
    }
}

safe_VkDeviceGroupCommandBufferBeginInfo::safe_VkDeviceGroupCommandBufferBeginInfo(const VkDeviceGroupCommandBufferBeginInfo* in_struct) :
    sType(in_struct->sType),
    deviceMask(in_struct->deviceMask)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkDeviceGroupCommandBufferBeginInfo::safe_VkDeviceGroupCommandBufferBeginInfo() :
    pNext(nullptr)
{}

safe_VkDeviceGroupCommandBufferBeginInfo::safe_VkDeviceGroupCommandBufferBeginInfo(const safe_VkDeviceGroupCommandBufferBeginInfo& src)
{
    sType = src.sType;
    deviceMask = src.deviceMask;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkDeviceGroupCommandBufferBeginInfo& safe_VkDeviceGroupCommandBufferBeginInfo::operator=(const safe_VkDeviceGroupCommandBufferBeginInfo& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    deviceMask = src.deviceMask;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkDeviceGroupCommandBufferBeginInfo::~safe_VkDeviceGroupCommandBufferBeginInfo()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkDeviceGroupCommandBufferBeginInfo::initialize(const VkDeviceGroupCommandBufferBeginInfo* in_struct)
{
    sType = in_struct->sType;
    deviceMask = in_struct->deviceMask;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkDeviceGroupCommandBufferBeginInfo::initialize(const safe_VkDeviceGroupCommandBufferBeginInfo* src)
{
    sType = src->sType;
    deviceMask = src->deviceMask;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkDeviceGroupSubmitInfo::safe_VkDeviceGroupSubmitInfo(const VkDeviceGroupSubmitInfo* in_struct) :
    sType(in_struct->sType),
    waitSemaphoreCount(in_struct->waitSemaphoreCount),
    pWaitSemaphoreDeviceIndices(nullptr),
    commandBufferCount(in_struct->commandBufferCount),
    pCommandBufferDeviceMasks(nullptr),
    signalSemaphoreCount(in_struct->signalSemaphoreCount),
    pSignalSemaphoreDeviceIndices(nullptr)
{
    pNext = SafePnextCopy(in_struct->pNext);
    if (in_struct->pWaitSemaphoreDeviceIndices) {
        pWaitSemaphoreDeviceIndices = new uint32_t[in_struct->waitSemaphoreCount];
        memcpy ((void *)pWaitSemaphoreDeviceIndices, (void *)in_struct->pWaitSemaphoreDeviceIndices, sizeof(uint32_t)*in_struct->waitSemaphoreCount);
    }
    if (in_struct->pCommandBufferDeviceMasks) {
        pCommandBufferDeviceMasks = new uint32_t[in_struct->commandBufferCount];
        memcpy ((void *)pCommandBufferDeviceMasks, (void *)in_struct->pCommandBufferDeviceMasks, sizeof(uint32_t)*in_struct->commandBufferCount);
    }
    if (in_struct->pSignalSemaphoreDeviceIndices) {
        pSignalSemaphoreDeviceIndices = new uint32_t[in_struct->signalSemaphoreCount];
        memcpy ((void *)pSignalSemaphoreDeviceIndices, (void *)in_struct->pSignalSemaphoreDeviceIndices, sizeof(uint32_t)*in_struct->signalSemaphoreCount);
    }
}

safe_VkDeviceGroupSubmitInfo::safe_VkDeviceGroupSubmitInfo() :
    pNext(nullptr),
    pWaitSemaphoreDeviceIndices(nullptr),
    pCommandBufferDeviceMasks(nullptr),
    pSignalSemaphoreDeviceIndices(nullptr)
{}

safe_VkDeviceGroupSubmitInfo::safe_VkDeviceGroupSubmitInfo(const safe_VkDeviceGroupSubmitInfo& src)
{
    sType = src.sType;
    waitSemaphoreCount = src.waitSemaphoreCount;
    pWaitSemaphoreDeviceIndices = nullptr;
    commandBufferCount = src.commandBufferCount;
    pCommandBufferDeviceMasks = nullptr;
    signalSemaphoreCount = src.signalSemaphoreCount;
    pSignalSemaphoreDeviceIndices = nullptr;
    pNext = SafePnextCopy(src.pNext);
    if (src.pWaitSemaphoreDeviceIndices) {
        pWaitSemaphoreDeviceIndices = new uint32_t[src.waitSemaphoreCount];
        memcpy ((void *)pWaitSemaphoreDeviceIndices, (void *)src.pWaitSemaphoreDeviceIndices, sizeof(uint32_t)*src.waitSemaphoreCount);
    }
    if (src.pCommandBufferDeviceMasks) {
        pCommandBufferDeviceMasks = new uint32_t[src.commandBufferCount];
        memcpy ((void *)pCommandBufferDeviceMasks, (void *)src.pCommandBufferDeviceMasks, sizeof(uint32_t)*src.commandBufferCount);
    }
    if (src.pSignalSemaphoreDeviceIndices) {
        pSignalSemaphoreDeviceIndices = new uint32_t[src.signalSemaphoreCount];
        memcpy ((void *)pSignalSemaphoreDeviceIndices, (void *)src.pSignalSemaphoreDeviceIndices, sizeof(uint32_t)*src.signalSemaphoreCount);
    }
}

safe_VkDeviceGroupSubmitInfo& safe_VkDeviceGroupSubmitInfo::operator=(const safe_VkDeviceGroupSubmitInfo& src)
{
    if (&src == this) return *this;

    if (pWaitSemaphoreDeviceIndices)
        delete[] pWaitSemaphoreDeviceIndices;
    if (pCommandBufferDeviceMasks)
        delete[] pCommandBufferDeviceMasks;
    if (pSignalSemaphoreDeviceIndices)
        delete[] pSignalSemaphoreDeviceIndices;
    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    waitSemaphoreCount = src.waitSemaphoreCount;
    pWaitSemaphoreDeviceIndices = nullptr;
    commandBufferCount = src.commandBufferCount;
    pCommandBufferDeviceMasks = nullptr;
    signalSemaphoreCount = src.signalSemaphoreCount;
    pSignalSemaphoreDeviceIndices = nullptr;
    pNext = SafePnextCopy(src.pNext);
    if (src.pWaitSemaphoreDeviceIndices) {
        pWaitSemaphoreDeviceIndices = new uint32_t[src.waitSemaphoreCount];
        memcpy ((void *)pWaitSemaphoreDeviceIndices, (void *)src.pWaitSemaphoreDeviceIndices, sizeof(uint32_t)*src.waitSemaphoreCount);
    }
    if (src.pCommandBufferDeviceMasks) {
        pCommandBufferDeviceMasks = new uint32_t[src.commandBufferCount];
        memcpy ((void *)pCommandBufferDeviceMasks, (void *)src.pCommandBufferDeviceMasks, sizeof(uint32_t)*src.commandBufferCount);
    }
    if (src.pSignalSemaphoreDeviceIndices) {
        pSignalSemaphoreDeviceIndices = new uint32_t[src.signalSemaphoreCount];
        memcpy ((void *)pSignalSemaphoreDeviceIndices, (void *)src.pSignalSemaphoreDeviceIndices, sizeof(uint32_t)*src.signalSemaphoreCount);
    }

    return *this;
}

safe_VkDeviceGroupSubmitInfo::~safe_VkDeviceGroupSubmitInfo()
{
    if (pWaitSemaphoreDeviceIndices)
        delete[] pWaitSemaphoreDeviceIndices;
    if (pCommandBufferDeviceMasks)
        delete[] pCommandBufferDeviceMasks;
    if (pSignalSemaphoreDeviceIndices)
        delete[] pSignalSemaphoreDeviceIndices;
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkDeviceGroupSubmitInfo::initialize(const VkDeviceGroupSubmitInfo* in_struct)
{
    sType = in_struct->sType;
    waitSemaphoreCount = in_struct->waitSemaphoreCount;
    pWaitSemaphoreDeviceIndices = nullptr;
    commandBufferCount = in_struct->commandBufferCount;
    pCommandBufferDeviceMasks = nullptr;
    signalSemaphoreCount = in_struct->signalSemaphoreCount;
    pSignalSemaphoreDeviceIndices = nullptr;
    pNext = SafePnextCopy(in_struct->pNext);
    if (in_struct->pWaitSemaphoreDeviceIndices) {
        pWaitSemaphoreDeviceIndices = new uint32_t[in_struct->waitSemaphoreCount];
        memcpy ((void *)pWaitSemaphoreDeviceIndices, (void *)in_struct->pWaitSemaphoreDeviceIndices, sizeof(uint32_t)*in_struct->waitSemaphoreCount);
    }
    if (in_struct->pCommandBufferDeviceMasks) {
        pCommandBufferDeviceMasks = new uint32_t[in_struct->commandBufferCount];
        memcpy ((void *)pCommandBufferDeviceMasks, (void *)in_struct->pCommandBufferDeviceMasks, sizeof(uint32_t)*in_struct->commandBufferCount);
    }
    if (in_struct->pSignalSemaphoreDeviceIndices) {
        pSignalSemaphoreDeviceIndices = new uint32_t[in_struct->signalSemaphoreCount];
        memcpy ((void *)pSignalSemaphoreDeviceIndices, (void *)in_struct->pSignalSemaphoreDeviceIndices, sizeof(uint32_t)*in_struct->signalSemaphoreCount);
    }
}

void safe_VkDeviceGroupSubmitInfo::initialize(const safe_VkDeviceGroupSubmitInfo* src)
{
    sType = src->sType;
    waitSemaphoreCount = src->waitSemaphoreCount;
    pWaitSemaphoreDeviceIndices = nullptr;
    commandBufferCount = src->commandBufferCount;
    pCommandBufferDeviceMasks = nullptr;
    signalSemaphoreCount = src->signalSemaphoreCount;
    pSignalSemaphoreDeviceIndices = nullptr;
    pNext = SafePnextCopy(src->pNext);
    if (src->pWaitSemaphoreDeviceIndices) {
        pWaitSemaphoreDeviceIndices = new uint32_t[src->waitSemaphoreCount];
        memcpy ((void *)pWaitSemaphoreDeviceIndices, (void *)src->pWaitSemaphoreDeviceIndices, sizeof(uint32_t)*src->waitSemaphoreCount);
    }
    if (src->pCommandBufferDeviceMasks) {
        pCommandBufferDeviceMasks = new uint32_t[src->commandBufferCount];
        memcpy ((void *)pCommandBufferDeviceMasks, (void *)src->pCommandBufferDeviceMasks, sizeof(uint32_t)*src->commandBufferCount);
    }
    if (src->pSignalSemaphoreDeviceIndices) {
        pSignalSemaphoreDeviceIndices = new uint32_t[src->signalSemaphoreCount];
        memcpy ((void *)pSignalSemaphoreDeviceIndices, (void *)src->pSignalSemaphoreDeviceIndices, sizeof(uint32_t)*src->signalSemaphoreCount);
    }
}

safe_VkDeviceGroupBindSparseInfo::safe_VkDeviceGroupBindSparseInfo(const VkDeviceGroupBindSparseInfo* in_struct) :
    sType(in_struct->sType),
    resourceDeviceIndex(in_struct->resourceDeviceIndex),
    memoryDeviceIndex(in_struct->memoryDeviceIndex)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkDeviceGroupBindSparseInfo::safe_VkDeviceGroupBindSparseInfo() :
    pNext(nullptr)
{}

safe_VkDeviceGroupBindSparseInfo::safe_VkDeviceGroupBindSparseInfo(const safe_VkDeviceGroupBindSparseInfo& src)
{
    sType = src.sType;
    resourceDeviceIndex = src.resourceDeviceIndex;
    memoryDeviceIndex = src.memoryDeviceIndex;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkDeviceGroupBindSparseInfo& safe_VkDeviceGroupBindSparseInfo::operator=(const safe_VkDeviceGroupBindSparseInfo& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    resourceDeviceIndex = src.resourceDeviceIndex;
    memoryDeviceIndex = src.memoryDeviceIndex;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkDeviceGroupBindSparseInfo::~safe_VkDeviceGroupBindSparseInfo()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkDeviceGroupBindSparseInfo::initialize(const VkDeviceGroupBindSparseInfo* in_struct)
{
    sType = in_struct->sType;
    resourceDeviceIndex = in_struct->resourceDeviceIndex;
    memoryDeviceIndex = in_struct->memoryDeviceIndex;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkDeviceGroupBindSparseInfo::initialize(const safe_VkDeviceGroupBindSparseInfo* src)
{
    sType = src->sType;
    resourceDeviceIndex = src->resourceDeviceIndex;
    memoryDeviceIndex = src->memoryDeviceIndex;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkBindBufferMemoryDeviceGroupInfo::safe_VkBindBufferMemoryDeviceGroupInfo(const VkBindBufferMemoryDeviceGroupInfo* in_struct) :
    sType(in_struct->sType),
    deviceIndexCount(in_struct->deviceIndexCount),
    pDeviceIndices(nullptr)
{
    pNext = SafePnextCopy(in_struct->pNext);
    if (in_struct->pDeviceIndices) {
        pDeviceIndices = new uint32_t[in_struct->deviceIndexCount];
        memcpy ((void *)pDeviceIndices, (void *)in_struct->pDeviceIndices, sizeof(uint32_t)*in_struct->deviceIndexCount);
    }
}

safe_VkBindBufferMemoryDeviceGroupInfo::safe_VkBindBufferMemoryDeviceGroupInfo() :
    pNext(nullptr),
    pDeviceIndices(nullptr)
{}

safe_VkBindBufferMemoryDeviceGroupInfo::safe_VkBindBufferMemoryDeviceGroupInfo(const safe_VkBindBufferMemoryDeviceGroupInfo& src)
{
    sType = src.sType;
    deviceIndexCount = src.deviceIndexCount;
    pDeviceIndices = nullptr;
    pNext = SafePnextCopy(src.pNext);
    if (src.pDeviceIndices) {
        pDeviceIndices = new uint32_t[src.deviceIndexCount];
        memcpy ((void *)pDeviceIndices, (void *)src.pDeviceIndices, sizeof(uint32_t)*src.deviceIndexCount);
    }
}

safe_VkBindBufferMemoryDeviceGroupInfo& safe_VkBindBufferMemoryDeviceGroupInfo::operator=(const safe_VkBindBufferMemoryDeviceGroupInfo& src)
{
    if (&src == this) return *this;

    if (pDeviceIndices)
        delete[] pDeviceIndices;
    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    deviceIndexCount = src.deviceIndexCount;
    pDeviceIndices = nullptr;
    pNext = SafePnextCopy(src.pNext);
    if (src.pDeviceIndices) {
        pDeviceIndices = new uint32_t[src.deviceIndexCount];
        memcpy ((void *)pDeviceIndices, (void *)src.pDeviceIndices, sizeof(uint32_t)*src.deviceIndexCount);
    }

    return *this;
}

safe_VkBindBufferMemoryDeviceGroupInfo::~safe_VkBindBufferMemoryDeviceGroupInfo()
{
    if (pDeviceIndices)
        delete[] pDeviceIndices;
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkBindBufferMemoryDeviceGroupInfo::initialize(const VkBindBufferMemoryDeviceGroupInfo* in_struct)
{
    sType = in_struct->sType;
    deviceIndexCount = in_struct->deviceIndexCount;
    pDeviceIndices = nullptr;
    pNext = SafePnextCopy(in_struct->pNext);
    if (in_struct->pDeviceIndices) {
        pDeviceIndices = new uint32_t[in_struct->deviceIndexCount];
        memcpy ((void *)pDeviceIndices, (void *)in_struct->pDeviceIndices, sizeof(uint32_t)*in_struct->deviceIndexCount);
    }
}

void safe_VkBindBufferMemoryDeviceGroupInfo::initialize(const safe_VkBindBufferMemoryDeviceGroupInfo* src)
{
    sType = src->sType;
    deviceIndexCount = src->deviceIndexCount;
    pDeviceIndices = nullptr;
    pNext = SafePnextCopy(src->pNext);
    if (src->pDeviceIndices) {
        pDeviceIndices = new uint32_t[src->deviceIndexCount];
        memcpy ((void *)pDeviceIndices, (void *)src->pDeviceIndices, sizeof(uint32_t)*src->deviceIndexCount);
    }
}

safe_VkBindImageMemoryDeviceGroupInfo::safe_VkBindImageMemoryDeviceGroupInfo(const VkBindImageMemoryDeviceGroupInfo* in_struct) :
    sType(in_struct->sType),
    deviceIndexCount(in_struct->deviceIndexCount),
    pDeviceIndices(nullptr),
    splitInstanceBindRegionCount(in_struct->splitInstanceBindRegionCount),
    pSplitInstanceBindRegions(nullptr)
{
    pNext = SafePnextCopy(in_struct->pNext);
    if (in_struct->pDeviceIndices) {
        pDeviceIndices = new uint32_t[in_struct->deviceIndexCount];
        memcpy ((void *)pDeviceIndices, (void *)in_struct->pDeviceIndices, sizeof(uint32_t)*in_struct->deviceIndexCount);
    }
    if (in_struct->pSplitInstanceBindRegions) {
        pSplitInstanceBindRegions = new VkRect2D[in_struct->splitInstanceBindRegionCount];
        memcpy ((void *)pSplitInstanceBindRegions, (void *)in_struct->pSplitInstanceBindRegions, sizeof(VkRect2D)*in_struct->splitInstanceBindRegionCount);
    }
}

safe_VkBindImageMemoryDeviceGroupInfo::safe_VkBindImageMemoryDeviceGroupInfo() :
    pNext(nullptr),
    pDeviceIndices(nullptr),
    pSplitInstanceBindRegions(nullptr)
{}

safe_VkBindImageMemoryDeviceGroupInfo::safe_VkBindImageMemoryDeviceGroupInfo(const safe_VkBindImageMemoryDeviceGroupInfo& src)
{
    sType = src.sType;
    deviceIndexCount = src.deviceIndexCount;
    pDeviceIndices = nullptr;
    splitInstanceBindRegionCount = src.splitInstanceBindRegionCount;
    pSplitInstanceBindRegions = nullptr;
    pNext = SafePnextCopy(src.pNext);
    if (src.pDeviceIndices) {
        pDeviceIndices = new uint32_t[src.deviceIndexCount];
        memcpy ((void *)pDeviceIndices, (void *)src.pDeviceIndices, sizeof(uint32_t)*src.deviceIndexCount);
    }
    if (src.pSplitInstanceBindRegions) {
        pSplitInstanceBindRegions = new VkRect2D[src.splitInstanceBindRegionCount];
        memcpy ((void *)pSplitInstanceBindRegions, (void *)src.pSplitInstanceBindRegions, sizeof(VkRect2D)*src.splitInstanceBindRegionCount);
    }
}

safe_VkBindImageMemoryDeviceGroupInfo& safe_VkBindImageMemoryDeviceGroupInfo::operator=(const safe_VkBindImageMemoryDeviceGroupInfo& src)
{
    if (&src == this) return *this;

    if (pDeviceIndices)
        delete[] pDeviceIndices;
    if (pSplitInstanceBindRegions)
        delete[] pSplitInstanceBindRegions;
    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    deviceIndexCount = src.deviceIndexCount;
    pDeviceIndices = nullptr;
    splitInstanceBindRegionCount = src.splitInstanceBindRegionCount;
    pSplitInstanceBindRegions = nullptr;
    pNext = SafePnextCopy(src.pNext);
    if (src.pDeviceIndices) {
        pDeviceIndices = new uint32_t[src.deviceIndexCount];
        memcpy ((void *)pDeviceIndices, (void *)src.pDeviceIndices, sizeof(uint32_t)*src.deviceIndexCount);
    }
    if (src.pSplitInstanceBindRegions) {
        pSplitInstanceBindRegions = new VkRect2D[src.splitInstanceBindRegionCount];
        memcpy ((void *)pSplitInstanceBindRegions, (void *)src.pSplitInstanceBindRegions, sizeof(VkRect2D)*src.splitInstanceBindRegionCount);
    }

    return *this;
}

safe_VkBindImageMemoryDeviceGroupInfo::~safe_VkBindImageMemoryDeviceGroupInfo()
{
    if (pDeviceIndices)
        delete[] pDeviceIndices;
    if (pSplitInstanceBindRegions)
        delete[] pSplitInstanceBindRegions;
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkBindImageMemoryDeviceGroupInfo::initialize(const VkBindImageMemoryDeviceGroupInfo* in_struct)
{
    sType = in_struct->sType;
    deviceIndexCount = in_struct->deviceIndexCount;
    pDeviceIndices = nullptr;
    splitInstanceBindRegionCount = in_struct->splitInstanceBindRegionCount;
    pSplitInstanceBindRegions = nullptr;
    pNext = SafePnextCopy(in_struct->pNext);
    if (in_struct->pDeviceIndices) {
        pDeviceIndices = new uint32_t[in_struct->deviceIndexCount];
        memcpy ((void *)pDeviceIndices, (void *)in_struct->pDeviceIndices, sizeof(uint32_t)*in_struct->deviceIndexCount);
    }
    if (in_struct->pSplitInstanceBindRegions) {
        pSplitInstanceBindRegions = new VkRect2D[in_struct->splitInstanceBindRegionCount];
        memcpy ((void *)pSplitInstanceBindRegions, (void *)in_struct->pSplitInstanceBindRegions, sizeof(VkRect2D)*in_struct->splitInstanceBindRegionCount);
    }
}

void safe_VkBindImageMemoryDeviceGroupInfo::initialize(const safe_VkBindImageMemoryDeviceGroupInfo* src)
{
    sType = src->sType;
    deviceIndexCount = src->deviceIndexCount;
    pDeviceIndices = nullptr;
    splitInstanceBindRegionCount = src->splitInstanceBindRegionCount;
    pSplitInstanceBindRegions = nullptr;
    pNext = SafePnextCopy(src->pNext);
    if (src->pDeviceIndices) {
        pDeviceIndices = new uint32_t[src->deviceIndexCount];
        memcpy ((void *)pDeviceIndices, (void *)src->pDeviceIndices, sizeof(uint32_t)*src->deviceIndexCount);
    }
    if (src->pSplitInstanceBindRegions) {
        pSplitInstanceBindRegions = new VkRect2D[src->splitInstanceBindRegionCount];
        memcpy ((void *)pSplitInstanceBindRegions, (void *)src->pSplitInstanceBindRegions, sizeof(VkRect2D)*src->splitInstanceBindRegionCount);
    }
}

safe_VkPhysicalDeviceGroupProperties::safe_VkPhysicalDeviceGroupProperties(const VkPhysicalDeviceGroupProperties* in_struct) :
    sType(in_struct->sType),
    physicalDeviceCount(in_struct->physicalDeviceCount),
    subsetAllocation(in_struct->subsetAllocation)
{
    pNext = SafePnextCopy(in_struct->pNext);
    for (uint32_t i = 0; i < VK_MAX_DEVICE_GROUP_SIZE; ++i) {
        physicalDevices[i] = in_struct->physicalDevices[i];
    }
}

safe_VkPhysicalDeviceGroupProperties::safe_VkPhysicalDeviceGroupProperties() :
    pNext(nullptr)
{}

safe_VkPhysicalDeviceGroupProperties::safe_VkPhysicalDeviceGroupProperties(const safe_VkPhysicalDeviceGroupProperties& src)
{
    sType = src.sType;
    physicalDeviceCount = src.physicalDeviceCount;
    subsetAllocation = src.subsetAllocation;
    pNext = SafePnextCopy(src.pNext);
    for (uint32_t i = 0; i < VK_MAX_DEVICE_GROUP_SIZE; ++i) {
        physicalDevices[i] = src.physicalDevices[i];
    }
}

safe_VkPhysicalDeviceGroupProperties& safe_VkPhysicalDeviceGroupProperties::operator=(const safe_VkPhysicalDeviceGroupProperties& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    physicalDeviceCount = src.physicalDeviceCount;
    subsetAllocation = src.subsetAllocation;
    pNext = SafePnextCopy(src.pNext);
    for (uint32_t i = 0; i < VK_MAX_DEVICE_GROUP_SIZE; ++i) {
        physicalDevices[i] = src.physicalDevices[i];
    }

    return *this;
}

safe_VkPhysicalDeviceGroupProperties::~safe_VkPhysicalDeviceGroupProperties()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPhysicalDeviceGroupProperties::initialize(const VkPhysicalDeviceGroupProperties* in_struct)
{
    sType = in_struct->sType;
    physicalDeviceCount = in_struct->physicalDeviceCount;
    subsetAllocation = in_struct->subsetAllocation;
    pNext = SafePnextCopy(in_struct->pNext);
    for (uint32_t i = 0; i < VK_MAX_DEVICE_GROUP_SIZE; ++i) {
        physicalDevices[i] = in_struct->physicalDevices[i];
    }
}

void safe_VkPhysicalDeviceGroupProperties::initialize(const safe_VkPhysicalDeviceGroupProperties* src)
{
    sType = src->sType;
    physicalDeviceCount = src->physicalDeviceCount;
    subsetAllocation = src->subsetAllocation;
    pNext = SafePnextCopy(src->pNext);
    for (uint32_t i = 0; i < VK_MAX_DEVICE_GROUP_SIZE; ++i) {
        physicalDevices[i] = src->physicalDevices[i];
    }
}

safe_VkDeviceGroupDeviceCreateInfo::safe_VkDeviceGroupDeviceCreateInfo(const VkDeviceGroupDeviceCreateInfo* in_struct) :
    sType(in_struct->sType),
    physicalDeviceCount(in_struct->physicalDeviceCount),
    pPhysicalDevices(nullptr)
{
    pNext = SafePnextCopy(in_struct->pNext);
    if (in_struct->pPhysicalDevices) {
        pPhysicalDevices = new VkPhysicalDevice[in_struct->physicalDeviceCount];
        memcpy ((void *)pPhysicalDevices, (void *)in_struct->pPhysicalDevices, sizeof(VkPhysicalDevice)*in_struct->physicalDeviceCount);
    }
}

safe_VkDeviceGroupDeviceCreateInfo::safe_VkDeviceGroupDeviceCreateInfo() :
    pNext(nullptr),
    pPhysicalDevices(nullptr)
{}

safe_VkDeviceGroupDeviceCreateInfo::safe_VkDeviceGroupDeviceCreateInfo(const safe_VkDeviceGroupDeviceCreateInfo& src)
{
    sType = src.sType;
    physicalDeviceCount = src.physicalDeviceCount;
    pPhysicalDevices = nullptr;
    pNext = SafePnextCopy(src.pNext);
    if (src.pPhysicalDevices) {
        pPhysicalDevices = new VkPhysicalDevice[src.physicalDeviceCount];
        memcpy ((void *)pPhysicalDevices, (void *)src.pPhysicalDevices, sizeof(VkPhysicalDevice)*src.physicalDeviceCount);
    }
}

safe_VkDeviceGroupDeviceCreateInfo& safe_VkDeviceGroupDeviceCreateInfo::operator=(const safe_VkDeviceGroupDeviceCreateInfo& src)
{
    if (&src == this) return *this;

    if (pPhysicalDevices)
        delete[] pPhysicalDevices;
    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    physicalDeviceCount = src.physicalDeviceCount;
    pPhysicalDevices = nullptr;
    pNext = SafePnextCopy(src.pNext);
    if (src.pPhysicalDevices) {
        pPhysicalDevices = new VkPhysicalDevice[src.physicalDeviceCount];
        memcpy ((void *)pPhysicalDevices, (void *)src.pPhysicalDevices, sizeof(VkPhysicalDevice)*src.physicalDeviceCount);
    }

    return *this;
}

safe_VkDeviceGroupDeviceCreateInfo::~safe_VkDeviceGroupDeviceCreateInfo()
{
    if (pPhysicalDevices)
        delete[] pPhysicalDevices;
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkDeviceGroupDeviceCreateInfo::initialize(const VkDeviceGroupDeviceCreateInfo* in_struct)
{
    sType = in_struct->sType;
    physicalDeviceCount = in_struct->physicalDeviceCount;
    pPhysicalDevices = nullptr;
    pNext = SafePnextCopy(in_struct->pNext);
    if (in_struct->pPhysicalDevices) {
        pPhysicalDevices = new VkPhysicalDevice[in_struct->physicalDeviceCount];
        memcpy ((void *)pPhysicalDevices, (void *)in_struct->pPhysicalDevices, sizeof(VkPhysicalDevice)*in_struct->physicalDeviceCount);
    }
}

void safe_VkDeviceGroupDeviceCreateInfo::initialize(const safe_VkDeviceGroupDeviceCreateInfo* src)
{
    sType = src->sType;
    physicalDeviceCount = src->physicalDeviceCount;
    pPhysicalDevices = nullptr;
    pNext = SafePnextCopy(src->pNext);
    if (src->pPhysicalDevices) {
        pPhysicalDevices = new VkPhysicalDevice[src->physicalDeviceCount];
        memcpy ((void *)pPhysicalDevices, (void *)src->pPhysicalDevices, sizeof(VkPhysicalDevice)*src->physicalDeviceCount);
    }
}

safe_VkBufferMemoryRequirementsInfo2::safe_VkBufferMemoryRequirementsInfo2(const VkBufferMemoryRequirementsInfo2* in_struct) :
    sType(in_struct->sType),
    buffer(in_struct->buffer)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkBufferMemoryRequirementsInfo2::safe_VkBufferMemoryRequirementsInfo2() :
    pNext(nullptr)
{}

safe_VkBufferMemoryRequirementsInfo2::safe_VkBufferMemoryRequirementsInfo2(const safe_VkBufferMemoryRequirementsInfo2& src)
{
    sType = src.sType;
    buffer = src.buffer;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkBufferMemoryRequirementsInfo2& safe_VkBufferMemoryRequirementsInfo2::operator=(const safe_VkBufferMemoryRequirementsInfo2& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    buffer = src.buffer;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkBufferMemoryRequirementsInfo2::~safe_VkBufferMemoryRequirementsInfo2()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkBufferMemoryRequirementsInfo2::initialize(const VkBufferMemoryRequirementsInfo2* in_struct)
{
    sType = in_struct->sType;
    buffer = in_struct->buffer;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkBufferMemoryRequirementsInfo2::initialize(const safe_VkBufferMemoryRequirementsInfo2* src)
{
    sType = src->sType;
    buffer = src->buffer;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkImageMemoryRequirementsInfo2::safe_VkImageMemoryRequirementsInfo2(const VkImageMemoryRequirementsInfo2* in_struct) :
    sType(in_struct->sType),
    image(in_struct->image)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkImageMemoryRequirementsInfo2::safe_VkImageMemoryRequirementsInfo2() :
    pNext(nullptr)
{}

safe_VkImageMemoryRequirementsInfo2::safe_VkImageMemoryRequirementsInfo2(const safe_VkImageMemoryRequirementsInfo2& src)
{
    sType = src.sType;
    image = src.image;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkImageMemoryRequirementsInfo2& safe_VkImageMemoryRequirementsInfo2::operator=(const safe_VkImageMemoryRequirementsInfo2& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    image = src.image;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkImageMemoryRequirementsInfo2::~safe_VkImageMemoryRequirementsInfo2()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkImageMemoryRequirementsInfo2::initialize(const VkImageMemoryRequirementsInfo2* in_struct)
{
    sType = in_struct->sType;
    image = in_struct->image;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkImageMemoryRequirementsInfo2::initialize(const safe_VkImageMemoryRequirementsInfo2* src)
{
    sType = src->sType;
    image = src->image;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkImageSparseMemoryRequirementsInfo2::safe_VkImageSparseMemoryRequirementsInfo2(const VkImageSparseMemoryRequirementsInfo2* in_struct) :
    sType(in_struct->sType),
    image(in_struct->image)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkImageSparseMemoryRequirementsInfo2::safe_VkImageSparseMemoryRequirementsInfo2() :
    pNext(nullptr)
{}

safe_VkImageSparseMemoryRequirementsInfo2::safe_VkImageSparseMemoryRequirementsInfo2(const safe_VkImageSparseMemoryRequirementsInfo2& src)
{
    sType = src.sType;
    image = src.image;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkImageSparseMemoryRequirementsInfo2& safe_VkImageSparseMemoryRequirementsInfo2::operator=(const safe_VkImageSparseMemoryRequirementsInfo2& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    image = src.image;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkImageSparseMemoryRequirementsInfo2::~safe_VkImageSparseMemoryRequirementsInfo2()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkImageSparseMemoryRequirementsInfo2::initialize(const VkImageSparseMemoryRequirementsInfo2* in_struct)
{
    sType = in_struct->sType;
    image = in_struct->image;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkImageSparseMemoryRequirementsInfo2::initialize(const safe_VkImageSparseMemoryRequirementsInfo2* src)
{
    sType = src->sType;
    image = src->image;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkMemoryRequirements2::safe_VkMemoryRequirements2(const VkMemoryRequirements2* in_struct) :
    sType(in_struct->sType),
    memoryRequirements(in_struct->memoryRequirements)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkMemoryRequirements2::safe_VkMemoryRequirements2() :
    pNext(nullptr)
{}

safe_VkMemoryRequirements2::safe_VkMemoryRequirements2(const safe_VkMemoryRequirements2& src)
{
    sType = src.sType;
    memoryRequirements = src.memoryRequirements;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkMemoryRequirements2& safe_VkMemoryRequirements2::operator=(const safe_VkMemoryRequirements2& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    memoryRequirements = src.memoryRequirements;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkMemoryRequirements2::~safe_VkMemoryRequirements2()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkMemoryRequirements2::initialize(const VkMemoryRequirements2* in_struct)
{
    sType = in_struct->sType;
    memoryRequirements = in_struct->memoryRequirements;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkMemoryRequirements2::initialize(const safe_VkMemoryRequirements2* src)
{
    sType = src->sType;
    memoryRequirements = src->memoryRequirements;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkSparseImageMemoryRequirements2::safe_VkSparseImageMemoryRequirements2(const VkSparseImageMemoryRequirements2* in_struct) :
    sType(in_struct->sType),
    memoryRequirements(in_struct->memoryRequirements)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkSparseImageMemoryRequirements2::safe_VkSparseImageMemoryRequirements2() :
    pNext(nullptr)
{}

safe_VkSparseImageMemoryRequirements2::safe_VkSparseImageMemoryRequirements2(const safe_VkSparseImageMemoryRequirements2& src)
{
    sType = src.sType;
    memoryRequirements = src.memoryRequirements;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkSparseImageMemoryRequirements2& safe_VkSparseImageMemoryRequirements2::operator=(const safe_VkSparseImageMemoryRequirements2& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    memoryRequirements = src.memoryRequirements;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkSparseImageMemoryRequirements2::~safe_VkSparseImageMemoryRequirements2()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkSparseImageMemoryRequirements2::initialize(const VkSparseImageMemoryRequirements2* in_struct)
{
    sType = in_struct->sType;
    memoryRequirements = in_struct->memoryRequirements;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkSparseImageMemoryRequirements2::initialize(const safe_VkSparseImageMemoryRequirements2* src)
{
    sType = src->sType;
    memoryRequirements = src->memoryRequirements;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkPhysicalDeviceFeatures2::safe_VkPhysicalDeviceFeatures2(const VkPhysicalDeviceFeatures2* in_struct) :
    sType(in_struct->sType),
    features(in_struct->features)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkPhysicalDeviceFeatures2::safe_VkPhysicalDeviceFeatures2() :
    pNext(nullptr)
{}

safe_VkPhysicalDeviceFeatures2::safe_VkPhysicalDeviceFeatures2(const safe_VkPhysicalDeviceFeatures2& src)
{
    sType = src.sType;
    features = src.features;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkPhysicalDeviceFeatures2& safe_VkPhysicalDeviceFeatures2::operator=(const safe_VkPhysicalDeviceFeatures2& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    features = src.features;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkPhysicalDeviceFeatures2::~safe_VkPhysicalDeviceFeatures2()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPhysicalDeviceFeatures2::initialize(const VkPhysicalDeviceFeatures2* in_struct)
{
    sType = in_struct->sType;
    features = in_struct->features;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkPhysicalDeviceFeatures2::initialize(const safe_VkPhysicalDeviceFeatures2* src)
{
    sType = src->sType;
    features = src->features;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkPhysicalDeviceProperties2::safe_VkPhysicalDeviceProperties2(const VkPhysicalDeviceProperties2* in_struct) :
    sType(in_struct->sType),
    properties(in_struct->properties)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkPhysicalDeviceProperties2::safe_VkPhysicalDeviceProperties2() :
    pNext(nullptr)
{}

safe_VkPhysicalDeviceProperties2::safe_VkPhysicalDeviceProperties2(const safe_VkPhysicalDeviceProperties2& src)
{
    sType = src.sType;
    properties = src.properties;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkPhysicalDeviceProperties2& safe_VkPhysicalDeviceProperties2::operator=(const safe_VkPhysicalDeviceProperties2& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    properties = src.properties;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkPhysicalDeviceProperties2::~safe_VkPhysicalDeviceProperties2()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPhysicalDeviceProperties2::initialize(const VkPhysicalDeviceProperties2* in_struct)
{
    sType = in_struct->sType;
    properties = in_struct->properties;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkPhysicalDeviceProperties2::initialize(const safe_VkPhysicalDeviceProperties2* src)
{
    sType = src->sType;
    properties = src->properties;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkFormatProperties2::safe_VkFormatProperties2(const VkFormatProperties2* in_struct) :
    sType(in_struct->sType),
    formatProperties(in_struct->formatProperties)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkFormatProperties2::safe_VkFormatProperties2() :
    pNext(nullptr)
{}

safe_VkFormatProperties2::safe_VkFormatProperties2(const safe_VkFormatProperties2& src)
{
    sType = src.sType;
    formatProperties = src.formatProperties;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkFormatProperties2& safe_VkFormatProperties2::operator=(const safe_VkFormatProperties2& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    formatProperties = src.formatProperties;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkFormatProperties2::~safe_VkFormatProperties2()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkFormatProperties2::initialize(const VkFormatProperties2* in_struct)
{
    sType = in_struct->sType;
    formatProperties = in_struct->formatProperties;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkFormatProperties2::initialize(const safe_VkFormatProperties2* src)
{
    sType = src->sType;
    formatProperties = src->formatProperties;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkImageFormatProperties2::safe_VkImageFormatProperties2(const VkImageFormatProperties2* in_struct) :
    sType(in_struct->sType),
    imageFormatProperties(in_struct->imageFormatProperties)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkImageFormatProperties2::safe_VkImageFormatProperties2() :
    pNext(nullptr)
{}

safe_VkImageFormatProperties2::safe_VkImageFormatProperties2(const safe_VkImageFormatProperties2& src)
{
    sType = src.sType;
    imageFormatProperties = src.imageFormatProperties;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkImageFormatProperties2& safe_VkImageFormatProperties2::operator=(const safe_VkImageFormatProperties2& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    imageFormatProperties = src.imageFormatProperties;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkImageFormatProperties2::~safe_VkImageFormatProperties2()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkImageFormatProperties2::initialize(const VkImageFormatProperties2* in_struct)
{
    sType = in_struct->sType;
    imageFormatProperties = in_struct->imageFormatProperties;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkImageFormatProperties2::initialize(const safe_VkImageFormatProperties2* src)
{
    sType = src->sType;
    imageFormatProperties = src->imageFormatProperties;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkPhysicalDeviceImageFormatInfo2::safe_VkPhysicalDeviceImageFormatInfo2(const VkPhysicalDeviceImageFormatInfo2* in_struct) :
    sType(in_struct->sType),
    format(in_struct->format),
    type(in_struct->type),
    tiling(in_struct->tiling),
    usage(in_struct->usage),
    flags(in_struct->flags)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkPhysicalDeviceImageFormatInfo2::safe_VkPhysicalDeviceImageFormatInfo2() :
    pNext(nullptr)
{}

safe_VkPhysicalDeviceImageFormatInfo2::safe_VkPhysicalDeviceImageFormatInfo2(const safe_VkPhysicalDeviceImageFormatInfo2& src)
{
    sType = src.sType;
    format = src.format;
    type = src.type;
    tiling = src.tiling;
    usage = src.usage;
    flags = src.flags;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkPhysicalDeviceImageFormatInfo2& safe_VkPhysicalDeviceImageFormatInfo2::operator=(const safe_VkPhysicalDeviceImageFormatInfo2& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    format = src.format;
    type = src.type;
    tiling = src.tiling;
    usage = src.usage;
    flags = src.flags;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkPhysicalDeviceImageFormatInfo2::~safe_VkPhysicalDeviceImageFormatInfo2()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPhysicalDeviceImageFormatInfo2::initialize(const VkPhysicalDeviceImageFormatInfo2* in_struct)
{
    sType = in_struct->sType;
    format = in_struct->format;
    type = in_struct->type;
    tiling = in_struct->tiling;
    usage = in_struct->usage;
    flags = in_struct->flags;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkPhysicalDeviceImageFormatInfo2::initialize(const safe_VkPhysicalDeviceImageFormatInfo2* src)
{
    sType = src->sType;
    format = src->format;
    type = src->type;
    tiling = src->tiling;
    usage = src->usage;
    flags = src->flags;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkQueueFamilyProperties2::safe_VkQueueFamilyProperties2(const VkQueueFamilyProperties2* in_struct) :
    sType(in_struct->sType),
    queueFamilyProperties(in_struct->queueFamilyProperties)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkQueueFamilyProperties2::safe_VkQueueFamilyProperties2() :
    pNext(nullptr)
{}

safe_VkQueueFamilyProperties2::safe_VkQueueFamilyProperties2(const safe_VkQueueFamilyProperties2& src)
{
    sType = src.sType;
    queueFamilyProperties = src.queueFamilyProperties;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkQueueFamilyProperties2& safe_VkQueueFamilyProperties2::operator=(const safe_VkQueueFamilyProperties2& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    queueFamilyProperties = src.queueFamilyProperties;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkQueueFamilyProperties2::~safe_VkQueueFamilyProperties2()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkQueueFamilyProperties2::initialize(const VkQueueFamilyProperties2* in_struct)
{
    sType = in_struct->sType;
    queueFamilyProperties = in_struct->queueFamilyProperties;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkQueueFamilyProperties2::initialize(const safe_VkQueueFamilyProperties2* src)
{
    sType = src->sType;
    queueFamilyProperties = src->queueFamilyProperties;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkPhysicalDeviceMemoryProperties2::safe_VkPhysicalDeviceMemoryProperties2(const VkPhysicalDeviceMemoryProperties2* in_struct) :
    sType(in_struct->sType),
    memoryProperties(in_struct->memoryProperties)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkPhysicalDeviceMemoryProperties2::safe_VkPhysicalDeviceMemoryProperties2() :
    pNext(nullptr)
{}

safe_VkPhysicalDeviceMemoryProperties2::safe_VkPhysicalDeviceMemoryProperties2(const safe_VkPhysicalDeviceMemoryProperties2& src)
{
    sType = src.sType;
    memoryProperties = src.memoryProperties;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkPhysicalDeviceMemoryProperties2& safe_VkPhysicalDeviceMemoryProperties2::operator=(const safe_VkPhysicalDeviceMemoryProperties2& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    memoryProperties = src.memoryProperties;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkPhysicalDeviceMemoryProperties2::~safe_VkPhysicalDeviceMemoryProperties2()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPhysicalDeviceMemoryProperties2::initialize(const VkPhysicalDeviceMemoryProperties2* in_struct)
{
    sType = in_struct->sType;
    memoryProperties = in_struct->memoryProperties;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkPhysicalDeviceMemoryProperties2::initialize(const safe_VkPhysicalDeviceMemoryProperties2* src)
{
    sType = src->sType;
    memoryProperties = src->memoryProperties;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkSparseImageFormatProperties2::safe_VkSparseImageFormatProperties2(const VkSparseImageFormatProperties2* in_struct) :
    sType(in_struct->sType),
    properties(in_struct->properties)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkSparseImageFormatProperties2::safe_VkSparseImageFormatProperties2() :
    pNext(nullptr)
{}

safe_VkSparseImageFormatProperties2::safe_VkSparseImageFormatProperties2(const safe_VkSparseImageFormatProperties2& src)
{
    sType = src.sType;
    properties = src.properties;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkSparseImageFormatProperties2& safe_VkSparseImageFormatProperties2::operator=(const safe_VkSparseImageFormatProperties2& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    properties = src.properties;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkSparseImageFormatProperties2::~safe_VkSparseImageFormatProperties2()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkSparseImageFormatProperties2::initialize(const VkSparseImageFormatProperties2* in_struct)
{
    sType = in_struct->sType;
    properties = in_struct->properties;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkSparseImageFormatProperties2::initialize(const safe_VkSparseImageFormatProperties2* src)
{
    sType = src->sType;
    properties = src->properties;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkPhysicalDeviceSparseImageFormatInfo2::safe_VkPhysicalDeviceSparseImageFormatInfo2(const VkPhysicalDeviceSparseImageFormatInfo2* in_struct) :
    sType(in_struct->sType),
    format(in_struct->format),
    type(in_struct->type),
    samples(in_struct->samples),
    usage(in_struct->usage),
    tiling(in_struct->tiling)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkPhysicalDeviceSparseImageFormatInfo2::safe_VkPhysicalDeviceSparseImageFormatInfo2() :
    pNext(nullptr)
{}

safe_VkPhysicalDeviceSparseImageFormatInfo2::safe_VkPhysicalDeviceSparseImageFormatInfo2(const safe_VkPhysicalDeviceSparseImageFormatInfo2& src)
{
    sType = src.sType;
    format = src.format;
    type = src.type;
    samples = src.samples;
    usage = src.usage;
    tiling = src.tiling;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkPhysicalDeviceSparseImageFormatInfo2& safe_VkPhysicalDeviceSparseImageFormatInfo2::operator=(const safe_VkPhysicalDeviceSparseImageFormatInfo2& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    format = src.format;
    type = src.type;
    samples = src.samples;
    usage = src.usage;
    tiling = src.tiling;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkPhysicalDeviceSparseImageFormatInfo2::~safe_VkPhysicalDeviceSparseImageFormatInfo2()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPhysicalDeviceSparseImageFormatInfo2::initialize(const VkPhysicalDeviceSparseImageFormatInfo2* in_struct)
{
    sType = in_struct->sType;
    format = in_struct->format;
    type = in_struct->type;
    samples = in_struct->samples;
    usage = in_struct->usage;
    tiling = in_struct->tiling;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkPhysicalDeviceSparseImageFormatInfo2::initialize(const safe_VkPhysicalDeviceSparseImageFormatInfo2* src)
{
    sType = src->sType;
    format = src->format;
    type = src->type;
    samples = src->samples;
    usage = src->usage;
    tiling = src->tiling;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkPhysicalDevicePointClippingProperties::safe_VkPhysicalDevicePointClippingProperties(const VkPhysicalDevicePointClippingProperties* in_struct) :
    sType(in_struct->sType),
    pointClippingBehavior(in_struct->pointClippingBehavior)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkPhysicalDevicePointClippingProperties::safe_VkPhysicalDevicePointClippingProperties() :
    pNext(nullptr)
{}

safe_VkPhysicalDevicePointClippingProperties::safe_VkPhysicalDevicePointClippingProperties(const safe_VkPhysicalDevicePointClippingProperties& src)
{
    sType = src.sType;
    pointClippingBehavior = src.pointClippingBehavior;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkPhysicalDevicePointClippingProperties& safe_VkPhysicalDevicePointClippingProperties::operator=(const safe_VkPhysicalDevicePointClippingProperties& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    pointClippingBehavior = src.pointClippingBehavior;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkPhysicalDevicePointClippingProperties::~safe_VkPhysicalDevicePointClippingProperties()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPhysicalDevicePointClippingProperties::initialize(const VkPhysicalDevicePointClippingProperties* in_struct)
{
    sType = in_struct->sType;
    pointClippingBehavior = in_struct->pointClippingBehavior;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkPhysicalDevicePointClippingProperties::initialize(const safe_VkPhysicalDevicePointClippingProperties* src)
{
    sType = src->sType;
    pointClippingBehavior = src->pointClippingBehavior;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkRenderPassInputAttachmentAspectCreateInfo::safe_VkRenderPassInputAttachmentAspectCreateInfo(const VkRenderPassInputAttachmentAspectCreateInfo* in_struct) :
    sType(in_struct->sType),
    aspectReferenceCount(in_struct->aspectReferenceCount),
    pAspectReferences(nullptr)
{
    pNext = SafePnextCopy(in_struct->pNext);
    if (in_struct->pAspectReferences) {
        pAspectReferences = new VkInputAttachmentAspectReference[in_struct->aspectReferenceCount];
        memcpy ((void *)pAspectReferences, (void *)in_struct->pAspectReferences, sizeof(VkInputAttachmentAspectReference)*in_struct->aspectReferenceCount);
    }
}

safe_VkRenderPassInputAttachmentAspectCreateInfo::safe_VkRenderPassInputAttachmentAspectCreateInfo() :
    pNext(nullptr),
    pAspectReferences(nullptr)
{}

safe_VkRenderPassInputAttachmentAspectCreateInfo::safe_VkRenderPassInputAttachmentAspectCreateInfo(const safe_VkRenderPassInputAttachmentAspectCreateInfo& src)
{
    sType = src.sType;
    aspectReferenceCount = src.aspectReferenceCount;
    pAspectReferences = nullptr;
    pNext = SafePnextCopy(src.pNext);
    if (src.pAspectReferences) {
        pAspectReferences = new VkInputAttachmentAspectReference[src.aspectReferenceCount];
        memcpy ((void *)pAspectReferences, (void *)src.pAspectReferences, sizeof(VkInputAttachmentAspectReference)*src.aspectReferenceCount);
    }
}

safe_VkRenderPassInputAttachmentAspectCreateInfo& safe_VkRenderPassInputAttachmentAspectCreateInfo::operator=(const safe_VkRenderPassInputAttachmentAspectCreateInfo& src)
{
    if (&src == this) return *this;

    if (pAspectReferences)
        delete[] pAspectReferences;
    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    aspectReferenceCount = src.aspectReferenceCount;
    pAspectReferences = nullptr;
    pNext = SafePnextCopy(src.pNext);
    if (src.pAspectReferences) {
        pAspectReferences = new VkInputAttachmentAspectReference[src.aspectReferenceCount];
        memcpy ((void *)pAspectReferences, (void *)src.pAspectReferences, sizeof(VkInputAttachmentAspectReference)*src.aspectReferenceCount);
    }

    return *this;
}

safe_VkRenderPassInputAttachmentAspectCreateInfo::~safe_VkRenderPassInputAttachmentAspectCreateInfo()
{
    if (pAspectReferences)
        delete[] pAspectReferences;
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkRenderPassInputAttachmentAspectCreateInfo::initialize(const VkRenderPassInputAttachmentAspectCreateInfo* in_struct)
{
    sType = in_struct->sType;
    aspectReferenceCount = in_struct->aspectReferenceCount;
    pAspectReferences = nullptr;
    pNext = SafePnextCopy(in_struct->pNext);
    if (in_struct->pAspectReferences) {
        pAspectReferences = new VkInputAttachmentAspectReference[in_struct->aspectReferenceCount];
        memcpy ((void *)pAspectReferences, (void *)in_struct->pAspectReferences, sizeof(VkInputAttachmentAspectReference)*in_struct->aspectReferenceCount);
    }
}

void safe_VkRenderPassInputAttachmentAspectCreateInfo::initialize(const safe_VkRenderPassInputAttachmentAspectCreateInfo* src)
{
    sType = src->sType;
    aspectReferenceCount = src->aspectReferenceCount;
    pAspectReferences = nullptr;
    pNext = SafePnextCopy(src->pNext);
    if (src->pAspectReferences) {
        pAspectReferences = new VkInputAttachmentAspectReference[src->aspectReferenceCount];
        memcpy ((void *)pAspectReferences, (void *)src->pAspectReferences, sizeof(VkInputAttachmentAspectReference)*src->aspectReferenceCount);
    }
}

safe_VkImageViewUsageCreateInfo::safe_VkImageViewUsageCreateInfo(const VkImageViewUsageCreateInfo* in_struct) :
    sType(in_struct->sType),
    usage(in_struct->usage)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkImageViewUsageCreateInfo::safe_VkImageViewUsageCreateInfo() :
    pNext(nullptr)
{}

safe_VkImageViewUsageCreateInfo::safe_VkImageViewUsageCreateInfo(const safe_VkImageViewUsageCreateInfo& src)
{
    sType = src.sType;
    usage = src.usage;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkImageViewUsageCreateInfo& safe_VkImageViewUsageCreateInfo::operator=(const safe_VkImageViewUsageCreateInfo& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    usage = src.usage;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkImageViewUsageCreateInfo::~safe_VkImageViewUsageCreateInfo()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkImageViewUsageCreateInfo::initialize(const VkImageViewUsageCreateInfo* in_struct)
{
    sType = in_struct->sType;
    usage = in_struct->usage;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkImageViewUsageCreateInfo::initialize(const safe_VkImageViewUsageCreateInfo* src)
{
    sType = src->sType;
    usage = src->usage;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkPipelineTessellationDomainOriginStateCreateInfo::safe_VkPipelineTessellationDomainOriginStateCreateInfo(const VkPipelineTessellationDomainOriginStateCreateInfo* in_struct) :
    sType(in_struct->sType),
    domainOrigin(in_struct->domainOrigin)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkPipelineTessellationDomainOriginStateCreateInfo::safe_VkPipelineTessellationDomainOriginStateCreateInfo() :
    pNext(nullptr)
{}

safe_VkPipelineTessellationDomainOriginStateCreateInfo::safe_VkPipelineTessellationDomainOriginStateCreateInfo(const safe_VkPipelineTessellationDomainOriginStateCreateInfo& src)
{
    sType = src.sType;
    domainOrigin = src.domainOrigin;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkPipelineTessellationDomainOriginStateCreateInfo& safe_VkPipelineTessellationDomainOriginStateCreateInfo::operator=(const safe_VkPipelineTessellationDomainOriginStateCreateInfo& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    domainOrigin = src.domainOrigin;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkPipelineTessellationDomainOriginStateCreateInfo::~safe_VkPipelineTessellationDomainOriginStateCreateInfo()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPipelineTessellationDomainOriginStateCreateInfo::initialize(const VkPipelineTessellationDomainOriginStateCreateInfo* in_struct)
{
    sType = in_struct->sType;
    domainOrigin = in_struct->domainOrigin;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkPipelineTessellationDomainOriginStateCreateInfo::initialize(const safe_VkPipelineTessellationDomainOriginStateCreateInfo* src)
{
    sType = src->sType;
    domainOrigin = src->domainOrigin;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkRenderPassMultiviewCreateInfo::safe_VkRenderPassMultiviewCreateInfo(const VkRenderPassMultiviewCreateInfo* in_struct) :
    sType(in_struct->sType),
    subpassCount(in_struct->subpassCount),
    pViewMasks(nullptr),
    dependencyCount(in_struct->dependencyCount),
    pViewOffsets(nullptr),
    correlationMaskCount(in_struct->correlationMaskCount),
    pCorrelationMasks(nullptr)
{
    pNext = SafePnextCopy(in_struct->pNext);
    if (in_struct->pViewMasks) {
        pViewMasks = new uint32_t[in_struct->subpassCount];
        memcpy ((void *)pViewMasks, (void *)in_struct->pViewMasks, sizeof(uint32_t)*in_struct->subpassCount);
    }
    if (in_struct->pViewOffsets) {
        pViewOffsets = new int32_t[in_struct->dependencyCount];
        memcpy ((void *)pViewOffsets, (void *)in_struct->pViewOffsets, sizeof(int32_t)*in_struct->dependencyCount);
    }
    if (in_struct->pCorrelationMasks) {
        pCorrelationMasks = new uint32_t[in_struct->correlationMaskCount];
        memcpy ((void *)pCorrelationMasks, (void *)in_struct->pCorrelationMasks, sizeof(uint32_t)*in_struct->correlationMaskCount);
    }
}

safe_VkRenderPassMultiviewCreateInfo::safe_VkRenderPassMultiviewCreateInfo() :
    pNext(nullptr),
    pViewMasks(nullptr),
    pViewOffsets(nullptr),
    pCorrelationMasks(nullptr)
{}

safe_VkRenderPassMultiviewCreateInfo::safe_VkRenderPassMultiviewCreateInfo(const safe_VkRenderPassMultiviewCreateInfo& src)
{
    sType = src.sType;
    subpassCount = src.subpassCount;
    pViewMasks = nullptr;
    dependencyCount = src.dependencyCount;
    pViewOffsets = nullptr;
    correlationMaskCount = src.correlationMaskCount;
    pCorrelationMasks = nullptr;
    pNext = SafePnextCopy(src.pNext);
    if (src.pViewMasks) {
        pViewMasks = new uint32_t[src.subpassCount];
        memcpy ((void *)pViewMasks, (void *)src.pViewMasks, sizeof(uint32_t)*src.subpassCount);
    }
    if (src.pViewOffsets) {
        pViewOffsets = new int32_t[src.dependencyCount];
        memcpy ((void *)pViewOffsets, (void *)src.pViewOffsets, sizeof(int32_t)*src.dependencyCount);
    }
    if (src.pCorrelationMasks) {
        pCorrelationMasks = new uint32_t[src.correlationMaskCount];
        memcpy ((void *)pCorrelationMasks, (void *)src.pCorrelationMasks, sizeof(uint32_t)*src.correlationMaskCount);
    }
}

safe_VkRenderPassMultiviewCreateInfo& safe_VkRenderPassMultiviewCreateInfo::operator=(const safe_VkRenderPassMultiviewCreateInfo& src)
{
    if (&src == this) return *this;

    if (pViewMasks)
        delete[] pViewMasks;
    if (pViewOffsets)
        delete[] pViewOffsets;
    if (pCorrelationMasks)
        delete[] pCorrelationMasks;
    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    subpassCount = src.subpassCount;
    pViewMasks = nullptr;
    dependencyCount = src.dependencyCount;
    pViewOffsets = nullptr;
    correlationMaskCount = src.correlationMaskCount;
    pCorrelationMasks = nullptr;
    pNext = SafePnextCopy(src.pNext);
    if (src.pViewMasks) {
        pViewMasks = new uint32_t[src.subpassCount];
        memcpy ((void *)pViewMasks, (void *)src.pViewMasks, sizeof(uint32_t)*src.subpassCount);
    }
    if (src.pViewOffsets) {
        pViewOffsets = new int32_t[src.dependencyCount];
        memcpy ((void *)pViewOffsets, (void *)src.pViewOffsets, sizeof(int32_t)*src.dependencyCount);
    }
    if (src.pCorrelationMasks) {
        pCorrelationMasks = new uint32_t[src.correlationMaskCount];
        memcpy ((void *)pCorrelationMasks, (void *)src.pCorrelationMasks, sizeof(uint32_t)*src.correlationMaskCount);
    }

    return *this;
}

safe_VkRenderPassMultiviewCreateInfo::~safe_VkRenderPassMultiviewCreateInfo()
{
    if (pViewMasks)
        delete[] pViewMasks;
    if (pViewOffsets)
        delete[] pViewOffsets;
    if (pCorrelationMasks)
        delete[] pCorrelationMasks;
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkRenderPassMultiviewCreateInfo::initialize(const VkRenderPassMultiviewCreateInfo* in_struct)
{
    sType = in_struct->sType;
    subpassCount = in_struct->subpassCount;
    pViewMasks = nullptr;
    dependencyCount = in_struct->dependencyCount;
    pViewOffsets = nullptr;
    correlationMaskCount = in_struct->correlationMaskCount;
    pCorrelationMasks = nullptr;
    pNext = SafePnextCopy(in_struct->pNext);
    if (in_struct->pViewMasks) {
        pViewMasks = new uint32_t[in_struct->subpassCount];
        memcpy ((void *)pViewMasks, (void *)in_struct->pViewMasks, sizeof(uint32_t)*in_struct->subpassCount);
    }
    if (in_struct->pViewOffsets) {
        pViewOffsets = new int32_t[in_struct->dependencyCount];
        memcpy ((void *)pViewOffsets, (void *)in_struct->pViewOffsets, sizeof(int32_t)*in_struct->dependencyCount);
    }
    if (in_struct->pCorrelationMasks) {
        pCorrelationMasks = new uint32_t[in_struct->correlationMaskCount];
        memcpy ((void *)pCorrelationMasks, (void *)in_struct->pCorrelationMasks, sizeof(uint32_t)*in_struct->correlationMaskCount);
    }
}

void safe_VkRenderPassMultiviewCreateInfo::initialize(const safe_VkRenderPassMultiviewCreateInfo* src)
{
    sType = src->sType;
    subpassCount = src->subpassCount;
    pViewMasks = nullptr;
    dependencyCount = src->dependencyCount;
    pViewOffsets = nullptr;
    correlationMaskCount = src->correlationMaskCount;
    pCorrelationMasks = nullptr;
    pNext = SafePnextCopy(src->pNext);
    if (src->pViewMasks) {
        pViewMasks = new uint32_t[src->subpassCount];
        memcpy ((void *)pViewMasks, (void *)src->pViewMasks, sizeof(uint32_t)*src->subpassCount);
    }
    if (src->pViewOffsets) {
        pViewOffsets = new int32_t[src->dependencyCount];
        memcpy ((void *)pViewOffsets, (void *)src->pViewOffsets, sizeof(int32_t)*src->dependencyCount);
    }
    if (src->pCorrelationMasks) {
        pCorrelationMasks = new uint32_t[src->correlationMaskCount];
        memcpy ((void *)pCorrelationMasks, (void *)src->pCorrelationMasks, sizeof(uint32_t)*src->correlationMaskCount);
    }
}

safe_VkPhysicalDeviceMultiviewFeatures::safe_VkPhysicalDeviceMultiviewFeatures(const VkPhysicalDeviceMultiviewFeatures* in_struct) :
    sType(in_struct->sType),
    multiview(in_struct->multiview),
    multiviewGeometryShader(in_struct->multiviewGeometryShader),
    multiviewTessellationShader(in_struct->multiviewTessellationShader)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkPhysicalDeviceMultiviewFeatures::safe_VkPhysicalDeviceMultiviewFeatures() :
    pNext(nullptr)
{}

safe_VkPhysicalDeviceMultiviewFeatures::safe_VkPhysicalDeviceMultiviewFeatures(const safe_VkPhysicalDeviceMultiviewFeatures& src)
{
    sType = src.sType;
    multiview = src.multiview;
    multiviewGeometryShader = src.multiviewGeometryShader;
    multiviewTessellationShader = src.multiviewTessellationShader;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkPhysicalDeviceMultiviewFeatures& safe_VkPhysicalDeviceMultiviewFeatures::operator=(const safe_VkPhysicalDeviceMultiviewFeatures& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    multiview = src.multiview;
    multiviewGeometryShader = src.multiviewGeometryShader;
    multiviewTessellationShader = src.multiviewTessellationShader;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkPhysicalDeviceMultiviewFeatures::~safe_VkPhysicalDeviceMultiviewFeatures()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPhysicalDeviceMultiviewFeatures::initialize(const VkPhysicalDeviceMultiviewFeatures* in_struct)
{
    sType = in_struct->sType;
    multiview = in_struct->multiview;
    multiviewGeometryShader = in_struct->multiviewGeometryShader;
    multiviewTessellationShader = in_struct->multiviewTessellationShader;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkPhysicalDeviceMultiviewFeatures::initialize(const safe_VkPhysicalDeviceMultiviewFeatures* src)
{
    sType = src->sType;
    multiview = src->multiview;
    multiviewGeometryShader = src->multiviewGeometryShader;
    multiviewTessellationShader = src->multiviewTessellationShader;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkPhysicalDeviceMultiviewProperties::safe_VkPhysicalDeviceMultiviewProperties(const VkPhysicalDeviceMultiviewProperties* in_struct) :
    sType(in_struct->sType),
    maxMultiviewViewCount(in_struct->maxMultiviewViewCount),
    maxMultiviewInstanceIndex(in_struct->maxMultiviewInstanceIndex)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkPhysicalDeviceMultiviewProperties::safe_VkPhysicalDeviceMultiviewProperties() :
    pNext(nullptr)
{}

safe_VkPhysicalDeviceMultiviewProperties::safe_VkPhysicalDeviceMultiviewProperties(const safe_VkPhysicalDeviceMultiviewProperties& src)
{
    sType = src.sType;
    maxMultiviewViewCount = src.maxMultiviewViewCount;
    maxMultiviewInstanceIndex = src.maxMultiviewInstanceIndex;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkPhysicalDeviceMultiviewProperties& safe_VkPhysicalDeviceMultiviewProperties::operator=(const safe_VkPhysicalDeviceMultiviewProperties& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    maxMultiviewViewCount = src.maxMultiviewViewCount;
    maxMultiviewInstanceIndex = src.maxMultiviewInstanceIndex;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkPhysicalDeviceMultiviewProperties::~safe_VkPhysicalDeviceMultiviewProperties()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPhysicalDeviceMultiviewProperties::initialize(const VkPhysicalDeviceMultiviewProperties* in_struct)
{
    sType = in_struct->sType;
    maxMultiviewViewCount = in_struct->maxMultiviewViewCount;
    maxMultiviewInstanceIndex = in_struct->maxMultiviewInstanceIndex;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkPhysicalDeviceMultiviewProperties::initialize(const safe_VkPhysicalDeviceMultiviewProperties* src)
{
    sType = src->sType;
    maxMultiviewViewCount = src->maxMultiviewViewCount;
    maxMultiviewInstanceIndex = src->maxMultiviewInstanceIndex;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkPhysicalDeviceVariablePointersFeatures::safe_VkPhysicalDeviceVariablePointersFeatures(const VkPhysicalDeviceVariablePointersFeatures* in_struct) :
    sType(in_struct->sType),
    variablePointersStorageBuffer(in_struct->variablePointersStorageBuffer),
    variablePointers(in_struct->variablePointers)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkPhysicalDeviceVariablePointersFeatures::safe_VkPhysicalDeviceVariablePointersFeatures() :
    pNext(nullptr)
{}

safe_VkPhysicalDeviceVariablePointersFeatures::safe_VkPhysicalDeviceVariablePointersFeatures(const safe_VkPhysicalDeviceVariablePointersFeatures& src)
{
    sType = src.sType;
    variablePointersStorageBuffer = src.variablePointersStorageBuffer;
    variablePointers = src.variablePointers;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkPhysicalDeviceVariablePointersFeatures& safe_VkPhysicalDeviceVariablePointersFeatures::operator=(const safe_VkPhysicalDeviceVariablePointersFeatures& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    variablePointersStorageBuffer = src.variablePointersStorageBuffer;
    variablePointers = src.variablePointers;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkPhysicalDeviceVariablePointersFeatures::~safe_VkPhysicalDeviceVariablePointersFeatures()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPhysicalDeviceVariablePointersFeatures::initialize(const VkPhysicalDeviceVariablePointersFeatures* in_struct)
{
    sType = in_struct->sType;
    variablePointersStorageBuffer = in_struct->variablePointersStorageBuffer;
    variablePointers = in_struct->variablePointers;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkPhysicalDeviceVariablePointersFeatures::initialize(const safe_VkPhysicalDeviceVariablePointersFeatures* src)
{
    sType = src->sType;
    variablePointersStorageBuffer = src->variablePointersStorageBuffer;
    variablePointers = src->variablePointers;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkPhysicalDeviceProtectedMemoryFeatures::safe_VkPhysicalDeviceProtectedMemoryFeatures(const VkPhysicalDeviceProtectedMemoryFeatures* in_struct) :
    sType(in_struct->sType),
    protectedMemory(in_struct->protectedMemory)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkPhysicalDeviceProtectedMemoryFeatures::safe_VkPhysicalDeviceProtectedMemoryFeatures() :
    pNext(nullptr)
{}

safe_VkPhysicalDeviceProtectedMemoryFeatures::safe_VkPhysicalDeviceProtectedMemoryFeatures(const safe_VkPhysicalDeviceProtectedMemoryFeatures& src)
{
    sType = src.sType;
    protectedMemory = src.protectedMemory;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkPhysicalDeviceProtectedMemoryFeatures& safe_VkPhysicalDeviceProtectedMemoryFeatures::operator=(const safe_VkPhysicalDeviceProtectedMemoryFeatures& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    protectedMemory = src.protectedMemory;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkPhysicalDeviceProtectedMemoryFeatures::~safe_VkPhysicalDeviceProtectedMemoryFeatures()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPhysicalDeviceProtectedMemoryFeatures::initialize(const VkPhysicalDeviceProtectedMemoryFeatures* in_struct)
{
    sType = in_struct->sType;
    protectedMemory = in_struct->protectedMemory;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkPhysicalDeviceProtectedMemoryFeatures::initialize(const safe_VkPhysicalDeviceProtectedMemoryFeatures* src)
{
    sType = src->sType;
    protectedMemory = src->protectedMemory;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkPhysicalDeviceProtectedMemoryProperties::safe_VkPhysicalDeviceProtectedMemoryProperties(const VkPhysicalDeviceProtectedMemoryProperties* in_struct) :
    sType(in_struct->sType),
    protectedNoFault(in_struct->protectedNoFault)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkPhysicalDeviceProtectedMemoryProperties::safe_VkPhysicalDeviceProtectedMemoryProperties() :
    pNext(nullptr)
{}

safe_VkPhysicalDeviceProtectedMemoryProperties::safe_VkPhysicalDeviceProtectedMemoryProperties(const safe_VkPhysicalDeviceProtectedMemoryProperties& src)
{
    sType = src.sType;
    protectedNoFault = src.protectedNoFault;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkPhysicalDeviceProtectedMemoryProperties& safe_VkPhysicalDeviceProtectedMemoryProperties::operator=(const safe_VkPhysicalDeviceProtectedMemoryProperties& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    protectedNoFault = src.protectedNoFault;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkPhysicalDeviceProtectedMemoryProperties::~safe_VkPhysicalDeviceProtectedMemoryProperties()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPhysicalDeviceProtectedMemoryProperties::initialize(const VkPhysicalDeviceProtectedMemoryProperties* in_struct)
{
    sType = in_struct->sType;
    protectedNoFault = in_struct->protectedNoFault;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkPhysicalDeviceProtectedMemoryProperties::initialize(const safe_VkPhysicalDeviceProtectedMemoryProperties* src)
{
    sType = src->sType;
    protectedNoFault = src->protectedNoFault;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkDeviceQueueInfo2::safe_VkDeviceQueueInfo2(const VkDeviceQueueInfo2* in_struct) :
    sType(in_struct->sType),
    flags(in_struct->flags),
    queueFamilyIndex(in_struct->queueFamilyIndex),
    queueIndex(in_struct->queueIndex)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkDeviceQueueInfo2::safe_VkDeviceQueueInfo2() :
    pNext(nullptr)
{}

safe_VkDeviceQueueInfo2::safe_VkDeviceQueueInfo2(const safe_VkDeviceQueueInfo2& src)
{
    sType = src.sType;
    flags = src.flags;
    queueFamilyIndex = src.queueFamilyIndex;
    queueIndex = src.queueIndex;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkDeviceQueueInfo2& safe_VkDeviceQueueInfo2::operator=(const safe_VkDeviceQueueInfo2& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    flags = src.flags;
    queueFamilyIndex = src.queueFamilyIndex;
    queueIndex = src.queueIndex;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkDeviceQueueInfo2::~safe_VkDeviceQueueInfo2()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkDeviceQueueInfo2::initialize(const VkDeviceQueueInfo2* in_struct)
{
    sType = in_struct->sType;
    flags = in_struct->flags;
    queueFamilyIndex = in_struct->queueFamilyIndex;
    queueIndex = in_struct->queueIndex;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkDeviceQueueInfo2::initialize(const safe_VkDeviceQueueInfo2* src)
{
    sType = src->sType;
    flags = src->flags;
    queueFamilyIndex = src->queueFamilyIndex;
    queueIndex = src->queueIndex;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkProtectedSubmitInfo::safe_VkProtectedSubmitInfo(const VkProtectedSubmitInfo* in_struct) :
    sType(in_struct->sType),
    protectedSubmit(in_struct->protectedSubmit)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkProtectedSubmitInfo::safe_VkProtectedSubmitInfo() :
    pNext(nullptr)
{}

safe_VkProtectedSubmitInfo::safe_VkProtectedSubmitInfo(const safe_VkProtectedSubmitInfo& src)
{
    sType = src.sType;
    protectedSubmit = src.protectedSubmit;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkProtectedSubmitInfo& safe_VkProtectedSubmitInfo::operator=(const safe_VkProtectedSubmitInfo& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    protectedSubmit = src.protectedSubmit;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkProtectedSubmitInfo::~safe_VkProtectedSubmitInfo()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkProtectedSubmitInfo::initialize(const VkProtectedSubmitInfo* in_struct)
{
    sType = in_struct->sType;
    protectedSubmit = in_struct->protectedSubmit;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkProtectedSubmitInfo::initialize(const safe_VkProtectedSubmitInfo* src)
{
    sType = src->sType;
    protectedSubmit = src->protectedSubmit;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkSamplerYcbcrConversionCreateInfo::safe_VkSamplerYcbcrConversionCreateInfo(const VkSamplerYcbcrConversionCreateInfo* in_struct) :
    sType(in_struct->sType),
    format(in_struct->format),
    ycbcrModel(in_struct->ycbcrModel),
    ycbcrRange(in_struct->ycbcrRange),
    components(in_struct->components),
    xChromaOffset(in_struct->xChromaOffset),
    yChromaOffset(in_struct->yChromaOffset),
    chromaFilter(in_struct->chromaFilter),
    forceExplicitReconstruction(in_struct->forceExplicitReconstruction)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkSamplerYcbcrConversionCreateInfo::safe_VkSamplerYcbcrConversionCreateInfo() :
    pNext(nullptr)
{}

safe_VkSamplerYcbcrConversionCreateInfo::safe_VkSamplerYcbcrConversionCreateInfo(const safe_VkSamplerYcbcrConversionCreateInfo& src)
{
    sType = src.sType;
    format = src.format;
    ycbcrModel = src.ycbcrModel;
    ycbcrRange = src.ycbcrRange;
    components = src.components;
    xChromaOffset = src.xChromaOffset;
    yChromaOffset = src.yChromaOffset;
    chromaFilter = src.chromaFilter;
    forceExplicitReconstruction = src.forceExplicitReconstruction;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkSamplerYcbcrConversionCreateInfo& safe_VkSamplerYcbcrConversionCreateInfo::operator=(const safe_VkSamplerYcbcrConversionCreateInfo& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    format = src.format;
    ycbcrModel = src.ycbcrModel;
    ycbcrRange = src.ycbcrRange;
    components = src.components;
    xChromaOffset = src.xChromaOffset;
    yChromaOffset = src.yChromaOffset;
    chromaFilter = src.chromaFilter;
    forceExplicitReconstruction = src.forceExplicitReconstruction;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkSamplerYcbcrConversionCreateInfo::~safe_VkSamplerYcbcrConversionCreateInfo()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkSamplerYcbcrConversionCreateInfo::initialize(const VkSamplerYcbcrConversionCreateInfo* in_struct)
{
    sType = in_struct->sType;
    format = in_struct->format;
    ycbcrModel = in_struct->ycbcrModel;
    ycbcrRange = in_struct->ycbcrRange;
    components = in_struct->components;
    xChromaOffset = in_struct->xChromaOffset;
    yChromaOffset = in_struct->yChromaOffset;
    chromaFilter = in_struct->chromaFilter;
    forceExplicitReconstruction = in_struct->forceExplicitReconstruction;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkSamplerYcbcrConversionCreateInfo::initialize(const safe_VkSamplerYcbcrConversionCreateInfo* src)
{
    sType = src->sType;
    format = src->format;
    ycbcrModel = src->ycbcrModel;
    ycbcrRange = src->ycbcrRange;
    components = src->components;
    xChromaOffset = src->xChromaOffset;
    yChromaOffset = src->yChromaOffset;
    chromaFilter = src->chromaFilter;
    forceExplicitReconstruction = src->forceExplicitReconstruction;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkSamplerYcbcrConversionInfo::safe_VkSamplerYcbcrConversionInfo(const VkSamplerYcbcrConversionInfo* in_struct) :
    sType(in_struct->sType),
    conversion(in_struct->conversion)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkSamplerYcbcrConversionInfo::safe_VkSamplerYcbcrConversionInfo() :
    pNext(nullptr)
{}

safe_VkSamplerYcbcrConversionInfo::safe_VkSamplerYcbcrConversionInfo(const safe_VkSamplerYcbcrConversionInfo& src)
{
    sType = src.sType;
    conversion = src.conversion;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkSamplerYcbcrConversionInfo& safe_VkSamplerYcbcrConversionInfo::operator=(const safe_VkSamplerYcbcrConversionInfo& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    conversion = src.conversion;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkSamplerYcbcrConversionInfo::~safe_VkSamplerYcbcrConversionInfo()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkSamplerYcbcrConversionInfo::initialize(const VkSamplerYcbcrConversionInfo* in_struct)
{
    sType = in_struct->sType;
    conversion = in_struct->conversion;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkSamplerYcbcrConversionInfo::initialize(const safe_VkSamplerYcbcrConversionInfo* src)
{
    sType = src->sType;
    conversion = src->conversion;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkBindImagePlaneMemoryInfo::safe_VkBindImagePlaneMemoryInfo(const VkBindImagePlaneMemoryInfo* in_struct) :
    sType(in_struct->sType),
    planeAspect(in_struct->planeAspect)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkBindImagePlaneMemoryInfo::safe_VkBindImagePlaneMemoryInfo() :
    pNext(nullptr)
{}

safe_VkBindImagePlaneMemoryInfo::safe_VkBindImagePlaneMemoryInfo(const safe_VkBindImagePlaneMemoryInfo& src)
{
    sType = src.sType;
    planeAspect = src.planeAspect;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkBindImagePlaneMemoryInfo& safe_VkBindImagePlaneMemoryInfo::operator=(const safe_VkBindImagePlaneMemoryInfo& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    planeAspect = src.planeAspect;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkBindImagePlaneMemoryInfo::~safe_VkBindImagePlaneMemoryInfo()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkBindImagePlaneMemoryInfo::initialize(const VkBindImagePlaneMemoryInfo* in_struct)
{
    sType = in_struct->sType;
    planeAspect = in_struct->planeAspect;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkBindImagePlaneMemoryInfo::initialize(const safe_VkBindImagePlaneMemoryInfo* src)
{
    sType = src->sType;
    planeAspect = src->planeAspect;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkImagePlaneMemoryRequirementsInfo::safe_VkImagePlaneMemoryRequirementsInfo(const VkImagePlaneMemoryRequirementsInfo* in_struct) :
    sType(in_struct->sType),
    planeAspect(in_struct->planeAspect)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkImagePlaneMemoryRequirementsInfo::safe_VkImagePlaneMemoryRequirementsInfo() :
    pNext(nullptr)
{}

safe_VkImagePlaneMemoryRequirementsInfo::safe_VkImagePlaneMemoryRequirementsInfo(const safe_VkImagePlaneMemoryRequirementsInfo& src)
{
    sType = src.sType;
    planeAspect = src.planeAspect;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkImagePlaneMemoryRequirementsInfo& safe_VkImagePlaneMemoryRequirementsInfo::operator=(const safe_VkImagePlaneMemoryRequirementsInfo& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    planeAspect = src.planeAspect;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkImagePlaneMemoryRequirementsInfo::~safe_VkImagePlaneMemoryRequirementsInfo()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkImagePlaneMemoryRequirementsInfo::initialize(const VkImagePlaneMemoryRequirementsInfo* in_struct)
{
    sType = in_struct->sType;
    planeAspect = in_struct->planeAspect;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkImagePlaneMemoryRequirementsInfo::initialize(const safe_VkImagePlaneMemoryRequirementsInfo* src)
{
    sType = src->sType;
    planeAspect = src->planeAspect;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkPhysicalDeviceSamplerYcbcrConversionFeatures::safe_VkPhysicalDeviceSamplerYcbcrConversionFeatures(const VkPhysicalDeviceSamplerYcbcrConversionFeatures* in_struct) :
    sType(in_struct->sType),
    samplerYcbcrConversion(in_struct->samplerYcbcrConversion)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkPhysicalDeviceSamplerYcbcrConversionFeatures::safe_VkPhysicalDeviceSamplerYcbcrConversionFeatures() :
    pNext(nullptr)
{}

safe_VkPhysicalDeviceSamplerYcbcrConversionFeatures::safe_VkPhysicalDeviceSamplerYcbcrConversionFeatures(const safe_VkPhysicalDeviceSamplerYcbcrConversionFeatures& src)
{
    sType = src.sType;
    samplerYcbcrConversion = src.samplerYcbcrConversion;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkPhysicalDeviceSamplerYcbcrConversionFeatures& safe_VkPhysicalDeviceSamplerYcbcrConversionFeatures::operator=(const safe_VkPhysicalDeviceSamplerYcbcrConversionFeatures& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    samplerYcbcrConversion = src.samplerYcbcrConversion;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkPhysicalDeviceSamplerYcbcrConversionFeatures::~safe_VkPhysicalDeviceSamplerYcbcrConversionFeatures()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPhysicalDeviceSamplerYcbcrConversionFeatures::initialize(const VkPhysicalDeviceSamplerYcbcrConversionFeatures* in_struct)
{
    sType = in_struct->sType;
    samplerYcbcrConversion = in_struct->samplerYcbcrConversion;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkPhysicalDeviceSamplerYcbcrConversionFeatures::initialize(const safe_VkPhysicalDeviceSamplerYcbcrConversionFeatures* src)
{
    sType = src->sType;
    samplerYcbcrConversion = src->samplerYcbcrConversion;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkSamplerYcbcrConversionImageFormatProperties::safe_VkSamplerYcbcrConversionImageFormatProperties(const VkSamplerYcbcrConversionImageFormatProperties* in_struct) :
    sType(in_struct->sType),
    combinedImageSamplerDescriptorCount(in_struct->combinedImageSamplerDescriptorCount)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkSamplerYcbcrConversionImageFormatProperties::safe_VkSamplerYcbcrConversionImageFormatProperties() :
    pNext(nullptr)
{}

safe_VkSamplerYcbcrConversionImageFormatProperties::safe_VkSamplerYcbcrConversionImageFormatProperties(const safe_VkSamplerYcbcrConversionImageFormatProperties& src)
{
    sType = src.sType;
    combinedImageSamplerDescriptorCount = src.combinedImageSamplerDescriptorCount;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkSamplerYcbcrConversionImageFormatProperties& safe_VkSamplerYcbcrConversionImageFormatProperties::operator=(const safe_VkSamplerYcbcrConversionImageFormatProperties& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    combinedImageSamplerDescriptorCount = src.combinedImageSamplerDescriptorCount;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkSamplerYcbcrConversionImageFormatProperties::~safe_VkSamplerYcbcrConversionImageFormatProperties()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkSamplerYcbcrConversionImageFormatProperties::initialize(const VkSamplerYcbcrConversionImageFormatProperties* in_struct)
{
    sType = in_struct->sType;
    combinedImageSamplerDescriptorCount = in_struct->combinedImageSamplerDescriptorCount;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkSamplerYcbcrConversionImageFormatProperties::initialize(const safe_VkSamplerYcbcrConversionImageFormatProperties* src)
{
    sType = src->sType;
    combinedImageSamplerDescriptorCount = src->combinedImageSamplerDescriptorCount;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkDescriptorUpdateTemplateCreateInfo::safe_VkDescriptorUpdateTemplateCreateInfo(const VkDescriptorUpdateTemplateCreateInfo* in_struct) :
    sType(in_struct->sType),
    flags(in_struct->flags),
    descriptorUpdateEntryCount(in_struct->descriptorUpdateEntryCount),
    pDescriptorUpdateEntries(nullptr),
    templateType(in_struct->templateType),
    descriptorSetLayout(in_struct->descriptorSetLayout),
    pipelineBindPoint(in_struct->pipelineBindPoint),
    pipelineLayout(in_struct->pipelineLayout),
    set(in_struct->set)
{
    pNext = SafePnextCopy(in_struct->pNext);
    if (in_struct->pDescriptorUpdateEntries) {
        pDescriptorUpdateEntries = new VkDescriptorUpdateTemplateEntry[in_struct->descriptorUpdateEntryCount];
        memcpy ((void *)pDescriptorUpdateEntries, (void *)in_struct->pDescriptorUpdateEntries, sizeof(VkDescriptorUpdateTemplateEntry)*in_struct->descriptorUpdateEntryCount);
    }
}

safe_VkDescriptorUpdateTemplateCreateInfo::safe_VkDescriptorUpdateTemplateCreateInfo() :
    pNext(nullptr),
    pDescriptorUpdateEntries(nullptr)
{}

safe_VkDescriptorUpdateTemplateCreateInfo::safe_VkDescriptorUpdateTemplateCreateInfo(const safe_VkDescriptorUpdateTemplateCreateInfo& src)
{
    sType = src.sType;
    flags = src.flags;
    descriptorUpdateEntryCount = src.descriptorUpdateEntryCount;
    pDescriptorUpdateEntries = nullptr;
    templateType = src.templateType;
    descriptorSetLayout = src.descriptorSetLayout;
    pipelineBindPoint = src.pipelineBindPoint;
    pipelineLayout = src.pipelineLayout;
    set = src.set;
    pNext = SafePnextCopy(src.pNext);
    if (src.pDescriptorUpdateEntries) {
        pDescriptorUpdateEntries = new VkDescriptorUpdateTemplateEntry[src.descriptorUpdateEntryCount];
        memcpy ((void *)pDescriptorUpdateEntries, (void *)src.pDescriptorUpdateEntries, sizeof(VkDescriptorUpdateTemplateEntry)*src.descriptorUpdateEntryCount);
    }
}

safe_VkDescriptorUpdateTemplateCreateInfo& safe_VkDescriptorUpdateTemplateCreateInfo::operator=(const safe_VkDescriptorUpdateTemplateCreateInfo& src)
{
    if (&src == this) return *this;

    if (pDescriptorUpdateEntries)
        delete[] pDescriptorUpdateEntries;
    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    flags = src.flags;
    descriptorUpdateEntryCount = src.descriptorUpdateEntryCount;
    pDescriptorUpdateEntries = nullptr;
    templateType = src.templateType;
    descriptorSetLayout = src.descriptorSetLayout;
    pipelineBindPoint = src.pipelineBindPoint;
    pipelineLayout = src.pipelineLayout;
    set = src.set;
    pNext = SafePnextCopy(src.pNext);
    if (src.pDescriptorUpdateEntries) {
        pDescriptorUpdateEntries = new VkDescriptorUpdateTemplateEntry[src.descriptorUpdateEntryCount];
        memcpy ((void *)pDescriptorUpdateEntries, (void *)src.pDescriptorUpdateEntries, sizeof(VkDescriptorUpdateTemplateEntry)*src.descriptorUpdateEntryCount);
    }

    return *this;
}

safe_VkDescriptorUpdateTemplateCreateInfo::~safe_VkDescriptorUpdateTemplateCreateInfo()
{
    if (pDescriptorUpdateEntries)
        delete[] pDescriptorUpdateEntries;
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkDescriptorUpdateTemplateCreateInfo::initialize(const VkDescriptorUpdateTemplateCreateInfo* in_struct)
{
    sType = in_struct->sType;
    flags = in_struct->flags;
    descriptorUpdateEntryCount = in_struct->descriptorUpdateEntryCount;
    pDescriptorUpdateEntries = nullptr;
    templateType = in_struct->templateType;
    descriptorSetLayout = in_struct->descriptorSetLayout;
    pipelineBindPoint = in_struct->pipelineBindPoint;
    pipelineLayout = in_struct->pipelineLayout;
    set = in_struct->set;
    pNext = SafePnextCopy(in_struct->pNext);
    if (in_struct->pDescriptorUpdateEntries) {
        pDescriptorUpdateEntries = new VkDescriptorUpdateTemplateEntry[in_struct->descriptorUpdateEntryCount];
        memcpy ((void *)pDescriptorUpdateEntries, (void *)in_struct->pDescriptorUpdateEntries, sizeof(VkDescriptorUpdateTemplateEntry)*in_struct->descriptorUpdateEntryCount);
    }
}

void safe_VkDescriptorUpdateTemplateCreateInfo::initialize(const safe_VkDescriptorUpdateTemplateCreateInfo* src)
{
    sType = src->sType;
    flags = src->flags;
    descriptorUpdateEntryCount = src->descriptorUpdateEntryCount;
    pDescriptorUpdateEntries = nullptr;
    templateType = src->templateType;
    descriptorSetLayout = src->descriptorSetLayout;
    pipelineBindPoint = src->pipelineBindPoint;
    pipelineLayout = src->pipelineLayout;
    set = src->set;
    pNext = SafePnextCopy(src->pNext);
    if (src->pDescriptorUpdateEntries) {
        pDescriptorUpdateEntries = new VkDescriptorUpdateTemplateEntry[src->descriptorUpdateEntryCount];
        memcpy ((void *)pDescriptorUpdateEntries, (void *)src->pDescriptorUpdateEntries, sizeof(VkDescriptorUpdateTemplateEntry)*src->descriptorUpdateEntryCount);
    }
}

safe_VkPhysicalDeviceExternalImageFormatInfo::safe_VkPhysicalDeviceExternalImageFormatInfo(const VkPhysicalDeviceExternalImageFormatInfo* in_struct) :
    sType(in_struct->sType),
    handleType(in_struct->handleType)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkPhysicalDeviceExternalImageFormatInfo::safe_VkPhysicalDeviceExternalImageFormatInfo() :
    pNext(nullptr)
{}

safe_VkPhysicalDeviceExternalImageFormatInfo::safe_VkPhysicalDeviceExternalImageFormatInfo(const safe_VkPhysicalDeviceExternalImageFormatInfo& src)
{
    sType = src.sType;
    handleType = src.handleType;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkPhysicalDeviceExternalImageFormatInfo& safe_VkPhysicalDeviceExternalImageFormatInfo::operator=(const safe_VkPhysicalDeviceExternalImageFormatInfo& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    handleType = src.handleType;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkPhysicalDeviceExternalImageFormatInfo::~safe_VkPhysicalDeviceExternalImageFormatInfo()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPhysicalDeviceExternalImageFormatInfo::initialize(const VkPhysicalDeviceExternalImageFormatInfo* in_struct)
{
    sType = in_struct->sType;
    handleType = in_struct->handleType;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkPhysicalDeviceExternalImageFormatInfo::initialize(const safe_VkPhysicalDeviceExternalImageFormatInfo* src)
{
    sType = src->sType;
    handleType = src->handleType;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkExternalImageFormatProperties::safe_VkExternalImageFormatProperties(const VkExternalImageFormatProperties* in_struct) :
    sType(in_struct->sType),
    externalMemoryProperties(in_struct->externalMemoryProperties)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkExternalImageFormatProperties::safe_VkExternalImageFormatProperties() :
    pNext(nullptr)
{}

safe_VkExternalImageFormatProperties::safe_VkExternalImageFormatProperties(const safe_VkExternalImageFormatProperties& src)
{
    sType = src.sType;
    externalMemoryProperties = src.externalMemoryProperties;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkExternalImageFormatProperties& safe_VkExternalImageFormatProperties::operator=(const safe_VkExternalImageFormatProperties& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    externalMemoryProperties = src.externalMemoryProperties;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkExternalImageFormatProperties::~safe_VkExternalImageFormatProperties()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkExternalImageFormatProperties::initialize(const VkExternalImageFormatProperties* in_struct)
{
    sType = in_struct->sType;
    externalMemoryProperties = in_struct->externalMemoryProperties;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkExternalImageFormatProperties::initialize(const safe_VkExternalImageFormatProperties* src)
{
    sType = src->sType;
    externalMemoryProperties = src->externalMemoryProperties;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkPhysicalDeviceExternalBufferInfo::safe_VkPhysicalDeviceExternalBufferInfo(const VkPhysicalDeviceExternalBufferInfo* in_struct) :
    sType(in_struct->sType),
    flags(in_struct->flags),
    usage(in_struct->usage),
    handleType(in_struct->handleType)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkPhysicalDeviceExternalBufferInfo::safe_VkPhysicalDeviceExternalBufferInfo() :
    pNext(nullptr)
{}

safe_VkPhysicalDeviceExternalBufferInfo::safe_VkPhysicalDeviceExternalBufferInfo(const safe_VkPhysicalDeviceExternalBufferInfo& src)
{
    sType = src.sType;
    flags = src.flags;
    usage = src.usage;
    handleType = src.handleType;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkPhysicalDeviceExternalBufferInfo& safe_VkPhysicalDeviceExternalBufferInfo::operator=(const safe_VkPhysicalDeviceExternalBufferInfo& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    flags = src.flags;
    usage = src.usage;
    handleType = src.handleType;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkPhysicalDeviceExternalBufferInfo::~safe_VkPhysicalDeviceExternalBufferInfo()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPhysicalDeviceExternalBufferInfo::initialize(const VkPhysicalDeviceExternalBufferInfo* in_struct)
{
    sType = in_struct->sType;
    flags = in_struct->flags;
    usage = in_struct->usage;
    handleType = in_struct->handleType;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkPhysicalDeviceExternalBufferInfo::initialize(const safe_VkPhysicalDeviceExternalBufferInfo* src)
{
    sType = src->sType;
    flags = src->flags;
    usage = src->usage;
    handleType = src->handleType;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkExternalBufferProperties::safe_VkExternalBufferProperties(const VkExternalBufferProperties* in_struct) :
    sType(in_struct->sType),
    externalMemoryProperties(in_struct->externalMemoryProperties)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkExternalBufferProperties::safe_VkExternalBufferProperties() :
    pNext(nullptr)
{}

safe_VkExternalBufferProperties::safe_VkExternalBufferProperties(const safe_VkExternalBufferProperties& src)
{
    sType = src.sType;
    externalMemoryProperties = src.externalMemoryProperties;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkExternalBufferProperties& safe_VkExternalBufferProperties::operator=(const safe_VkExternalBufferProperties& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    externalMemoryProperties = src.externalMemoryProperties;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkExternalBufferProperties::~safe_VkExternalBufferProperties()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkExternalBufferProperties::initialize(const VkExternalBufferProperties* in_struct)
{
    sType = in_struct->sType;
    externalMemoryProperties = in_struct->externalMemoryProperties;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkExternalBufferProperties::initialize(const safe_VkExternalBufferProperties* src)
{
    sType = src->sType;
    externalMemoryProperties = src->externalMemoryProperties;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkPhysicalDeviceIDProperties::safe_VkPhysicalDeviceIDProperties(const VkPhysicalDeviceIDProperties* in_struct) :
    sType(in_struct->sType),
    deviceNodeMask(in_struct->deviceNodeMask),
    deviceLUIDValid(in_struct->deviceLUIDValid)
{
    pNext = SafePnextCopy(in_struct->pNext);
    for (uint32_t i = 0; i < VK_UUID_SIZE; ++i) {
        deviceUUID[i] = in_struct->deviceUUID[i];
    }
    for (uint32_t i = 0; i < VK_UUID_SIZE; ++i) {
        driverUUID[i] = in_struct->driverUUID[i];
    }
    for (uint32_t i = 0; i < VK_LUID_SIZE; ++i) {
        deviceLUID[i] = in_struct->deviceLUID[i];
    }
}

safe_VkPhysicalDeviceIDProperties::safe_VkPhysicalDeviceIDProperties() :
    pNext(nullptr)
{}

safe_VkPhysicalDeviceIDProperties::safe_VkPhysicalDeviceIDProperties(const safe_VkPhysicalDeviceIDProperties& src)
{
    sType = src.sType;
    deviceNodeMask = src.deviceNodeMask;
    deviceLUIDValid = src.deviceLUIDValid;
    pNext = SafePnextCopy(src.pNext);
    for (uint32_t i = 0; i < VK_UUID_SIZE; ++i) {
        deviceUUID[i] = src.deviceUUID[i];
    }
    for (uint32_t i = 0; i < VK_UUID_SIZE; ++i) {
        driverUUID[i] = src.driverUUID[i];
    }
    for (uint32_t i = 0; i < VK_LUID_SIZE; ++i) {
        deviceLUID[i] = src.deviceLUID[i];
    }
}

safe_VkPhysicalDeviceIDProperties& safe_VkPhysicalDeviceIDProperties::operator=(const safe_VkPhysicalDeviceIDProperties& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    deviceNodeMask = src.deviceNodeMask;
    deviceLUIDValid = src.deviceLUIDValid;
    pNext = SafePnextCopy(src.pNext);
    for (uint32_t i = 0; i < VK_UUID_SIZE; ++i) {
        deviceUUID[i] = src.deviceUUID[i];
    }
    for (uint32_t i = 0; i < VK_UUID_SIZE; ++i) {
        driverUUID[i] = src.driverUUID[i];
    }
    for (uint32_t i = 0; i < VK_LUID_SIZE; ++i) {
        deviceLUID[i] = src.deviceLUID[i];
    }

    return *this;
}

safe_VkPhysicalDeviceIDProperties::~safe_VkPhysicalDeviceIDProperties()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPhysicalDeviceIDProperties::initialize(const VkPhysicalDeviceIDProperties* in_struct)
{
    sType = in_struct->sType;
    deviceNodeMask = in_struct->deviceNodeMask;
    deviceLUIDValid = in_struct->deviceLUIDValid;
    pNext = SafePnextCopy(in_struct->pNext);
    for (uint32_t i = 0; i < VK_UUID_SIZE; ++i) {
        deviceUUID[i] = in_struct->deviceUUID[i];
    }
    for (uint32_t i = 0; i < VK_UUID_SIZE; ++i) {
        driverUUID[i] = in_struct->driverUUID[i];
    }
    for (uint32_t i = 0; i < VK_LUID_SIZE; ++i) {
        deviceLUID[i] = in_struct->deviceLUID[i];
    }
}

void safe_VkPhysicalDeviceIDProperties::initialize(const safe_VkPhysicalDeviceIDProperties* src)
{
    sType = src->sType;
    deviceNodeMask = src->deviceNodeMask;
    deviceLUIDValid = src->deviceLUIDValid;
    pNext = SafePnextCopy(src->pNext);
    for (uint32_t i = 0; i < VK_UUID_SIZE; ++i) {
        deviceUUID[i] = src->deviceUUID[i];
    }
    for (uint32_t i = 0; i < VK_UUID_SIZE; ++i) {
        driverUUID[i] = src->driverUUID[i];
    }
    for (uint32_t i = 0; i < VK_LUID_SIZE; ++i) {
        deviceLUID[i] = src->deviceLUID[i];
    }
}

safe_VkExternalMemoryImageCreateInfo::safe_VkExternalMemoryImageCreateInfo(const VkExternalMemoryImageCreateInfo* in_struct) :
    sType(in_struct->sType),
    handleTypes(in_struct->handleTypes)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkExternalMemoryImageCreateInfo::safe_VkExternalMemoryImageCreateInfo() :
    pNext(nullptr)
{}

safe_VkExternalMemoryImageCreateInfo::safe_VkExternalMemoryImageCreateInfo(const safe_VkExternalMemoryImageCreateInfo& src)
{
    sType = src.sType;
    handleTypes = src.handleTypes;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkExternalMemoryImageCreateInfo& safe_VkExternalMemoryImageCreateInfo::operator=(const safe_VkExternalMemoryImageCreateInfo& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    handleTypes = src.handleTypes;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkExternalMemoryImageCreateInfo::~safe_VkExternalMemoryImageCreateInfo()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkExternalMemoryImageCreateInfo::initialize(const VkExternalMemoryImageCreateInfo* in_struct)
{
    sType = in_struct->sType;
    handleTypes = in_struct->handleTypes;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkExternalMemoryImageCreateInfo::initialize(const safe_VkExternalMemoryImageCreateInfo* src)
{
    sType = src->sType;
    handleTypes = src->handleTypes;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkExternalMemoryBufferCreateInfo::safe_VkExternalMemoryBufferCreateInfo(const VkExternalMemoryBufferCreateInfo* in_struct) :
    sType(in_struct->sType),
    handleTypes(in_struct->handleTypes)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkExternalMemoryBufferCreateInfo::safe_VkExternalMemoryBufferCreateInfo() :
    pNext(nullptr)
{}

safe_VkExternalMemoryBufferCreateInfo::safe_VkExternalMemoryBufferCreateInfo(const safe_VkExternalMemoryBufferCreateInfo& src)
{
    sType = src.sType;
    handleTypes = src.handleTypes;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkExternalMemoryBufferCreateInfo& safe_VkExternalMemoryBufferCreateInfo::operator=(const safe_VkExternalMemoryBufferCreateInfo& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    handleTypes = src.handleTypes;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkExternalMemoryBufferCreateInfo::~safe_VkExternalMemoryBufferCreateInfo()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkExternalMemoryBufferCreateInfo::initialize(const VkExternalMemoryBufferCreateInfo* in_struct)
{
    sType = in_struct->sType;
    handleTypes = in_struct->handleTypes;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkExternalMemoryBufferCreateInfo::initialize(const safe_VkExternalMemoryBufferCreateInfo* src)
{
    sType = src->sType;
    handleTypes = src->handleTypes;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkExportMemoryAllocateInfo::safe_VkExportMemoryAllocateInfo(const VkExportMemoryAllocateInfo* in_struct) :
    sType(in_struct->sType),
    handleTypes(in_struct->handleTypes)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkExportMemoryAllocateInfo::safe_VkExportMemoryAllocateInfo() :
    pNext(nullptr)
{}

safe_VkExportMemoryAllocateInfo::safe_VkExportMemoryAllocateInfo(const safe_VkExportMemoryAllocateInfo& src)
{
    sType = src.sType;
    handleTypes = src.handleTypes;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkExportMemoryAllocateInfo& safe_VkExportMemoryAllocateInfo::operator=(const safe_VkExportMemoryAllocateInfo& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    handleTypes = src.handleTypes;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkExportMemoryAllocateInfo::~safe_VkExportMemoryAllocateInfo()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkExportMemoryAllocateInfo::initialize(const VkExportMemoryAllocateInfo* in_struct)
{
    sType = in_struct->sType;
    handleTypes = in_struct->handleTypes;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkExportMemoryAllocateInfo::initialize(const safe_VkExportMemoryAllocateInfo* src)
{
    sType = src->sType;
    handleTypes = src->handleTypes;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkPhysicalDeviceExternalFenceInfo::safe_VkPhysicalDeviceExternalFenceInfo(const VkPhysicalDeviceExternalFenceInfo* in_struct) :
    sType(in_struct->sType),
    handleType(in_struct->handleType)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkPhysicalDeviceExternalFenceInfo::safe_VkPhysicalDeviceExternalFenceInfo() :
    pNext(nullptr)
{}

safe_VkPhysicalDeviceExternalFenceInfo::safe_VkPhysicalDeviceExternalFenceInfo(const safe_VkPhysicalDeviceExternalFenceInfo& src)
{
    sType = src.sType;
    handleType = src.handleType;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkPhysicalDeviceExternalFenceInfo& safe_VkPhysicalDeviceExternalFenceInfo::operator=(const safe_VkPhysicalDeviceExternalFenceInfo& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    handleType = src.handleType;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkPhysicalDeviceExternalFenceInfo::~safe_VkPhysicalDeviceExternalFenceInfo()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPhysicalDeviceExternalFenceInfo::initialize(const VkPhysicalDeviceExternalFenceInfo* in_struct)
{
    sType = in_struct->sType;
    handleType = in_struct->handleType;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkPhysicalDeviceExternalFenceInfo::initialize(const safe_VkPhysicalDeviceExternalFenceInfo* src)
{
    sType = src->sType;
    handleType = src->handleType;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkExternalFenceProperties::safe_VkExternalFenceProperties(const VkExternalFenceProperties* in_struct) :
    sType(in_struct->sType),
    exportFromImportedHandleTypes(in_struct->exportFromImportedHandleTypes),
    compatibleHandleTypes(in_struct->compatibleHandleTypes),
    externalFenceFeatures(in_struct->externalFenceFeatures)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkExternalFenceProperties::safe_VkExternalFenceProperties() :
    pNext(nullptr)
{}

safe_VkExternalFenceProperties::safe_VkExternalFenceProperties(const safe_VkExternalFenceProperties& src)
{
    sType = src.sType;
    exportFromImportedHandleTypes = src.exportFromImportedHandleTypes;
    compatibleHandleTypes = src.compatibleHandleTypes;
    externalFenceFeatures = src.externalFenceFeatures;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkExternalFenceProperties& safe_VkExternalFenceProperties::operator=(const safe_VkExternalFenceProperties& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    exportFromImportedHandleTypes = src.exportFromImportedHandleTypes;
    compatibleHandleTypes = src.compatibleHandleTypes;
    externalFenceFeatures = src.externalFenceFeatures;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkExternalFenceProperties::~safe_VkExternalFenceProperties()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkExternalFenceProperties::initialize(const VkExternalFenceProperties* in_struct)
{
    sType = in_struct->sType;
    exportFromImportedHandleTypes = in_struct->exportFromImportedHandleTypes;
    compatibleHandleTypes = in_struct->compatibleHandleTypes;
    externalFenceFeatures = in_struct->externalFenceFeatures;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkExternalFenceProperties::initialize(const safe_VkExternalFenceProperties* src)
{
    sType = src->sType;
    exportFromImportedHandleTypes = src->exportFromImportedHandleTypes;
    compatibleHandleTypes = src->compatibleHandleTypes;
    externalFenceFeatures = src->externalFenceFeatures;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkExportFenceCreateInfo::safe_VkExportFenceCreateInfo(const VkExportFenceCreateInfo* in_struct) :
    sType(in_struct->sType),
    handleTypes(in_struct->handleTypes)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkExportFenceCreateInfo::safe_VkExportFenceCreateInfo() :
    pNext(nullptr)
{}

safe_VkExportFenceCreateInfo::safe_VkExportFenceCreateInfo(const safe_VkExportFenceCreateInfo& src)
{
    sType = src.sType;
    handleTypes = src.handleTypes;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkExportFenceCreateInfo& safe_VkExportFenceCreateInfo::operator=(const safe_VkExportFenceCreateInfo& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    handleTypes = src.handleTypes;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkExportFenceCreateInfo::~safe_VkExportFenceCreateInfo()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkExportFenceCreateInfo::initialize(const VkExportFenceCreateInfo* in_struct)
{
    sType = in_struct->sType;
    handleTypes = in_struct->handleTypes;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkExportFenceCreateInfo::initialize(const safe_VkExportFenceCreateInfo* src)
{
    sType = src->sType;
    handleTypes = src->handleTypes;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkExportSemaphoreCreateInfo::safe_VkExportSemaphoreCreateInfo(const VkExportSemaphoreCreateInfo* in_struct) :
    sType(in_struct->sType),
    handleTypes(in_struct->handleTypes)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkExportSemaphoreCreateInfo::safe_VkExportSemaphoreCreateInfo() :
    pNext(nullptr)
{}

safe_VkExportSemaphoreCreateInfo::safe_VkExportSemaphoreCreateInfo(const safe_VkExportSemaphoreCreateInfo& src)
{
    sType = src.sType;
    handleTypes = src.handleTypes;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkExportSemaphoreCreateInfo& safe_VkExportSemaphoreCreateInfo::operator=(const safe_VkExportSemaphoreCreateInfo& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    handleTypes = src.handleTypes;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkExportSemaphoreCreateInfo::~safe_VkExportSemaphoreCreateInfo()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkExportSemaphoreCreateInfo::initialize(const VkExportSemaphoreCreateInfo* in_struct)
{
    sType = in_struct->sType;
    handleTypes = in_struct->handleTypes;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkExportSemaphoreCreateInfo::initialize(const safe_VkExportSemaphoreCreateInfo* src)
{
    sType = src->sType;
    handleTypes = src->handleTypes;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkPhysicalDeviceExternalSemaphoreInfo::safe_VkPhysicalDeviceExternalSemaphoreInfo(const VkPhysicalDeviceExternalSemaphoreInfo* in_struct) :
    sType(in_struct->sType),
    handleType(in_struct->handleType)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkPhysicalDeviceExternalSemaphoreInfo::safe_VkPhysicalDeviceExternalSemaphoreInfo() :
    pNext(nullptr)
{}

safe_VkPhysicalDeviceExternalSemaphoreInfo::safe_VkPhysicalDeviceExternalSemaphoreInfo(const safe_VkPhysicalDeviceExternalSemaphoreInfo& src)
{
    sType = src.sType;
    handleType = src.handleType;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkPhysicalDeviceExternalSemaphoreInfo& safe_VkPhysicalDeviceExternalSemaphoreInfo::operator=(const safe_VkPhysicalDeviceExternalSemaphoreInfo& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    handleType = src.handleType;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkPhysicalDeviceExternalSemaphoreInfo::~safe_VkPhysicalDeviceExternalSemaphoreInfo()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPhysicalDeviceExternalSemaphoreInfo::initialize(const VkPhysicalDeviceExternalSemaphoreInfo* in_struct)
{
    sType = in_struct->sType;
    handleType = in_struct->handleType;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkPhysicalDeviceExternalSemaphoreInfo::initialize(const safe_VkPhysicalDeviceExternalSemaphoreInfo* src)
{
    sType = src->sType;
    handleType = src->handleType;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkExternalSemaphoreProperties::safe_VkExternalSemaphoreProperties(const VkExternalSemaphoreProperties* in_struct) :
    sType(in_struct->sType),
    exportFromImportedHandleTypes(in_struct->exportFromImportedHandleTypes),
    compatibleHandleTypes(in_struct->compatibleHandleTypes),
    externalSemaphoreFeatures(in_struct->externalSemaphoreFeatures)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkExternalSemaphoreProperties::safe_VkExternalSemaphoreProperties() :
    pNext(nullptr)
{}

safe_VkExternalSemaphoreProperties::safe_VkExternalSemaphoreProperties(const safe_VkExternalSemaphoreProperties& src)
{
    sType = src.sType;
    exportFromImportedHandleTypes = src.exportFromImportedHandleTypes;
    compatibleHandleTypes = src.compatibleHandleTypes;
    externalSemaphoreFeatures = src.externalSemaphoreFeatures;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkExternalSemaphoreProperties& safe_VkExternalSemaphoreProperties::operator=(const safe_VkExternalSemaphoreProperties& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    exportFromImportedHandleTypes = src.exportFromImportedHandleTypes;
    compatibleHandleTypes = src.compatibleHandleTypes;
    externalSemaphoreFeatures = src.externalSemaphoreFeatures;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkExternalSemaphoreProperties::~safe_VkExternalSemaphoreProperties()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkExternalSemaphoreProperties::initialize(const VkExternalSemaphoreProperties* in_struct)
{
    sType = in_struct->sType;
    exportFromImportedHandleTypes = in_struct->exportFromImportedHandleTypes;
    compatibleHandleTypes = in_struct->compatibleHandleTypes;
    externalSemaphoreFeatures = in_struct->externalSemaphoreFeatures;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkExternalSemaphoreProperties::initialize(const safe_VkExternalSemaphoreProperties* src)
{
    sType = src->sType;
    exportFromImportedHandleTypes = src->exportFromImportedHandleTypes;
    compatibleHandleTypes = src->compatibleHandleTypes;
    externalSemaphoreFeatures = src->externalSemaphoreFeatures;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkPhysicalDeviceMaintenance3Properties::safe_VkPhysicalDeviceMaintenance3Properties(const VkPhysicalDeviceMaintenance3Properties* in_struct) :
    sType(in_struct->sType),
    maxPerSetDescriptors(in_struct->maxPerSetDescriptors),
    maxMemoryAllocationSize(in_struct->maxMemoryAllocationSize)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkPhysicalDeviceMaintenance3Properties::safe_VkPhysicalDeviceMaintenance3Properties() :
    pNext(nullptr)
{}

safe_VkPhysicalDeviceMaintenance3Properties::safe_VkPhysicalDeviceMaintenance3Properties(const safe_VkPhysicalDeviceMaintenance3Properties& src)
{
    sType = src.sType;
    maxPerSetDescriptors = src.maxPerSetDescriptors;
    maxMemoryAllocationSize = src.maxMemoryAllocationSize;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkPhysicalDeviceMaintenance3Properties& safe_VkPhysicalDeviceMaintenance3Properties::operator=(const safe_VkPhysicalDeviceMaintenance3Properties& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    maxPerSetDescriptors = src.maxPerSetDescriptors;
    maxMemoryAllocationSize = src.maxMemoryAllocationSize;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkPhysicalDeviceMaintenance3Properties::~safe_VkPhysicalDeviceMaintenance3Properties()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPhysicalDeviceMaintenance3Properties::initialize(const VkPhysicalDeviceMaintenance3Properties* in_struct)
{
    sType = in_struct->sType;
    maxPerSetDescriptors = in_struct->maxPerSetDescriptors;
    maxMemoryAllocationSize = in_struct->maxMemoryAllocationSize;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkPhysicalDeviceMaintenance3Properties::initialize(const safe_VkPhysicalDeviceMaintenance3Properties* src)
{
    sType = src->sType;
    maxPerSetDescriptors = src->maxPerSetDescriptors;
    maxMemoryAllocationSize = src->maxMemoryAllocationSize;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkDescriptorSetLayoutSupport::safe_VkDescriptorSetLayoutSupport(const VkDescriptorSetLayoutSupport* in_struct) :
    sType(in_struct->sType),
    supported(in_struct->supported)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkDescriptorSetLayoutSupport::safe_VkDescriptorSetLayoutSupport() :
    pNext(nullptr)
{}

safe_VkDescriptorSetLayoutSupport::safe_VkDescriptorSetLayoutSupport(const safe_VkDescriptorSetLayoutSupport& src)
{
    sType = src.sType;
    supported = src.supported;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkDescriptorSetLayoutSupport& safe_VkDescriptorSetLayoutSupport::operator=(const safe_VkDescriptorSetLayoutSupport& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    supported = src.supported;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkDescriptorSetLayoutSupport::~safe_VkDescriptorSetLayoutSupport()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkDescriptorSetLayoutSupport::initialize(const VkDescriptorSetLayoutSupport* in_struct)
{
    sType = in_struct->sType;
    supported = in_struct->supported;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkDescriptorSetLayoutSupport::initialize(const safe_VkDescriptorSetLayoutSupport* src)
{
    sType = src->sType;
    supported = src->supported;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkPhysicalDeviceShaderDrawParametersFeatures::safe_VkPhysicalDeviceShaderDrawParametersFeatures(const VkPhysicalDeviceShaderDrawParametersFeatures* in_struct) :
    sType(in_struct->sType),
    shaderDrawParameters(in_struct->shaderDrawParameters)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkPhysicalDeviceShaderDrawParametersFeatures::safe_VkPhysicalDeviceShaderDrawParametersFeatures() :
    pNext(nullptr)
{}

safe_VkPhysicalDeviceShaderDrawParametersFeatures::safe_VkPhysicalDeviceShaderDrawParametersFeatures(const safe_VkPhysicalDeviceShaderDrawParametersFeatures& src)
{
    sType = src.sType;
    shaderDrawParameters = src.shaderDrawParameters;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkPhysicalDeviceShaderDrawParametersFeatures& safe_VkPhysicalDeviceShaderDrawParametersFeatures::operator=(const safe_VkPhysicalDeviceShaderDrawParametersFeatures& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    shaderDrawParameters = src.shaderDrawParameters;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkPhysicalDeviceShaderDrawParametersFeatures::~safe_VkPhysicalDeviceShaderDrawParametersFeatures()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPhysicalDeviceShaderDrawParametersFeatures::initialize(const VkPhysicalDeviceShaderDrawParametersFeatures* in_struct)
{
    sType = in_struct->sType;
    shaderDrawParameters = in_struct->shaderDrawParameters;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkPhysicalDeviceShaderDrawParametersFeatures::initialize(const safe_VkPhysicalDeviceShaderDrawParametersFeatures* src)
{
    sType = src->sType;
    shaderDrawParameters = src->shaderDrawParameters;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkSwapchainCreateInfoKHR::safe_VkSwapchainCreateInfoKHR(const VkSwapchainCreateInfoKHR* in_struct) :
    sType(in_struct->sType),
    flags(in_struct->flags),
    surface(in_struct->surface),
    minImageCount(in_struct->minImageCount),
    imageFormat(in_struct->imageFormat),
    imageColorSpace(in_struct->imageColorSpace),
    imageExtent(in_struct->imageExtent),
    imageArrayLayers(in_struct->imageArrayLayers),
    imageUsage(in_struct->imageUsage),
    imageSharingMode(in_struct->imageSharingMode),
    queueFamilyIndexCount(in_struct->queueFamilyIndexCount),
    pQueueFamilyIndices(nullptr),
    preTransform(in_struct->preTransform),
    compositeAlpha(in_struct->compositeAlpha),
    presentMode(in_struct->presentMode),
    clipped(in_struct->clipped),
    oldSwapchain(in_struct->oldSwapchain)
{
    pNext = SafePnextCopy(in_struct->pNext);
    if (in_struct->pQueueFamilyIndices) {
        pQueueFamilyIndices = new uint32_t[in_struct->queueFamilyIndexCount];
        memcpy ((void *)pQueueFamilyIndices, (void *)in_struct->pQueueFamilyIndices, sizeof(uint32_t)*in_struct->queueFamilyIndexCount);
    }
}

safe_VkSwapchainCreateInfoKHR::safe_VkSwapchainCreateInfoKHR() :
    pNext(nullptr),
    pQueueFamilyIndices(nullptr)
{}

safe_VkSwapchainCreateInfoKHR::safe_VkSwapchainCreateInfoKHR(const safe_VkSwapchainCreateInfoKHR& src)
{
    sType = src.sType;
    flags = src.flags;
    surface = src.surface;
    minImageCount = src.minImageCount;
    imageFormat = src.imageFormat;
    imageColorSpace = src.imageColorSpace;
    imageExtent = src.imageExtent;
    imageArrayLayers = src.imageArrayLayers;
    imageUsage = src.imageUsage;
    imageSharingMode = src.imageSharingMode;
    queueFamilyIndexCount = src.queueFamilyIndexCount;
    pQueueFamilyIndices = nullptr;
    preTransform = src.preTransform;
    compositeAlpha = src.compositeAlpha;
    presentMode = src.presentMode;
    clipped = src.clipped;
    oldSwapchain = src.oldSwapchain;
    pNext = SafePnextCopy(src.pNext);
    if (src.pQueueFamilyIndices) {
        pQueueFamilyIndices = new uint32_t[src.queueFamilyIndexCount];
        memcpy ((void *)pQueueFamilyIndices, (void *)src.pQueueFamilyIndices, sizeof(uint32_t)*src.queueFamilyIndexCount);
    }
}

safe_VkSwapchainCreateInfoKHR& safe_VkSwapchainCreateInfoKHR::operator=(const safe_VkSwapchainCreateInfoKHR& src)
{
    if (&src == this) return *this;

    if (pQueueFamilyIndices)
        delete[] pQueueFamilyIndices;
    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    flags = src.flags;
    surface = src.surface;
    minImageCount = src.minImageCount;
    imageFormat = src.imageFormat;
    imageColorSpace = src.imageColorSpace;
    imageExtent = src.imageExtent;
    imageArrayLayers = src.imageArrayLayers;
    imageUsage = src.imageUsage;
    imageSharingMode = src.imageSharingMode;
    queueFamilyIndexCount = src.queueFamilyIndexCount;
    pQueueFamilyIndices = nullptr;
    preTransform = src.preTransform;
    compositeAlpha = src.compositeAlpha;
    presentMode = src.presentMode;
    clipped = src.clipped;
    oldSwapchain = src.oldSwapchain;
    pNext = SafePnextCopy(src.pNext);
    if (src.pQueueFamilyIndices) {
        pQueueFamilyIndices = new uint32_t[src.queueFamilyIndexCount];
        memcpy ((void *)pQueueFamilyIndices, (void *)src.pQueueFamilyIndices, sizeof(uint32_t)*src.queueFamilyIndexCount);
    }

    return *this;
}

safe_VkSwapchainCreateInfoKHR::~safe_VkSwapchainCreateInfoKHR()
{
    if (pQueueFamilyIndices)
        delete[] pQueueFamilyIndices;
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkSwapchainCreateInfoKHR::initialize(const VkSwapchainCreateInfoKHR* in_struct)
{
    sType = in_struct->sType;
    flags = in_struct->flags;
    surface = in_struct->surface;
    minImageCount = in_struct->minImageCount;
    imageFormat = in_struct->imageFormat;
    imageColorSpace = in_struct->imageColorSpace;
    imageExtent = in_struct->imageExtent;
    imageArrayLayers = in_struct->imageArrayLayers;
    imageUsage = in_struct->imageUsage;
    imageSharingMode = in_struct->imageSharingMode;
    queueFamilyIndexCount = in_struct->queueFamilyIndexCount;
    pQueueFamilyIndices = nullptr;
    preTransform = in_struct->preTransform;
    compositeAlpha = in_struct->compositeAlpha;
    presentMode = in_struct->presentMode;
    clipped = in_struct->clipped;
    oldSwapchain = in_struct->oldSwapchain;
    pNext = SafePnextCopy(in_struct->pNext);
    if (in_struct->pQueueFamilyIndices) {
        pQueueFamilyIndices = new uint32_t[in_struct->queueFamilyIndexCount];
        memcpy ((void *)pQueueFamilyIndices, (void *)in_struct->pQueueFamilyIndices, sizeof(uint32_t)*in_struct->queueFamilyIndexCount);
    }
}

void safe_VkSwapchainCreateInfoKHR::initialize(const safe_VkSwapchainCreateInfoKHR* src)
{
    sType = src->sType;
    flags = src->flags;
    surface = src->surface;
    minImageCount = src->minImageCount;
    imageFormat = src->imageFormat;
    imageColorSpace = src->imageColorSpace;
    imageExtent = src->imageExtent;
    imageArrayLayers = src->imageArrayLayers;
    imageUsage = src->imageUsage;
    imageSharingMode = src->imageSharingMode;
    queueFamilyIndexCount = src->queueFamilyIndexCount;
    pQueueFamilyIndices = nullptr;
    preTransform = src->preTransform;
    compositeAlpha = src->compositeAlpha;
    presentMode = src->presentMode;
    clipped = src->clipped;
    oldSwapchain = src->oldSwapchain;
    pNext = SafePnextCopy(src->pNext);
    if (src->pQueueFamilyIndices) {
        pQueueFamilyIndices = new uint32_t[src->queueFamilyIndexCount];
        memcpy ((void *)pQueueFamilyIndices, (void *)src->pQueueFamilyIndices, sizeof(uint32_t)*src->queueFamilyIndexCount);
    }
}

safe_VkPresentInfoKHR::safe_VkPresentInfoKHR(const VkPresentInfoKHR* in_struct) :
    sType(in_struct->sType),
    waitSemaphoreCount(in_struct->waitSemaphoreCount),
    pWaitSemaphores(nullptr),
    swapchainCount(in_struct->swapchainCount),
    pSwapchains(nullptr),
    pImageIndices(nullptr),
    pResults(nullptr)
{
    pNext = SafePnextCopy(in_struct->pNext);
    if (waitSemaphoreCount && in_struct->pWaitSemaphores) {
        pWaitSemaphores = new VkSemaphore[waitSemaphoreCount];
        for (uint32_t i = 0; i < waitSemaphoreCount; ++i) {
            pWaitSemaphores[i] = in_struct->pWaitSemaphores[i];
        }
    }
    if (swapchainCount && in_struct->pSwapchains) {
        pSwapchains = new VkSwapchainKHR[swapchainCount];
        for (uint32_t i = 0; i < swapchainCount; ++i) {
            pSwapchains[i] = in_struct->pSwapchains[i];
        }
    }
    if (in_struct->pImageIndices) {
        pImageIndices = new uint32_t[in_struct->swapchainCount];
        memcpy ((void *)pImageIndices, (void *)in_struct->pImageIndices, sizeof(uint32_t)*in_struct->swapchainCount);
    }
    if (in_struct->pResults) {
        pResults = new VkResult[in_struct->swapchainCount];
        memcpy ((void *)pResults, (void *)in_struct->pResults, sizeof(VkResult)*in_struct->swapchainCount);
    }
}

safe_VkPresentInfoKHR::safe_VkPresentInfoKHR() :
    pNext(nullptr),
    pWaitSemaphores(nullptr),
    pSwapchains(nullptr),
    pImageIndices(nullptr),
    pResults(nullptr)
{}

safe_VkPresentInfoKHR::safe_VkPresentInfoKHR(const safe_VkPresentInfoKHR& src)
{
    sType = src.sType;
    waitSemaphoreCount = src.waitSemaphoreCount;
    pWaitSemaphores = nullptr;
    swapchainCount = src.swapchainCount;
    pSwapchains = nullptr;
    pImageIndices = nullptr;
    pResults = nullptr;
    pNext = SafePnextCopy(src.pNext);
    if (waitSemaphoreCount && src.pWaitSemaphores) {
        pWaitSemaphores = new VkSemaphore[waitSemaphoreCount];
        for (uint32_t i = 0; i < waitSemaphoreCount; ++i) {
            pWaitSemaphores[i] = src.pWaitSemaphores[i];
        }
    }
    if (swapchainCount && src.pSwapchains) {
        pSwapchains = new VkSwapchainKHR[swapchainCount];
        for (uint32_t i = 0; i < swapchainCount; ++i) {
            pSwapchains[i] = src.pSwapchains[i];
        }
    }
    if (src.pImageIndices) {
        pImageIndices = new uint32_t[src.swapchainCount];
        memcpy ((void *)pImageIndices, (void *)src.pImageIndices, sizeof(uint32_t)*src.swapchainCount);
    }
    if (src.pResults) {
        pResults = new VkResult[src.swapchainCount];
        memcpy ((void *)pResults, (void *)src.pResults, sizeof(VkResult)*src.swapchainCount);
    }
}

safe_VkPresentInfoKHR& safe_VkPresentInfoKHR::operator=(const safe_VkPresentInfoKHR& src)
{
    if (&src == this) return *this;

    if (pWaitSemaphores)
        delete[] pWaitSemaphores;
    if (pSwapchains)
        delete[] pSwapchains;
    if (pImageIndices)
        delete[] pImageIndices;
    if (pResults)
        delete[] pResults;
    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    waitSemaphoreCount = src.waitSemaphoreCount;
    pWaitSemaphores = nullptr;
    swapchainCount = src.swapchainCount;
    pSwapchains = nullptr;
    pImageIndices = nullptr;
    pResults = nullptr;
    pNext = SafePnextCopy(src.pNext);
    if (waitSemaphoreCount && src.pWaitSemaphores) {
        pWaitSemaphores = new VkSemaphore[waitSemaphoreCount];
        for (uint32_t i = 0; i < waitSemaphoreCount; ++i) {
            pWaitSemaphores[i] = src.pWaitSemaphores[i];
        }
    }
    if (swapchainCount && src.pSwapchains) {
        pSwapchains = new VkSwapchainKHR[swapchainCount];
        for (uint32_t i = 0; i < swapchainCount; ++i) {
            pSwapchains[i] = src.pSwapchains[i];
        }
    }
    if (src.pImageIndices) {
        pImageIndices = new uint32_t[src.swapchainCount];
        memcpy ((void *)pImageIndices, (void *)src.pImageIndices, sizeof(uint32_t)*src.swapchainCount);
    }
    if (src.pResults) {
        pResults = new VkResult[src.swapchainCount];
        memcpy ((void *)pResults, (void *)src.pResults, sizeof(VkResult)*src.swapchainCount);
    }

    return *this;
}

safe_VkPresentInfoKHR::~safe_VkPresentInfoKHR()
{
    if (pWaitSemaphores)
        delete[] pWaitSemaphores;
    if (pSwapchains)
        delete[] pSwapchains;
    if (pImageIndices)
        delete[] pImageIndices;
    if (pResults)
        delete[] pResults;
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPresentInfoKHR::initialize(const VkPresentInfoKHR* in_struct)
{
    sType = in_struct->sType;
    waitSemaphoreCount = in_struct->waitSemaphoreCount;
    pWaitSemaphores = nullptr;
    swapchainCount = in_struct->swapchainCount;
    pSwapchains = nullptr;
    pImageIndices = nullptr;
    pResults = nullptr;
    pNext = SafePnextCopy(in_struct->pNext);
    if (waitSemaphoreCount && in_struct->pWaitSemaphores) {
        pWaitSemaphores = new VkSemaphore[waitSemaphoreCount];
        for (uint32_t i = 0; i < waitSemaphoreCount; ++i) {
            pWaitSemaphores[i] = in_struct->pWaitSemaphores[i];
        }
    }
    if (swapchainCount && in_struct->pSwapchains) {
        pSwapchains = new VkSwapchainKHR[swapchainCount];
        for (uint32_t i = 0; i < swapchainCount; ++i) {
            pSwapchains[i] = in_struct->pSwapchains[i];
        }
    }
    if (in_struct->pImageIndices) {
        pImageIndices = new uint32_t[in_struct->swapchainCount];
        memcpy ((void *)pImageIndices, (void *)in_struct->pImageIndices, sizeof(uint32_t)*in_struct->swapchainCount);
    }
    if (in_struct->pResults) {
        pResults = new VkResult[in_struct->swapchainCount];
        memcpy ((void *)pResults, (void *)in_struct->pResults, sizeof(VkResult)*in_struct->swapchainCount);
    }
}

void safe_VkPresentInfoKHR::initialize(const safe_VkPresentInfoKHR* src)
{
    sType = src->sType;
    waitSemaphoreCount = src->waitSemaphoreCount;
    pWaitSemaphores = nullptr;
    swapchainCount = src->swapchainCount;
    pSwapchains = nullptr;
    pImageIndices = nullptr;
    pResults = nullptr;
    pNext = SafePnextCopy(src->pNext);
    if (waitSemaphoreCount && src->pWaitSemaphores) {
        pWaitSemaphores = new VkSemaphore[waitSemaphoreCount];
        for (uint32_t i = 0; i < waitSemaphoreCount; ++i) {
            pWaitSemaphores[i] = src->pWaitSemaphores[i];
        }
    }
    if (swapchainCount && src->pSwapchains) {
        pSwapchains = new VkSwapchainKHR[swapchainCount];
        for (uint32_t i = 0; i < swapchainCount; ++i) {
            pSwapchains[i] = src->pSwapchains[i];
        }
    }
    if (src->pImageIndices) {
        pImageIndices = new uint32_t[src->swapchainCount];
        memcpy ((void *)pImageIndices, (void *)src->pImageIndices, sizeof(uint32_t)*src->swapchainCount);
    }
    if (src->pResults) {
        pResults = new VkResult[src->swapchainCount];
        memcpy ((void *)pResults, (void *)src->pResults, sizeof(VkResult)*src->swapchainCount);
    }
}

safe_VkImageSwapchainCreateInfoKHR::safe_VkImageSwapchainCreateInfoKHR(const VkImageSwapchainCreateInfoKHR* in_struct) :
    sType(in_struct->sType),
    swapchain(in_struct->swapchain)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkImageSwapchainCreateInfoKHR::safe_VkImageSwapchainCreateInfoKHR() :
    pNext(nullptr)
{}

safe_VkImageSwapchainCreateInfoKHR::safe_VkImageSwapchainCreateInfoKHR(const safe_VkImageSwapchainCreateInfoKHR& src)
{
    sType = src.sType;
    swapchain = src.swapchain;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkImageSwapchainCreateInfoKHR& safe_VkImageSwapchainCreateInfoKHR::operator=(const safe_VkImageSwapchainCreateInfoKHR& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    swapchain = src.swapchain;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkImageSwapchainCreateInfoKHR::~safe_VkImageSwapchainCreateInfoKHR()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkImageSwapchainCreateInfoKHR::initialize(const VkImageSwapchainCreateInfoKHR* in_struct)
{
    sType = in_struct->sType;
    swapchain = in_struct->swapchain;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkImageSwapchainCreateInfoKHR::initialize(const safe_VkImageSwapchainCreateInfoKHR* src)
{
    sType = src->sType;
    swapchain = src->swapchain;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkBindImageMemorySwapchainInfoKHR::safe_VkBindImageMemorySwapchainInfoKHR(const VkBindImageMemorySwapchainInfoKHR* in_struct) :
    sType(in_struct->sType),
    swapchain(in_struct->swapchain),
    imageIndex(in_struct->imageIndex)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkBindImageMemorySwapchainInfoKHR::safe_VkBindImageMemorySwapchainInfoKHR() :
    pNext(nullptr)
{}

safe_VkBindImageMemorySwapchainInfoKHR::safe_VkBindImageMemorySwapchainInfoKHR(const safe_VkBindImageMemorySwapchainInfoKHR& src)
{
    sType = src.sType;
    swapchain = src.swapchain;
    imageIndex = src.imageIndex;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkBindImageMemorySwapchainInfoKHR& safe_VkBindImageMemorySwapchainInfoKHR::operator=(const safe_VkBindImageMemorySwapchainInfoKHR& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    swapchain = src.swapchain;
    imageIndex = src.imageIndex;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkBindImageMemorySwapchainInfoKHR::~safe_VkBindImageMemorySwapchainInfoKHR()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkBindImageMemorySwapchainInfoKHR::initialize(const VkBindImageMemorySwapchainInfoKHR* in_struct)
{
    sType = in_struct->sType;
    swapchain = in_struct->swapchain;
    imageIndex = in_struct->imageIndex;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkBindImageMemorySwapchainInfoKHR::initialize(const safe_VkBindImageMemorySwapchainInfoKHR* src)
{
    sType = src->sType;
    swapchain = src->swapchain;
    imageIndex = src->imageIndex;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkAcquireNextImageInfoKHR::safe_VkAcquireNextImageInfoKHR(const VkAcquireNextImageInfoKHR* in_struct) :
    sType(in_struct->sType),
    swapchain(in_struct->swapchain),
    timeout(in_struct->timeout),
    semaphore(in_struct->semaphore),
    fence(in_struct->fence),
    deviceMask(in_struct->deviceMask)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkAcquireNextImageInfoKHR::safe_VkAcquireNextImageInfoKHR() :
    pNext(nullptr)
{}

safe_VkAcquireNextImageInfoKHR::safe_VkAcquireNextImageInfoKHR(const safe_VkAcquireNextImageInfoKHR& src)
{
    sType = src.sType;
    swapchain = src.swapchain;
    timeout = src.timeout;
    semaphore = src.semaphore;
    fence = src.fence;
    deviceMask = src.deviceMask;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkAcquireNextImageInfoKHR& safe_VkAcquireNextImageInfoKHR::operator=(const safe_VkAcquireNextImageInfoKHR& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    swapchain = src.swapchain;
    timeout = src.timeout;
    semaphore = src.semaphore;
    fence = src.fence;
    deviceMask = src.deviceMask;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkAcquireNextImageInfoKHR::~safe_VkAcquireNextImageInfoKHR()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkAcquireNextImageInfoKHR::initialize(const VkAcquireNextImageInfoKHR* in_struct)
{
    sType = in_struct->sType;
    swapchain = in_struct->swapchain;
    timeout = in_struct->timeout;
    semaphore = in_struct->semaphore;
    fence = in_struct->fence;
    deviceMask = in_struct->deviceMask;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkAcquireNextImageInfoKHR::initialize(const safe_VkAcquireNextImageInfoKHR* src)
{
    sType = src->sType;
    swapchain = src->swapchain;
    timeout = src->timeout;
    semaphore = src->semaphore;
    fence = src->fence;
    deviceMask = src->deviceMask;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkDeviceGroupPresentCapabilitiesKHR::safe_VkDeviceGroupPresentCapabilitiesKHR(const VkDeviceGroupPresentCapabilitiesKHR* in_struct) :
    sType(in_struct->sType),
    modes(in_struct->modes)
{
    pNext = SafePnextCopy(in_struct->pNext);
    for (uint32_t i = 0; i < VK_MAX_DEVICE_GROUP_SIZE; ++i) {
        presentMask[i] = in_struct->presentMask[i];
    }
}

safe_VkDeviceGroupPresentCapabilitiesKHR::safe_VkDeviceGroupPresentCapabilitiesKHR() :
    pNext(nullptr)
{}

safe_VkDeviceGroupPresentCapabilitiesKHR::safe_VkDeviceGroupPresentCapabilitiesKHR(const safe_VkDeviceGroupPresentCapabilitiesKHR& src)
{
    sType = src.sType;
    modes = src.modes;
    pNext = SafePnextCopy(src.pNext);
    for (uint32_t i = 0; i < VK_MAX_DEVICE_GROUP_SIZE; ++i) {
        presentMask[i] = src.presentMask[i];
    }
}

safe_VkDeviceGroupPresentCapabilitiesKHR& safe_VkDeviceGroupPresentCapabilitiesKHR::operator=(const safe_VkDeviceGroupPresentCapabilitiesKHR& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    modes = src.modes;
    pNext = SafePnextCopy(src.pNext);
    for (uint32_t i = 0; i < VK_MAX_DEVICE_GROUP_SIZE; ++i) {
        presentMask[i] = src.presentMask[i];
    }

    return *this;
}

safe_VkDeviceGroupPresentCapabilitiesKHR::~safe_VkDeviceGroupPresentCapabilitiesKHR()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkDeviceGroupPresentCapabilitiesKHR::initialize(const VkDeviceGroupPresentCapabilitiesKHR* in_struct)
{
    sType = in_struct->sType;
    modes = in_struct->modes;
    pNext = SafePnextCopy(in_struct->pNext);
    for (uint32_t i = 0; i < VK_MAX_DEVICE_GROUP_SIZE; ++i) {
        presentMask[i] = in_struct->presentMask[i];
    }
}

void safe_VkDeviceGroupPresentCapabilitiesKHR::initialize(const safe_VkDeviceGroupPresentCapabilitiesKHR* src)
{
    sType = src->sType;
    modes = src->modes;
    pNext = SafePnextCopy(src->pNext);
    for (uint32_t i = 0; i < VK_MAX_DEVICE_GROUP_SIZE; ++i) {
        presentMask[i] = src->presentMask[i];
    }
}

safe_VkDeviceGroupPresentInfoKHR::safe_VkDeviceGroupPresentInfoKHR(const VkDeviceGroupPresentInfoKHR* in_struct) :
    sType(in_struct->sType),
    swapchainCount(in_struct->swapchainCount),
    pDeviceMasks(nullptr),
    mode(in_struct->mode)
{
    pNext = SafePnextCopy(in_struct->pNext);
    if (in_struct->pDeviceMasks) {
        pDeviceMasks = new uint32_t[in_struct->swapchainCount];
        memcpy ((void *)pDeviceMasks, (void *)in_struct->pDeviceMasks, sizeof(uint32_t)*in_struct->swapchainCount);
    }
}

safe_VkDeviceGroupPresentInfoKHR::safe_VkDeviceGroupPresentInfoKHR() :
    pNext(nullptr),
    pDeviceMasks(nullptr)
{}

safe_VkDeviceGroupPresentInfoKHR::safe_VkDeviceGroupPresentInfoKHR(const safe_VkDeviceGroupPresentInfoKHR& src)
{
    sType = src.sType;
    swapchainCount = src.swapchainCount;
    pDeviceMasks = nullptr;
    mode = src.mode;
    pNext = SafePnextCopy(src.pNext);
    if (src.pDeviceMasks) {
        pDeviceMasks = new uint32_t[src.swapchainCount];
        memcpy ((void *)pDeviceMasks, (void *)src.pDeviceMasks, sizeof(uint32_t)*src.swapchainCount);
    }
}

safe_VkDeviceGroupPresentInfoKHR& safe_VkDeviceGroupPresentInfoKHR::operator=(const safe_VkDeviceGroupPresentInfoKHR& src)
{
    if (&src == this) return *this;

    if (pDeviceMasks)
        delete[] pDeviceMasks;
    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    swapchainCount = src.swapchainCount;
    pDeviceMasks = nullptr;
    mode = src.mode;
    pNext = SafePnextCopy(src.pNext);
    if (src.pDeviceMasks) {
        pDeviceMasks = new uint32_t[src.swapchainCount];
        memcpy ((void *)pDeviceMasks, (void *)src.pDeviceMasks, sizeof(uint32_t)*src.swapchainCount);
    }

    return *this;
}

safe_VkDeviceGroupPresentInfoKHR::~safe_VkDeviceGroupPresentInfoKHR()
{
    if (pDeviceMasks)
        delete[] pDeviceMasks;
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkDeviceGroupPresentInfoKHR::initialize(const VkDeviceGroupPresentInfoKHR* in_struct)
{
    sType = in_struct->sType;
    swapchainCount = in_struct->swapchainCount;
    pDeviceMasks = nullptr;
    mode = in_struct->mode;
    pNext = SafePnextCopy(in_struct->pNext);
    if (in_struct->pDeviceMasks) {
        pDeviceMasks = new uint32_t[in_struct->swapchainCount];
        memcpy ((void *)pDeviceMasks, (void *)in_struct->pDeviceMasks, sizeof(uint32_t)*in_struct->swapchainCount);
    }
}

void safe_VkDeviceGroupPresentInfoKHR::initialize(const safe_VkDeviceGroupPresentInfoKHR* src)
{
    sType = src->sType;
    swapchainCount = src->swapchainCount;
    pDeviceMasks = nullptr;
    mode = src->mode;
    pNext = SafePnextCopy(src->pNext);
    if (src->pDeviceMasks) {
        pDeviceMasks = new uint32_t[src->swapchainCount];
        memcpy ((void *)pDeviceMasks, (void *)src->pDeviceMasks, sizeof(uint32_t)*src->swapchainCount);
    }
}

safe_VkDeviceGroupSwapchainCreateInfoKHR::safe_VkDeviceGroupSwapchainCreateInfoKHR(const VkDeviceGroupSwapchainCreateInfoKHR* in_struct) :
    sType(in_struct->sType),
    modes(in_struct->modes)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkDeviceGroupSwapchainCreateInfoKHR::safe_VkDeviceGroupSwapchainCreateInfoKHR() :
    pNext(nullptr)
{}

safe_VkDeviceGroupSwapchainCreateInfoKHR::safe_VkDeviceGroupSwapchainCreateInfoKHR(const safe_VkDeviceGroupSwapchainCreateInfoKHR& src)
{
    sType = src.sType;
    modes = src.modes;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkDeviceGroupSwapchainCreateInfoKHR& safe_VkDeviceGroupSwapchainCreateInfoKHR::operator=(const safe_VkDeviceGroupSwapchainCreateInfoKHR& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    modes = src.modes;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkDeviceGroupSwapchainCreateInfoKHR::~safe_VkDeviceGroupSwapchainCreateInfoKHR()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkDeviceGroupSwapchainCreateInfoKHR::initialize(const VkDeviceGroupSwapchainCreateInfoKHR* in_struct)
{
    sType = in_struct->sType;
    modes = in_struct->modes;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkDeviceGroupSwapchainCreateInfoKHR::initialize(const safe_VkDeviceGroupSwapchainCreateInfoKHR* src)
{
    sType = src->sType;
    modes = src->modes;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkDisplayPropertiesKHR::safe_VkDisplayPropertiesKHR(const VkDisplayPropertiesKHR* in_struct) :
    display(in_struct->display),
    physicalDimensions(in_struct->physicalDimensions),
    physicalResolution(in_struct->physicalResolution),
    supportedTransforms(in_struct->supportedTransforms),
    planeReorderPossible(in_struct->planeReorderPossible),
    persistentContent(in_struct->persistentContent)
{
    displayName = SafeStringCopy(in_struct->displayName);
}

safe_VkDisplayPropertiesKHR::safe_VkDisplayPropertiesKHR() :
    displayName(nullptr)
{}

safe_VkDisplayPropertiesKHR::safe_VkDisplayPropertiesKHR(const safe_VkDisplayPropertiesKHR& src)
{
    display = src.display;
    physicalDimensions = src.physicalDimensions;
    physicalResolution = src.physicalResolution;
    supportedTransforms = src.supportedTransforms;
    planeReorderPossible = src.planeReorderPossible;
    persistentContent = src.persistentContent;
    displayName = SafeStringCopy(src.displayName);
}

safe_VkDisplayPropertiesKHR& safe_VkDisplayPropertiesKHR::operator=(const safe_VkDisplayPropertiesKHR& src)
{
    if (&src == this) return *this;

    if (displayName) delete [] displayName;

    display = src.display;
    physicalDimensions = src.physicalDimensions;
    physicalResolution = src.physicalResolution;
    supportedTransforms = src.supportedTransforms;
    planeReorderPossible = src.planeReorderPossible;
    persistentContent = src.persistentContent;
    displayName = SafeStringCopy(src.displayName);

    return *this;
}

safe_VkDisplayPropertiesKHR::~safe_VkDisplayPropertiesKHR()
{
    if (displayName) delete [] displayName;
}

void safe_VkDisplayPropertiesKHR::initialize(const VkDisplayPropertiesKHR* in_struct)
{
    display = in_struct->display;
    physicalDimensions = in_struct->physicalDimensions;
    physicalResolution = in_struct->physicalResolution;
    supportedTransforms = in_struct->supportedTransforms;
    planeReorderPossible = in_struct->planeReorderPossible;
    persistentContent = in_struct->persistentContent;
    displayName = SafeStringCopy(in_struct->displayName);
}

void safe_VkDisplayPropertiesKHR::initialize(const safe_VkDisplayPropertiesKHR* src)
{
    display = src->display;
    physicalDimensions = src->physicalDimensions;
    physicalResolution = src->physicalResolution;
    supportedTransforms = src->supportedTransforms;
    planeReorderPossible = src->planeReorderPossible;
    persistentContent = src->persistentContent;
    displayName = SafeStringCopy(src->displayName);
}

safe_VkDisplayModeCreateInfoKHR::safe_VkDisplayModeCreateInfoKHR(const VkDisplayModeCreateInfoKHR* in_struct) :
    sType(in_struct->sType),
    flags(in_struct->flags),
    parameters(in_struct->parameters)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkDisplayModeCreateInfoKHR::safe_VkDisplayModeCreateInfoKHR() :
    pNext(nullptr)
{}

safe_VkDisplayModeCreateInfoKHR::safe_VkDisplayModeCreateInfoKHR(const safe_VkDisplayModeCreateInfoKHR& src)
{
    sType = src.sType;
    flags = src.flags;
    parameters = src.parameters;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkDisplayModeCreateInfoKHR& safe_VkDisplayModeCreateInfoKHR::operator=(const safe_VkDisplayModeCreateInfoKHR& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    flags = src.flags;
    parameters = src.parameters;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkDisplayModeCreateInfoKHR::~safe_VkDisplayModeCreateInfoKHR()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkDisplayModeCreateInfoKHR::initialize(const VkDisplayModeCreateInfoKHR* in_struct)
{
    sType = in_struct->sType;
    flags = in_struct->flags;
    parameters = in_struct->parameters;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkDisplayModeCreateInfoKHR::initialize(const safe_VkDisplayModeCreateInfoKHR* src)
{
    sType = src->sType;
    flags = src->flags;
    parameters = src->parameters;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkDisplaySurfaceCreateInfoKHR::safe_VkDisplaySurfaceCreateInfoKHR(const VkDisplaySurfaceCreateInfoKHR* in_struct) :
    sType(in_struct->sType),
    flags(in_struct->flags),
    displayMode(in_struct->displayMode),
    planeIndex(in_struct->planeIndex),
    planeStackIndex(in_struct->planeStackIndex),
    transform(in_struct->transform),
    globalAlpha(in_struct->globalAlpha),
    alphaMode(in_struct->alphaMode),
    imageExtent(in_struct->imageExtent)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkDisplaySurfaceCreateInfoKHR::safe_VkDisplaySurfaceCreateInfoKHR() :
    pNext(nullptr)
{}

safe_VkDisplaySurfaceCreateInfoKHR::safe_VkDisplaySurfaceCreateInfoKHR(const safe_VkDisplaySurfaceCreateInfoKHR& src)
{
    sType = src.sType;
    flags = src.flags;
    displayMode = src.displayMode;
    planeIndex = src.planeIndex;
    planeStackIndex = src.planeStackIndex;
    transform = src.transform;
    globalAlpha = src.globalAlpha;
    alphaMode = src.alphaMode;
    imageExtent = src.imageExtent;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkDisplaySurfaceCreateInfoKHR& safe_VkDisplaySurfaceCreateInfoKHR::operator=(const safe_VkDisplaySurfaceCreateInfoKHR& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    flags = src.flags;
    displayMode = src.displayMode;
    planeIndex = src.planeIndex;
    planeStackIndex = src.planeStackIndex;
    transform = src.transform;
    globalAlpha = src.globalAlpha;
    alphaMode = src.alphaMode;
    imageExtent = src.imageExtent;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkDisplaySurfaceCreateInfoKHR::~safe_VkDisplaySurfaceCreateInfoKHR()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkDisplaySurfaceCreateInfoKHR::initialize(const VkDisplaySurfaceCreateInfoKHR* in_struct)
{
    sType = in_struct->sType;
    flags = in_struct->flags;
    displayMode = in_struct->displayMode;
    planeIndex = in_struct->planeIndex;
    planeStackIndex = in_struct->planeStackIndex;
    transform = in_struct->transform;
    globalAlpha = in_struct->globalAlpha;
    alphaMode = in_struct->alphaMode;
    imageExtent = in_struct->imageExtent;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkDisplaySurfaceCreateInfoKHR::initialize(const safe_VkDisplaySurfaceCreateInfoKHR* src)
{
    sType = src->sType;
    flags = src->flags;
    displayMode = src->displayMode;
    planeIndex = src->planeIndex;
    planeStackIndex = src->planeStackIndex;
    transform = src->transform;
    globalAlpha = src->globalAlpha;
    alphaMode = src->alphaMode;
    imageExtent = src->imageExtent;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkDisplayPresentInfoKHR::safe_VkDisplayPresentInfoKHR(const VkDisplayPresentInfoKHR* in_struct) :
    sType(in_struct->sType),
    srcRect(in_struct->srcRect),
    dstRect(in_struct->dstRect),
    persistent(in_struct->persistent)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkDisplayPresentInfoKHR::safe_VkDisplayPresentInfoKHR() :
    pNext(nullptr)
{}

safe_VkDisplayPresentInfoKHR::safe_VkDisplayPresentInfoKHR(const safe_VkDisplayPresentInfoKHR& src)
{
    sType = src.sType;
    srcRect = src.srcRect;
    dstRect = src.dstRect;
    persistent = src.persistent;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkDisplayPresentInfoKHR& safe_VkDisplayPresentInfoKHR::operator=(const safe_VkDisplayPresentInfoKHR& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    srcRect = src.srcRect;
    dstRect = src.dstRect;
    persistent = src.persistent;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkDisplayPresentInfoKHR::~safe_VkDisplayPresentInfoKHR()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkDisplayPresentInfoKHR::initialize(const VkDisplayPresentInfoKHR* in_struct)
{
    sType = in_struct->sType;
    srcRect = in_struct->srcRect;
    dstRect = in_struct->dstRect;
    persistent = in_struct->persistent;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkDisplayPresentInfoKHR::initialize(const safe_VkDisplayPresentInfoKHR* src)
{
    sType = src->sType;
    srcRect = src->srcRect;
    dstRect = src->dstRect;
    persistent = src->persistent;
    pNext = SafePnextCopy(src->pNext);
}
#ifdef VK_USE_PLATFORM_WIN32_KHR


safe_VkImportMemoryWin32HandleInfoKHR::safe_VkImportMemoryWin32HandleInfoKHR(const VkImportMemoryWin32HandleInfoKHR* in_struct) :
    sType(in_struct->sType),
    handleType(in_struct->handleType),
    handle(in_struct->handle),
    name(in_struct->name)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkImportMemoryWin32HandleInfoKHR::safe_VkImportMemoryWin32HandleInfoKHR() :
    pNext(nullptr)
{}

safe_VkImportMemoryWin32HandleInfoKHR::safe_VkImportMemoryWin32HandleInfoKHR(const safe_VkImportMemoryWin32HandleInfoKHR& src)
{
    sType = src.sType;
    handleType = src.handleType;
    handle = src.handle;
    name = src.name;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkImportMemoryWin32HandleInfoKHR& safe_VkImportMemoryWin32HandleInfoKHR::operator=(const safe_VkImportMemoryWin32HandleInfoKHR& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    handleType = src.handleType;
    handle = src.handle;
    name = src.name;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkImportMemoryWin32HandleInfoKHR::~safe_VkImportMemoryWin32HandleInfoKHR()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkImportMemoryWin32HandleInfoKHR::initialize(const VkImportMemoryWin32HandleInfoKHR* in_struct)
{
    sType = in_struct->sType;
    handleType = in_struct->handleType;
    handle = in_struct->handle;
    name = in_struct->name;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkImportMemoryWin32HandleInfoKHR::initialize(const safe_VkImportMemoryWin32HandleInfoKHR* src)
{
    sType = src->sType;
    handleType = src->handleType;
    handle = src->handle;
    name = src->name;
    pNext = SafePnextCopy(src->pNext);
}
#endif // VK_USE_PLATFORM_WIN32_KHR

#ifdef VK_USE_PLATFORM_WIN32_KHR


safe_VkExportMemoryWin32HandleInfoKHR::safe_VkExportMemoryWin32HandleInfoKHR(const VkExportMemoryWin32HandleInfoKHR* in_struct) :
    sType(in_struct->sType),
    pAttributes(nullptr),
    dwAccess(in_struct->dwAccess),
    name(in_struct->name)
{
    pNext = SafePnextCopy(in_struct->pNext);
    if (in_struct->pAttributes) {
        pAttributes = new SECURITY_ATTRIBUTES(*in_struct->pAttributes);
    }
}

safe_VkExportMemoryWin32HandleInfoKHR::safe_VkExportMemoryWin32HandleInfoKHR() :
    pNext(nullptr),
    pAttributes(nullptr)
{}

safe_VkExportMemoryWin32HandleInfoKHR::safe_VkExportMemoryWin32HandleInfoKHR(const safe_VkExportMemoryWin32HandleInfoKHR& src)
{
    sType = src.sType;
    pAttributes = nullptr;
    dwAccess = src.dwAccess;
    name = src.name;
    pNext = SafePnextCopy(src.pNext);
    if (src.pAttributes) {
        pAttributes = new SECURITY_ATTRIBUTES(*src.pAttributes);
    }
}

safe_VkExportMemoryWin32HandleInfoKHR& safe_VkExportMemoryWin32HandleInfoKHR::operator=(const safe_VkExportMemoryWin32HandleInfoKHR& src)
{
    if (&src == this) return *this;

    if (pAttributes)
        delete pAttributes;
    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    pAttributes = nullptr;
    dwAccess = src.dwAccess;
    name = src.name;
    pNext = SafePnextCopy(src.pNext);
    if (src.pAttributes) {
        pAttributes = new SECURITY_ATTRIBUTES(*src.pAttributes);
    }

    return *this;
}

safe_VkExportMemoryWin32HandleInfoKHR::~safe_VkExportMemoryWin32HandleInfoKHR()
{
    if (pAttributes)
        delete pAttributes;
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkExportMemoryWin32HandleInfoKHR::initialize(const VkExportMemoryWin32HandleInfoKHR* in_struct)
{
    sType = in_struct->sType;
    pAttributes = nullptr;
    dwAccess = in_struct->dwAccess;
    name = in_struct->name;
    pNext = SafePnextCopy(in_struct->pNext);
    if (in_struct->pAttributes) {
        pAttributes = new SECURITY_ATTRIBUTES(*in_struct->pAttributes);
    }
}

void safe_VkExportMemoryWin32HandleInfoKHR::initialize(const safe_VkExportMemoryWin32HandleInfoKHR* src)
{
    sType = src->sType;
    pAttributes = nullptr;
    dwAccess = src->dwAccess;
    name = src->name;
    pNext = SafePnextCopy(src->pNext);
    if (src->pAttributes) {
        pAttributes = new SECURITY_ATTRIBUTES(*src->pAttributes);
    }
}
#endif // VK_USE_PLATFORM_WIN32_KHR

#ifdef VK_USE_PLATFORM_WIN32_KHR


safe_VkMemoryWin32HandlePropertiesKHR::safe_VkMemoryWin32HandlePropertiesKHR(const VkMemoryWin32HandlePropertiesKHR* in_struct) :
    sType(in_struct->sType),
    memoryTypeBits(in_struct->memoryTypeBits)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkMemoryWin32HandlePropertiesKHR::safe_VkMemoryWin32HandlePropertiesKHR() :
    pNext(nullptr)
{}

safe_VkMemoryWin32HandlePropertiesKHR::safe_VkMemoryWin32HandlePropertiesKHR(const safe_VkMemoryWin32HandlePropertiesKHR& src)
{
    sType = src.sType;
    memoryTypeBits = src.memoryTypeBits;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkMemoryWin32HandlePropertiesKHR& safe_VkMemoryWin32HandlePropertiesKHR::operator=(const safe_VkMemoryWin32HandlePropertiesKHR& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    memoryTypeBits = src.memoryTypeBits;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkMemoryWin32HandlePropertiesKHR::~safe_VkMemoryWin32HandlePropertiesKHR()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkMemoryWin32HandlePropertiesKHR::initialize(const VkMemoryWin32HandlePropertiesKHR* in_struct)
{
    sType = in_struct->sType;
    memoryTypeBits = in_struct->memoryTypeBits;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkMemoryWin32HandlePropertiesKHR::initialize(const safe_VkMemoryWin32HandlePropertiesKHR* src)
{
    sType = src->sType;
    memoryTypeBits = src->memoryTypeBits;
    pNext = SafePnextCopy(src->pNext);
}
#endif // VK_USE_PLATFORM_WIN32_KHR

#ifdef VK_USE_PLATFORM_WIN32_KHR


safe_VkMemoryGetWin32HandleInfoKHR::safe_VkMemoryGetWin32HandleInfoKHR(const VkMemoryGetWin32HandleInfoKHR* in_struct) :
    sType(in_struct->sType),
    memory(in_struct->memory),
    handleType(in_struct->handleType)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkMemoryGetWin32HandleInfoKHR::safe_VkMemoryGetWin32HandleInfoKHR() :
    pNext(nullptr)
{}

safe_VkMemoryGetWin32HandleInfoKHR::safe_VkMemoryGetWin32HandleInfoKHR(const safe_VkMemoryGetWin32HandleInfoKHR& src)
{
    sType = src.sType;
    memory = src.memory;
    handleType = src.handleType;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkMemoryGetWin32HandleInfoKHR& safe_VkMemoryGetWin32HandleInfoKHR::operator=(const safe_VkMemoryGetWin32HandleInfoKHR& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    memory = src.memory;
    handleType = src.handleType;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkMemoryGetWin32HandleInfoKHR::~safe_VkMemoryGetWin32HandleInfoKHR()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkMemoryGetWin32HandleInfoKHR::initialize(const VkMemoryGetWin32HandleInfoKHR* in_struct)
{
    sType = in_struct->sType;
    memory = in_struct->memory;
    handleType = in_struct->handleType;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkMemoryGetWin32HandleInfoKHR::initialize(const safe_VkMemoryGetWin32HandleInfoKHR* src)
{
    sType = src->sType;
    memory = src->memory;
    handleType = src->handleType;
    pNext = SafePnextCopy(src->pNext);
}
#endif // VK_USE_PLATFORM_WIN32_KHR


safe_VkImportMemoryFdInfoKHR::safe_VkImportMemoryFdInfoKHR(const VkImportMemoryFdInfoKHR* in_struct) :
    sType(in_struct->sType),
    handleType(in_struct->handleType),
    fd(in_struct->fd)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkImportMemoryFdInfoKHR::safe_VkImportMemoryFdInfoKHR() :
    pNext(nullptr)
{}

safe_VkImportMemoryFdInfoKHR::safe_VkImportMemoryFdInfoKHR(const safe_VkImportMemoryFdInfoKHR& src)
{
    sType = src.sType;
    handleType = src.handleType;
    fd = src.fd;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkImportMemoryFdInfoKHR& safe_VkImportMemoryFdInfoKHR::operator=(const safe_VkImportMemoryFdInfoKHR& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    handleType = src.handleType;
    fd = src.fd;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkImportMemoryFdInfoKHR::~safe_VkImportMemoryFdInfoKHR()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkImportMemoryFdInfoKHR::initialize(const VkImportMemoryFdInfoKHR* in_struct)
{
    sType = in_struct->sType;
    handleType = in_struct->handleType;
    fd = in_struct->fd;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkImportMemoryFdInfoKHR::initialize(const safe_VkImportMemoryFdInfoKHR* src)
{
    sType = src->sType;
    handleType = src->handleType;
    fd = src->fd;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkMemoryFdPropertiesKHR::safe_VkMemoryFdPropertiesKHR(const VkMemoryFdPropertiesKHR* in_struct) :
    sType(in_struct->sType),
    memoryTypeBits(in_struct->memoryTypeBits)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkMemoryFdPropertiesKHR::safe_VkMemoryFdPropertiesKHR() :
    pNext(nullptr)
{}

safe_VkMemoryFdPropertiesKHR::safe_VkMemoryFdPropertiesKHR(const safe_VkMemoryFdPropertiesKHR& src)
{
    sType = src.sType;
    memoryTypeBits = src.memoryTypeBits;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkMemoryFdPropertiesKHR& safe_VkMemoryFdPropertiesKHR::operator=(const safe_VkMemoryFdPropertiesKHR& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    memoryTypeBits = src.memoryTypeBits;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkMemoryFdPropertiesKHR::~safe_VkMemoryFdPropertiesKHR()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkMemoryFdPropertiesKHR::initialize(const VkMemoryFdPropertiesKHR* in_struct)
{
    sType = in_struct->sType;
    memoryTypeBits = in_struct->memoryTypeBits;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkMemoryFdPropertiesKHR::initialize(const safe_VkMemoryFdPropertiesKHR* src)
{
    sType = src->sType;
    memoryTypeBits = src->memoryTypeBits;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkMemoryGetFdInfoKHR::safe_VkMemoryGetFdInfoKHR(const VkMemoryGetFdInfoKHR* in_struct) :
    sType(in_struct->sType),
    memory(in_struct->memory),
    handleType(in_struct->handleType)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkMemoryGetFdInfoKHR::safe_VkMemoryGetFdInfoKHR() :
    pNext(nullptr)
{}

safe_VkMemoryGetFdInfoKHR::safe_VkMemoryGetFdInfoKHR(const safe_VkMemoryGetFdInfoKHR& src)
{
    sType = src.sType;
    memory = src.memory;
    handleType = src.handleType;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkMemoryGetFdInfoKHR& safe_VkMemoryGetFdInfoKHR::operator=(const safe_VkMemoryGetFdInfoKHR& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    memory = src.memory;
    handleType = src.handleType;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkMemoryGetFdInfoKHR::~safe_VkMemoryGetFdInfoKHR()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkMemoryGetFdInfoKHR::initialize(const VkMemoryGetFdInfoKHR* in_struct)
{
    sType = in_struct->sType;
    memory = in_struct->memory;
    handleType = in_struct->handleType;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkMemoryGetFdInfoKHR::initialize(const safe_VkMemoryGetFdInfoKHR* src)
{
    sType = src->sType;
    memory = src->memory;
    handleType = src->handleType;
    pNext = SafePnextCopy(src->pNext);
}
#ifdef VK_USE_PLATFORM_WIN32_KHR


safe_VkWin32KeyedMutexAcquireReleaseInfoKHR::safe_VkWin32KeyedMutexAcquireReleaseInfoKHR(const VkWin32KeyedMutexAcquireReleaseInfoKHR* in_struct) :
    sType(in_struct->sType),
    acquireCount(in_struct->acquireCount),
    pAcquireSyncs(nullptr),
    pAcquireKeys(nullptr),
    pAcquireTimeouts(nullptr),
    releaseCount(in_struct->releaseCount),
    pReleaseSyncs(nullptr),
    pReleaseKeys(nullptr)
{
    pNext = SafePnextCopy(in_struct->pNext);
    if (acquireCount && in_struct->pAcquireSyncs) {
        pAcquireSyncs = new VkDeviceMemory[acquireCount];
        for (uint32_t i = 0; i < acquireCount; ++i) {
            pAcquireSyncs[i] = in_struct->pAcquireSyncs[i];
        }
    }
    if (in_struct->pAcquireKeys) {
        pAcquireKeys = new uint64_t[in_struct->acquireCount];
        memcpy ((void *)pAcquireKeys, (void *)in_struct->pAcquireKeys, sizeof(uint64_t)*in_struct->acquireCount);
    }
    if (in_struct->pAcquireTimeouts) {
        pAcquireTimeouts = new uint32_t[in_struct->acquireCount];
        memcpy ((void *)pAcquireTimeouts, (void *)in_struct->pAcquireTimeouts, sizeof(uint32_t)*in_struct->acquireCount);
    }
    if (releaseCount && in_struct->pReleaseSyncs) {
        pReleaseSyncs = new VkDeviceMemory[releaseCount];
        for (uint32_t i = 0; i < releaseCount; ++i) {
            pReleaseSyncs[i] = in_struct->pReleaseSyncs[i];
        }
    }
    if (in_struct->pReleaseKeys) {
        pReleaseKeys = new uint64_t[in_struct->releaseCount];
        memcpy ((void *)pReleaseKeys, (void *)in_struct->pReleaseKeys, sizeof(uint64_t)*in_struct->releaseCount);
    }
}

safe_VkWin32KeyedMutexAcquireReleaseInfoKHR::safe_VkWin32KeyedMutexAcquireReleaseInfoKHR() :
    pNext(nullptr),
    pAcquireSyncs(nullptr),
    pAcquireKeys(nullptr),
    pAcquireTimeouts(nullptr),
    pReleaseSyncs(nullptr),
    pReleaseKeys(nullptr)
{}

safe_VkWin32KeyedMutexAcquireReleaseInfoKHR::safe_VkWin32KeyedMutexAcquireReleaseInfoKHR(const safe_VkWin32KeyedMutexAcquireReleaseInfoKHR& src)
{
    sType = src.sType;
    acquireCount = src.acquireCount;
    pAcquireSyncs = nullptr;
    pAcquireKeys = nullptr;
    pAcquireTimeouts = nullptr;
    releaseCount = src.releaseCount;
    pReleaseSyncs = nullptr;
    pReleaseKeys = nullptr;
    pNext = SafePnextCopy(src.pNext);
    if (acquireCount && src.pAcquireSyncs) {
        pAcquireSyncs = new VkDeviceMemory[acquireCount];
        for (uint32_t i = 0; i < acquireCount; ++i) {
            pAcquireSyncs[i] = src.pAcquireSyncs[i];
        }
    }
    if (src.pAcquireKeys) {
        pAcquireKeys = new uint64_t[src.acquireCount];
        memcpy ((void *)pAcquireKeys, (void *)src.pAcquireKeys, sizeof(uint64_t)*src.acquireCount);
    }
    if (src.pAcquireTimeouts) {
        pAcquireTimeouts = new uint32_t[src.acquireCount];
        memcpy ((void *)pAcquireTimeouts, (void *)src.pAcquireTimeouts, sizeof(uint32_t)*src.acquireCount);
    }
    if (releaseCount && src.pReleaseSyncs) {
        pReleaseSyncs = new VkDeviceMemory[releaseCount];
        for (uint32_t i = 0; i < releaseCount; ++i) {
            pReleaseSyncs[i] = src.pReleaseSyncs[i];
        }
    }
    if (src.pReleaseKeys) {
        pReleaseKeys = new uint64_t[src.releaseCount];
        memcpy ((void *)pReleaseKeys, (void *)src.pReleaseKeys, sizeof(uint64_t)*src.releaseCount);
    }
}

safe_VkWin32KeyedMutexAcquireReleaseInfoKHR& safe_VkWin32KeyedMutexAcquireReleaseInfoKHR::operator=(const safe_VkWin32KeyedMutexAcquireReleaseInfoKHR& src)
{
    if (&src == this) return *this;

    if (pAcquireSyncs)
        delete[] pAcquireSyncs;
    if (pAcquireKeys)
        delete[] pAcquireKeys;
    if (pAcquireTimeouts)
        delete[] pAcquireTimeouts;
    if (pReleaseSyncs)
        delete[] pReleaseSyncs;
    if (pReleaseKeys)
        delete[] pReleaseKeys;
    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    acquireCount = src.acquireCount;
    pAcquireSyncs = nullptr;
    pAcquireKeys = nullptr;
    pAcquireTimeouts = nullptr;
    releaseCount = src.releaseCount;
    pReleaseSyncs = nullptr;
    pReleaseKeys = nullptr;
    pNext = SafePnextCopy(src.pNext);
    if (acquireCount && src.pAcquireSyncs) {
        pAcquireSyncs = new VkDeviceMemory[acquireCount];
        for (uint32_t i = 0; i < acquireCount; ++i) {
            pAcquireSyncs[i] = src.pAcquireSyncs[i];
        }
    }
    if (src.pAcquireKeys) {
        pAcquireKeys = new uint64_t[src.acquireCount];
        memcpy ((void *)pAcquireKeys, (void *)src.pAcquireKeys, sizeof(uint64_t)*src.acquireCount);
    }
    if (src.pAcquireTimeouts) {
        pAcquireTimeouts = new uint32_t[src.acquireCount];
        memcpy ((void *)pAcquireTimeouts, (void *)src.pAcquireTimeouts, sizeof(uint32_t)*src.acquireCount);
    }
    if (releaseCount && src.pReleaseSyncs) {
        pReleaseSyncs = new VkDeviceMemory[releaseCount];
        for (uint32_t i = 0; i < releaseCount; ++i) {
            pReleaseSyncs[i] = src.pReleaseSyncs[i];
        }
    }
    if (src.pReleaseKeys) {
        pReleaseKeys = new uint64_t[src.releaseCount];
        memcpy ((void *)pReleaseKeys, (void *)src.pReleaseKeys, sizeof(uint64_t)*src.releaseCount);
    }

    return *this;
}

safe_VkWin32KeyedMutexAcquireReleaseInfoKHR::~safe_VkWin32KeyedMutexAcquireReleaseInfoKHR()
{
    if (pAcquireSyncs)
        delete[] pAcquireSyncs;
    if (pAcquireKeys)
        delete[] pAcquireKeys;
    if (pAcquireTimeouts)
        delete[] pAcquireTimeouts;
    if (pReleaseSyncs)
        delete[] pReleaseSyncs;
    if (pReleaseKeys)
        delete[] pReleaseKeys;
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkWin32KeyedMutexAcquireReleaseInfoKHR::initialize(const VkWin32KeyedMutexAcquireReleaseInfoKHR* in_struct)
{
    sType = in_struct->sType;
    acquireCount = in_struct->acquireCount;
    pAcquireSyncs = nullptr;
    pAcquireKeys = nullptr;
    pAcquireTimeouts = nullptr;
    releaseCount = in_struct->releaseCount;
    pReleaseSyncs = nullptr;
    pReleaseKeys = nullptr;
    pNext = SafePnextCopy(in_struct->pNext);
    if (acquireCount && in_struct->pAcquireSyncs) {
        pAcquireSyncs = new VkDeviceMemory[acquireCount];
        for (uint32_t i = 0; i < acquireCount; ++i) {
            pAcquireSyncs[i] = in_struct->pAcquireSyncs[i];
        }
    }
    if (in_struct->pAcquireKeys) {
        pAcquireKeys = new uint64_t[in_struct->acquireCount];
        memcpy ((void *)pAcquireKeys, (void *)in_struct->pAcquireKeys, sizeof(uint64_t)*in_struct->acquireCount);
    }
    if (in_struct->pAcquireTimeouts) {
        pAcquireTimeouts = new uint32_t[in_struct->acquireCount];
        memcpy ((void *)pAcquireTimeouts, (void *)in_struct->pAcquireTimeouts, sizeof(uint32_t)*in_struct->acquireCount);
    }
    if (releaseCount && in_struct->pReleaseSyncs) {
        pReleaseSyncs = new VkDeviceMemory[releaseCount];
        for (uint32_t i = 0; i < releaseCount; ++i) {
            pReleaseSyncs[i] = in_struct->pReleaseSyncs[i];
        }
    }
    if (in_struct->pReleaseKeys) {
        pReleaseKeys = new uint64_t[in_struct->releaseCount];
        memcpy ((void *)pReleaseKeys, (void *)in_struct->pReleaseKeys, sizeof(uint64_t)*in_struct->releaseCount);
    }
}

void safe_VkWin32KeyedMutexAcquireReleaseInfoKHR::initialize(const safe_VkWin32KeyedMutexAcquireReleaseInfoKHR* src)
{
    sType = src->sType;
    acquireCount = src->acquireCount;
    pAcquireSyncs = nullptr;
    pAcquireKeys = nullptr;
    pAcquireTimeouts = nullptr;
    releaseCount = src->releaseCount;
    pReleaseSyncs = nullptr;
    pReleaseKeys = nullptr;
    pNext = SafePnextCopy(src->pNext);
    if (acquireCount && src->pAcquireSyncs) {
        pAcquireSyncs = new VkDeviceMemory[acquireCount];
        for (uint32_t i = 0; i < acquireCount; ++i) {
            pAcquireSyncs[i] = src->pAcquireSyncs[i];
        }
    }
    if (src->pAcquireKeys) {
        pAcquireKeys = new uint64_t[src->acquireCount];
        memcpy ((void *)pAcquireKeys, (void *)src->pAcquireKeys, sizeof(uint64_t)*src->acquireCount);
    }
    if (src->pAcquireTimeouts) {
        pAcquireTimeouts = new uint32_t[src->acquireCount];
        memcpy ((void *)pAcquireTimeouts, (void *)src->pAcquireTimeouts, sizeof(uint32_t)*src->acquireCount);
    }
    if (releaseCount && src->pReleaseSyncs) {
        pReleaseSyncs = new VkDeviceMemory[releaseCount];
        for (uint32_t i = 0; i < releaseCount; ++i) {
            pReleaseSyncs[i] = src->pReleaseSyncs[i];
        }
    }
    if (src->pReleaseKeys) {
        pReleaseKeys = new uint64_t[src->releaseCount];
        memcpy ((void *)pReleaseKeys, (void *)src->pReleaseKeys, sizeof(uint64_t)*src->releaseCount);
    }
}
#endif // VK_USE_PLATFORM_WIN32_KHR

#ifdef VK_USE_PLATFORM_WIN32_KHR


safe_VkImportSemaphoreWin32HandleInfoKHR::safe_VkImportSemaphoreWin32HandleInfoKHR(const VkImportSemaphoreWin32HandleInfoKHR* in_struct) :
    sType(in_struct->sType),
    semaphore(in_struct->semaphore),
    flags(in_struct->flags),
    handleType(in_struct->handleType),
    handle(in_struct->handle),
    name(in_struct->name)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkImportSemaphoreWin32HandleInfoKHR::safe_VkImportSemaphoreWin32HandleInfoKHR() :
    pNext(nullptr)
{}

safe_VkImportSemaphoreWin32HandleInfoKHR::safe_VkImportSemaphoreWin32HandleInfoKHR(const safe_VkImportSemaphoreWin32HandleInfoKHR& src)
{
    sType = src.sType;
    semaphore = src.semaphore;
    flags = src.flags;
    handleType = src.handleType;
    handle = src.handle;
    name = src.name;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkImportSemaphoreWin32HandleInfoKHR& safe_VkImportSemaphoreWin32HandleInfoKHR::operator=(const safe_VkImportSemaphoreWin32HandleInfoKHR& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    semaphore = src.semaphore;
    flags = src.flags;
    handleType = src.handleType;
    handle = src.handle;
    name = src.name;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkImportSemaphoreWin32HandleInfoKHR::~safe_VkImportSemaphoreWin32HandleInfoKHR()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkImportSemaphoreWin32HandleInfoKHR::initialize(const VkImportSemaphoreWin32HandleInfoKHR* in_struct)
{
    sType = in_struct->sType;
    semaphore = in_struct->semaphore;
    flags = in_struct->flags;
    handleType = in_struct->handleType;
    handle = in_struct->handle;
    name = in_struct->name;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkImportSemaphoreWin32HandleInfoKHR::initialize(const safe_VkImportSemaphoreWin32HandleInfoKHR* src)
{
    sType = src->sType;
    semaphore = src->semaphore;
    flags = src->flags;
    handleType = src->handleType;
    handle = src->handle;
    name = src->name;
    pNext = SafePnextCopy(src->pNext);
}
#endif // VK_USE_PLATFORM_WIN32_KHR

#ifdef VK_USE_PLATFORM_WIN32_KHR


safe_VkExportSemaphoreWin32HandleInfoKHR::safe_VkExportSemaphoreWin32HandleInfoKHR(const VkExportSemaphoreWin32HandleInfoKHR* in_struct) :
    sType(in_struct->sType),
    pAttributes(nullptr),
    dwAccess(in_struct->dwAccess),
    name(in_struct->name)
{
    pNext = SafePnextCopy(in_struct->pNext);
    if (in_struct->pAttributes) {
        pAttributes = new SECURITY_ATTRIBUTES(*in_struct->pAttributes);
    }
}

safe_VkExportSemaphoreWin32HandleInfoKHR::safe_VkExportSemaphoreWin32HandleInfoKHR() :
    pNext(nullptr),
    pAttributes(nullptr)
{}

safe_VkExportSemaphoreWin32HandleInfoKHR::safe_VkExportSemaphoreWin32HandleInfoKHR(const safe_VkExportSemaphoreWin32HandleInfoKHR& src)
{
    sType = src.sType;
    pAttributes = nullptr;
    dwAccess = src.dwAccess;
    name = src.name;
    pNext = SafePnextCopy(src.pNext);
    if (src.pAttributes) {
        pAttributes = new SECURITY_ATTRIBUTES(*src.pAttributes);
    }
}

safe_VkExportSemaphoreWin32HandleInfoKHR& safe_VkExportSemaphoreWin32HandleInfoKHR::operator=(const safe_VkExportSemaphoreWin32HandleInfoKHR& src)
{
    if (&src == this) return *this;

    if (pAttributes)
        delete pAttributes;
    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    pAttributes = nullptr;
    dwAccess = src.dwAccess;
    name = src.name;
    pNext = SafePnextCopy(src.pNext);
    if (src.pAttributes) {
        pAttributes = new SECURITY_ATTRIBUTES(*src.pAttributes);
    }

    return *this;
}

safe_VkExportSemaphoreWin32HandleInfoKHR::~safe_VkExportSemaphoreWin32HandleInfoKHR()
{
    if (pAttributes)
        delete pAttributes;
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkExportSemaphoreWin32HandleInfoKHR::initialize(const VkExportSemaphoreWin32HandleInfoKHR* in_struct)
{
    sType = in_struct->sType;
    pAttributes = nullptr;
    dwAccess = in_struct->dwAccess;
    name = in_struct->name;
    pNext = SafePnextCopy(in_struct->pNext);
    if (in_struct->pAttributes) {
        pAttributes = new SECURITY_ATTRIBUTES(*in_struct->pAttributes);
    }
}

void safe_VkExportSemaphoreWin32HandleInfoKHR::initialize(const safe_VkExportSemaphoreWin32HandleInfoKHR* src)
{
    sType = src->sType;
    pAttributes = nullptr;
    dwAccess = src->dwAccess;
    name = src->name;
    pNext = SafePnextCopy(src->pNext);
    if (src->pAttributes) {
        pAttributes = new SECURITY_ATTRIBUTES(*src->pAttributes);
    }
}
#endif // VK_USE_PLATFORM_WIN32_KHR

#ifdef VK_USE_PLATFORM_WIN32_KHR


safe_VkD3D12FenceSubmitInfoKHR::safe_VkD3D12FenceSubmitInfoKHR(const VkD3D12FenceSubmitInfoKHR* in_struct) :
    sType(in_struct->sType),
    waitSemaphoreValuesCount(in_struct->waitSemaphoreValuesCount),
    pWaitSemaphoreValues(nullptr),
    signalSemaphoreValuesCount(in_struct->signalSemaphoreValuesCount),
    pSignalSemaphoreValues(nullptr)
{
    pNext = SafePnextCopy(in_struct->pNext);
    if (in_struct->pWaitSemaphoreValues) {
        pWaitSemaphoreValues = new uint64_t[in_struct->waitSemaphoreValuesCount];
        memcpy ((void *)pWaitSemaphoreValues, (void *)in_struct->pWaitSemaphoreValues, sizeof(uint64_t)*in_struct->waitSemaphoreValuesCount);
    }
    if (in_struct->pSignalSemaphoreValues) {
        pSignalSemaphoreValues = new uint64_t[in_struct->signalSemaphoreValuesCount];
        memcpy ((void *)pSignalSemaphoreValues, (void *)in_struct->pSignalSemaphoreValues, sizeof(uint64_t)*in_struct->signalSemaphoreValuesCount);
    }
}

safe_VkD3D12FenceSubmitInfoKHR::safe_VkD3D12FenceSubmitInfoKHR() :
    pNext(nullptr),
    pWaitSemaphoreValues(nullptr),
    pSignalSemaphoreValues(nullptr)
{}

safe_VkD3D12FenceSubmitInfoKHR::safe_VkD3D12FenceSubmitInfoKHR(const safe_VkD3D12FenceSubmitInfoKHR& src)
{
    sType = src.sType;
    waitSemaphoreValuesCount = src.waitSemaphoreValuesCount;
    pWaitSemaphoreValues = nullptr;
    signalSemaphoreValuesCount = src.signalSemaphoreValuesCount;
    pSignalSemaphoreValues = nullptr;
    pNext = SafePnextCopy(src.pNext);
    if (src.pWaitSemaphoreValues) {
        pWaitSemaphoreValues = new uint64_t[src.waitSemaphoreValuesCount];
        memcpy ((void *)pWaitSemaphoreValues, (void *)src.pWaitSemaphoreValues, sizeof(uint64_t)*src.waitSemaphoreValuesCount);
    }
    if (src.pSignalSemaphoreValues) {
        pSignalSemaphoreValues = new uint64_t[src.signalSemaphoreValuesCount];
        memcpy ((void *)pSignalSemaphoreValues, (void *)src.pSignalSemaphoreValues, sizeof(uint64_t)*src.signalSemaphoreValuesCount);
    }
}

safe_VkD3D12FenceSubmitInfoKHR& safe_VkD3D12FenceSubmitInfoKHR::operator=(const safe_VkD3D12FenceSubmitInfoKHR& src)
{
    if (&src == this) return *this;

    if (pWaitSemaphoreValues)
        delete[] pWaitSemaphoreValues;
    if (pSignalSemaphoreValues)
        delete[] pSignalSemaphoreValues;
    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    waitSemaphoreValuesCount = src.waitSemaphoreValuesCount;
    pWaitSemaphoreValues = nullptr;
    signalSemaphoreValuesCount = src.signalSemaphoreValuesCount;
    pSignalSemaphoreValues = nullptr;
    pNext = SafePnextCopy(src.pNext);
    if (src.pWaitSemaphoreValues) {
        pWaitSemaphoreValues = new uint64_t[src.waitSemaphoreValuesCount];
        memcpy ((void *)pWaitSemaphoreValues, (void *)src.pWaitSemaphoreValues, sizeof(uint64_t)*src.waitSemaphoreValuesCount);
    }
    if (src.pSignalSemaphoreValues) {
        pSignalSemaphoreValues = new uint64_t[src.signalSemaphoreValuesCount];
        memcpy ((void *)pSignalSemaphoreValues, (void *)src.pSignalSemaphoreValues, sizeof(uint64_t)*src.signalSemaphoreValuesCount);
    }

    return *this;
}

safe_VkD3D12FenceSubmitInfoKHR::~safe_VkD3D12FenceSubmitInfoKHR()
{
    if (pWaitSemaphoreValues)
        delete[] pWaitSemaphoreValues;
    if (pSignalSemaphoreValues)
        delete[] pSignalSemaphoreValues;
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkD3D12FenceSubmitInfoKHR::initialize(const VkD3D12FenceSubmitInfoKHR* in_struct)
{
    sType = in_struct->sType;
    waitSemaphoreValuesCount = in_struct->waitSemaphoreValuesCount;
    pWaitSemaphoreValues = nullptr;
    signalSemaphoreValuesCount = in_struct->signalSemaphoreValuesCount;
    pSignalSemaphoreValues = nullptr;
    pNext = SafePnextCopy(in_struct->pNext);
    if (in_struct->pWaitSemaphoreValues) {
        pWaitSemaphoreValues = new uint64_t[in_struct->waitSemaphoreValuesCount];
        memcpy ((void *)pWaitSemaphoreValues, (void *)in_struct->pWaitSemaphoreValues, sizeof(uint64_t)*in_struct->waitSemaphoreValuesCount);
    }
    if (in_struct->pSignalSemaphoreValues) {
        pSignalSemaphoreValues = new uint64_t[in_struct->signalSemaphoreValuesCount];
        memcpy ((void *)pSignalSemaphoreValues, (void *)in_struct->pSignalSemaphoreValues, sizeof(uint64_t)*in_struct->signalSemaphoreValuesCount);
    }
}

void safe_VkD3D12FenceSubmitInfoKHR::initialize(const safe_VkD3D12FenceSubmitInfoKHR* src)
{
    sType = src->sType;
    waitSemaphoreValuesCount = src->waitSemaphoreValuesCount;
    pWaitSemaphoreValues = nullptr;
    signalSemaphoreValuesCount = src->signalSemaphoreValuesCount;
    pSignalSemaphoreValues = nullptr;
    pNext = SafePnextCopy(src->pNext);
    if (src->pWaitSemaphoreValues) {
        pWaitSemaphoreValues = new uint64_t[src->waitSemaphoreValuesCount];
        memcpy ((void *)pWaitSemaphoreValues, (void *)src->pWaitSemaphoreValues, sizeof(uint64_t)*src->waitSemaphoreValuesCount);
    }
    if (src->pSignalSemaphoreValues) {
        pSignalSemaphoreValues = new uint64_t[src->signalSemaphoreValuesCount];
        memcpy ((void *)pSignalSemaphoreValues, (void *)src->pSignalSemaphoreValues, sizeof(uint64_t)*src->signalSemaphoreValuesCount);
    }
}
#endif // VK_USE_PLATFORM_WIN32_KHR

#ifdef VK_USE_PLATFORM_WIN32_KHR


safe_VkSemaphoreGetWin32HandleInfoKHR::safe_VkSemaphoreGetWin32HandleInfoKHR(const VkSemaphoreGetWin32HandleInfoKHR* in_struct) :
    sType(in_struct->sType),
    semaphore(in_struct->semaphore),
    handleType(in_struct->handleType)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkSemaphoreGetWin32HandleInfoKHR::safe_VkSemaphoreGetWin32HandleInfoKHR() :
    pNext(nullptr)
{}

safe_VkSemaphoreGetWin32HandleInfoKHR::safe_VkSemaphoreGetWin32HandleInfoKHR(const safe_VkSemaphoreGetWin32HandleInfoKHR& src)
{
    sType = src.sType;
    semaphore = src.semaphore;
    handleType = src.handleType;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkSemaphoreGetWin32HandleInfoKHR& safe_VkSemaphoreGetWin32HandleInfoKHR::operator=(const safe_VkSemaphoreGetWin32HandleInfoKHR& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    semaphore = src.semaphore;
    handleType = src.handleType;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkSemaphoreGetWin32HandleInfoKHR::~safe_VkSemaphoreGetWin32HandleInfoKHR()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkSemaphoreGetWin32HandleInfoKHR::initialize(const VkSemaphoreGetWin32HandleInfoKHR* in_struct)
{
    sType = in_struct->sType;
    semaphore = in_struct->semaphore;
    handleType = in_struct->handleType;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkSemaphoreGetWin32HandleInfoKHR::initialize(const safe_VkSemaphoreGetWin32HandleInfoKHR* src)
{
    sType = src->sType;
    semaphore = src->semaphore;
    handleType = src->handleType;
    pNext = SafePnextCopy(src->pNext);
}
#endif // VK_USE_PLATFORM_WIN32_KHR


safe_VkImportSemaphoreFdInfoKHR::safe_VkImportSemaphoreFdInfoKHR(const VkImportSemaphoreFdInfoKHR* in_struct) :
    sType(in_struct->sType),
    semaphore(in_struct->semaphore),
    flags(in_struct->flags),
    handleType(in_struct->handleType),
    fd(in_struct->fd)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkImportSemaphoreFdInfoKHR::safe_VkImportSemaphoreFdInfoKHR() :
    pNext(nullptr)
{}

safe_VkImportSemaphoreFdInfoKHR::safe_VkImportSemaphoreFdInfoKHR(const safe_VkImportSemaphoreFdInfoKHR& src)
{
    sType = src.sType;
    semaphore = src.semaphore;
    flags = src.flags;
    handleType = src.handleType;
    fd = src.fd;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkImportSemaphoreFdInfoKHR& safe_VkImportSemaphoreFdInfoKHR::operator=(const safe_VkImportSemaphoreFdInfoKHR& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    semaphore = src.semaphore;
    flags = src.flags;
    handleType = src.handleType;
    fd = src.fd;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkImportSemaphoreFdInfoKHR::~safe_VkImportSemaphoreFdInfoKHR()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkImportSemaphoreFdInfoKHR::initialize(const VkImportSemaphoreFdInfoKHR* in_struct)
{
    sType = in_struct->sType;
    semaphore = in_struct->semaphore;
    flags = in_struct->flags;
    handleType = in_struct->handleType;
    fd = in_struct->fd;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkImportSemaphoreFdInfoKHR::initialize(const safe_VkImportSemaphoreFdInfoKHR* src)
{
    sType = src->sType;
    semaphore = src->semaphore;
    flags = src->flags;
    handleType = src->handleType;
    fd = src->fd;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkSemaphoreGetFdInfoKHR::safe_VkSemaphoreGetFdInfoKHR(const VkSemaphoreGetFdInfoKHR* in_struct) :
    sType(in_struct->sType),
    semaphore(in_struct->semaphore),
    handleType(in_struct->handleType)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkSemaphoreGetFdInfoKHR::safe_VkSemaphoreGetFdInfoKHR() :
    pNext(nullptr)
{}

safe_VkSemaphoreGetFdInfoKHR::safe_VkSemaphoreGetFdInfoKHR(const safe_VkSemaphoreGetFdInfoKHR& src)
{
    sType = src.sType;
    semaphore = src.semaphore;
    handleType = src.handleType;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkSemaphoreGetFdInfoKHR& safe_VkSemaphoreGetFdInfoKHR::operator=(const safe_VkSemaphoreGetFdInfoKHR& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    semaphore = src.semaphore;
    handleType = src.handleType;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkSemaphoreGetFdInfoKHR::~safe_VkSemaphoreGetFdInfoKHR()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkSemaphoreGetFdInfoKHR::initialize(const VkSemaphoreGetFdInfoKHR* in_struct)
{
    sType = in_struct->sType;
    semaphore = in_struct->semaphore;
    handleType = in_struct->handleType;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkSemaphoreGetFdInfoKHR::initialize(const safe_VkSemaphoreGetFdInfoKHR* src)
{
    sType = src->sType;
    semaphore = src->semaphore;
    handleType = src->handleType;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkPhysicalDevicePushDescriptorPropertiesKHR::safe_VkPhysicalDevicePushDescriptorPropertiesKHR(const VkPhysicalDevicePushDescriptorPropertiesKHR* in_struct) :
    sType(in_struct->sType),
    maxPushDescriptors(in_struct->maxPushDescriptors)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkPhysicalDevicePushDescriptorPropertiesKHR::safe_VkPhysicalDevicePushDescriptorPropertiesKHR() :
    pNext(nullptr)
{}

safe_VkPhysicalDevicePushDescriptorPropertiesKHR::safe_VkPhysicalDevicePushDescriptorPropertiesKHR(const safe_VkPhysicalDevicePushDescriptorPropertiesKHR& src)
{
    sType = src.sType;
    maxPushDescriptors = src.maxPushDescriptors;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkPhysicalDevicePushDescriptorPropertiesKHR& safe_VkPhysicalDevicePushDescriptorPropertiesKHR::operator=(const safe_VkPhysicalDevicePushDescriptorPropertiesKHR& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    maxPushDescriptors = src.maxPushDescriptors;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkPhysicalDevicePushDescriptorPropertiesKHR::~safe_VkPhysicalDevicePushDescriptorPropertiesKHR()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPhysicalDevicePushDescriptorPropertiesKHR::initialize(const VkPhysicalDevicePushDescriptorPropertiesKHR* in_struct)
{
    sType = in_struct->sType;
    maxPushDescriptors = in_struct->maxPushDescriptors;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkPhysicalDevicePushDescriptorPropertiesKHR::initialize(const safe_VkPhysicalDevicePushDescriptorPropertiesKHR* src)
{
    sType = src->sType;
    maxPushDescriptors = src->maxPushDescriptors;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkPhysicalDeviceShaderFloat16Int8FeaturesKHR::safe_VkPhysicalDeviceShaderFloat16Int8FeaturesKHR(const VkPhysicalDeviceShaderFloat16Int8FeaturesKHR* in_struct) :
    sType(in_struct->sType),
    shaderFloat16(in_struct->shaderFloat16),
    shaderInt8(in_struct->shaderInt8)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkPhysicalDeviceShaderFloat16Int8FeaturesKHR::safe_VkPhysicalDeviceShaderFloat16Int8FeaturesKHR() :
    pNext(nullptr)
{}

safe_VkPhysicalDeviceShaderFloat16Int8FeaturesKHR::safe_VkPhysicalDeviceShaderFloat16Int8FeaturesKHR(const safe_VkPhysicalDeviceShaderFloat16Int8FeaturesKHR& src)
{
    sType = src.sType;
    shaderFloat16 = src.shaderFloat16;
    shaderInt8 = src.shaderInt8;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkPhysicalDeviceShaderFloat16Int8FeaturesKHR& safe_VkPhysicalDeviceShaderFloat16Int8FeaturesKHR::operator=(const safe_VkPhysicalDeviceShaderFloat16Int8FeaturesKHR& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    shaderFloat16 = src.shaderFloat16;
    shaderInt8 = src.shaderInt8;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkPhysicalDeviceShaderFloat16Int8FeaturesKHR::~safe_VkPhysicalDeviceShaderFloat16Int8FeaturesKHR()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPhysicalDeviceShaderFloat16Int8FeaturesKHR::initialize(const VkPhysicalDeviceShaderFloat16Int8FeaturesKHR* in_struct)
{
    sType = in_struct->sType;
    shaderFloat16 = in_struct->shaderFloat16;
    shaderInt8 = in_struct->shaderInt8;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkPhysicalDeviceShaderFloat16Int8FeaturesKHR::initialize(const safe_VkPhysicalDeviceShaderFloat16Int8FeaturesKHR* src)
{
    sType = src->sType;
    shaderFloat16 = src->shaderFloat16;
    shaderInt8 = src->shaderInt8;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkPresentRegionKHR::safe_VkPresentRegionKHR(const VkPresentRegionKHR* in_struct) :
    rectangleCount(in_struct->rectangleCount),
    pRectangles(nullptr)
{
    if (in_struct->pRectangles) {
        pRectangles = new VkRectLayerKHR[in_struct->rectangleCount];
        memcpy ((void *)pRectangles, (void *)in_struct->pRectangles, sizeof(VkRectLayerKHR)*in_struct->rectangleCount);
    }
}

safe_VkPresentRegionKHR::safe_VkPresentRegionKHR() :
    pRectangles(nullptr)
{}

safe_VkPresentRegionKHR::safe_VkPresentRegionKHR(const safe_VkPresentRegionKHR& src)
{
    rectangleCount = src.rectangleCount;
    pRectangles = nullptr;
    if (src.pRectangles) {
        pRectangles = new VkRectLayerKHR[src.rectangleCount];
        memcpy ((void *)pRectangles, (void *)src.pRectangles, sizeof(VkRectLayerKHR)*src.rectangleCount);
    }
}

safe_VkPresentRegionKHR& safe_VkPresentRegionKHR::operator=(const safe_VkPresentRegionKHR& src)
{
    if (&src == this) return *this;

    if (pRectangles)
        delete[] pRectangles;

    rectangleCount = src.rectangleCount;
    pRectangles = nullptr;
    if (src.pRectangles) {
        pRectangles = new VkRectLayerKHR[src.rectangleCount];
        memcpy ((void *)pRectangles, (void *)src.pRectangles, sizeof(VkRectLayerKHR)*src.rectangleCount);
    }

    return *this;
}

safe_VkPresentRegionKHR::~safe_VkPresentRegionKHR()
{
    if (pRectangles)
        delete[] pRectangles;
}

void safe_VkPresentRegionKHR::initialize(const VkPresentRegionKHR* in_struct)
{
    rectangleCount = in_struct->rectangleCount;
    pRectangles = nullptr;
    if (in_struct->pRectangles) {
        pRectangles = new VkRectLayerKHR[in_struct->rectangleCount];
        memcpy ((void *)pRectangles, (void *)in_struct->pRectangles, sizeof(VkRectLayerKHR)*in_struct->rectangleCount);
    }
}

void safe_VkPresentRegionKHR::initialize(const safe_VkPresentRegionKHR* src)
{
    rectangleCount = src->rectangleCount;
    pRectangles = nullptr;
    if (src->pRectangles) {
        pRectangles = new VkRectLayerKHR[src->rectangleCount];
        memcpy ((void *)pRectangles, (void *)src->pRectangles, sizeof(VkRectLayerKHR)*src->rectangleCount);
    }
}

safe_VkPresentRegionsKHR::safe_VkPresentRegionsKHR(const VkPresentRegionsKHR* in_struct) :
    sType(in_struct->sType),
    swapchainCount(in_struct->swapchainCount),
    pRegions(nullptr)
{
    pNext = SafePnextCopy(in_struct->pNext);
    if (swapchainCount && in_struct->pRegions) {
        pRegions = new safe_VkPresentRegionKHR[swapchainCount];
        for (uint32_t i = 0; i < swapchainCount; ++i) {
            pRegions[i].initialize(&in_struct->pRegions[i]);
        }
    }
}

safe_VkPresentRegionsKHR::safe_VkPresentRegionsKHR() :
    pNext(nullptr),
    pRegions(nullptr)
{}

safe_VkPresentRegionsKHR::safe_VkPresentRegionsKHR(const safe_VkPresentRegionsKHR& src)
{
    sType = src.sType;
    swapchainCount = src.swapchainCount;
    pRegions = nullptr;
    pNext = SafePnextCopy(src.pNext);
    if (swapchainCount && src.pRegions) {
        pRegions = new safe_VkPresentRegionKHR[swapchainCount];
        for (uint32_t i = 0; i < swapchainCount; ++i) {
            pRegions[i].initialize(&src.pRegions[i]);
        }
    }
}

safe_VkPresentRegionsKHR& safe_VkPresentRegionsKHR::operator=(const safe_VkPresentRegionsKHR& src)
{
    if (&src == this) return *this;

    if (pRegions)
        delete[] pRegions;
    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    swapchainCount = src.swapchainCount;
    pRegions = nullptr;
    pNext = SafePnextCopy(src.pNext);
    if (swapchainCount && src.pRegions) {
        pRegions = new safe_VkPresentRegionKHR[swapchainCount];
        for (uint32_t i = 0; i < swapchainCount; ++i) {
            pRegions[i].initialize(&src.pRegions[i]);
        }
    }

    return *this;
}

safe_VkPresentRegionsKHR::~safe_VkPresentRegionsKHR()
{
    if (pRegions)
        delete[] pRegions;
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPresentRegionsKHR::initialize(const VkPresentRegionsKHR* in_struct)
{
    sType = in_struct->sType;
    swapchainCount = in_struct->swapchainCount;
    pRegions = nullptr;
    pNext = SafePnextCopy(in_struct->pNext);
    if (swapchainCount && in_struct->pRegions) {
        pRegions = new safe_VkPresentRegionKHR[swapchainCount];
        for (uint32_t i = 0; i < swapchainCount; ++i) {
            pRegions[i].initialize(&in_struct->pRegions[i]);
        }
    }
}

void safe_VkPresentRegionsKHR::initialize(const safe_VkPresentRegionsKHR* src)
{
    sType = src->sType;
    swapchainCount = src->swapchainCount;
    pRegions = nullptr;
    pNext = SafePnextCopy(src->pNext);
    if (swapchainCount && src->pRegions) {
        pRegions = new safe_VkPresentRegionKHR[swapchainCount];
        for (uint32_t i = 0; i < swapchainCount; ++i) {
            pRegions[i].initialize(&src->pRegions[i]);
        }
    }
}

safe_VkPhysicalDeviceImagelessFramebufferFeaturesKHR::safe_VkPhysicalDeviceImagelessFramebufferFeaturesKHR(const VkPhysicalDeviceImagelessFramebufferFeaturesKHR* in_struct) :
    sType(in_struct->sType),
    imagelessFramebuffer(in_struct->imagelessFramebuffer)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkPhysicalDeviceImagelessFramebufferFeaturesKHR::safe_VkPhysicalDeviceImagelessFramebufferFeaturesKHR() :
    pNext(nullptr)
{}

safe_VkPhysicalDeviceImagelessFramebufferFeaturesKHR::safe_VkPhysicalDeviceImagelessFramebufferFeaturesKHR(const safe_VkPhysicalDeviceImagelessFramebufferFeaturesKHR& src)
{
    sType = src.sType;
    imagelessFramebuffer = src.imagelessFramebuffer;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkPhysicalDeviceImagelessFramebufferFeaturesKHR& safe_VkPhysicalDeviceImagelessFramebufferFeaturesKHR::operator=(const safe_VkPhysicalDeviceImagelessFramebufferFeaturesKHR& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    imagelessFramebuffer = src.imagelessFramebuffer;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkPhysicalDeviceImagelessFramebufferFeaturesKHR::~safe_VkPhysicalDeviceImagelessFramebufferFeaturesKHR()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPhysicalDeviceImagelessFramebufferFeaturesKHR::initialize(const VkPhysicalDeviceImagelessFramebufferFeaturesKHR* in_struct)
{
    sType = in_struct->sType;
    imagelessFramebuffer = in_struct->imagelessFramebuffer;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkPhysicalDeviceImagelessFramebufferFeaturesKHR::initialize(const safe_VkPhysicalDeviceImagelessFramebufferFeaturesKHR* src)
{
    sType = src->sType;
    imagelessFramebuffer = src->imagelessFramebuffer;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkFramebufferAttachmentImageInfoKHR::safe_VkFramebufferAttachmentImageInfoKHR(const VkFramebufferAttachmentImageInfoKHR* in_struct) :
    sType(in_struct->sType),
    flags(in_struct->flags),
    usage(in_struct->usage),
    width(in_struct->width),
    height(in_struct->height),
    layerCount(in_struct->layerCount),
    viewFormatCount(in_struct->viewFormatCount),
    pViewFormats(nullptr)
{
    pNext = SafePnextCopy(in_struct->pNext);
    if (in_struct->pViewFormats) {
        pViewFormats = new VkFormat[in_struct->viewFormatCount];
        memcpy ((void *)pViewFormats, (void *)in_struct->pViewFormats, sizeof(VkFormat)*in_struct->viewFormatCount);
    }
}

safe_VkFramebufferAttachmentImageInfoKHR::safe_VkFramebufferAttachmentImageInfoKHR() :
    pNext(nullptr),
    pViewFormats(nullptr)
{}

safe_VkFramebufferAttachmentImageInfoKHR::safe_VkFramebufferAttachmentImageInfoKHR(const safe_VkFramebufferAttachmentImageInfoKHR& src)
{
    sType = src.sType;
    flags = src.flags;
    usage = src.usage;
    width = src.width;
    height = src.height;
    layerCount = src.layerCount;
    viewFormatCount = src.viewFormatCount;
    pViewFormats = nullptr;
    pNext = SafePnextCopy(src.pNext);
    if (src.pViewFormats) {
        pViewFormats = new VkFormat[src.viewFormatCount];
        memcpy ((void *)pViewFormats, (void *)src.pViewFormats, sizeof(VkFormat)*src.viewFormatCount);
    }
}

safe_VkFramebufferAttachmentImageInfoKHR& safe_VkFramebufferAttachmentImageInfoKHR::operator=(const safe_VkFramebufferAttachmentImageInfoKHR& src)
{
    if (&src == this) return *this;

    if (pViewFormats)
        delete[] pViewFormats;
    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    flags = src.flags;
    usage = src.usage;
    width = src.width;
    height = src.height;
    layerCount = src.layerCount;
    viewFormatCount = src.viewFormatCount;
    pViewFormats = nullptr;
    pNext = SafePnextCopy(src.pNext);
    if (src.pViewFormats) {
        pViewFormats = new VkFormat[src.viewFormatCount];
        memcpy ((void *)pViewFormats, (void *)src.pViewFormats, sizeof(VkFormat)*src.viewFormatCount);
    }

    return *this;
}

safe_VkFramebufferAttachmentImageInfoKHR::~safe_VkFramebufferAttachmentImageInfoKHR()
{
    if (pViewFormats)
        delete[] pViewFormats;
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkFramebufferAttachmentImageInfoKHR::initialize(const VkFramebufferAttachmentImageInfoKHR* in_struct)
{
    sType = in_struct->sType;
    flags = in_struct->flags;
    usage = in_struct->usage;
    width = in_struct->width;
    height = in_struct->height;
    layerCount = in_struct->layerCount;
    viewFormatCount = in_struct->viewFormatCount;
    pViewFormats = nullptr;
    pNext = SafePnextCopy(in_struct->pNext);
    if (in_struct->pViewFormats) {
        pViewFormats = new VkFormat[in_struct->viewFormatCount];
        memcpy ((void *)pViewFormats, (void *)in_struct->pViewFormats, sizeof(VkFormat)*in_struct->viewFormatCount);
    }
}

void safe_VkFramebufferAttachmentImageInfoKHR::initialize(const safe_VkFramebufferAttachmentImageInfoKHR* src)
{
    sType = src->sType;
    flags = src->flags;
    usage = src->usage;
    width = src->width;
    height = src->height;
    layerCount = src->layerCount;
    viewFormatCount = src->viewFormatCount;
    pViewFormats = nullptr;
    pNext = SafePnextCopy(src->pNext);
    if (src->pViewFormats) {
        pViewFormats = new VkFormat[src->viewFormatCount];
        memcpy ((void *)pViewFormats, (void *)src->pViewFormats, sizeof(VkFormat)*src->viewFormatCount);
    }
}

safe_VkFramebufferAttachmentsCreateInfoKHR::safe_VkFramebufferAttachmentsCreateInfoKHR(const VkFramebufferAttachmentsCreateInfoKHR* in_struct) :
    sType(in_struct->sType),
    attachmentImageInfoCount(in_struct->attachmentImageInfoCount),
    pAttachmentImageInfos(nullptr)
{
    pNext = SafePnextCopy(in_struct->pNext);
    if (attachmentImageInfoCount && in_struct->pAttachmentImageInfos) {
        pAttachmentImageInfos = new safe_VkFramebufferAttachmentImageInfoKHR[attachmentImageInfoCount];
        for (uint32_t i = 0; i < attachmentImageInfoCount; ++i) {
            pAttachmentImageInfos[i].initialize(&in_struct->pAttachmentImageInfos[i]);
        }
    }
}

safe_VkFramebufferAttachmentsCreateInfoKHR::safe_VkFramebufferAttachmentsCreateInfoKHR() :
    pNext(nullptr),
    pAttachmentImageInfos(nullptr)
{}

safe_VkFramebufferAttachmentsCreateInfoKHR::safe_VkFramebufferAttachmentsCreateInfoKHR(const safe_VkFramebufferAttachmentsCreateInfoKHR& src)
{
    sType = src.sType;
    attachmentImageInfoCount = src.attachmentImageInfoCount;
    pAttachmentImageInfos = nullptr;
    pNext = SafePnextCopy(src.pNext);
    if (attachmentImageInfoCount && src.pAttachmentImageInfos) {
        pAttachmentImageInfos = new safe_VkFramebufferAttachmentImageInfoKHR[attachmentImageInfoCount];
        for (uint32_t i = 0; i < attachmentImageInfoCount; ++i) {
            pAttachmentImageInfos[i].initialize(&src.pAttachmentImageInfos[i]);
        }
    }
}

safe_VkFramebufferAttachmentsCreateInfoKHR& safe_VkFramebufferAttachmentsCreateInfoKHR::operator=(const safe_VkFramebufferAttachmentsCreateInfoKHR& src)
{
    if (&src == this) return *this;

    if (pAttachmentImageInfos)
        delete[] pAttachmentImageInfos;
    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    attachmentImageInfoCount = src.attachmentImageInfoCount;
    pAttachmentImageInfos = nullptr;
    pNext = SafePnextCopy(src.pNext);
    if (attachmentImageInfoCount && src.pAttachmentImageInfos) {
        pAttachmentImageInfos = new safe_VkFramebufferAttachmentImageInfoKHR[attachmentImageInfoCount];
        for (uint32_t i = 0; i < attachmentImageInfoCount; ++i) {
            pAttachmentImageInfos[i].initialize(&src.pAttachmentImageInfos[i]);
        }
    }

    return *this;
}

safe_VkFramebufferAttachmentsCreateInfoKHR::~safe_VkFramebufferAttachmentsCreateInfoKHR()
{
    if (pAttachmentImageInfos)
        delete[] pAttachmentImageInfos;
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkFramebufferAttachmentsCreateInfoKHR::initialize(const VkFramebufferAttachmentsCreateInfoKHR* in_struct)
{
    sType = in_struct->sType;
    attachmentImageInfoCount = in_struct->attachmentImageInfoCount;
    pAttachmentImageInfos = nullptr;
    pNext = SafePnextCopy(in_struct->pNext);
    if (attachmentImageInfoCount && in_struct->pAttachmentImageInfos) {
        pAttachmentImageInfos = new safe_VkFramebufferAttachmentImageInfoKHR[attachmentImageInfoCount];
        for (uint32_t i = 0; i < attachmentImageInfoCount; ++i) {
            pAttachmentImageInfos[i].initialize(&in_struct->pAttachmentImageInfos[i]);
        }
    }
}

void safe_VkFramebufferAttachmentsCreateInfoKHR::initialize(const safe_VkFramebufferAttachmentsCreateInfoKHR* src)
{
    sType = src->sType;
    attachmentImageInfoCount = src->attachmentImageInfoCount;
    pAttachmentImageInfos = nullptr;
    pNext = SafePnextCopy(src->pNext);
    if (attachmentImageInfoCount && src->pAttachmentImageInfos) {
        pAttachmentImageInfos = new safe_VkFramebufferAttachmentImageInfoKHR[attachmentImageInfoCount];
        for (uint32_t i = 0; i < attachmentImageInfoCount; ++i) {
            pAttachmentImageInfos[i].initialize(&src->pAttachmentImageInfos[i]);
        }
    }
}

safe_VkRenderPassAttachmentBeginInfoKHR::safe_VkRenderPassAttachmentBeginInfoKHR(const VkRenderPassAttachmentBeginInfoKHR* in_struct) :
    sType(in_struct->sType),
    attachmentCount(in_struct->attachmentCount),
    pAttachments(nullptr)
{
    pNext = SafePnextCopy(in_struct->pNext);
    if (attachmentCount && in_struct->pAttachments) {
        pAttachments = new VkImageView[attachmentCount];
        for (uint32_t i = 0; i < attachmentCount; ++i) {
            pAttachments[i] = in_struct->pAttachments[i];
        }
    }
}

safe_VkRenderPassAttachmentBeginInfoKHR::safe_VkRenderPassAttachmentBeginInfoKHR() :
    pNext(nullptr),
    pAttachments(nullptr)
{}

safe_VkRenderPassAttachmentBeginInfoKHR::safe_VkRenderPassAttachmentBeginInfoKHR(const safe_VkRenderPassAttachmentBeginInfoKHR& src)
{
    sType = src.sType;
    attachmentCount = src.attachmentCount;
    pAttachments = nullptr;
    pNext = SafePnextCopy(src.pNext);
    if (attachmentCount && src.pAttachments) {
        pAttachments = new VkImageView[attachmentCount];
        for (uint32_t i = 0; i < attachmentCount; ++i) {
            pAttachments[i] = src.pAttachments[i];
        }
    }
}

safe_VkRenderPassAttachmentBeginInfoKHR& safe_VkRenderPassAttachmentBeginInfoKHR::operator=(const safe_VkRenderPassAttachmentBeginInfoKHR& src)
{
    if (&src == this) return *this;

    if (pAttachments)
        delete[] pAttachments;
    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    attachmentCount = src.attachmentCount;
    pAttachments = nullptr;
    pNext = SafePnextCopy(src.pNext);
    if (attachmentCount && src.pAttachments) {
        pAttachments = new VkImageView[attachmentCount];
        for (uint32_t i = 0; i < attachmentCount; ++i) {
            pAttachments[i] = src.pAttachments[i];
        }
    }

    return *this;
}

safe_VkRenderPassAttachmentBeginInfoKHR::~safe_VkRenderPassAttachmentBeginInfoKHR()
{
    if (pAttachments)
        delete[] pAttachments;
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkRenderPassAttachmentBeginInfoKHR::initialize(const VkRenderPassAttachmentBeginInfoKHR* in_struct)
{
    sType = in_struct->sType;
    attachmentCount = in_struct->attachmentCount;
    pAttachments = nullptr;
    pNext = SafePnextCopy(in_struct->pNext);
    if (attachmentCount && in_struct->pAttachments) {
        pAttachments = new VkImageView[attachmentCount];
        for (uint32_t i = 0; i < attachmentCount; ++i) {
            pAttachments[i] = in_struct->pAttachments[i];
        }
    }
}

void safe_VkRenderPassAttachmentBeginInfoKHR::initialize(const safe_VkRenderPassAttachmentBeginInfoKHR* src)
{
    sType = src->sType;
    attachmentCount = src->attachmentCount;
    pAttachments = nullptr;
    pNext = SafePnextCopy(src->pNext);
    if (attachmentCount && src->pAttachments) {
        pAttachments = new VkImageView[attachmentCount];
        for (uint32_t i = 0; i < attachmentCount; ++i) {
            pAttachments[i] = src->pAttachments[i];
        }
    }
}

safe_VkAttachmentDescription2KHR::safe_VkAttachmentDescription2KHR(const VkAttachmentDescription2KHR* in_struct) :
    sType(in_struct->sType),
    flags(in_struct->flags),
    format(in_struct->format),
    samples(in_struct->samples),
    loadOp(in_struct->loadOp),
    storeOp(in_struct->storeOp),
    stencilLoadOp(in_struct->stencilLoadOp),
    stencilStoreOp(in_struct->stencilStoreOp),
    initialLayout(in_struct->initialLayout),
    finalLayout(in_struct->finalLayout)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkAttachmentDescription2KHR::safe_VkAttachmentDescription2KHR() :
    pNext(nullptr)
{}

safe_VkAttachmentDescription2KHR::safe_VkAttachmentDescription2KHR(const safe_VkAttachmentDescription2KHR& src)
{
    sType = src.sType;
    flags = src.flags;
    format = src.format;
    samples = src.samples;
    loadOp = src.loadOp;
    storeOp = src.storeOp;
    stencilLoadOp = src.stencilLoadOp;
    stencilStoreOp = src.stencilStoreOp;
    initialLayout = src.initialLayout;
    finalLayout = src.finalLayout;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkAttachmentDescription2KHR& safe_VkAttachmentDescription2KHR::operator=(const safe_VkAttachmentDescription2KHR& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    flags = src.flags;
    format = src.format;
    samples = src.samples;
    loadOp = src.loadOp;
    storeOp = src.storeOp;
    stencilLoadOp = src.stencilLoadOp;
    stencilStoreOp = src.stencilStoreOp;
    initialLayout = src.initialLayout;
    finalLayout = src.finalLayout;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkAttachmentDescription2KHR::~safe_VkAttachmentDescription2KHR()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkAttachmentDescription2KHR::initialize(const VkAttachmentDescription2KHR* in_struct)
{
    sType = in_struct->sType;
    flags = in_struct->flags;
    format = in_struct->format;
    samples = in_struct->samples;
    loadOp = in_struct->loadOp;
    storeOp = in_struct->storeOp;
    stencilLoadOp = in_struct->stencilLoadOp;
    stencilStoreOp = in_struct->stencilStoreOp;
    initialLayout = in_struct->initialLayout;
    finalLayout = in_struct->finalLayout;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkAttachmentDescription2KHR::initialize(const safe_VkAttachmentDescription2KHR* src)
{
    sType = src->sType;
    flags = src->flags;
    format = src->format;
    samples = src->samples;
    loadOp = src->loadOp;
    storeOp = src->storeOp;
    stencilLoadOp = src->stencilLoadOp;
    stencilStoreOp = src->stencilStoreOp;
    initialLayout = src->initialLayout;
    finalLayout = src->finalLayout;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkAttachmentReference2KHR::safe_VkAttachmentReference2KHR(const VkAttachmentReference2KHR* in_struct) :
    sType(in_struct->sType),
    attachment(in_struct->attachment),
    layout(in_struct->layout),
    aspectMask(in_struct->aspectMask)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkAttachmentReference2KHR::safe_VkAttachmentReference2KHR() :
    pNext(nullptr)
{}

safe_VkAttachmentReference2KHR::safe_VkAttachmentReference2KHR(const safe_VkAttachmentReference2KHR& src)
{
    sType = src.sType;
    attachment = src.attachment;
    layout = src.layout;
    aspectMask = src.aspectMask;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkAttachmentReference2KHR& safe_VkAttachmentReference2KHR::operator=(const safe_VkAttachmentReference2KHR& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    attachment = src.attachment;
    layout = src.layout;
    aspectMask = src.aspectMask;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkAttachmentReference2KHR::~safe_VkAttachmentReference2KHR()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkAttachmentReference2KHR::initialize(const VkAttachmentReference2KHR* in_struct)
{
    sType = in_struct->sType;
    attachment = in_struct->attachment;
    layout = in_struct->layout;
    aspectMask = in_struct->aspectMask;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkAttachmentReference2KHR::initialize(const safe_VkAttachmentReference2KHR* src)
{
    sType = src->sType;
    attachment = src->attachment;
    layout = src->layout;
    aspectMask = src->aspectMask;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkSubpassDescription2KHR::safe_VkSubpassDescription2KHR(const VkSubpassDescription2KHR* in_struct) :
    sType(in_struct->sType),
    flags(in_struct->flags),
    pipelineBindPoint(in_struct->pipelineBindPoint),
    viewMask(in_struct->viewMask),
    inputAttachmentCount(in_struct->inputAttachmentCount),
    pInputAttachments(nullptr),
    colorAttachmentCount(in_struct->colorAttachmentCount),
    pColorAttachments(nullptr),
    pResolveAttachments(nullptr),
    pDepthStencilAttachment(nullptr),
    preserveAttachmentCount(in_struct->preserveAttachmentCount),
    pPreserveAttachments(nullptr)
{
    pNext = SafePnextCopy(in_struct->pNext);
    if (inputAttachmentCount && in_struct->pInputAttachments) {
        pInputAttachments = new safe_VkAttachmentReference2KHR[inputAttachmentCount];
        for (uint32_t i = 0; i < inputAttachmentCount; ++i) {
            pInputAttachments[i].initialize(&in_struct->pInputAttachments[i]);
        }
    }
    if (colorAttachmentCount && in_struct->pColorAttachments) {
        pColorAttachments = new safe_VkAttachmentReference2KHR[colorAttachmentCount];
        for (uint32_t i = 0; i < colorAttachmentCount; ++i) {
            pColorAttachments[i].initialize(&in_struct->pColorAttachments[i]);
        }
    }
    if (colorAttachmentCount && in_struct->pResolveAttachments) {
        pResolveAttachments = new safe_VkAttachmentReference2KHR[colorAttachmentCount];
        for (uint32_t i = 0; i < colorAttachmentCount; ++i) {
            pResolveAttachments[i].initialize(&in_struct->pResolveAttachments[i]);
        }
    }
    if (in_struct->pDepthStencilAttachment)
        pDepthStencilAttachment = new safe_VkAttachmentReference2KHR(in_struct->pDepthStencilAttachment);
    if (in_struct->pPreserveAttachments) {
        pPreserveAttachments = new uint32_t[in_struct->preserveAttachmentCount];
        memcpy ((void *)pPreserveAttachments, (void *)in_struct->pPreserveAttachments, sizeof(uint32_t)*in_struct->preserveAttachmentCount);
    }
}

safe_VkSubpassDescription2KHR::safe_VkSubpassDescription2KHR() :
    pNext(nullptr),
    pInputAttachments(nullptr),
    pColorAttachments(nullptr),
    pResolveAttachments(nullptr),
    pDepthStencilAttachment(nullptr),
    pPreserveAttachments(nullptr)
{}

safe_VkSubpassDescription2KHR::safe_VkSubpassDescription2KHR(const safe_VkSubpassDescription2KHR& src)
{
    sType = src.sType;
    flags = src.flags;
    pipelineBindPoint = src.pipelineBindPoint;
    viewMask = src.viewMask;
    inputAttachmentCount = src.inputAttachmentCount;
    pInputAttachments = nullptr;
    colorAttachmentCount = src.colorAttachmentCount;
    pColorAttachments = nullptr;
    pResolveAttachments = nullptr;
    pDepthStencilAttachment = nullptr;
    preserveAttachmentCount = src.preserveAttachmentCount;
    pPreserveAttachments = nullptr;
    pNext = SafePnextCopy(src.pNext);
    if (inputAttachmentCount && src.pInputAttachments) {
        pInputAttachments = new safe_VkAttachmentReference2KHR[inputAttachmentCount];
        for (uint32_t i = 0; i < inputAttachmentCount; ++i) {
            pInputAttachments[i].initialize(&src.pInputAttachments[i]);
        }
    }
    if (colorAttachmentCount && src.pColorAttachments) {
        pColorAttachments = new safe_VkAttachmentReference2KHR[colorAttachmentCount];
        for (uint32_t i = 0; i < colorAttachmentCount; ++i) {
            pColorAttachments[i].initialize(&src.pColorAttachments[i]);
        }
    }
    if (colorAttachmentCount && src.pResolveAttachments) {
        pResolveAttachments = new safe_VkAttachmentReference2KHR[colorAttachmentCount];
        for (uint32_t i = 0; i < colorAttachmentCount; ++i) {
            pResolveAttachments[i].initialize(&src.pResolveAttachments[i]);
        }
    }
    if (src.pDepthStencilAttachment)
        pDepthStencilAttachment = new safe_VkAttachmentReference2KHR(*src.pDepthStencilAttachment);
    if (src.pPreserveAttachments) {
        pPreserveAttachments = new uint32_t[src.preserveAttachmentCount];
        memcpy ((void *)pPreserveAttachments, (void *)src.pPreserveAttachments, sizeof(uint32_t)*src.preserveAttachmentCount);
    }
}

safe_VkSubpassDescription2KHR& safe_VkSubpassDescription2KHR::operator=(const safe_VkSubpassDescription2KHR& src)
{
    if (&src == this) return *this;

    if (pInputAttachments)
        delete[] pInputAttachments;
    if (pColorAttachments)
        delete[] pColorAttachments;
    if (pResolveAttachments)
        delete[] pResolveAttachments;
    if (pDepthStencilAttachment)
        delete pDepthStencilAttachment;
    if (pPreserveAttachments)
        delete[] pPreserveAttachments;
    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    flags = src.flags;
    pipelineBindPoint = src.pipelineBindPoint;
    viewMask = src.viewMask;
    inputAttachmentCount = src.inputAttachmentCount;
    pInputAttachments = nullptr;
    colorAttachmentCount = src.colorAttachmentCount;
    pColorAttachments = nullptr;
    pResolveAttachments = nullptr;
    pDepthStencilAttachment = nullptr;
    preserveAttachmentCount = src.preserveAttachmentCount;
    pPreserveAttachments = nullptr;
    pNext = SafePnextCopy(src.pNext);
    if (inputAttachmentCount && src.pInputAttachments) {
        pInputAttachments = new safe_VkAttachmentReference2KHR[inputAttachmentCount];
        for (uint32_t i = 0; i < inputAttachmentCount; ++i) {
            pInputAttachments[i].initialize(&src.pInputAttachments[i]);
        }
    }
    if (colorAttachmentCount && src.pColorAttachments) {
        pColorAttachments = new safe_VkAttachmentReference2KHR[colorAttachmentCount];
        for (uint32_t i = 0; i < colorAttachmentCount; ++i) {
            pColorAttachments[i].initialize(&src.pColorAttachments[i]);
        }
    }
    if (colorAttachmentCount && src.pResolveAttachments) {
        pResolveAttachments = new safe_VkAttachmentReference2KHR[colorAttachmentCount];
        for (uint32_t i = 0; i < colorAttachmentCount; ++i) {
            pResolveAttachments[i].initialize(&src.pResolveAttachments[i]);
        }
    }
    if (src.pDepthStencilAttachment)
        pDepthStencilAttachment = new safe_VkAttachmentReference2KHR(*src.pDepthStencilAttachment);
    if (src.pPreserveAttachments) {
        pPreserveAttachments = new uint32_t[src.preserveAttachmentCount];
        memcpy ((void *)pPreserveAttachments, (void *)src.pPreserveAttachments, sizeof(uint32_t)*src.preserveAttachmentCount);
    }

    return *this;
}

safe_VkSubpassDescription2KHR::~safe_VkSubpassDescription2KHR()
{
    if (pInputAttachments)
        delete[] pInputAttachments;
    if (pColorAttachments)
        delete[] pColorAttachments;
    if (pResolveAttachments)
        delete[] pResolveAttachments;
    if (pDepthStencilAttachment)
        delete pDepthStencilAttachment;
    if (pPreserveAttachments)
        delete[] pPreserveAttachments;
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkSubpassDescription2KHR::initialize(const VkSubpassDescription2KHR* in_struct)
{
    sType = in_struct->sType;
    flags = in_struct->flags;
    pipelineBindPoint = in_struct->pipelineBindPoint;
    viewMask = in_struct->viewMask;
    inputAttachmentCount = in_struct->inputAttachmentCount;
    pInputAttachments = nullptr;
    colorAttachmentCount = in_struct->colorAttachmentCount;
    pColorAttachments = nullptr;
    pResolveAttachments = nullptr;
    pDepthStencilAttachment = nullptr;
    preserveAttachmentCount = in_struct->preserveAttachmentCount;
    pPreserveAttachments = nullptr;
    pNext = SafePnextCopy(in_struct->pNext);
    if (inputAttachmentCount && in_struct->pInputAttachments) {
        pInputAttachments = new safe_VkAttachmentReference2KHR[inputAttachmentCount];
        for (uint32_t i = 0; i < inputAttachmentCount; ++i) {
            pInputAttachments[i].initialize(&in_struct->pInputAttachments[i]);
        }
    }
    if (colorAttachmentCount && in_struct->pColorAttachments) {
        pColorAttachments = new safe_VkAttachmentReference2KHR[colorAttachmentCount];
        for (uint32_t i = 0; i < colorAttachmentCount; ++i) {
            pColorAttachments[i].initialize(&in_struct->pColorAttachments[i]);
        }
    }
    if (colorAttachmentCount && in_struct->pResolveAttachments) {
        pResolveAttachments = new safe_VkAttachmentReference2KHR[colorAttachmentCount];
        for (uint32_t i = 0; i < colorAttachmentCount; ++i) {
            pResolveAttachments[i].initialize(&in_struct->pResolveAttachments[i]);
        }
    }
    if (in_struct->pDepthStencilAttachment)
        pDepthStencilAttachment = new safe_VkAttachmentReference2KHR(in_struct->pDepthStencilAttachment);
    if (in_struct->pPreserveAttachments) {
        pPreserveAttachments = new uint32_t[in_struct->preserveAttachmentCount];
        memcpy ((void *)pPreserveAttachments, (void *)in_struct->pPreserveAttachments, sizeof(uint32_t)*in_struct->preserveAttachmentCount);
    }
}

void safe_VkSubpassDescription2KHR::initialize(const safe_VkSubpassDescription2KHR* src)
{
    sType = src->sType;
    flags = src->flags;
    pipelineBindPoint = src->pipelineBindPoint;
    viewMask = src->viewMask;
    inputAttachmentCount = src->inputAttachmentCount;
    pInputAttachments = nullptr;
    colorAttachmentCount = src->colorAttachmentCount;
    pColorAttachments = nullptr;
    pResolveAttachments = nullptr;
    pDepthStencilAttachment = nullptr;
    preserveAttachmentCount = src->preserveAttachmentCount;
    pPreserveAttachments = nullptr;
    pNext = SafePnextCopy(src->pNext);
    if (inputAttachmentCount && src->pInputAttachments) {
        pInputAttachments = new safe_VkAttachmentReference2KHR[inputAttachmentCount];
        for (uint32_t i = 0; i < inputAttachmentCount; ++i) {
            pInputAttachments[i].initialize(&src->pInputAttachments[i]);
        }
    }
    if (colorAttachmentCount && src->pColorAttachments) {
        pColorAttachments = new safe_VkAttachmentReference2KHR[colorAttachmentCount];
        for (uint32_t i = 0; i < colorAttachmentCount; ++i) {
            pColorAttachments[i].initialize(&src->pColorAttachments[i]);
        }
    }
    if (colorAttachmentCount && src->pResolveAttachments) {
        pResolveAttachments = new safe_VkAttachmentReference2KHR[colorAttachmentCount];
        for (uint32_t i = 0; i < colorAttachmentCount; ++i) {
            pResolveAttachments[i].initialize(&src->pResolveAttachments[i]);
        }
    }
    if (src->pDepthStencilAttachment)
        pDepthStencilAttachment = new safe_VkAttachmentReference2KHR(*src->pDepthStencilAttachment);
    if (src->pPreserveAttachments) {
        pPreserveAttachments = new uint32_t[src->preserveAttachmentCount];
        memcpy ((void *)pPreserveAttachments, (void *)src->pPreserveAttachments, sizeof(uint32_t)*src->preserveAttachmentCount);
    }
}

safe_VkSubpassDependency2KHR::safe_VkSubpassDependency2KHR(const VkSubpassDependency2KHR* in_struct) :
    sType(in_struct->sType),
    srcSubpass(in_struct->srcSubpass),
    dstSubpass(in_struct->dstSubpass),
    srcStageMask(in_struct->srcStageMask),
    dstStageMask(in_struct->dstStageMask),
    srcAccessMask(in_struct->srcAccessMask),
    dstAccessMask(in_struct->dstAccessMask),
    dependencyFlags(in_struct->dependencyFlags),
    viewOffset(in_struct->viewOffset)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkSubpassDependency2KHR::safe_VkSubpassDependency2KHR() :
    pNext(nullptr)
{}

safe_VkSubpassDependency2KHR::safe_VkSubpassDependency2KHR(const safe_VkSubpassDependency2KHR& src)
{
    sType = src.sType;
    srcSubpass = src.srcSubpass;
    dstSubpass = src.dstSubpass;
    srcStageMask = src.srcStageMask;
    dstStageMask = src.dstStageMask;
    srcAccessMask = src.srcAccessMask;
    dstAccessMask = src.dstAccessMask;
    dependencyFlags = src.dependencyFlags;
    viewOffset = src.viewOffset;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkSubpassDependency2KHR& safe_VkSubpassDependency2KHR::operator=(const safe_VkSubpassDependency2KHR& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    srcSubpass = src.srcSubpass;
    dstSubpass = src.dstSubpass;
    srcStageMask = src.srcStageMask;
    dstStageMask = src.dstStageMask;
    srcAccessMask = src.srcAccessMask;
    dstAccessMask = src.dstAccessMask;
    dependencyFlags = src.dependencyFlags;
    viewOffset = src.viewOffset;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkSubpassDependency2KHR::~safe_VkSubpassDependency2KHR()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkSubpassDependency2KHR::initialize(const VkSubpassDependency2KHR* in_struct)
{
    sType = in_struct->sType;
    srcSubpass = in_struct->srcSubpass;
    dstSubpass = in_struct->dstSubpass;
    srcStageMask = in_struct->srcStageMask;
    dstStageMask = in_struct->dstStageMask;
    srcAccessMask = in_struct->srcAccessMask;
    dstAccessMask = in_struct->dstAccessMask;
    dependencyFlags = in_struct->dependencyFlags;
    viewOffset = in_struct->viewOffset;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkSubpassDependency2KHR::initialize(const safe_VkSubpassDependency2KHR* src)
{
    sType = src->sType;
    srcSubpass = src->srcSubpass;
    dstSubpass = src->dstSubpass;
    srcStageMask = src->srcStageMask;
    dstStageMask = src->dstStageMask;
    srcAccessMask = src->srcAccessMask;
    dstAccessMask = src->dstAccessMask;
    dependencyFlags = src->dependencyFlags;
    viewOffset = src->viewOffset;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkRenderPassCreateInfo2KHR::safe_VkRenderPassCreateInfo2KHR(const VkRenderPassCreateInfo2KHR* in_struct) :
    sType(in_struct->sType),
    flags(in_struct->flags),
    attachmentCount(in_struct->attachmentCount),
    pAttachments(nullptr),
    subpassCount(in_struct->subpassCount),
    pSubpasses(nullptr),
    dependencyCount(in_struct->dependencyCount),
    pDependencies(nullptr),
    correlatedViewMaskCount(in_struct->correlatedViewMaskCount),
    pCorrelatedViewMasks(nullptr)
{
    pNext = SafePnextCopy(in_struct->pNext);
    if (attachmentCount && in_struct->pAttachments) {
        pAttachments = new safe_VkAttachmentDescription2KHR[attachmentCount];
        for (uint32_t i = 0; i < attachmentCount; ++i) {
            pAttachments[i].initialize(&in_struct->pAttachments[i]);
        }
    }
    if (subpassCount && in_struct->pSubpasses) {
        pSubpasses = new safe_VkSubpassDescription2KHR[subpassCount];
        for (uint32_t i = 0; i < subpassCount; ++i) {
            pSubpasses[i].initialize(&in_struct->pSubpasses[i]);
        }
    }
    if (dependencyCount && in_struct->pDependencies) {
        pDependencies = new safe_VkSubpassDependency2KHR[dependencyCount];
        for (uint32_t i = 0; i < dependencyCount; ++i) {
            pDependencies[i].initialize(&in_struct->pDependencies[i]);
        }
    }
    if (in_struct->pCorrelatedViewMasks) {
        pCorrelatedViewMasks = new uint32_t[in_struct->correlatedViewMaskCount];
        memcpy ((void *)pCorrelatedViewMasks, (void *)in_struct->pCorrelatedViewMasks, sizeof(uint32_t)*in_struct->correlatedViewMaskCount);
    }
}

safe_VkRenderPassCreateInfo2KHR::safe_VkRenderPassCreateInfo2KHR() :
    pNext(nullptr),
    pAttachments(nullptr),
    pSubpasses(nullptr),
    pDependencies(nullptr),
    pCorrelatedViewMasks(nullptr)
{}

safe_VkRenderPassCreateInfo2KHR::safe_VkRenderPassCreateInfo2KHR(const safe_VkRenderPassCreateInfo2KHR& src)
{
    sType = src.sType;
    flags = src.flags;
    attachmentCount = src.attachmentCount;
    pAttachments = nullptr;
    subpassCount = src.subpassCount;
    pSubpasses = nullptr;
    dependencyCount = src.dependencyCount;
    pDependencies = nullptr;
    correlatedViewMaskCount = src.correlatedViewMaskCount;
    pCorrelatedViewMasks = nullptr;
    pNext = SafePnextCopy(src.pNext);
    if (attachmentCount && src.pAttachments) {
        pAttachments = new safe_VkAttachmentDescription2KHR[attachmentCount];
        for (uint32_t i = 0; i < attachmentCount; ++i) {
            pAttachments[i].initialize(&src.pAttachments[i]);
        }
    }
    if (subpassCount && src.pSubpasses) {
        pSubpasses = new safe_VkSubpassDescription2KHR[subpassCount];
        for (uint32_t i = 0; i < subpassCount; ++i) {
            pSubpasses[i].initialize(&src.pSubpasses[i]);
        }
    }
    if (dependencyCount && src.pDependencies) {
        pDependencies = new safe_VkSubpassDependency2KHR[dependencyCount];
        for (uint32_t i = 0; i < dependencyCount; ++i) {
            pDependencies[i].initialize(&src.pDependencies[i]);
        }
    }
    if (src.pCorrelatedViewMasks) {
        pCorrelatedViewMasks = new uint32_t[src.correlatedViewMaskCount];
        memcpy ((void *)pCorrelatedViewMasks, (void *)src.pCorrelatedViewMasks, sizeof(uint32_t)*src.correlatedViewMaskCount);
    }
}

safe_VkRenderPassCreateInfo2KHR& safe_VkRenderPassCreateInfo2KHR::operator=(const safe_VkRenderPassCreateInfo2KHR& src)
{
    if (&src == this) return *this;

    if (pAttachments)
        delete[] pAttachments;
    if (pSubpasses)
        delete[] pSubpasses;
    if (pDependencies)
        delete[] pDependencies;
    if (pCorrelatedViewMasks)
        delete[] pCorrelatedViewMasks;
    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    flags = src.flags;
    attachmentCount = src.attachmentCount;
    pAttachments = nullptr;
    subpassCount = src.subpassCount;
    pSubpasses = nullptr;
    dependencyCount = src.dependencyCount;
    pDependencies = nullptr;
    correlatedViewMaskCount = src.correlatedViewMaskCount;
    pCorrelatedViewMasks = nullptr;
    pNext = SafePnextCopy(src.pNext);
    if (attachmentCount && src.pAttachments) {
        pAttachments = new safe_VkAttachmentDescription2KHR[attachmentCount];
        for (uint32_t i = 0; i < attachmentCount; ++i) {
            pAttachments[i].initialize(&src.pAttachments[i]);
        }
    }
    if (subpassCount && src.pSubpasses) {
        pSubpasses = new safe_VkSubpassDescription2KHR[subpassCount];
        for (uint32_t i = 0; i < subpassCount; ++i) {
            pSubpasses[i].initialize(&src.pSubpasses[i]);
        }
    }
    if (dependencyCount && src.pDependencies) {
        pDependencies = new safe_VkSubpassDependency2KHR[dependencyCount];
        for (uint32_t i = 0; i < dependencyCount; ++i) {
            pDependencies[i].initialize(&src.pDependencies[i]);
        }
    }
    if (src.pCorrelatedViewMasks) {
        pCorrelatedViewMasks = new uint32_t[src.correlatedViewMaskCount];
        memcpy ((void *)pCorrelatedViewMasks, (void *)src.pCorrelatedViewMasks, sizeof(uint32_t)*src.correlatedViewMaskCount);
    }

    return *this;
}

safe_VkRenderPassCreateInfo2KHR::~safe_VkRenderPassCreateInfo2KHR()
{
    if (pAttachments)
        delete[] pAttachments;
    if (pSubpasses)
        delete[] pSubpasses;
    if (pDependencies)
        delete[] pDependencies;
    if (pCorrelatedViewMasks)
        delete[] pCorrelatedViewMasks;
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkRenderPassCreateInfo2KHR::initialize(const VkRenderPassCreateInfo2KHR* in_struct)
{
    sType = in_struct->sType;
    flags = in_struct->flags;
    attachmentCount = in_struct->attachmentCount;
    pAttachments = nullptr;
    subpassCount = in_struct->subpassCount;
    pSubpasses = nullptr;
    dependencyCount = in_struct->dependencyCount;
    pDependencies = nullptr;
    correlatedViewMaskCount = in_struct->correlatedViewMaskCount;
    pCorrelatedViewMasks = nullptr;
    pNext = SafePnextCopy(in_struct->pNext);
    if (attachmentCount && in_struct->pAttachments) {
        pAttachments = new safe_VkAttachmentDescription2KHR[attachmentCount];
        for (uint32_t i = 0; i < attachmentCount; ++i) {
            pAttachments[i].initialize(&in_struct->pAttachments[i]);
        }
    }
    if (subpassCount && in_struct->pSubpasses) {
        pSubpasses = new safe_VkSubpassDescription2KHR[subpassCount];
        for (uint32_t i = 0; i < subpassCount; ++i) {
            pSubpasses[i].initialize(&in_struct->pSubpasses[i]);
        }
    }
    if (dependencyCount && in_struct->pDependencies) {
        pDependencies = new safe_VkSubpassDependency2KHR[dependencyCount];
        for (uint32_t i = 0; i < dependencyCount; ++i) {
            pDependencies[i].initialize(&in_struct->pDependencies[i]);
        }
    }
    if (in_struct->pCorrelatedViewMasks) {
        pCorrelatedViewMasks = new uint32_t[in_struct->correlatedViewMaskCount];
        memcpy ((void *)pCorrelatedViewMasks, (void *)in_struct->pCorrelatedViewMasks, sizeof(uint32_t)*in_struct->correlatedViewMaskCount);
    }
}

void safe_VkRenderPassCreateInfo2KHR::initialize(const safe_VkRenderPassCreateInfo2KHR* src)
{
    sType = src->sType;
    flags = src->flags;
    attachmentCount = src->attachmentCount;
    pAttachments = nullptr;
    subpassCount = src->subpassCount;
    pSubpasses = nullptr;
    dependencyCount = src->dependencyCount;
    pDependencies = nullptr;
    correlatedViewMaskCount = src->correlatedViewMaskCount;
    pCorrelatedViewMasks = nullptr;
    pNext = SafePnextCopy(src->pNext);
    if (attachmentCount && src->pAttachments) {
        pAttachments = new safe_VkAttachmentDescription2KHR[attachmentCount];
        for (uint32_t i = 0; i < attachmentCount; ++i) {
            pAttachments[i].initialize(&src->pAttachments[i]);
        }
    }
    if (subpassCount && src->pSubpasses) {
        pSubpasses = new safe_VkSubpassDescription2KHR[subpassCount];
        for (uint32_t i = 0; i < subpassCount; ++i) {
            pSubpasses[i].initialize(&src->pSubpasses[i]);
        }
    }
    if (dependencyCount && src->pDependencies) {
        pDependencies = new safe_VkSubpassDependency2KHR[dependencyCount];
        for (uint32_t i = 0; i < dependencyCount; ++i) {
            pDependencies[i].initialize(&src->pDependencies[i]);
        }
    }
    if (src->pCorrelatedViewMasks) {
        pCorrelatedViewMasks = new uint32_t[src->correlatedViewMaskCount];
        memcpy ((void *)pCorrelatedViewMasks, (void *)src->pCorrelatedViewMasks, sizeof(uint32_t)*src->correlatedViewMaskCount);
    }
}

safe_VkSubpassBeginInfoKHR::safe_VkSubpassBeginInfoKHR(const VkSubpassBeginInfoKHR* in_struct) :
    sType(in_struct->sType),
    contents(in_struct->contents)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkSubpassBeginInfoKHR::safe_VkSubpassBeginInfoKHR() :
    pNext(nullptr)
{}

safe_VkSubpassBeginInfoKHR::safe_VkSubpassBeginInfoKHR(const safe_VkSubpassBeginInfoKHR& src)
{
    sType = src.sType;
    contents = src.contents;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkSubpassBeginInfoKHR& safe_VkSubpassBeginInfoKHR::operator=(const safe_VkSubpassBeginInfoKHR& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    contents = src.contents;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkSubpassBeginInfoKHR::~safe_VkSubpassBeginInfoKHR()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkSubpassBeginInfoKHR::initialize(const VkSubpassBeginInfoKHR* in_struct)
{
    sType = in_struct->sType;
    contents = in_struct->contents;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkSubpassBeginInfoKHR::initialize(const safe_VkSubpassBeginInfoKHR* src)
{
    sType = src->sType;
    contents = src->contents;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkSubpassEndInfoKHR::safe_VkSubpassEndInfoKHR(const VkSubpassEndInfoKHR* in_struct) :
    sType(in_struct->sType)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkSubpassEndInfoKHR::safe_VkSubpassEndInfoKHR() :
    pNext(nullptr)
{}

safe_VkSubpassEndInfoKHR::safe_VkSubpassEndInfoKHR(const safe_VkSubpassEndInfoKHR& src)
{
    sType = src.sType;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkSubpassEndInfoKHR& safe_VkSubpassEndInfoKHR::operator=(const safe_VkSubpassEndInfoKHR& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkSubpassEndInfoKHR::~safe_VkSubpassEndInfoKHR()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkSubpassEndInfoKHR::initialize(const VkSubpassEndInfoKHR* in_struct)
{
    sType = in_struct->sType;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkSubpassEndInfoKHR::initialize(const safe_VkSubpassEndInfoKHR* src)
{
    sType = src->sType;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkSharedPresentSurfaceCapabilitiesKHR::safe_VkSharedPresentSurfaceCapabilitiesKHR(const VkSharedPresentSurfaceCapabilitiesKHR* in_struct) :
    sType(in_struct->sType),
    sharedPresentSupportedUsageFlags(in_struct->sharedPresentSupportedUsageFlags)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkSharedPresentSurfaceCapabilitiesKHR::safe_VkSharedPresentSurfaceCapabilitiesKHR() :
    pNext(nullptr)
{}

safe_VkSharedPresentSurfaceCapabilitiesKHR::safe_VkSharedPresentSurfaceCapabilitiesKHR(const safe_VkSharedPresentSurfaceCapabilitiesKHR& src)
{
    sType = src.sType;
    sharedPresentSupportedUsageFlags = src.sharedPresentSupportedUsageFlags;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkSharedPresentSurfaceCapabilitiesKHR& safe_VkSharedPresentSurfaceCapabilitiesKHR::operator=(const safe_VkSharedPresentSurfaceCapabilitiesKHR& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    sharedPresentSupportedUsageFlags = src.sharedPresentSupportedUsageFlags;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkSharedPresentSurfaceCapabilitiesKHR::~safe_VkSharedPresentSurfaceCapabilitiesKHR()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkSharedPresentSurfaceCapabilitiesKHR::initialize(const VkSharedPresentSurfaceCapabilitiesKHR* in_struct)
{
    sType = in_struct->sType;
    sharedPresentSupportedUsageFlags = in_struct->sharedPresentSupportedUsageFlags;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkSharedPresentSurfaceCapabilitiesKHR::initialize(const safe_VkSharedPresentSurfaceCapabilitiesKHR* src)
{
    sType = src->sType;
    sharedPresentSupportedUsageFlags = src->sharedPresentSupportedUsageFlags;
    pNext = SafePnextCopy(src->pNext);
}
#ifdef VK_USE_PLATFORM_WIN32_KHR


safe_VkImportFenceWin32HandleInfoKHR::safe_VkImportFenceWin32HandleInfoKHR(const VkImportFenceWin32HandleInfoKHR* in_struct) :
    sType(in_struct->sType),
    fence(in_struct->fence),
    flags(in_struct->flags),
    handleType(in_struct->handleType),
    handle(in_struct->handle),
    name(in_struct->name)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkImportFenceWin32HandleInfoKHR::safe_VkImportFenceWin32HandleInfoKHR() :
    pNext(nullptr)
{}

safe_VkImportFenceWin32HandleInfoKHR::safe_VkImportFenceWin32HandleInfoKHR(const safe_VkImportFenceWin32HandleInfoKHR& src)
{
    sType = src.sType;
    fence = src.fence;
    flags = src.flags;
    handleType = src.handleType;
    handle = src.handle;
    name = src.name;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkImportFenceWin32HandleInfoKHR& safe_VkImportFenceWin32HandleInfoKHR::operator=(const safe_VkImportFenceWin32HandleInfoKHR& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    fence = src.fence;
    flags = src.flags;
    handleType = src.handleType;
    handle = src.handle;
    name = src.name;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkImportFenceWin32HandleInfoKHR::~safe_VkImportFenceWin32HandleInfoKHR()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkImportFenceWin32HandleInfoKHR::initialize(const VkImportFenceWin32HandleInfoKHR* in_struct)
{
    sType = in_struct->sType;
    fence = in_struct->fence;
    flags = in_struct->flags;
    handleType = in_struct->handleType;
    handle = in_struct->handle;
    name = in_struct->name;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkImportFenceWin32HandleInfoKHR::initialize(const safe_VkImportFenceWin32HandleInfoKHR* src)
{
    sType = src->sType;
    fence = src->fence;
    flags = src->flags;
    handleType = src->handleType;
    handle = src->handle;
    name = src->name;
    pNext = SafePnextCopy(src->pNext);
}
#endif // VK_USE_PLATFORM_WIN32_KHR

#ifdef VK_USE_PLATFORM_WIN32_KHR


safe_VkExportFenceWin32HandleInfoKHR::safe_VkExportFenceWin32HandleInfoKHR(const VkExportFenceWin32HandleInfoKHR* in_struct) :
    sType(in_struct->sType),
    pAttributes(nullptr),
    dwAccess(in_struct->dwAccess),
    name(in_struct->name)
{
    pNext = SafePnextCopy(in_struct->pNext);
    if (in_struct->pAttributes) {
        pAttributes = new SECURITY_ATTRIBUTES(*in_struct->pAttributes);
    }
}

safe_VkExportFenceWin32HandleInfoKHR::safe_VkExportFenceWin32HandleInfoKHR() :
    pNext(nullptr),
    pAttributes(nullptr)
{}

safe_VkExportFenceWin32HandleInfoKHR::safe_VkExportFenceWin32HandleInfoKHR(const safe_VkExportFenceWin32HandleInfoKHR& src)
{
    sType = src.sType;
    pAttributes = nullptr;
    dwAccess = src.dwAccess;
    name = src.name;
    pNext = SafePnextCopy(src.pNext);
    if (src.pAttributes) {
        pAttributes = new SECURITY_ATTRIBUTES(*src.pAttributes);
    }
}

safe_VkExportFenceWin32HandleInfoKHR& safe_VkExportFenceWin32HandleInfoKHR::operator=(const safe_VkExportFenceWin32HandleInfoKHR& src)
{
    if (&src == this) return *this;

    if (pAttributes)
        delete pAttributes;
    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    pAttributes = nullptr;
    dwAccess = src.dwAccess;
    name = src.name;
    pNext = SafePnextCopy(src.pNext);
    if (src.pAttributes) {
        pAttributes = new SECURITY_ATTRIBUTES(*src.pAttributes);
    }

    return *this;
}

safe_VkExportFenceWin32HandleInfoKHR::~safe_VkExportFenceWin32HandleInfoKHR()
{
    if (pAttributes)
        delete pAttributes;
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkExportFenceWin32HandleInfoKHR::initialize(const VkExportFenceWin32HandleInfoKHR* in_struct)
{
    sType = in_struct->sType;
    pAttributes = nullptr;
    dwAccess = in_struct->dwAccess;
    name = in_struct->name;
    pNext = SafePnextCopy(in_struct->pNext);
    if (in_struct->pAttributes) {
        pAttributes = new SECURITY_ATTRIBUTES(*in_struct->pAttributes);
    }
}

void safe_VkExportFenceWin32HandleInfoKHR::initialize(const safe_VkExportFenceWin32HandleInfoKHR* src)
{
    sType = src->sType;
    pAttributes = nullptr;
    dwAccess = src->dwAccess;
    name = src->name;
    pNext = SafePnextCopy(src->pNext);
    if (src->pAttributes) {
        pAttributes = new SECURITY_ATTRIBUTES(*src->pAttributes);
    }
}
#endif // VK_USE_PLATFORM_WIN32_KHR

#ifdef VK_USE_PLATFORM_WIN32_KHR


safe_VkFenceGetWin32HandleInfoKHR::safe_VkFenceGetWin32HandleInfoKHR(const VkFenceGetWin32HandleInfoKHR* in_struct) :
    sType(in_struct->sType),
    fence(in_struct->fence),
    handleType(in_struct->handleType)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkFenceGetWin32HandleInfoKHR::safe_VkFenceGetWin32HandleInfoKHR() :
    pNext(nullptr)
{}

safe_VkFenceGetWin32HandleInfoKHR::safe_VkFenceGetWin32HandleInfoKHR(const safe_VkFenceGetWin32HandleInfoKHR& src)
{
    sType = src.sType;
    fence = src.fence;
    handleType = src.handleType;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkFenceGetWin32HandleInfoKHR& safe_VkFenceGetWin32HandleInfoKHR::operator=(const safe_VkFenceGetWin32HandleInfoKHR& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    fence = src.fence;
    handleType = src.handleType;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkFenceGetWin32HandleInfoKHR::~safe_VkFenceGetWin32HandleInfoKHR()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkFenceGetWin32HandleInfoKHR::initialize(const VkFenceGetWin32HandleInfoKHR* in_struct)
{
    sType = in_struct->sType;
    fence = in_struct->fence;
    handleType = in_struct->handleType;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkFenceGetWin32HandleInfoKHR::initialize(const safe_VkFenceGetWin32HandleInfoKHR* src)
{
    sType = src->sType;
    fence = src->fence;
    handleType = src->handleType;
    pNext = SafePnextCopy(src->pNext);
}
#endif // VK_USE_PLATFORM_WIN32_KHR


safe_VkImportFenceFdInfoKHR::safe_VkImportFenceFdInfoKHR(const VkImportFenceFdInfoKHR* in_struct) :
    sType(in_struct->sType),
    fence(in_struct->fence),
    flags(in_struct->flags),
    handleType(in_struct->handleType),
    fd(in_struct->fd)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkImportFenceFdInfoKHR::safe_VkImportFenceFdInfoKHR() :
    pNext(nullptr)
{}

safe_VkImportFenceFdInfoKHR::safe_VkImportFenceFdInfoKHR(const safe_VkImportFenceFdInfoKHR& src)
{
    sType = src.sType;
    fence = src.fence;
    flags = src.flags;
    handleType = src.handleType;
    fd = src.fd;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkImportFenceFdInfoKHR& safe_VkImportFenceFdInfoKHR::operator=(const safe_VkImportFenceFdInfoKHR& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    fence = src.fence;
    flags = src.flags;
    handleType = src.handleType;
    fd = src.fd;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkImportFenceFdInfoKHR::~safe_VkImportFenceFdInfoKHR()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkImportFenceFdInfoKHR::initialize(const VkImportFenceFdInfoKHR* in_struct)
{
    sType = in_struct->sType;
    fence = in_struct->fence;
    flags = in_struct->flags;
    handleType = in_struct->handleType;
    fd = in_struct->fd;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkImportFenceFdInfoKHR::initialize(const safe_VkImportFenceFdInfoKHR* src)
{
    sType = src->sType;
    fence = src->fence;
    flags = src->flags;
    handleType = src->handleType;
    fd = src->fd;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkFenceGetFdInfoKHR::safe_VkFenceGetFdInfoKHR(const VkFenceGetFdInfoKHR* in_struct) :
    sType(in_struct->sType),
    fence(in_struct->fence),
    handleType(in_struct->handleType)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkFenceGetFdInfoKHR::safe_VkFenceGetFdInfoKHR() :
    pNext(nullptr)
{}

safe_VkFenceGetFdInfoKHR::safe_VkFenceGetFdInfoKHR(const safe_VkFenceGetFdInfoKHR& src)
{
    sType = src.sType;
    fence = src.fence;
    handleType = src.handleType;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkFenceGetFdInfoKHR& safe_VkFenceGetFdInfoKHR::operator=(const safe_VkFenceGetFdInfoKHR& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    fence = src.fence;
    handleType = src.handleType;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkFenceGetFdInfoKHR::~safe_VkFenceGetFdInfoKHR()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkFenceGetFdInfoKHR::initialize(const VkFenceGetFdInfoKHR* in_struct)
{
    sType = in_struct->sType;
    fence = in_struct->fence;
    handleType = in_struct->handleType;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkFenceGetFdInfoKHR::initialize(const safe_VkFenceGetFdInfoKHR* src)
{
    sType = src->sType;
    fence = src->fence;
    handleType = src->handleType;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkPhysicalDeviceSurfaceInfo2KHR::safe_VkPhysicalDeviceSurfaceInfo2KHR(const VkPhysicalDeviceSurfaceInfo2KHR* in_struct) :
    sType(in_struct->sType),
    surface(in_struct->surface)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkPhysicalDeviceSurfaceInfo2KHR::safe_VkPhysicalDeviceSurfaceInfo2KHR() :
    pNext(nullptr)
{}

safe_VkPhysicalDeviceSurfaceInfo2KHR::safe_VkPhysicalDeviceSurfaceInfo2KHR(const safe_VkPhysicalDeviceSurfaceInfo2KHR& src)
{
    sType = src.sType;
    surface = src.surface;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkPhysicalDeviceSurfaceInfo2KHR& safe_VkPhysicalDeviceSurfaceInfo2KHR::operator=(const safe_VkPhysicalDeviceSurfaceInfo2KHR& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    surface = src.surface;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkPhysicalDeviceSurfaceInfo2KHR::~safe_VkPhysicalDeviceSurfaceInfo2KHR()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPhysicalDeviceSurfaceInfo2KHR::initialize(const VkPhysicalDeviceSurfaceInfo2KHR* in_struct)
{
    sType = in_struct->sType;
    surface = in_struct->surface;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkPhysicalDeviceSurfaceInfo2KHR::initialize(const safe_VkPhysicalDeviceSurfaceInfo2KHR* src)
{
    sType = src->sType;
    surface = src->surface;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkSurfaceCapabilities2KHR::safe_VkSurfaceCapabilities2KHR(const VkSurfaceCapabilities2KHR* in_struct) :
    sType(in_struct->sType),
    surfaceCapabilities(in_struct->surfaceCapabilities)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkSurfaceCapabilities2KHR::safe_VkSurfaceCapabilities2KHR() :
    pNext(nullptr)
{}

safe_VkSurfaceCapabilities2KHR::safe_VkSurfaceCapabilities2KHR(const safe_VkSurfaceCapabilities2KHR& src)
{
    sType = src.sType;
    surfaceCapabilities = src.surfaceCapabilities;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkSurfaceCapabilities2KHR& safe_VkSurfaceCapabilities2KHR::operator=(const safe_VkSurfaceCapabilities2KHR& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    surfaceCapabilities = src.surfaceCapabilities;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkSurfaceCapabilities2KHR::~safe_VkSurfaceCapabilities2KHR()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkSurfaceCapabilities2KHR::initialize(const VkSurfaceCapabilities2KHR* in_struct)
{
    sType = in_struct->sType;
    surfaceCapabilities = in_struct->surfaceCapabilities;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkSurfaceCapabilities2KHR::initialize(const safe_VkSurfaceCapabilities2KHR* src)
{
    sType = src->sType;
    surfaceCapabilities = src->surfaceCapabilities;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkSurfaceFormat2KHR::safe_VkSurfaceFormat2KHR(const VkSurfaceFormat2KHR* in_struct) :
    sType(in_struct->sType),
    surfaceFormat(in_struct->surfaceFormat)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkSurfaceFormat2KHR::safe_VkSurfaceFormat2KHR() :
    pNext(nullptr)
{}

safe_VkSurfaceFormat2KHR::safe_VkSurfaceFormat2KHR(const safe_VkSurfaceFormat2KHR& src)
{
    sType = src.sType;
    surfaceFormat = src.surfaceFormat;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkSurfaceFormat2KHR& safe_VkSurfaceFormat2KHR::operator=(const safe_VkSurfaceFormat2KHR& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    surfaceFormat = src.surfaceFormat;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkSurfaceFormat2KHR::~safe_VkSurfaceFormat2KHR()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkSurfaceFormat2KHR::initialize(const VkSurfaceFormat2KHR* in_struct)
{
    sType = in_struct->sType;
    surfaceFormat = in_struct->surfaceFormat;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkSurfaceFormat2KHR::initialize(const safe_VkSurfaceFormat2KHR* src)
{
    sType = src->sType;
    surfaceFormat = src->surfaceFormat;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkDisplayProperties2KHR::safe_VkDisplayProperties2KHR(const VkDisplayProperties2KHR* in_struct) :
    sType(in_struct->sType),
    displayProperties(&in_struct->displayProperties)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkDisplayProperties2KHR::safe_VkDisplayProperties2KHR() :
    pNext(nullptr)
{}

safe_VkDisplayProperties2KHR::safe_VkDisplayProperties2KHR(const safe_VkDisplayProperties2KHR& src)
{
    sType = src.sType;
    displayProperties.initialize(&src.displayProperties);
    pNext = SafePnextCopy(src.pNext);
}

safe_VkDisplayProperties2KHR& safe_VkDisplayProperties2KHR::operator=(const safe_VkDisplayProperties2KHR& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    displayProperties.initialize(&src.displayProperties);
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkDisplayProperties2KHR::~safe_VkDisplayProperties2KHR()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkDisplayProperties2KHR::initialize(const VkDisplayProperties2KHR* in_struct)
{
    sType = in_struct->sType;
    displayProperties.initialize(&in_struct->displayProperties);
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkDisplayProperties2KHR::initialize(const safe_VkDisplayProperties2KHR* src)
{
    sType = src->sType;
    displayProperties.initialize(&src->displayProperties);
    pNext = SafePnextCopy(src->pNext);
}

safe_VkDisplayPlaneProperties2KHR::safe_VkDisplayPlaneProperties2KHR(const VkDisplayPlaneProperties2KHR* in_struct) :
    sType(in_struct->sType),
    displayPlaneProperties(in_struct->displayPlaneProperties)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkDisplayPlaneProperties2KHR::safe_VkDisplayPlaneProperties2KHR() :
    pNext(nullptr)
{}

safe_VkDisplayPlaneProperties2KHR::safe_VkDisplayPlaneProperties2KHR(const safe_VkDisplayPlaneProperties2KHR& src)
{
    sType = src.sType;
    displayPlaneProperties = src.displayPlaneProperties;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkDisplayPlaneProperties2KHR& safe_VkDisplayPlaneProperties2KHR::operator=(const safe_VkDisplayPlaneProperties2KHR& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    displayPlaneProperties = src.displayPlaneProperties;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkDisplayPlaneProperties2KHR::~safe_VkDisplayPlaneProperties2KHR()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkDisplayPlaneProperties2KHR::initialize(const VkDisplayPlaneProperties2KHR* in_struct)
{
    sType = in_struct->sType;
    displayPlaneProperties = in_struct->displayPlaneProperties;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkDisplayPlaneProperties2KHR::initialize(const safe_VkDisplayPlaneProperties2KHR* src)
{
    sType = src->sType;
    displayPlaneProperties = src->displayPlaneProperties;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkDisplayModeProperties2KHR::safe_VkDisplayModeProperties2KHR(const VkDisplayModeProperties2KHR* in_struct) :
    sType(in_struct->sType),
    displayModeProperties(in_struct->displayModeProperties)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkDisplayModeProperties2KHR::safe_VkDisplayModeProperties2KHR() :
    pNext(nullptr)
{}

safe_VkDisplayModeProperties2KHR::safe_VkDisplayModeProperties2KHR(const safe_VkDisplayModeProperties2KHR& src)
{
    sType = src.sType;
    displayModeProperties = src.displayModeProperties;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkDisplayModeProperties2KHR& safe_VkDisplayModeProperties2KHR::operator=(const safe_VkDisplayModeProperties2KHR& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    displayModeProperties = src.displayModeProperties;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkDisplayModeProperties2KHR::~safe_VkDisplayModeProperties2KHR()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkDisplayModeProperties2KHR::initialize(const VkDisplayModeProperties2KHR* in_struct)
{
    sType = in_struct->sType;
    displayModeProperties = in_struct->displayModeProperties;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkDisplayModeProperties2KHR::initialize(const safe_VkDisplayModeProperties2KHR* src)
{
    sType = src->sType;
    displayModeProperties = src->displayModeProperties;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkDisplayPlaneInfo2KHR::safe_VkDisplayPlaneInfo2KHR(const VkDisplayPlaneInfo2KHR* in_struct) :
    sType(in_struct->sType),
    mode(in_struct->mode),
    planeIndex(in_struct->planeIndex)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkDisplayPlaneInfo2KHR::safe_VkDisplayPlaneInfo2KHR() :
    pNext(nullptr)
{}

safe_VkDisplayPlaneInfo2KHR::safe_VkDisplayPlaneInfo2KHR(const safe_VkDisplayPlaneInfo2KHR& src)
{
    sType = src.sType;
    mode = src.mode;
    planeIndex = src.planeIndex;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkDisplayPlaneInfo2KHR& safe_VkDisplayPlaneInfo2KHR::operator=(const safe_VkDisplayPlaneInfo2KHR& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    mode = src.mode;
    planeIndex = src.planeIndex;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkDisplayPlaneInfo2KHR::~safe_VkDisplayPlaneInfo2KHR()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkDisplayPlaneInfo2KHR::initialize(const VkDisplayPlaneInfo2KHR* in_struct)
{
    sType = in_struct->sType;
    mode = in_struct->mode;
    planeIndex = in_struct->planeIndex;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkDisplayPlaneInfo2KHR::initialize(const safe_VkDisplayPlaneInfo2KHR* src)
{
    sType = src->sType;
    mode = src->mode;
    planeIndex = src->planeIndex;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkDisplayPlaneCapabilities2KHR::safe_VkDisplayPlaneCapabilities2KHR(const VkDisplayPlaneCapabilities2KHR* in_struct) :
    sType(in_struct->sType),
    capabilities(in_struct->capabilities)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkDisplayPlaneCapabilities2KHR::safe_VkDisplayPlaneCapabilities2KHR() :
    pNext(nullptr)
{}

safe_VkDisplayPlaneCapabilities2KHR::safe_VkDisplayPlaneCapabilities2KHR(const safe_VkDisplayPlaneCapabilities2KHR& src)
{
    sType = src.sType;
    capabilities = src.capabilities;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkDisplayPlaneCapabilities2KHR& safe_VkDisplayPlaneCapabilities2KHR::operator=(const safe_VkDisplayPlaneCapabilities2KHR& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    capabilities = src.capabilities;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkDisplayPlaneCapabilities2KHR::~safe_VkDisplayPlaneCapabilities2KHR()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkDisplayPlaneCapabilities2KHR::initialize(const VkDisplayPlaneCapabilities2KHR* in_struct)
{
    sType = in_struct->sType;
    capabilities = in_struct->capabilities;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkDisplayPlaneCapabilities2KHR::initialize(const safe_VkDisplayPlaneCapabilities2KHR* src)
{
    sType = src->sType;
    capabilities = src->capabilities;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkImageFormatListCreateInfoKHR::safe_VkImageFormatListCreateInfoKHR(const VkImageFormatListCreateInfoKHR* in_struct) :
    sType(in_struct->sType),
    viewFormatCount(in_struct->viewFormatCount),
    pViewFormats(nullptr)
{
    pNext = SafePnextCopy(in_struct->pNext);
    if (in_struct->pViewFormats) {
        pViewFormats = new VkFormat[in_struct->viewFormatCount];
        memcpy ((void *)pViewFormats, (void *)in_struct->pViewFormats, sizeof(VkFormat)*in_struct->viewFormatCount);
    }
}

safe_VkImageFormatListCreateInfoKHR::safe_VkImageFormatListCreateInfoKHR() :
    pNext(nullptr),
    pViewFormats(nullptr)
{}

safe_VkImageFormatListCreateInfoKHR::safe_VkImageFormatListCreateInfoKHR(const safe_VkImageFormatListCreateInfoKHR& src)
{
    sType = src.sType;
    viewFormatCount = src.viewFormatCount;
    pViewFormats = nullptr;
    pNext = SafePnextCopy(src.pNext);
    if (src.pViewFormats) {
        pViewFormats = new VkFormat[src.viewFormatCount];
        memcpy ((void *)pViewFormats, (void *)src.pViewFormats, sizeof(VkFormat)*src.viewFormatCount);
    }
}

safe_VkImageFormatListCreateInfoKHR& safe_VkImageFormatListCreateInfoKHR::operator=(const safe_VkImageFormatListCreateInfoKHR& src)
{
    if (&src == this) return *this;

    if (pViewFormats)
        delete[] pViewFormats;
    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    viewFormatCount = src.viewFormatCount;
    pViewFormats = nullptr;
    pNext = SafePnextCopy(src.pNext);
    if (src.pViewFormats) {
        pViewFormats = new VkFormat[src.viewFormatCount];
        memcpy ((void *)pViewFormats, (void *)src.pViewFormats, sizeof(VkFormat)*src.viewFormatCount);
    }

    return *this;
}

safe_VkImageFormatListCreateInfoKHR::~safe_VkImageFormatListCreateInfoKHR()
{
    if (pViewFormats)
        delete[] pViewFormats;
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkImageFormatListCreateInfoKHR::initialize(const VkImageFormatListCreateInfoKHR* in_struct)
{
    sType = in_struct->sType;
    viewFormatCount = in_struct->viewFormatCount;
    pViewFormats = nullptr;
    pNext = SafePnextCopy(in_struct->pNext);
    if (in_struct->pViewFormats) {
        pViewFormats = new VkFormat[in_struct->viewFormatCount];
        memcpy ((void *)pViewFormats, (void *)in_struct->pViewFormats, sizeof(VkFormat)*in_struct->viewFormatCount);
    }
}

void safe_VkImageFormatListCreateInfoKHR::initialize(const safe_VkImageFormatListCreateInfoKHR* src)
{
    sType = src->sType;
    viewFormatCount = src->viewFormatCount;
    pViewFormats = nullptr;
    pNext = SafePnextCopy(src->pNext);
    if (src->pViewFormats) {
        pViewFormats = new VkFormat[src->viewFormatCount];
        memcpy ((void *)pViewFormats, (void *)src->pViewFormats, sizeof(VkFormat)*src->viewFormatCount);
    }
}

safe_VkPhysicalDeviceShaderSubgroupExtendedTypesFeaturesKHR::safe_VkPhysicalDeviceShaderSubgroupExtendedTypesFeaturesKHR(const VkPhysicalDeviceShaderSubgroupExtendedTypesFeaturesKHR* in_struct) :
    sType(in_struct->sType),
    shaderSubgroupExtendedTypes(in_struct->shaderSubgroupExtendedTypes)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkPhysicalDeviceShaderSubgroupExtendedTypesFeaturesKHR::safe_VkPhysicalDeviceShaderSubgroupExtendedTypesFeaturesKHR() :
    pNext(nullptr)
{}

safe_VkPhysicalDeviceShaderSubgroupExtendedTypesFeaturesKHR::safe_VkPhysicalDeviceShaderSubgroupExtendedTypesFeaturesKHR(const safe_VkPhysicalDeviceShaderSubgroupExtendedTypesFeaturesKHR& src)
{
    sType = src.sType;
    shaderSubgroupExtendedTypes = src.shaderSubgroupExtendedTypes;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkPhysicalDeviceShaderSubgroupExtendedTypesFeaturesKHR& safe_VkPhysicalDeviceShaderSubgroupExtendedTypesFeaturesKHR::operator=(const safe_VkPhysicalDeviceShaderSubgroupExtendedTypesFeaturesKHR& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    shaderSubgroupExtendedTypes = src.shaderSubgroupExtendedTypes;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkPhysicalDeviceShaderSubgroupExtendedTypesFeaturesKHR::~safe_VkPhysicalDeviceShaderSubgroupExtendedTypesFeaturesKHR()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPhysicalDeviceShaderSubgroupExtendedTypesFeaturesKHR::initialize(const VkPhysicalDeviceShaderSubgroupExtendedTypesFeaturesKHR* in_struct)
{
    sType = in_struct->sType;
    shaderSubgroupExtendedTypes = in_struct->shaderSubgroupExtendedTypes;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkPhysicalDeviceShaderSubgroupExtendedTypesFeaturesKHR::initialize(const safe_VkPhysicalDeviceShaderSubgroupExtendedTypesFeaturesKHR* src)
{
    sType = src->sType;
    shaderSubgroupExtendedTypes = src->shaderSubgroupExtendedTypes;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkPhysicalDevice8BitStorageFeaturesKHR::safe_VkPhysicalDevice8BitStorageFeaturesKHR(const VkPhysicalDevice8BitStorageFeaturesKHR* in_struct) :
    sType(in_struct->sType),
    storageBuffer8BitAccess(in_struct->storageBuffer8BitAccess),
    uniformAndStorageBuffer8BitAccess(in_struct->uniformAndStorageBuffer8BitAccess),
    storagePushConstant8(in_struct->storagePushConstant8)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkPhysicalDevice8BitStorageFeaturesKHR::safe_VkPhysicalDevice8BitStorageFeaturesKHR() :
    pNext(nullptr)
{}

safe_VkPhysicalDevice8BitStorageFeaturesKHR::safe_VkPhysicalDevice8BitStorageFeaturesKHR(const safe_VkPhysicalDevice8BitStorageFeaturesKHR& src)
{
    sType = src.sType;
    storageBuffer8BitAccess = src.storageBuffer8BitAccess;
    uniformAndStorageBuffer8BitAccess = src.uniformAndStorageBuffer8BitAccess;
    storagePushConstant8 = src.storagePushConstant8;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkPhysicalDevice8BitStorageFeaturesKHR& safe_VkPhysicalDevice8BitStorageFeaturesKHR::operator=(const safe_VkPhysicalDevice8BitStorageFeaturesKHR& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    storageBuffer8BitAccess = src.storageBuffer8BitAccess;
    uniformAndStorageBuffer8BitAccess = src.uniformAndStorageBuffer8BitAccess;
    storagePushConstant8 = src.storagePushConstant8;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkPhysicalDevice8BitStorageFeaturesKHR::~safe_VkPhysicalDevice8BitStorageFeaturesKHR()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPhysicalDevice8BitStorageFeaturesKHR::initialize(const VkPhysicalDevice8BitStorageFeaturesKHR* in_struct)
{
    sType = in_struct->sType;
    storageBuffer8BitAccess = in_struct->storageBuffer8BitAccess;
    uniformAndStorageBuffer8BitAccess = in_struct->uniformAndStorageBuffer8BitAccess;
    storagePushConstant8 = in_struct->storagePushConstant8;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkPhysicalDevice8BitStorageFeaturesKHR::initialize(const safe_VkPhysicalDevice8BitStorageFeaturesKHR* src)
{
    sType = src->sType;
    storageBuffer8BitAccess = src->storageBuffer8BitAccess;
    uniformAndStorageBuffer8BitAccess = src->uniformAndStorageBuffer8BitAccess;
    storagePushConstant8 = src->storagePushConstant8;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkPhysicalDeviceShaderAtomicInt64FeaturesKHR::safe_VkPhysicalDeviceShaderAtomicInt64FeaturesKHR(const VkPhysicalDeviceShaderAtomicInt64FeaturesKHR* in_struct) :
    sType(in_struct->sType),
    shaderBufferInt64Atomics(in_struct->shaderBufferInt64Atomics),
    shaderSharedInt64Atomics(in_struct->shaderSharedInt64Atomics)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkPhysicalDeviceShaderAtomicInt64FeaturesKHR::safe_VkPhysicalDeviceShaderAtomicInt64FeaturesKHR() :
    pNext(nullptr)
{}

safe_VkPhysicalDeviceShaderAtomicInt64FeaturesKHR::safe_VkPhysicalDeviceShaderAtomicInt64FeaturesKHR(const safe_VkPhysicalDeviceShaderAtomicInt64FeaturesKHR& src)
{
    sType = src.sType;
    shaderBufferInt64Atomics = src.shaderBufferInt64Atomics;
    shaderSharedInt64Atomics = src.shaderSharedInt64Atomics;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkPhysicalDeviceShaderAtomicInt64FeaturesKHR& safe_VkPhysicalDeviceShaderAtomicInt64FeaturesKHR::operator=(const safe_VkPhysicalDeviceShaderAtomicInt64FeaturesKHR& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    shaderBufferInt64Atomics = src.shaderBufferInt64Atomics;
    shaderSharedInt64Atomics = src.shaderSharedInt64Atomics;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkPhysicalDeviceShaderAtomicInt64FeaturesKHR::~safe_VkPhysicalDeviceShaderAtomicInt64FeaturesKHR()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPhysicalDeviceShaderAtomicInt64FeaturesKHR::initialize(const VkPhysicalDeviceShaderAtomicInt64FeaturesKHR* in_struct)
{
    sType = in_struct->sType;
    shaderBufferInt64Atomics = in_struct->shaderBufferInt64Atomics;
    shaderSharedInt64Atomics = in_struct->shaderSharedInt64Atomics;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkPhysicalDeviceShaderAtomicInt64FeaturesKHR::initialize(const safe_VkPhysicalDeviceShaderAtomicInt64FeaturesKHR* src)
{
    sType = src->sType;
    shaderBufferInt64Atomics = src->shaderBufferInt64Atomics;
    shaderSharedInt64Atomics = src->shaderSharedInt64Atomics;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkPhysicalDeviceShaderClockFeaturesKHR::safe_VkPhysicalDeviceShaderClockFeaturesKHR(const VkPhysicalDeviceShaderClockFeaturesKHR* in_struct) :
    sType(in_struct->sType),
    shaderSubgroupClock(in_struct->shaderSubgroupClock),
    shaderDeviceClock(in_struct->shaderDeviceClock)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkPhysicalDeviceShaderClockFeaturesKHR::safe_VkPhysicalDeviceShaderClockFeaturesKHR() :
    pNext(nullptr)
{}

safe_VkPhysicalDeviceShaderClockFeaturesKHR::safe_VkPhysicalDeviceShaderClockFeaturesKHR(const safe_VkPhysicalDeviceShaderClockFeaturesKHR& src)
{
    sType = src.sType;
    shaderSubgroupClock = src.shaderSubgroupClock;
    shaderDeviceClock = src.shaderDeviceClock;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkPhysicalDeviceShaderClockFeaturesKHR& safe_VkPhysicalDeviceShaderClockFeaturesKHR::operator=(const safe_VkPhysicalDeviceShaderClockFeaturesKHR& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    shaderSubgroupClock = src.shaderSubgroupClock;
    shaderDeviceClock = src.shaderDeviceClock;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkPhysicalDeviceShaderClockFeaturesKHR::~safe_VkPhysicalDeviceShaderClockFeaturesKHR()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPhysicalDeviceShaderClockFeaturesKHR::initialize(const VkPhysicalDeviceShaderClockFeaturesKHR* in_struct)
{
    sType = in_struct->sType;
    shaderSubgroupClock = in_struct->shaderSubgroupClock;
    shaderDeviceClock = in_struct->shaderDeviceClock;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkPhysicalDeviceShaderClockFeaturesKHR::initialize(const safe_VkPhysicalDeviceShaderClockFeaturesKHR* src)
{
    sType = src->sType;
    shaderSubgroupClock = src->shaderSubgroupClock;
    shaderDeviceClock = src->shaderDeviceClock;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkPhysicalDeviceDriverPropertiesKHR::safe_VkPhysicalDeviceDriverPropertiesKHR(const VkPhysicalDeviceDriverPropertiesKHR* in_struct) :
    sType(in_struct->sType),
    driverID(in_struct->driverID),
    conformanceVersion(in_struct->conformanceVersion)
{
    pNext = SafePnextCopy(in_struct->pNext);
    for (uint32_t i = 0; i < VK_MAX_DRIVER_NAME_SIZE_KHR; ++i) {
        driverName[i] = in_struct->driverName[i];
    }
    for (uint32_t i = 0; i < VK_MAX_DRIVER_INFO_SIZE_KHR; ++i) {
        driverInfo[i] = in_struct->driverInfo[i];
    }
}

safe_VkPhysicalDeviceDriverPropertiesKHR::safe_VkPhysicalDeviceDriverPropertiesKHR() :
    pNext(nullptr)
{}

safe_VkPhysicalDeviceDriverPropertiesKHR::safe_VkPhysicalDeviceDriverPropertiesKHR(const safe_VkPhysicalDeviceDriverPropertiesKHR& src)
{
    sType = src.sType;
    driverID = src.driverID;
    conformanceVersion = src.conformanceVersion;
    pNext = SafePnextCopy(src.pNext);
    for (uint32_t i = 0; i < VK_MAX_DRIVER_NAME_SIZE_KHR; ++i) {
        driverName[i] = src.driverName[i];
    }
    for (uint32_t i = 0; i < VK_MAX_DRIVER_INFO_SIZE_KHR; ++i) {
        driverInfo[i] = src.driverInfo[i];
    }
}

safe_VkPhysicalDeviceDriverPropertiesKHR& safe_VkPhysicalDeviceDriverPropertiesKHR::operator=(const safe_VkPhysicalDeviceDriverPropertiesKHR& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    driverID = src.driverID;
    conformanceVersion = src.conformanceVersion;
    pNext = SafePnextCopy(src.pNext);
    for (uint32_t i = 0; i < VK_MAX_DRIVER_NAME_SIZE_KHR; ++i) {
        driverName[i] = src.driverName[i];
    }
    for (uint32_t i = 0; i < VK_MAX_DRIVER_INFO_SIZE_KHR; ++i) {
        driverInfo[i] = src.driverInfo[i];
    }

    return *this;
}

safe_VkPhysicalDeviceDriverPropertiesKHR::~safe_VkPhysicalDeviceDriverPropertiesKHR()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPhysicalDeviceDriverPropertiesKHR::initialize(const VkPhysicalDeviceDriverPropertiesKHR* in_struct)
{
    sType = in_struct->sType;
    driverID = in_struct->driverID;
    conformanceVersion = in_struct->conformanceVersion;
    pNext = SafePnextCopy(in_struct->pNext);
    for (uint32_t i = 0; i < VK_MAX_DRIVER_NAME_SIZE_KHR; ++i) {
        driverName[i] = in_struct->driverName[i];
    }
    for (uint32_t i = 0; i < VK_MAX_DRIVER_INFO_SIZE_KHR; ++i) {
        driverInfo[i] = in_struct->driverInfo[i];
    }
}

void safe_VkPhysicalDeviceDriverPropertiesKHR::initialize(const safe_VkPhysicalDeviceDriverPropertiesKHR* src)
{
    sType = src->sType;
    driverID = src->driverID;
    conformanceVersion = src->conformanceVersion;
    pNext = SafePnextCopy(src->pNext);
    for (uint32_t i = 0; i < VK_MAX_DRIVER_NAME_SIZE_KHR; ++i) {
        driverName[i] = src->driverName[i];
    }
    for (uint32_t i = 0; i < VK_MAX_DRIVER_INFO_SIZE_KHR; ++i) {
        driverInfo[i] = src->driverInfo[i];
    }
}

safe_VkPhysicalDeviceFloatControlsPropertiesKHR::safe_VkPhysicalDeviceFloatControlsPropertiesKHR(const VkPhysicalDeviceFloatControlsPropertiesKHR* in_struct) :
    sType(in_struct->sType),
    denormBehaviorIndependence(in_struct->denormBehaviorIndependence),
    roundingModeIndependence(in_struct->roundingModeIndependence),
    shaderSignedZeroInfNanPreserveFloat16(in_struct->shaderSignedZeroInfNanPreserveFloat16),
    shaderSignedZeroInfNanPreserveFloat32(in_struct->shaderSignedZeroInfNanPreserveFloat32),
    shaderSignedZeroInfNanPreserveFloat64(in_struct->shaderSignedZeroInfNanPreserveFloat64),
    shaderDenormPreserveFloat16(in_struct->shaderDenormPreserveFloat16),
    shaderDenormPreserveFloat32(in_struct->shaderDenormPreserveFloat32),
    shaderDenormPreserveFloat64(in_struct->shaderDenormPreserveFloat64),
    shaderDenormFlushToZeroFloat16(in_struct->shaderDenormFlushToZeroFloat16),
    shaderDenormFlushToZeroFloat32(in_struct->shaderDenormFlushToZeroFloat32),
    shaderDenormFlushToZeroFloat64(in_struct->shaderDenormFlushToZeroFloat64),
    shaderRoundingModeRTEFloat16(in_struct->shaderRoundingModeRTEFloat16),
    shaderRoundingModeRTEFloat32(in_struct->shaderRoundingModeRTEFloat32),
    shaderRoundingModeRTEFloat64(in_struct->shaderRoundingModeRTEFloat64),
    shaderRoundingModeRTZFloat16(in_struct->shaderRoundingModeRTZFloat16),
    shaderRoundingModeRTZFloat32(in_struct->shaderRoundingModeRTZFloat32),
    shaderRoundingModeRTZFloat64(in_struct->shaderRoundingModeRTZFloat64)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkPhysicalDeviceFloatControlsPropertiesKHR::safe_VkPhysicalDeviceFloatControlsPropertiesKHR() :
    pNext(nullptr)
{}

safe_VkPhysicalDeviceFloatControlsPropertiesKHR::safe_VkPhysicalDeviceFloatControlsPropertiesKHR(const safe_VkPhysicalDeviceFloatControlsPropertiesKHR& src)
{
    sType = src.sType;
    denormBehaviorIndependence = src.denormBehaviorIndependence;
    roundingModeIndependence = src.roundingModeIndependence;
    shaderSignedZeroInfNanPreserveFloat16 = src.shaderSignedZeroInfNanPreserveFloat16;
    shaderSignedZeroInfNanPreserveFloat32 = src.shaderSignedZeroInfNanPreserveFloat32;
    shaderSignedZeroInfNanPreserveFloat64 = src.shaderSignedZeroInfNanPreserveFloat64;
    shaderDenormPreserveFloat16 = src.shaderDenormPreserveFloat16;
    shaderDenormPreserveFloat32 = src.shaderDenormPreserveFloat32;
    shaderDenormPreserveFloat64 = src.shaderDenormPreserveFloat64;
    shaderDenormFlushToZeroFloat16 = src.shaderDenormFlushToZeroFloat16;
    shaderDenormFlushToZeroFloat32 = src.shaderDenormFlushToZeroFloat32;
    shaderDenormFlushToZeroFloat64 = src.shaderDenormFlushToZeroFloat64;
    shaderRoundingModeRTEFloat16 = src.shaderRoundingModeRTEFloat16;
    shaderRoundingModeRTEFloat32 = src.shaderRoundingModeRTEFloat32;
    shaderRoundingModeRTEFloat64 = src.shaderRoundingModeRTEFloat64;
    shaderRoundingModeRTZFloat16 = src.shaderRoundingModeRTZFloat16;
    shaderRoundingModeRTZFloat32 = src.shaderRoundingModeRTZFloat32;
    shaderRoundingModeRTZFloat64 = src.shaderRoundingModeRTZFloat64;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkPhysicalDeviceFloatControlsPropertiesKHR& safe_VkPhysicalDeviceFloatControlsPropertiesKHR::operator=(const safe_VkPhysicalDeviceFloatControlsPropertiesKHR& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    denormBehaviorIndependence = src.denormBehaviorIndependence;
    roundingModeIndependence = src.roundingModeIndependence;
    shaderSignedZeroInfNanPreserveFloat16 = src.shaderSignedZeroInfNanPreserveFloat16;
    shaderSignedZeroInfNanPreserveFloat32 = src.shaderSignedZeroInfNanPreserveFloat32;
    shaderSignedZeroInfNanPreserveFloat64 = src.shaderSignedZeroInfNanPreserveFloat64;
    shaderDenormPreserveFloat16 = src.shaderDenormPreserveFloat16;
    shaderDenormPreserveFloat32 = src.shaderDenormPreserveFloat32;
    shaderDenormPreserveFloat64 = src.shaderDenormPreserveFloat64;
    shaderDenormFlushToZeroFloat16 = src.shaderDenormFlushToZeroFloat16;
    shaderDenormFlushToZeroFloat32 = src.shaderDenormFlushToZeroFloat32;
    shaderDenormFlushToZeroFloat64 = src.shaderDenormFlushToZeroFloat64;
    shaderRoundingModeRTEFloat16 = src.shaderRoundingModeRTEFloat16;
    shaderRoundingModeRTEFloat32 = src.shaderRoundingModeRTEFloat32;
    shaderRoundingModeRTEFloat64 = src.shaderRoundingModeRTEFloat64;
    shaderRoundingModeRTZFloat16 = src.shaderRoundingModeRTZFloat16;
    shaderRoundingModeRTZFloat32 = src.shaderRoundingModeRTZFloat32;
    shaderRoundingModeRTZFloat64 = src.shaderRoundingModeRTZFloat64;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkPhysicalDeviceFloatControlsPropertiesKHR::~safe_VkPhysicalDeviceFloatControlsPropertiesKHR()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPhysicalDeviceFloatControlsPropertiesKHR::initialize(const VkPhysicalDeviceFloatControlsPropertiesKHR* in_struct)
{
    sType = in_struct->sType;
    denormBehaviorIndependence = in_struct->denormBehaviorIndependence;
    roundingModeIndependence = in_struct->roundingModeIndependence;
    shaderSignedZeroInfNanPreserveFloat16 = in_struct->shaderSignedZeroInfNanPreserveFloat16;
    shaderSignedZeroInfNanPreserveFloat32 = in_struct->shaderSignedZeroInfNanPreserveFloat32;
    shaderSignedZeroInfNanPreserveFloat64 = in_struct->shaderSignedZeroInfNanPreserveFloat64;
    shaderDenormPreserveFloat16 = in_struct->shaderDenormPreserveFloat16;
    shaderDenormPreserveFloat32 = in_struct->shaderDenormPreserveFloat32;
    shaderDenormPreserveFloat64 = in_struct->shaderDenormPreserveFloat64;
    shaderDenormFlushToZeroFloat16 = in_struct->shaderDenormFlushToZeroFloat16;
    shaderDenormFlushToZeroFloat32 = in_struct->shaderDenormFlushToZeroFloat32;
    shaderDenormFlushToZeroFloat64 = in_struct->shaderDenormFlushToZeroFloat64;
    shaderRoundingModeRTEFloat16 = in_struct->shaderRoundingModeRTEFloat16;
    shaderRoundingModeRTEFloat32 = in_struct->shaderRoundingModeRTEFloat32;
    shaderRoundingModeRTEFloat64 = in_struct->shaderRoundingModeRTEFloat64;
    shaderRoundingModeRTZFloat16 = in_struct->shaderRoundingModeRTZFloat16;
    shaderRoundingModeRTZFloat32 = in_struct->shaderRoundingModeRTZFloat32;
    shaderRoundingModeRTZFloat64 = in_struct->shaderRoundingModeRTZFloat64;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkPhysicalDeviceFloatControlsPropertiesKHR::initialize(const safe_VkPhysicalDeviceFloatControlsPropertiesKHR* src)
{
    sType = src->sType;
    denormBehaviorIndependence = src->denormBehaviorIndependence;
    roundingModeIndependence = src->roundingModeIndependence;
    shaderSignedZeroInfNanPreserveFloat16 = src->shaderSignedZeroInfNanPreserveFloat16;
    shaderSignedZeroInfNanPreserveFloat32 = src->shaderSignedZeroInfNanPreserveFloat32;
    shaderSignedZeroInfNanPreserveFloat64 = src->shaderSignedZeroInfNanPreserveFloat64;
    shaderDenormPreserveFloat16 = src->shaderDenormPreserveFloat16;
    shaderDenormPreserveFloat32 = src->shaderDenormPreserveFloat32;
    shaderDenormPreserveFloat64 = src->shaderDenormPreserveFloat64;
    shaderDenormFlushToZeroFloat16 = src->shaderDenormFlushToZeroFloat16;
    shaderDenormFlushToZeroFloat32 = src->shaderDenormFlushToZeroFloat32;
    shaderDenormFlushToZeroFloat64 = src->shaderDenormFlushToZeroFloat64;
    shaderRoundingModeRTEFloat16 = src->shaderRoundingModeRTEFloat16;
    shaderRoundingModeRTEFloat32 = src->shaderRoundingModeRTEFloat32;
    shaderRoundingModeRTEFloat64 = src->shaderRoundingModeRTEFloat64;
    shaderRoundingModeRTZFloat16 = src->shaderRoundingModeRTZFloat16;
    shaderRoundingModeRTZFloat32 = src->shaderRoundingModeRTZFloat32;
    shaderRoundingModeRTZFloat64 = src->shaderRoundingModeRTZFloat64;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkSubpassDescriptionDepthStencilResolveKHR::safe_VkSubpassDescriptionDepthStencilResolveKHR(const VkSubpassDescriptionDepthStencilResolveKHR* in_struct) :
    sType(in_struct->sType),
    depthResolveMode(in_struct->depthResolveMode),
    stencilResolveMode(in_struct->stencilResolveMode),
    pDepthStencilResolveAttachment(nullptr)
{
    pNext = SafePnextCopy(in_struct->pNext);
    if (in_struct->pDepthStencilResolveAttachment)
        pDepthStencilResolveAttachment = new safe_VkAttachmentReference2KHR(in_struct->pDepthStencilResolveAttachment);
}

safe_VkSubpassDescriptionDepthStencilResolveKHR::safe_VkSubpassDescriptionDepthStencilResolveKHR() :
    pNext(nullptr),
    pDepthStencilResolveAttachment(nullptr)
{}

safe_VkSubpassDescriptionDepthStencilResolveKHR::safe_VkSubpassDescriptionDepthStencilResolveKHR(const safe_VkSubpassDescriptionDepthStencilResolveKHR& src)
{
    sType = src.sType;
    depthResolveMode = src.depthResolveMode;
    stencilResolveMode = src.stencilResolveMode;
    pDepthStencilResolveAttachment = nullptr;
    pNext = SafePnextCopy(src.pNext);
    if (src.pDepthStencilResolveAttachment)
        pDepthStencilResolveAttachment = new safe_VkAttachmentReference2KHR(*src.pDepthStencilResolveAttachment);
}

safe_VkSubpassDescriptionDepthStencilResolveKHR& safe_VkSubpassDescriptionDepthStencilResolveKHR::operator=(const safe_VkSubpassDescriptionDepthStencilResolveKHR& src)
{
    if (&src == this) return *this;

    if (pDepthStencilResolveAttachment)
        delete pDepthStencilResolveAttachment;
    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    depthResolveMode = src.depthResolveMode;
    stencilResolveMode = src.stencilResolveMode;
    pDepthStencilResolveAttachment = nullptr;
    pNext = SafePnextCopy(src.pNext);
    if (src.pDepthStencilResolveAttachment)
        pDepthStencilResolveAttachment = new safe_VkAttachmentReference2KHR(*src.pDepthStencilResolveAttachment);

    return *this;
}

safe_VkSubpassDescriptionDepthStencilResolveKHR::~safe_VkSubpassDescriptionDepthStencilResolveKHR()
{
    if (pDepthStencilResolveAttachment)
        delete pDepthStencilResolveAttachment;
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkSubpassDescriptionDepthStencilResolveKHR::initialize(const VkSubpassDescriptionDepthStencilResolveKHR* in_struct)
{
    sType = in_struct->sType;
    depthResolveMode = in_struct->depthResolveMode;
    stencilResolveMode = in_struct->stencilResolveMode;
    pDepthStencilResolveAttachment = nullptr;
    pNext = SafePnextCopy(in_struct->pNext);
    if (in_struct->pDepthStencilResolveAttachment)
        pDepthStencilResolveAttachment = new safe_VkAttachmentReference2KHR(in_struct->pDepthStencilResolveAttachment);
}

void safe_VkSubpassDescriptionDepthStencilResolveKHR::initialize(const safe_VkSubpassDescriptionDepthStencilResolveKHR* src)
{
    sType = src->sType;
    depthResolveMode = src->depthResolveMode;
    stencilResolveMode = src->stencilResolveMode;
    pDepthStencilResolveAttachment = nullptr;
    pNext = SafePnextCopy(src->pNext);
    if (src->pDepthStencilResolveAttachment)
        pDepthStencilResolveAttachment = new safe_VkAttachmentReference2KHR(*src->pDepthStencilResolveAttachment);
}

safe_VkPhysicalDeviceDepthStencilResolvePropertiesKHR::safe_VkPhysicalDeviceDepthStencilResolvePropertiesKHR(const VkPhysicalDeviceDepthStencilResolvePropertiesKHR* in_struct) :
    sType(in_struct->sType),
    supportedDepthResolveModes(in_struct->supportedDepthResolveModes),
    supportedStencilResolveModes(in_struct->supportedStencilResolveModes),
    independentResolveNone(in_struct->independentResolveNone),
    independentResolve(in_struct->independentResolve)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkPhysicalDeviceDepthStencilResolvePropertiesKHR::safe_VkPhysicalDeviceDepthStencilResolvePropertiesKHR() :
    pNext(nullptr)
{}

safe_VkPhysicalDeviceDepthStencilResolvePropertiesKHR::safe_VkPhysicalDeviceDepthStencilResolvePropertiesKHR(const safe_VkPhysicalDeviceDepthStencilResolvePropertiesKHR& src)
{
    sType = src.sType;
    supportedDepthResolveModes = src.supportedDepthResolveModes;
    supportedStencilResolveModes = src.supportedStencilResolveModes;
    independentResolveNone = src.independentResolveNone;
    independentResolve = src.independentResolve;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkPhysicalDeviceDepthStencilResolvePropertiesKHR& safe_VkPhysicalDeviceDepthStencilResolvePropertiesKHR::operator=(const safe_VkPhysicalDeviceDepthStencilResolvePropertiesKHR& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    supportedDepthResolveModes = src.supportedDepthResolveModes;
    supportedStencilResolveModes = src.supportedStencilResolveModes;
    independentResolveNone = src.independentResolveNone;
    independentResolve = src.independentResolve;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkPhysicalDeviceDepthStencilResolvePropertiesKHR::~safe_VkPhysicalDeviceDepthStencilResolvePropertiesKHR()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPhysicalDeviceDepthStencilResolvePropertiesKHR::initialize(const VkPhysicalDeviceDepthStencilResolvePropertiesKHR* in_struct)
{
    sType = in_struct->sType;
    supportedDepthResolveModes = in_struct->supportedDepthResolveModes;
    supportedStencilResolveModes = in_struct->supportedStencilResolveModes;
    independentResolveNone = in_struct->independentResolveNone;
    independentResolve = in_struct->independentResolve;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkPhysicalDeviceDepthStencilResolvePropertiesKHR::initialize(const safe_VkPhysicalDeviceDepthStencilResolvePropertiesKHR* src)
{
    sType = src->sType;
    supportedDepthResolveModes = src->supportedDepthResolveModes;
    supportedStencilResolveModes = src->supportedStencilResolveModes;
    independentResolveNone = src->independentResolveNone;
    independentResolve = src->independentResolve;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkPhysicalDeviceTimelineSemaphoreFeaturesKHR::safe_VkPhysicalDeviceTimelineSemaphoreFeaturesKHR(const VkPhysicalDeviceTimelineSemaphoreFeaturesKHR* in_struct) :
    sType(in_struct->sType),
    timelineSemaphore(in_struct->timelineSemaphore)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkPhysicalDeviceTimelineSemaphoreFeaturesKHR::safe_VkPhysicalDeviceTimelineSemaphoreFeaturesKHR() :
    pNext(nullptr)
{}

safe_VkPhysicalDeviceTimelineSemaphoreFeaturesKHR::safe_VkPhysicalDeviceTimelineSemaphoreFeaturesKHR(const safe_VkPhysicalDeviceTimelineSemaphoreFeaturesKHR& src)
{
    sType = src.sType;
    timelineSemaphore = src.timelineSemaphore;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkPhysicalDeviceTimelineSemaphoreFeaturesKHR& safe_VkPhysicalDeviceTimelineSemaphoreFeaturesKHR::operator=(const safe_VkPhysicalDeviceTimelineSemaphoreFeaturesKHR& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    timelineSemaphore = src.timelineSemaphore;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkPhysicalDeviceTimelineSemaphoreFeaturesKHR::~safe_VkPhysicalDeviceTimelineSemaphoreFeaturesKHR()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPhysicalDeviceTimelineSemaphoreFeaturesKHR::initialize(const VkPhysicalDeviceTimelineSemaphoreFeaturesKHR* in_struct)
{
    sType = in_struct->sType;
    timelineSemaphore = in_struct->timelineSemaphore;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkPhysicalDeviceTimelineSemaphoreFeaturesKHR::initialize(const safe_VkPhysicalDeviceTimelineSemaphoreFeaturesKHR* src)
{
    sType = src->sType;
    timelineSemaphore = src->timelineSemaphore;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkPhysicalDeviceTimelineSemaphorePropertiesKHR::safe_VkPhysicalDeviceTimelineSemaphorePropertiesKHR(const VkPhysicalDeviceTimelineSemaphorePropertiesKHR* in_struct) :
    sType(in_struct->sType),
    maxTimelineSemaphoreValueDifference(in_struct->maxTimelineSemaphoreValueDifference)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkPhysicalDeviceTimelineSemaphorePropertiesKHR::safe_VkPhysicalDeviceTimelineSemaphorePropertiesKHR() :
    pNext(nullptr)
{}

safe_VkPhysicalDeviceTimelineSemaphorePropertiesKHR::safe_VkPhysicalDeviceTimelineSemaphorePropertiesKHR(const safe_VkPhysicalDeviceTimelineSemaphorePropertiesKHR& src)
{
    sType = src.sType;
    maxTimelineSemaphoreValueDifference = src.maxTimelineSemaphoreValueDifference;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkPhysicalDeviceTimelineSemaphorePropertiesKHR& safe_VkPhysicalDeviceTimelineSemaphorePropertiesKHR::operator=(const safe_VkPhysicalDeviceTimelineSemaphorePropertiesKHR& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    maxTimelineSemaphoreValueDifference = src.maxTimelineSemaphoreValueDifference;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkPhysicalDeviceTimelineSemaphorePropertiesKHR::~safe_VkPhysicalDeviceTimelineSemaphorePropertiesKHR()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPhysicalDeviceTimelineSemaphorePropertiesKHR::initialize(const VkPhysicalDeviceTimelineSemaphorePropertiesKHR* in_struct)
{
    sType = in_struct->sType;
    maxTimelineSemaphoreValueDifference = in_struct->maxTimelineSemaphoreValueDifference;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkPhysicalDeviceTimelineSemaphorePropertiesKHR::initialize(const safe_VkPhysicalDeviceTimelineSemaphorePropertiesKHR* src)
{
    sType = src->sType;
    maxTimelineSemaphoreValueDifference = src->maxTimelineSemaphoreValueDifference;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkSemaphoreTypeCreateInfoKHR::safe_VkSemaphoreTypeCreateInfoKHR(const VkSemaphoreTypeCreateInfoKHR* in_struct) :
    sType(in_struct->sType),
    semaphoreType(in_struct->semaphoreType),
    initialValue(in_struct->initialValue)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkSemaphoreTypeCreateInfoKHR::safe_VkSemaphoreTypeCreateInfoKHR() :
    pNext(nullptr)
{}

safe_VkSemaphoreTypeCreateInfoKHR::safe_VkSemaphoreTypeCreateInfoKHR(const safe_VkSemaphoreTypeCreateInfoKHR& src)
{
    sType = src.sType;
    semaphoreType = src.semaphoreType;
    initialValue = src.initialValue;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkSemaphoreTypeCreateInfoKHR& safe_VkSemaphoreTypeCreateInfoKHR::operator=(const safe_VkSemaphoreTypeCreateInfoKHR& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    semaphoreType = src.semaphoreType;
    initialValue = src.initialValue;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkSemaphoreTypeCreateInfoKHR::~safe_VkSemaphoreTypeCreateInfoKHR()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkSemaphoreTypeCreateInfoKHR::initialize(const VkSemaphoreTypeCreateInfoKHR* in_struct)
{
    sType = in_struct->sType;
    semaphoreType = in_struct->semaphoreType;
    initialValue = in_struct->initialValue;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkSemaphoreTypeCreateInfoKHR::initialize(const safe_VkSemaphoreTypeCreateInfoKHR* src)
{
    sType = src->sType;
    semaphoreType = src->semaphoreType;
    initialValue = src->initialValue;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkTimelineSemaphoreSubmitInfoKHR::safe_VkTimelineSemaphoreSubmitInfoKHR(const VkTimelineSemaphoreSubmitInfoKHR* in_struct) :
    sType(in_struct->sType),
    waitSemaphoreValueCount(in_struct->waitSemaphoreValueCount),
    pWaitSemaphoreValues(nullptr),
    signalSemaphoreValueCount(in_struct->signalSemaphoreValueCount),
    pSignalSemaphoreValues(nullptr)
{
    pNext = SafePnextCopy(in_struct->pNext);
    if (in_struct->pWaitSemaphoreValues) {
        pWaitSemaphoreValues = new uint64_t[in_struct->waitSemaphoreValueCount];
        memcpy ((void *)pWaitSemaphoreValues, (void *)in_struct->pWaitSemaphoreValues, sizeof(uint64_t)*in_struct->waitSemaphoreValueCount);
    }
    if (in_struct->pSignalSemaphoreValues) {
        pSignalSemaphoreValues = new uint64_t[in_struct->signalSemaphoreValueCount];
        memcpy ((void *)pSignalSemaphoreValues, (void *)in_struct->pSignalSemaphoreValues, sizeof(uint64_t)*in_struct->signalSemaphoreValueCount);
    }
}

safe_VkTimelineSemaphoreSubmitInfoKHR::safe_VkTimelineSemaphoreSubmitInfoKHR() :
    pNext(nullptr),
    pWaitSemaphoreValues(nullptr),
    pSignalSemaphoreValues(nullptr)
{}

safe_VkTimelineSemaphoreSubmitInfoKHR::safe_VkTimelineSemaphoreSubmitInfoKHR(const safe_VkTimelineSemaphoreSubmitInfoKHR& src)
{
    sType = src.sType;
    waitSemaphoreValueCount = src.waitSemaphoreValueCount;
    pWaitSemaphoreValues = nullptr;
    signalSemaphoreValueCount = src.signalSemaphoreValueCount;
    pSignalSemaphoreValues = nullptr;
    pNext = SafePnextCopy(src.pNext);
    if (src.pWaitSemaphoreValues) {
        pWaitSemaphoreValues = new uint64_t[src.waitSemaphoreValueCount];
        memcpy ((void *)pWaitSemaphoreValues, (void *)src.pWaitSemaphoreValues, sizeof(uint64_t)*src.waitSemaphoreValueCount);
    }
    if (src.pSignalSemaphoreValues) {
        pSignalSemaphoreValues = new uint64_t[src.signalSemaphoreValueCount];
        memcpy ((void *)pSignalSemaphoreValues, (void *)src.pSignalSemaphoreValues, sizeof(uint64_t)*src.signalSemaphoreValueCount);
    }
}

safe_VkTimelineSemaphoreSubmitInfoKHR& safe_VkTimelineSemaphoreSubmitInfoKHR::operator=(const safe_VkTimelineSemaphoreSubmitInfoKHR& src)
{
    if (&src == this) return *this;

    if (pWaitSemaphoreValues)
        delete[] pWaitSemaphoreValues;
    if (pSignalSemaphoreValues)
        delete[] pSignalSemaphoreValues;
    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    waitSemaphoreValueCount = src.waitSemaphoreValueCount;
    pWaitSemaphoreValues = nullptr;
    signalSemaphoreValueCount = src.signalSemaphoreValueCount;
    pSignalSemaphoreValues = nullptr;
    pNext = SafePnextCopy(src.pNext);
    if (src.pWaitSemaphoreValues) {
        pWaitSemaphoreValues = new uint64_t[src.waitSemaphoreValueCount];
        memcpy ((void *)pWaitSemaphoreValues, (void *)src.pWaitSemaphoreValues, sizeof(uint64_t)*src.waitSemaphoreValueCount);
    }
    if (src.pSignalSemaphoreValues) {
        pSignalSemaphoreValues = new uint64_t[src.signalSemaphoreValueCount];
        memcpy ((void *)pSignalSemaphoreValues, (void *)src.pSignalSemaphoreValues, sizeof(uint64_t)*src.signalSemaphoreValueCount);
    }

    return *this;
}

safe_VkTimelineSemaphoreSubmitInfoKHR::~safe_VkTimelineSemaphoreSubmitInfoKHR()
{
    if (pWaitSemaphoreValues)
        delete[] pWaitSemaphoreValues;
    if (pSignalSemaphoreValues)
        delete[] pSignalSemaphoreValues;
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkTimelineSemaphoreSubmitInfoKHR::initialize(const VkTimelineSemaphoreSubmitInfoKHR* in_struct)
{
    sType = in_struct->sType;
    waitSemaphoreValueCount = in_struct->waitSemaphoreValueCount;
    pWaitSemaphoreValues = nullptr;
    signalSemaphoreValueCount = in_struct->signalSemaphoreValueCount;
    pSignalSemaphoreValues = nullptr;
    pNext = SafePnextCopy(in_struct->pNext);
    if (in_struct->pWaitSemaphoreValues) {
        pWaitSemaphoreValues = new uint64_t[in_struct->waitSemaphoreValueCount];
        memcpy ((void *)pWaitSemaphoreValues, (void *)in_struct->pWaitSemaphoreValues, sizeof(uint64_t)*in_struct->waitSemaphoreValueCount);
    }
    if (in_struct->pSignalSemaphoreValues) {
        pSignalSemaphoreValues = new uint64_t[in_struct->signalSemaphoreValueCount];
        memcpy ((void *)pSignalSemaphoreValues, (void *)in_struct->pSignalSemaphoreValues, sizeof(uint64_t)*in_struct->signalSemaphoreValueCount);
    }
}

void safe_VkTimelineSemaphoreSubmitInfoKHR::initialize(const safe_VkTimelineSemaphoreSubmitInfoKHR* src)
{
    sType = src->sType;
    waitSemaphoreValueCount = src->waitSemaphoreValueCount;
    pWaitSemaphoreValues = nullptr;
    signalSemaphoreValueCount = src->signalSemaphoreValueCount;
    pSignalSemaphoreValues = nullptr;
    pNext = SafePnextCopy(src->pNext);
    if (src->pWaitSemaphoreValues) {
        pWaitSemaphoreValues = new uint64_t[src->waitSemaphoreValueCount];
        memcpy ((void *)pWaitSemaphoreValues, (void *)src->pWaitSemaphoreValues, sizeof(uint64_t)*src->waitSemaphoreValueCount);
    }
    if (src->pSignalSemaphoreValues) {
        pSignalSemaphoreValues = new uint64_t[src->signalSemaphoreValueCount];
        memcpy ((void *)pSignalSemaphoreValues, (void *)src->pSignalSemaphoreValues, sizeof(uint64_t)*src->signalSemaphoreValueCount);
    }
}

safe_VkSemaphoreWaitInfoKHR::safe_VkSemaphoreWaitInfoKHR(const VkSemaphoreWaitInfoKHR* in_struct) :
    sType(in_struct->sType),
    flags(in_struct->flags),
    semaphoreCount(in_struct->semaphoreCount),
    pSemaphores(nullptr),
    pValues(nullptr)
{
    pNext = SafePnextCopy(in_struct->pNext);
    if (semaphoreCount && in_struct->pSemaphores) {
        pSemaphores = new VkSemaphore[semaphoreCount];
        for (uint32_t i = 0; i < semaphoreCount; ++i) {
            pSemaphores[i] = in_struct->pSemaphores[i];
        }
    }
    if (in_struct->pValues) {
        pValues = new uint64_t[in_struct->semaphoreCount];
        memcpy ((void *)pValues, (void *)in_struct->pValues, sizeof(uint64_t)*in_struct->semaphoreCount);
    }
}

safe_VkSemaphoreWaitInfoKHR::safe_VkSemaphoreWaitInfoKHR() :
    pNext(nullptr),
    pSemaphores(nullptr),
    pValues(nullptr)
{}

safe_VkSemaphoreWaitInfoKHR::safe_VkSemaphoreWaitInfoKHR(const safe_VkSemaphoreWaitInfoKHR& src)
{
    sType = src.sType;
    flags = src.flags;
    semaphoreCount = src.semaphoreCount;
    pSemaphores = nullptr;
    pValues = nullptr;
    pNext = SafePnextCopy(src.pNext);
    if (semaphoreCount && src.pSemaphores) {
        pSemaphores = new VkSemaphore[semaphoreCount];
        for (uint32_t i = 0; i < semaphoreCount; ++i) {
            pSemaphores[i] = src.pSemaphores[i];
        }
    }
    if (src.pValues) {
        pValues = new uint64_t[src.semaphoreCount];
        memcpy ((void *)pValues, (void *)src.pValues, sizeof(uint64_t)*src.semaphoreCount);
    }
}

safe_VkSemaphoreWaitInfoKHR& safe_VkSemaphoreWaitInfoKHR::operator=(const safe_VkSemaphoreWaitInfoKHR& src)
{
    if (&src == this) return *this;

    if (pSemaphores)
        delete[] pSemaphores;
    if (pValues)
        delete[] pValues;
    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    flags = src.flags;
    semaphoreCount = src.semaphoreCount;
    pSemaphores = nullptr;
    pValues = nullptr;
    pNext = SafePnextCopy(src.pNext);
    if (semaphoreCount && src.pSemaphores) {
        pSemaphores = new VkSemaphore[semaphoreCount];
        for (uint32_t i = 0; i < semaphoreCount; ++i) {
            pSemaphores[i] = src.pSemaphores[i];
        }
    }
    if (src.pValues) {
        pValues = new uint64_t[src.semaphoreCount];
        memcpy ((void *)pValues, (void *)src.pValues, sizeof(uint64_t)*src.semaphoreCount);
    }

    return *this;
}

safe_VkSemaphoreWaitInfoKHR::~safe_VkSemaphoreWaitInfoKHR()
{
    if (pSemaphores)
        delete[] pSemaphores;
    if (pValues)
        delete[] pValues;
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkSemaphoreWaitInfoKHR::initialize(const VkSemaphoreWaitInfoKHR* in_struct)
{
    sType = in_struct->sType;
    flags = in_struct->flags;
    semaphoreCount = in_struct->semaphoreCount;
    pSemaphores = nullptr;
    pValues = nullptr;
    pNext = SafePnextCopy(in_struct->pNext);
    if (semaphoreCount && in_struct->pSemaphores) {
        pSemaphores = new VkSemaphore[semaphoreCount];
        for (uint32_t i = 0; i < semaphoreCount; ++i) {
            pSemaphores[i] = in_struct->pSemaphores[i];
        }
    }
    if (in_struct->pValues) {
        pValues = new uint64_t[in_struct->semaphoreCount];
        memcpy ((void *)pValues, (void *)in_struct->pValues, sizeof(uint64_t)*in_struct->semaphoreCount);
    }
}

void safe_VkSemaphoreWaitInfoKHR::initialize(const safe_VkSemaphoreWaitInfoKHR* src)
{
    sType = src->sType;
    flags = src->flags;
    semaphoreCount = src->semaphoreCount;
    pSemaphores = nullptr;
    pValues = nullptr;
    pNext = SafePnextCopy(src->pNext);
    if (semaphoreCount && src->pSemaphores) {
        pSemaphores = new VkSemaphore[semaphoreCount];
        for (uint32_t i = 0; i < semaphoreCount; ++i) {
            pSemaphores[i] = src->pSemaphores[i];
        }
    }
    if (src->pValues) {
        pValues = new uint64_t[src->semaphoreCount];
        memcpy ((void *)pValues, (void *)src->pValues, sizeof(uint64_t)*src->semaphoreCount);
    }
}

safe_VkSemaphoreSignalInfoKHR::safe_VkSemaphoreSignalInfoKHR(const VkSemaphoreSignalInfoKHR* in_struct) :
    sType(in_struct->sType),
    semaphore(in_struct->semaphore),
    value(in_struct->value)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkSemaphoreSignalInfoKHR::safe_VkSemaphoreSignalInfoKHR() :
    pNext(nullptr)
{}

safe_VkSemaphoreSignalInfoKHR::safe_VkSemaphoreSignalInfoKHR(const safe_VkSemaphoreSignalInfoKHR& src)
{
    sType = src.sType;
    semaphore = src.semaphore;
    value = src.value;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkSemaphoreSignalInfoKHR& safe_VkSemaphoreSignalInfoKHR::operator=(const safe_VkSemaphoreSignalInfoKHR& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    semaphore = src.semaphore;
    value = src.value;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkSemaphoreSignalInfoKHR::~safe_VkSemaphoreSignalInfoKHR()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkSemaphoreSignalInfoKHR::initialize(const VkSemaphoreSignalInfoKHR* in_struct)
{
    sType = in_struct->sType;
    semaphore = in_struct->semaphore;
    value = in_struct->value;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkSemaphoreSignalInfoKHR::initialize(const safe_VkSemaphoreSignalInfoKHR* src)
{
    sType = src->sType;
    semaphore = src->semaphore;
    value = src->value;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkPhysicalDeviceVulkanMemoryModelFeaturesKHR::safe_VkPhysicalDeviceVulkanMemoryModelFeaturesKHR(const VkPhysicalDeviceVulkanMemoryModelFeaturesKHR* in_struct) :
    sType(in_struct->sType),
    vulkanMemoryModel(in_struct->vulkanMemoryModel),
    vulkanMemoryModelDeviceScope(in_struct->vulkanMemoryModelDeviceScope),
    vulkanMemoryModelAvailabilityVisibilityChains(in_struct->vulkanMemoryModelAvailabilityVisibilityChains)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkPhysicalDeviceVulkanMemoryModelFeaturesKHR::safe_VkPhysicalDeviceVulkanMemoryModelFeaturesKHR() :
    pNext(nullptr)
{}

safe_VkPhysicalDeviceVulkanMemoryModelFeaturesKHR::safe_VkPhysicalDeviceVulkanMemoryModelFeaturesKHR(const safe_VkPhysicalDeviceVulkanMemoryModelFeaturesKHR& src)
{
    sType = src.sType;
    vulkanMemoryModel = src.vulkanMemoryModel;
    vulkanMemoryModelDeviceScope = src.vulkanMemoryModelDeviceScope;
    vulkanMemoryModelAvailabilityVisibilityChains = src.vulkanMemoryModelAvailabilityVisibilityChains;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkPhysicalDeviceVulkanMemoryModelFeaturesKHR& safe_VkPhysicalDeviceVulkanMemoryModelFeaturesKHR::operator=(const safe_VkPhysicalDeviceVulkanMemoryModelFeaturesKHR& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    vulkanMemoryModel = src.vulkanMemoryModel;
    vulkanMemoryModelDeviceScope = src.vulkanMemoryModelDeviceScope;
    vulkanMemoryModelAvailabilityVisibilityChains = src.vulkanMemoryModelAvailabilityVisibilityChains;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkPhysicalDeviceVulkanMemoryModelFeaturesKHR::~safe_VkPhysicalDeviceVulkanMemoryModelFeaturesKHR()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPhysicalDeviceVulkanMemoryModelFeaturesKHR::initialize(const VkPhysicalDeviceVulkanMemoryModelFeaturesKHR* in_struct)
{
    sType = in_struct->sType;
    vulkanMemoryModel = in_struct->vulkanMemoryModel;
    vulkanMemoryModelDeviceScope = in_struct->vulkanMemoryModelDeviceScope;
    vulkanMemoryModelAvailabilityVisibilityChains = in_struct->vulkanMemoryModelAvailabilityVisibilityChains;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkPhysicalDeviceVulkanMemoryModelFeaturesKHR::initialize(const safe_VkPhysicalDeviceVulkanMemoryModelFeaturesKHR* src)
{
    sType = src->sType;
    vulkanMemoryModel = src->vulkanMemoryModel;
    vulkanMemoryModelDeviceScope = src->vulkanMemoryModelDeviceScope;
    vulkanMemoryModelAvailabilityVisibilityChains = src->vulkanMemoryModelAvailabilityVisibilityChains;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkSurfaceProtectedCapabilitiesKHR::safe_VkSurfaceProtectedCapabilitiesKHR(const VkSurfaceProtectedCapabilitiesKHR* in_struct) :
    sType(in_struct->sType),
    supportsProtected(in_struct->supportsProtected)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkSurfaceProtectedCapabilitiesKHR::safe_VkSurfaceProtectedCapabilitiesKHR() :
    pNext(nullptr)
{}

safe_VkSurfaceProtectedCapabilitiesKHR::safe_VkSurfaceProtectedCapabilitiesKHR(const safe_VkSurfaceProtectedCapabilitiesKHR& src)
{
    sType = src.sType;
    supportsProtected = src.supportsProtected;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkSurfaceProtectedCapabilitiesKHR& safe_VkSurfaceProtectedCapabilitiesKHR::operator=(const safe_VkSurfaceProtectedCapabilitiesKHR& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    supportsProtected = src.supportsProtected;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkSurfaceProtectedCapabilitiesKHR::~safe_VkSurfaceProtectedCapabilitiesKHR()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkSurfaceProtectedCapabilitiesKHR::initialize(const VkSurfaceProtectedCapabilitiesKHR* in_struct)
{
    sType = in_struct->sType;
    supportsProtected = in_struct->supportsProtected;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkSurfaceProtectedCapabilitiesKHR::initialize(const safe_VkSurfaceProtectedCapabilitiesKHR* src)
{
    sType = src->sType;
    supportsProtected = src->supportsProtected;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkPhysicalDeviceUniformBufferStandardLayoutFeaturesKHR::safe_VkPhysicalDeviceUniformBufferStandardLayoutFeaturesKHR(const VkPhysicalDeviceUniformBufferStandardLayoutFeaturesKHR* in_struct) :
    sType(in_struct->sType),
    uniformBufferStandardLayout(in_struct->uniformBufferStandardLayout)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkPhysicalDeviceUniformBufferStandardLayoutFeaturesKHR::safe_VkPhysicalDeviceUniformBufferStandardLayoutFeaturesKHR() :
    pNext(nullptr)
{}

safe_VkPhysicalDeviceUniformBufferStandardLayoutFeaturesKHR::safe_VkPhysicalDeviceUniformBufferStandardLayoutFeaturesKHR(const safe_VkPhysicalDeviceUniformBufferStandardLayoutFeaturesKHR& src)
{
    sType = src.sType;
    uniformBufferStandardLayout = src.uniformBufferStandardLayout;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkPhysicalDeviceUniformBufferStandardLayoutFeaturesKHR& safe_VkPhysicalDeviceUniformBufferStandardLayoutFeaturesKHR::operator=(const safe_VkPhysicalDeviceUniformBufferStandardLayoutFeaturesKHR& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    uniformBufferStandardLayout = src.uniformBufferStandardLayout;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkPhysicalDeviceUniformBufferStandardLayoutFeaturesKHR::~safe_VkPhysicalDeviceUniformBufferStandardLayoutFeaturesKHR()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPhysicalDeviceUniformBufferStandardLayoutFeaturesKHR::initialize(const VkPhysicalDeviceUniformBufferStandardLayoutFeaturesKHR* in_struct)
{
    sType = in_struct->sType;
    uniformBufferStandardLayout = in_struct->uniformBufferStandardLayout;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkPhysicalDeviceUniformBufferStandardLayoutFeaturesKHR::initialize(const safe_VkPhysicalDeviceUniformBufferStandardLayoutFeaturesKHR* src)
{
    sType = src->sType;
    uniformBufferStandardLayout = src->uniformBufferStandardLayout;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkPhysicalDevicePipelineExecutablePropertiesFeaturesKHR::safe_VkPhysicalDevicePipelineExecutablePropertiesFeaturesKHR(const VkPhysicalDevicePipelineExecutablePropertiesFeaturesKHR* in_struct) :
    sType(in_struct->sType),
    pipelineExecutableInfo(in_struct->pipelineExecutableInfo)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkPhysicalDevicePipelineExecutablePropertiesFeaturesKHR::safe_VkPhysicalDevicePipelineExecutablePropertiesFeaturesKHR() :
    pNext(nullptr)
{}

safe_VkPhysicalDevicePipelineExecutablePropertiesFeaturesKHR::safe_VkPhysicalDevicePipelineExecutablePropertiesFeaturesKHR(const safe_VkPhysicalDevicePipelineExecutablePropertiesFeaturesKHR& src)
{
    sType = src.sType;
    pipelineExecutableInfo = src.pipelineExecutableInfo;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkPhysicalDevicePipelineExecutablePropertiesFeaturesKHR& safe_VkPhysicalDevicePipelineExecutablePropertiesFeaturesKHR::operator=(const safe_VkPhysicalDevicePipelineExecutablePropertiesFeaturesKHR& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    pipelineExecutableInfo = src.pipelineExecutableInfo;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkPhysicalDevicePipelineExecutablePropertiesFeaturesKHR::~safe_VkPhysicalDevicePipelineExecutablePropertiesFeaturesKHR()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPhysicalDevicePipelineExecutablePropertiesFeaturesKHR::initialize(const VkPhysicalDevicePipelineExecutablePropertiesFeaturesKHR* in_struct)
{
    sType = in_struct->sType;
    pipelineExecutableInfo = in_struct->pipelineExecutableInfo;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkPhysicalDevicePipelineExecutablePropertiesFeaturesKHR::initialize(const safe_VkPhysicalDevicePipelineExecutablePropertiesFeaturesKHR* src)
{
    sType = src->sType;
    pipelineExecutableInfo = src->pipelineExecutableInfo;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkPipelineInfoKHR::safe_VkPipelineInfoKHR(const VkPipelineInfoKHR* in_struct) :
    sType(in_struct->sType),
    pipeline(in_struct->pipeline)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkPipelineInfoKHR::safe_VkPipelineInfoKHR() :
    pNext(nullptr)
{}

safe_VkPipelineInfoKHR::safe_VkPipelineInfoKHR(const safe_VkPipelineInfoKHR& src)
{
    sType = src.sType;
    pipeline = src.pipeline;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkPipelineInfoKHR& safe_VkPipelineInfoKHR::operator=(const safe_VkPipelineInfoKHR& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    pipeline = src.pipeline;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkPipelineInfoKHR::~safe_VkPipelineInfoKHR()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPipelineInfoKHR::initialize(const VkPipelineInfoKHR* in_struct)
{
    sType = in_struct->sType;
    pipeline = in_struct->pipeline;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkPipelineInfoKHR::initialize(const safe_VkPipelineInfoKHR* src)
{
    sType = src->sType;
    pipeline = src->pipeline;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkPipelineExecutablePropertiesKHR::safe_VkPipelineExecutablePropertiesKHR(const VkPipelineExecutablePropertiesKHR* in_struct) :
    sType(in_struct->sType),
    stages(in_struct->stages),
    subgroupSize(in_struct->subgroupSize)
{
    pNext = SafePnextCopy(in_struct->pNext);
    for (uint32_t i = 0; i < VK_MAX_DESCRIPTION_SIZE; ++i) {
        name[i] = in_struct->name[i];
    }
    for (uint32_t i = 0; i < VK_MAX_DESCRIPTION_SIZE; ++i) {
        description[i] = in_struct->description[i];
    }
}

safe_VkPipelineExecutablePropertiesKHR::safe_VkPipelineExecutablePropertiesKHR() :
    pNext(nullptr)
{}

safe_VkPipelineExecutablePropertiesKHR::safe_VkPipelineExecutablePropertiesKHR(const safe_VkPipelineExecutablePropertiesKHR& src)
{
    sType = src.sType;
    stages = src.stages;
    subgroupSize = src.subgroupSize;
    pNext = SafePnextCopy(src.pNext);
    for (uint32_t i = 0; i < VK_MAX_DESCRIPTION_SIZE; ++i) {
        name[i] = src.name[i];
    }
    for (uint32_t i = 0; i < VK_MAX_DESCRIPTION_SIZE; ++i) {
        description[i] = src.description[i];
    }
}

safe_VkPipelineExecutablePropertiesKHR& safe_VkPipelineExecutablePropertiesKHR::operator=(const safe_VkPipelineExecutablePropertiesKHR& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    stages = src.stages;
    subgroupSize = src.subgroupSize;
    pNext = SafePnextCopy(src.pNext);
    for (uint32_t i = 0; i < VK_MAX_DESCRIPTION_SIZE; ++i) {
        name[i] = src.name[i];
    }
    for (uint32_t i = 0; i < VK_MAX_DESCRIPTION_SIZE; ++i) {
        description[i] = src.description[i];
    }

    return *this;
}

safe_VkPipelineExecutablePropertiesKHR::~safe_VkPipelineExecutablePropertiesKHR()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPipelineExecutablePropertiesKHR::initialize(const VkPipelineExecutablePropertiesKHR* in_struct)
{
    sType = in_struct->sType;
    stages = in_struct->stages;
    subgroupSize = in_struct->subgroupSize;
    pNext = SafePnextCopy(in_struct->pNext);
    for (uint32_t i = 0; i < VK_MAX_DESCRIPTION_SIZE; ++i) {
        name[i] = in_struct->name[i];
    }
    for (uint32_t i = 0; i < VK_MAX_DESCRIPTION_SIZE; ++i) {
        description[i] = in_struct->description[i];
    }
}

void safe_VkPipelineExecutablePropertiesKHR::initialize(const safe_VkPipelineExecutablePropertiesKHR* src)
{
    sType = src->sType;
    stages = src->stages;
    subgroupSize = src->subgroupSize;
    pNext = SafePnextCopy(src->pNext);
    for (uint32_t i = 0; i < VK_MAX_DESCRIPTION_SIZE; ++i) {
        name[i] = src->name[i];
    }
    for (uint32_t i = 0; i < VK_MAX_DESCRIPTION_SIZE; ++i) {
        description[i] = src->description[i];
    }
}

safe_VkPipelineExecutableInfoKHR::safe_VkPipelineExecutableInfoKHR(const VkPipelineExecutableInfoKHR* in_struct) :
    sType(in_struct->sType),
    pipeline(in_struct->pipeline),
    executableIndex(in_struct->executableIndex)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkPipelineExecutableInfoKHR::safe_VkPipelineExecutableInfoKHR() :
    pNext(nullptr)
{}

safe_VkPipelineExecutableInfoKHR::safe_VkPipelineExecutableInfoKHR(const safe_VkPipelineExecutableInfoKHR& src)
{
    sType = src.sType;
    pipeline = src.pipeline;
    executableIndex = src.executableIndex;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkPipelineExecutableInfoKHR& safe_VkPipelineExecutableInfoKHR::operator=(const safe_VkPipelineExecutableInfoKHR& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    pipeline = src.pipeline;
    executableIndex = src.executableIndex;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkPipelineExecutableInfoKHR::~safe_VkPipelineExecutableInfoKHR()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPipelineExecutableInfoKHR::initialize(const VkPipelineExecutableInfoKHR* in_struct)
{
    sType = in_struct->sType;
    pipeline = in_struct->pipeline;
    executableIndex = in_struct->executableIndex;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkPipelineExecutableInfoKHR::initialize(const safe_VkPipelineExecutableInfoKHR* src)
{
    sType = src->sType;
    pipeline = src->pipeline;
    executableIndex = src->executableIndex;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkPipelineExecutableStatisticKHR::safe_VkPipelineExecutableStatisticKHR(const VkPipelineExecutableStatisticKHR* in_struct) :
    sType(in_struct->sType),
    format(in_struct->format),
    value(in_struct->value)
{
    pNext = SafePnextCopy(in_struct->pNext);
    for (uint32_t i = 0; i < VK_MAX_DESCRIPTION_SIZE; ++i) {
        name[i] = in_struct->name[i];
    }
    for (uint32_t i = 0; i < VK_MAX_DESCRIPTION_SIZE; ++i) {
        description[i] = in_struct->description[i];
    }
}

safe_VkPipelineExecutableStatisticKHR::safe_VkPipelineExecutableStatisticKHR() :
    pNext(nullptr)
{}

safe_VkPipelineExecutableStatisticKHR::safe_VkPipelineExecutableStatisticKHR(const safe_VkPipelineExecutableStatisticKHR& src)
{
    sType = src.sType;
    format = src.format;
    value = src.value;
    pNext = SafePnextCopy(src.pNext);
    for (uint32_t i = 0; i < VK_MAX_DESCRIPTION_SIZE; ++i) {
        name[i] = src.name[i];
    }
    for (uint32_t i = 0; i < VK_MAX_DESCRIPTION_SIZE; ++i) {
        description[i] = src.description[i];
    }
}

safe_VkPipelineExecutableStatisticKHR& safe_VkPipelineExecutableStatisticKHR::operator=(const safe_VkPipelineExecutableStatisticKHR& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    format = src.format;
    value = src.value;
    pNext = SafePnextCopy(src.pNext);
    for (uint32_t i = 0; i < VK_MAX_DESCRIPTION_SIZE; ++i) {
        name[i] = src.name[i];
    }
    for (uint32_t i = 0; i < VK_MAX_DESCRIPTION_SIZE; ++i) {
        description[i] = src.description[i];
    }

    return *this;
}

safe_VkPipelineExecutableStatisticKHR::~safe_VkPipelineExecutableStatisticKHR()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPipelineExecutableStatisticKHR::initialize(const VkPipelineExecutableStatisticKHR* in_struct)
{
    sType = in_struct->sType;
    format = in_struct->format;
    value = in_struct->value;
    pNext = SafePnextCopy(in_struct->pNext);
    for (uint32_t i = 0; i < VK_MAX_DESCRIPTION_SIZE; ++i) {
        name[i] = in_struct->name[i];
    }
    for (uint32_t i = 0; i < VK_MAX_DESCRIPTION_SIZE; ++i) {
        description[i] = in_struct->description[i];
    }
}

void safe_VkPipelineExecutableStatisticKHR::initialize(const safe_VkPipelineExecutableStatisticKHR* src)
{
    sType = src->sType;
    format = src->format;
    value = src->value;
    pNext = SafePnextCopy(src->pNext);
    for (uint32_t i = 0; i < VK_MAX_DESCRIPTION_SIZE; ++i) {
        name[i] = src->name[i];
    }
    for (uint32_t i = 0; i < VK_MAX_DESCRIPTION_SIZE; ++i) {
        description[i] = src->description[i];
    }
}

safe_VkPipelineExecutableInternalRepresentationKHR::safe_VkPipelineExecutableInternalRepresentationKHR(const VkPipelineExecutableInternalRepresentationKHR* in_struct) :
    sType(in_struct->sType),
    isText(in_struct->isText),
    dataSize(in_struct->dataSize),
    pData(in_struct->pData)
{
    pNext = SafePnextCopy(in_struct->pNext);
    for (uint32_t i = 0; i < VK_MAX_DESCRIPTION_SIZE; ++i) {
        name[i] = in_struct->name[i];
    }
    for (uint32_t i = 0; i < VK_MAX_DESCRIPTION_SIZE; ++i) {
        description[i] = in_struct->description[i];
    }
}

safe_VkPipelineExecutableInternalRepresentationKHR::safe_VkPipelineExecutableInternalRepresentationKHR() :
    pNext(nullptr),
    pData(nullptr)
{}

safe_VkPipelineExecutableInternalRepresentationKHR::safe_VkPipelineExecutableInternalRepresentationKHR(const safe_VkPipelineExecutableInternalRepresentationKHR& src)
{
    sType = src.sType;
    isText = src.isText;
    dataSize = src.dataSize;
    pData = src.pData;
    pNext = SafePnextCopy(src.pNext);
    for (uint32_t i = 0; i < VK_MAX_DESCRIPTION_SIZE; ++i) {
        name[i] = src.name[i];
    }
    for (uint32_t i = 0; i < VK_MAX_DESCRIPTION_SIZE; ++i) {
        description[i] = src.description[i];
    }
}

safe_VkPipelineExecutableInternalRepresentationKHR& safe_VkPipelineExecutableInternalRepresentationKHR::operator=(const safe_VkPipelineExecutableInternalRepresentationKHR& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    isText = src.isText;
    dataSize = src.dataSize;
    pData = src.pData;
    pNext = SafePnextCopy(src.pNext);
    for (uint32_t i = 0; i < VK_MAX_DESCRIPTION_SIZE; ++i) {
        name[i] = src.name[i];
    }
    for (uint32_t i = 0; i < VK_MAX_DESCRIPTION_SIZE; ++i) {
        description[i] = src.description[i];
    }

    return *this;
}

safe_VkPipelineExecutableInternalRepresentationKHR::~safe_VkPipelineExecutableInternalRepresentationKHR()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPipelineExecutableInternalRepresentationKHR::initialize(const VkPipelineExecutableInternalRepresentationKHR* in_struct)
{
    sType = in_struct->sType;
    isText = in_struct->isText;
    dataSize = in_struct->dataSize;
    pData = in_struct->pData;
    pNext = SafePnextCopy(in_struct->pNext);
    for (uint32_t i = 0; i < VK_MAX_DESCRIPTION_SIZE; ++i) {
        name[i] = in_struct->name[i];
    }
    for (uint32_t i = 0; i < VK_MAX_DESCRIPTION_SIZE; ++i) {
        description[i] = in_struct->description[i];
    }
}

void safe_VkPipelineExecutableInternalRepresentationKHR::initialize(const safe_VkPipelineExecutableInternalRepresentationKHR* src)
{
    sType = src->sType;
    isText = src->isText;
    dataSize = src->dataSize;
    pData = src->pData;
    pNext = SafePnextCopy(src->pNext);
    for (uint32_t i = 0; i < VK_MAX_DESCRIPTION_SIZE; ++i) {
        name[i] = src->name[i];
    }
    for (uint32_t i = 0; i < VK_MAX_DESCRIPTION_SIZE; ++i) {
        description[i] = src->description[i];
    }
}

safe_VkDebugReportCallbackCreateInfoEXT::safe_VkDebugReportCallbackCreateInfoEXT(const VkDebugReportCallbackCreateInfoEXT* in_struct) :
    sType(in_struct->sType),
    flags(in_struct->flags),
    pfnCallback(in_struct->pfnCallback),
    pUserData(in_struct->pUserData)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkDebugReportCallbackCreateInfoEXT::safe_VkDebugReportCallbackCreateInfoEXT() :
    pNext(nullptr),
    pUserData(nullptr)
{}

safe_VkDebugReportCallbackCreateInfoEXT::safe_VkDebugReportCallbackCreateInfoEXT(const safe_VkDebugReportCallbackCreateInfoEXT& src)
{
    sType = src.sType;
    flags = src.flags;
    pfnCallback = src.pfnCallback;
    pUserData = src.pUserData;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkDebugReportCallbackCreateInfoEXT& safe_VkDebugReportCallbackCreateInfoEXT::operator=(const safe_VkDebugReportCallbackCreateInfoEXT& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    flags = src.flags;
    pfnCallback = src.pfnCallback;
    pUserData = src.pUserData;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkDebugReportCallbackCreateInfoEXT::~safe_VkDebugReportCallbackCreateInfoEXT()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkDebugReportCallbackCreateInfoEXT::initialize(const VkDebugReportCallbackCreateInfoEXT* in_struct)
{
    sType = in_struct->sType;
    flags = in_struct->flags;
    pfnCallback = in_struct->pfnCallback;
    pUserData = in_struct->pUserData;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkDebugReportCallbackCreateInfoEXT::initialize(const safe_VkDebugReportCallbackCreateInfoEXT* src)
{
    sType = src->sType;
    flags = src->flags;
    pfnCallback = src->pfnCallback;
    pUserData = src->pUserData;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkPipelineRasterizationStateRasterizationOrderAMD::safe_VkPipelineRasterizationStateRasterizationOrderAMD(const VkPipelineRasterizationStateRasterizationOrderAMD* in_struct) :
    sType(in_struct->sType),
    rasterizationOrder(in_struct->rasterizationOrder)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkPipelineRasterizationStateRasterizationOrderAMD::safe_VkPipelineRasterizationStateRasterizationOrderAMD() :
    pNext(nullptr)
{}

safe_VkPipelineRasterizationStateRasterizationOrderAMD::safe_VkPipelineRasterizationStateRasterizationOrderAMD(const safe_VkPipelineRasterizationStateRasterizationOrderAMD& src)
{
    sType = src.sType;
    rasterizationOrder = src.rasterizationOrder;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkPipelineRasterizationStateRasterizationOrderAMD& safe_VkPipelineRasterizationStateRasterizationOrderAMD::operator=(const safe_VkPipelineRasterizationStateRasterizationOrderAMD& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    rasterizationOrder = src.rasterizationOrder;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkPipelineRasterizationStateRasterizationOrderAMD::~safe_VkPipelineRasterizationStateRasterizationOrderAMD()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPipelineRasterizationStateRasterizationOrderAMD::initialize(const VkPipelineRasterizationStateRasterizationOrderAMD* in_struct)
{
    sType = in_struct->sType;
    rasterizationOrder = in_struct->rasterizationOrder;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkPipelineRasterizationStateRasterizationOrderAMD::initialize(const safe_VkPipelineRasterizationStateRasterizationOrderAMD* src)
{
    sType = src->sType;
    rasterizationOrder = src->rasterizationOrder;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkDebugMarkerObjectNameInfoEXT::safe_VkDebugMarkerObjectNameInfoEXT(const VkDebugMarkerObjectNameInfoEXT* in_struct) :
    sType(in_struct->sType),
    objectType(in_struct->objectType),
    object(in_struct->object)
{
    pNext = SafePnextCopy(in_struct->pNext);
    pObjectName = SafeStringCopy(in_struct->pObjectName);
}

safe_VkDebugMarkerObjectNameInfoEXT::safe_VkDebugMarkerObjectNameInfoEXT() :
    pNext(nullptr),
    pObjectName(nullptr)
{}

safe_VkDebugMarkerObjectNameInfoEXT::safe_VkDebugMarkerObjectNameInfoEXT(const safe_VkDebugMarkerObjectNameInfoEXT& src)
{
    sType = src.sType;
    objectType = src.objectType;
    object = src.object;
    pNext = SafePnextCopy(src.pNext);
    pObjectName = SafeStringCopy(src.pObjectName);
}

safe_VkDebugMarkerObjectNameInfoEXT& safe_VkDebugMarkerObjectNameInfoEXT::operator=(const safe_VkDebugMarkerObjectNameInfoEXT& src)
{
    if (&src == this) return *this;

    if (pObjectName) delete [] pObjectName;
    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    objectType = src.objectType;
    object = src.object;
    pNext = SafePnextCopy(src.pNext);
    pObjectName = SafeStringCopy(src.pObjectName);

    return *this;
}

safe_VkDebugMarkerObjectNameInfoEXT::~safe_VkDebugMarkerObjectNameInfoEXT()
{
    if (pObjectName) delete [] pObjectName;
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkDebugMarkerObjectNameInfoEXT::initialize(const VkDebugMarkerObjectNameInfoEXT* in_struct)
{
    sType = in_struct->sType;
    objectType = in_struct->objectType;
    object = in_struct->object;
    pNext = SafePnextCopy(in_struct->pNext);
    pObjectName = SafeStringCopy(in_struct->pObjectName);
}

void safe_VkDebugMarkerObjectNameInfoEXT::initialize(const safe_VkDebugMarkerObjectNameInfoEXT* src)
{
    sType = src->sType;
    objectType = src->objectType;
    object = src->object;
    pNext = SafePnextCopy(src->pNext);
    pObjectName = SafeStringCopy(src->pObjectName);
}

safe_VkDebugMarkerObjectTagInfoEXT::safe_VkDebugMarkerObjectTagInfoEXT(const VkDebugMarkerObjectTagInfoEXT* in_struct) :
    sType(in_struct->sType),
    objectType(in_struct->objectType),
    object(in_struct->object),
    tagName(in_struct->tagName),
    tagSize(in_struct->tagSize),
    pTag(in_struct->pTag)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkDebugMarkerObjectTagInfoEXT::safe_VkDebugMarkerObjectTagInfoEXT() :
    pNext(nullptr),
    pTag(nullptr)
{}

safe_VkDebugMarkerObjectTagInfoEXT::safe_VkDebugMarkerObjectTagInfoEXT(const safe_VkDebugMarkerObjectTagInfoEXT& src)
{
    sType = src.sType;
    objectType = src.objectType;
    object = src.object;
    tagName = src.tagName;
    tagSize = src.tagSize;
    pTag = src.pTag;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkDebugMarkerObjectTagInfoEXT& safe_VkDebugMarkerObjectTagInfoEXT::operator=(const safe_VkDebugMarkerObjectTagInfoEXT& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    objectType = src.objectType;
    object = src.object;
    tagName = src.tagName;
    tagSize = src.tagSize;
    pTag = src.pTag;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkDebugMarkerObjectTagInfoEXT::~safe_VkDebugMarkerObjectTagInfoEXT()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkDebugMarkerObjectTagInfoEXT::initialize(const VkDebugMarkerObjectTagInfoEXT* in_struct)
{
    sType = in_struct->sType;
    objectType = in_struct->objectType;
    object = in_struct->object;
    tagName = in_struct->tagName;
    tagSize = in_struct->tagSize;
    pTag = in_struct->pTag;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkDebugMarkerObjectTagInfoEXT::initialize(const safe_VkDebugMarkerObjectTagInfoEXT* src)
{
    sType = src->sType;
    objectType = src->objectType;
    object = src->object;
    tagName = src->tagName;
    tagSize = src->tagSize;
    pTag = src->pTag;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkDebugMarkerMarkerInfoEXT::safe_VkDebugMarkerMarkerInfoEXT(const VkDebugMarkerMarkerInfoEXT* in_struct) :
    sType(in_struct->sType)
{
    pNext = SafePnextCopy(in_struct->pNext);
    pMarkerName = SafeStringCopy(in_struct->pMarkerName);
    for (uint32_t i = 0; i < 4; ++i) {
        color[i] = in_struct->color[i];
    }
}

safe_VkDebugMarkerMarkerInfoEXT::safe_VkDebugMarkerMarkerInfoEXT() :
    pNext(nullptr),
    pMarkerName(nullptr)
{}

safe_VkDebugMarkerMarkerInfoEXT::safe_VkDebugMarkerMarkerInfoEXT(const safe_VkDebugMarkerMarkerInfoEXT& src)
{
    sType = src.sType;
    pNext = SafePnextCopy(src.pNext);
    pMarkerName = SafeStringCopy(src.pMarkerName);
    for (uint32_t i = 0; i < 4; ++i) {
        color[i] = src.color[i];
    }
}

safe_VkDebugMarkerMarkerInfoEXT& safe_VkDebugMarkerMarkerInfoEXT::operator=(const safe_VkDebugMarkerMarkerInfoEXT& src)
{
    if (&src == this) return *this;

    if (pMarkerName) delete [] pMarkerName;
    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    pNext = SafePnextCopy(src.pNext);
    pMarkerName = SafeStringCopy(src.pMarkerName);
    for (uint32_t i = 0; i < 4; ++i) {
        color[i] = src.color[i];
    }

    return *this;
}

safe_VkDebugMarkerMarkerInfoEXT::~safe_VkDebugMarkerMarkerInfoEXT()
{
    if (pMarkerName) delete [] pMarkerName;
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkDebugMarkerMarkerInfoEXT::initialize(const VkDebugMarkerMarkerInfoEXT* in_struct)
{
    sType = in_struct->sType;
    pNext = SafePnextCopy(in_struct->pNext);
    pMarkerName = SafeStringCopy(in_struct->pMarkerName);
    for (uint32_t i = 0; i < 4; ++i) {
        color[i] = in_struct->color[i];
    }
}

void safe_VkDebugMarkerMarkerInfoEXT::initialize(const safe_VkDebugMarkerMarkerInfoEXT* src)
{
    sType = src->sType;
    pNext = SafePnextCopy(src->pNext);
    pMarkerName = SafeStringCopy(src->pMarkerName);
    for (uint32_t i = 0; i < 4; ++i) {
        color[i] = src->color[i];
    }
}

safe_VkDedicatedAllocationImageCreateInfoNV::safe_VkDedicatedAllocationImageCreateInfoNV(const VkDedicatedAllocationImageCreateInfoNV* in_struct) :
    sType(in_struct->sType),
    dedicatedAllocation(in_struct->dedicatedAllocation)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkDedicatedAllocationImageCreateInfoNV::safe_VkDedicatedAllocationImageCreateInfoNV() :
    pNext(nullptr)
{}

safe_VkDedicatedAllocationImageCreateInfoNV::safe_VkDedicatedAllocationImageCreateInfoNV(const safe_VkDedicatedAllocationImageCreateInfoNV& src)
{
    sType = src.sType;
    dedicatedAllocation = src.dedicatedAllocation;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkDedicatedAllocationImageCreateInfoNV& safe_VkDedicatedAllocationImageCreateInfoNV::operator=(const safe_VkDedicatedAllocationImageCreateInfoNV& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    dedicatedAllocation = src.dedicatedAllocation;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkDedicatedAllocationImageCreateInfoNV::~safe_VkDedicatedAllocationImageCreateInfoNV()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkDedicatedAllocationImageCreateInfoNV::initialize(const VkDedicatedAllocationImageCreateInfoNV* in_struct)
{
    sType = in_struct->sType;
    dedicatedAllocation = in_struct->dedicatedAllocation;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkDedicatedAllocationImageCreateInfoNV::initialize(const safe_VkDedicatedAllocationImageCreateInfoNV* src)
{
    sType = src->sType;
    dedicatedAllocation = src->dedicatedAllocation;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkDedicatedAllocationBufferCreateInfoNV::safe_VkDedicatedAllocationBufferCreateInfoNV(const VkDedicatedAllocationBufferCreateInfoNV* in_struct) :
    sType(in_struct->sType),
    dedicatedAllocation(in_struct->dedicatedAllocation)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkDedicatedAllocationBufferCreateInfoNV::safe_VkDedicatedAllocationBufferCreateInfoNV() :
    pNext(nullptr)
{}

safe_VkDedicatedAllocationBufferCreateInfoNV::safe_VkDedicatedAllocationBufferCreateInfoNV(const safe_VkDedicatedAllocationBufferCreateInfoNV& src)
{
    sType = src.sType;
    dedicatedAllocation = src.dedicatedAllocation;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkDedicatedAllocationBufferCreateInfoNV& safe_VkDedicatedAllocationBufferCreateInfoNV::operator=(const safe_VkDedicatedAllocationBufferCreateInfoNV& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    dedicatedAllocation = src.dedicatedAllocation;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkDedicatedAllocationBufferCreateInfoNV::~safe_VkDedicatedAllocationBufferCreateInfoNV()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkDedicatedAllocationBufferCreateInfoNV::initialize(const VkDedicatedAllocationBufferCreateInfoNV* in_struct)
{
    sType = in_struct->sType;
    dedicatedAllocation = in_struct->dedicatedAllocation;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkDedicatedAllocationBufferCreateInfoNV::initialize(const safe_VkDedicatedAllocationBufferCreateInfoNV* src)
{
    sType = src->sType;
    dedicatedAllocation = src->dedicatedAllocation;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkDedicatedAllocationMemoryAllocateInfoNV::safe_VkDedicatedAllocationMemoryAllocateInfoNV(const VkDedicatedAllocationMemoryAllocateInfoNV* in_struct) :
    sType(in_struct->sType),
    image(in_struct->image),
    buffer(in_struct->buffer)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkDedicatedAllocationMemoryAllocateInfoNV::safe_VkDedicatedAllocationMemoryAllocateInfoNV() :
    pNext(nullptr)
{}

safe_VkDedicatedAllocationMemoryAllocateInfoNV::safe_VkDedicatedAllocationMemoryAllocateInfoNV(const safe_VkDedicatedAllocationMemoryAllocateInfoNV& src)
{
    sType = src.sType;
    image = src.image;
    buffer = src.buffer;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkDedicatedAllocationMemoryAllocateInfoNV& safe_VkDedicatedAllocationMemoryAllocateInfoNV::operator=(const safe_VkDedicatedAllocationMemoryAllocateInfoNV& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    image = src.image;
    buffer = src.buffer;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkDedicatedAllocationMemoryAllocateInfoNV::~safe_VkDedicatedAllocationMemoryAllocateInfoNV()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkDedicatedAllocationMemoryAllocateInfoNV::initialize(const VkDedicatedAllocationMemoryAllocateInfoNV* in_struct)
{
    sType = in_struct->sType;
    image = in_struct->image;
    buffer = in_struct->buffer;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkDedicatedAllocationMemoryAllocateInfoNV::initialize(const safe_VkDedicatedAllocationMemoryAllocateInfoNV* src)
{
    sType = src->sType;
    image = src->image;
    buffer = src->buffer;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkPhysicalDeviceTransformFeedbackFeaturesEXT::safe_VkPhysicalDeviceTransformFeedbackFeaturesEXT(const VkPhysicalDeviceTransformFeedbackFeaturesEXT* in_struct) :
    sType(in_struct->sType),
    transformFeedback(in_struct->transformFeedback),
    geometryStreams(in_struct->geometryStreams)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkPhysicalDeviceTransformFeedbackFeaturesEXT::safe_VkPhysicalDeviceTransformFeedbackFeaturesEXT() :
    pNext(nullptr)
{}

safe_VkPhysicalDeviceTransformFeedbackFeaturesEXT::safe_VkPhysicalDeviceTransformFeedbackFeaturesEXT(const safe_VkPhysicalDeviceTransformFeedbackFeaturesEXT& src)
{
    sType = src.sType;
    transformFeedback = src.transformFeedback;
    geometryStreams = src.geometryStreams;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkPhysicalDeviceTransformFeedbackFeaturesEXT& safe_VkPhysicalDeviceTransformFeedbackFeaturesEXT::operator=(const safe_VkPhysicalDeviceTransformFeedbackFeaturesEXT& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    transformFeedback = src.transformFeedback;
    geometryStreams = src.geometryStreams;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkPhysicalDeviceTransformFeedbackFeaturesEXT::~safe_VkPhysicalDeviceTransformFeedbackFeaturesEXT()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPhysicalDeviceTransformFeedbackFeaturesEXT::initialize(const VkPhysicalDeviceTransformFeedbackFeaturesEXT* in_struct)
{
    sType = in_struct->sType;
    transformFeedback = in_struct->transformFeedback;
    geometryStreams = in_struct->geometryStreams;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkPhysicalDeviceTransformFeedbackFeaturesEXT::initialize(const safe_VkPhysicalDeviceTransformFeedbackFeaturesEXT* src)
{
    sType = src->sType;
    transformFeedback = src->transformFeedback;
    geometryStreams = src->geometryStreams;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkPhysicalDeviceTransformFeedbackPropertiesEXT::safe_VkPhysicalDeviceTransformFeedbackPropertiesEXT(const VkPhysicalDeviceTransformFeedbackPropertiesEXT* in_struct) :
    sType(in_struct->sType),
    maxTransformFeedbackStreams(in_struct->maxTransformFeedbackStreams),
    maxTransformFeedbackBuffers(in_struct->maxTransformFeedbackBuffers),
    maxTransformFeedbackBufferSize(in_struct->maxTransformFeedbackBufferSize),
    maxTransformFeedbackStreamDataSize(in_struct->maxTransformFeedbackStreamDataSize),
    maxTransformFeedbackBufferDataSize(in_struct->maxTransformFeedbackBufferDataSize),
    maxTransformFeedbackBufferDataStride(in_struct->maxTransformFeedbackBufferDataStride),
    transformFeedbackQueries(in_struct->transformFeedbackQueries),
    transformFeedbackStreamsLinesTriangles(in_struct->transformFeedbackStreamsLinesTriangles),
    transformFeedbackRasterizationStreamSelect(in_struct->transformFeedbackRasterizationStreamSelect),
    transformFeedbackDraw(in_struct->transformFeedbackDraw)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkPhysicalDeviceTransformFeedbackPropertiesEXT::safe_VkPhysicalDeviceTransformFeedbackPropertiesEXT() :
    pNext(nullptr)
{}

safe_VkPhysicalDeviceTransformFeedbackPropertiesEXT::safe_VkPhysicalDeviceTransformFeedbackPropertiesEXT(const safe_VkPhysicalDeviceTransformFeedbackPropertiesEXT& src)
{
    sType = src.sType;
    maxTransformFeedbackStreams = src.maxTransformFeedbackStreams;
    maxTransformFeedbackBuffers = src.maxTransformFeedbackBuffers;
    maxTransformFeedbackBufferSize = src.maxTransformFeedbackBufferSize;
    maxTransformFeedbackStreamDataSize = src.maxTransformFeedbackStreamDataSize;
    maxTransformFeedbackBufferDataSize = src.maxTransformFeedbackBufferDataSize;
    maxTransformFeedbackBufferDataStride = src.maxTransformFeedbackBufferDataStride;
    transformFeedbackQueries = src.transformFeedbackQueries;
    transformFeedbackStreamsLinesTriangles = src.transformFeedbackStreamsLinesTriangles;
    transformFeedbackRasterizationStreamSelect = src.transformFeedbackRasterizationStreamSelect;
    transformFeedbackDraw = src.transformFeedbackDraw;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkPhysicalDeviceTransformFeedbackPropertiesEXT& safe_VkPhysicalDeviceTransformFeedbackPropertiesEXT::operator=(const safe_VkPhysicalDeviceTransformFeedbackPropertiesEXT& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    maxTransformFeedbackStreams = src.maxTransformFeedbackStreams;
    maxTransformFeedbackBuffers = src.maxTransformFeedbackBuffers;
    maxTransformFeedbackBufferSize = src.maxTransformFeedbackBufferSize;
    maxTransformFeedbackStreamDataSize = src.maxTransformFeedbackStreamDataSize;
    maxTransformFeedbackBufferDataSize = src.maxTransformFeedbackBufferDataSize;
    maxTransformFeedbackBufferDataStride = src.maxTransformFeedbackBufferDataStride;
    transformFeedbackQueries = src.transformFeedbackQueries;
    transformFeedbackStreamsLinesTriangles = src.transformFeedbackStreamsLinesTriangles;
    transformFeedbackRasterizationStreamSelect = src.transformFeedbackRasterizationStreamSelect;
    transformFeedbackDraw = src.transformFeedbackDraw;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkPhysicalDeviceTransformFeedbackPropertiesEXT::~safe_VkPhysicalDeviceTransformFeedbackPropertiesEXT()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPhysicalDeviceTransformFeedbackPropertiesEXT::initialize(const VkPhysicalDeviceTransformFeedbackPropertiesEXT* in_struct)
{
    sType = in_struct->sType;
    maxTransformFeedbackStreams = in_struct->maxTransformFeedbackStreams;
    maxTransformFeedbackBuffers = in_struct->maxTransformFeedbackBuffers;
    maxTransformFeedbackBufferSize = in_struct->maxTransformFeedbackBufferSize;
    maxTransformFeedbackStreamDataSize = in_struct->maxTransformFeedbackStreamDataSize;
    maxTransformFeedbackBufferDataSize = in_struct->maxTransformFeedbackBufferDataSize;
    maxTransformFeedbackBufferDataStride = in_struct->maxTransformFeedbackBufferDataStride;
    transformFeedbackQueries = in_struct->transformFeedbackQueries;
    transformFeedbackStreamsLinesTriangles = in_struct->transformFeedbackStreamsLinesTriangles;
    transformFeedbackRasterizationStreamSelect = in_struct->transformFeedbackRasterizationStreamSelect;
    transformFeedbackDraw = in_struct->transformFeedbackDraw;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkPhysicalDeviceTransformFeedbackPropertiesEXT::initialize(const safe_VkPhysicalDeviceTransformFeedbackPropertiesEXT* src)
{
    sType = src->sType;
    maxTransformFeedbackStreams = src->maxTransformFeedbackStreams;
    maxTransformFeedbackBuffers = src->maxTransformFeedbackBuffers;
    maxTransformFeedbackBufferSize = src->maxTransformFeedbackBufferSize;
    maxTransformFeedbackStreamDataSize = src->maxTransformFeedbackStreamDataSize;
    maxTransformFeedbackBufferDataSize = src->maxTransformFeedbackBufferDataSize;
    maxTransformFeedbackBufferDataStride = src->maxTransformFeedbackBufferDataStride;
    transformFeedbackQueries = src->transformFeedbackQueries;
    transformFeedbackStreamsLinesTriangles = src->transformFeedbackStreamsLinesTriangles;
    transformFeedbackRasterizationStreamSelect = src->transformFeedbackRasterizationStreamSelect;
    transformFeedbackDraw = src->transformFeedbackDraw;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkPipelineRasterizationStateStreamCreateInfoEXT::safe_VkPipelineRasterizationStateStreamCreateInfoEXT(const VkPipelineRasterizationStateStreamCreateInfoEXT* in_struct) :
    sType(in_struct->sType),
    flags(in_struct->flags),
    rasterizationStream(in_struct->rasterizationStream)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkPipelineRasterizationStateStreamCreateInfoEXT::safe_VkPipelineRasterizationStateStreamCreateInfoEXT() :
    pNext(nullptr)
{}

safe_VkPipelineRasterizationStateStreamCreateInfoEXT::safe_VkPipelineRasterizationStateStreamCreateInfoEXT(const safe_VkPipelineRasterizationStateStreamCreateInfoEXT& src)
{
    sType = src.sType;
    flags = src.flags;
    rasterizationStream = src.rasterizationStream;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkPipelineRasterizationStateStreamCreateInfoEXT& safe_VkPipelineRasterizationStateStreamCreateInfoEXT::operator=(const safe_VkPipelineRasterizationStateStreamCreateInfoEXT& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    flags = src.flags;
    rasterizationStream = src.rasterizationStream;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkPipelineRasterizationStateStreamCreateInfoEXT::~safe_VkPipelineRasterizationStateStreamCreateInfoEXT()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPipelineRasterizationStateStreamCreateInfoEXT::initialize(const VkPipelineRasterizationStateStreamCreateInfoEXT* in_struct)
{
    sType = in_struct->sType;
    flags = in_struct->flags;
    rasterizationStream = in_struct->rasterizationStream;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkPipelineRasterizationStateStreamCreateInfoEXT::initialize(const safe_VkPipelineRasterizationStateStreamCreateInfoEXT* src)
{
    sType = src->sType;
    flags = src->flags;
    rasterizationStream = src->rasterizationStream;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkImageViewHandleInfoNVX::safe_VkImageViewHandleInfoNVX(const VkImageViewHandleInfoNVX* in_struct) :
    sType(in_struct->sType),
    imageView(in_struct->imageView),
    descriptorType(in_struct->descriptorType),
    sampler(in_struct->sampler)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkImageViewHandleInfoNVX::safe_VkImageViewHandleInfoNVX() :
    pNext(nullptr)
{}

safe_VkImageViewHandleInfoNVX::safe_VkImageViewHandleInfoNVX(const safe_VkImageViewHandleInfoNVX& src)
{
    sType = src.sType;
    imageView = src.imageView;
    descriptorType = src.descriptorType;
    sampler = src.sampler;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkImageViewHandleInfoNVX& safe_VkImageViewHandleInfoNVX::operator=(const safe_VkImageViewHandleInfoNVX& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    imageView = src.imageView;
    descriptorType = src.descriptorType;
    sampler = src.sampler;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkImageViewHandleInfoNVX::~safe_VkImageViewHandleInfoNVX()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkImageViewHandleInfoNVX::initialize(const VkImageViewHandleInfoNVX* in_struct)
{
    sType = in_struct->sType;
    imageView = in_struct->imageView;
    descriptorType = in_struct->descriptorType;
    sampler = in_struct->sampler;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkImageViewHandleInfoNVX::initialize(const safe_VkImageViewHandleInfoNVX* src)
{
    sType = src->sType;
    imageView = src->imageView;
    descriptorType = src->descriptorType;
    sampler = src->sampler;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkTextureLODGatherFormatPropertiesAMD::safe_VkTextureLODGatherFormatPropertiesAMD(const VkTextureLODGatherFormatPropertiesAMD* in_struct) :
    sType(in_struct->sType),
    supportsTextureGatherLODBiasAMD(in_struct->supportsTextureGatherLODBiasAMD)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkTextureLODGatherFormatPropertiesAMD::safe_VkTextureLODGatherFormatPropertiesAMD() :
    pNext(nullptr)
{}

safe_VkTextureLODGatherFormatPropertiesAMD::safe_VkTextureLODGatherFormatPropertiesAMD(const safe_VkTextureLODGatherFormatPropertiesAMD& src)
{
    sType = src.sType;
    supportsTextureGatherLODBiasAMD = src.supportsTextureGatherLODBiasAMD;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkTextureLODGatherFormatPropertiesAMD& safe_VkTextureLODGatherFormatPropertiesAMD::operator=(const safe_VkTextureLODGatherFormatPropertiesAMD& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    supportsTextureGatherLODBiasAMD = src.supportsTextureGatherLODBiasAMD;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkTextureLODGatherFormatPropertiesAMD::~safe_VkTextureLODGatherFormatPropertiesAMD()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkTextureLODGatherFormatPropertiesAMD::initialize(const VkTextureLODGatherFormatPropertiesAMD* in_struct)
{
    sType = in_struct->sType;
    supportsTextureGatherLODBiasAMD = in_struct->supportsTextureGatherLODBiasAMD;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkTextureLODGatherFormatPropertiesAMD::initialize(const safe_VkTextureLODGatherFormatPropertiesAMD* src)
{
    sType = src->sType;
    supportsTextureGatherLODBiasAMD = src->supportsTextureGatherLODBiasAMD;
    pNext = SafePnextCopy(src->pNext);
}
#ifdef VK_USE_PLATFORM_GGP


safe_VkStreamDescriptorSurfaceCreateInfoGGP::safe_VkStreamDescriptorSurfaceCreateInfoGGP(const VkStreamDescriptorSurfaceCreateInfoGGP* in_struct) :
    sType(in_struct->sType),
    flags(in_struct->flags),
    streamDescriptor(in_struct->streamDescriptor)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkStreamDescriptorSurfaceCreateInfoGGP::safe_VkStreamDescriptorSurfaceCreateInfoGGP() :
    pNext(nullptr)
{}

safe_VkStreamDescriptorSurfaceCreateInfoGGP::safe_VkStreamDescriptorSurfaceCreateInfoGGP(const safe_VkStreamDescriptorSurfaceCreateInfoGGP& src)
{
    sType = src.sType;
    flags = src.flags;
    streamDescriptor = src.streamDescriptor;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkStreamDescriptorSurfaceCreateInfoGGP& safe_VkStreamDescriptorSurfaceCreateInfoGGP::operator=(const safe_VkStreamDescriptorSurfaceCreateInfoGGP& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    flags = src.flags;
    streamDescriptor = src.streamDescriptor;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkStreamDescriptorSurfaceCreateInfoGGP::~safe_VkStreamDescriptorSurfaceCreateInfoGGP()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkStreamDescriptorSurfaceCreateInfoGGP::initialize(const VkStreamDescriptorSurfaceCreateInfoGGP* in_struct)
{
    sType = in_struct->sType;
    flags = in_struct->flags;
    streamDescriptor = in_struct->streamDescriptor;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkStreamDescriptorSurfaceCreateInfoGGP::initialize(const safe_VkStreamDescriptorSurfaceCreateInfoGGP* src)
{
    sType = src->sType;
    flags = src->flags;
    streamDescriptor = src->streamDescriptor;
    pNext = SafePnextCopy(src->pNext);
}
#endif // VK_USE_PLATFORM_GGP


safe_VkPhysicalDeviceCornerSampledImageFeaturesNV::safe_VkPhysicalDeviceCornerSampledImageFeaturesNV(const VkPhysicalDeviceCornerSampledImageFeaturesNV* in_struct) :
    sType(in_struct->sType),
    cornerSampledImage(in_struct->cornerSampledImage)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkPhysicalDeviceCornerSampledImageFeaturesNV::safe_VkPhysicalDeviceCornerSampledImageFeaturesNV() :
    pNext(nullptr)
{}

safe_VkPhysicalDeviceCornerSampledImageFeaturesNV::safe_VkPhysicalDeviceCornerSampledImageFeaturesNV(const safe_VkPhysicalDeviceCornerSampledImageFeaturesNV& src)
{
    sType = src.sType;
    cornerSampledImage = src.cornerSampledImage;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkPhysicalDeviceCornerSampledImageFeaturesNV& safe_VkPhysicalDeviceCornerSampledImageFeaturesNV::operator=(const safe_VkPhysicalDeviceCornerSampledImageFeaturesNV& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    cornerSampledImage = src.cornerSampledImage;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkPhysicalDeviceCornerSampledImageFeaturesNV::~safe_VkPhysicalDeviceCornerSampledImageFeaturesNV()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPhysicalDeviceCornerSampledImageFeaturesNV::initialize(const VkPhysicalDeviceCornerSampledImageFeaturesNV* in_struct)
{
    sType = in_struct->sType;
    cornerSampledImage = in_struct->cornerSampledImage;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkPhysicalDeviceCornerSampledImageFeaturesNV::initialize(const safe_VkPhysicalDeviceCornerSampledImageFeaturesNV* src)
{
    sType = src->sType;
    cornerSampledImage = src->cornerSampledImage;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkExternalMemoryImageCreateInfoNV::safe_VkExternalMemoryImageCreateInfoNV(const VkExternalMemoryImageCreateInfoNV* in_struct) :
    sType(in_struct->sType),
    handleTypes(in_struct->handleTypes)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkExternalMemoryImageCreateInfoNV::safe_VkExternalMemoryImageCreateInfoNV() :
    pNext(nullptr)
{}

safe_VkExternalMemoryImageCreateInfoNV::safe_VkExternalMemoryImageCreateInfoNV(const safe_VkExternalMemoryImageCreateInfoNV& src)
{
    sType = src.sType;
    handleTypes = src.handleTypes;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkExternalMemoryImageCreateInfoNV& safe_VkExternalMemoryImageCreateInfoNV::operator=(const safe_VkExternalMemoryImageCreateInfoNV& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    handleTypes = src.handleTypes;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkExternalMemoryImageCreateInfoNV::~safe_VkExternalMemoryImageCreateInfoNV()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkExternalMemoryImageCreateInfoNV::initialize(const VkExternalMemoryImageCreateInfoNV* in_struct)
{
    sType = in_struct->sType;
    handleTypes = in_struct->handleTypes;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkExternalMemoryImageCreateInfoNV::initialize(const safe_VkExternalMemoryImageCreateInfoNV* src)
{
    sType = src->sType;
    handleTypes = src->handleTypes;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkExportMemoryAllocateInfoNV::safe_VkExportMemoryAllocateInfoNV(const VkExportMemoryAllocateInfoNV* in_struct) :
    sType(in_struct->sType),
    handleTypes(in_struct->handleTypes)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkExportMemoryAllocateInfoNV::safe_VkExportMemoryAllocateInfoNV() :
    pNext(nullptr)
{}

safe_VkExportMemoryAllocateInfoNV::safe_VkExportMemoryAllocateInfoNV(const safe_VkExportMemoryAllocateInfoNV& src)
{
    sType = src.sType;
    handleTypes = src.handleTypes;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkExportMemoryAllocateInfoNV& safe_VkExportMemoryAllocateInfoNV::operator=(const safe_VkExportMemoryAllocateInfoNV& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    handleTypes = src.handleTypes;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkExportMemoryAllocateInfoNV::~safe_VkExportMemoryAllocateInfoNV()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkExportMemoryAllocateInfoNV::initialize(const VkExportMemoryAllocateInfoNV* in_struct)
{
    sType = in_struct->sType;
    handleTypes = in_struct->handleTypes;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkExportMemoryAllocateInfoNV::initialize(const safe_VkExportMemoryAllocateInfoNV* src)
{
    sType = src->sType;
    handleTypes = src->handleTypes;
    pNext = SafePnextCopy(src->pNext);
}
#ifdef VK_USE_PLATFORM_WIN32_KHR


safe_VkImportMemoryWin32HandleInfoNV::safe_VkImportMemoryWin32HandleInfoNV(const VkImportMemoryWin32HandleInfoNV* in_struct) :
    sType(in_struct->sType),
    handleType(in_struct->handleType),
    handle(in_struct->handle)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkImportMemoryWin32HandleInfoNV::safe_VkImportMemoryWin32HandleInfoNV() :
    pNext(nullptr)
{}

safe_VkImportMemoryWin32HandleInfoNV::safe_VkImportMemoryWin32HandleInfoNV(const safe_VkImportMemoryWin32HandleInfoNV& src)
{
    sType = src.sType;
    handleType = src.handleType;
    handle = src.handle;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkImportMemoryWin32HandleInfoNV& safe_VkImportMemoryWin32HandleInfoNV::operator=(const safe_VkImportMemoryWin32HandleInfoNV& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    handleType = src.handleType;
    handle = src.handle;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkImportMemoryWin32HandleInfoNV::~safe_VkImportMemoryWin32HandleInfoNV()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkImportMemoryWin32HandleInfoNV::initialize(const VkImportMemoryWin32HandleInfoNV* in_struct)
{
    sType = in_struct->sType;
    handleType = in_struct->handleType;
    handle = in_struct->handle;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkImportMemoryWin32HandleInfoNV::initialize(const safe_VkImportMemoryWin32HandleInfoNV* src)
{
    sType = src->sType;
    handleType = src->handleType;
    handle = src->handle;
    pNext = SafePnextCopy(src->pNext);
}
#endif // VK_USE_PLATFORM_WIN32_KHR

#ifdef VK_USE_PLATFORM_WIN32_KHR


safe_VkExportMemoryWin32HandleInfoNV::safe_VkExportMemoryWin32HandleInfoNV(const VkExportMemoryWin32HandleInfoNV* in_struct) :
    sType(in_struct->sType),
    pAttributes(nullptr),
    dwAccess(in_struct->dwAccess)
{
    pNext = SafePnextCopy(in_struct->pNext);
    if (in_struct->pAttributes) {
        pAttributes = new SECURITY_ATTRIBUTES(*in_struct->pAttributes);
    }
}

safe_VkExportMemoryWin32HandleInfoNV::safe_VkExportMemoryWin32HandleInfoNV() :
    pNext(nullptr),
    pAttributes(nullptr)
{}

safe_VkExportMemoryWin32HandleInfoNV::safe_VkExportMemoryWin32HandleInfoNV(const safe_VkExportMemoryWin32HandleInfoNV& src)
{
    sType = src.sType;
    pAttributes = nullptr;
    dwAccess = src.dwAccess;
    pNext = SafePnextCopy(src.pNext);
    if (src.pAttributes) {
        pAttributes = new SECURITY_ATTRIBUTES(*src.pAttributes);
    }
}

safe_VkExportMemoryWin32HandleInfoNV& safe_VkExportMemoryWin32HandleInfoNV::operator=(const safe_VkExportMemoryWin32HandleInfoNV& src)
{
    if (&src == this) return *this;

    if (pAttributes)
        delete pAttributes;
    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    pAttributes = nullptr;
    dwAccess = src.dwAccess;
    pNext = SafePnextCopy(src.pNext);
    if (src.pAttributes) {
        pAttributes = new SECURITY_ATTRIBUTES(*src.pAttributes);
    }

    return *this;
}

safe_VkExportMemoryWin32HandleInfoNV::~safe_VkExportMemoryWin32HandleInfoNV()
{
    if (pAttributes)
        delete pAttributes;
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkExportMemoryWin32HandleInfoNV::initialize(const VkExportMemoryWin32HandleInfoNV* in_struct)
{
    sType = in_struct->sType;
    pAttributes = nullptr;
    dwAccess = in_struct->dwAccess;
    pNext = SafePnextCopy(in_struct->pNext);
    if (in_struct->pAttributes) {
        pAttributes = new SECURITY_ATTRIBUTES(*in_struct->pAttributes);
    }
}

void safe_VkExportMemoryWin32HandleInfoNV::initialize(const safe_VkExportMemoryWin32HandleInfoNV* src)
{
    sType = src->sType;
    pAttributes = nullptr;
    dwAccess = src->dwAccess;
    pNext = SafePnextCopy(src->pNext);
    if (src->pAttributes) {
        pAttributes = new SECURITY_ATTRIBUTES(*src->pAttributes);
    }
}
#endif // VK_USE_PLATFORM_WIN32_KHR

#ifdef VK_USE_PLATFORM_WIN32_KHR


safe_VkWin32KeyedMutexAcquireReleaseInfoNV::safe_VkWin32KeyedMutexAcquireReleaseInfoNV(const VkWin32KeyedMutexAcquireReleaseInfoNV* in_struct) :
    sType(in_struct->sType),
    acquireCount(in_struct->acquireCount),
    pAcquireSyncs(nullptr),
    pAcquireKeys(nullptr),
    pAcquireTimeoutMilliseconds(nullptr),
    releaseCount(in_struct->releaseCount),
    pReleaseSyncs(nullptr),
    pReleaseKeys(nullptr)
{
    pNext = SafePnextCopy(in_struct->pNext);
    if (acquireCount && in_struct->pAcquireSyncs) {
        pAcquireSyncs = new VkDeviceMemory[acquireCount];
        for (uint32_t i = 0; i < acquireCount; ++i) {
            pAcquireSyncs[i] = in_struct->pAcquireSyncs[i];
        }
    }
    if (in_struct->pAcquireKeys) {
        pAcquireKeys = new uint64_t[in_struct->acquireCount];
        memcpy ((void *)pAcquireKeys, (void *)in_struct->pAcquireKeys, sizeof(uint64_t)*in_struct->acquireCount);
    }
    if (in_struct->pAcquireTimeoutMilliseconds) {
        pAcquireTimeoutMilliseconds = new uint32_t[in_struct->acquireCount];
        memcpy ((void *)pAcquireTimeoutMilliseconds, (void *)in_struct->pAcquireTimeoutMilliseconds, sizeof(uint32_t)*in_struct->acquireCount);
    }
    if (releaseCount && in_struct->pReleaseSyncs) {
        pReleaseSyncs = new VkDeviceMemory[releaseCount];
        for (uint32_t i = 0; i < releaseCount; ++i) {
            pReleaseSyncs[i] = in_struct->pReleaseSyncs[i];
        }
    }
    if (in_struct->pReleaseKeys) {
        pReleaseKeys = new uint64_t[in_struct->releaseCount];
        memcpy ((void *)pReleaseKeys, (void *)in_struct->pReleaseKeys, sizeof(uint64_t)*in_struct->releaseCount);
    }
}

safe_VkWin32KeyedMutexAcquireReleaseInfoNV::safe_VkWin32KeyedMutexAcquireReleaseInfoNV() :
    pNext(nullptr),
    pAcquireSyncs(nullptr),
    pAcquireKeys(nullptr),
    pAcquireTimeoutMilliseconds(nullptr),
    pReleaseSyncs(nullptr),
    pReleaseKeys(nullptr)
{}

safe_VkWin32KeyedMutexAcquireReleaseInfoNV::safe_VkWin32KeyedMutexAcquireReleaseInfoNV(const safe_VkWin32KeyedMutexAcquireReleaseInfoNV& src)
{
    sType = src.sType;
    acquireCount = src.acquireCount;
    pAcquireSyncs = nullptr;
    pAcquireKeys = nullptr;
    pAcquireTimeoutMilliseconds = nullptr;
    releaseCount = src.releaseCount;
    pReleaseSyncs = nullptr;
    pReleaseKeys = nullptr;
    pNext = SafePnextCopy(src.pNext);
    if (acquireCount && src.pAcquireSyncs) {
        pAcquireSyncs = new VkDeviceMemory[acquireCount];
        for (uint32_t i = 0; i < acquireCount; ++i) {
            pAcquireSyncs[i] = src.pAcquireSyncs[i];
        }
    }
    if (src.pAcquireKeys) {
        pAcquireKeys = new uint64_t[src.acquireCount];
        memcpy ((void *)pAcquireKeys, (void *)src.pAcquireKeys, sizeof(uint64_t)*src.acquireCount);
    }
    if (src.pAcquireTimeoutMilliseconds) {
        pAcquireTimeoutMilliseconds = new uint32_t[src.acquireCount];
        memcpy ((void *)pAcquireTimeoutMilliseconds, (void *)src.pAcquireTimeoutMilliseconds, sizeof(uint32_t)*src.acquireCount);
    }
    if (releaseCount && src.pReleaseSyncs) {
        pReleaseSyncs = new VkDeviceMemory[releaseCount];
        for (uint32_t i = 0; i < releaseCount; ++i) {
            pReleaseSyncs[i] = src.pReleaseSyncs[i];
        }
    }
    if (src.pReleaseKeys) {
        pReleaseKeys = new uint64_t[src.releaseCount];
        memcpy ((void *)pReleaseKeys, (void *)src.pReleaseKeys, sizeof(uint64_t)*src.releaseCount);
    }
}

safe_VkWin32KeyedMutexAcquireReleaseInfoNV& safe_VkWin32KeyedMutexAcquireReleaseInfoNV::operator=(const safe_VkWin32KeyedMutexAcquireReleaseInfoNV& src)
{
    if (&src == this) return *this;

    if (pAcquireSyncs)
        delete[] pAcquireSyncs;
    if (pAcquireKeys)
        delete[] pAcquireKeys;
    if (pAcquireTimeoutMilliseconds)
        delete[] pAcquireTimeoutMilliseconds;
    if (pReleaseSyncs)
        delete[] pReleaseSyncs;
    if (pReleaseKeys)
        delete[] pReleaseKeys;
    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    acquireCount = src.acquireCount;
    pAcquireSyncs = nullptr;
    pAcquireKeys = nullptr;
    pAcquireTimeoutMilliseconds = nullptr;
    releaseCount = src.releaseCount;
    pReleaseSyncs = nullptr;
    pReleaseKeys = nullptr;
    pNext = SafePnextCopy(src.pNext);
    if (acquireCount && src.pAcquireSyncs) {
        pAcquireSyncs = new VkDeviceMemory[acquireCount];
        for (uint32_t i = 0; i < acquireCount; ++i) {
            pAcquireSyncs[i] = src.pAcquireSyncs[i];
        }
    }
    if (src.pAcquireKeys) {
        pAcquireKeys = new uint64_t[src.acquireCount];
        memcpy ((void *)pAcquireKeys, (void *)src.pAcquireKeys, sizeof(uint64_t)*src.acquireCount);
    }
    if (src.pAcquireTimeoutMilliseconds) {
        pAcquireTimeoutMilliseconds = new uint32_t[src.acquireCount];
        memcpy ((void *)pAcquireTimeoutMilliseconds, (void *)src.pAcquireTimeoutMilliseconds, sizeof(uint32_t)*src.acquireCount);
    }
    if (releaseCount && src.pReleaseSyncs) {
        pReleaseSyncs = new VkDeviceMemory[releaseCount];
        for (uint32_t i = 0; i < releaseCount; ++i) {
            pReleaseSyncs[i] = src.pReleaseSyncs[i];
        }
    }
    if (src.pReleaseKeys) {
        pReleaseKeys = new uint64_t[src.releaseCount];
        memcpy ((void *)pReleaseKeys, (void *)src.pReleaseKeys, sizeof(uint64_t)*src.releaseCount);
    }

    return *this;
}

safe_VkWin32KeyedMutexAcquireReleaseInfoNV::~safe_VkWin32KeyedMutexAcquireReleaseInfoNV()
{
    if (pAcquireSyncs)
        delete[] pAcquireSyncs;
    if (pAcquireKeys)
        delete[] pAcquireKeys;
    if (pAcquireTimeoutMilliseconds)
        delete[] pAcquireTimeoutMilliseconds;
    if (pReleaseSyncs)
        delete[] pReleaseSyncs;
    if (pReleaseKeys)
        delete[] pReleaseKeys;
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkWin32KeyedMutexAcquireReleaseInfoNV::initialize(const VkWin32KeyedMutexAcquireReleaseInfoNV* in_struct)
{
    sType = in_struct->sType;
    acquireCount = in_struct->acquireCount;
    pAcquireSyncs = nullptr;
    pAcquireKeys = nullptr;
    pAcquireTimeoutMilliseconds = nullptr;
    releaseCount = in_struct->releaseCount;
    pReleaseSyncs = nullptr;
    pReleaseKeys = nullptr;
    pNext = SafePnextCopy(in_struct->pNext);
    if (acquireCount && in_struct->pAcquireSyncs) {
        pAcquireSyncs = new VkDeviceMemory[acquireCount];
        for (uint32_t i = 0; i < acquireCount; ++i) {
            pAcquireSyncs[i] = in_struct->pAcquireSyncs[i];
        }
    }
    if (in_struct->pAcquireKeys) {
        pAcquireKeys = new uint64_t[in_struct->acquireCount];
        memcpy ((void *)pAcquireKeys, (void *)in_struct->pAcquireKeys, sizeof(uint64_t)*in_struct->acquireCount);
    }
    if (in_struct->pAcquireTimeoutMilliseconds) {
        pAcquireTimeoutMilliseconds = new uint32_t[in_struct->acquireCount];
        memcpy ((void *)pAcquireTimeoutMilliseconds, (void *)in_struct->pAcquireTimeoutMilliseconds, sizeof(uint32_t)*in_struct->acquireCount);
    }
    if (releaseCount && in_struct->pReleaseSyncs) {
        pReleaseSyncs = new VkDeviceMemory[releaseCount];
        for (uint32_t i = 0; i < releaseCount; ++i) {
            pReleaseSyncs[i] = in_struct->pReleaseSyncs[i];
        }
    }
    if (in_struct->pReleaseKeys) {
        pReleaseKeys = new uint64_t[in_struct->releaseCount];
        memcpy ((void *)pReleaseKeys, (void *)in_struct->pReleaseKeys, sizeof(uint64_t)*in_struct->releaseCount);
    }
}

void safe_VkWin32KeyedMutexAcquireReleaseInfoNV::initialize(const safe_VkWin32KeyedMutexAcquireReleaseInfoNV* src)
{
    sType = src->sType;
    acquireCount = src->acquireCount;
    pAcquireSyncs = nullptr;
    pAcquireKeys = nullptr;
    pAcquireTimeoutMilliseconds = nullptr;
    releaseCount = src->releaseCount;
    pReleaseSyncs = nullptr;
    pReleaseKeys = nullptr;
    pNext = SafePnextCopy(src->pNext);
    if (acquireCount && src->pAcquireSyncs) {
        pAcquireSyncs = new VkDeviceMemory[acquireCount];
        for (uint32_t i = 0; i < acquireCount; ++i) {
            pAcquireSyncs[i] = src->pAcquireSyncs[i];
        }
    }
    if (src->pAcquireKeys) {
        pAcquireKeys = new uint64_t[src->acquireCount];
        memcpy ((void *)pAcquireKeys, (void *)src->pAcquireKeys, sizeof(uint64_t)*src->acquireCount);
    }
    if (src->pAcquireTimeoutMilliseconds) {
        pAcquireTimeoutMilliseconds = new uint32_t[src->acquireCount];
        memcpy ((void *)pAcquireTimeoutMilliseconds, (void *)src->pAcquireTimeoutMilliseconds, sizeof(uint32_t)*src->acquireCount);
    }
    if (releaseCount && src->pReleaseSyncs) {
        pReleaseSyncs = new VkDeviceMemory[releaseCount];
        for (uint32_t i = 0; i < releaseCount; ++i) {
            pReleaseSyncs[i] = src->pReleaseSyncs[i];
        }
    }
    if (src->pReleaseKeys) {
        pReleaseKeys = new uint64_t[src->releaseCount];
        memcpy ((void *)pReleaseKeys, (void *)src->pReleaseKeys, sizeof(uint64_t)*src->releaseCount);
    }
}
#endif // VK_USE_PLATFORM_WIN32_KHR


safe_VkValidationFlagsEXT::safe_VkValidationFlagsEXT(const VkValidationFlagsEXT* in_struct) :
    sType(in_struct->sType),
    disabledValidationCheckCount(in_struct->disabledValidationCheckCount),
    pDisabledValidationChecks(nullptr)
{
    pNext = SafePnextCopy(in_struct->pNext);
    if (in_struct->pDisabledValidationChecks) {
        pDisabledValidationChecks = new VkValidationCheckEXT[in_struct->disabledValidationCheckCount];
        memcpy ((void *)pDisabledValidationChecks, (void *)in_struct->pDisabledValidationChecks, sizeof(VkValidationCheckEXT)*in_struct->disabledValidationCheckCount);
    }
}

safe_VkValidationFlagsEXT::safe_VkValidationFlagsEXT() :
    pNext(nullptr),
    pDisabledValidationChecks(nullptr)
{}

safe_VkValidationFlagsEXT::safe_VkValidationFlagsEXT(const safe_VkValidationFlagsEXT& src)
{
    sType = src.sType;
    disabledValidationCheckCount = src.disabledValidationCheckCount;
    pDisabledValidationChecks = nullptr;
    pNext = SafePnextCopy(src.pNext);
    if (src.pDisabledValidationChecks) {
        pDisabledValidationChecks = new VkValidationCheckEXT[src.disabledValidationCheckCount];
        memcpy ((void *)pDisabledValidationChecks, (void *)src.pDisabledValidationChecks, sizeof(VkValidationCheckEXT)*src.disabledValidationCheckCount);
    }
}

safe_VkValidationFlagsEXT& safe_VkValidationFlagsEXT::operator=(const safe_VkValidationFlagsEXT& src)
{
    if (&src == this) return *this;

    if (pDisabledValidationChecks)
        delete[] pDisabledValidationChecks;
    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    disabledValidationCheckCount = src.disabledValidationCheckCount;
    pDisabledValidationChecks = nullptr;
    pNext = SafePnextCopy(src.pNext);
    if (src.pDisabledValidationChecks) {
        pDisabledValidationChecks = new VkValidationCheckEXT[src.disabledValidationCheckCount];
        memcpy ((void *)pDisabledValidationChecks, (void *)src.pDisabledValidationChecks, sizeof(VkValidationCheckEXT)*src.disabledValidationCheckCount);
    }

    return *this;
}

safe_VkValidationFlagsEXT::~safe_VkValidationFlagsEXT()
{
    if (pDisabledValidationChecks)
        delete[] pDisabledValidationChecks;
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkValidationFlagsEXT::initialize(const VkValidationFlagsEXT* in_struct)
{
    sType = in_struct->sType;
    disabledValidationCheckCount = in_struct->disabledValidationCheckCount;
    pDisabledValidationChecks = nullptr;
    pNext = SafePnextCopy(in_struct->pNext);
    if (in_struct->pDisabledValidationChecks) {
        pDisabledValidationChecks = new VkValidationCheckEXT[in_struct->disabledValidationCheckCount];
        memcpy ((void *)pDisabledValidationChecks, (void *)in_struct->pDisabledValidationChecks, sizeof(VkValidationCheckEXT)*in_struct->disabledValidationCheckCount);
    }
}

void safe_VkValidationFlagsEXT::initialize(const safe_VkValidationFlagsEXT* src)
{
    sType = src->sType;
    disabledValidationCheckCount = src->disabledValidationCheckCount;
    pDisabledValidationChecks = nullptr;
    pNext = SafePnextCopy(src->pNext);
    if (src->pDisabledValidationChecks) {
        pDisabledValidationChecks = new VkValidationCheckEXT[src->disabledValidationCheckCount];
        memcpy ((void *)pDisabledValidationChecks, (void *)src->pDisabledValidationChecks, sizeof(VkValidationCheckEXT)*src->disabledValidationCheckCount);
    }
}
#ifdef VK_USE_PLATFORM_VI_NN


safe_VkViSurfaceCreateInfoNN::safe_VkViSurfaceCreateInfoNN(const VkViSurfaceCreateInfoNN* in_struct) :
    sType(in_struct->sType),
    flags(in_struct->flags),
    window(in_struct->window)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkViSurfaceCreateInfoNN::safe_VkViSurfaceCreateInfoNN() :
    pNext(nullptr),
    window(nullptr)
{}

safe_VkViSurfaceCreateInfoNN::safe_VkViSurfaceCreateInfoNN(const safe_VkViSurfaceCreateInfoNN& src)
{
    sType = src.sType;
    flags = src.flags;
    window = src.window;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkViSurfaceCreateInfoNN& safe_VkViSurfaceCreateInfoNN::operator=(const safe_VkViSurfaceCreateInfoNN& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    flags = src.flags;
    window = src.window;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkViSurfaceCreateInfoNN::~safe_VkViSurfaceCreateInfoNN()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkViSurfaceCreateInfoNN::initialize(const VkViSurfaceCreateInfoNN* in_struct)
{
    sType = in_struct->sType;
    flags = in_struct->flags;
    window = in_struct->window;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkViSurfaceCreateInfoNN::initialize(const safe_VkViSurfaceCreateInfoNN* src)
{
    sType = src->sType;
    flags = src->flags;
    window = src->window;
    pNext = SafePnextCopy(src->pNext);
}
#endif // VK_USE_PLATFORM_VI_NN


safe_VkPhysicalDeviceTextureCompressionASTCHDRFeaturesEXT::safe_VkPhysicalDeviceTextureCompressionASTCHDRFeaturesEXT(const VkPhysicalDeviceTextureCompressionASTCHDRFeaturesEXT* in_struct) :
    sType(in_struct->sType),
    textureCompressionASTC_HDR(in_struct->textureCompressionASTC_HDR)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkPhysicalDeviceTextureCompressionASTCHDRFeaturesEXT::safe_VkPhysicalDeviceTextureCompressionASTCHDRFeaturesEXT() :
    pNext(nullptr)
{}

safe_VkPhysicalDeviceTextureCompressionASTCHDRFeaturesEXT::safe_VkPhysicalDeviceTextureCompressionASTCHDRFeaturesEXT(const safe_VkPhysicalDeviceTextureCompressionASTCHDRFeaturesEXT& src)
{
    sType = src.sType;
    textureCompressionASTC_HDR = src.textureCompressionASTC_HDR;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkPhysicalDeviceTextureCompressionASTCHDRFeaturesEXT& safe_VkPhysicalDeviceTextureCompressionASTCHDRFeaturesEXT::operator=(const safe_VkPhysicalDeviceTextureCompressionASTCHDRFeaturesEXT& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    textureCompressionASTC_HDR = src.textureCompressionASTC_HDR;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkPhysicalDeviceTextureCompressionASTCHDRFeaturesEXT::~safe_VkPhysicalDeviceTextureCompressionASTCHDRFeaturesEXT()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPhysicalDeviceTextureCompressionASTCHDRFeaturesEXT::initialize(const VkPhysicalDeviceTextureCompressionASTCHDRFeaturesEXT* in_struct)
{
    sType = in_struct->sType;
    textureCompressionASTC_HDR = in_struct->textureCompressionASTC_HDR;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkPhysicalDeviceTextureCompressionASTCHDRFeaturesEXT::initialize(const safe_VkPhysicalDeviceTextureCompressionASTCHDRFeaturesEXT* src)
{
    sType = src->sType;
    textureCompressionASTC_HDR = src->textureCompressionASTC_HDR;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkImageViewASTCDecodeModeEXT::safe_VkImageViewASTCDecodeModeEXT(const VkImageViewASTCDecodeModeEXT* in_struct) :
    sType(in_struct->sType),
    decodeMode(in_struct->decodeMode)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkImageViewASTCDecodeModeEXT::safe_VkImageViewASTCDecodeModeEXT() :
    pNext(nullptr)
{}

safe_VkImageViewASTCDecodeModeEXT::safe_VkImageViewASTCDecodeModeEXT(const safe_VkImageViewASTCDecodeModeEXT& src)
{
    sType = src.sType;
    decodeMode = src.decodeMode;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkImageViewASTCDecodeModeEXT& safe_VkImageViewASTCDecodeModeEXT::operator=(const safe_VkImageViewASTCDecodeModeEXT& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    decodeMode = src.decodeMode;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkImageViewASTCDecodeModeEXT::~safe_VkImageViewASTCDecodeModeEXT()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkImageViewASTCDecodeModeEXT::initialize(const VkImageViewASTCDecodeModeEXT* in_struct)
{
    sType = in_struct->sType;
    decodeMode = in_struct->decodeMode;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkImageViewASTCDecodeModeEXT::initialize(const safe_VkImageViewASTCDecodeModeEXT* src)
{
    sType = src->sType;
    decodeMode = src->decodeMode;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkPhysicalDeviceASTCDecodeFeaturesEXT::safe_VkPhysicalDeviceASTCDecodeFeaturesEXT(const VkPhysicalDeviceASTCDecodeFeaturesEXT* in_struct) :
    sType(in_struct->sType),
    decodeModeSharedExponent(in_struct->decodeModeSharedExponent)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkPhysicalDeviceASTCDecodeFeaturesEXT::safe_VkPhysicalDeviceASTCDecodeFeaturesEXT() :
    pNext(nullptr)
{}

safe_VkPhysicalDeviceASTCDecodeFeaturesEXT::safe_VkPhysicalDeviceASTCDecodeFeaturesEXT(const safe_VkPhysicalDeviceASTCDecodeFeaturesEXT& src)
{
    sType = src.sType;
    decodeModeSharedExponent = src.decodeModeSharedExponent;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkPhysicalDeviceASTCDecodeFeaturesEXT& safe_VkPhysicalDeviceASTCDecodeFeaturesEXT::operator=(const safe_VkPhysicalDeviceASTCDecodeFeaturesEXT& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    decodeModeSharedExponent = src.decodeModeSharedExponent;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkPhysicalDeviceASTCDecodeFeaturesEXT::~safe_VkPhysicalDeviceASTCDecodeFeaturesEXT()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPhysicalDeviceASTCDecodeFeaturesEXT::initialize(const VkPhysicalDeviceASTCDecodeFeaturesEXT* in_struct)
{
    sType = in_struct->sType;
    decodeModeSharedExponent = in_struct->decodeModeSharedExponent;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkPhysicalDeviceASTCDecodeFeaturesEXT::initialize(const safe_VkPhysicalDeviceASTCDecodeFeaturesEXT* src)
{
    sType = src->sType;
    decodeModeSharedExponent = src->decodeModeSharedExponent;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkConditionalRenderingBeginInfoEXT::safe_VkConditionalRenderingBeginInfoEXT(const VkConditionalRenderingBeginInfoEXT* in_struct) :
    sType(in_struct->sType),
    buffer(in_struct->buffer),
    offset(in_struct->offset),
    flags(in_struct->flags)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkConditionalRenderingBeginInfoEXT::safe_VkConditionalRenderingBeginInfoEXT() :
    pNext(nullptr)
{}

safe_VkConditionalRenderingBeginInfoEXT::safe_VkConditionalRenderingBeginInfoEXT(const safe_VkConditionalRenderingBeginInfoEXT& src)
{
    sType = src.sType;
    buffer = src.buffer;
    offset = src.offset;
    flags = src.flags;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkConditionalRenderingBeginInfoEXT& safe_VkConditionalRenderingBeginInfoEXT::operator=(const safe_VkConditionalRenderingBeginInfoEXT& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    buffer = src.buffer;
    offset = src.offset;
    flags = src.flags;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkConditionalRenderingBeginInfoEXT::~safe_VkConditionalRenderingBeginInfoEXT()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkConditionalRenderingBeginInfoEXT::initialize(const VkConditionalRenderingBeginInfoEXT* in_struct)
{
    sType = in_struct->sType;
    buffer = in_struct->buffer;
    offset = in_struct->offset;
    flags = in_struct->flags;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkConditionalRenderingBeginInfoEXT::initialize(const safe_VkConditionalRenderingBeginInfoEXT* src)
{
    sType = src->sType;
    buffer = src->buffer;
    offset = src->offset;
    flags = src->flags;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkPhysicalDeviceConditionalRenderingFeaturesEXT::safe_VkPhysicalDeviceConditionalRenderingFeaturesEXT(const VkPhysicalDeviceConditionalRenderingFeaturesEXT* in_struct) :
    sType(in_struct->sType),
    conditionalRendering(in_struct->conditionalRendering),
    inheritedConditionalRendering(in_struct->inheritedConditionalRendering)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkPhysicalDeviceConditionalRenderingFeaturesEXT::safe_VkPhysicalDeviceConditionalRenderingFeaturesEXT() :
    pNext(nullptr)
{}

safe_VkPhysicalDeviceConditionalRenderingFeaturesEXT::safe_VkPhysicalDeviceConditionalRenderingFeaturesEXT(const safe_VkPhysicalDeviceConditionalRenderingFeaturesEXT& src)
{
    sType = src.sType;
    conditionalRendering = src.conditionalRendering;
    inheritedConditionalRendering = src.inheritedConditionalRendering;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkPhysicalDeviceConditionalRenderingFeaturesEXT& safe_VkPhysicalDeviceConditionalRenderingFeaturesEXT::operator=(const safe_VkPhysicalDeviceConditionalRenderingFeaturesEXT& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    conditionalRendering = src.conditionalRendering;
    inheritedConditionalRendering = src.inheritedConditionalRendering;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkPhysicalDeviceConditionalRenderingFeaturesEXT::~safe_VkPhysicalDeviceConditionalRenderingFeaturesEXT()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPhysicalDeviceConditionalRenderingFeaturesEXT::initialize(const VkPhysicalDeviceConditionalRenderingFeaturesEXT* in_struct)
{
    sType = in_struct->sType;
    conditionalRendering = in_struct->conditionalRendering;
    inheritedConditionalRendering = in_struct->inheritedConditionalRendering;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkPhysicalDeviceConditionalRenderingFeaturesEXT::initialize(const safe_VkPhysicalDeviceConditionalRenderingFeaturesEXT* src)
{
    sType = src->sType;
    conditionalRendering = src->conditionalRendering;
    inheritedConditionalRendering = src->inheritedConditionalRendering;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkCommandBufferInheritanceConditionalRenderingInfoEXT::safe_VkCommandBufferInheritanceConditionalRenderingInfoEXT(const VkCommandBufferInheritanceConditionalRenderingInfoEXT* in_struct) :
    sType(in_struct->sType),
    conditionalRenderingEnable(in_struct->conditionalRenderingEnable)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkCommandBufferInheritanceConditionalRenderingInfoEXT::safe_VkCommandBufferInheritanceConditionalRenderingInfoEXT() :
    pNext(nullptr)
{}

safe_VkCommandBufferInheritanceConditionalRenderingInfoEXT::safe_VkCommandBufferInheritanceConditionalRenderingInfoEXT(const safe_VkCommandBufferInheritanceConditionalRenderingInfoEXT& src)
{
    sType = src.sType;
    conditionalRenderingEnable = src.conditionalRenderingEnable;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkCommandBufferInheritanceConditionalRenderingInfoEXT& safe_VkCommandBufferInheritanceConditionalRenderingInfoEXT::operator=(const safe_VkCommandBufferInheritanceConditionalRenderingInfoEXT& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    conditionalRenderingEnable = src.conditionalRenderingEnable;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkCommandBufferInheritanceConditionalRenderingInfoEXT::~safe_VkCommandBufferInheritanceConditionalRenderingInfoEXT()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkCommandBufferInheritanceConditionalRenderingInfoEXT::initialize(const VkCommandBufferInheritanceConditionalRenderingInfoEXT* in_struct)
{
    sType = in_struct->sType;
    conditionalRenderingEnable = in_struct->conditionalRenderingEnable;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkCommandBufferInheritanceConditionalRenderingInfoEXT::initialize(const safe_VkCommandBufferInheritanceConditionalRenderingInfoEXT* src)
{
    sType = src->sType;
    conditionalRenderingEnable = src->conditionalRenderingEnable;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkDeviceGeneratedCommandsFeaturesNVX::safe_VkDeviceGeneratedCommandsFeaturesNVX(const VkDeviceGeneratedCommandsFeaturesNVX* in_struct) :
    sType(in_struct->sType),
    computeBindingPointSupport(in_struct->computeBindingPointSupport)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkDeviceGeneratedCommandsFeaturesNVX::safe_VkDeviceGeneratedCommandsFeaturesNVX() :
    pNext(nullptr)
{}

safe_VkDeviceGeneratedCommandsFeaturesNVX::safe_VkDeviceGeneratedCommandsFeaturesNVX(const safe_VkDeviceGeneratedCommandsFeaturesNVX& src)
{
    sType = src.sType;
    computeBindingPointSupport = src.computeBindingPointSupport;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkDeviceGeneratedCommandsFeaturesNVX& safe_VkDeviceGeneratedCommandsFeaturesNVX::operator=(const safe_VkDeviceGeneratedCommandsFeaturesNVX& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    computeBindingPointSupport = src.computeBindingPointSupport;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkDeviceGeneratedCommandsFeaturesNVX::~safe_VkDeviceGeneratedCommandsFeaturesNVX()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkDeviceGeneratedCommandsFeaturesNVX::initialize(const VkDeviceGeneratedCommandsFeaturesNVX* in_struct)
{
    sType = in_struct->sType;
    computeBindingPointSupport = in_struct->computeBindingPointSupport;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkDeviceGeneratedCommandsFeaturesNVX::initialize(const safe_VkDeviceGeneratedCommandsFeaturesNVX* src)
{
    sType = src->sType;
    computeBindingPointSupport = src->computeBindingPointSupport;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkDeviceGeneratedCommandsLimitsNVX::safe_VkDeviceGeneratedCommandsLimitsNVX(const VkDeviceGeneratedCommandsLimitsNVX* in_struct) :
    sType(in_struct->sType),
    maxIndirectCommandsLayoutTokenCount(in_struct->maxIndirectCommandsLayoutTokenCount),
    maxObjectEntryCounts(in_struct->maxObjectEntryCounts),
    minSequenceCountBufferOffsetAlignment(in_struct->minSequenceCountBufferOffsetAlignment),
    minSequenceIndexBufferOffsetAlignment(in_struct->minSequenceIndexBufferOffsetAlignment),
    minCommandsTokenBufferOffsetAlignment(in_struct->minCommandsTokenBufferOffsetAlignment)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkDeviceGeneratedCommandsLimitsNVX::safe_VkDeviceGeneratedCommandsLimitsNVX() :
    pNext(nullptr)
{}

safe_VkDeviceGeneratedCommandsLimitsNVX::safe_VkDeviceGeneratedCommandsLimitsNVX(const safe_VkDeviceGeneratedCommandsLimitsNVX& src)
{
    sType = src.sType;
    maxIndirectCommandsLayoutTokenCount = src.maxIndirectCommandsLayoutTokenCount;
    maxObjectEntryCounts = src.maxObjectEntryCounts;
    minSequenceCountBufferOffsetAlignment = src.minSequenceCountBufferOffsetAlignment;
    minSequenceIndexBufferOffsetAlignment = src.minSequenceIndexBufferOffsetAlignment;
    minCommandsTokenBufferOffsetAlignment = src.minCommandsTokenBufferOffsetAlignment;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkDeviceGeneratedCommandsLimitsNVX& safe_VkDeviceGeneratedCommandsLimitsNVX::operator=(const safe_VkDeviceGeneratedCommandsLimitsNVX& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    maxIndirectCommandsLayoutTokenCount = src.maxIndirectCommandsLayoutTokenCount;
    maxObjectEntryCounts = src.maxObjectEntryCounts;
    minSequenceCountBufferOffsetAlignment = src.minSequenceCountBufferOffsetAlignment;
    minSequenceIndexBufferOffsetAlignment = src.minSequenceIndexBufferOffsetAlignment;
    minCommandsTokenBufferOffsetAlignment = src.minCommandsTokenBufferOffsetAlignment;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkDeviceGeneratedCommandsLimitsNVX::~safe_VkDeviceGeneratedCommandsLimitsNVX()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkDeviceGeneratedCommandsLimitsNVX::initialize(const VkDeviceGeneratedCommandsLimitsNVX* in_struct)
{
    sType = in_struct->sType;
    maxIndirectCommandsLayoutTokenCount = in_struct->maxIndirectCommandsLayoutTokenCount;
    maxObjectEntryCounts = in_struct->maxObjectEntryCounts;
    minSequenceCountBufferOffsetAlignment = in_struct->minSequenceCountBufferOffsetAlignment;
    minSequenceIndexBufferOffsetAlignment = in_struct->minSequenceIndexBufferOffsetAlignment;
    minCommandsTokenBufferOffsetAlignment = in_struct->minCommandsTokenBufferOffsetAlignment;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkDeviceGeneratedCommandsLimitsNVX::initialize(const safe_VkDeviceGeneratedCommandsLimitsNVX* src)
{
    sType = src->sType;
    maxIndirectCommandsLayoutTokenCount = src->maxIndirectCommandsLayoutTokenCount;
    maxObjectEntryCounts = src->maxObjectEntryCounts;
    minSequenceCountBufferOffsetAlignment = src->minSequenceCountBufferOffsetAlignment;
    minSequenceIndexBufferOffsetAlignment = src->minSequenceIndexBufferOffsetAlignment;
    minCommandsTokenBufferOffsetAlignment = src->minCommandsTokenBufferOffsetAlignment;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkIndirectCommandsLayoutCreateInfoNVX::safe_VkIndirectCommandsLayoutCreateInfoNVX(const VkIndirectCommandsLayoutCreateInfoNVX* in_struct) :
    sType(in_struct->sType),
    pipelineBindPoint(in_struct->pipelineBindPoint),
    flags(in_struct->flags),
    tokenCount(in_struct->tokenCount),
    pTokens(nullptr)
{
    pNext = SafePnextCopy(in_struct->pNext);
    if (in_struct->pTokens) {
        pTokens = new VkIndirectCommandsLayoutTokenNVX[in_struct->tokenCount];
        memcpy ((void *)pTokens, (void *)in_struct->pTokens, sizeof(VkIndirectCommandsLayoutTokenNVX)*in_struct->tokenCount);
    }
}

safe_VkIndirectCommandsLayoutCreateInfoNVX::safe_VkIndirectCommandsLayoutCreateInfoNVX() :
    pNext(nullptr),
    pTokens(nullptr)
{}

safe_VkIndirectCommandsLayoutCreateInfoNVX::safe_VkIndirectCommandsLayoutCreateInfoNVX(const safe_VkIndirectCommandsLayoutCreateInfoNVX& src)
{
    sType = src.sType;
    pipelineBindPoint = src.pipelineBindPoint;
    flags = src.flags;
    tokenCount = src.tokenCount;
    pTokens = nullptr;
    pNext = SafePnextCopy(src.pNext);
    if (src.pTokens) {
        pTokens = new VkIndirectCommandsLayoutTokenNVX[src.tokenCount];
        memcpy ((void *)pTokens, (void *)src.pTokens, sizeof(VkIndirectCommandsLayoutTokenNVX)*src.tokenCount);
    }
}

safe_VkIndirectCommandsLayoutCreateInfoNVX& safe_VkIndirectCommandsLayoutCreateInfoNVX::operator=(const safe_VkIndirectCommandsLayoutCreateInfoNVX& src)
{
    if (&src == this) return *this;

    if (pTokens)
        delete[] pTokens;
    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    pipelineBindPoint = src.pipelineBindPoint;
    flags = src.flags;
    tokenCount = src.tokenCount;
    pTokens = nullptr;
    pNext = SafePnextCopy(src.pNext);
    if (src.pTokens) {
        pTokens = new VkIndirectCommandsLayoutTokenNVX[src.tokenCount];
        memcpy ((void *)pTokens, (void *)src.pTokens, sizeof(VkIndirectCommandsLayoutTokenNVX)*src.tokenCount);
    }

    return *this;
}

safe_VkIndirectCommandsLayoutCreateInfoNVX::~safe_VkIndirectCommandsLayoutCreateInfoNVX()
{
    if (pTokens)
        delete[] pTokens;
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkIndirectCommandsLayoutCreateInfoNVX::initialize(const VkIndirectCommandsLayoutCreateInfoNVX* in_struct)
{
    sType = in_struct->sType;
    pipelineBindPoint = in_struct->pipelineBindPoint;
    flags = in_struct->flags;
    tokenCount = in_struct->tokenCount;
    pTokens = nullptr;
    pNext = SafePnextCopy(in_struct->pNext);
    if (in_struct->pTokens) {
        pTokens = new VkIndirectCommandsLayoutTokenNVX[in_struct->tokenCount];
        memcpy ((void *)pTokens, (void *)in_struct->pTokens, sizeof(VkIndirectCommandsLayoutTokenNVX)*in_struct->tokenCount);
    }
}

void safe_VkIndirectCommandsLayoutCreateInfoNVX::initialize(const safe_VkIndirectCommandsLayoutCreateInfoNVX* src)
{
    sType = src->sType;
    pipelineBindPoint = src->pipelineBindPoint;
    flags = src->flags;
    tokenCount = src->tokenCount;
    pTokens = nullptr;
    pNext = SafePnextCopy(src->pNext);
    if (src->pTokens) {
        pTokens = new VkIndirectCommandsLayoutTokenNVX[src->tokenCount];
        memcpy ((void *)pTokens, (void *)src->pTokens, sizeof(VkIndirectCommandsLayoutTokenNVX)*src->tokenCount);
    }
}

safe_VkCmdProcessCommandsInfoNVX::safe_VkCmdProcessCommandsInfoNVX(const VkCmdProcessCommandsInfoNVX* in_struct) :
    sType(in_struct->sType),
    objectTable(in_struct->objectTable),
    indirectCommandsLayout(in_struct->indirectCommandsLayout),
    indirectCommandsTokenCount(in_struct->indirectCommandsTokenCount),
    pIndirectCommandsTokens(nullptr),
    maxSequencesCount(in_struct->maxSequencesCount),
    targetCommandBuffer(in_struct->targetCommandBuffer),
    sequencesCountBuffer(in_struct->sequencesCountBuffer),
    sequencesCountOffset(in_struct->sequencesCountOffset),
    sequencesIndexBuffer(in_struct->sequencesIndexBuffer),
    sequencesIndexOffset(in_struct->sequencesIndexOffset)
{
    pNext = SafePnextCopy(in_struct->pNext);
    if (indirectCommandsTokenCount && in_struct->pIndirectCommandsTokens) {
        pIndirectCommandsTokens = new VkIndirectCommandsTokenNVX[indirectCommandsTokenCount];
        for (uint32_t i = 0; i < indirectCommandsTokenCount; ++i) {
            pIndirectCommandsTokens[i] = in_struct->pIndirectCommandsTokens[i];
        }
    }
}

safe_VkCmdProcessCommandsInfoNVX::safe_VkCmdProcessCommandsInfoNVX() :
    pNext(nullptr),
    pIndirectCommandsTokens(nullptr)
{}

safe_VkCmdProcessCommandsInfoNVX::safe_VkCmdProcessCommandsInfoNVX(const safe_VkCmdProcessCommandsInfoNVX& src)
{
    sType = src.sType;
    objectTable = src.objectTable;
    indirectCommandsLayout = src.indirectCommandsLayout;
    indirectCommandsTokenCount = src.indirectCommandsTokenCount;
    pIndirectCommandsTokens = nullptr;
    maxSequencesCount = src.maxSequencesCount;
    targetCommandBuffer = src.targetCommandBuffer;
    sequencesCountBuffer = src.sequencesCountBuffer;
    sequencesCountOffset = src.sequencesCountOffset;
    sequencesIndexBuffer = src.sequencesIndexBuffer;
    sequencesIndexOffset = src.sequencesIndexOffset;
    pNext = SafePnextCopy(src.pNext);
    if (indirectCommandsTokenCount && src.pIndirectCommandsTokens) {
        pIndirectCommandsTokens = new VkIndirectCommandsTokenNVX[indirectCommandsTokenCount];
        for (uint32_t i = 0; i < indirectCommandsTokenCount; ++i) {
            pIndirectCommandsTokens[i] = src.pIndirectCommandsTokens[i];
        }
    }
}

safe_VkCmdProcessCommandsInfoNVX& safe_VkCmdProcessCommandsInfoNVX::operator=(const safe_VkCmdProcessCommandsInfoNVX& src)
{
    if (&src == this) return *this;

    if (pIndirectCommandsTokens)
        delete[] pIndirectCommandsTokens;
    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    objectTable = src.objectTable;
    indirectCommandsLayout = src.indirectCommandsLayout;
    indirectCommandsTokenCount = src.indirectCommandsTokenCount;
    pIndirectCommandsTokens = nullptr;
    maxSequencesCount = src.maxSequencesCount;
    targetCommandBuffer = src.targetCommandBuffer;
    sequencesCountBuffer = src.sequencesCountBuffer;
    sequencesCountOffset = src.sequencesCountOffset;
    sequencesIndexBuffer = src.sequencesIndexBuffer;
    sequencesIndexOffset = src.sequencesIndexOffset;
    pNext = SafePnextCopy(src.pNext);
    if (indirectCommandsTokenCount && src.pIndirectCommandsTokens) {
        pIndirectCommandsTokens = new VkIndirectCommandsTokenNVX[indirectCommandsTokenCount];
        for (uint32_t i = 0; i < indirectCommandsTokenCount; ++i) {
            pIndirectCommandsTokens[i] = src.pIndirectCommandsTokens[i];
        }
    }

    return *this;
}

safe_VkCmdProcessCommandsInfoNVX::~safe_VkCmdProcessCommandsInfoNVX()
{
    if (pIndirectCommandsTokens)
        delete[] pIndirectCommandsTokens;
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkCmdProcessCommandsInfoNVX::initialize(const VkCmdProcessCommandsInfoNVX* in_struct)
{
    sType = in_struct->sType;
    objectTable = in_struct->objectTable;
    indirectCommandsLayout = in_struct->indirectCommandsLayout;
    indirectCommandsTokenCount = in_struct->indirectCommandsTokenCount;
    pIndirectCommandsTokens = nullptr;
    maxSequencesCount = in_struct->maxSequencesCount;
    targetCommandBuffer = in_struct->targetCommandBuffer;
    sequencesCountBuffer = in_struct->sequencesCountBuffer;
    sequencesCountOffset = in_struct->sequencesCountOffset;
    sequencesIndexBuffer = in_struct->sequencesIndexBuffer;
    sequencesIndexOffset = in_struct->sequencesIndexOffset;
    pNext = SafePnextCopy(in_struct->pNext);
    if (indirectCommandsTokenCount && in_struct->pIndirectCommandsTokens) {
        pIndirectCommandsTokens = new VkIndirectCommandsTokenNVX[indirectCommandsTokenCount];
        for (uint32_t i = 0; i < indirectCommandsTokenCount; ++i) {
            pIndirectCommandsTokens[i] = in_struct->pIndirectCommandsTokens[i];
        }
    }
}

void safe_VkCmdProcessCommandsInfoNVX::initialize(const safe_VkCmdProcessCommandsInfoNVX* src)
{
    sType = src->sType;
    objectTable = src->objectTable;
    indirectCommandsLayout = src->indirectCommandsLayout;
    indirectCommandsTokenCount = src->indirectCommandsTokenCount;
    pIndirectCommandsTokens = nullptr;
    maxSequencesCount = src->maxSequencesCount;
    targetCommandBuffer = src->targetCommandBuffer;
    sequencesCountBuffer = src->sequencesCountBuffer;
    sequencesCountOffset = src->sequencesCountOffset;
    sequencesIndexBuffer = src->sequencesIndexBuffer;
    sequencesIndexOffset = src->sequencesIndexOffset;
    pNext = SafePnextCopy(src->pNext);
    if (indirectCommandsTokenCount && src->pIndirectCommandsTokens) {
        pIndirectCommandsTokens = new VkIndirectCommandsTokenNVX[indirectCommandsTokenCount];
        for (uint32_t i = 0; i < indirectCommandsTokenCount; ++i) {
            pIndirectCommandsTokens[i] = src->pIndirectCommandsTokens[i];
        }
    }
}

safe_VkCmdReserveSpaceForCommandsInfoNVX::safe_VkCmdReserveSpaceForCommandsInfoNVX(const VkCmdReserveSpaceForCommandsInfoNVX* in_struct) :
    sType(in_struct->sType),
    objectTable(in_struct->objectTable),
    indirectCommandsLayout(in_struct->indirectCommandsLayout),
    maxSequencesCount(in_struct->maxSequencesCount)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkCmdReserveSpaceForCommandsInfoNVX::safe_VkCmdReserveSpaceForCommandsInfoNVX() :
    pNext(nullptr)
{}

safe_VkCmdReserveSpaceForCommandsInfoNVX::safe_VkCmdReserveSpaceForCommandsInfoNVX(const safe_VkCmdReserveSpaceForCommandsInfoNVX& src)
{
    sType = src.sType;
    objectTable = src.objectTable;
    indirectCommandsLayout = src.indirectCommandsLayout;
    maxSequencesCount = src.maxSequencesCount;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkCmdReserveSpaceForCommandsInfoNVX& safe_VkCmdReserveSpaceForCommandsInfoNVX::operator=(const safe_VkCmdReserveSpaceForCommandsInfoNVX& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    objectTable = src.objectTable;
    indirectCommandsLayout = src.indirectCommandsLayout;
    maxSequencesCount = src.maxSequencesCount;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkCmdReserveSpaceForCommandsInfoNVX::~safe_VkCmdReserveSpaceForCommandsInfoNVX()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkCmdReserveSpaceForCommandsInfoNVX::initialize(const VkCmdReserveSpaceForCommandsInfoNVX* in_struct)
{
    sType = in_struct->sType;
    objectTable = in_struct->objectTable;
    indirectCommandsLayout = in_struct->indirectCommandsLayout;
    maxSequencesCount = in_struct->maxSequencesCount;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkCmdReserveSpaceForCommandsInfoNVX::initialize(const safe_VkCmdReserveSpaceForCommandsInfoNVX* src)
{
    sType = src->sType;
    objectTable = src->objectTable;
    indirectCommandsLayout = src->indirectCommandsLayout;
    maxSequencesCount = src->maxSequencesCount;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkObjectTableCreateInfoNVX::safe_VkObjectTableCreateInfoNVX(const VkObjectTableCreateInfoNVX* in_struct) :
    sType(in_struct->sType),
    objectCount(in_struct->objectCount),
    pObjectEntryTypes(nullptr),
    pObjectEntryCounts(nullptr),
    pObjectEntryUsageFlags(nullptr),
    maxUniformBuffersPerDescriptor(in_struct->maxUniformBuffersPerDescriptor),
    maxStorageBuffersPerDescriptor(in_struct->maxStorageBuffersPerDescriptor),
    maxStorageImagesPerDescriptor(in_struct->maxStorageImagesPerDescriptor),
    maxSampledImagesPerDescriptor(in_struct->maxSampledImagesPerDescriptor),
    maxPipelineLayouts(in_struct->maxPipelineLayouts)
{
    pNext = SafePnextCopy(in_struct->pNext);
    if (in_struct->pObjectEntryTypes) {
        pObjectEntryTypes = new VkObjectEntryTypeNVX[in_struct->objectCount];
        memcpy ((void *)pObjectEntryTypes, (void *)in_struct->pObjectEntryTypes, sizeof(VkObjectEntryTypeNVX)*in_struct->objectCount);
    }
    if (in_struct->pObjectEntryCounts) {
        pObjectEntryCounts = new uint32_t[in_struct->objectCount];
        memcpy ((void *)pObjectEntryCounts, (void *)in_struct->pObjectEntryCounts, sizeof(uint32_t)*in_struct->objectCount);
    }
    if (in_struct->pObjectEntryUsageFlags) {
        pObjectEntryUsageFlags = new VkObjectEntryUsageFlagsNVX[in_struct->objectCount];
        memcpy ((void *)pObjectEntryUsageFlags, (void *)in_struct->pObjectEntryUsageFlags, sizeof(VkObjectEntryUsageFlagsNVX)*in_struct->objectCount);
    }
}

safe_VkObjectTableCreateInfoNVX::safe_VkObjectTableCreateInfoNVX() :
    pNext(nullptr),
    pObjectEntryTypes(nullptr),
    pObjectEntryCounts(nullptr),
    pObjectEntryUsageFlags(nullptr)
{}

safe_VkObjectTableCreateInfoNVX::safe_VkObjectTableCreateInfoNVX(const safe_VkObjectTableCreateInfoNVX& src)
{
    sType = src.sType;
    objectCount = src.objectCount;
    pObjectEntryTypes = nullptr;
    pObjectEntryCounts = nullptr;
    pObjectEntryUsageFlags = nullptr;
    maxUniformBuffersPerDescriptor = src.maxUniformBuffersPerDescriptor;
    maxStorageBuffersPerDescriptor = src.maxStorageBuffersPerDescriptor;
    maxStorageImagesPerDescriptor = src.maxStorageImagesPerDescriptor;
    maxSampledImagesPerDescriptor = src.maxSampledImagesPerDescriptor;
    maxPipelineLayouts = src.maxPipelineLayouts;
    pNext = SafePnextCopy(src.pNext);
    if (src.pObjectEntryTypes) {
        pObjectEntryTypes = new VkObjectEntryTypeNVX[src.objectCount];
        memcpy ((void *)pObjectEntryTypes, (void *)src.pObjectEntryTypes, sizeof(VkObjectEntryTypeNVX)*src.objectCount);
    }
    if (src.pObjectEntryCounts) {
        pObjectEntryCounts = new uint32_t[src.objectCount];
        memcpy ((void *)pObjectEntryCounts, (void *)src.pObjectEntryCounts, sizeof(uint32_t)*src.objectCount);
    }
    if (src.pObjectEntryUsageFlags) {
        pObjectEntryUsageFlags = new VkObjectEntryUsageFlagsNVX[src.objectCount];
        memcpy ((void *)pObjectEntryUsageFlags, (void *)src.pObjectEntryUsageFlags, sizeof(VkObjectEntryUsageFlagsNVX)*src.objectCount);
    }
}

safe_VkObjectTableCreateInfoNVX& safe_VkObjectTableCreateInfoNVX::operator=(const safe_VkObjectTableCreateInfoNVX& src)
{
    if (&src == this) return *this;

    if (pObjectEntryTypes)
        delete[] pObjectEntryTypes;
    if (pObjectEntryCounts)
        delete[] pObjectEntryCounts;
    if (pObjectEntryUsageFlags)
        delete[] pObjectEntryUsageFlags;
    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    objectCount = src.objectCount;
    pObjectEntryTypes = nullptr;
    pObjectEntryCounts = nullptr;
    pObjectEntryUsageFlags = nullptr;
    maxUniformBuffersPerDescriptor = src.maxUniformBuffersPerDescriptor;
    maxStorageBuffersPerDescriptor = src.maxStorageBuffersPerDescriptor;
    maxStorageImagesPerDescriptor = src.maxStorageImagesPerDescriptor;
    maxSampledImagesPerDescriptor = src.maxSampledImagesPerDescriptor;
    maxPipelineLayouts = src.maxPipelineLayouts;
    pNext = SafePnextCopy(src.pNext);
    if (src.pObjectEntryTypes) {
        pObjectEntryTypes = new VkObjectEntryTypeNVX[src.objectCount];
        memcpy ((void *)pObjectEntryTypes, (void *)src.pObjectEntryTypes, sizeof(VkObjectEntryTypeNVX)*src.objectCount);
    }
    if (src.pObjectEntryCounts) {
        pObjectEntryCounts = new uint32_t[src.objectCount];
        memcpy ((void *)pObjectEntryCounts, (void *)src.pObjectEntryCounts, sizeof(uint32_t)*src.objectCount);
    }
    if (src.pObjectEntryUsageFlags) {
        pObjectEntryUsageFlags = new VkObjectEntryUsageFlagsNVX[src.objectCount];
        memcpy ((void *)pObjectEntryUsageFlags, (void *)src.pObjectEntryUsageFlags, sizeof(VkObjectEntryUsageFlagsNVX)*src.objectCount);
    }

    return *this;
}

safe_VkObjectTableCreateInfoNVX::~safe_VkObjectTableCreateInfoNVX()
{
    if (pObjectEntryTypes)
        delete[] pObjectEntryTypes;
    if (pObjectEntryCounts)
        delete[] pObjectEntryCounts;
    if (pObjectEntryUsageFlags)
        delete[] pObjectEntryUsageFlags;
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkObjectTableCreateInfoNVX::initialize(const VkObjectTableCreateInfoNVX* in_struct)
{
    sType = in_struct->sType;
    objectCount = in_struct->objectCount;
    pObjectEntryTypes = nullptr;
    pObjectEntryCounts = nullptr;
    pObjectEntryUsageFlags = nullptr;
    maxUniformBuffersPerDescriptor = in_struct->maxUniformBuffersPerDescriptor;
    maxStorageBuffersPerDescriptor = in_struct->maxStorageBuffersPerDescriptor;
    maxStorageImagesPerDescriptor = in_struct->maxStorageImagesPerDescriptor;
    maxSampledImagesPerDescriptor = in_struct->maxSampledImagesPerDescriptor;
    maxPipelineLayouts = in_struct->maxPipelineLayouts;
    pNext = SafePnextCopy(in_struct->pNext);
    if (in_struct->pObjectEntryTypes) {
        pObjectEntryTypes = new VkObjectEntryTypeNVX[in_struct->objectCount];
        memcpy ((void *)pObjectEntryTypes, (void *)in_struct->pObjectEntryTypes, sizeof(VkObjectEntryTypeNVX)*in_struct->objectCount);
    }
    if (in_struct->pObjectEntryCounts) {
        pObjectEntryCounts = new uint32_t[in_struct->objectCount];
        memcpy ((void *)pObjectEntryCounts, (void *)in_struct->pObjectEntryCounts, sizeof(uint32_t)*in_struct->objectCount);
    }
    if (in_struct->pObjectEntryUsageFlags) {
        pObjectEntryUsageFlags = new VkObjectEntryUsageFlagsNVX[in_struct->objectCount];
        memcpy ((void *)pObjectEntryUsageFlags, (void *)in_struct->pObjectEntryUsageFlags, sizeof(VkObjectEntryUsageFlagsNVX)*in_struct->objectCount);
    }
}

void safe_VkObjectTableCreateInfoNVX::initialize(const safe_VkObjectTableCreateInfoNVX* src)
{
    sType = src->sType;
    objectCount = src->objectCount;
    pObjectEntryTypes = nullptr;
    pObjectEntryCounts = nullptr;
    pObjectEntryUsageFlags = nullptr;
    maxUniformBuffersPerDescriptor = src->maxUniformBuffersPerDescriptor;
    maxStorageBuffersPerDescriptor = src->maxStorageBuffersPerDescriptor;
    maxStorageImagesPerDescriptor = src->maxStorageImagesPerDescriptor;
    maxSampledImagesPerDescriptor = src->maxSampledImagesPerDescriptor;
    maxPipelineLayouts = src->maxPipelineLayouts;
    pNext = SafePnextCopy(src->pNext);
    if (src->pObjectEntryTypes) {
        pObjectEntryTypes = new VkObjectEntryTypeNVX[src->objectCount];
        memcpy ((void *)pObjectEntryTypes, (void *)src->pObjectEntryTypes, sizeof(VkObjectEntryTypeNVX)*src->objectCount);
    }
    if (src->pObjectEntryCounts) {
        pObjectEntryCounts = new uint32_t[src->objectCount];
        memcpy ((void *)pObjectEntryCounts, (void *)src->pObjectEntryCounts, sizeof(uint32_t)*src->objectCount);
    }
    if (src->pObjectEntryUsageFlags) {
        pObjectEntryUsageFlags = new VkObjectEntryUsageFlagsNVX[src->objectCount];
        memcpy ((void *)pObjectEntryUsageFlags, (void *)src->pObjectEntryUsageFlags, sizeof(VkObjectEntryUsageFlagsNVX)*src->objectCount);
    }
}

safe_VkPipelineViewportWScalingStateCreateInfoNV::safe_VkPipelineViewportWScalingStateCreateInfoNV(const VkPipelineViewportWScalingStateCreateInfoNV* in_struct) :
    sType(in_struct->sType),
    viewportWScalingEnable(in_struct->viewportWScalingEnable),
    viewportCount(in_struct->viewportCount),
    pViewportWScalings(nullptr)
{
    pNext = SafePnextCopy(in_struct->pNext);
    if (in_struct->pViewportWScalings) {
        pViewportWScalings = new VkViewportWScalingNV[in_struct->viewportCount];
        memcpy ((void *)pViewportWScalings, (void *)in_struct->pViewportWScalings, sizeof(VkViewportWScalingNV)*in_struct->viewportCount);
    }
}

safe_VkPipelineViewportWScalingStateCreateInfoNV::safe_VkPipelineViewportWScalingStateCreateInfoNV() :
    pNext(nullptr),
    pViewportWScalings(nullptr)
{}

safe_VkPipelineViewportWScalingStateCreateInfoNV::safe_VkPipelineViewportWScalingStateCreateInfoNV(const safe_VkPipelineViewportWScalingStateCreateInfoNV& src)
{
    sType = src.sType;
    viewportWScalingEnable = src.viewportWScalingEnable;
    viewportCount = src.viewportCount;
    pViewportWScalings = nullptr;
    pNext = SafePnextCopy(src.pNext);
    if (src.pViewportWScalings) {
        pViewportWScalings = new VkViewportWScalingNV[src.viewportCount];
        memcpy ((void *)pViewportWScalings, (void *)src.pViewportWScalings, sizeof(VkViewportWScalingNV)*src.viewportCount);
    }
}

safe_VkPipelineViewportWScalingStateCreateInfoNV& safe_VkPipelineViewportWScalingStateCreateInfoNV::operator=(const safe_VkPipelineViewportWScalingStateCreateInfoNV& src)
{
    if (&src == this) return *this;

    if (pViewportWScalings)
        delete[] pViewportWScalings;
    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    viewportWScalingEnable = src.viewportWScalingEnable;
    viewportCount = src.viewportCount;
    pViewportWScalings = nullptr;
    pNext = SafePnextCopy(src.pNext);
    if (src.pViewportWScalings) {
        pViewportWScalings = new VkViewportWScalingNV[src.viewportCount];
        memcpy ((void *)pViewportWScalings, (void *)src.pViewportWScalings, sizeof(VkViewportWScalingNV)*src.viewportCount);
    }

    return *this;
}

safe_VkPipelineViewportWScalingStateCreateInfoNV::~safe_VkPipelineViewportWScalingStateCreateInfoNV()
{
    if (pViewportWScalings)
        delete[] pViewportWScalings;
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPipelineViewportWScalingStateCreateInfoNV::initialize(const VkPipelineViewportWScalingStateCreateInfoNV* in_struct)
{
    sType = in_struct->sType;
    viewportWScalingEnable = in_struct->viewportWScalingEnable;
    viewportCount = in_struct->viewportCount;
    pViewportWScalings = nullptr;
    pNext = SafePnextCopy(in_struct->pNext);
    if (in_struct->pViewportWScalings) {
        pViewportWScalings = new VkViewportWScalingNV[in_struct->viewportCount];
        memcpy ((void *)pViewportWScalings, (void *)in_struct->pViewportWScalings, sizeof(VkViewportWScalingNV)*in_struct->viewportCount);
    }
}

void safe_VkPipelineViewportWScalingStateCreateInfoNV::initialize(const safe_VkPipelineViewportWScalingStateCreateInfoNV* src)
{
    sType = src->sType;
    viewportWScalingEnable = src->viewportWScalingEnable;
    viewportCount = src->viewportCount;
    pViewportWScalings = nullptr;
    pNext = SafePnextCopy(src->pNext);
    if (src->pViewportWScalings) {
        pViewportWScalings = new VkViewportWScalingNV[src->viewportCount];
        memcpy ((void *)pViewportWScalings, (void *)src->pViewportWScalings, sizeof(VkViewportWScalingNV)*src->viewportCount);
    }
}

safe_VkSurfaceCapabilities2EXT::safe_VkSurfaceCapabilities2EXT(const VkSurfaceCapabilities2EXT* in_struct) :
    sType(in_struct->sType),
    minImageCount(in_struct->minImageCount),
    maxImageCount(in_struct->maxImageCount),
    currentExtent(in_struct->currentExtent),
    minImageExtent(in_struct->minImageExtent),
    maxImageExtent(in_struct->maxImageExtent),
    maxImageArrayLayers(in_struct->maxImageArrayLayers),
    supportedTransforms(in_struct->supportedTransforms),
    currentTransform(in_struct->currentTransform),
    supportedCompositeAlpha(in_struct->supportedCompositeAlpha),
    supportedUsageFlags(in_struct->supportedUsageFlags),
    supportedSurfaceCounters(in_struct->supportedSurfaceCounters)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkSurfaceCapabilities2EXT::safe_VkSurfaceCapabilities2EXT() :
    pNext(nullptr)
{}

safe_VkSurfaceCapabilities2EXT::safe_VkSurfaceCapabilities2EXT(const safe_VkSurfaceCapabilities2EXT& src)
{
    sType = src.sType;
    minImageCount = src.minImageCount;
    maxImageCount = src.maxImageCount;
    currentExtent = src.currentExtent;
    minImageExtent = src.minImageExtent;
    maxImageExtent = src.maxImageExtent;
    maxImageArrayLayers = src.maxImageArrayLayers;
    supportedTransforms = src.supportedTransforms;
    currentTransform = src.currentTransform;
    supportedCompositeAlpha = src.supportedCompositeAlpha;
    supportedUsageFlags = src.supportedUsageFlags;
    supportedSurfaceCounters = src.supportedSurfaceCounters;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkSurfaceCapabilities2EXT& safe_VkSurfaceCapabilities2EXT::operator=(const safe_VkSurfaceCapabilities2EXT& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    minImageCount = src.minImageCount;
    maxImageCount = src.maxImageCount;
    currentExtent = src.currentExtent;
    minImageExtent = src.minImageExtent;
    maxImageExtent = src.maxImageExtent;
    maxImageArrayLayers = src.maxImageArrayLayers;
    supportedTransforms = src.supportedTransforms;
    currentTransform = src.currentTransform;
    supportedCompositeAlpha = src.supportedCompositeAlpha;
    supportedUsageFlags = src.supportedUsageFlags;
    supportedSurfaceCounters = src.supportedSurfaceCounters;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkSurfaceCapabilities2EXT::~safe_VkSurfaceCapabilities2EXT()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkSurfaceCapabilities2EXT::initialize(const VkSurfaceCapabilities2EXT* in_struct)
{
    sType = in_struct->sType;
    minImageCount = in_struct->minImageCount;
    maxImageCount = in_struct->maxImageCount;
    currentExtent = in_struct->currentExtent;
    minImageExtent = in_struct->minImageExtent;
    maxImageExtent = in_struct->maxImageExtent;
    maxImageArrayLayers = in_struct->maxImageArrayLayers;
    supportedTransforms = in_struct->supportedTransforms;
    currentTransform = in_struct->currentTransform;
    supportedCompositeAlpha = in_struct->supportedCompositeAlpha;
    supportedUsageFlags = in_struct->supportedUsageFlags;
    supportedSurfaceCounters = in_struct->supportedSurfaceCounters;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkSurfaceCapabilities2EXT::initialize(const safe_VkSurfaceCapabilities2EXT* src)
{
    sType = src->sType;
    minImageCount = src->minImageCount;
    maxImageCount = src->maxImageCount;
    currentExtent = src->currentExtent;
    minImageExtent = src->minImageExtent;
    maxImageExtent = src->maxImageExtent;
    maxImageArrayLayers = src->maxImageArrayLayers;
    supportedTransforms = src->supportedTransforms;
    currentTransform = src->currentTransform;
    supportedCompositeAlpha = src->supportedCompositeAlpha;
    supportedUsageFlags = src->supportedUsageFlags;
    supportedSurfaceCounters = src->supportedSurfaceCounters;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkDisplayPowerInfoEXT::safe_VkDisplayPowerInfoEXT(const VkDisplayPowerInfoEXT* in_struct) :
    sType(in_struct->sType),
    powerState(in_struct->powerState)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkDisplayPowerInfoEXT::safe_VkDisplayPowerInfoEXT() :
    pNext(nullptr)
{}

safe_VkDisplayPowerInfoEXT::safe_VkDisplayPowerInfoEXT(const safe_VkDisplayPowerInfoEXT& src)
{
    sType = src.sType;
    powerState = src.powerState;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkDisplayPowerInfoEXT& safe_VkDisplayPowerInfoEXT::operator=(const safe_VkDisplayPowerInfoEXT& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    powerState = src.powerState;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkDisplayPowerInfoEXT::~safe_VkDisplayPowerInfoEXT()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkDisplayPowerInfoEXT::initialize(const VkDisplayPowerInfoEXT* in_struct)
{
    sType = in_struct->sType;
    powerState = in_struct->powerState;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkDisplayPowerInfoEXT::initialize(const safe_VkDisplayPowerInfoEXT* src)
{
    sType = src->sType;
    powerState = src->powerState;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkDeviceEventInfoEXT::safe_VkDeviceEventInfoEXT(const VkDeviceEventInfoEXT* in_struct) :
    sType(in_struct->sType),
    deviceEvent(in_struct->deviceEvent)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkDeviceEventInfoEXT::safe_VkDeviceEventInfoEXT() :
    pNext(nullptr)
{}

safe_VkDeviceEventInfoEXT::safe_VkDeviceEventInfoEXT(const safe_VkDeviceEventInfoEXT& src)
{
    sType = src.sType;
    deviceEvent = src.deviceEvent;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkDeviceEventInfoEXT& safe_VkDeviceEventInfoEXT::operator=(const safe_VkDeviceEventInfoEXT& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    deviceEvent = src.deviceEvent;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkDeviceEventInfoEXT::~safe_VkDeviceEventInfoEXT()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkDeviceEventInfoEXT::initialize(const VkDeviceEventInfoEXT* in_struct)
{
    sType = in_struct->sType;
    deviceEvent = in_struct->deviceEvent;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkDeviceEventInfoEXT::initialize(const safe_VkDeviceEventInfoEXT* src)
{
    sType = src->sType;
    deviceEvent = src->deviceEvent;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkDisplayEventInfoEXT::safe_VkDisplayEventInfoEXT(const VkDisplayEventInfoEXT* in_struct) :
    sType(in_struct->sType),
    displayEvent(in_struct->displayEvent)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkDisplayEventInfoEXT::safe_VkDisplayEventInfoEXT() :
    pNext(nullptr)
{}

safe_VkDisplayEventInfoEXT::safe_VkDisplayEventInfoEXT(const safe_VkDisplayEventInfoEXT& src)
{
    sType = src.sType;
    displayEvent = src.displayEvent;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkDisplayEventInfoEXT& safe_VkDisplayEventInfoEXT::operator=(const safe_VkDisplayEventInfoEXT& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    displayEvent = src.displayEvent;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkDisplayEventInfoEXT::~safe_VkDisplayEventInfoEXT()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkDisplayEventInfoEXT::initialize(const VkDisplayEventInfoEXT* in_struct)
{
    sType = in_struct->sType;
    displayEvent = in_struct->displayEvent;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkDisplayEventInfoEXT::initialize(const safe_VkDisplayEventInfoEXT* src)
{
    sType = src->sType;
    displayEvent = src->displayEvent;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkSwapchainCounterCreateInfoEXT::safe_VkSwapchainCounterCreateInfoEXT(const VkSwapchainCounterCreateInfoEXT* in_struct) :
    sType(in_struct->sType),
    surfaceCounters(in_struct->surfaceCounters)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkSwapchainCounterCreateInfoEXT::safe_VkSwapchainCounterCreateInfoEXT() :
    pNext(nullptr)
{}

safe_VkSwapchainCounterCreateInfoEXT::safe_VkSwapchainCounterCreateInfoEXT(const safe_VkSwapchainCounterCreateInfoEXT& src)
{
    sType = src.sType;
    surfaceCounters = src.surfaceCounters;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkSwapchainCounterCreateInfoEXT& safe_VkSwapchainCounterCreateInfoEXT::operator=(const safe_VkSwapchainCounterCreateInfoEXT& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    surfaceCounters = src.surfaceCounters;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkSwapchainCounterCreateInfoEXT::~safe_VkSwapchainCounterCreateInfoEXT()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkSwapchainCounterCreateInfoEXT::initialize(const VkSwapchainCounterCreateInfoEXT* in_struct)
{
    sType = in_struct->sType;
    surfaceCounters = in_struct->surfaceCounters;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkSwapchainCounterCreateInfoEXT::initialize(const safe_VkSwapchainCounterCreateInfoEXT* src)
{
    sType = src->sType;
    surfaceCounters = src->surfaceCounters;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkPresentTimesInfoGOOGLE::safe_VkPresentTimesInfoGOOGLE(const VkPresentTimesInfoGOOGLE* in_struct) :
    sType(in_struct->sType),
    swapchainCount(in_struct->swapchainCount),
    pTimes(nullptr)
{
    pNext = SafePnextCopy(in_struct->pNext);
    if (in_struct->pTimes) {
        pTimes = new VkPresentTimeGOOGLE[in_struct->swapchainCount];
        memcpy ((void *)pTimes, (void *)in_struct->pTimes, sizeof(VkPresentTimeGOOGLE)*in_struct->swapchainCount);
    }
}

safe_VkPresentTimesInfoGOOGLE::safe_VkPresentTimesInfoGOOGLE() :
    pNext(nullptr),
    pTimes(nullptr)
{}

safe_VkPresentTimesInfoGOOGLE::safe_VkPresentTimesInfoGOOGLE(const safe_VkPresentTimesInfoGOOGLE& src)
{
    sType = src.sType;
    swapchainCount = src.swapchainCount;
    pTimes = nullptr;
    pNext = SafePnextCopy(src.pNext);
    if (src.pTimes) {
        pTimes = new VkPresentTimeGOOGLE[src.swapchainCount];
        memcpy ((void *)pTimes, (void *)src.pTimes, sizeof(VkPresentTimeGOOGLE)*src.swapchainCount);
    }
}

safe_VkPresentTimesInfoGOOGLE& safe_VkPresentTimesInfoGOOGLE::operator=(const safe_VkPresentTimesInfoGOOGLE& src)
{
    if (&src == this) return *this;

    if (pTimes)
        delete[] pTimes;
    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    swapchainCount = src.swapchainCount;
    pTimes = nullptr;
    pNext = SafePnextCopy(src.pNext);
    if (src.pTimes) {
        pTimes = new VkPresentTimeGOOGLE[src.swapchainCount];
        memcpy ((void *)pTimes, (void *)src.pTimes, sizeof(VkPresentTimeGOOGLE)*src.swapchainCount);
    }

    return *this;
}

safe_VkPresentTimesInfoGOOGLE::~safe_VkPresentTimesInfoGOOGLE()
{
    if (pTimes)
        delete[] pTimes;
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPresentTimesInfoGOOGLE::initialize(const VkPresentTimesInfoGOOGLE* in_struct)
{
    sType = in_struct->sType;
    swapchainCount = in_struct->swapchainCount;
    pTimes = nullptr;
    pNext = SafePnextCopy(in_struct->pNext);
    if (in_struct->pTimes) {
        pTimes = new VkPresentTimeGOOGLE[in_struct->swapchainCount];
        memcpy ((void *)pTimes, (void *)in_struct->pTimes, sizeof(VkPresentTimeGOOGLE)*in_struct->swapchainCount);
    }
}

void safe_VkPresentTimesInfoGOOGLE::initialize(const safe_VkPresentTimesInfoGOOGLE* src)
{
    sType = src->sType;
    swapchainCount = src->swapchainCount;
    pTimes = nullptr;
    pNext = SafePnextCopy(src->pNext);
    if (src->pTimes) {
        pTimes = new VkPresentTimeGOOGLE[src->swapchainCount];
        memcpy ((void *)pTimes, (void *)src->pTimes, sizeof(VkPresentTimeGOOGLE)*src->swapchainCount);
    }
}

safe_VkPhysicalDeviceMultiviewPerViewAttributesPropertiesNVX::safe_VkPhysicalDeviceMultiviewPerViewAttributesPropertiesNVX(const VkPhysicalDeviceMultiviewPerViewAttributesPropertiesNVX* in_struct) :
    sType(in_struct->sType),
    perViewPositionAllComponents(in_struct->perViewPositionAllComponents)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkPhysicalDeviceMultiviewPerViewAttributesPropertiesNVX::safe_VkPhysicalDeviceMultiviewPerViewAttributesPropertiesNVX() :
    pNext(nullptr)
{}

safe_VkPhysicalDeviceMultiviewPerViewAttributesPropertiesNVX::safe_VkPhysicalDeviceMultiviewPerViewAttributesPropertiesNVX(const safe_VkPhysicalDeviceMultiviewPerViewAttributesPropertiesNVX& src)
{
    sType = src.sType;
    perViewPositionAllComponents = src.perViewPositionAllComponents;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkPhysicalDeviceMultiviewPerViewAttributesPropertiesNVX& safe_VkPhysicalDeviceMultiviewPerViewAttributesPropertiesNVX::operator=(const safe_VkPhysicalDeviceMultiviewPerViewAttributesPropertiesNVX& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    perViewPositionAllComponents = src.perViewPositionAllComponents;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkPhysicalDeviceMultiviewPerViewAttributesPropertiesNVX::~safe_VkPhysicalDeviceMultiviewPerViewAttributesPropertiesNVX()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPhysicalDeviceMultiviewPerViewAttributesPropertiesNVX::initialize(const VkPhysicalDeviceMultiviewPerViewAttributesPropertiesNVX* in_struct)
{
    sType = in_struct->sType;
    perViewPositionAllComponents = in_struct->perViewPositionAllComponents;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkPhysicalDeviceMultiviewPerViewAttributesPropertiesNVX::initialize(const safe_VkPhysicalDeviceMultiviewPerViewAttributesPropertiesNVX* src)
{
    sType = src->sType;
    perViewPositionAllComponents = src->perViewPositionAllComponents;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkPipelineViewportSwizzleStateCreateInfoNV::safe_VkPipelineViewportSwizzleStateCreateInfoNV(const VkPipelineViewportSwizzleStateCreateInfoNV* in_struct) :
    sType(in_struct->sType),
    flags(in_struct->flags),
    viewportCount(in_struct->viewportCount),
    pViewportSwizzles(nullptr)
{
    pNext = SafePnextCopy(in_struct->pNext);
    if (in_struct->pViewportSwizzles) {
        pViewportSwizzles = new VkViewportSwizzleNV[in_struct->viewportCount];
        memcpy ((void *)pViewportSwizzles, (void *)in_struct->pViewportSwizzles, sizeof(VkViewportSwizzleNV)*in_struct->viewportCount);
    }
}

safe_VkPipelineViewportSwizzleStateCreateInfoNV::safe_VkPipelineViewportSwizzleStateCreateInfoNV() :
    pNext(nullptr),
    pViewportSwizzles(nullptr)
{}

safe_VkPipelineViewportSwizzleStateCreateInfoNV::safe_VkPipelineViewportSwizzleStateCreateInfoNV(const safe_VkPipelineViewportSwizzleStateCreateInfoNV& src)
{
    sType = src.sType;
    flags = src.flags;
    viewportCount = src.viewportCount;
    pViewportSwizzles = nullptr;
    pNext = SafePnextCopy(src.pNext);
    if (src.pViewportSwizzles) {
        pViewportSwizzles = new VkViewportSwizzleNV[src.viewportCount];
        memcpy ((void *)pViewportSwizzles, (void *)src.pViewportSwizzles, sizeof(VkViewportSwizzleNV)*src.viewportCount);
    }
}

safe_VkPipelineViewportSwizzleStateCreateInfoNV& safe_VkPipelineViewportSwizzleStateCreateInfoNV::operator=(const safe_VkPipelineViewportSwizzleStateCreateInfoNV& src)
{
    if (&src == this) return *this;

    if (pViewportSwizzles)
        delete[] pViewportSwizzles;
    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    flags = src.flags;
    viewportCount = src.viewportCount;
    pViewportSwizzles = nullptr;
    pNext = SafePnextCopy(src.pNext);
    if (src.pViewportSwizzles) {
        pViewportSwizzles = new VkViewportSwizzleNV[src.viewportCount];
        memcpy ((void *)pViewportSwizzles, (void *)src.pViewportSwizzles, sizeof(VkViewportSwizzleNV)*src.viewportCount);
    }

    return *this;
}

safe_VkPipelineViewportSwizzleStateCreateInfoNV::~safe_VkPipelineViewportSwizzleStateCreateInfoNV()
{
    if (pViewportSwizzles)
        delete[] pViewportSwizzles;
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPipelineViewportSwizzleStateCreateInfoNV::initialize(const VkPipelineViewportSwizzleStateCreateInfoNV* in_struct)
{
    sType = in_struct->sType;
    flags = in_struct->flags;
    viewportCount = in_struct->viewportCount;
    pViewportSwizzles = nullptr;
    pNext = SafePnextCopy(in_struct->pNext);
    if (in_struct->pViewportSwizzles) {
        pViewportSwizzles = new VkViewportSwizzleNV[in_struct->viewportCount];
        memcpy ((void *)pViewportSwizzles, (void *)in_struct->pViewportSwizzles, sizeof(VkViewportSwizzleNV)*in_struct->viewportCount);
    }
}

void safe_VkPipelineViewportSwizzleStateCreateInfoNV::initialize(const safe_VkPipelineViewportSwizzleStateCreateInfoNV* src)
{
    sType = src->sType;
    flags = src->flags;
    viewportCount = src->viewportCount;
    pViewportSwizzles = nullptr;
    pNext = SafePnextCopy(src->pNext);
    if (src->pViewportSwizzles) {
        pViewportSwizzles = new VkViewportSwizzleNV[src->viewportCount];
        memcpy ((void *)pViewportSwizzles, (void *)src->pViewportSwizzles, sizeof(VkViewportSwizzleNV)*src->viewportCount);
    }
}

safe_VkPhysicalDeviceDiscardRectanglePropertiesEXT::safe_VkPhysicalDeviceDiscardRectanglePropertiesEXT(const VkPhysicalDeviceDiscardRectanglePropertiesEXT* in_struct) :
    sType(in_struct->sType),
    maxDiscardRectangles(in_struct->maxDiscardRectangles)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkPhysicalDeviceDiscardRectanglePropertiesEXT::safe_VkPhysicalDeviceDiscardRectanglePropertiesEXT() :
    pNext(nullptr)
{}

safe_VkPhysicalDeviceDiscardRectanglePropertiesEXT::safe_VkPhysicalDeviceDiscardRectanglePropertiesEXT(const safe_VkPhysicalDeviceDiscardRectanglePropertiesEXT& src)
{
    sType = src.sType;
    maxDiscardRectangles = src.maxDiscardRectangles;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkPhysicalDeviceDiscardRectanglePropertiesEXT& safe_VkPhysicalDeviceDiscardRectanglePropertiesEXT::operator=(const safe_VkPhysicalDeviceDiscardRectanglePropertiesEXT& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    maxDiscardRectangles = src.maxDiscardRectangles;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkPhysicalDeviceDiscardRectanglePropertiesEXT::~safe_VkPhysicalDeviceDiscardRectanglePropertiesEXT()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPhysicalDeviceDiscardRectanglePropertiesEXT::initialize(const VkPhysicalDeviceDiscardRectanglePropertiesEXT* in_struct)
{
    sType = in_struct->sType;
    maxDiscardRectangles = in_struct->maxDiscardRectangles;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkPhysicalDeviceDiscardRectanglePropertiesEXT::initialize(const safe_VkPhysicalDeviceDiscardRectanglePropertiesEXT* src)
{
    sType = src->sType;
    maxDiscardRectangles = src->maxDiscardRectangles;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkPipelineDiscardRectangleStateCreateInfoEXT::safe_VkPipelineDiscardRectangleStateCreateInfoEXT(const VkPipelineDiscardRectangleStateCreateInfoEXT* in_struct) :
    sType(in_struct->sType),
    flags(in_struct->flags),
    discardRectangleMode(in_struct->discardRectangleMode),
    discardRectangleCount(in_struct->discardRectangleCount),
    pDiscardRectangles(nullptr)
{
    pNext = SafePnextCopy(in_struct->pNext);
    if (in_struct->pDiscardRectangles) {
        pDiscardRectangles = new VkRect2D[in_struct->discardRectangleCount];
        memcpy ((void *)pDiscardRectangles, (void *)in_struct->pDiscardRectangles, sizeof(VkRect2D)*in_struct->discardRectangleCount);
    }
}

safe_VkPipelineDiscardRectangleStateCreateInfoEXT::safe_VkPipelineDiscardRectangleStateCreateInfoEXT() :
    pNext(nullptr),
    pDiscardRectangles(nullptr)
{}

safe_VkPipelineDiscardRectangleStateCreateInfoEXT::safe_VkPipelineDiscardRectangleStateCreateInfoEXT(const safe_VkPipelineDiscardRectangleStateCreateInfoEXT& src)
{
    sType = src.sType;
    flags = src.flags;
    discardRectangleMode = src.discardRectangleMode;
    discardRectangleCount = src.discardRectangleCount;
    pDiscardRectangles = nullptr;
    pNext = SafePnextCopy(src.pNext);
    if (src.pDiscardRectangles) {
        pDiscardRectangles = new VkRect2D[src.discardRectangleCount];
        memcpy ((void *)pDiscardRectangles, (void *)src.pDiscardRectangles, sizeof(VkRect2D)*src.discardRectangleCount);
    }
}

safe_VkPipelineDiscardRectangleStateCreateInfoEXT& safe_VkPipelineDiscardRectangleStateCreateInfoEXT::operator=(const safe_VkPipelineDiscardRectangleStateCreateInfoEXT& src)
{
    if (&src == this) return *this;

    if (pDiscardRectangles)
        delete[] pDiscardRectangles;
    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    flags = src.flags;
    discardRectangleMode = src.discardRectangleMode;
    discardRectangleCount = src.discardRectangleCount;
    pDiscardRectangles = nullptr;
    pNext = SafePnextCopy(src.pNext);
    if (src.pDiscardRectangles) {
        pDiscardRectangles = new VkRect2D[src.discardRectangleCount];
        memcpy ((void *)pDiscardRectangles, (void *)src.pDiscardRectangles, sizeof(VkRect2D)*src.discardRectangleCount);
    }

    return *this;
}

safe_VkPipelineDiscardRectangleStateCreateInfoEXT::~safe_VkPipelineDiscardRectangleStateCreateInfoEXT()
{
    if (pDiscardRectangles)
        delete[] pDiscardRectangles;
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPipelineDiscardRectangleStateCreateInfoEXT::initialize(const VkPipelineDiscardRectangleStateCreateInfoEXT* in_struct)
{
    sType = in_struct->sType;
    flags = in_struct->flags;
    discardRectangleMode = in_struct->discardRectangleMode;
    discardRectangleCount = in_struct->discardRectangleCount;
    pDiscardRectangles = nullptr;
    pNext = SafePnextCopy(in_struct->pNext);
    if (in_struct->pDiscardRectangles) {
        pDiscardRectangles = new VkRect2D[in_struct->discardRectangleCount];
        memcpy ((void *)pDiscardRectangles, (void *)in_struct->pDiscardRectangles, sizeof(VkRect2D)*in_struct->discardRectangleCount);
    }
}

void safe_VkPipelineDiscardRectangleStateCreateInfoEXT::initialize(const safe_VkPipelineDiscardRectangleStateCreateInfoEXT* src)
{
    sType = src->sType;
    flags = src->flags;
    discardRectangleMode = src->discardRectangleMode;
    discardRectangleCount = src->discardRectangleCount;
    pDiscardRectangles = nullptr;
    pNext = SafePnextCopy(src->pNext);
    if (src->pDiscardRectangles) {
        pDiscardRectangles = new VkRect2D[src->discardRectangleCount];
        memcpy ((void *)pDiscardRectangles, (void *)src->pDiscardRectangles, sizeof(VkRect2D)*src->discardRectangleCount);
    }
}

safe_VkPhysicalDeviceConservativeRasterizationPropertiesEXT::safe_VkPhysicalDeviceConservativeRasterizationPropertiesEXT(const VkPhysicalDeviceConservativeRasterizationPropertiesEXT* in_struct) :
    sType(in_struct->sType),
    primitiveOverestimationSize(in_struct->primitiveOverestimationSize),
    maxExtraPrimitiveOverestimationSize(in_struct->maxExtraPrimitiveOverestimationSize),
    extraPrimitiveOverestimationSizeGranularity(in_struct->extraPrimitiveOverestimationSizeGranularity),
    primitiveUnderestimation(in_struct->primitiveUnderestimation),
    conservativePointAndLineRasterization(in_struct->conservativePointAndLineRasterization),
    degenerateTrianglesRasterized(in_struct->degenerateTrianglesRasterized),
    degenerateLinesRasterized(in_struct->degenerateLinesRasterized),
    fullyCoveredFragmentShaderInputVariable(in_struct->fullyCoveredFragmentShaderInputVariable),
    conservativeRasterizationPostDepthCoverage(in_struct->conservativeRasterizationPostDepthCoverage)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkPhysicalDeviceConservativeRasterizationPropertiesEXT::safe_VkPhysicalDeviceConservativeRasterizationPropertiesEXT() :
    pNext(nullptr)
{}

safe_VkPhysicalDeviceConservativeRasterizationPropertiesEXT::safe_VkPhysicalDeviceConservativeRasterizationPropertiesEXT(const safe_VkPhysicalDeviceConservativeRasterizationPropertiesEXT& src)
{
    sType = src.sType;
    primitiveOverestimationSize = src.primitiveOverestimationSize;
    maxExtraPrimitiveOverestimationSize = src.maxExtraPrimitiveOverestimationSize;
    extraPrimitiveOverestimationSizeGranularity = src.extraPrimitiveOverestimationSizeGranularity;
    primitiveUnderestimation = src.primitiveUnderestimation;
    conservativePointAndLineRasterization = src.conservativePointAndLineRasterization;
    degenerateTrianglesRasterized = src.degenerateTrianglesRasterized;
    degenerateLinesRasterized = src.degenerateLinesRasterized;
    fullyCoveredFragmentShaderInputVariable = src.fullyCoveredFragmentShaderInputVariable;
    conservativeRasterizationPostDepthCoverage = src.conservativeRasterizationPostDepthCoverage;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkPhysicalDeviceConservativeRasterizationPropertiesEXT& safe_VkPhysicalDeviceConservativeRasterizationPropertiesEXT::operator=(const safe_VkPhysicalDeviceConservativeRasterizationPropertiesEXT& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    primitiveOverestimationSize = src.primitiveOverestimationSize;
    maxExtraPrimitiveOverestimationSize = src.maxExtraPrimitiveOverestimationSize;
    extraPrimitiveOverestimationSizeGranularity = src.extraPrimitiveOverestimationSizeGranularity;
    primitiveUnderestimation = src.primitiveUnderestimation;
    conservativePointAndLineRasterization = src.conservativePointAndLineRasterization;
    degenerateTrianglesRasterized = src.degenerateTrianglesRasterized;
    degenerateLinesRasterized = src.degenerateLinesRasterized;
    fullyCoveredFragmentShaderInputVariable = src.fullyCoveredFragmentShaderInputVariable;
    conservativeRasterizationPostDepthCoverage = src.conservativeRasterizationPostDepthCoverage;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkPhysicalDeviceConservativeRasterizationPropertiesEXT::~safe_VkPhysicalDeviceConservativeRasterizationPropertiesEXT()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPhysicalDeviceConservativeRasterizationPropertiesEXT::initialize(const VkPhysicalDeviceConservativeRasterizationPropertiesEXT* in_struct)
{
    sType = in_struct->sType;
    primitiveOverestimationSize = in_struct->primitiveOverestimationSize;
    maxExtraPrimitiveOverestimationSize = in_struct->maxExtraPrimitiveOverestimationSize;
    extraPrimitiveOverestimationSizeGranularity = in_struct->extraPrimitiveOverestimationSizeGranularity;
    primitiveUnderestimation = in_struct->primitiveUnderestimation;
    conservativePointAndLineRasterization = in_struct->conservativePointAndLineRasterization;
    degenerateTrianglesRasterized = in_struct->degenerateTrianglesRasterized;
    degenerateLinesRasterized = in_struct->degenerateLinesRasterized;
    fullyCoveredFragmentShaderInputVariable = in_struct->fullyCoveredFragmentShaderInputVariable;
    conservativeRasterizationPostDepthCoverage = in_struct->conservativeRasterizationPostDepthCoverage;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkPhysicalDeviceConservativeRasterizationPropertiesEXT::initialize(const safe_VkPhysicalDeviceConservativeRasterizationPropertiesEXT* src)
{
    sType = src->sType;
    primitiveOverestimationSize = src->primitiveOverestimationSize;
    maxExtraPrimitiveOverestimationSize = src->maxExtraPrimitiveOverestimationSize;
    extraPrimitiveOverestimationSizeGranularity = src->extraPrimitiveOverestimationSizeGranularity;
    primitiveUnderestimation = src->primitiveUnderestimation;
    conservativePointAndLineRasterization = src->conservativePointAndLineRasterization;
    degenerateTrianglesRasterized = src->degenerateTrianglesRasterized;
    degenerateLinesRasterized = src->degenerateLinesRasterized;
    fullyCoveredFragmentShaderInputVariable = src->fullyCoveredFragmentShaderInputVariable;
    conservativeRasterizationPostDepthCoverage = src->conservativeRasterizationPostDepthCoverage;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkPipelineRasterizationConservativeStateCreateInfoEXT::safe_VkPipelineRasterizationConservativeStateCreateInfoEXT(const VkPipelineRasterizationConservativeStateCreateInfoEXT* in_struct) :
    sType(in_struct->sType),
    flags(in_struct->flags),
    conservativeRasterizationMode(in_struct->conservativeRasterizationMode),
    extraPrimitiveOverestimationSize(in_struct->extraPrimitiveOverestimationSize)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkPipelineRasterizationConservativeStateCreateInfoEXT::safe_VkPipelineRasterizationConservativeStateCreateInfoEXT() :
    pNext(nullptr)
{}

safe_VkPipelineRasterizationConservativeStateCreateInfoEXT::safe_VkPipelineRasterizationConservativeStateCreateInfoEXT(const safe_VkPipelineRasterizationConservativeStateCreateInfoEXT& src)
{
    sType = src.sType;
    flags = src.flags;
    conservativeRasterizationMode = src.conservativeRasterizationMode;
    extraPrimitiveOverestimationSize = src.extraPrimitiveOverestimationSize;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkPipelineRasterizationConservativeStateCreateInfoEXT& safe_VkPipelineRasterizationConservativeStateCreateInfoEXT::operator=(const safe_VkPipelineRasterizationConservativeStateCreateInfoEXT& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    flags = src.flags;
    conservativeRasterizationMode = src.conservativeRasterizationMode;
    extraPrimitiveOverestimationSize = src.extraPrimitiveOverestimationSize;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkPipelineRasterizationConservativeStateCreateInfoEXT::~safe_VkPipelineRasterizationConservativeStateCreateInfoEXT()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPipelineRasterizationConservativeStateCreateInfoEXT::initialize(const VkPipelineRasterizationConservativeStateCreateInfoEXT* in_struct)
{
    sType = in_struct->sType;
    flags = in_struct->flags;
    conservativeRasterizationMode = in_struct->conservativeRasterizationMode;
    extraPrimitiveOverestimationSize = in_struct->extraPrimitiveOverestimationSize;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkPipelineRasterizationConservativeStateCreateInfoEXT::initialize(const safe_VkPipelineRasterizationConservativeStateCreateInfoEXT* src)
{
    sType = src->sType;
    flags = src->flags;
    conservativeRasterizationMode = src->conservativeRasterizationMode;
    extraPrimitiveOverestimationSize = src->extraPrimitiveOverestimationSize;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkPhysicalDeviceDepthClipEnableFeaturesEXT::safe_VkPhysicalDeviceDepthClipEnableFeaturesEXT(const VkPhysicalDeviceDepthClipEnableFeaturesEXT* in_struct) :
    sType(in_struct->sType),
    depthClipEnable(in_struct->depthClipEnable)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkPhysicalDeviceDepthClipEnableFeaturesEXT::safe_VkPhysicalDeviceDepthClipEnableFeaturesEXT() :
    pNext(nullptr)
{}

safe_VkPhysicalDeviceDepthClipEnableFeaturesEXT::safe_VkPhysicalDeviceDepthClipEnableFeaturesEXT(const safe_VkPhysicalDeviceDepthClipEnableFeaturesEXT& src)
{
    sType = src.sType;
    depthClipEnable = src.depthClipEnable;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkPhysicalDeviceDepthClipEnableFeaturesEXT& safe_VkPhysicalDeviceDepthClipEnableFeaturesEXT::operator=(const safe_VkPhysicalDeviceDepthClipEnableFeaturesEXT& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    depthClipEnable = src.depthClipEnable;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkPhysicalDeviceDepthClipEnableFeaturesEXT::~safe_VkPhysicalDeviceDepthClipEnableFeaturesEXT()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPhysicalDeviceDepthClipEnableFeaturesEXT::initialize(const VkPhysicalDeviceDepthClipEnableFeaturesEXT* in_struct)
{
    sType = in_struct->sType;
    depthClipEnable = in_struct->depthClipEnable;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkPhysicalDeviceDepthClipEnableFeaturesEXT::initialize(const safe_VkPhysicalDeviceDepthClipEnableFeaturesEXT* src)
{
    sType = src->sType;
    depthClipEnable = src->depthClipEnable;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkPipelineRasterizationDepthClipStateCreateInfoEXT::safe_VkPipelineRasterizationDepthClipStateCreateInfoEXT(const VkPipelineRasterizationDepthClipStateCreateInfoEXT* in_struct) :
    sType(in_struct->sType),
    flags(in_struct->flags),
    depthClipEnable(in_struct->depthClipEnable)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkPipelineRasterizationDepthClipStateCreateInfoEXT::safe_VkPipelineRasterizationDepthClipStateCreateInfoEXT() :
    pNext(nullptr)
{}

safe_VkPipelineRasterizationDepthClipStateCreateInfoEXT::safe_VkPipelineRasterizationDepthClipStateCreateInfoEXT(const safe_VkPipelineRasterizationDepthClipStateCreateInfoEXT& src)
{
    sType = src.sType;
    flags = src.flags;
    depthClipEnable = src.depthClipEnable;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkPipelineRasterizationDepthClipStateCreateInfoEXT& safe_VkPipelineRasterizationDepthClipStateCreateInfoEXT::operator=(const safe_VkPipelineRasterizationDepthClipStateCreateInfoEXT& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    flags = src.flags;
    depthClipEnable = src.depthClipEnable;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkPipelineRasterizationDepthClipStateCreateInfoEXT::~safe_VkPipelineRasterizationDepthClipStateCreateInfoEXT()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPipelineRasterizationDepthClipStateCreateInfoEXT::initialize(const VkPipelineRasterizationDepthClipStateCreateInfoEXT* in_struct)
{
    sType = in_struct->sType;
    flags = in_struct->flags;
    depthClipEnable = in_struct->depthClipEnable;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkPipelineRasterizationDepthClipStateCreateInfoEXT::initialize(const safe_VkPipelineRasterizationDepthClipStateCreateInfoEXT* src)
{
    sType = src->sType;
    flags = src->flags;
    depthClipEnable = src->depthClipEnable;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkHdrMetadataEXT::safe_VkHdrMetadataEXT(const VkHdrMetadataEXT* in_struct) :
    sType(in_struct->sType),
    displayPrimaryRed(in_struct->displayPrimaryRed),
    displayPrimaryGreen(in_struct->displayPrimaryGreen),
    displayPrimaryBlue(in_struct->displayPrimaryBlue),
    whitePoint(in_struct->whitePoint),
    maxLuminance(in_struct->maxLuminance),
    minLuminance(in_struct->minLuminance),
    maxContentLightLevel(in_struct->maxContentLightLevel),
    maxFrameAverageLightLevel(in_struct->maxFrameAverageLightLevel)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkHdrMetadataEXT::safe_VkHdrMetadataEXT() :
    pNext(nullptr)
{}

safe_VkHdrMetadataEXT::safe_VkHdrMetadataEXT(const safe_VkHdrMetadataEXT& src)
{
    sType = src.sType;
    displayPrimaryRed = src.displayPrimaryRed;
    displayPrimaryGreen = src.displayPrimaryGreen;
    displayPrimaryBlue = src.displayPrimaryBlue;
    whitePoint = src.whitePoint;
    maxLuminance = src.maxLuminance;
    minLuminance = src.minLuminance;
    maxContentLightLevel = src.maxContentLightLevel;
    maxFrameAverageLightLevel = src.maxFrameAverageLightLevel;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkHdrMetadataEXT& safe_VkHdrMetadataEXT::operator=(const safe_VkHdrMetadataEXT& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    displayPrimaryRed = src.displayPrimaryRed;
    displayPrimaryGreen = src.displayPrimaryGreen;
    displayPrimaryBlue = src.displayPrimaryBlue;
    whitePoint = src.whitePoint;
    maxLuminance = src.maxLuminance;
    minLuminance = src.minLuminance;
    maxContentLightLevel = src.maxContentLightLevel;
    maxFrameAverageLightLevel = src.maxFrameAverageLightLevel;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkHdrMetadataEXT::~safe_VkHdrMetadataEXT()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkHdrMetadataEXT::initialize(const VkHdrMetadataEXT* in_struct)
{
    sType = in_struct->sType;
    displayPrimaryRed = in_struct->displayPrimaryRed;
    displayPrimaryGreen = in_struct->displayPrimaryGreen;
    displayPrimaryBlue = in_struct->displayPrimaryBlue;
    whitePoint = in_struct->whitePoint;
    maxLuminance = in_struct->maxLuminance;
    minLuminance = in_struct->minLuminance;
    maxContentLightLevel = in_struct->maxContentLightLevel;
    maxFrameAverageLightLevel = in_struct->maxFrameAverageLightLevel;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkHdrMetadataEXT::initialize(const safe_VkHdrMetadataEXT* src)
{
    sType = src->sType;
    displayPrimaryRed = src->displayPrimaryRed;
    displayPrimaryGreen = src->displayPrimaryGreen;
    displayPrimaryBlue = src->displayPrimaryBlue;
    whitePoint = src->whitePoint;
    maxLuminance = src->maxLuminance;
    minLuminance = src->minLuminance;
    maxContentLightLevel = src->maxContentLightLevel;
    maxFrameAverageLightLevel = src->maxFrameAverageLightLevel;
    pNext = SafePnextCopy(src->pNext);
}
#ifdef VK_USE_PLATFORM_IOS_MVK


safe_VkIOSSurfaceCreateInfoMVK::safe_VkIOSSurfaceCreateInfoMVK(const VkIOSSurfaceCreateInfoMVK* in_struct) :
    sType(in_struct->sType),
    flags(in_struct->flags),
    pView(in_struct->pView)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkIOSSurfaceCreateInfoMVK::safe_VkIOSSurfaceCreateInfoMVK() :
    pNext(nullptr),
    pView(nullptr)
{}

safe_VkIOSSurfaceCreateInfoMVK::safe_VkIOSSurfaceCreateInfoMVK(const safe_VkIOSSurfaceCreateInfoMVK& src)
{
    sType = src.sType;
    flags = src.flags;
    pView = src.pView;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkIOSSurfaceCreateInfoMVK& safe_VkIOSSurfaceCreateInfoMVK::operator=(const safe_VkIOSSurfaceCreateInfoMVK& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    flags = src.flags;
    pView = src.pView;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkIOSSurfaceCreateInfoMVK::~safe_VkIOSSurfaceCreateInfoMVK()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkIOSSurfaceCreateInfoMVK::initialize(const VkIOSSurfaceCreateInfoMVK* in_struct)
{
    sType = in_struct->sType;
    flags = in_struct->flags;
    pView = in_struct->pView;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkIOSSurfaceCreateInfoMVK::initialize(const safe_VkIOSSurfaceCreateInfoMVK* src)
{
    sType = src->sType;
    flags = src->flags;
    pView = src->pView;
    pNext = SafePnextCopy(src->pNext);
}
#endif // VK_USE_PLATFORM_IOS_MVK

#ifdef VK_USE_PLATFORM_MACOS_MVK


safe_VkMacOSSurfaceCreateInfoMVK::safe_VkMacOSSurfaceCreateInfoMVK(const VkMacOSSurfaceCreateInfoMVK* in_struct) :
    sType(in_struct->sType),
    flags(in_struct->flags),
    pView(in_struct->pView)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkMacOSSurfaceCreateInfoMVK::safe_VkMacOSSurfaceCreateInfoMVK() :
    pNext(nullptr),
    pView(nullptr)
{}

safe_VkMacOSSurfaceCreateInfoMVK::safe_VkMacOSSurfaceCreateInfoMVK(const safe_VkMacOSSurfaceCreateInfoMVK& src)
{
    sType = src.sType;
    flags = src.flags;
    pView = src.pView;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkMacOSSurfaceCreateInfoMVK& safe_VkMacOSSurfaceCreateInfoMVK::operator=(const safe_VkMacOSSurfaceCreateInfoMVK& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    flags = src.flags;
    pView = src.pView;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkMacOSSurfaceCreateInfoMVK::~safe_VkMacOSSurfaceCreateInfoMVK()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkMacOSSurfaceCreateInfoMVK::initialize(const VkMacOSSurfaceCreateInfoMVK* in_struct)
{
    sType = in_struct->sType;
    flags = in_struct->flags;
    pView = in_struct->pView;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkMacOSSurfaceCreateInfoMVK::initialize(const safe_VkMacOSSurfaceCreateInfoMVK* src)
{
    sType = src->sType;
    flags = src->flags;
    pView = src->pView;
    pNext = SafePnextCopy(src->pNext);
}
#endif // VK_USE_PLATFORM_MACOS_MVK


safe_VkDebugUtilsObjectNameInfoEXT::safe_VkDebugUtilsObjectNameInfoEXT(const VkDebugUtilsObjectNameInfoEXT* in_struct) :
    sType(in_struct->sType),
    objectType(in_struct->objectType),
    objectHandle(in_struct->objectHandle)
{
    pNext = SafePnextCopy(in_struct->pNext);
    pObjectName = SafeStringCopy(in_struct->pObjectName);
}

safe_VkDebugUtilsObjectNameInfoEXT::safe_VkDebugUtilsObjectNameInfoEXT() :
    pNext(nullptr),
    pObjectName(nullptr)
{}

safe_VkDebugUtilsObjectNameInfoEXT::safe_VkDebugUtilsObjectNameInfoEXT(const safe_VkDebugUtilsObjectNameInfoEXT& src)
{
    sType = src.sType;
    objectType = src.objectType;
    objectHandle = src.objectHandle;
    pNext = SafePnextCopy(src.pNext);
    pObjectName = SafeStringCopy(src.pObjectName);
}

safe_VkDebugUtilsObjectNameInfoEXT& safe_VkDebugUtilsObjectNameInfoEXT::operator=(const safe_VkDebugUtilsObjectNameInfoEXT& src)
{
    if (&src == this) return *this;

    if (pObjectName) delete [] pObjectName;
    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    objectType = src.objectType;
    objectHandle = src.objectHandle;
    pNext = SafePnextCopy(src.pNext);
    pObjectName = SafeStringCopy(src.pObjectName);

    return *this;
}

safe_VkDebugUtilsObjectNameInfoEXT::~safe_VkDebugUtilsObjectNameInfoEXT()
{
    if (pObjectName) delete [] pObjectName;
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkDebugUtilsObjectNameInfoEXT::initialize(const VkDebugUtilsObjectNameInfoEXT* in_struct)
{
    sType = in_struct->sType;
    objectType = in_struct->objectType;
    objectHandle = in_struct->objectHandle;
    pNext = SafePnextCopy(in_struct->pNext);
    pObjectName = SafeStringCopy(in_struct->pObjectName);
}

void safe_VkDebugUtilsObjectNameInfoEXT::initialize(const safe_VkDebugUtilsObjectNameInfoEXT* src)
{
    sType = src->sType;
    objectType = src->objectType;
    objectHandle = src->objectHandle;
    pNext = SafePnextCopy(src->pNext);
    pObjectName = SafeStringCopy(src->pObjectName);
}

safe_VkDebugUtilsObjectTagInfoEXT::safe_VkDebugUtilsObjectTagInfoEXT(const VkDebugUtilsObjectTagInfoEXT* in_struct) :
    sType(in_struct->sType),
    objectType(in_struct->objectType),
    objectHandle(in_struct->objectHandle),
    tagName(in_struct->tagName),
    tagSize(in_struct->tagSize),
    pTag(in_struct->pTag)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkDebugUtilsObjectTagInfoEXT::safe_VkDebugUtilsObjectTagInfoEXT() :
    pNext(nullptr),
    pTag(nullptr)
{}

safe_VkDebugUtilsObjectTagInfoEXT::safe_VkDebugUtilsObjectTagInfoEXT(const safe_VkDebugUtilsObjectTagInfoEXT& src)
{
    sType = src.sType;
    objectType = src.objectType;
    objectHandle = src.objectHandle;
    tagName = src.tagName;
    tagSize = src.tagSize;
    pTag = src.pTag;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkDebugUtilsObjectTagInfoEXT& safe_VkDebugUtilsObjectTagInfoEXT::operator=(const safe_VkDebugUtilsObjectTagInfoEXT& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    objectType = src.objectType;
    objectHandle = src.objectHandle;
    tagName = src.tagName;
    tagSize = src.tagSize;
    pTag = src.pTag;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkDebugUtilsObjectTagInfoEXT::~safe_VkDebugUtilsObjectTagInfoEXT()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkDebugUtilsObjectTagInfoEXT::initialize(const VkDebugUtilsObjectTagInfoEXT* in_struct)
{
    sType = in_struct->sType;
    objectType = in_struct->objectType;
    objectHandle = in_struct->objectHandle;
    tagName = in_struct->tagName;
    tagSize = in_struct->tagSize;
    pTag = in_struct->pTag;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkDebugUtilsObjectTagInfoEXT::initialize(const safe_VkDebugUtilsObjectTagInfoEXT* src)
{
    sType = src->sType;
    objectType = src->objectType;
    objectHandle = src->objectHandle;
    tagName = src->tagName;
    tagSize = src->tagSize;
    pTag = src->pTag;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkDebugUtilsLabelEXT::safe_VkDebugUtilsLabelEXT(const VkDebugUtilsLabelEXT* in_struct) :
    sType(in_struct->sType)
{
    pNext = SafePnextCopy(in_struct->pNext);
    pLabelName = SafeStringCopy(in_struct->pLabelName);
    for (uint32_t i = 0; i < 4; ++i) {
        color[i] = in_struct->color[i];
    }
}

safe_VkDebugUtilsLabelEXT::safe_VkDebugUtilsLabelEXT() :
    pNext(nullptr),
    pLabelName(nullptr)
{}

safe_VkDebugUtilsLabelEXT::safe_VkDebugUtilsLabelEXT(const safe_VkDebugUtilsLabelEXT& src)
{
    sType = src.sType;
    pNext = SafePnextCopy(src.pNext);
    pLabelName = SafeStringCopy(src.pLabelName);
    for (uint32_t i = 0; i < 4; ++i) {
        color[i] = src.color[i];
    }
}

safe_VkDebugUtilsLabelEXT& safe_VkDebugUtilsLabelEXT::operator=(const safe_VkDebugUtilsLabelEXT& src)
{
    if (&src == this) return *this;

    if (pLabelName) delete [] pLabelName;
    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    pNext = SafePnextCopy(src.pNext);
    pLabelName = SafeStringCopy(src.pLabelName);
    for (uint32_t i = 0; i < 4; ++i) {
        color[i] = src.color[i];
    }

    return *this;
}

safe_VkDebugUtilsLabelEXT::~safe_VkDebugUtilsLabelEXT()
{
    if (pLabelName) delete [] pLabelName;
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkDebugUtilsLabelEXT::initialize(const VkDebugUtilsLabelEXT* in_struct)
{
    sType = in_struct->sType;
    pNext = SafePnextCopy(in_struct->pNext);
    pLabelName = SafeStringCopy(in_struct->pLabelName);
    for (uint32_t i = 0; i < 4; ++i) {
        color[i] = in_struct->color[i];
    }
}

void safe_VkDebugUtilsLabelEXT::initialize(const safe_VkDebugUtilsLabelEXT* src)
{
    sType = src->sType;
    pNext = SafePnextCopy(src->pNext);
    pLabelName = SafeStringCopy(src->pLabelName);
    for (uint32_t i = 0; i < 4; ++i) {
        color[i] = src->color[i];
    }
}

safe_VkDebugUtilsMessengerCallbackDataEXT::safe_VkDebugUtilsMessengerCallbackDataEXT(const VkDebugUtilsMessengerCallbackDataEXT* in_struct) :
    sType(in_struct->sType),
    flags(in_struct->flags),
    messageIdNumber(in_struct->messageIdNumber),
    queueLabelCount(in_struct->queueLabelCount),
    pQueueLabels(nullptr),
    cmdBufLabelCount(in_struct->cmdBufLabelCount),
    pCmdBufLabels(nullptr),
    objectCount(in_struct->objectCount),
    pObjects(nullptr)
{
    pNext = SafePnextCopy(in_struct->pNext);
    pMessageIdName = SafeStringCopy(in_struct->pMessageIdName);
    pMessage = SafeStringCopy(in_struct->pMessage);
    if (queueLabelCount && in_struct->pQueueLabels) {
        pQueueLabels = new safe_VkDebugUtilsLabelEXT[queueLabelCount];
        for (uint32_t i = 0; i < queueLabelCount; ++i) {
            pQueueLabels[i].initialize(&in_struct->pQueueLabels[i]);
        }
    }
    if (cmdBufLabelCount && in_struct->pCmdBufLabels) {
        pCmdBufLabels = new safe_VkDebugUtilsLabelEXT[cmdBufLabelCount];
        for (uint32_t i = 0; i < cmdBufLabelCount; ++i) {
            pCmdBufLabels[i].initialize(&in_struct->pCmdBufLabels[i]);
        }
    }
    if (objectCount && in_struct->pObjects) {
        pObjects = new safe_VkDebugUtilsObjectNameInfoEXT[objectCount];
        for (uint32_t i = 0; i < objectCount; ++i) {
            pObjects[i].initialize(&in_struct->pObjects[i]);
        }
    }
}

safe_VkDebugUtilsMessengerCallbackDataEXT::safe_VkDebugUtilsMessengerCallbackDataEXT() :
    pNext(nullptr),
    pMessageIdName(nullptr),
    pMessage(nullptr),
    pQueueLabels(nullptr),
    pCmdBufLabels(nullptr),
    pObjects(nullptr)
{}

safe_VkDebugUtilsMessengerCallbackDataEXT::safe_VkDebugUtilsMessengerCallbackDataEXT(const safe_VkDebugUtilsMessengerCallbackDataEXT& src)
{
    sType = src.sType;
    flags = src.flags;
    messageIdNumber = src.messageIdNumber;
    queueLabelCount = src.queueLabelCount;
    pQueueLabels = nullptr;
    cmdBufLabelCount = src.cmdBufLabelCount;
    pCmdBufLabels = nullptr;
    objectCount = src.objectCount;
    pObjects = nullptr;
    pNext = SafePnextCopy(src.pNext);
    pMessageIdName = SafeStringCopy(src.pMessageIdName);
    pMessage = SafeStringCopy(src.pMessage);
    if (queueLabelCount && src.pQueueLabels) {
        pQueueLabels = new safe_VkDebugUtilsLabelEXT[queueLabelCount];
        for (uint32_t i = 0; i < queueLabelCount; ++i) {
            pQueueLabels[i].initialize(&src.pQueueLabels[i]);
        }
    }
    if (cmdBufLabelCount && src.pCmdBufLabels) {
        pCmdBufLabels = new safe_VkDebugUtilsLabelEXT[cmdBufLabelCount];
        for (uint32_t i = 0; i < cmdBufLabelCount; ++i) {
            pCmdBufLabels[i].initialize(&src.pCmdBufLabels[i]);
        }
    }
    if (objectCount && src.pObjects) {
        pObjects = new safe_VkDebugUtilsObjectNameInfoEXT[objectCount];
        for (uint32_t i = 0; i < objectCount; ++i) {
            pObjects[i].initialize(&src.pObjects[i]);
        }
    }
}

safe_VkDebugUtilsMessengerCallbackDataEXT& safe_VkDebugUtilsMessengerCallbackDataEXT::operator=(const safe_VkDebugUtilsMessengerCallbackDataEXT& src)
{
    if (&src == this) return *this;

    if (pMessageIdName) delete [] pMessageIdName;
    if (pMessage) delete [] pMessage;
    if (pQueueLabels)
        delete[] pQueueLabels;
    if (pCmdBufLabels)
        delete[] pCmdBufLabels;
    if (pObjects)
        delete[] pObjects;
    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    flags = src.flags;
    messageIdNumber = src.messageIdNumber;
    queueLabelCount = src.queueLabelCount;
    pQueueLabels = nullptr;
    cmdBufLabelCount = src.cmdBufLabelCount;
    pCmdBufLabels = nullptr;
    objectCount = src.objectCount;
    pObjects = nullptr;
    pNext = SafePnextCopy(src.pNext);
    pMessageIdName = SafeStringCopy(src.pMessageIdName);
    pMessage = SafeStringCopy(src.pMessage);
    if (queueLabelCount && src.pQueueLabels) {
        pQueueLabels = new safe_VkDebugUtilsLabelEXT[queueLabelCount];
        for (uint32_t i = 0; i < queueLabelCount; ++i) {
            pQueueLabels[i].initialize(&src.pQueueLabels[i]);
        }
    }
    if (cmdBufLabelCount && src.pCmdBufLabels) {
        pCmdBufLabels = new safe_VkDebugUtilsLabelEXT[cmdBufLabelCount];
        for (uint32_t i = 0; i < cmdBufLabelCount; ++i) {
            pCmdBufLabels[i].initialize(&src.pCmdBufLabels[i]);
        }
    }
    if (objectCount && src.pObjects) {
        pObjects = new safe_VkDebugUtilsObjectNameInfoEXT[objectCount];
        for (uint32_t i = 0; i < objectCount; ++i) {
            pObjects[i].initialize(&src.pObjects[i]);
        }
    }

    return *this;
}

safe_VkDebugUtilsMessengerCallbackDataEXT::~safe_VkDebugUtilsMessengerCallbackDataEXT()
{
    if (pMessageIdName) delete [] pMessageIdName;
    if (pMessage) delete [] pMessage;
    if (pQueueLabels)
        delete[] pQueueLabels;
    if (pCmdBufLabels)
        delete[] pCmdBufLabels;
    if (pObjects)
        delete[] pObjects;
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkDebugUtilsMessengerCallbackDataEXT::initialize(const VkDebugUtilsMessengerCallbackDataEXT* in_struct)
{
    sType = in_struct->sType;
    flags = in_struct->flags;
    messageIdNumber = in_struct->messageIdNumber;
    queueLabelCount = in_struct->queueLabelCount;
    pQueueLabels = nullptr;
    cmdBufLabelCount = in_struct->cmdBufLabelCount;
    pCmdBufLabels = nullptr;
    objectCount = in_struct->objectCount;
    pObjects = nullptr;
    pNext = SafePnextCopy(in_struct->pNext);
    pMessageIdName = SafeStringCopy(in_struct->pMessageIdName);
    pMessage = SafeStringCopy(in_struct->pMessage);
    if (queueLabelCount && in_struct->pQueueLabels) {
        pQueueLabels = new safe_VkDebugUtilsLabelEXT[queueLabelCount];
        for (uint32_t i = 0; i < queueLabelCount; ++i) {
            pQueueLabels[i].initialize(&in_struct->pQueueLabels[i]);
        }
    }
    if (cmdBufLabelCount && in_struct->pCmdBufLabels) {
        pCmdBufLabels = new safe_VkDebugUtilsLabelEXT[cmdBufLabelCount];
        for (uint32_t i = 0; i < cmdBufLabelCount; ++i) {
            pCmdBufLabels[i].initialize(&in_struct->pCmdBufLabels[i]);
        }
    }
    if (objectCount && in_struct->pObjects) {
        pObjects = new safe_VkDebugUtilsObjectNameInfoEXT[objectCount];
        for (uint32_t i = 0; i < objectCount; ++i) {
            pObjects[i].initialize(&in_struct->pObjects[i]);
        }
    }
}

void safe_VkDebugUtilsMessengerCallbackDataEXT::initialize(const safe_VkDebugUtilsMessengerCallbackDataEXT* src)
{
    sType = src->sType;
    flags = src->flags;
    messageIdNumber = src->messageIdNumber;
    queueLabelCount = src->queueLabelCount;
    pQueueLabels = nullptr;
    cmdBufLabelCount = src->cmdBufLabelCount;
    pCmdBufLabels = nullptr;
    objectCount = src->objectCount;
    pObjects = nullptr;
    pNext = SafePnextCopy(src->pNext);
    pMessageIdName = SafeStringCopy(src->pMessageIdName);
    pMessage = SafeStringCopy(src->pMessage);
    if (queueLabelCount && src->pQueueLabels) {
        pQueueLabels = new safe_VkDebugUtilsLabelEXT[queueLabelCount];
        for (uint32_t i = 0; i < queueLabelCount; ++i) {
            pQueueLabels[i].initialize(&src->pQueueLabels[i]);
        }
    }
    if (cmdBufLabelCount && src->pCmdBufLabels) {
        pCmdBufLabels = new safe_VkDebugUtilsLabelEXT[cmdBufLabelCount];
        for (uint32_t i = 0; i < cmdBufLabelCount; ++i) {
            pCmdBufLabels[i].initialize(&src->pCmdBufLabels[i]);
        }
    }
    if (objectCount && src->pObjects) {
        pObjects = new safe_VkDebugUtilsObjectNameInfoEXT[objectCount];
        for (uint32_t i = 0; i < objectCount; ++i) {
            pObjects[i].initialize(&src->pObjects[i]);
        }
    }
}

safe_VkDebugUtilsMessengerCreateInfoEXT::safe_VkDebugUtilsMessengerCreateInfoEXT(const VkDebugUtilsMessengerCreateInfoEXT* in_struct) :
    sType(in_struct->sType),
    flags(in_struct->flags),
    messageSeverity(in_struct->messageSeverity),
    messageType(in_struct->messageType),
    pfnUserCallback(in_struct->pfnUserCallback),
    pUserData(in_struct->pUserData)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkDebugUtilsMessengerCreateInfoEXT::safe_VkDebugUtilsMessengerCreateInfoEXT() :
    pNext(nullptr),
    pUserData(nullptr)
{}

safe_VkDebugUtilsMessengerCreateInfoEXT::safe_VkDebugUtilsMessengerCreateInfoEXT(const safe_VkDebugUtilsMessengerCreateInfoEXT& src)
{
    sType = src.sType;
    flags = src.flags;
    messageSeverity = src.messageSeverity;
    messageType = src.messageType;
    pfnUserCallback = src.pfnUserCallback;
    pUserData = src.pUserData;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkDebugUtilsMessengerCreateInfoEXT& safe_VkDebugUtilsMessengerCreateInfoEXT::operator=(const safe_VkDebugUtilsMessengerCreateInfoEXT& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    flags = src.flags;
    messageSeverity = src.messageSeverity;
    messageType = src.messageType;
    pfnUserCallback = src.pfnUserCallback;
    pUserData = src.pUserData;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkDebugUtilsMessengerCreateInfoEXT::~safe_VkDebugUtilsMessengerCreateInfoEXT()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkDebugUtilsMessengerCreateInfoEXT::initialize(const VkDebugUtilsMessengerCreateInfoEXT* in_struct)
{
    sType = in_struct->sType;
    flags = in_struct->flags;
    messageSeverity = in_struct->messageSeverity;
    messageType = in_struct->messageType;
    pfnUserCallback = in_struct->pfnUserCallback;
    pUserData = in_struct->pUserData;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkDebugUtilsMessengerCreateInfoEXT::initialize(const safe_VkDebugUtilsMessengerCreateInfoEXT* src)
{
    sType = src->sType;
    flags = src->flags;
    messageSeverity = src->messageSeverity;
    messageType = src->messageType;
    pfnUserCallback = src->pfnUserCallback;
    pUserData = src->pUserData;
    pNext = SafePnextCopy(src->pNext);
}
#ifdef VK_USE_PLATFORM_ANDROID_KHR


safe_VkAndroidHardwareBufferUsageANDROID::safe_VkAndroidHardwareBufferUsageANDROID(const VkAndroidHardwareBufferUsageANDROID* in_struct) :
    sType(in_struct->sType),
    androidHardwareBufferUsage(in_struct->androidHardwareBufferUsage)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkAndroidHardwareBufferUsageANDROID::safe_VkAndroidHardwareBufferUsageANDROID() :
    pNext(nullptr)
{}

safe_VkAndroidHardwareBufferUsageANDROID::safe_VkAndroidHardwareBufferUsageANDROID(const safe_VkAndroidHardwareBufferUsageANDROID& src)
{
    sType = src.sType;
    androidHardwareBufferUsage = src.androidHardwareBufferUsage;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkAndroidHardwareBufferUsageANDROID& safe_VkAndroidHardwareBufferUsageANDROID::operator=(const safe_VkAndroidHardwareBufferUsageANDROID& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    androidHardwareBufferUsage = src.androidHardwareBufferUsage;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkAndroidHardwareBufferUsageANDROID::~safe_VkAndroidHardwareBufferUsageANDROID()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkAndroidHardwareBufferUsageANDROID::initialize(const VkAndroidHardwareBufferUsageANDROID* in_struct)
{
    sType = in_struct->sType;
    androidHardwareBufferUsage = in_struct->androidHardwareBufferUsage;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkAndroidHardwareBufferUsageANDROID::initialize(const safe_VkAndroidHardwareBufferUsageANDROID* src)
{
    sType = src->sType;
    androidHardwareBufferUsage = src->androidHardwareBufferUsage;
    pNext = SafePnextCopy(src->pNext);
}
#endif // VK_USE_PLATFORM_ANDROID_KHR

#ifdef VK_USE_PLATFORM_ANDROID_KHR


safe_VkAndroidHardwareBufferPropertiesANDROID::safe_VkAndroidHardwareBufferPropertiesANDROID(const VkAndroidHardwareBufferPropertiesANDROID* in_struct) :
    sType(in_struct->sType),
    allocationSize(in_struct->allocationSize),
    memoryTypeBits(in_struct->memoryTypeBits)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkAndroidHardwareBufferPropertiesANDROID::safe_VkAndroidHardwareBufferPropertiesANDROID() :
    pNext(nullptr)
{}

safe_VkAndroidHardwareBufferPropertiesANDROID::safe_VkAndroidHardwareBufferPropertiesANDROID(const safe_VkAndroidHardwareBufferPropertiesANDROID& src)
{
    sType = src.sType;
    allocationSize = src.allocationSize;
    memoryTypeBits = src.memoryTypeBits;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkAndroidHardwareBufferPropertiesANDROID& safe_VkAndroidHardwareBufferPropertiesANDROID::operator=(const safe_VkAndroidHardwareBufferPropertiesANDROID& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    allocationSize = src.allocationSize;
    memoryTypeBits = src.memoryTypeBits;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkAndroidHardwareBufferPropertiesANDROID::~safe_VkAndroidHardwareBufferPropertiesANDROID()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkAndroidHardwareBufferPropertiesANDROID::initialize(const VkAndroidHardwareBufferPropertiesANDROID* in_struct)
{
    sType = in_struct->sType;
    allocationSize = in_struct->allocationSize;
    memoryTypeBits = in_struct->memoryTypeBits;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkAndroidHardwareBufferPropertiesANDROID::initialize(const safe_VkAndroidHardwareBufferPropertiesANDROID* src)
{
    sType = src->sType;
    allocationSize = src->allocationSize;
    memoryTypeBits = src->memoryTypeBits;
    pNext = SafePnextCopy(src->pNext);
}
#endif // VK_USE_PLATFORM_ANDROID_KHR

#ifdef VK_USE_PLATFORM_ANDROID_KHR


safe_VkAndroidHardwareBufferFormatPropertiesANDROID::safe_VkAndroidHardwareBufferFormatPropertiesANDROID(const VkAndroidHardwareBufferFormatPropertiesANDROID* in_struct) :
    sType(in_struct->sType),
    format(in_struct->format),
    externalFormat(in_struct->externalFormat),
    formatFeatures(in_struct->formatFeatures),
    samplerYcbcrConversionComponents(in_struct->samplerYcbcrConversionComponents),
    suggestedYcbcrModel(in_struct->suggestedYcbcrModel),
    suggestedYcbcrRange(in_struct->suggestedYcbcrRange),
    suggestedXChromaOffset(in_struct->suggestedXChromaOffset),
    suggestedYChromaOffset(in_struct->suggestedYChromaOffset)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkAndroidHardwareBufferFormatPropertiesANDROID::safe_VkAndroidHardwareBufferFormatPropertiesANDROID() :
    pNext(nullptr)
{}

safe_VkAndroidHardwareBufferFormatPropertiesANDROID::safe_VkAndroidHardwareBufferFormatPropertiesANDROID(const safe_VkAndroidHardwareBufferFormatPropertiesANDROID& src)
{
    sType = src.sType;
    format = src.format;
    externalFormat = src.externalFormat;
    formatFeatures = src.formatFeatures;
    samplerYcbcrConversionComponents = src.samplerYcbcrConversionComponents;
    suggestedYcbcrModel = src.suggestedYcbcrModel;
    suggestedYcbcrRange = src.suggestedYcbcrRange;
    suggestedXChromaOffset = src.suggestedXChromaOffset;
    suggestedYChromaOffset = src.suggestedYChromaOffset;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkAndroidHardwareBufferFormatPropertiesANDROID& safe_VkAndroidHardwareBufferFormatPropertiesANDROID::operator=(const safe_VkAndroidHardwareBufferFormatPropertiesANDROID& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    format = src.format;
    externalFormat = src.externalFormat;
    formatFeatures = src.formatFeatures;
    samplerYcbcrConversionComponents = src.samplerYcbcrConversionComponents;
    suggestedYcbcrModel = src.suggestedYcbcrModel;
    suggestedYcbcrRange = src.suggestedYcbcrRange;
    suggestedXChromaOffset = src.suggestedXChromaOffset;
    suggestedYChromaOffset = src.suggestedYChromaOffset;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkAndroidHardwareBufferFormatPropertiesANDROID::~safe_VkAndroidHardwareBufferFormatPropertiesANDROID()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkAndroidHardwareBufferFormatPropertiesANDROID::initialize(const VkAndroidHardwareBufferFormatPropertiesANDROID* in_struct)
{
    sType = in_struct->sType;
    format = in_struct->format;
    externalFormat = in_struct->externalFormat;
    formatFeatures = in_struct->formatFeatures;
    samplerYcbcrConversionComponents = in_struct->samplerYcbcrConversionComponents;
    suggestedYcbcrModel = in_struct->suggestedYcbcrModel;
    suggestedYcbcrRange = in_struct->suggestedYcbcrRange;
    suggestedXChromaOffset = in_struct->suggestedXChromaOffset;
    suggestedYChromaOffset = in_struct->suggestedYChromaOffset;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkAndroidHardwareBufferFormatPropertiesANDROID::initialize(const safe_VkAndroidHardwareBufferFormatPropertiesANDROID* src)
{
    sType = src->sType;
    format = src->format;
    externalFormat = src->externalFormat;
    formatFeatures = src->formatFeatures;
    samplerYcbcrConversionComponents = src->samplerYcbcrConversionComponents;
    suggestedYcbcrModel = src->suggestedYcbcrModel;
    suggestedYcbcrRange = src->suggestedYcbcrRange;
    suggestedXChromaOffset = src->suggestedXChromaOffset;
    suggestedYChromaOffset = src->suggestedYChromaOffset;
    pNext = SafePnextCopy(src->pNext);
}
#endif // VK_USE_PLATFORM_ANDROID_KHR

#ifdef VK_USE_PLATFORM_ANDROID_KHR


safe_VkImportAndroidHardwareBufferInfoANDROID::safe_VkImportAndroidHardwareBufferInfoANDROID(const VkImportAndroidHardwareBufferInfoANDROID* in_struct) :
    sType(in_struct->sType),
    buffer(nullptr)
{
    pNext = SafePnextCopy(in_struct->pNext);
    buffer = in_struct->buffer;
}

safe_VkImportAndroidHardwareBufferInfoANDROID::safe_VkImportAndroidHardwareBufferInfoANDROID() :
    pNext(nullptr),
    buffer(nullptr)
{}

safe_VkImportAndroidHardwareBufferInfoANDROID::safe_VkImportAndroidHardwareBufferInfoANDROID(const safe_VkImportAndroidHardwareBufferInfoANDROID& src)
{
    sType = src.sType;
    pNext = SafePnextCopy(src.pNext);
    buffer = src.buffer;
}

safe_VkImportAndroidHardwareBufferInfoANDROID& safe_VkImportAndroidHardwareBufferInfoANDROID::operator=(const safe_VkImportAndroidHardwareBufferInfoANDROID& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    pNext = SafePnextCopy(src.pNext);
    buffer = src.buffer;

    return *this;
}

safe_VkImportAndroidHardwareBufferInfoANDROID::~safe_VkImportAndroidHardwareBufferInfoANDROID()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkImportAndroidHardwareBufferInfoANDROID::initialize(const VkImportAndroidHardwareBufferInfoANDROID* in_struct)
{
    sType = in_struct->sType;
    pNext = SafePnextCopy(in_struct->pNext);
    buffer = in_struct->buffer;
}

void safe_VkImportAndroidHardwareBufferInfoANDROID::initialize(const safe_VkImportAndroidHardwareBufferInfoANDROID* src)
{
    sType = src->sType;
    pNext = SafePnextCopy(src->pNext);
    buffer = src->buffer;
}
#endif // VK_USE_PLATFORM_ANDROID_KHR

#ifdef VK_USE_PLATFORM_ANDROID_KHR


safe_VkMemoryGetAndroidHardwareBufferInfoANDROID::safe_VkMemoryGetAndroidHardwareBufferInfoANDROID(const VkMemoryGetAndroidHardwareBufferInfoANDROID* in_struct) :
    sType(in_struct->sType),
    memory(in_struct->memory)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkMemoryGetAndroidHardwareBufferInfoANDROID::safe_VkMemoryGetAndroidHardwareBufferInfoANDROID() :
    pNext(nullptr)
{}

safe_VkMemoryGetAndroidHardwareBufferInfoANDROID::safe_VkMemoryGetAndroidHardwareBufferInfoANDROID(const safe_VkMemoryGetAndroidHardwareBufferInfoANDROID& src)
{
    sType = src.sType;
    memory = src.memory;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkMemoryGetAndroidHardwareBufferInfoANDROID& safe_VkMemoryGetAndroidHardwareBufferInfoANDROID::operator=(const safe_VkMemoryGetAndroidHardwareBufferInfoANDROID& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    memory = src.memory;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkMemoryGetAndroidHardwareBufferInfoANDROID::~safe_VkMemoryGetAndroidHardwareBufferInfoANDROID()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkMemoryGetAndroidHardwareBufferInfoANDROID::initialize(const VkMemoryGetAndroidHardwareBufferInfoANDROID* in_struct)
{
    sType = in_struct->sType;
    memory = in_struct->memory;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkMemoryGetAndroidHardwareBufferInfoANDROID::initialize(const safe_VkMemoryGetAndroidHardwareBufferInfoANDROID* src)
{
    sType = src->sType;
    memory = src->memory;
    pNext = SafePnextCopy(src->pNext);
}
#endif // VK_USE_PLATFORM_ANDROID_KHR

#ifdef VK_USE_PLATFORM_ANDROID_KHR


safe_VkExternalFormatANDROID::safe_VkExternalFormatANDROID(const VkExternalFormatANDROID* in_struct) :
    sType(in_struct->sType),
    externalFormat(in_struct->externalFormat)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkExternalFormatANDROID::safe_VkExternalFormatANDROID() :
    pNext(nullptr)
{}

safe_VkExternalFormatANDROID::safe_VkExternalFormatANDROID(const safe_VkExternalFormatANDROID& src)
{
    sType = src.sType;
    externalFormat = src.externalFormat;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkExternalFormatANDROID& safe_VkExternalFormatANDROID::operator=(const safe_VkExternalFormatANDROID& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    externalFormat = src.externalFormat;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkExternalFormatANDROID::~safe_VkExternalFormatANDROID()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkExternalFormatANDROID::initialize(const VkExternalFormatANDROID* in_struct)
{
    sType = in_struct->sType;
    externalFormat = in_struct->externalFormat;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkExternalFormatANDROID::initialize(const safe_VkExternalFormatANDROID* src)
{
    sType = src->sType;
    externalFormat = src->externalFormat;
    pNext = SafePnextCopy(src->pNext);
}
#endif // VK_USE_PLATFORM_ANDROID_KHR


safe_VkSamplerReductionModeCreateInfoEXT::safe_VkSamplerReductionModeCreateInfoEXT(const VkSamplerReductionModeCreateInfoEXT* in_struct) :
    sType(in_struct->sType),
    reductionMode(in_struct->reductionMode)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkSamplerReductionModeCreateInfoEXT::safe_VkSamplerReductionModeCreateInfoEXT() :
    pNext(nullptr)
{}

safe_VkSamplerReductionModeCreateInfoEXT::safe_VkSamplerReductionModeCreateInfoEXT(const safe_VkSamplerReductionModeCreateInfoEXT& src)
{
    sType = src.sType;
    reductionMode = src.reductionMode;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkSamplerReductionModeCreateInfoEXT& safe_VkSamplerReductionModeCreateInfoEXT::operator=(const safe_VkSamplerReductionModeCreateInfoEXT& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    reductionMode = src.reductionMode;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkSamplerReductionModeCreateInfoEXT::~safe_VkSamplerReductionModeCreateInfoEXT()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkSamplerReductionModeCreateInfoEXT::initialize(const VkSamplerReductionModeCreateInfoEXT* in_struct)
{
    sType = in_struct->sType;
    reductionMode = in_struct->reductionMode;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkSamplerReductionModeCreateInfoEXT::initialize(const safe_VkSamplerReductionModeCreateInfoEXT* src)
{
    sType = src->sType;
    reductionMode = src->reductionMode;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkPhysicalDeviceSamplerFilterMinmaxPropertiesEXT::safe_VkPhysicalDeviceSamplerFilterMinmaxPropertiesEXT(const VkPhysicalDeviceSamplerFilterMinmaxPropertiesEXT* in_struct) :
    sType(in_struct->sType),
    filterMinmaxSingleComponentFormats(in_struct->filterMinmaxSingleComponentFormats),
    filterMinmaxImageComponentMapping(in_struct->filterMinmaxImageComponentMapping)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkPhysicalDeviceSamplerFilterMinmaxPropertiesEXT::safe_VkPhysicalDeviceSamplerFilterMinmaxPropertiesEXT() :
    pNext(nullptr)
{}

safe_VkPhysicalDeviceSamplerFilterMinmaxPropertiesEXT::safe_VkPhysicalDeviceSamplerFilterMinmaxPropertiesEXT(const safe_VkPhysicalDeviceSamplerFilterMinmaxPropertiesEXT& src)
{
    sType = src.sType;
    filterMinmaxSingleComponentFormats = src.filterMinmaxSingleComponentFormats;
    filterMinmaxImageComponentMapping = src.filterMinmaxImageComponentMapping;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkPhysicalDeviceSamplerFilterMinmaxPropertiesEXT& safe_VkPhysicalDeviceSamplerFilterMinmaxPropertiesEXT::operator=(const safe_VkPhysicalDeviceSamplerFilterMinmaxPropertiesEXT& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    filterMinmaxSingleComponentFormats = src.filterMinmaxSingleComponentFormats;
    filterMinmaxImageComponentMapping = src.filterMinmaxImageComponentMapping;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkPhysicalDeviceSamplerFilterMinmaxPropertiesEXT::~safe_VkPhysicalDeviceSamplerFilterMinmaxPropertiesEXT()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPhysicalDeviceSamplerFilterMinmaxPropertiesEXT::initialize(const VkPhysicalDeviceSamplerFilterMinmaxPropertiesEXT* in_struct)
{
    sType = in_struct->sType;
    filterMinmaxSingleComponentFormats = in_struct->filterMinmaxSingleComponentFormats;
    filterMinmaxImageComponentMapping = in_struct->filterMinmaxImageComponentMapping;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkPhysicalDeviceSamplerFilterMinmaxPropertiesEXT::initialize(const safe_VkPhysicalDeviceSamplerFilterMinmaxPropertiesEXT* src)
{
    sType = src->sType;
    filterMinmaxSingleComponentFormats = src->filterMinmaxSingleComponentFormats;
    filterMinmaxImageComponentMapping = src->filterMinmaxImageComponentMapping;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkPhysicalDeviceInlineUniformBlockFeaturesEXT::safe_VkPhysicalDeviceInlineUniformBlockFeaturesEXT(const VkPhysicalDeviceInlineUniformBlockFeaturesEXT* in_struct) :
    sType(in_struct->sType),
    inlineUniformBlock(in_struct->inlineUniformBlock),
    descriptorBindingInlineUniformBlockUpdateAfterBind(in_struct->descriptorBindingInlineUniformBlockUpdateAfterBind)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkPhysicalDeviceInlineUniformBlockFeaturesEXT::safe_VkPhysicalDeviceInlineUniformBlockFeaturesEXT() :
    pNext(nullptr)
{}

safe_VkPhysicalDeviceInlineUniformBlockFeaturesEXT::safe_VkPhysicalDeviceInlineUniformBlockFeaturesEXT(const safe_VkPhysicalDeviceInlineUniformBlockFeaturesEXT& src)
{
    sType = src.sType;
    inlineUniformBlock = src.inlineUniformBlock;
    descriptorBindingInlineUniformBlockUpdateAfterBind = src.descriptorBindingInlineUniformBlockUpdateAfterBind;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkPhysicalDeviceInlineUniformBlockFeaturesEXT& safe_VkPhysicalDeviceInlineUniformBlockFeaturesEXT::operator=(const safe_VkPhysicalDeviceInlineUniformBlockFeaturesEXT& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    inlineUniformBlock = src.inlineUniformBlock;
    descriptorBindingInlineUniformBlockUpdateAfterBind = src.descriptorBindingInlineUniformBlockUpdateAfterBind;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkPhysicalDeviceInlineUniformBlockFeaturesEXT::~safe_VkPhysicalDeviceInlineUniformBlockFeaturesEXT()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPhysicalDeviceInlineUniformBlockFeaturesEXT::initialize(const VkPhysicalDeviceInlineUniformBlockFeaturesEXT* in_struct)
{
    sType = in_struct->sType;
    inlineUniformBlock = in_struct->inlineUniformBlock;
    descriptorBindingInlineUniformBlockUpdateAfterBind = in_struct->descriptorBindingInlineUniformBlockUpdateAfterBind;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkPhysicalDeviceInlineUniformBlockFeaturesEXT::initialize(const safe_VkPhysicalDeviceInlineUniformBlockFeaturesEXT* src)
{
    sType = src->sType;
    inlineUniformBlock = src->inlineUniformBlock;
    descriptorBindingInlineUniformBlockUpdateAfterBind = src->descriptorBindingInlineUniformBlockUpdateAfterBind;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkPhysicalDeviceInlineUniformBlockPropertiesEXT::safe_VkPhysicalDeviceInlineUniformBlockPropertiesEXT(const VkPhysicalDeviceInlineUniformBlockPropertiesEXT* in_struct) :
    sType(in_struct->sType),
    maxInlineUniformBlockSize(in_struct->maxInlineUniformBlockSize),
    maxPerStageDescriptorInlineUniformBlocks(in_struct->maxPerStageDescriptorInlineUniformBlocks),
    maxPerStageDescriptorUpdateAfterBindInlineUniformBlocks(in_struct->maxPerStageDescriptorUpdateAfterBindInlineUniformBlocks),
    maxDescriptorSetInlineUniformBlocks(in_struct->maxDescriptorSetInlineUniformBlocks),
    maxDescriptorSetUpdateAfterBindInlineUniformBlocks(in_struct->maxDescriptorSetUpdateAfterBindInlineUniformBlocks)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkPhysicalDeviceInlineUniformBlockPropertiesEXT::safe_VkPhysicalDeviceInlineUniformBlockPropertiesEXT() :
    pNext(nullptr)
{}

safe_VkPhysicalDeviceInlineUniformBlockPropertiesEXT::safe_VkPhysicalDeviceInlineUniformBlockPropertiesEXT(const safe_VkPhysicalDeviceInlineUniformBlockPropertiesEXT& src)
{
    sType = src.sType;
    maxInlineUniformBlockSize = src.maxInlineUniformBlockSize;
    maxPerStageDescriptorInlineUniformBlocks = src.maxPerStageDescriptorInlineUniformBlocks;
    maxPerStageDescriptorUpdateAfterBindInlineUniformBlocks = src.maxPerStageDescriptorUpdateAfterBindInlineUniformBlocks;
    maxDescriptorSetInlineUniformBlocks = src.maxDescriptorSetInlineUniformBlocks;
    maxDescriptorSetUpdateAfterBindInlineUniformBlocks = src.maxDescriptorSetUpdateAfterBindInlineUniformBlocks;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkPhysicalDeviceInlineUniformBlockPropertiesEXT& safe_VkPhysicalDeviceInlineUniformBlockPropertiesEXT::operator=(const safe_VkPhysicalDeviceInlineUniformBlockPropertiesEXT& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    maxInlineUniformBlockSize = src.maxInlineUniformBlockSize;
    maxPerStageDescriptorInlineUniformBlocks = src.maxPerStageDescriptorInlineUniformBlocks;
    maxPerStageDescriptorUpdateAfterBindInlineUniformBlocks = src.maxPerStageDescriptorUpdateAfterBindInlineUniformBlocks;
    maxDescriptorSetInlineUniformBlocks = src.maxDescriptorSetInlineUniformBlocks;
    maxDescriptorSetUpdateAfterBindInlineUniformBlocks = src.maxDescriptorSetUpdateAfterBindInlineUniformBlocks;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkPhysicalDeviceInlineUniformBlockPropertiesEXT::~safe_VkPhysicalDeviceInlineUniformBlockPropertiesEXT()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPhysicalDeviceInlineUniformBlockPropertiesEXT::initialize(const VkPhysicalDeviceInlineUniformBlockPropertiesEXT* in_struct)
{
    sType = in_struct->sType;
    maxInlineUniformBlockSize = in_struct->maxInlineUniformBlockSize;
    maxPerStageDescriptorInlineUniformBlocks = in_struct->maxPerStageDescriptorInlineUniformBlocks;
    maxPerStageDescriptorUpdateAfterBindInlineUniformBlocks = in_struct->maxPerStageDescriptorUpdateAfterBindInlineUniformBlocks;
    maxDescriptorSetInlineUniformBlocks = in_struct->maxDescriptorSetInlineUniformBlocks;
    maxDescriptorSetUpdateAfterBindInlineUniformBlocks = in_struct->maxDescriptorSetUpdateAfterBindInlineUniformBlocks;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkPhysicalDeviceInlineUniformBlockPropertiesEXT::initialize(const safe_VkPhysicalDeviceInlineUniformBlockPropertiesEXT* src)
{
    sType = src->sType;
    maxInlineUniformBlockSize = src->maxInlineUniformBlockSize;
    maxPerStageDescriptorInlineUniformBlocks = src->maxPerStageDescriptorInlineUniformBlocks;
    maxPerStageDescriptorUpdateAfterBindInlineUniformBlocks = src->maxPerStageDescriptorUpdateAfterBindInlineUniformBlocks;
    maxDescriptorSetInlineUniformBlocks = src->maxDescriptorSetInlineUniformBlocks;
    maxDescriptorSetUpdateAfterBindInlineUniformBlocks = src->maxDescriptorSetUpdateAfterBindInlineUniformBlocks;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkWriteDescriptorSetInlineUniformBlockEXT::safe_VkWriteDescriptorSetInlineUniformBlockEXT(const VkWriteDescriptorSetInlineUniformBlockEXT* in_struct) :
    sType(in_struct->sType),
    dataSize(in_struct->dataSize),
    pData(in_struct->pData)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkWriteDescriptorSetInlineUniformBlockEXT::safe_VkWriteDescriptorSetInlineUniformBlockEXT() :
    pNext(nullptr),
    pData(nullptr)
{}

safe_VkWriteDescriptorSetInlineUniformBlockEXT::safe_VkWriteDescriptorSetInlineUniformBlockEXT(const safe_VkWriteDescriptorSetInlineUniformBlockEXT& src)
{
    sType = src.sType;
    dataSize = src.dataSize;
    pData = src.pData;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkWriteDescriptorSetInlineUniformBlockEXT& safe_VkWriteDescriptorSetInlineUniformBlockEXT::operator=(const safe_VkWriteDescriptorSetInlineUniformBlockEXT& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    dataSize = src.dataSize;
    pData = src.pData;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkWriteDescriptorSetInlineUniformBlockEXT::~safe_VkWriteDescriptorSetInlineUniformBlockEXT()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkWriteDescriptorSetInlineUniformBlockEXT::initialize(const VkWriteDescriptorSetInlineUniformBlockEXT* in_struct)
{
    sType = in_struct->sType;
    dataSize = in_struct->dataSize;
    pData = in_struct->pData;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkWriteDescriptorSetInlineUniformBlockEXT::initialize(const safe_VkWriteDescriptorSetInlineUniformBlockEXT* src)
{
    sType = src->sType;
    dataSize = src->dataSize;
    pData = src->pData;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkDescriptorPoolInlineUniformBlockCreateInfoEXT::safe_VkDescriptorPoolInlineUniformBlockCreateInfoEXT(const VkDescriptorPoolInlineUniformBlockCreateInfoEXT* in_struct) :
    sType(in_struct->sType),
    maxInlineUniformBlockBindings(in_struct->maxInlineUniformBlockBindings)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkDescriptorPoolInlineUniformBlockCreateInfoEXT::safe_VkDescriptorPoolInlineUniformBlockCreateInfoEXT() :
    pNext(nullptr)
{}

safe_VkDescriptorPoolInlineUniformBlockCreateInfoEXT::safe_VkDescriptorPoolInlineUniformBlockCreateInfoEXT(const safe_VkDescriptorPoolInlineUniformBlockCreateInfoEXT& src)
{
    sType = src.sType;
    maxInlineUniformBlockBindings = src.maxInlineUniformBlockBindings;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkDescriptorPoolInlineUniformBlockCreateInfoEXT& safe_VkDescriptorPoolInlineUniformBlockCreateInfoEXT::operator=(const safe_VkDescriptorPoolInlineUniformBlockCreateInfoEXT& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    maxInlineUniformBlockBindings = src.maxInlineUniformBlockBindings;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkDescriptorPoolInlineUniformBlockCreateInfoEXT::~safe_VkDescriptorPoolInlineUniformBlockCreateInfoEXT()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkDescriptorPoolInlineUniformBlockCreateInfoEXT::initialize(const VkDescriptorPoolInlineUniformBlockCreateInfoEXT* in_struct)
{
    sType = in_struct->sType;
    maxInlineUniformBlockBindings = in_struct->maxInlineUniformBlockBindings;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkDescriptorPoolInlineUniformBlockCreateInfoEXT::initialize(const safe_VkDescriptorPoolInlineUniformBlockCreateInfoEXT* src)
{
    sType = src->sType;
    maxInlineUniformBlockBindings = src->maxInlineUniformBlockBindings;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkSampleLocationsInfoEXT::safe_VkSampleLocationsInfoEXT(const VkSampleLocationsInfoEXT* in_struct) :
    sType(in_struct->sType),
    sampleLocationsPerPixel(in_struct->sampleLocationsPerPixel),
    sampleLocationGridSize(in_struct->sampleLocationGridSize),
    sampleLocationsCount(in_struct->sampleLocationsCount),
    pSampleLocations(nullptr)
{
    pNext = SafePnextCopy(in_struct->pNext);
    if (in_struct->pSampleLocations) {
        pSampleLocations = new VkSampleLocationEXT[in_struct->sampleLocationsCount];
        memcpy ((void *)pSampleLocations, (void *)in_struct->pSampleLocations, sizeof(VkSampleLocationEXT)*in_struct->sampleLocationsCount);
    }
}

safe_VkSampleLocationsInfoEXT::safe_VkSampleLocationsInfoEXT() :
    pNext(nullptr),
    pSampleLocations(nullptr)
{}

safe_VkSampleLocationsInfoEXT::safe_VkSampleLocationsInfoEXT(const safe_VkSampleLocationsInfoEXT& src)
{
    sType = src.sType;
    sampleLocationsPerPixel = src.sampleLocationsPerPixel;
    sampleLocationGridSize = src.sampleLocationGridSize;
    sampleLocationsCount = src.sampleLocationsCount;
    pSampleLocations = nullptr;
    pNext = SafePnextCopy(src.pNext);
    if (src.pSampleLocations) {
        pSampleLocations = new VkSampleLocationEXT[src.sampleLocationsCount];
        memcpy ((void *)pSampleLocations, (void *)src.pSampleLocations, sizeof(VkSampleLocationEXT)*src.sampleLocationsCount);
    }
}

safe_VkSampleLocationsInfoEXT& safe_VkSampleLocationsInfoEXT::operator=(const safe_VkSampleLocationsInfoEXT& src)
{
    if (&src == this) return *this;

    if (pSampleLocations)
        delete[] pSampleLocations;
    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    sampleLocationsPerPixel = src.sampleLocationsPerPixel;
    sampleLocationGridSize = src.sampleLocationGridSize;
    sampleLocationsCount = src.sampleLocationsCount;
    pSampleLocations = nullptr;
    pNext = SafePnextCopy(src.pNext);
    if (src.pSampleLocations) {
        pSampleLocations = new VkSampleLocationEXT[src.sampleLocationsCount];
        memcpy ((void *)pSampleLocations, (void *)src.pSampleLocations, sizeof(VkSampleLocationEXT)*src.sampleLocationsCount);
    }

    return *this;
}

safe_VkSampleLocationsInfoEXT::~safe_VkSampleLocationsInfoEXT()
{
    if (pSampleLocations)
        delete[] pSampleLocations;
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkSampleLocationsInfoEXT::initialize(const VkSampleLocationsInfoEXT* in_struct)
{
    sType = in_struct->sType;
    sampleLocationsPerPixel = in_struct->sampleLocationsPerPixel;
    sampleLocationGridSize = in_struct->sampleLocationGridSize;
    sampleLocationsCount = in_struct->sampleLocationsCount;
    pSampleLocations = nullptr;
    pNext = SafePnextCopy(in_struct->pNext);
    if (in_struct->pSampleLocations) {
        pSampleLocations = new VkSampleLocationEXT[in_struct->sampleLocationsCount];
        memcpy ((void *)pSampleLocations, (void *)in_struct->pSampleLocations, sizeof(VkSampleLocationEXT)*in_struct->sampleLocationsCount);
    }
}

void safe_VkSampleLocationsInfoEXT::initialize(const safe_VkSampleLocationsInfoEXT* src)
{
    sType = src->sType;
    sampleLocationsPerPixel = src->sampleLocationsPerPixel;
    sampleLocationGridSize = src->sampleLocationGridSize;
    sampleLocationsCount = src->sampleLocationsCount;
    pSampleLocations = nullptr;
    pNext = SafePnextCopy(src->pNext);
    if (src->pSampleLocations) {
        pSampleLocations = new VkSampleLocationEXT[src->sampleLocationsCount];
        memcpy ((void *)pSampleLocations, (void *)src->pSampleLocations, sizeof(VkSampleLocationEXT)*src->sampleLocationsCount);
    }
}

safe_VkRenderPassSampleLocationsBeginInfoEXT::safe_VkRenderPassSampleLocationsBeginInfoEXT(const VkRenderPassSampleLocationsBeginInfoEXT* in_struct) :
    sType(in_struct->sType),
    attachmentInitialSampleLocationsCount(in_struct->attachmentInitialSampleLocationsCount),
    pAttachmentInitialSampleLocations(nullptr),
    postSubpassSampleLocationsCount(in_struct->postSubpassSampleLocationsCount),
    pPostSubpassSampleLocations(nullptr)
{
    pNext = SafePnextCopy(in_struct->pNext);
    if (in_struct->pAttachmentInitialSampleLocations) {
        pAttachmentInitialSampleLocations = new VkAttachmentSampleLocationsEXT[in_struct->attachmentInitialSampleLocationsCount];
        memcpy ((void *)pAttachmentInitialSampleLocations, (void *)in_struct->pAttachmentInitialSampleLocations, sizeof(VkAttachmentSampleLocationsEXT)*in_struct->attachmentInitialSampleLocationsCount);
    }
    if (in_struct->pPostSubpassSampleLocations) {
        pPostSubpassSampleLocations = new VkSubpassSampleLocationsEXT[in_struct->postSubpassSampleLocationsCount];
        memcpy ((void *)pPostSubpassSampleLocations, (void *)in_struct->pPostSubpassSampleLocations, sizeof(VkSubpassSampleLocationsEXT)*in_struct->postSubpassSampleLocationsCount);
    }
}

safe_VkRenderPassSampleLocationsBeginInfoEXT::safe_VkRenderPassSampleLocationsBeginInfoEXT() :
    pNext(nullptr),
    pAttachmentInitialSampleLocations(nullptr),
    pPostSubpassSampleLocations(nullptr)
{}

safe_VkRenderPassSampleLocationsBeginInfoEXT::safe_VkRenderPassSampleLocationsBeginInfoEXT(const safe_VkRenderPassSampleLocationsBeginInfoEXT& src)
{
    sType = src.sType;
    attachmentInitialSampleLocationsCount = src.attachmentInitialSampleLocationsCount;
    pAttachmentInitialSampleLocations = nullptr;
    postSubpassSampleLocationsCount = src.postSubpassSampleLocationsCount;
    pPostSubpassSampleLocations = nullptr;
    pNext = SafePnextCopy(src.pNext);
    if (src.pAttachmentInitialSampleLocations) {
        pAttachmentInitialSampleLocations = new VkAttachmentSampleLocationsEXT[src.attachmentInitialSampleLocationsCount];
        memcpy ((void *)pAttachmentInitialSampleLocations, (void *)src.pAttachmentInitialSampleLocations, sizeof(VkAttachmentSampleLocationsEXT)*src.attachmentInitialSampleLocationsCount);
    }
    if (src.pPostSubpassSampleLocations) {
        pPostSubpassSampleLocations = new VkSubpassSampleLocationsEXT[src.postSubpassSampleLocationsCount];
        memcpy ((void *)pPostSubpassSampleLocations, (void *)src.pPostSubpassSampleLocations, sizeof(VkSubpassSampleLocationsEXT)*src.postSubpassSampleLocationsCount);
    }
}

safe_VkRenderPassSampleLocationsBeginInfoEXT& safe_VkRenderPassSampleLocationsBeginInfoEXT::operator=(const safe_VkRenderPassSampleLocationsBeginInfoEXT& src)
{
    if (&src == this) return *this;

    if (pAttachmentInitialSampleLocations)
        delete[] pAttachmentInitialSampleLocations;
    if (pPostSubpassSampleLocations)
        delete[] pPostSubpassSampleLocations;
    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    attachmentInitialSampleLocationsCount = src.attachmentInitialSampleLocationsCount;
    pAttachmentInitialSampleLocations = nullptr;
    postSubpassSampleLocationsCount = src.postSubpassSampleLocationsCount;
    pPostSubpassSampleLocations = nullptr;
    pNext = SafePnextCopy(src.pNext);
    if (src.pAttachmentInitialSampleLocations) {
        pAttachmentInitialSampleLocations = new VkAttachmentSampleLocationsEXT[src.attachmentInitialSampleLocationsCount];
        memcpy ((void *)pAttachmentInitialSampleLocations, (void *)src.pAttachmentInitialSampleLocations, sizeof(VkAttachmentSampleLocationsEXT)*src.attachmentInitialSampleLocationsCount);
    }
    if (src.pPostSubpassSampleLocations) {
        pPostSubpassSampleLocations = new VkSubpassSampleLocationsEXT[src.postSubpassSampleLocationsCount];
        memcpy ((void *)pPostSubpassSampleLocations, (void *)src.pPostSubpassSampleLocations, sizeof(VkSubpassSampleLocationsEXT)*src.postSubpassSampleLocationsCount);
    }

    return *this;
}

safe_VkRenderPassSampleLocationsBeginInfoEXT::~safe_VkRenderPassSampleLocationsBeginInfoEXT()
{
    if (pAttachmentInitialSampleLocations)
        delete[] pAttachmentInitialSampleLocations;
    if (pPostSubpassSampleLocations)
        delete[] pPostSubpassSampleLocations;
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkRenderPassSampleLocationsBeginInfoEXT::initialize(const VkRenderPassSampleLocationsBeginInfoEXT* in_struct)
{
    sType = in_struct->sType;
    attachmentInitialSampleLocationsCount = in_struct->attachmentInitialSampleLocationsCount;
    pAttachmentInitialSampleLocations = nullptr;
    postSubpassSampleLocationsCount = in_struct->postSubpassSampleLocationsCount;
    pPostSubpassSampleLocations = nullptr;
    pNext = SafePnextCopy(in_struct->pNext);
    if (in_struct->pAttachmentInitialSampleLocations) {
        pAttachmentInitialSampleLocations = new VkAttachmentSampleLocationsEXT[in_struct->attachmentInitialSampleLocationsCount];
        memcpy ((void *)pAttachmentInitialSampleLocations, (void *)in_struct->pAttachmentInitialSampleLocations, sizeof(VkAttachmentSampleLocationsEXT)*in_struct->attachmentInitialSampleLocationsCount);
    }
    if (in_struct->pPostSubpassSampleLocations) {
        pPostSubpassSampleLocations = new VkSubpassSampleLocationsEXT[in_struct->postSubpassSampleLocationsCount];
        memcpy ((void *)pPostSubpassSampleLocations, (void *)in_struct->pPostSubpassSampleLocations, sizeof(VkSubpassSampleLocationsEXT)*in_struct->postSubpassSampleLocationsCount);
    }
}

void safe_VkRenderPassSampleLocationsBeginInfoEXT::initialize(const safe_VkRenderPassSampleLocationsBeginInfoEXT* src)
{
    sType = src->sType;
    attachmentInitialSampleLocationsCount = src->attachmentInitialSampleLocationsCount;
    pAttachmentInitialSampleLocations = nullptr;
    postSubpassSampleLocationsCount = src->postSubpassSampleLocationsCount;
    pPostSubpassSampleLocations = nullptr;
    pNext = SafePnextCopy(src->pNext);
    if (src->pAttachmentInitialSampleLocations) {
        pAttachmentInitialSampleLocations = new VkAttachmentSampleLocationsEXT[src->attachmentInitialSampleLocationsCount];
        memcpy ((void *)pAttachmentInitialSampleLocations, (void *)src->pAttachmentInitialSampleLocations, sizeof(VkAttachmentSampleLocationsEXT)*src->attachmentInitialSampleLocationsCount);
    }
    if (src->pPostSubpassSampleLocations) {
        pPostSubpassSampleLocations = new VkSubpassSampleLocationsEXT[src->postSubpassSampleLocationsCount];
        memcpy ((void *)pPostSubpassSampleLocations, (void *)src->pPostSubpassSampleLocations, sizeof(VkSubpassSampleLocationsEXT)*src->postSubpassSampleLocationsCount);
    }
}

safe_VkPipelineSampleLocationsStateCreateInfoEXT::safe_VkPipelineSampleLocationsStateCreateInfoEXT(const VkPipelineSampleLocationsStateCreateInfoEXT* in_struct) :
    sType(in_struct->sType),
    sampleLocationsEnable(in_struct->sampleLocationsEnable),
    sampleLocationsInfo(&in_struct->sampleLocationsInfo)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkPipelineSampleLocationsStateCreateInfoEXT::safe_VkPipelineSampleLocationsStateCreateInfoEXT() :
    pNext(nullptr)
{}

safe_VkPipelineSampleLocationsStateCreateInfoEXT::safe_VkPipelineSampleLocationsStateCreateInfoEXT(const safe_VkPipelineSampleLocationsStateCreateInfoEXT& src)
{
    sType = src.sType;
    sampleLocationsEnable = src.sampleLocationsEnable;
    sampleLocationsInfo.initialize(&src.sampleLocationsInfo);
    pNext = SafePnextCopy(src.pNext);
}

safe_VkPipelineSampleLocationsStateCreateInfoEXT& safe_VkPipelineSampleLocationsStateCreateInfoEXT::operator=(const safe_VkPipelineSampleLocationsStateCreateInfoEXT& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    sampleLocationsEnable = src.sampleLocationsEnable;
    sampleLocationsInfo.initialize(&src.sampleLocationsInfo);
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkPipelineSampleLocationsStateCreateInfoEXT::~safe_VkPipelineSampleLocationsStateCreateInfoEXT()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPipelineSampleLocationsStateCreateInfoEXT::initialize(const VkPipelineSampleLocationsStateCreateInfoEXT* in_struct)
{
    sType = in_struct->sType;
    sampleLocationsEnable = in_struct->sampleLocationsEnable;
    sampleLocationsInfo.initialize(&in_struct->sampleLocationsInfo);
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkPipelineSampleLocationsStateCreateInfoEXT::initialize(const safe_VkPipelineSampleLocationsStateCreateInfoEXT* src)
{
    sType = src->sType;
    sampleLocationsEnable = src->sampleLocationsEnable;
    sampleLocationsInfo.initialize(&src->sampleLocationsInfo);
    pNext = SafePnextCopy(src->pNext);
}

safe_VkPhysicalDeviceSampleLocationsPropertiesEXT::safe_VkPhysicalDeviceSampleLocationsPropertiesEXT(const VkPhysicalDeviceSampleLocationsPropertiesEXT* in_struct) :
    sType(in_struct->sType),
    sampleLocationSampleCounts(in_struct->sampleLocationSampleCounts),
    maxSampleLocationGridSize(in_struct->maxSampleLocationGridSize),
    sampleLocationSubPixelBits(in_struct->sampleLocationSubPixelBits),
    variableSampleLocations(in_struct->variableSampleLocations)
{
    pNext = SafePnextCopy(in_struct->pNext);
    for (uint32_t i = 0; i < 2; ++i) {
        sampleLocationCoordinateRange[i] = in_struct->sampleLocationCoordinateRange[i];
    }
}

safe_VkPhysicalDeviceSampleLocationsPropertiesEXT::safe_VkPhysicalDeviceSampleLocationsPropertiesEXT() :
    pNext(nullptr)
{}

safe_VkPhysicalDeviceSampleLocationsPropertiesEXT::safe_VkPhysicalDeviceSampleLocationsPropertiesEXT(const safe_VkPhysicalDeviceSampleLocationsPropertiesEXT& src)
{
    sType = src.sType;
    sampleLocationSampleCounts = src.sampleLocationSampleCounts;
    maxSampleLocationGridSize = src.maxSampleLocationGridSize;
    sampleLocationSubPixelBits = src.sampleLocationSubPixelBits;
    variableSampleLocations = src.variableSampleLocations;
    pNext = SafePnextCopy(src.pNext);
    for (uint32_t i = 0; i < 2; ++i) {
        sampleLocationCoordinateRange[i] = src.sampleLocationCoordinateRange[i];
    }
}

safe_VkPhysicalDeviceSampleLocationsPropertiesEXT& safe_VkPhysicalDeviceSampleLocationsPropertiesEXT::operator=(const safe_VkPhysicalDeviceSampleLocationsPropertiesEXT& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    sampleLocationSampleCounts = src.sampleLocationSampleCounts;
    maxSampleLocationGridSize = src.maxSampleLocationGridSize;
    sampleLocationSubPixelBits = src.sampleLocationSubPixelBits;
    variableSampleLocations = src.variableSampleLocations;
    pNext = SafePnextCopy(src.pNext);
    for (uint32_t i = 0; i < 2; ++i) {
        sampleLocationCoordinateRange[i] = src.sampleLocationCoordinateRange[i];
    }

    return *this;
}

safe_VkPhysicalDeviceSampleLocationsPropertiesEXT::~safe_VkPhysicalDeviceSampleLocationsPropertiesEXT()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPhysicalDeviceSampleLocationsPropertiesEXT::initialize(const VkPhysicalDeviceSampleLocationsPropertiesEXT* in_struct)
{
    sType = in_struct->sType;
    sampleLocationSampleCounts = in_struct->sampleLocationSampleCounts;
    maxSampleLocationGridSize = in_struct->maxSampleLocationGridSize;
    sampleLocationSubPixelBits = in_struct->sampleLocationSubPixelBits;
    variableSampleLocations = in_struct->variableSampleLocations;
    pNext = SafePnextCopy(in_struct->pNext);
    for (uint32_t i = 0; i < 2; ++i) {
        sampleLocationCoordinateRange[i] = in_struct->sampleLocationCoordinateRange[i];
    }
}

void safe_VkPhysicalDeviceSampleLocationsPropertiesEXT::initialize(const safe_VkPhysicalDeviceSampleLocationsPropertiesEXT* src)
{
    sType = src->sType;
    sampleLocationSampleCounts = src->sampleLocationSampleCounts;
    maxSampleLocationGridSize = src->maxSampleLocationGridSize;
    sampleLocationSubPixelBits = src->sampleLocationSubPixelBits;
    variableSampleLocations = src->variableSampleLocations;
    pNext = SafePnextCopy(src->pNext);
    for (uint32_t i = 0; i < 2; ++i) {
        sampleLocationCoordinateRange[i] = src->sampleLocationCoordinateRange[i];
    }
}

safe_VkMultisamplePropertiesEXT::safe_VkMultisamplePropertiesEXT(const VkMultisamplePropertiesEXT* in_struct) :
    sType(in_struct->sType),
    maxSampleLocationGridSize(in_struct->maxSampleLocationGridSize)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkMultisamplePropertiesEXT::safe_VkMultisamplePropertiesEXT() :
    pNext(nullptr)
{}

safe_VkMultisamplePropertiesEXT::safe_VkMultisamplePropertiesEXT(const safe_VkMultisamplePropertiesEXT& src)
{
    sType = src.sType;
    maxSampleLocationGridSize = src.maxSampleLocationGridSize;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkMultisamplePropertiesEXT& safe_VkMultisamplePropertiesEXT::operator=(const safe_VkMultisamplePropertiesEXT& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    maxSampleLocationGridSize = src.maxSampleLocationGridSize;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkMultisamplePropertiesEXT::~safe_VkMultisamplePropertiesEXT()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkMultisamplePropertiesEXT::initialize(const VkMultisamplePropertiesEXT* in_struct)
{
    sType = in_struct->sType;
    maxSampleLocationGridSize = in_struct->maxSampleLocationGridSize;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkMultisamplePropertiesEXT::initialize(const safe_VkMultisamplePropertiesEXT* src)
{
    sType = src->sType;
    maxSampleLocationGridSize = src->maxSampleLocationGridSize;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkPhysicalDeviceBlendOperationAdvancedFeaturesEXT::safe_VkPhysicalDeviceBlendOperationAdvancedFeaturesEXT(const VkPhysicalDeviceBlendOperationAdvancedFeaturesEXT* in_struct) :
    sType(in_struct->sType),
    advancedBlendCoherentOperations(in_struct->advancedBlendCoherentOperations)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkPhysicalDeviceBlendOperationAdvancedFeaturesEXT::safe_VkPhysicalDeviceBlendOperationAdvancedFeaturesEXT() :
    pNext(nullptr)
{}

safe_VkPhysicalDeviceBlendOperationAdvancedFeaturesEXT::safe_VkPhysicalDeviceBlendOperationAdvancedFeaturesEXT(const safe_VkPhysicalDeviceBlendOperationAdvancedFeaturesEXT& src)
{
    sType = src.sType;
    advancedBlendCoherentOperations = src.advancedBlendCoherentOperations;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkPhysicalDeviceBlendOperationAdvancedFeaturesEXT& safe_VkPhysicalDeviceBlendOperationAdvancedFeaturesEXT::operator=(const safe_VkPhysicalDeviceBlendOperationAdvancedFeaturesEXT& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    advancedBlendCoherentOperations = src.advancedBlendCoherentOperations;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkPhysicalDeviceBlendOperationAdvancedFeaturesEXT::~safe_VkPhysicalDeviceBlendOperationAdvancedFeaturesEXT()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPhysicalDeviceBlendOperationAdvancedFeaturesEXT::initialize(const VkPhysicalDeviceBlendOperationAdvancedFeaturesEXT* in_struct)
{
    sType = in_struct->sType;
    advancedBlendCoherentOperations = in_struct->advancedBlendCoherentOperations;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkPhysicalDeviceBlendOperationAdvancedFeaturesEXT::initialize(const safe_VkPhysicalDeviceBlendOperationAdvancedFeaturesEXT* src)
{
    sType = src->sType;
    advancedBlendCoherentOperations = src->advancedBlendCoherentOperations;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT::safe_VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT(const VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT* in_struct) :
    sType(in_struct->sType),
    advancedBlendMaxColorAttachments(in_struct->advancedBlendMaxColorAttachments),
    advancedBlendIndependentBlend(in_struct->advancedBlendIndependentBlend),
    advancedBlendNonPremultipliedSrcColor(in_struct->advancedBlendNonPremultipliedSrcColor),
    advancedBlendNonPremultipliedDstColor(in_struct->advancedBlendNonPremultipliedDstColor),
    advancedBlendCorrelatedOverlap(in_struct->advancedBlendCorrelatedOverlap),
    advancedBlendAllOperations(in_struct->advancedBlendAllOperations)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT::safe_VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT() :
    pNext(nullptr)
{}

safe_VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT::safe_VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT(const safe_VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT& src)
{
    sType = src.sType;
    advancedBlendMaxColorAttachments = src.advancedBlendMaxColorAttachments;
    advancedBlendIndependentBlend = src.advancedBlendIndependentBlend;
    advancedBlendNonPremultipliedSrcColor = src.advancedBlendNonPremultipliedSrcColor;
    advancedBlendNonPremultipliedDstColor = src.advancedBlendNonPremultipliedDstColor;
    advancedBlendCorrelatedOverlap = src.advancedBlendCorrelatedOverlap;
    advancedBlendAllOperations = src.advancedBlendAllOperations;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT& safe_VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT::operator=(const safe_VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    advancedBlendMaxColorAttachments = src.advancedBlendMaxColorAttachments;
    advancedBlendIndependentBlend = src.advancedBlendIndependentBlend;
    advancedBlendNonPremultipliedSrcColor = src.advancedBlendNonPremultipliedSrcColor;
    advancedBlendNonPremultipliedDstColor = src.advancedBlendNonPremultipliedDstColor;
    advancedBlendCorrelatedOverlap = src.advancedBlendCorrelatedOverlap;
    advancedBlendAllOperations = src.advancedBlendAllOperations;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT::~safe_VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT::initialize(const VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT* in_struct)
{
    sType = in_struct->sType;
    advancedBlendMaxColorAttachments = in_struct->advancedBlendMaxColorAttachments;
    advancedBlendIndependentBlend = in_struct->advancedBlendIndependentBlend;
    advancedBlendNonPremultipliedSrcColor = in_struct->advancedBlendNonPremultipliedSrcColor;
    advancedBlendNonPremultipliedDstColor = in_struct->advancedBlendNonPremultipliedDstColor;
    advancedBlendCorrelatedOverlap = in_struct->advancedBlendCorrelatedOverlap;
    advancedBlendAllOperations = in_struct->advancedBlendAllOperations;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT::initialize(const safe_VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT* src)
{
    sType = src->sType;
    advancedBlendMaxColorAttachments = src->advancedBlendMaxColorAttachments;
    advancedBlendIndependentBlend = src->advancedBlendIndependentBlend;
    advancedBlendNonPremultipliedSrcColor = src->advancedBlendNonPremultipliedSrcColor;
    advancedBlendNonPremultipliedDstColor = src->advancedBlendNonPremultipliedDstColor;
    advancedBlendCorrelatedOverlap = src->advancedBlendCorrelatedOverlap;
    advancedBlendAllOperations = src->advancedBlendAllOperations;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkPipelineColorBlendAdvancedStateCreateInfoEXT::safe_VkPipelineColorBlendAdvancedStateCreateInfoEXT(const VkPipelineColorBlendAdvancedStateCreateInfoEXT* in_struct) :
    sType(in_struct->sType),
    srcPremultiplied(in_struct->srcPremultiplied),
    dstPremultiplied(in_struct->dstPremultiplied),
    blendOverlap(in_struct->blendOverlap)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkPipelineColorBlendAdvancedStateCreateInfoEXT::safe_VkPipelineColorBlendAdvancedStateCreateInfoEXT() :
    pNext(nullptr)
{}

safe_VkPipelineColorBlendAdvancedStateCreateInfoEXT::safe_VkPipelineColorBlendAdvancedStateCreateInfoEXT(const safe_VkPipelineColorBlendAdvancedStateCreateInfoEXT& src)
{
    sType = src.sType;
    srcPremultiplied = src.srcPremultiplied;
    dstPremultiplied = src.dstPremultiplied;
    blendOverlap = src.blendOverlap;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkPipelineColorBlendAdvancedStateCreateInfoEXT& safe_VkPipelineColorBlendAdvancedStateCreateInfoEXT::operator=(const safe_VkPipelineColorBlendAdvancedStateCreateInfoEXT& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    srcPremultiplied = src.srcPremultiplied;
    dstPremultiplied = src.dstPremultiplied;
    blendOverlap = src.blendOverlap;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkPipelineColorBlendAdvancedStateCreateInfoEXT::~safe_VkPipelineColorBlendAdvancedStateCreateInfoEXT()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPipelineColorBlendAdvancedStateCreateInfoEXT::initialize(const VkPipelineColorBlendAdvancedStateCreateInfoEXT* in_struct)
{
    sType = in_struct->sType;
    srcPremultiplied = in_struct->srcPremultiplied;
    dstPremultiplied = in_struct->dstPremultiplied;
    blendOverlap = in_struct->blendOverlap;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkPipelineColorBlendAdvancedStateCreateInfoEXT::initialize(const safe_VkPipelineColorBlendAdvancedStateCreateInfoEXT* src)
{
    sType = src->sType;
    srcPremultiplied = src->srcPremultiplied;
    dstPremultiplied = src->dstPremultiplied;
    blendOverlap = src->blendOverlap;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkPipelineCoverageToColorStateCreateInfoNV::safe_VkPipelineCoverageToColorStateCreateInfoNV(const VkPipelineCoverageToColorStateCreateInfoNV* in_struct) :
    sType(in_struct->sType),
    flags(in_struct->flags),
    coverageToColorEnable(in_struct->coverageToColorEnable),
    coverageToColorLocation(in_struct->coverageToColorLocation)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkPipelineCoverageToColorStateCreateInfoNV::safe_VkPipelineCoverageToColorStateCreateInfoNV() :
    pNext(nullptr)
{}

safe_VkPipelineCoverageToColorStateCreateInfoNV::safe_VkPipelineCoverageToColorStateCreateInfoNV(const safe_VkPipelineCoverageToColorStateCreateInfoNV& src)
{
    sType = src.sType;
    flags = src.flags;
    coverageToColorEnable = src.coverageToColorEnable;
    coverageToColorLocation = src.coverageToColorLocation;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkPipelineCoverageToColorStateCreateInfoNV& safe_VkPipelineCoverageToColorStateCreateInfoNV::operator=(const safe_VkPipelineCoverageToColorStateCreateInfoNV& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    flags = src.flags;
    coverageToColorEnable = src.coverageToColorEnable;
    coverageToColorLocation = src.coverageToColorLocation;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkPipelineCoverageToColorStateCreateInfoNV::~safe_VkPipelineCoverageToColorStateCreateInfoNV()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPipelineCoverageToColorStateCreateInfoNV::initialize(const VkPipelineCoverageToColorStateCreateInfoNV* in_struct)
{
    sType = in_struct->sType;
    flags = in_struct->flags;
    coverageToColorEnable = in_struct->coverageToColorEnable;
    coverageToColorLocation = in_struct->coverageToColorLocation;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkPipelineCoverageToColorStateCreateInfoNV::initialize(const safe_VkPipelineCoverageToColorStateCreateInfoNV* src)
{
    sType = src->sType;
    flags = src->flags;
    coverageToColorEnable = src->coverageToColorEnable;
    coverageToColorLocation = src->coverageToColorLocation;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkPipelineCoverageModulationStateCreateInfoNV::safe_VkPipelineCoverageModulationStateCreateInfoNV(const VkPipelineCoverageModulationStateCreateInfoNV* in_struct) :
    sType(in_struct->sType),
    flags(in_struct->flags),
    coverageModulationMode(in_struct->coverageModulationMode),
    coverageModulationTableEnable(in_struct->coverageModulationTableEnable),
    coverageModulationTableCount(in_struct->coverageModulationTableCount),
    pCoverageModulationTable(nullptr)
{
    pNext = SafePnextCopy(in_struct->pNext);
    if (in_struct->pCoverageModulationTable) {
        pCoverageModulationTable = new float[in_struct->coverageModulationTableCount];
        memcpy ((void *)pCoverageModulationTable, (void *)in_struct->pCoverageModulationTable, sizeof(float)*in_struct->coverageModulationTableCount);
    }
}

safe_VkPipelineCoverageModulationStateCreateInfoNV::safe_VkPipelineCoverageModulationStateCreateInfoNV() :
    pNext(nullptr),
    pCoverageModulationTable(nullptr)
{}

safe_VkPipelineCoverageModulationStateCreateInfoNV::safe_VkPipelineCoverageModulationStateCreateInfoNV(const safe_VkPipelineCoverageModulationStateCreateInfoNV& src)
{
    sType = src.sType;
    flags = src.flags;
    coverageModulationMode = src.coverageModulationMode;
    coverageModulationTableEnable = src.coverageModulationTableEnable;
    coverageModulationTableCount = src.coverageModulationTableCount;
    pCoverageModulationTable = nullptr;
    pNext = SafePnextCopy(src.pNext);
    if (src.pCoverageModulationTable) {
        pCoverageModulationTable = new float[src.coverageModulationTableCount];
        memcpy ((void *)pCoverageModulationTable, (void *)src.pCoverageModulationTable, sizeof(float)*src.coverageModulationTableCount);
    }
}

safe_VkPipelineCoverageModulationStateCreateInfoNV& safe_VkPipelineCoverageModulationStateCreateInfoNV::operator=(const safe_VkPipelineCoverageModulationStateCreateInfoNV& src)
{
    if (&src == this) return *this;

    if (pCoverageModulationTable)
        delete[] pCoverageModulationTable;
    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    flags = src.flags;
    coverageModulationMode = src.coverageModulationMode;
    coverageModulationTableEnable = src.coverageModulationTableEnable;
    coverageModulationTableCount = src.coverageModulationTableCount;
    pCoverageModulationTable = nullptr;
    pNext = SafePnextCopy(src.pNext);
    if (src.pCoverageModulationTable) {
        pCoverageModulationTable = new float[src.coverageModulationTableCount];
        memcpy ((void *)pCoverageModulationTable, (void *)src.pCoverageModulationTable, sizeof(float)*src.coverageModulationTableCount);
    }

    return *this;
}

safe_VkPipelineCoverageModulationStateCreateInfoNV::~safe_VkPipelineCoverageModulationStateCreateInfoNV()
{
    if (pCoverageModulationTable)
        delete[] pCoverageModulationTable;
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPipelineCoverageModulationStateCreateInfoNV::initialize(const VkPipelineCoverageModulationStateCreateInfoNV* in_struct)
{
    sType = in_struct->sType;
    flags = in_struct->flags;
    coverageModulationMode = in_struct->coverageModulationMode;
    coverageModulationTableEnable = in_struct->coverageModulationTableEnable;
    coverageModulationTableCount = in_struct->coverageModulationTableCount;
    pCoverageModulationTable = nullptr;
    pNext = SafePnextCopy(in_struct->pNext);
    if (in_struct->pCoverageModulationTable) {
        pCoverageModulationTable = new float[in_struct->coverageModulationTableCount];
        memcpy ((void *)pCoverageModulationTable, (void *)in_struct->pCoverageModulationTable, sizeof(float)*in_struct->coverageModulationTableCount);
    }
}

void safe_VkPipelineCoverageModulationStateCreateInfoNV::initialize(const safe_VkPipelineCoverageModulationStateCreateInfoNV* src)
{
    sType = src->sType;
    flags = src->flags;
    coverageModulationMode = src->coverageModulationMode;
    coverageModulationTableEnable = src->coverageModulationTableEnable;
    coverageModulationTableCount = src->coverageModulationTableCount;
    pCoverageModulationTable = nullptr;
    pNext = SafePnextCopy(src->pNext);
    if (src->pCoverageModulationTable) {
        pCoverageModulationTable = new float[src->coverageModulationTableCount];
        memcpy ((void *)pCoverageModulationTable, (void *)src->pCoverageModulationTable, sizeof(float)*src->coverageModulationTableCount);
    }
}

safe_VkPhysicalDeviceShaderSMBuiltinsPropertiesNV::safe_VkPhysicalDeviceShaderSMBuiltinsPropertiesNV(const VkPhysicalDeviceShaderSMBuiltinsPropertiesNV* in_struct) :
    sType(in_struct->sType),
    shaderSMCount(in_struct->shaderSMCount),
    shaderWarpsPerSM(in_struct->shaderWarpsPerSM)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkPhysicalDeviceShaderSMBuiltinsPropertiesNV::safe_VkPhysicalDeviceShaderSMBuiltinsPropertiesNV() :
    pNext(nullptr)
{}

safe_VkPhysicalDeviceShaderSMBuiltinsPropertiesNV::safe_VkPhysicalDeviceShaderSMBuiltinsPropertiesNV(const safe_VkPhysicalDeviceShaderSMBuiltinsPropertiesNV& src)
{
    sType = src.sType;
    shaderSMCount = src.shaderSMCount;
    shaderWarpsPerSM = src.shaderWarpsPerSM;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkPhysicalDeviceShaderSMBuiltinsPropertiesNV& safe_VkPhysicalDeviceShaderSMBuiltinsPropertiesNV::operator=(const safe_VkPhysicalDeviceShaderSMBuiltinsPropertiesNV& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    shaderSMCount = src.shaderSMCount;
    shaderWarpsPerSM = src.shaderWarpsPerSM;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkPhysicalDeviceShaderSMBuiltinsPropertiesNV::~safe_VkPhysicalDeviceShaderSMBuiltinsPropertiesNV()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPhysicalDeviceShaderSMBuiltinsPropertiesNV::initialize(const VkPhysicalDeviceShaderSMBuiltinsPropertiesNV* in_struct)
{
    sType = in_struct->sType;
    shaderSMCount = in_struct->shaderSMCount;
    shaderWarpsPerSM = in_struct->shaderWarpsPerSM;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkPhysicalDeviceShaderSMBuiltinsPropertiesNV::initialize(const safe_VkPhysicalDeviceShaderSMBuiltinsPropertiesNV* src)
{
    sType = src->sType;
    shaderSMCount = src->shaderSMCount;
    shaderWarpsPerSM = src->shaderWarpsPerSM;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkPhysicalDeviceShaderSMBuiltinsFeaturesNV::safe_VkPhysicalDeviceShaderSMBuiltinsFeaturesNV(const VkPhysicalDeviceShaderSMBuiltinsFeaturesNV* in_struct) :
    sType(in_struct->sType),
    shaderSMBuiltins(in_struct->shaderSMBuiltins)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkPhysicalDeviceShaderSMBuiltinsFeaturesNV::safe_VkPhysicalDeviceShaderSMBuiltinsFeaturesNV() :
    pNext(nullptr)
{}

safe_VkPhysicalDeviceShaderSMBuiltinsFeaturesNV::safe_VkPhysicalDeviceShaderSMBuiltinsFeaturesNV(const safe_VkPhysicalDeviceShaderSMBuiltinsFeaturesNV& src)
{
    sType = src.sType;
    shaderSMBuiltins = src.shaderSMBuiltins;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkPhysicalDeviceShaderSMBuiltinsFeaturesNV& safe_VkPhysicalDeviceShaderSMBuiltinsFeaturesNV::operator=(const safe_VkPhysicalDeviceShaderSMBuiltinsFeaturesNV& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    shaderSMBuiltins = src.shaderSMBuiltins;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkPhysicalDeviceShaderSMBuiltinsFeaturesNV::~safe_VkPhysicalDeviceShaderSMBuiltinsFeaturesNV()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPhysicalDeviceShaderSMBuiltinsFeaturesNV::initialize(const VkPhysicalDeviceShaderSMBuiltinsFeaturesNV* in_struct)
{
    sType = in_struct->sType;
    shaderSMBuiltins = in_struct->shaderSMBuiltins;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkPhysicalDeviceShaderSMBuiltinsFeaturesNV::initialize(const safe_VkPhysicalDeviceShaderSMBuiltinsFeaturesNV* src)
{
    sType = src->sType;
    shaderSMBuiltins = src->shaderSMBuiltins;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkDrmFormatModifierPropertiesListEXT::safe_VkDrmFormatModifierPropertiesListEXT(const VkDrmFormatModifierPropertiesListEXT* in_struct) :
    sType(in_struct->sType),
    drmFormatModifierCount(in_struct->drmFormatModifierCount),
    pDrmFormatModifierProperties(nullptr)
{
    pNext = SafePnextCopy(in_struct->pNext);
    if (in_struct->pDrmFormatModifierProperties) {
        pDrmFormatModifierProperties = new VkDrmFormatModifierPropertiesEXT[in_struct->drmFormatModifierCount];
        memcpy ((void *)pDrmFormatModifierProperties, (void *)in_struct->pDrmFormatModifierProperties, sizeof(VkDrmFormatModifierPropertiesEXT)*in_struct->drmFormatModifierCount);
    }
}

safe_VkDrmFormatModifierPropertiesListEXT::safe_VkDrmFormatModifierPropertiesListEXT() :
    pNext(nullptr),
    pDrmFormatModifierProperties(nullptr)
{}

safe_VkDrmFormatModifierPropertiesListEXT::safe_VkDrmFormatModifierPropertiesListEXT(const safe_VkDrmFormatModifierPropertiesListEXT& src)
{
    sType = src.sType;
    drmFormatModifierCount = src.drmFormatModifierCount;
    pDrmFormatModifierProperties = nullptr;
    pNext = SafePnextCopy(src.pNext);
    if (src.pDrmFormatModifierProperties) {
        pDrmFormatModifierProperties = new VkDrmFormatModifierPropertiesEXT[src.drmFormatModifierCount];
        memcpy ((void *)pDrmFormatModifierProperties, (void *)src.pDrmFormatModifierProperties, sizeof(VkDrmFormatModifierPropertiesEXT)*src.drmFormatModifierCount);
    }
}

safe_VkDrmFormatModifierPropertiesListEXT& safe_VkDrmFormatModifierPropertiesListEXT::operator=(const safe_VkDrmFormatModifierPropertiesListEXT& src)
{
    if (&src == this) return *this;

    if (pDrmFormatModifierProperties)
        delete[] pDrmFormatModifierProperties;
    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    drmFormatModifierCount = src.drmFormatModifierCount;
    pDrmFormatModifierProperties = nullptr;
    pNext = SafePnextCopy(src.pNext);
    if (src.pDrmFormatModifierProperties) {
        pDrmFormatModifierProperties = new VkDrmFormatModifierPropertiesEXT[src.drmFormatModifierCount];
        memcpy ((void *)pDrmFormatModifierProperties, (void *)src.pDrmFormatModifierProperties, sizeof(VkDrmFormatModifierPropertiesEXT)*src.drmFormatModifierCount);
    }

    return *this;
}

safe_VkDrmFormatModifierPropertiesListEXT::~safe_VkDrmFormatModifierPropertiesListEXT()
{
    if (pDrmFormatModifierProperties)
        delete[] pDrmFormatModifierProperties;
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkDrmFormatModifierPropertiesListEXT::initialize(const VkDrmFormatModifierPropertiesListEXT* in_struct)
{
    sType = in_struct->sType;
    drmFormatModifierCount = in_struct->drmFormatModifierCount;
    pDrmFormatModifierProperties = nullptr;
    pNext = SafePnextCopy(in_struct->pNext);
    if (in_struct->pDrmFormatModifierProperties) {
        pDrmFormatModifierProperties = new VkDrmFormatModifierPropertiesEXT[in_struct->drmFormatModifierCount];
        memcpy ((void *)pDrmFormatModifierProperties, (void *)in_struct->pDrmFormatModifierProperties, sizeof(VkDrmFormatModifierPropertiesEXT)*in_struct->drmFormatModifierCount);
    }
}

void safe_VkDrmFormatModifierPropertiesListEXT::initialize(const safe_VkDrmFormatModifierPropertiesListEXT* src)
{
    sType = src->sType;
    drmFormatModifierCount = src->drmFormatModifierCount;
    pDrmFormatModifierProperties = nullptr;
    pNext = SafePnextCopy(src->pNext);
    if (src->pDrmFormatModifierProperties) {
        pDrmFormatModifierProperties = new VkDrmFormatModifierPropertiesEXT[src->drmFormatModifierCount];
        memcpy ((void *)pDrmFormatModifierProperties, (void *)src->pDrmFormatModifierProperties, sizeof(VkDrmFormatModifierPropertiesEXT)*src->drmFormatModifierCount);
    }
}

safe_VkPhysicalDeviceImageDrmFormatModifierInfoEXT::safe_VkPhysicalDeviceImageDrmFormatModifierInfoEXT(const VkPhysicalDeviceImageDrmFormatModifierInfoEXT* in_struct) :
    sType(in_struct->sType),
    drmFormatModifier(in_struct->drmFormatModifier),
    sharingMode(in_struct->sharingMode),
    queueFamilyIndexCount(in_struct->queueFamilyIndexCount),
    pQueueFamilyIndices(nullptr)
{
    pNext = SafePnextCopy(in_struct->pNext);
    if (in_struct->pQueueFamilyIndices) {
        pQueueFamilyIndices = new uint32_t[in_struct->queueFamilyIndexCount];
        memcpy ((void *)pQueueFamilyIndices, (void *)in_struct->pQueueFamilyIndices, sizeof(uint32_t)*in_struct->queueFamilyIndexCount);
    }
}

safe_VkPhysicalDeviceImageDrmFormatModifierInfoEXT::safe_VkPhysicalDeviceImageDrmFormatModifierInfoEXT() :
    pNext(nullptr),
    pQueueFamilyIndices(nullptr)
{}

safe_VkPhysicalDeviceImageDrmFormatModifierInfoEXT::safe_VkPhysicalDeviceImageDrmFormatModifierInfoEXT(const safe_VkPhysicalDeviceImageDrmFormatModifierInfoEXT& src)
{
    sType = src.sType;
    drmFormatModifier = src.drmFormatModifier;
    sharingMode = src.sharingMode;
    queueFamilyIndexCount = src.queueFamilyIndexCount;
    pQueueFamilyIndices = nullptr;
    pNext = SafePnextCopy(src.pNext);
    if (src.pQueueFamilyIndices) {
        pQueueFamilyIndices = new uint32_t[src.queueFamilyIndexCount];
        memcpy ((void *)pQueueFamilyIndices, (void *)src.pQueueFamilyIndices, sizeof(uint32_t)*src.queueFamilyIndexCount);
    }
}

safe_VkPhysicalDeviceImageDrmFormatModifierInfoEXT& safe_VkPhysicalDeviceImageDrmFormatModifierInfoEXT::operator=(const safe_VkPhysicalDeviceImageDrmFormatModifierInfoEXT& src)
{
    if (&src == this) return *this;

    if (pQueueFamilyIndices)
        delete[] pQueueFamilyIndices;
    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    drmFormatModifier = src.drmFormatModifier;
    sharingMode = src.sharingMode;
    queueFamilyIndexCount = src.queueFamilyIndexCount;
    pQueueFamilyIndices = nullptr;
    pNext = SafePnextCopy(src.pNext);
    if (src.pQueueFamilyIndices) {
        pQueueFamilyIndices = new uint32_t[src.queueFamilyIndexCount];
        memcpy ((void *)pQueueFamilyIndices, (void *)src.pQueueFamilyIndices, sizeof(uint32_t)*src.queueFamilyIndexCount);
    }

    return *this;
}

safe_VkPhysicalDeviceImageDrmFormatModifierInfoEXT::~safe_VkPhysicalDeviceImageDrmFormatModifierInfoEXT()
{
    if (pQueueFamilyIndices)
        delete[] pQueueFamilyIndices;
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPhysicalDeviceImageDrmFormatModifierInfoEXT::initialize(const VkPhysicalDeviceImageDrmFormatModifierInfoEXT* in_struct)
{
    sType = in_struct->sType;
    drmFormatModifier = in_struct->drmFormatModifier;
    sharingMode = in_struct->sharingMode;
    queueFamilyIndexCount = in_struct->queueFamilyIndexCount;
    pQueueFamilyIndices = nullptr;
    pNext = SafePnextCopy(in_struct->pNext);
    if (in_struct->pQueueFamilyIndices) {
        pQueueFamilyIndices = new uint32_t[in_struct->queueFamilyIndexCount];
        memcpy ((void *)pQueueFamilyIndices, (void *)in_struct->pQueueFamilyIndices, sizeof(uint32_t)*in_struct->queueFamilyIndexCount);
    }
}

void safe_VkPhysicalDeviceImageDrmFormatModifierInfoEXT::initialize(const safe_VkPhysicalDeviceImageDrmFormatModifierInfoEXT* src)
{
    sType = src->sType;
    drmFormatModifier = src->drmFormatModifier;
    sharingMode = src->sharingMode;
    queueFamilyIndexCount = src->queueFamilyIndexCount;
    pQueueFamilyIndices = nullptr;
    pNext = SafePnextCopy(src->pNext);
    if (src->pQueueFamilyIndices) {
        pQueueFamilyIndices = new uint32_t[src->queueFamilyIndexCount];
        memcpy ((void *)pQueueFamilyIndices, (void *)src->pQueueFamilyIndices, sizeof(uint32_t)*src->queueFamilyIndexCount);
    }
}

safe_VkImageDrmFormatModifierListCreateInfoEXT::safe_VkImageDrmFormatModifierListCreateInfoEXT(const VkImageDrmFormatModifierListCreateInfoEXT* in_struct) :
    sType(in_struct->sType),
    drmFormatModifierCount(in_struct->drmFormatModifierCount),
    pDrmFormatModifiers(nullptr)
{
    pNext = SafePnextCopy(in_struct->pNext);
    if (in_struct->pDrmFormatModifiers) {
        pDrmFormatModifiers = new uint64_t[in_struct->drmFormatModifierCount];
        memcpy ((void *)pDrmFormatModifiers, (void *)in_struct->pDrmFormatModifiers, sizeof(uint64_t)*in_struct->drmFormatModifierCount);
    }
}

safe_VkImageDrmFormatModifierListCreateInfoEXT::safe_VkImageDrmFormatModifierListCreateInfoEXT() :
    pNext(nullptr),
    pDrmFormatModifiers(nullptr)
{}

safe_VkImageDrmFormatModifierListCreateInfoEXT::safe_VkImageDrmFormatModifierListCreateInfoEXT(const safe_VkImageDrmFormatModifierListCreateInfoEXT& src)
{
    sType = src.sType;
    drmFormatModifierCount = src.drmFormatModifierCount;
    pDrmFormatModifiers = nullptr;
    pNext = SafePnextCopy(src.pNext);
    if (src.pDrmFormatModifiers) {
        pDrmFormatModifiers = new uint64_t[src.drmFormatModifierCount];
        memcpy ((void *)pDrmFormatModifiers, (void *)src.pDrmFormatModifiers, sizeof(uint64_t)*src.drmFormatModifierCount);
    }
}

safe_VkImageDrmFormatModifierListCreateInfoEXT& safe_VkImageDrmFormatModifierListCreateInfoEXT::operator=(const safe_VkImageDrmFormatModifierListCreateInfoEXT& src)
{
    if (&src == this) return *this;

    if (pDrmFormatModifiers)
        delete[] pDrmFormatModifiers;
    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    drmFormatModifierCount = src.drmFormatModifierCount;
    pDrmFormatModifiers = nullptr;
    pNext = SafePnextCopy(src.pNext);
    if (src.pDrmFormatModifiers) {
        pDrmFormatModifiers = new uint64_t[src.drmFormatModifierCount];
        memcpy ((void *)pDrmFormatModifiers, (void *)src.pDrmFormatModifiers, sizeof(uint64_t)*src.drmFormatModifierCount);
    }

    return *this;
}

safe_VkImageDrmFormatModifierListCreateInfoEXT::~safe_VkImageDrmFormatModifierListCreateInfoEXT()
{
    if (pDrmFormatModifiers)
        delete[] pDrmFormatModifiers;
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkImageDrmFormatModifierListCreateInfoEXT::initialize(const VkImageDrmFormatModifierListCreateInfoEXT* in_struct)
{
    sType = in_struct->sType;
    drmFormatModifierCount = in_struct->drmFormatModifierCount;
    pDrmFormatModifiers = nullptr;
    pNext = SafePnextCopy(in_struct->pNext);
    if (in_struct->pDrmFormatModifiers) {
        pDrmFormatModifiers = new uint64_t[in_struct->drmFormatModifierCount];
        memcpy ((void *)pDrmFormatModifiers, (void *)in_struct->pDrmFormatModifiers, sizeof(uint64_t)*in_struct->drmFormatModifierCount);
    }
}

void safe_VkImageDrmFormatModifierListCreateInfoEXT::initialize(const safe_VkImageDrmFormatModifierListCreateInfoEXT* src)
{
    sType = src->sType;
    drmFormatModifierCount = src->drmFormatModifierCount;
    pDrmFormatModifiers = nullptr;
    pNext = SafePnextCopy(src->pNext);
    if (src->pDrmFormatModifiers) {
        pDrmFormatModifiers = new uint64_t[src->drmFormatModifierCount];
        memcpy ((void *)pDrmFormatModifiers, (void *)src->pDrmFormatModifiers, sizeof(uint64_t)*src->drmFormatModifierCount);
    }
}

safe_VkImageDrmFormatModifierExplicitCreateInfoEXT::safe_VkImageDrmFormatModifierExplicitCreateInfoEXT(const VkImageDrmFormatModifierExplicitCreateInfoEXT* in_struct) :
    sType(in_struct->sType),
    drmFormatModifier(in_struct->drmFormatModifier),
    drmFormatModifierPlaneCount(in_struct->drmFormatModifierPlaneCount),
    pPlaneLayouts(nullptr)
{
    pNext = SafePnextCopy(in_struct->pNext);
    if (in_struct->pPlaneLayouts) {
        pPlaneLayouts = new VkSubresourceLayout[in_struct->drmFormatModifierPlaneCount];
        memcpy ((void *)pPlaneLayouts, (void *)in_struct->pPlaneLayouts, sizeof(VkSubresourceLayout)*in_struct->drmFormatModifierPlaneCount);
    }
}

safe_VkImageDrmFormatModifierExplicitCreateInfoEXT::safe_VkImageDrmFormatModifierExplicitCreateInfoEXT() :
    pNext(nullptr),
    pPlaneLayouts(nullptr)
{}

safe_VkImageDrmFormatModifierExplicitCreateInfoEXT::safe_VkImageDrmFormatModifierExplicitCreateInfoEXT(const safe_VkImageDrmFormatModifierExplicitCreateInfoEXT& src)
{
    sType = src.sType;
    drmFormatModifier = src.drmFormatModifier;
    drmFormatModifierPlaneCount = src.drmFormatModifierPlaneCount;
    pPlaneLayouts = nullptr;
    pNext = SafePnextCopy(src.pNext);
    if (src.pPlaneLayouts) {
        pPlaneLayouts = new VkSubresourceLayout[src.drmFormatModifierPlaneCount];
        memcpy ((void *)pPlaneLayouts, (void *)src.pPlaneLayouts, sizeof(VkSubresourceLayout)*src.drmFormatModifierPlaneCount);
    }
}

safe_VkImageDrmFormatModifierExplicitCreateInfoEXT& safe_VkImageDrmFormatModifierExplicitCreateInfoEXT::operator=(const safe_VkImageDrmFormatModifierExplicitCreateInfoEXT& src)
{
    if (&src == this) return *this;

    if (pPlaneLayouts)
        delete[] pPlaneLayouts;
    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    drmFormatModifier = src.drmFormatModifier;
    drmFormatModifierPlaneCount = src.drmFormatModifierPlaneCount;
    pPlaneLayouts = nullptr;
    pNext = SafePnextCopy(src.pNext);
    if (src.pPlaneLayouts) {
        pPlaneLayouts = new VkSubresourceLayout[src.drmFormatModifierPlaneCount];
        memcpy ((void *)pPlaneLayouts, (void *)src.pPlaneLayouts, sizeof(VkSubresourceLayout)*src.drmFormatModifierPlaneCount);
    }

    return *this;
}

safe_VkImageDrmFormatModifierExplicitCreateInfoEXT::~safe_VkImageDrmFormatModifierExplicitCreateInfoEXT()
{
    if (pPlaneLayouts)
        delete[] pPlaneLayouts;
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkImageDrmFormatModifierExplicitCreateInfoEXT::initialize(const VkImageDrmFormatModifierExplicitCreateInfoEXT* in_struct)
{
    sType = in_struct->sType;
    drmFormatModifier = in_struct->drmFormatModifier;
    drmFormatModifierPlaneCount = in_struct->drmFormatModifierPlaneCount;
    pPlaneLayouts = nullptr;
    pNext = SafePnextCopy(in_struct->pNext);
    if (in_struct->pPlaneLayouts) {
        pPlaneLayouts = new VkSubresourceLayout[in_struct->drmFormatModifierPlaneCount];
        memcpy ((void *)pPlaneLayouts, (void *)in_struct->pPlaneLayouts, sizeof(VkSubresourceLayout)*in_struct->drmFormatModifierPlaneCount);
    }
}

void safe_VkImageDrmFormatModifierExplicitCreateInfoEXT::initialize(const safe_VkImageDrmFormatModifierExplicitCreateInfoEXT* src)
{
    sType = src->sType;
    drmFormatModifier = src->drmFormatModifier;
    drmFormatModifierPlaneCount = src->drmFormatModifierPlaneCount;
    pPlaneLayouts = nullptr;
    pNext = SafePnextCopy(src->pNext);
    if (src->pPlaneLayouts) {
        pPlaneLayouts = new VkSubresourceLayout[src->drmFormatModifierPlaneCount];
        memcpy ((void *)pPlaneLayouts, (void *)src->pPlaneLayouts, sizeof(VkSubresourceLayout)*src->drmFormatModifierPlaneCount);
    }
}

safe_VkImageDrmFormatModifierPropertiesEXT::safe_VkImageDrmFormatModifierPropertiesEXT(const VkImageDrmFormatModifierPropertiesEXT* in_struct) :
    sType(in_struct->sType),
    drmFormatModifier(in_struct->drmFormatModifier)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkImageDrmFormatModifierPropertiesEXT::safe_VkImageDrmFormatModifierPropertiesEXT() :
    pNext(nullptr)
{}

safe_VkImageDrmFormatModifierPropertiesEXT::safe_VkImageDrmFormatModifierPropertiesEXT(const safe_VkImageDrmFormatModifierPropertiesEXT& src)
{
    sType = src.sType;
    drmFormatModifier = src.drmFormatModifier;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkImageDrmFormatModifierPropertiesEXT& safe_VkImageDrmFormatModifierPropertiesEXT::operator=(const safe_VkImageDrmFormatModifierPropertiesEXT& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    drmFormatModifier = src.drmFormatModifier;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkImageDrmFormatModifierPropertiesEXT::~safe_VkImageDrmFormatModifierPropertiesEXT()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkImageDrmFormatModifierPropertiesEXT::initialize(const VkImageDrmFormatModifierPropertiesEXT* in_struct)
{
    sType = in_struct->sType;
    drmFormatModifier = in_struct->drmFormatModifier;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkImageDrmFormatModifierPropertiesEXT::initialize(const safe_VkImageDrmFormatModifierPropertiesEXT* src)
{
    sType = src->sType;
    drmFormatModifier = src->drmFormatModifier;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkValidationCacheCreateInfoEXT::safe_VkValidationCacheCreateInfoEXT(const VkValidationCacheCreateInfoEXT* in_struct) :
    sType(in_struct->sType),
    flags(in_struct->flags),
    initialDataSize(in_struct->initialDataSize),
    pInitialData(in_struct->pInitialData)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkValidationCacheCreateInfoEXT::safe_VkValidationCacheCreateInfoEXT() :
    pNext(nullptr),
    pInitialData(nullptr)
{}

safe_VkValidationCacheCreateInfoEXT::safe_VkValidationCacheCreateInfoEXT(const safe_VkValidationCacheCreateInfoEXT& src)
{
    sType = src.sType;
    flags = src.flags;
    initialDataSize = src.initialDataSize;
    pInitialData = src.pInitialData;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkValidationCacheCreateInfoEXT& safe_VkValidationCacheCreateInfoEXT::operator=(const safe_VkValidationCacheCreateInfoEXT& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    flags = src.flags;
    initialDataSize = src.initialDataSize;
    pInitialData = src.pInitialData;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkValidationCacheCreateInfoEXT::~safe_VkValidationCacheCreateInfoEXT()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkValidationCacheCreateInfoEXT::initialize(const VkValidationCacheCreateInfoEXT* in_struct)
{
    sType = in_struct->sType;
    flags = in_struct->flags;
    initialDataSize = in_struct->initialDataSize;
    pInitialData = in_struct->pInitialData;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkValidationCacheCreateInfoEXT::initialize(const safe_VkValidationCacheCreateInfoEXT* src)
{
    sType = src->sType;
    flags = src->flags;
    initialDataSize = src->initialDataSize;
    pInitialData = src->pInitialData;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkShaderModuleValidationCacheCreateInfoEXT::safe_VkShaderModuleValidationCacheCreateInfoEXT(const VkShaderModuleValidationCacheCreateInfoEXT* in_struct) :
    sType(in_struct->sType),
    validationCache(in_struct->validationCache)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkShaderModuleValidationCacheCreateInfoEXT::safe_VkShaderModuleValidationCacheCreateInfoEXT() :
    pNext(nullptr)
{}

safe_VkShaderModuleValidationCacheCreateInfoEXT::safe_VkShaderModuleValidationCacheCreateInfoEXT(const safe_VkShaderModuleValidationCacheCreateInfoEXT& src)
{
    sType = src.sType;
    validationCache = src.validationCache;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkShaderModuleValidationCacheCreateInfoEXT& safe_VkShaderModuleValidationCacheCreateInfoEXT::operator=(const safe_VkShaderModuleValidationCacheCreateInfoEXT& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    validationCache = src.validationCache;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkShaderModuleValidationCacheCreateInfoEXT::~safe_VkShaderModuleValidationCacheCreateInfoEXT()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkShaderModuleValidationCacheCreateInfoEXT::initialize(const VkShaderModuleValidationCacheCreateInfoEXT* in_struct)
{
    sType = in_struct->sType;
    validationCache = in_struct->validationCache;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkShaderModuleValidationCacheCreateInfoEXT::initialize(const safe_VkShaderModuleValidationCacheCreateInfoEXT* src)
{
    sType = src->sType;
    validationCache = src->validationCache;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkDescriptorSetLayoutBindingFlagsCreateInfoEXT::safe_VkDescriptorSetLayoutBindingFlagsCreateInfoEXT(const VkDescriptorSetLayoutBindingFlagsCreateInfoEXT* in_struct) :
    sType(in_struct->sType),
    bindingCount(in_struct->bindingCount),
    pBindingFlags(nullptr)
{
    pNext = SafePnextCopy(in_struct->pNext);
    if (in_struct->pBindingFlags) {
        pBindingFlags = new VkDescriptorBindingFlagsEXT[in_struct->bindingCount];
        memcpy ((void *)pBindingFlags, (void *)in_struct->pBindingFlags, sizeof(VkDescriptorBindingFlagsEXT)*in_struct->bindingCount);
    }
}

safe_VkDescriptorSetLayoutBindingFlagsCreateInfoEXT::safe_VkDescriptorSetLayoutBindingFlagsCreateInfoEXT() :
    pNext(nullptr),
    pBindingFlags(nullptr)
{}

safe_VkDescriptorSetLayoutBindingFlagsCreateInfoEXT::safe_VkDescriptorSetLayoutBindingFlagsCreateInfoEXT(const safe_VkDescriptorSetLayoutBindingFlagsCreateInfoEXT& src)
{
    sType = src.sType;
    bindingCount = src.bindingCount;
    pBindingFlags = nullptr;
    pNext = SafePnextCopy(src.pNext);
    if (src.pBindingFlags) {
        pBindingFlags = new VkDescriptorBindingFlagsEXT[src.bindingCount];
        memcpy ((void *)pBindingFlags, (void *)src.pBindingFlags, sizeof(VkDescriptorBindingFlagsEXT)*src.bindingCount);
    }
}

safe_VkDescriptorSetLayoutBindingFlagsCreateInfoEXT& safe_VkDescriptorSetLayoutBindingFlagsCreateInfoEXT::operator=(const safe_VkDescriptorSetLayoutBindingFlagsCreateInfoEXT& src)
{
    if (&src == this) return *this;

    if (pBindingFlags)
        delete[] pBindingFlags;
    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    bindingCount = src.bindingCount;
    pBindingFlags = nullptr;
    pNext = SafePnextCopy(src.pNext);
    if (src.pBindingFlags) {
        pBindingFlags = new VkDescriptorBindingFlagsEXT[src.bindingCount];
        memcpy ((void *)pBindingFlags, (void *)src.pBindingFlags, sizeof(VkDescriptorBindingFlagsEXT)*src.bindingCount);
    }

    return *this;
}

safe_VkDescriptorSetLayoutBindingFlagsCreateInfoEXT::~safe_VkDescriptorSetLayoutBindingFlagsCreateInfoEXT()
{
    if (pBindingFlags)
        delete[] pBindingFlags;
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkDescriptorSetLayoutBindingFlagsCreateInfoEXT::initialize(const VkDescriptorSetLayoutBindingFlagsCreateInfoEXT* in_struct)
{
    sType = in_struct->sType;
    bindingCount = in_struct->bindingCount;
    pBindingFlags = nullptr;
    pNext = SafePnextCopy(in_struct->pNext);
    if (in_struct->pBindingFlags) {
        pBindingFlags = new VkDescriptorBindingFlagsEXT[in_struct->bindingCount];
        memcpy ((void *)pBindingFlags, (void *)in_struct->pBindingFlags, sizeof(VkDescriptorBindingFlagsEXT)*in_struct->bindingCount);
    }
}

void safe_VkDescriptorSetLayoutBindingFlagsCreateInfoEXT::initialize(const safe_VkDescriptorSetLayoutBindingFlagsCreateInfoEXT* src)
{
    sType = src->sType;
    bindingCount = src->bindingCount;
    pBindingFlags = nullptr;
    pNext = SafePnextCopy(src->pNext);
    if (src->pBindingFlags) {
        pBindingFlags = new VkDescriptorBindingFlagsEXT[src->bindingCount];
        memcpy ((void *)pBindingFlags, (void *)src->pBindingFlags, sizeof(VkDescriptorBindingFlagsEXT)*src->bindingCount);
    }
}

safe_VkPhysicalDeviceDescriptorIndexingFeaturesEXT::safe_VkPhysicalDeviceDescriptorIndexingFeaturesEXT(const VkPhysicalDeviceDescriptorIndexingFeaturesEXT* in_struct) :
    sType(in_struct->sType),
    shaderInputAttachmentArrayDynamicIndexing(in_struct->shaderInputAttachmentArrayDynamicIndexing),
    shaderUniformTexelBufferArrayDynamicIndexing(in_struct->shaderUniformTexelBufferArrayDynamicIndexing),
    shaderStorageTexelBufferArrayDynamicIndexing(in_struct->shaderStorageTexelBufferArrayDynamicIndexing),
    shaderUniformBufferArrayNonUniformIndexing(in_struct->shaderUniformBufferArrayNonUniformIndexing),
    shaderSampledImageArrayNonUniformIndexing(in_struct->shaderSampledImageArrayNonUniformIndexing),
    shaderStorageBufferArrayNonUniformIndexing(in_struct->shaderStorageBufferArrayNonUniformIndexing),
    shaderStorageImageArrayNonUniformIndexing(in_struct->shaderStorageImageArrayNonUniformIndexing),
    shaderInputAttachmentArrayNonUniformIndexing(in_struct->shaderInputAttachmentArrayNonUniformIndexing),
    shaderUniformTexelBufferArrayNonUniformIndexing(in_struct->shaderUniformTexelBufferArrayNonUniformIndexing),
    shaderStorageTexelBufferArrayNonUniformIndexing(in_struct->shaderStorageTexelBufferArrayNonUniformIndexing),
    descriptorBindingUniformBufferUpdateAfterBind(in_struct->descriptorBindingUniformBufferUpdateAfterBind),
    descriptorBindingSampledImageUpdateAfterBind(in_struct->descriptorBindingSampledImageUpdateAfterBind),
    descriptorBindingStorageImageUpdateAfterBind(in_struct->descriptorBindingStorageImageUpdateAfterBind),
    descriptorBindingStorageBufferUpdateAfterBind(in_struct->descriptorBindingStorageBufferUpdateAfterBind),
    descriptorBindingUniformTexelBufferUpdateAfterBind(in_struct->descriptorBindingUniformTexelBufferUpdateAfterBind),
    descriptorBindingStorageTexelBufferUpdateAfterBind(in_struct->descriptorBindingStorageTexelBufferUpdateAfterBind),
    descriptorBindingUpdateUnusedWhilePending(in_struct->descriptorBindingUpdateUnusedWhilePending),
    descriptorBindingPartiallyBound(in_struct->descriptorBindingPartiallyBound),
    descriptorBindingVariableDescriptorCount(in_struct->descriptorBindingVariableDescriptorCount),
    runtimeDescriptorArray(in_struct->runtimeDescriptorArray)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkPhysicalDeviceDescriptorIndexingFeaturesEXT::safe_VkPhysicalDeviceDescriptorIndexingFeaturesEXT() :
    pNext(nullptr)
{}

safe_VkPhysicalDeviceDescriptorIndexingFeaturesEXT::safe_VkPhysicalDeviceDescriptorIndexingFeaturesEXT(const safe_VkPhysicalDeviceDescriptorIndexingFeaturesEXT& src)
{
    sType = src.sType;
    shaderInputAttachmentArrayDynamicIndexing = src.shaderInputAttachmentArrayDynamicIndexing;
    shaderUniformTexelBufferArrayDynamicIndexing = src.shaderUniformTexelBufferArrayDynamicIndexing;
    shaderStorageTexelBufferArrayDynamicIndexing = src.shaderStorageTexelBufferArrayDynamicIndexing;
    shaderUniformBufferArrayNonUniformIndexing = src.shaderUniformBufferArrayNonUniformIndexing;
    shaderSampledImageArrayNonUniformIndexing = src.shaderSampledImageArrayNonUniformIndexing;
    shaderStorageBufferArrayNonUniformIndexing = src.shaderStorageBufferArrayNonUniformIndexing;
    shaderStorageImageArrayNonUniformIndexing = src.shaderStorageImageArrayNonUniformIndexing;
    shaderInputAttachmentArrayNonUniformIndexing = src.shaderInputAttachmentArrayNonUniformIndexing;
    shaderUniformTexelBufferArrayNonUniformIndexing = src.shaderUniformTexelBufferArrayNonUniformIndexing;
    shaderStorageTexelBufferArrayNonUniformIndexing = src.shaderStorageTexelBufferArrayNonUniformIndexing;
    descriptorBindingUniformBufferUpdateAfterBind = src.descriptorBindingUniformBufferUpdateAfterBind;
    descriptorBindingSampledImageUpdateAfterBind = src.descriptorBindingSampledImageUpdateAfterBind;
    descriptorBindingStorageImageUpdateAfterBind = src.descriptorBindingStorageImageUpdateAfterBind;
    descriptorBindingStorageBufferUpdateAfterBind = src.descriptorBindingStorageBufferUpdateAfterBind;
    descriptorBindingUniformTexelBufferUpdateAfterBind = src.descriptorBindingUniformTexelBufferUpdateAfterBind;
    descriptorBindingStorageTexelBufferUpdateAfterBind = src.descriptorBindingStorageTexelBufferUpdateAfterBind;
    descriptorBindingUpdateUnusedWhilePending = src.descriptorBindingUpdateUnusedWhilePending;
    descriptorBindingPartiallyBound = src.descriptorBindingPartiallyBound;
    descriptorBindingVariableDescriptorCount = src.descriptorBindingVariableDescriptorCount;
    runtimeDescriptorArray = src.runtimeDescriptorArray;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkPhysicalDeviceDescriptorIndexingFeaturesEXT& safe_VkPhysicalDeviceDescriptorIndexingFeaturesEXT::operator=(const safe_VkPhysicalDeviceDescriptorIndexingFeaturesEXT& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    shaderInputAttachmentArrayDynamicIndexing = src.shaderInputAttachmentArrayDynamicIndexing;
    shaderUniformTexelBufferArrayDynamicIndexing = src.shaderUniformTexelBufferArrayDynamicIndexing;
    shaderStorageTexelBufferArrayDynamicIndexing = src.shaderStorageTexelBufferArrayDynamicIndexing;
    shaderUniformBufferArrayNonUniformIndexing = src.shaderUniformBufferArrayNonUniformIndexing;
    shaderSampledImageArrayNonUniformIndexing = src.shaderSampledImageArrayNonUniformIndexing;
    shaderStorageBufferArrayNonUniformIndexing = src.shaderStorageBufferArrayNonUniformIndexing;
    shaderStorageImageArrayNonUniformIndexing = src.shaderStorageImageArrayNonUniformIndexing;
    shaderInputAttachmentArrayNonUniformIndexing = src.shaderInputAttachmentArrayNonUniformIndexing;
    shaderUniformTexelBufferArrayNonUniformIndexing = src.shaderUniformTexelBufferArrayNonUniformIndexing;
    shaderStorageTexelBufferArrayNonUniformIndexing = src.shaderStorageTexelBufferArrayNonUniformIndexing;
    descriptorBindingUniformBufferUpdateAfterBind = src.descriptorBindingUniformBufferUpdateAfterBind;
    descriptorBindingSampledImageUpdateAfterBind = src.descriptorBindingSampledImageUpdateAfterBind;
    descriptorBindingStorageImageUpdateAfterBind = src.descriptorBindingStorageImageUpdateAfterBind;
    descriptorBindingStorageBufferUpdateAfterBind = src.descriptorBindingStorageBufferUpdateAfterBind;
    descriptorBindingUniformTexelBufferUpdateAfterBind = src.descriptorBindingUniformTexelBufferUpdateAfterBind;
    descriptorBindingStorageTexelBufferUpdateAfterBind = src.descriptorBindingStorageTexelBufferUpdateAfterBind;
    descriptorBindingUpdateUnusedWhilePending = src.descriptorBindingUpdateUnusedWhilePending;
    descriptorBindingPartiallyBound = src.descriptorBindingPartiallyBound;
    descriptorBindingVariableDescriptorCount = src.descriptorBindingVariableDescriptorCount;
    runtimeDescriptorArray = src.runtimeDescriptorArray;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkPhysicalDeviceDescriptorIndexingFeaturesEXT::~safe_VkPhysicalDeviceDescriptorIndexingFeaturesEXT()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPhysicalDeviceDescriptorIndexingFeaturesEXT::initialize(const VkPhysicalDeviceDescriptorIndexingFeaturesEXT* in_struct)
{
    sType = in_struct->sType;
    shaderInputAttachmentArrayDynamicIndexing = in_struct->shaderInputAttachmentArrayDynamicIndexing;
    shaderUniformTexelBufferArrayDynamicIndexing = in_struct->shaderUniformTexelBufferArrayDynamicIndexing;
    shaderStorageTexelBufferArrayDynamicIndexing = in_struct->shaderStorageTexelBufferArrayDynamicIndexing;
    shaderUniformBufferArrayNonUniformIndexing = in_struct->shaderUniformBufferArrayNonUniformIndexing;
    shaderSampledImageArrayNonUniformIndexing = in_struct->shaderSampledImageArrayNonUniformIndexing;
    shaderStorageBufferArrayNonUniformIndexing = in_struct->shaderStorageBufferArrayNonUniformIndexing;
    shaderStorageImageArrayNonUniformIndexing = in_struct->shaderStorageImageArrayNonUniformIndexing;
    shaderInputAttachmentArrayNonUniformIndexing = in_struct->shaderInputAttachmentArrayNonUniformIndexing;
    shaderUniformTexelBufferArrayNonUniformIndexing = in_struct->shaderUniformTexelBufferArrayNonUniformIndexing;
    shaderStorageTexelBufferArrayNonUniformIndexing = in_struct->shaderStorageTexelBufferArrayNonUniformIndexing;
    descriptorBindingUniformBufferUpdateAfterBind = in_struct->descriptorBindingUniformBufferUpdateAfterBind;
    descriptorBindingSampledImageUpdateAfterBind = in_struct->descriptorBindingSampledImageUpdateAfterBind;
    descriptorBindingStorageImageUpdateAfterBind = in_struct->descriptorBindingStorageImageUpdateAfterBind;
    descriptorBindingStorageBufferUpdateAfterBind = in_struct->descriptorBindingStorageBufferUpdateAfterBind;
    descriptorBindingUniformTexelBufferUpdateAfterBind = in_struct->descriptorBindingUniformTexelBufferUpdateAfterBind;
    descriptorBindingStorageTexelBufferUpdateAfterBind = in_struct->descriptorBindingStorageTexelBufferUpdateAfterBind;
    descriptorBindingUpdateUnusedWhilePending = in_struct->descriptorBindingUpdateUnusedWhilePending;
    descriptorBindingPartiallyBound = in_struct->descriptorBindingPartiallyBound;
    descriptorBindingVariableDescriptorCount = in_struct->descriptorBindingVariableDescriptorCount;
    runtimeDescriptorArray = in_struct->runtimeDescriptorArray;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkPhysicalDeviceDescriptorIndexingFeaturesEXT::initialize(const safe_VkPhysicalDeviceDescriptorIndexingFeaturesEXT* src)
{
    sType = src->sType;
    shaderInputAttachmentArrayDynamicIndexing = src->shaderInputAttachmentArrayDynamicIndexing;
    shaderUniformTexelBufferArrayDynamicIndexing = src->shaderUniformTexelBufferArrayDynamicIndexing;
    shaderStorageTexelBufferArrayDynamicIndexing = src->shaderStorageTexelBufferArrayDynamicIndexing;
    shaderUniformBufferArrayNonUniformIndexing = src->shaderUniformBufferArrayNonUniformIndexing;
    shaderSampledImageArrayNonUniformIndexing = src->shaderSampledImageArrayNonUniformIndexing;
    shaderStorageBufferArrayNonUniformIndexing = src->shaderStorageBufferArrayNonUniformIndexing;
    shaderStorageImageArrayNonUniformIndexing = src->shaderStorageImageArrayNonUniformIndexing;
    shaderInputAttachmentArrayNonUniformIndexing = src->shaderInputAttachmentArrayNonUniformIndexing;
    shaderUniformTexelBufferArrayNonUniformIndexing = src->shaderUniformTexelBufferArrayNonUniformIndexing;
    shaderStorageTexelBufferArrayNonUniformIndexing = src->shaderStorageTexelBufferArrayNonUniformIndexing;
    descriptorBindingUniformBufferUpdateAfterBind = src->descriptorBindingUniformBufferUpdateAfterBind;
    descriptorBindingSampledImageUpdateAfterBind = src->descriptorBindingSampledImageUpdateAfterBind;
    descriptorBindingStorageImageUpdateAfterBind = src->descriptorBindingStorageImageUpdateAfterBind;
    descriptorBindingStorageBufferUpdateAfterBind = src->descriptorBindingStorageBufferUpdateAfterBind;
    descriptorBindingUniformTexelBufferUpdateAfterBind = src->descriptorBindingUniformTexelBufferUpdateAfterBind;
    descriptorBindingStorageTexelBufferUpdateAfterBind = src->descriptorBindingStorageTexelBufferUpdateAfterBind;
    descriptorBindingUpdateUnusedWhilePending = src->descriptorBindingUpdateUnusedWhilePending;
    descriptorBindingPartiallyBound = src->descriptorBindingPartiallyBound;
    descriptorBindingVariableDescriptorCount = src->descriptorBindingVariableDescriptorCount;
    runtimeDescriptorArray = src->runtimeDescriptorArray;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkPhysicalDeviceDescriptorIndexingPropertiesEXT::safe_VkPhysicalDeviceDescriptorIndexingPropertiesEXT(const VkPhysicalDeviceDescriptorIndexingPropertiesEXT* in_struct) :
    sType(in_struct->sType),
    maxUpdateAfterBindDescriptorsInAllPools(in_struct->maxUpdateAfterBindDescriptorsInAllPools),
    shaderUniformBufferArrayNonUniformIndexingNative(in_struct->shaderUniformBufferArrayNonUniformIndexingNative),
    shaderSampledImageArrayNonUniformIndexingNative(in_struct->shaderSampledImageArrayNonUniformIndexingNative),
    shaderStorageBufferArrayNonUniformIndexingNative(in_struct->shaderStorageBufferArrayNonUniformIndexingNative),
    shaderStorageImageArrayNonUniformIndexingNative(in_struct->shaderStorageImageArrayNonUniformIndexingNative),
    shaderInputAttachmentArrayNonUniformIndexingNative(in_struct->shaderInputAttachmentArrayNonUniformIndexingNative),
    robustBufferAccessUpdateAfterBind(in_struct->robustBufferAccessUpdateAfterBind),
    quadDivergentImplicitLod(in_struct->quadDivergentImplicitLod),
    maxPerStageDescriptorUpdateAfterBindSamplers(in_struct->maxPerStageDescriptorUpdateAfterBindSamplers),
    maxPerStageDescriptorUpdateAfterBindUniformBuffers(in_struct->maxPerStageDescriptorUpdateAfterBindUniformBuffers),
    maxPerStageDescriptorUpdateAfterBindStorageBuffers(in_struct->maxPerStageDescriptorUpdateAfterBindStorageBuffers),
    maxPerStageDescriptorUpdateAfterBindSampledImages(in_struct->maxPerStageDescriptorUpdateAfterBindSampledImages),
    maxPerStageDescriptorUpdateAfterBindStorageImages(in_struct->maxPerStageDescriptorUpdateAfterBindStorageImages),
    maxPerStageDescriptorUpdateAfterBindInputAttachments(in_struct->maxPerStageDescriptorUpdateAfterBindInputAttachments),
    maxPerStageUpdateAfterBindResources(in_struct->maxPerStageUpdateAfterBindResources),
    maxDescriptorSetUpdateAfterBindSamplers(in_struct->maxDescriptorSetUpdateAfterBindSamplers),
    maxDescriptorSetUpdateAfterBindUniformBuffers(in_struct->maxDescriptorSetUpdateAfterBindUniformBuffers),
    maxDescriptorSetUpdateAfterBindUniformBuffersDynamic(in_struct->maxDescriptorSetUpdateAfterBindUniformBuffersDynamic),
    maxDescriptorSetUpdateAfterBindStorageBuffers(in_struct->maxDescriptorSetUpdateAfterBindStorageBuffers),
    maxDescriptorSetUpdateAfterBindStorageBuffersDynamic(in_struct->maxDescriptorSetUpdateAfterBindStorageBuffersDynamic),
    maxDescriptorSetUpdateAfterBindSampledImages(in_struct->maxDescriptorSetUpdateAfterBindSampledImages),
    maxDescriptorSetUpdateAfterBindStorageImages(in_struct->maxDescriptorSetUpdateAfterBindStorageImages),
    maxDescriptorSetUpdateAfterBindInputAttachments(in_struct->maxDescriptorSetUpdateAfterBindInputAttachments)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkPhysicalDeviceDescriptorIndexingPropertiesEXT::safe_VkPhysicalDeviceDescriptorIndexingPropertiesEXT() :
    pNext(nullptr)
{}

safe_VkPhysicalDeviceDescriptorIndexingPropertiesEXT::safe_VkPhysicalDeviceDescriptorIndexingPropertiesEXT(const safe_VkPhysicalDeviceDescriptorIndexingPropertiesEXT& src)
{
    sType = src.sType;
    maxUpdateAfterBindDescriptorsInAllPools = src.maxUpdateAfterBindDescriptorsInAllPools;
    shaderUniformBufferArrayNonUniformIndexingNative = src.shaderUniformBufferArrayNonUniformIndexingNative;
    shaderSampledImageArrayNonUniformIndexingNative = src.shaderSampledImageArrayNonUniformIndexingNative;
    shaderStorageBufferArrayNonUniformIndexingNative = src.shaderStorageBufferArrayNonUniformIndexingNative;
    shaderStorageImageArrayNonUniformIndexingNative = src.shaderStorageImageArrayNonUniformIndexingNative;
    shaderInputAttachmentArrayNonUniformIndexingNative = src.shaderInputAttachmentArrayNonUniformIndexingNative;
    robustBufferAccessUpdateAfterBind = src.robustBufferAccessUpdateAfterBind;
    quadDivergentImplicitLod = src.quadDivergentImplicitLod;
    maxPerStageDescriptorUpdateAfterBindSamplers = src.maxPerStageDescriptorUpdateAfterBindSamplers;
    maxPerStageDescriptorUpdateAfterBindUniformBuffers = src.maxPerStageDescriptorUpdateAfterBindUniformBuffers;
    maxPerStageDescriptorUpdateAfterBindStorageBuffers = src.maxPerStageDescriptorUpdateAfterBindStorageBuffers;
    maxPerStageDescriptorUpdateAfterBindSampledImages = src.maxPerStageDescriptorUpdateAfterBindSampledImages;
    maxPerStageDescriptorUpdateAfterBindStorageImages = src.maxPerStageDescriptorUpdateAfterBindStorageImages;
    maxPerStageDescriptorUpdateAfterBindInputAttachments = src.maxPerStageDescriptorUpdateAfterBindInputAttachments;
    maxPerStageUpdateAfterBindResources = src.maxPerStageUpdateAfterBindResources;
    maxDescriptorSetUpdateAfterBindSamplers = src.maxDescriptorSetUpdateAfterBindSamplers;
    maxDescriptorSetUpdateAfterBindUniformBuffers = src.maxDescriptorSetUpdateAfterBindUniformBuffers;
    maxDescriptorSetUpdateAfterBindUniformBuffersDynamic = src.maxDescriptorSetUpdateAfterBindUniformBuffersDynamic;
    maxDescriptorSetUpdateAfterBindStorageBuffers = src.maxDescriptorSetUpdateAfterBindStorageBuffers;
    maxDescriptorSetUpdateAfterBindStorageBuffersDynamic = src.maxDescriptorSetUpdateAfterBindStorageBuffersDynamic;
    maxDescriptorSetUpdateAfterBindSampledImages = src.maxDescriptorSetUpdateAfterBindSampledImages;
    maxDescriptorSetUpdateAfterBindStorageImages = src.maxDescriptorSetUpdateAfterBindStorageImages;
    maxDescriptorSetUpdateAfterBindInputAttachments = src.maxDescriptorSetUpdateAfterBindInputAttachments;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkPhysicalDeviceDescriptorIndexingPropertiesEXT& safe_VkPhysicalDeviceDescriptorIndexingPropertiesEXT::operator=(const safe_VkPhysicalDeviceDescriptorIndexingPropertiesEXT& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    maxUpdateAfterBindDescriptorsInAllPools = src.maxUpdateAfterBindDescriptorsInAllPools;
    shaderUniformBufferArrayNonUniformIndexingNative = src.shaderUniformBufferArrayNonUniformIndexingNative;
    shaderSampledImageArrayNonUniformIndexingNative = src.shaderSampledImageArrayNonUniformIndexingNative;
    shaderStorageBufferArrayNonUniformIndexingNative = src.shaderStorageBufferArrayNonUniformIndexingNative;
    shaderStorageImageArrayNonUniformIndexingNative = src.shaderStorageImageArrayNonUniformIndexingNative;
    shaderInputAttachmentArrayNonUniformIndexingNative = src.shaderInputAttachmentArrayNonUniformIndexingNative;
    robustBufferAccessUpdateAfterBind = src.robustBufferAccessUpdateAfterBind;
    quadDivergentImplicitLod = src.quadDivergentImplicitLod;
    maxPerStageDescriptorUpdateAfterBindSamplers = src.maxPerStageDescriptorUpdateAfterBindSamplers;
    maxPerStageDescriptorUpdateAfterBindUniformBuffers = src.maxPerStageDescriptorUpdateAfterBindUniformBuffers;
    maxPerStageDescriptorUpdateAfterBindStorageBuffers = src.maxPerStageDescriptorUpdateAfterBindStorageBuffers;
    maxPerStageDescriptorUpdateAfterBindSampledImages = src.maxPerStageDescriptorUpdateAfterBindSampledImages;
    maxPerStageDescriptorUpdateAfterBindStorageImages = src.maxPerStageDescriptorUpdateAfterBindStorageImages;
    maxPerStageDescriptorUpdateAfterBindInputAttachments = src.maxPerStageDescriptorUpdateAfterBindInputAttachments;
    maxPerStageUpdateAfterBindResources = src.maxPerStageUpdateAfterBindResources;
    maxDescriptorSetUpdateAfterBindSamplers = src.maxDescriptorSetUpdateAfterBindSamplers;
    maxDescriptorSetUpdateAfterBindUniformBuffers = src.maxDescriptorSetUpdateAfterBindUniformBuffers;
    maxDescriptorSetUpdateAfterBindUniformBuffersDynamic = src.maxDescriptorSetUpdateAfterBindUniformBuffersDynamic;
    maxDescriptorSetUpdateAfterBindStorageBuffers = src.maxDescriptorSetUpdateAfterBindStorageBuffers;
    maxDescriptorSetUpdateAfterBindStorageBuffersDynamic = src.maxDescriptorSetUpdateAfterBindStorageBuffersDynamic;
    maxDescriptorSetUpdateAfterBindSampledImages = src.maxDescriptorSetUpdateAfterBindSampledImages;
    maxDescriptorSetUpdateAfterBindStorageImages = src.maxDescriptorSetUpdateAfterBindStorageImages;
    maxDescriptorSetUpdateAfterBindInputAttachments = src.maxDescriptorSetUpdateAfterBindInputAttachments;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkPhysicalDeviceDescriptorIndexingPropertiesEXT::~safe_VkPhysicalDeviceDescriptorIndexingPropertiesEXT()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPhysicalDeviceDescriptorIndexingPropertiesEXT::initialize(const VkPhysicalDeviceDescriptorIndexingPropertiesEXT* in_struct)
{
    sType = in_struct->sType;
    maxUpdateAfterBindDescriptorsInAllPools = in_struct->maxUpdateAfterBindDescriptorsInAllPools;
    shaderUniformBufferArrayNonUniformIndexingNative = in_struct->shaderUniformBufferArrayNonUniformIndexingNative;
    shaderSampledImageArrayNonUniformIndexingNative = in_struct->shaderSampledImageArrayNonUniformIndexingNative;
    shaderStorageBufferArrayNonUniformIndexingNative = in_struct->shaderStorageBufferArrayNonUniformIndexingNative;
    shaderStorageImageArrayNonUniformIndexingNative = in_struct->shaderStorageImageArrayNonUniformIndexingNative;
    shaderInputAttachmentArrayNonUniformIndexingNative = in_struct->shaderInputAttachmentArrayNonUniformIndexingNative;
    robustBufferAccessUpdateAfterBind = in_struct->robustBufferAccessUpdateAfterBind;
    quadDivergentImplicitLod = in_struct->quadDivergentImplicitLod;
    maxPerStageDescriptorUpdateAfterBindSamplers = in_struct->maxPerStageDescriptorUpdateAfterBindSamplers;
    maxPerStageDescriptorUpdateAfterBindUniformBuffers = in_struct->maxPerStageDescriptorUpdateAfterBindUniformBuffers;
    maxPerStageDescriptorUpdateAfterBindStorageBuffers = in_struct->maxPerStageDescriptorUpdateAfterBindStorageBuffers;
    maxPerStageDescriptorUpdateAfterBindSampledImages = in_struct->maxPerStageDescriptorUpdateAfterBindSampledImages;
    maxPerStageDescriptorUpdateAfterBindStorageImages = in_struct->maxPerStageDescriptorUpdateAfterBindStorageImages;
    maxPerStageDescriptorUpdateAfterBindInputAttachments = in_struct->maxPerStageDescriptorUpdateAfterBindInputAttachments;
    maxPerStageUpdateAfterBindResources = in_struct->maxPerStageUpdateAfterBindResources;
    maxDescriptorSetUpdateAfterBindSamplers = in_struct->maxDescriptorSetUpdateAfterBindSamplers;
    maxDescriptorSetUpdateAfterBindUniformBuffers = in_struct->maxDescriptorSetUpdateAfterBindUniformBuffers;
    maxDescriptorSetUpdateAfterBindUniformBuffersDynamic = in_struct->maxDescriptorSetUpdateAfterBindUniformBuffersDynamic;
    maxDescriptorSetUpdateAfterBindStorageBuffers = in_struct->maxDescriptorSetUpdateAfterBindStorageBuffers;
    maxDescriptorSetUpdateAfterBindStorageBuffersDynamic = in_struct->maxDescriptorSetUpdateAfterBindStorageBuffersDynamic;
    maxDescriptorSetUpdateAfterBindSampledImages = in_struct->maxDescriptorSetUpdateAfterBindSampledImages;
    maxDescriptorSetUpdateAfterBindStorageImages = in_struct->maxDescriptorSetUpdateAfterBindStorageImages;
    maxDescriptorSetUpdateAfterBindInputAttachments = in_struct->maxDescriptorSetUpdateAfterBindInputAttachments;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkPhysicalDeviceDescriptorIndexingPropertiesEXT::initialize(const safe_VkPhysicalDeviceDescriptorIndexingPropertiesEXT* src)
{
    sType = src->sType;
    maxUpdateAfterBindDescriptorsInAllPools = src->maxUpdateAfterBindDescriptorsInAllPools;
    shaderUniformBufferArrayNonUniformIndexingNative = src->shaderUniformBufferArrayNonUniformIndexingNative;
    shaderSampledImageArrayNonUniformIndexingNative = src->shaderSampledImageArrayNonUniformIndexingNative;
    shaderStorageBufferArrayNonUniformIndexingNative = src->shaderStorageBufferArrayNonUniformIndexingNative;
    shaderStorageImageArrayNonUniformIndexingNative = src->shaderStorageImageArrayNonUniformIndexingNative;
    shaderInputAttachmentArrayNonUniformIndexingNative = src->shaderInputAttachmentArrayNonUniformIndexingNative;
    robustBufferAccessUpdateAfterBind = src->robustBufferAccessUpdateAfterBind;
    quadDivergentImplicitLod = src->quadDivergentImplicitLod;
    maxPerStageDescriptorUpdateAfterBindSamplers = src->maxPerStageDescriptorUpdateAfterBindSamplers;
    maxPerStageDescriptorUpdateAfterBindUniformBuffers = src->maxPerStageDescriptorUpdateAfterBindUniformBuffers;
    maxPerStageDescriptorUpdateAfterBindStorageBuffers = src->maxPerStageDescriptorUpdateAfterBindStorageBuffers;
    maxPerStageDescriptorUpdateAfterBindSampledImages = src->maxPerStageDescriptorUpdateAfterBindSampledImages;
    maxPerStageDescriptorUpdateAfterBindStorageImages = src->maxPerStageDescriptorUpdateAfterBindStorageImages;
    maxPerStageDescriptorUpdateAfterBindInputAttachments = src->maxPerStageDescriptorUpdateAfterBindInputAttachments;
    maxPerStageUpdateAfterBindResources = src->maxPerStageUpdateAfterBindResources;
    maxDescriptorSetUpdateAfterBindSamplers = src->maxDescriptorSetUpdateAfterBindSamplers;
    maxDescriptorSetUpdateAfterBindUniformBuffers = src->maxDescriptorSetUpdateAfterBindUniformBuffers;
    maxDescriptorSetUpdateAfterBindUniformBuffersDynamic = src->maxDescriptorSetUpdateAfterBindUniformBuffersDynamic;
    maxDescriptorSetUpdateAfterBindStorageBuffers = src->maxDescriptorSetUpdateAfterBindStorageBuffers;
    maxDescriptorSetUpdateAfterBindStorageBuffersDynamic = src->maxDescriptorSetUpdateAfterBindStorageBuffersDynamic;
    maxDescriptorSetUpdateAfterBindSampledImages = src->maxDescriptorSetUpdateAfterBindSampledImages;
    maxDescriptorSetUpdateAfterBindStorageImages = src->maxDescriptorSetUpdateAfterBindStorageImages;
    maxDescriptorSetUpdateAfterBindInputAttachments = src->maxDescriptorSetUpdateAfterBindInputAttachments;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkDescriptorSetVariableDescriptorCountAllocateInfoEXT::safe_VkDescriptorSetVariableDescriptorCountAllocateInfoEXT(const VkDescriptorSetVariableDescriptorCountAllocateInfoEXT* in_struct) :
    sType(in_struct->sType),
    descriptorSetCount(in_struct->descriptorSetCount),
    pDescriptorCounts(nullptr)
{
    pNext = SafePnextCopy(in_struct->pNext);
    if (in_struct->pDescriptorCounts) {
        pDescriptorCounts = new uint32_t[in_struct->descriptorSetCount];
        memcpy ((void *)pDescriptorCounts, (void *)in_struct->pDescriptorCounts, sizeof(uint32_t)*in_struct->descriptorSetCount);
    }
}

safe_VkDescriptorSetVariableDescriptorCountAllocateInfoEXT::safe_VkDescriptorSetVariableDescriptorCountAllocateInfoEXT() :
    pNext(nullptr),
    pDescriptorCounts(nullptr)
{}

safe_VkDescriptorSetVariableDescriptorCountAllocateInfoEXT::safe_VkDescriptorSetVariableDescriptorCountAllocateInfoEXT(const safe_VkDescriptorSetVariableDescriptorCountAllocateInfoEXT& src)
{
    sType = src.sType;
    descriptorSetCount = src.descriptorSetCount;
    pDescriptorCounts = nullptr;
    pNext = SafePnextCopy(src.pNext);
    if (src.pDescriptorCounts) {
        pDescriptorCounts = new uint32_t[src.descriptorSetCount];
        memcpy ((void *)pDescriptorCounts, (void *)src.pDescriptorCounts, sizeof(uint32_t)*src.descriptorSetCount);
    }
}

safe_VkDescriptorSetVariableDescriptorCountAllocateInfoEXT& safe_VkDescriptorSetVariableDescriptorCountAllocateInfoEXT::operator=(const safe_VkDescriptorSetVariableDescriptorCountAllocateInfoEXT& src)
{
    if (&src == this) return *this;

    if (pDescriptorCounts)
        delete[] pDescriptorCounts;
    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    descriptorSetCount = src.descriptorSetCount;
    pDescriptorCounts = nullptr;
    pNext = SafePnextCopy(src.pNext);
    if (src.pDescriptorCounts) {
        pDescriptorCounts = new uint32_t[src.descriptorSetCount];
        memcpy ((void *)pDescriptorCounts, (void *)src.pDescriptorCounts, sizeof(uint32_t)*src.descriptorSetCount);
    }

    return *this;
}

safe_VkDescriptorSetVariableDescriptorCountAllocateInfoEXT::~safe_VkDescriptorSetVariableDescriptorCountAllocateInfoEXT()
{
    if (pDescriptorCounts)
        delete[] pDescriptorCounts;
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkDescriptorSetVariableDescriptorCountAllocateInfoEXT::initialize(const VkDescriptorSetVariableDescriptorCountAllocateInfoEXT* in_struct)
{
    sType = in_struct->sType;
    descriptorSetCount = in_struct->descriptorSetCount;
    pDescriptorCounts = nullptr;
    pNext = SafePnextCopy(in_struct->pNext);
    if (in_struct->pDescriptorCounts) {
        pDescriptorCounts = new uint32_t[in_struct->descriptorSetCount];
        memcpy ((void *)pDescriptorCounts, (void *)in_struct->pDescriptorCounts, sizeof(uint32_t)*in_struct->descriptorSetCount);
    }
}

void safe_VkDescriptorSetVariableDescriptorCountAllocateInfoEXT::initialize(const safe_VkDescriptorSetVariableDescriptorCountAllocateInfoEXT* src)
{
    sType = src->sType;
    descriptorSetCount = src->descriptorSetCount;
    pDescriptorCounts = nullptr;
    pNext = SafePnextCopy(src->pNext);
    if (src->pDescriptorCounts) {
        pDescriptorCounts = new uint32_t[src->descriptorSetCount];
        memcpy ((void *)pDescriptorCounts, (void *)src->pDescriptorCounts, sizeof(uint32_t)*src->descriptorSetCount);
    }
}

safe_VkDescriptorSetVariableDescriptorCountLayoutSupportEXT::safe_VkDescriptorSetVariableDescriptorCountLayoutSupportEXT(const VkDescriptorSetVariableDescriptorCountLayoutSupportEXT* in_struct) :
    sType(in_struct->sType),
    maxVariableDescriptorCount(in_struct->maxVariableDescriptorCount)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkDescriptorSetVariableDescriptorCountLayoutSupportEXT::safe_VkDescriptorSetVariableDescriptorCountLayoutSupportEXT() :
    pNext(nullptr)
{}

safe_VkDescriptorSetVariableDescriptorCountLayoutSupportEXT::safe_VkDescriptorSetVariableDescriptorCountLayoutSupportEXT(const safe_VkDescriptorSetVariableDescriptorCountLayoutSupportEXT& src)
{
    sType = src.sType;
    maxVariableDescriptorCount = src.maxVariableDescriptorCount;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkDescriptorSetVariableDescriptorCountLayoutSupportEXT& safe_VkDescriptorSetVariableDescriptorCountLayoutSupportEXT::operator=(const safe_VkDescriptorSetVariableDescriptorCountLayoutSupportEXT& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    maxVariableDescriptorCount = src.maxVariableDescriptorCount;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkDescriptorSetVariableDescriptorCountLayoutSupportEXT::~safe_VkDescriptorSetVariableDescriptorCountLayoutSupportEXT()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkDescriptorSetVariableDescriptorCountLayoutSupportEXT::initialize(const VkDescriptorSetVariableDescriptorCountLayoutSupportEXT* in_struct)
{
    sType = in_struct->sType;
    maxVariableDescriptorCount = in_struct->maxVariableDescriptorCount;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkDescriptorSetVariableDescriptorCountLayoutSupportEXT::initialize(const safe_VkDescriptorSetVariableDescriptorCountLayoutSupportEXT* src)
{
    sType = src->sType;
    maxVariableDescriptorCount = src->maxVariableDescriptorCount;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkShadingRatePaletteNV::safe_VkShadingRatePaletteNV(const VkShadingRatePaletteNV* in_struct) :
    shadingRatePaletteEntryCount(in_struct->shadingRatePaletteEntryCount),
    pShadingRatePaletteEntries(nullptr)
{
    if (in_struct->pShadingRatePaletteEntries) {
        pShadingRatePaletteEntries = new VkShadingRatePaletteEntryNV[in_struct->shadingRatePaletteEntryCount];
        memcpy ((void *)pShadingRatePaletteEntries, (void *)in_struct->pShadingRatePaletteEntries, sizeof(VkShadingRatePaletteEntryNV)*in_struct->shadingRatePaletteEntryCount);
    }
}

safe_VkShadingRatePaletteNV::safe_VkShadingRatePaletteNV() :
    pShadingRatePaletteEntries(nullptr)
{}

safe_VkShadingRatePaletteNV::safe_VkShadingRatePaletteNV(const safe_VkShadingRatePaletteNV& src)
{
    shadingRatePaletteEntryCount = src.shadingRatePaletteEntryCount;
    pShadingRatePaletteEntries = nullptr;
    if (src.pShadingRatePaletteEntries) {
        pShadingRatePaletteEntries = new VkShadingRatePaletteEntryNV[src.shadingRatePaletteEntryCount];
        memcpy ((void *)pShadingRatePaletteEntries, (void *)src.pShadingRatePaletteEntries, sizeof(VkShadingRatePaletteEntryNV)*src.shadingRatePaletteEntryCount);
    }
}

safe_VkShadingRatePaletteNV& safe_VkShadingRatePaletteNV::operator=(const safe_VkShadingRatePaletteNV& src)
{
    if (&src == this) return *this;

    if (pShadingRatePaletteEntries)
        delete[] pShadingRatePaletteEntries;

    shadingRatePaletteEntryCount = src.shadingRatePaletteEntryCount;
    pShadingRatePaletteEntries = nullptr;
    if (src.pShadingRatePaletteEntries) {
        pShadingRatePaletteEntries = new VkShadingRatePaletteEntryNV[src.shadingRatePaletteEntryCount];
        memcpy ((void *)pShadingRatePaletteEntries, (void *)src.pShadingRatePaletteEntries, sizeof(VkShadingRatePaletteEntryNV)*src.shadingRatePaletteEntryCount);
    }

    return *this;
}

safe_VkShadingRatePaletteNV::~safe_VkShadingRatePaletteNV()
{
    if (pShadingRatePaletteEntries)
        delete[] pShadingRatePaletteEntries;
}

void safe_VkShadingRatePaletteNV::initialize(const VkShadingRatePaletteNV* in_struct)
{
    shadingRatePaletteEntryCount = in_struct->shadingRatePaletteEntryCount;
    pShadingRatePaletteEntries = nullptr;
    if (in_struct->pShadingRatePaletteEntries) {
        pShadingRatePaletteEntries = new VkShadingRatePaletteEntryNV[in_struct->shadingRatePaletteEntryCount];
        memcpy ((void *)pShadingRatePaletteEntries, (void *)in_struct->pShadingRatePaletteEntries, sizeof(VkShadingRatePaletteEntryNV)*in_struct->shadingRatePaletteEntryCount);
    }
}

void safe_VkShadingRatePaletteNV::initialize(const safe_VkShadingRatePaletteNV* src)
{
    shadingRatePaletteEntryCount = src->shadingRatePaletteEntryCount;
    pShadingRatePaletteEntries = nullptr;
    if (src->pShadingRatePaletteEntries) {
        pShadingRatePaletteEntries = new VkShadingRatePaletteEntryNV[src->shadingRatePaletteEntryCount];
        memcpy ((void *)pShadingRatePaletteEntries, (void *)src->pShadingRatePaletteEntries, sizeof(VkShadingRatePaletteEntryNV)*src->shadingRatePaletteEntryCount);
    }
}

safe_VkPipelineViewportShadingRateImageStateCreateInfoNV::safe_VkPipelineViewportShadingRateImageStateCreateInfoNV(const VkPipelineViewportShadingRateImageStateCreateInfoNV* in_struct) :
    sType(in_struct->sType),
    shadingRateImageEnable(in_struct->shadingRateImageEnable),
    viewportCount(in_struct->viewportCount),
    pShadingRatePalettes(nullptr)
{
    pNext = SafePnextCopy(in_struct->pNext);
    if (viewportCount && in_struct->pShadingRatePalettes) {
        pShadingRatePalettes = new safe_VkShadingRatePaletteNV[viewportCount];
        for (uint32_t i = 0; i < viewportCount; ++i) {
            pShadingRatePalettes[i].initialize(&in_struct->pShadingRatePalettes[i]);
        }
    }
}

safe_VkPipelineViewportShadingRateImageStateCreateInfoNV::safe_VkPipelineViewportShadingRateImageStateCreateInfoNV() :
    pNext(nullptr),
    pShadingRatePalettes(nullptr)
{}

safe_VkPipelineViewportShadingRateImageStateCreateInfoNV::safe_VkPipelineViewportShadingRateImageStateCreateInfoNV(const safe_VkPipelineViewportShadingRateImageStateCreateInfoNV& src)
{
    sType = src.sType;
    shadingRateImageEnable = src.shadingRateImageEnable;
    viewportCount = src.viewportCount;
    pShadingRatePalettes = nullptr;
    pNext = SafePnextCopy(src.pNext);
    if (viewportCount && src.pShadingRatePalettes) {
        pShadingRatePalettes = new safe_VkShadingRatePaletteNV[viewportCount];
        for (uint32_t i = 0; i < viewportCount; ++i) {
            pShadingRatePalettes[i].initialize(&src.pShadingRatePalettes[i]);
        }
    }
}

safe_VkPipelineViewportShadingRateImageStateCreateInfoNV& safe_VkPipelineViewportShadingRateImageStateCreateInfoNV::operator=(const safe_VkPipelineViewportShadingRateImageStateCreateInfoNV& src)
{
    if (&src == this) return *this;

    if (pShadingRatePalettes)
        delete[] pShadingRatePalettes;
    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    shadingRateImageEnable = src.shadingRateImageEnable;
    viewportCount = src.viewportCount;
    pShadingRatePalettes = nullptr;
    pNext = SafePnextCopy(src.pNext);
    if (viewportCount && src.pShadingRatePalettes) {
        pShadingRatePalettes = new safe_VkShadingRatePaletteNV[viewportCount];
        for (uint32_t i = 0; i < viewportCount; ++i) {
            pShadingRatePalettes[i].initialize(&src.pShadingRatePalettes[i]);
        }
    }

    return *this;
}

safe_VkPipelineViewportShadingRateImageStateCreateInfoNV::~safe_VkPipelineViewportShadingRateImageStateCreateInfoNV()
{
    if (pShadingRatePalettes)
        delete[] pShadingRatePalettes;
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPipelineViewportShadingRateImageStateCreateInfoNV::initialize(const VkPipelineViewportShadingRateImageStateCreateInfoNV* in_struct)
{
    sType = in_struct->sType;
    shadingRateImageEnable = in_struct->shadingRateImageEnable;
    viewportCount = in_struct->viewportCount;
    pShadingRatePalettes = nullptr;
    pNext = SafePnextCopy(in_struct->pNext);
    if (viewportCount && in_struct->pShadingRatePalettes) {
        pShadingRatePalettes = new safe_VkShadingRatePaletteNV[viewportCount];
        for (uint32_t i = 0; i < viewportCount; ++i) {
            pShadingRatePalettes[i].initialize(&in_struct->pShadingRatePalettes[i]);
        }
    }
}

void safe_VkPipelineViewportShadingRateImageStateCreateInfoNV::initialize(const safe_VkPipelineViewportShadingRateImageStateCreateInfoNV* src)
{
    sType = src->sType;
    shadingRateImageEnable = src->shadingRateImageEnable;
    viewportCount = src->viewportCount;
    pShadingRatePalettes = nullptr;
    pNext = SafePnextCopy(src->pNext);
    if (viewportCount && src->pShadingRatePalettes) {
        pShadingRatePalettes = new safe_VkShadingRatePaletteNV[viewportCount];
        for (uint32_t i = 0; i < viewportCount; ++i) {
            pShadingRatePalettes[i].initialize(&src->pShadingRatePalettes[i]);
        }
    }
}

safe_VkPhysicalDeviceShadingRateImageFeaturesNV::safe_VkPhysicalDeviceShadingRateImageFeaturesNV(const VkPhysicalDeviceShadingRateImageFeaturesNV* in_struct) :
    sType(in_struct->sType),
    shadingRateImage(in_struct->shadingRateImage),
    shadingRateCoarseSampleOrder(in_struct->shadingRateCoarseSampleOrder)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkPhysicalDeviceShadingRateImageFeaturesNV::safe_VkPhysicalDeviceShadingRateImageFeaturesNV() :
    pNext(nullptr)
{}

safe_VkPhysicalDeviceShadingRateImageFeaturesNV::safe_VkPhysicalDeviceShadingRateImageFeaturesNV(const safe_VkPhysicalDeviceShadingRateImageFeaturesNV& src)
{
    sType = src.sType;
    shadingRateImage = src.shadingRateImage;
    shadingRateCoarseSampleOrder = src.shadingRateCoarseSampleOrder;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkPhysicalDeviceShadingRateImageFeaturesNV& safe_VkPhysicalDeviceShadingRateImageFeaturesNV::operator=(const safe_VkPhysicalDeviceShadingRateImageFeaturesNV& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    shadingRateImage = src.shadingRateImage;
    shadingRateCoarseSampleOrder = src.shadingRateCoarseSampleOrder;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkPhysicalDeviceShadingRateImageFeaturesNV::~safe_VkPhysicalDeviceShadingRateImageFeaturesNV()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPhysicalDeviceShadingRateImageFeaturesNV::initialize(const VkPhysicalDeviceShadingRateImageFeaturesNV* in_struct)
{
    sType = in_struct->sType;
    shadingRateImage = in_struct->shadingRateImage;
    shadingRateCoarseSampleOrder = in_struct->shadingRateCoarseSampleOrder;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkPhysicalDeviceShadingRateImageFeaturesNV::initialize(const safe_VkPhysicalDeviceShadingRateImageFeaturesNV* src)
{
    sType = src->sType;
    shadingRateImage = src->shadingRateImage;
    shadingRateCoarseSampleOrder = src->shadingRateCoarseSampleOrder;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkPhysicalDeviceShadingRateImagePropertiesNV::safe_VkPhysicalDeviceShadingRateImagePropertiesNV(const VkPhysicalDeviceShadingRateImagePropertiesNV* in_struct) :
    sType(in_struct->sType),
    shadingRateTexelSize(in_struct->shadingRateTexelSize),
    shadingRatePaletteSize(in_struct->shadingRatePaletteSize),
    shadingRateMaxCoarseSamples(in_struct->shadingRateMaxCoarseSamples)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkPhysicalDeviceShadingRateImagePropertiesNV::safe_VkPhysicalDeviceShadingRateImagePropertiesNV() :
    pNext(nullptr)
{}

safe_VkPhysicalDeviceShadingRateImagePropertiesNV::safe_VkPhysicalDeviceShadingRateImagePropertiesNV(const safe_VkPhysicalDeviceShadingRateImagePropertiesNV& src)
{
    sType = src.sType;
    shadingRateTexelSize = src.shadingRateTexelSize;
    shadingRatePaletteSize = src.shadingRatePaletteSize;
    shadingRateMaxCoarseSamples = src.shadingRateMaxCoarseSamples;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkPhysicalDeviceShadingRateImagePropertiesNV& safe_VkPhysicalDeviceShadingRateImagePropertiesNV::operator=(const safe_VkPhysicalDeviceShadingRateImagePropertiesNV& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    shadingRateTexelSize = src.shadingRateTexelSize;
    shadingRatePaletteSize = src.shadingRatePaletteSize;
    shadingRateMaxCoarseSamples = src.shadingRateMaxCoarseSamples;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkPhysicalDeviceShadingRateImagePropertiesNV::~safe_VkPhysicalDeviceShadingRateImagePropertiesNV()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPhysicalDeviceShadingRateImagePropertiesNV::initialize(const VkPhysicalDeviceShadingRateImagePropertiesNV* in_struct)
{
    sType = in_struct->sType;
    shadingRateTexelSize = in_struct->shadingRateTexelSize;
    shadingRatePaletteSize = in_struct->shadingRatePaletteSize;
    shadingRateMaxCoarseSamples = in_struct->shadingRateMaxCoarseSamples;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkPhysicalDeviceShadingRateImagePropertiesNV::initialize(const safe_VkPhysicalDeviceShadingRateImagePropertiesNV* src)
{
    sType = src->sType;
    shadingRateTexelSize = src->shadingRateTexelSize;
    shadingRatePaletteSize = src->shadingRatePaletteSize;
    shadingRateMaxCoarseSamples = src->shadingRateMaxCoarseSamples;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkCoarseSampleOrderCustomNV::safe_VkCoarseSampleOrderCustomNV(const VkCoarseSampleOrderCustomNV* in_struct) :
    shadingRate(in_struct->shadingRate),
    sampleCount(in_struct->sampleCount),
    sampleLocationCount(in_struct->sampleLocationCount),
    pSampleLocations(nullptr)
{
    if (in_struct->pSampleLocations) {
        pSampleLocations = new VkCoarseSampleLocationNV[in_struct->sampleLocationCount];
        memcpy ((void *)pSampleLocations, (void *)in_struct->pSampleLocations, sizeof(VkCoarseSampleLocationNV)*in_struct->sampleLocationCount);
    }
}

safe_VkCoarseSampleOrderCustomNV::safe_VkCoarseSampleOrderCustomNV() :
    pSampleLocations(nullptr)
{}

safe_VkCoarseSampleOrderCustomNV::safe_VkCoarseSampleOrderCustomNV(const safe_VkCoarseSampleOrderCustomNV& src)
{
    shadingRate = src.shadingRate;
    sampleCount = src.sampleCount;
    sampleLocationCount = src.sampleLocationCount;
    pSampleLocations = nullptr;
    if (src.pSampleLocations) {
        pSampleLocations = new VkCoarseSampleLocationNV[src.sampleLocationCount];
        memcpy ((void *)pSampleLocations, (void *)src.pSampleLocations, sizeof(VkCoarseSampleLocationNV)*src.sampleLocationCount);
    }
}

safe_VkCoarseSampleOrderCustomNV& safe_VkCoarseSampleOrderCustomNV::operator=(const safe_VkCoarseSampleOrderCustomNV& src)
{
    if (&src == this) return *this;

    if (pSampleLocations)
        delete[] pSampleLocations;

    shadingRate = src.shadingRate;
    sampleCount = src.sampleCount;
    sampleLocationCount = src.sampleLocationCount;
    pSampleLocations = nullptr;
    if (src.pSampleLocations) {
        pSampleLocations = new VkCoarseSampleLocationNV[src.sampleLocationCount];
        memcpy ((void *)pSampleLocations, (void *)src.pSampleLocations, sizeof(VkCoarseSampleLocationNV)*src.sampleLocationCount);
    }

    return *this;
}

safe_VkCoarseSampleOrderCustomNV::~safe_VkCoarseSampleOrderCustomNV()
{
    if (pSampleLocations)
        delete[] pSampleLocations;
}

void safe_VkCoarseSampleOrderCustomNV::initialize(const VkCoarseSampleOrderCustomNV* in_struct)
{
    shadingRate = in_struct->shadingRate;
    sampleCount = in_struct->sampleCount;
    sampleLocationCount = in_struct->sampleLocationCount;
    pSampleLocations = nullptr;
    if (in_struct->pSampleLocations) {
        pSampleLocations = new VkCoarseSampleLocationNV[in_struct->sampleLocationCount];
        memcpy ((void *)pSampleLocations, (void *)in_struct->pSampleLocations, sizeof(VkCoarseSampleLocationNV)*in_struct->sampleLocationCount);
    }
}

void safe_VkCoarseSampleOrderCustomNV::initialize(const safe_VkCoarseSampleOrderCustomNV* src)
{
    shadingRate = src->shadingRate;
    sampleCount = src->sampleCount;
    sampleLocationCount = src->sampleLocationCount;
    pSampleLocations = nullptr;
    if (src->pSampleLocations) {
        pSampleLocations = new VkCoarseSampleLocationNV[src->sampleLocationCount];
        memcpy ((void *)pSampleLocations, (void *)src->pSampleLocations, sizeof(VkCoarseSampleLocationNV)*src->sampleLocationCount);
    }
}

safe_VkPipelineViewportCoarseSampleOrderStateCreateInfoNV::safe_VkPipelineViewportCoarseSampleOrderStateCreateInfoNV(const VkPipelineViewportCoarseSampleOrderStateCreateInfoNV* in_struct) :
    sType(in_struct->sType),
    sampleOrderType(in_struct->sampleOrderType),
    customSampleOrderCount(in_struct->customSampleOrderCount),
    pCustomSampleOrders(nullptr)
{
    pNext = SafePnextCopy(in_struct->pNext);
    if (customSampleOrderCount && in_struct->pCustomSampleOrders) {
        pCustomSampleOrders = new safe_VkCoarseSampleOrderCustomNV[customSampleOrderCount];
        for (uint32_t i = 0; i < customSampleOrderCount; ++i) {
            pCustomSampleOrders[i].initialize(&in_struct->pCustomSampleOrders[i]);
        }
    }
}

safe_VkPipelineViewportCoarseSampleOrderStateCreateInfoNV::safe_VkPipelineViewportCoarseSampleOrderStateCreateInfoNV() :
    pNext(nullptr),
    pCustomSampleOrders(nullptr)
{}

safe_VkPipelineViewportCoarseSampleOrderStateCreateInfoNV::safe_VkPipelineViewportCoarseSampleOrderStateCreateInfoNV(const safe_VkPipelineViewportCoarseSampleOrderStateCreateInfoNV& src)
{
    sType = src.sType;
    sampleOrderType = src.sampleOrderType;
    customSampleOrderCount = src.customSampleOrderCount;
    pCustomSampleOrders = nullptr;
    pNext = SafePnextCopy(src.pNext);
    if (customSampleOrderCount && src.pCustomSampleOrders) {
        pCustomSampleOrders = new safe_VkCoarseSampleOrderCustomNV[customSampleOrderCount];
        for (uint32_t i = 0; i < customSampleOrderCount; ++i) {
            pCustomSampleOrders[i].initialize(&src.pCustomSampleOrders[i]);
        }
    }
}

safe_VkPipelineViewportCoarseSampleOrderStateCreateInfoNV& safe_VkPipelineViewportCoarseSampleOrderStateCreateInfoNV::operator=(const safe_VkPipelineViewportCoarseSampleOrderStateCreateInfoNV& src)
{
    if (&src == this) return *this;

    if (pCustomSampleOrders)
        delete[] pCustomSampleOrders;
    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    sampleOrderType = src.sampleOrderType;
    customSampleOrderCount = src.customSampleOrderCount;
    pCustomSampleOrders = nullptr;
    pNext = SafePnextCopy(src.pNext);
    if (customSampleOrderCount && src.pCustomSampleOrders) {
        pCustomSampleOrders = new safe_VkCoarseSampleOrderCustomNV[customSampleOrderCount];
        for (uint32_t i = 0; i < customSampleOrderCount; ++i) {
            pCustomSampleOrders[i].initialize(&src.pCustomSampleOrders[i]);
        }
    }

    return *this;
}

safe_VkPipelineViewportCoarseSampleOrderStateCreateInfoNV::~safe_VkPipelineViewportCoarseSampleOrderStateCreateInfoNV()
{
    if (pCustomSampleOrders)
        delete[] pCustomSampleOrders;
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPipelineViewportCoarseSampleOrderStateCreateInfoNV::initialize(const VkPipelineViewportCoarseSampleOrderStateCreateInfoNV* in_struct)
{
    sType = in_struct->sType;
    sampleOrderType = in_struct->sampleOrderType;
    customSampleOrderCount = in_struct->customSampleOrderCount;
    pCustomSampleOrders = nullptr;
    pNext = SafePnextCopy(in_struct->pNext);
    if (customSampleOrderCount && in_struct->pCustomSampleOrders) {
        pCustomSampleOrders = new safe_VkCoarseSampleOrderCustomNV[customSampleOrderCount];
        for (uint32_t i = 0; i < customSampleOrderCount; ++i) {
            pCustomSampleOrders[i].initialize(&in_struct->pCustomSampleOrders[i]);
        }
    }
}

void safe_VkPipelineViewportCoarseSampleOrderStateCreateInfoNV::initialize(const safe_VkPipelineViewportCoarseSampleOrderStateCreateInfoNV* src)
{
    sType = src->sType;
    sampleOrderType = src->sampleOrderType;
    customSampleOrderCount = src->customSampleOrderCount;
    pCustomSampleOrders = nullptr;
    pNext = SafePnextCopy(src->pNext);
    if (customSampleOrderCount && src->pCustomSampleOrders) {
        pCustomSampleOrders = new safe_VkCoarseSampleOrderCustomNV[customSampleOrderCount];
        for (uint32_t i = 0; i < customSampleOrderCount; ++i) {
            pCustomSampleOrders[i].initialize(&src->pCustomSampleOrders[i]);
        }
    }
}

safe_VkRayTracingShaderGroupCreateInfoNV::safe_VkRayTracingShaderGroupCreateInfoNV(const VkRayTracingShaderGroupCreateInfoNV* in_struct) :
    sType(in_struct->sType),
    type(in_struct->type),
    generalShader(in_struct->generalShader),
    closestHitShader(in_struct->closestHitShader),
    anyHitShader(in_struct->anyHitShader),
    intersectionShader(in_struct->intersectionShader)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkRayTracingShaderGroupCreateInfoNV::safe_VkRayTracingShaderGroupCreateInfoNV() :
    pNext(nullptr)
{}

safe_VkRayTracingShaderGroupCreateInfoNV::safe_VkRayTracingShaderGroupCreateInfoNV(const safe_VkRayTracingShaderGroupCreateInfoNV& src)
{
    sType = src.sType;
    type = src.type;
    generalShader = src.generalShader;
    closestHitShader = src.closestHitShader;
    anyHitShader = src.anyHitShader;
    intersectionShader = src.intersectionShader;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkRayTracingShaderGroupCreateInfoNV& safe_VkRayTracingShaderGroupCreateInfoNV::operator=(const safe_VkRayTracingShaderGroupCreateInfoNV& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    type = src.type;
    generalShader = src.generalShader;
    closestHitShader = src.closestHitShader;
    anyHitShader = src.anyHitShader;
    intersectionShader = src.intersectionShader;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkRayTracingShaderGroupCreateInfoNV::~safe_VkRayTracingShaderGroupCreateInfoNV()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkRayTracingShaderGroupCreateInfoNV::initialize(const VkRayTracingShaderGroupCreateInfoNV* in_struct)
{
    sType = in_struct->sType;
    type = in_struct->type;
    generalShader = in_struct->generalShader;
    closestHitShader = in_struct->closestHitShader;
    anyHitShader = in_struct->anyHitShader;
    intersectionShader = in_struct->intersectionShader;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkRayTracingShaderGroupCreateInfoNV::initialize(const safe_VkRayTracingShaderGroupCreateInfoNV* src)
{
    sType = src->sType;
    type = src->type;
    generalShader = src->generalShader;
    closestHitShader = src->closestHitShader;
    anyHitShader = src->anyHitShader;
    intersectionShader = src->intersectionShader;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkRayTracingPipelineCreateInfoNV::safe_VkRayTracingPipelineCreateInfoNV(const VkRayTracingPipelineCreateInfoNV* in_struct) :
    sType(in_struct->sType),
    flags(in_struct->flags),
    stageCount(in_struct->stageCount),
    pStages(nullptr),
    groupCount(in_struct->groupCount),
    pGroups(nullptr),
    maxRecursionDepth(in_struct->maxRecursionDepth),
    layout(in_struct->layout),
    basePipelineHandle(in_struct->basePipelineHandle),
    basePipelineIndex(in_struct->basePipelineIndex)
{
    pNext = SafePnextCopy(in_struct->pNext);
    if (stageCount && in_struct->pStages) {
        pStages = new safe_VkPipelineShaderStageCreateInfo[stageCount];
        for (uint32_t i = 0; i < stageCount; ++i) {
            pStages[i].initialize(&in_struct->pStages[i]);
        }
    }
    if (groupCount && in_struct->pGroups) {
        pGroups = new safe_VkRayTracingShaderGroupCreateInfoNV[groupCount];
        for (uint32_t i = 0; i < groupCount; ++i) {
            pGroups[i].initialize(&in_struct->pGroups[i]);
        }
    }
}

safe_VkRayTracingPipelineCreateInfoNV::safe_VkRayTracingPipelineCreateInfoNV() :
    pNext(nullptr),
    pStages(nullptr),
    pGroups(nullptr)
{}

safe_VkRayTracingPipelineCreateInfoNV::safe_VkRayTracingPipelineCreateInfoNV(const safe_VkRayTracingPipelineCreateInfoNV& src)
{
    sType = src.sType;
    flags = src.flags;
    stageCount = src.stageCount;
    pStages = nullptr;
    groupCount = src.groupCount;
    pGroups = nullptr;
    maxRecursionDepth = src.maxRecursionDepth;
    layout = src.layout;
    basePipelineHandle = src.basePipelineHandle;
    basePipelineIndex = src.basePipelineIndex;
    pNext = SafePnextCopy(src.pNext);
    if (stageCount && src.pStages) {
        pStages = new safe_VkPipelineShaderStageCreateInfo[stageCount];
        for (uint32_t i = 0; i < stageCount; ++i) {
            pStages[i].initialize(&src.pStages[i]);
        }
    }
    if (groupCount && src.pGroups) {
        pGroups = new safe_VkRayTracingShaderGroupCreateInfoNV[groupCount];
        for (uint32_t i = 0; i < groupCount; ++i) {
            pGroups[i].initialize(&src.pGroups[i]);
        }
    }
}

safe_VkRayTracingPipelineCreateInfoNV& safe_VkRayTracingPipelineCreateInfoNV::operator=(const safe_VkRayTracingPipelineCreateInfoNV& src)
{
    if (&src == this) return *this;

    if (pStages)
        delete[] pStages;
    if (pGroups)
        delete[] pGroups;
    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    flags = src.flags;
    stageCount = src.stageCount;
    pStages = nullptr;
    groupCount = src.groupCount;
    pGroups = nullptr;
    maxRecursionDepth = src.maxRecursionDepth;
    layout = src.layout;
    basePipelineHandle = src.basePipelineHandle;
    basePipelineIndex = src.basePipelineIndex;
    pNext = SafePnextCopy(src.pNext);
    if (stageCount && src.pStages) {
        pStages = new safe_VkPipelineShaderStageCreateInfo[stageCount];
        for (uint32_t i = 0; i < stageCount; ++i) {
            pStages[i].initialize(&src.pStages[i]);
        }
    }
    if (groupCount && src.pGroups) {
        pGroups = new safe_VkRayTracingShaderGroupCreateInfoNV[groupCount];
        for (uint32_t i = 0; i < groupCount; ++i) {
            pGroups[i].initialize(&src.pGroups[i]);
        }
    }

    return *this;
}

safe_VkRayTracingPipelineCreateInfoNV::~safe_VkRayTracingPipelineCreateInfoNV()
{
    if (pStages)
        delete[] pStages;
    if (pGroups)
        delete[] pGroups;
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkRayTracingPipelineCreateInfoNV::initialize(const VkRayTracingPipelineCreateInfoNV* in_struct)
{
    sType = in_struct->sType;
    flags = in_struct->flags;
    stageCount = in_struct->stageCount;
    pStages = nullptr;
    groupCount = in_struct->groupCount;
    pGroups = nullptr;
    maxRecursionDepth = in_struct->maxRecursionDepth;
    layout = in_struct->layout;
    basePipelineHandle = in_struct->basePipelineHandle;
    basePipelineIndex = in_struct->basePipelineIndex;
    pNext = SafePnextCopy(in_struct->pNext);
    if (stageCount && in_struct->pStages) {
        pStages = new safe_VkPipelineShaderStageCreateInfo[stageCount];
        for (uint32_t i = 0; i < stageCount; ++i) {
            pStages[i].initialize(&in_struct->pStages[i]);
        }
    }
    if (groupCount && in_struct->pGroups) {
        pGroups = new safe_VkRayTracingShaderGroupCreateInfoNV[groupCount];
        for (uint32_t i = 0; i < groupCount; ++i) {
            pGroups[i].initialize(&in_struct->pGroups[i]);
        }
    }
}

void safe_VkRayTracingPipelineCreateInfoNV::initialize(const safe_VkRayTracingPipelineCreateInfoNV* src)
{
    sType = src->sType;
    flags = src->flags;
    stageCount = src->stageCount;
    pStages = nullptr;
    groupCount = src->groupCount;
    pGroups = nullptr;
    maxRecursionDepth = src->maxRecursionDepth;
    layout = src->layout;
    basePipelineHandle = src->basePipelineHandle;
    basePipelineIndex = src->basePipelineIndex;
    pNext = SafePnextCopy(src->pNext);
    if (stageCount && src->pStages) {
        pStages = new safe_VkPipelineShaderStageCreateInfo[stageCount];
        for (uint32_t i = 0; i < stageCount; ++i) {
            pStages[i].initialize(&src->pStages[i]);
        }
    }
    if (groupCount && src->pGroups) {
        pGroups = new safe_VkRayTracingShaderGroupCreateInfoNV[groupCount];
        for (uint32_t i = 0; i < groupCount; ++i) {
            pGroups[i].initialize(&src->pGroups[i]);
        }
    }
}

safe_VkGeometryTrianglesNV::safe_VkGeometryTrianglesNV(const VkGeometryTrianglesNV* in_struct) :
    sType(in_struct->sType),
    vertexData(in_struct->vertexData),
    vertexOffset(in_struct->vertexOffset),
    vertexCount(in_struct->vertexCount),
    vertexStride(in_struct->vertexStride),
    vertexFormat(in_struct->vertexFormat),
    indexData(in_struct->indexData),
    indexOffset(in_struct->indexOffset),
    indexCount(in_struct->indexCount),
    indexType(in_struct->indexType),
    transformData(in_struct->transformData),
    transformOffset(in_struct->transformOffset)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkGeometryTrianglesNV::safe_VkGeometryTrianglesNV() :
    pNext(nullptr)
{}

safe_VkGeometryTrianglesNV::safe_VkGeometryTrianglesNV(const safe_VkGeometryTrianglesNV& src)
{
    sType = src.sType;
    vertexData = src.vertexData;
    vertexOffset = src.vertexOffset;
    vertexCount = src.vertexCount;
    vertexStride = src.vertexStride;
    vertexFormat = src.vertexFormat;
    indexData = src.indexData;
    indexOffset = src.indexOffset;
    indexCount = src.indexCount;
    indexType = src.indexType;
    transformData = src.transformData;
    transformOffset = src.transformOffset;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkGeometryTrianglesNV& safe_VkGeometryTrianglesNV::operator=(const safe_VkGeometryTrianglesNV& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    vertexData = src.vertexData;
    vertexOffset = src.vertexOffset;
    vertexCount = src.vertexCount;
    vertexStride = src.vertexStride;
    vertexFormat = src.vertexFormat;
    indexData = src.indexData;
    indexOffset = src.indexOffset;
    indexCount = src.indexCount;
    indexType = src.indexType;
    transformData = src.transformData;
    transformOffset = src.transformOffset;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkGeometryTrianglesNV::~safe_VkGeometryTrianglesNV()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkGeometryTrianglesNV::initialize(const VkGeometryTrianglesNV* in_struct)
{
    sType = in_struct->sType;
    vertexData = in_struct->vertexData;
    vertexOffset = in_struct->vertexOffset;
    vertexCount = in_struct->vertexCount;
    vertexStride = in_struct->vertexStride;
    vertexFormat = in_struct->vertexFormat;
    indexData = in_struct->indexData;
    indexOffset = in_struct->indexOffset;
    indexCount = in_struct->indexCount;
    indexType = in_struct->indexType;
    transformData = in_struct->transformData;
    transformOffset = in_struct->transformOffset;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkGeometryTrianglesNV::initialize(const safe_VkGeometryTrianglesNV* src)
{
    sType = src->sType;
    vertexData = src->vertexData;
    vertexOffset = src->vertexOffset;
    vertexCount = src->vertexCount;
    vertexStride = src->vertexStride;
    vertexFormat = src->vertexFormat;
    indexData = src->indexData;
    indexOffset = src->indexOffset;
    indexCount = src->indexCount;
    indexType = src->indexType;
    transformData = src->transformData;
    transformOffset = src->transformOffset;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkGeometryAABBNV::safe_VkGeometryAABBNV(const VkGeometryAABBNV* in_struct) :
    sType(in_struct->sType),
    aabbData(in_struct->aabbData),
    numAABBs(in_struct->numAABBs),
    stride(in_struct->stride),
    offset(in_struct->offset)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkGeometryAABBNV::safe_VkGeometryAABBNV() :
    pNext(nullptr)
{}

safe_VkGeometryAABBNV::safe_VkGeometryAABBNV(const safe_VkGeometryAABBNV& src)
{
    sType = src.sType;
    aabbData = src.aabbData;
    numAABBs = src.numAABBs;
    stride = src.stride;
    offset = src.offset;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkGeometryAABBNV& safe_VkGeometryAABBNV::operator=(const safe_VkGeometryAABBNV& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    aabbData = src.aabbData;
    numAABBs = src.numAABBs;
    stride = src.stride;
    offset = src.offset;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkGeometryAABBNV::~safe_VkGeometryAABBNV()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkGeometryAABBNV::initialize(const VkGeometryAABBNV* in_struct)
{
    sType = in_struct->sType;
    aabbData = in_struct->aabbData;
    numAABBs = in_struct->numAABBs;
    stride = in_struct->stride;
    offset = in_struct->offset;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkGeometryAABBNV::initialize(const safe_VkGeometryAABBNV* src)
{
    sType = src->sType;
    aabbData = src->aabbData;
    numAABBs = src->numAABBs;
    stride = src->stride;
    offset = src->offset;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkGeometryNV::safe_VkGeometryNV(const VkGeometryNV* in_struct) :
    sType(in_struct->sType),
    geometryType(in_struct->geometryType),
    geometry(in_struct->geometry),
    flags(in_struct->flags)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkGeometryNV::safe_VkGeometryNV() :
    pNext(nullptr)
{}

safe_VkGeometryNV::safe_VkGeometryNV(const safe_VkGeometryNV& src)
{
    sType = src.sType;
    geometryType = src.geometryType;
    geometry = src.geometry;
    flags = src.flags;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkGeometryNV& safe_VkGeometryNV::operator=(const safe_VkGeometryNV& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    geometryType = src.geometryType;
    geometry = src.geometry;
    flags = src.flags;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkGeometryNV::~safe_VkGeometryNV()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkGeometryNV::initialize(const VkGeometryNV* in_struct)
{
    sType = in_struct->sType;
    geometryType = in_struct->geometryType;
    geometry = in_struct->geometry;
    flags = in_struct->flags;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkGeometryNV::initialize(const safe_VkGeometryNV* src)
{
    sType = src->sType;
    geometryType = src->geometryType;
    geometry = src->geometry;
    flags = src->flags;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkAccelerationStructureInfoNV::safe_VkAccelerationStructureInfoNV(const VkAccelerationStructureInfoNV* in_struct) :
    sType(in_struct->sType),
    type(in_struct->type),
    flags(in_struct->flags),
    instanceCount(in_struct->instanceCount),
    geometryCount(in_struct->geometryCount),
    pGeometries(nullptr)
{
    pNext = SafePnextCopy(in_struct->pNext);
    if (geometryCount && in_struct->pGeometries) {
        pGeometries = new safe_VkGeometryNV[geometryCount];
        for (uint32_t i = 0; i < geometryCount; ++i) {
            pGeometries[i].initialize(&in_struct->pGeometries[i]);
        }
    }
}

safe_VkAccelerationStructureInfoNV::safe_VkAccelerationStructureInfoNV() :
    pNext(nullptr),
    pGeometries(nullptr)
{}

safe_VkAccelerationStructureInfoNV::safe_VkAccelerationStructureInfoNV(const safe_VkAccelerationStructureInfoNV& src)
{
    sType = src.sType;
    type = src.type;
    flags = src.flags;
    instanceCount = src.instanceCount;
    geometryCount = src.geometryCount;
    pGeometries = nullptr;
    pNext = SafePnextCopy(src.pNext);
    if (geometryCount && src.pGeometries) {
        pGeometries = new safe_VkGeometryNV[geometryCount];
        for (uint32_t i = 0; i < geometryCount; ++i) {
            pGeometries[i].initialize(&src.pGeometries[i]);
        }
    }
}

safe_VkAccelerationStructureInfoNV& safe_VkAccelerationStructureInfoNV::operator=(const safe_VkAccelerationStructureInfoNV& src)
{
    if (&src == this) return *this;

    if (pGeometries)
        delete[] pGeometries;
    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    type = src.type;
    flags = src.flags;
    instanceCount = src.instanceCount;
    geometryCount = src.geometryCount;
    pGeometries = nullptr;
    pNext = SafePnextCopy(src.pNext);
    if (geometryCount && src.pGeometries) {
        pGeometries = new safe_VkGeometryNV[geometryCount];
        for (uint32_t i = 0; i < geometryCount; ++i) {
            pGeometries[i].initialize(&src.pGeometries[i]);
        }
    }

    return *this;
}

safe_VkAccelerationStructureInfoNV::~safe_VkAccelerationStructureInfoNV()
{
    if (pGeometries)
        delete[] pGeometries;
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkAccelerationStructureInfoNV::initialize(const VkAccelerationStructureInfoNV* in_struct)
{
    sType = in_struct->sType;
    type = in_struct->type;
    flags = in_struct->flags;
    instanceCount = in_struct->instanceCount;
    geometryCount = in_struct->geometryCount;
    pGeometries = nullptr;
    pNext = SafePnextCopy(in_struct->pNext);
    if (geometryCount && in_struct->pGeometries) {
        pGeometries = new safe_VkGeometryNV[geometryCount];
        for (uint32_t i = 0; i < geometryCount; ++i) {
            pGeometries[i].initialize(&in_struct->pGeometries[i]);
        }
    }
}

void safe_VkAccelerationStructureInfoNV::initialize(const safe_VkAccelerationStructureInfoNV* src)
{
    sType = src->sType;
    type = src->type;
    flags = src->flags;
    instanceCount = src->instanceCount;
    geometryCount = src->geometryCount;
    pGeometries = nullptr;
    pNext = SafePnextCopy(src->pNext);
    if (geometryCount && src->pGeometries) {
        pGeometries = new safe_VkGeometryNV[geometryCount];
        for (uint32_t i = 0; i < geometryCount; ++i) {
            pGeometries[i].initialize(&src->pGeometries[i]);
        }
    }
}

safe_VkAccelerationStructureCreateInfoNV::safe_VkAccelerationStructureCreateInfoNV(const VkAccelerationStructureCreateInfoNV* in_struct) :
    sType(in_struct->sType),
    compactedSize(in_struct->compactedSize),
    info(&in_struct->info)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkAccelerationStructureCreateInfoNV::safe_VkAccelerationStructureCreateInfoNV() :
    pNext(nullptr)
{}

safe_VkAccelerationStructureCreateInfoNV::safe_VkAccelerationStructureCreateInfoNV(const safe_VkAccelerationStructureCreateInfoNV& src)
{
    sType = src.sType;
    compactedSize = src.compactedSize;
    info.initialize(&src.info);
    pNext = SafePnextCopy(src.pNext);
}

safe_VkAccelerationStructureCreateInfoNV& safe_VkAccelerationStructureCreateInfoNV::operator=(const safe_VkAccelerationStructureCreateInfoNV& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    compactedSize = src.compactedSize;
    info.initialize(&src.info);
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkAccelerationStructureCreateInfoNV::~safe_VkAccelerationStructureCreateInfoNV()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkAccelerationStructureCreateInfoNV::initialize(const VkAccelerationStructureCreateInfoNV* in_struct)
{
    sType = in_struct->sType;
    compactedSize = in_struct->compactedSize;
    info.initialize(&in_struct->info);
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkAccelerationStructureCreateInfoNV::initialize(const safe_VkAccelerationStructureCreateInfoNV* src)
{
    sType = src->sType;
    compactedSize = src->compactedSize;
    info.initialize(&src->info);
    pNext = SafePnextCopy(src->pNext);
}

safe_VkBindAccelerationStructureMemoryInfoNV::safe_VkBindAccelerationStructureMemoryInfoNV(const VkBindAccelerationStructureMemoryInfoNV* in_struct) :
    sType(in_struct->sType),
    accelerationStructure(in_struct->accelerationStructure),
    memory(in_struct->memory),
    memoryOffset(in_struct->memoryOffset),
    deviceIndexCount(in_struct->deviceIndexCount),
    pDeviceIndices(nullptr)
{
    pNext = SafePnextCopy(in_struct->pNext);
    if (in_struct->pDeviceIndices) {
        pDeviceIndices = new uint32_t[in_struct->deviceIndexCount];
        memcpy ((void *)pDeviceIndices, (void *)in_struct->pDeviceIndices, sizeof(uint32_t)*in_struct->deviceIndexCount);
    }
}

safe_VkBindAccelerationStructureMemoryInfoNV::safe_VkBindAccelerationStructureMemoryInfoNV() :
    pNext(nullptr),
    pDeviceIndices(nullptr)
{}

safe_VkBindAccelerationStructureMemoryInfoNV::safe_VkBindAccelerationStructureMemoryInfoNV(const safe_VkBindAccelerationStructureMemoryInfoNV& src)
{
    sType = src.sType;
    accelerationStructure = src.accelerationStructure;
    memory = src.memory;
    memoryOffset = src.memoryOffset;
    deviceIndexCount = src.deviceIndexCount;
    pDeviceIndices = nullptr;
    pNext = SafePnextCopy(src.pNext);
    if (src.pDeviceIndices) {
        pDeviceIndices = new uint32_t[src.deviceIndexCount];
        memcpy ((void *)pDeviceIndices, (void *)src.pDeviceIndices, sizeof(uint32_t)*src.deviceIndexCount);
    }
}

safe_VkBindAccelerationStructureMemoryInfoNV& safe_VkBindAccelerationStructureMemoryInfoNV::operator=(const safe_VkBindAccelerationStructureMemoryInfoNV& src)
{
    if (&src == this) return *this;

    if (pDeviceIndices)
        delete[] pDeviceIndices;
    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    accelerationStructure = src.accelerationStructure;
    memory = src.memory;
    memoryOffset = src.memoryOffset;
    deviceIndexCount = src.deviceIndexCount;
    pDeviceIndices = nullptr;
    pNext = SafePnextCopy(src.pNext);
    if (src.pDeviceIndices) {
        pDeviceIndices = new uint32_t[src.deviceIndexCount];
        memcpy ((void *)pDeviceIndices, (void *)src.pDeviceIndices, sizeof(uint32_t)*src.deviceIndexCount);
    }

    return *this;
}

safe_VkBindAccelerationStructureMemoryInfoNV::~safe_VkBindAccelerationStructureMemoryInfoNV()
{
    if (pDeviceIndices)
        delete[] pDeviceIndices;
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkBindAccelerationStructureMemoryInfoNV::initialize(const VkBindAccelerationStructureMemoryInfoNV* in_struct)
{
    sType = in_struct->sType;
    accelerationStructure = in_struct->accelerationStructure;
    memory = in_struct->memory;
    memoryOffset = in_struct->memoryOffset;
    deviceIndexCount = in_struct->deviceIndexCount;
    pDeviceIndices = nullptr;
    pNext = SafePnextCopy(in_struct->pNext);
    if (in_struct->pDeviceIndices) {
        pDeviceIndices = new uint32_t[in_struct->deviceIndexCount];
        memcpy ((void *)pDeviceIndices, (void *)in_struct->pDeviceIndices, sizeof(uint32_t)*in_struct->deviceIndexCount);
    }
}

void safe_VkBindAccelerationStructureMemoryInfoNV::initialize(const safe_VkBindAccelerationStructureMemoryInfoNV* src)
{
    sType = src->sType;
    accelerationStructure = src->accelerationStructure;
    memory = src->memory;
    memoryOffset = src->memoryOffset;
    deviceIndexCount = src->deviceIndexCount;
    pDeviceIndices = nullptr;
    pNext = SafePnextCopy(src->pNext);
    if (src->pDeviceIndices) {
        pDeviceIndices = new uint32_t[src->deviceIndexCount];
        memcpy ((void *)pDeviceIndices, (void *)src->pDeviceIndices, sizeof(uint32_t)*src->deviceIndexCount);
    }
}

safe_VkWriteDescriptorSetAccelerationStructureNV::safe_VkWriteDescriptorSetAccelerationStructureNV(const VkWriteDescriptorSetAccelerationStructureNV* in_struct) :
    sType(in_struct->sType),
    accelerationStructureCount(in_struct->accelerationStructureCount),
    pAccelerationStructures(nullptr)
{
    pNext = SafePnextCopy(in_struct->pNext);
    if (accelerationStructureCount && in_struct->pAccelerationStructures) {
        pAccelerationStructures = new VkAccelerationStructureNV[accelerationStructureCount];
        for (uint32_t i = 0; i < accelerationStructureCount; ++i) {
            pAccelerationStructures[i] = in_struct->pAccelerationStructures[i];
        }
    }
}

safe_VkWriteDescriptorSetAccelerationStructureNV::safe_VkWriteDescriptorSetAccelerationStructureNV() :
    pNext(nullptr),
    pAccelerationStructures(nullptr)
{}

safe_VkWriteDescriptorSetAccelerationStructureNV::safe_VkWriteDescriptorSetAccelerationStructureNV(const safe_VkWriteDescriptorSetAccelerationStructureNV& src)
{
    sType = src.sType;
    accelerationStructureCount = src.accelerationStructureCount;
    pAccelerationStructures = nullptr;
    pNext = SafePnextCopy(src.pNext);
    if (accelerationStructureCount && src.pAccelerationStructures) {
        pAccelerationStructures = new VkAccelerationStructureNV[accelerationStructureCount];
        for (uint32_t i = 0; i < accelerationStructureCount; ++i) {
            pAccelerationStructures[i] = src.pAccelerationStructures[i];
        }
    }
}

safe_VkWriteDescriptorSetAccelerationStructureNV& safe_VkWriteDescriptorSetAccelerationStructureNV::operator=(const safe_VkWriteDescriptorSetAccelerationStructureNV& src)
{
    if (&src == this) return *this;

    if (pAccelerationStructures)
        delete[] pAccelerationStructures;
    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    accelerationStructureCount = src.accelerationStructureCount;
    pAccelerationStructures = nullptr;
    pNext = SafePnextCopy(src.pNext);
    if (accelerationStructureCount && src.pAccelerationStructures) {
        pAccelerationStructures = new VkAccelerationStructureNV[accelerationStructureCount];
        for (uint32_t i = 0; i < accelerationStructureCount; ++i) {
            pAccelerationStructures[i] = src.pAccelerationStructures[i];
        }
    }

    return *this;
}

safe_VkWriteDescriptorSetAccelerationStructureNV::~safe_VkWriteDescriptorSetAccelerationStructureNV()
{
    if (pAccelerationStructures)
        delete[] pAccelerationStructures;
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkWriteDescriptorSetAccelerationStructureNV::initialize(const VkWriteDescriptorSetAccelerationStructureNV* in_struct)
{
    sType = in_struct->sType;
    accelerationStructureCount = in_struct->accelerationStructureCount;
    pAccelerationStructures = nullptr;
    pNext = SafePnextCopy(in_struct->pNext);
    if (accelerationStructureCount && in_struct->pAccelerationStructures) {
        pAccelerationStructures = new VkAccelerationStructureNV[accelerationStructureCount];
        for (uint32_t i = 0; i < accelerationStructureCount; ++i) {
            pAccelerationStructures[i] = in_struct->pAccelerationStructures[i];
        }
    }
}

void safe_VkWriteDescriptorSetAccelerationStructureNV::initialize(const safe_VkWriteDescriptorSetAccelerationStructureNV* src)
{
    sType = src->sType;
    accelerationStructureCount = src->accelerationStructureCount;
    pAccelerationStructures = nullptr;
    pNext = SafePnextCopy(src->pNext);
    if (accelerationStructureCount && src->pAccelerationStructures) {
        pAccelerationStructures = new VkAccelerationStructureNV[accelerationStructureCount];
        for (uint32_t i = 0; i < accelerationStructureCount; ++i) {
            pAccelerationStructures[i] = src->pAccelerationStructures[i];
        }
    }
}

safe_VkAccelerationStructureMemoryRequirementsInfoNV::safe_VkAccelerationStructureMemoryRequirementsInfoNV(const VkAccelerationStructureMemoryRequirementsInfoNV* in_struct) :
    sType(in_struct->sType),
    type(in_struct->type),
    accelerationStructure(in_struct->accelerationStructure)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkAccelerationStructureMemoryRequirementsInfoNV::safe_VkAccelerationStructureMemoryRequirementsInfoNV() :
    pNext(nullptr)
{}

safe_VkAccelerationStructureMemoryRequirementsInfoNV::safe_VkAccelerationStructureMemoryRequirementsInfoNV(const safe_VkAccelerationStructureMemoryRequirementsInfoNV& src)
{
    sType = src.sType;
    type = src.type;
    accelerationStructure = src.accelerationStructure;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkAccelerationStructureMemoryRequirementsInfoNV& safe_VkAccelerationStructureMemoryRequirementsInfoNV::operator=(const safe_VkAccelerationStructureMemoryRequirementsInfoNV& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    type = src.type;
    accelerationStructure = src.accelerationStructure;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkAccelerationStructureMemoryRequirementsInfoNV::~safe_VkAccelerationStructureMemoryRequirementsInfoNV()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkAccelerationStructureMemoryRequirementsInfoNV::initialize(const VkAccelerationStructureMemoryRequirementsInfoNV* in_struct)
{
    sType = in_struct->sType;
    type = in_struct->type;
    accelerationStructure = in_struct->accelerationStructure;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkAccelerationStructureMemoryRequirementsInfoNV::initialize(const safe_VkAccelerationStructureMemoryRequirementsInfoNV* src)
{
    sType = src->sType;
    type = src->type;
    accelerationStructure = src->accelerationStructure;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkPhysicalDeviceRayTracingPropertiesNV::safe_VkPhysicalDeviceRayTracingPropertiesNV(const VkPhysicalDeviceRayTracingPropertiesNV* in_struct) :
    sType(in_struct->sType),
    shaderGroupHandleSize(in_struct->shaderGroupHandleSize),
    maxRecursionDepth(in_struct->maxRecursionDepth),
    maxShaderGroupStride(in_struct->maxShaderGroupStride),
    shaderGroupBaseAlignment(in_struct->shaderGroupBaseAlignment),
    maxGeometryCount(in_struct->maxGeometryCount),
    maxInstanceCount(in_struct->maxInstanceCount),
    maxTriangleCount(in_struct->maxTriangleCount),
    maxDescriptorSetAccelerationStructures(in_struct->maxDescriptorSetAccelerationStructures)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkPhysicalDeviceRayTracingPropertiesNV::safe_VkPhysicalDeviceRayTracingPropertiesNV() :
    pNext(nullptr)
{}

safe_VkPhysicalDeviceRayTracingPropertiesNV::safe_VkPhysicalDeviceRayTracingPropertiesNV(const safe_VkPhysicalDeviceRayTracingPropertiesNV& src)
{
    sType = src.sType;
    shaderGroupHandleSize = src.shaderGroupHandleSize;
    maxRecursionDepth = src.maxRecursionDepth;
    maxShaderGroupStride = src.maxShaderGroupStride;
    shaderGroupBaseAlignment = src.shaderGroupBaseAlignment;
    maxGeometryCount = src.maxGeometryCount;
    maxInstanceCount = src.maxInstanceCount;
    maxTriangleCount = src.maxTriangleCount;
    maxDescriptorSetAccelerationStructures = src.maxDescriptorSetAccelerationStructures;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkPhysicalDeviceRayTracingPropertiesNV& safe_VkPhysicalDeviceRayTracingPropertiesNV::operator=(const safe_VkPhysicalDeviceRayTracingPropertiesNV& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    shaderGroupHandleSize = src.shaderGroupHandleSize;
    maxRecursionDepth = src.maxRecursionDepth;
    maxShaderGroupStride = src.maxShaderGroupStride;
    shaderGroupBaseAlignment = src.shaderGroupBaseAlignment;
    maxGeometryCount = src.maxGeometryCount;
    maxInstanceCount = src.maxInstanceCount;
    maxTriangleCount = src.maxTriangleCount;
    maxDescriptorSetAccelerationStructures = src.maxDescriptorSetAccelerationStructures;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkPhysicalDeviceRayTracingPropertiesNV::~safe_VkPhysicalDeviceRayTracingPropertiesNV()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPhysicalDeviceRayTracingPropertiesNV::initialize(const VkPhysicalDeviceRayTracingPropertiesNV* in_struct)
{
    sType = in_struct->sType;
    shaderGroupHandleSize = in_struct->shaderGroupHandleSize;
    maxRecursionDepth = in_struct->maxRecursionDepth;
    maxShaderGroupStride = in_struct->maxShaderGroupStride;
    shaderGroupBaseAlignment = in_struct->shaderGroupBaseAlignment;
    maxGeometryCount = in_struct->maxGeometryCount;
    maxInstanceCount = in_struct->maxInstanceCount;
    maxTriangleCount = in_struct->maxTriangleCount;
    maxDescriptorSetAccelerationStructures = in_struct->maxDescriptorSetAccelerationStructures;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkPhysicalDeviceRayTracingPropertiesNV::initialize(const safe_VkPhysicalDeviceRayTracingPropertiesNV* src)
{
    sType = src->sType;
    shaderGroupHandleSize = src->shaderGroupHandleSize;
    maxRecursionDepth = src->maxRecursionDepth;
    maxShaderGroupStride = src->maxShaderGroupStride;
    shaderGroupBaseAlignment = src->shaderGroupBaseAlignment;
    maxGeometryCount = src->maxGeometryCount;
    maxInstanceCount = src->maxInstanceCount;
    maxTriangleCount = src->maxTriangleCount;
    maxDescriptorSetAccelerationStructures = src->maxDescriptorSetAccelerationStructures;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkPhysicalDeviceRepresentativeFragmentTestFeaturesNV::safe_VkPhysicalDeviceRepresentativeFragmentTestFeaturesNV(const VkPhysicalDeviceRepresentativeFragmentTestFeaturesNV* in_struct) :
    sType(in_struct->sType),
    representativeFragmentTest(in_struct->representativeFragmentTest)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkPhysicalDeviceRepresentativeFragmentTestFeaturesNV::safe_VkPhysicalDeviceRepresentativeFragmentTestFeaturesNV() :
    pNext(nullptr)
{}

safe_VkPhysicalDeviceRepresentativeFragmentTestFeaturesNV::safe_VkPhysicalDeviceRepresentativeFragmentTestFeaturesNV(const safe_VkPhysicalDeviceRepresentativeFragmentTestFeaturesNV& src)
{
    sType = src.sType;
    representativeFragmentTest = src.representativeFragmentTest;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkPhysicalDeviceRepresentativeFragmentTestFeaturesNV& safe_VkPhysicalDeviceRepresentativeFragmentTestFeaturesNV::operator=(const safe_VkPhysicalDeviceRepresentativeFragmentTestFeaturesNV& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    representativeFragmentTest = src.representativeFragmentTest;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkPhysicalDeviceRepresentativeFragmentTestFeaturesNV::~safe_VkPhysicalDeviceRepresentativeFragmentTestFeaturesNV()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPhysicalDeviceRepresentativeFragmentTestFeaturesNV::initialize(const VkPhysicalDeviceRepresentativeFragmentTestFeaturesNV* in_struct)
{
    sType = in_struct->sType;
    representativeFragmentTest = in_struct->representativeFragmentTest;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkPhysicalDeviceRepresentativeFragmentTestFeaturesNV::initialize(const safe_VkPhysicalDeviceRepresentativeFragmentTestFeaturesNV* src)
{
    sType = src->sType;
    representativeFragmentTest = src->representativeFragmentTest;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkPipelineRepresentativeFragmentTestStateCreateInfoNV::safe_VkPipelineRepresentativeFragmentTestStateCreateInfoNV(const VkPipelineRepresentativeFragmentTestStateCreateInfoNV* in_struct) :
    sType(in_struct->sType),
    representativeFragmentTestEnable(in_struct->representativeFragmentTestEnable)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkPipelineRepresentativeFragmentTestStateCreateInfoNV::safe_VkPipelineRepresentativeFragmentTestStateCreateInfoNV() :
    pNext(nullptr)
{}

safe_VkPipelineRepresentativeFragmentTestStateCreateInfoNV::safe_VkPipelineRepresentativeFragmentTestStateCreateInfoNV(const safe_VkPipelineRepresentativeFragmentTestStateCreateInfoNV& src)
{
    sType = src.sType;
    representativeFragmentTestEnable = src.representativeFragmentTestEnable;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkPipelineRepresentativeFragmentTestStateCreateInfoNV& safe_VkPipelineRepresentativeFragmentTestStateCreateInfoNV::operator=(const safe_VkPipelineRepresentativeFragmentTestStateCreateInfoNV& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    representativeFragmentTestEnable = src.representativeFragmentTestEnable;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkPipelineRepresentativeFragmentTestStateCreateInfoNV::~safe_VkPipelineRepresentativeFragmentTestStateCreateInfoNV()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPipelineRepresentativeFragmentTestStateCreateInfoNV::initialize(const VkPipelineRepresentativeFragmentTestStateCreateInfoNV* in_struct)
{
    sType = in_struct->sType;
    representativeFragmentTestEnable = in_struct->representativeFragmentTestEnable;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkPipelineRepresentativeFragmentTestStateCreateInfoNV::initialize(const safe_VkPipelineRepresentativeFragmentTestStateCreateInfoNV* src)
{
    sType = src->sType;
    representativeFragmentTestEnable = src->representativeFragmentTestEnable;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkPhysicalDeviceImageViewImageFormatInfoEXT::safe_VkPhysicalDeviceImageViewImageFormatInfoEXT(const VkPhysicalDeviceImageViewImageFormatInfoEXT* in_struct) :
    sType(in_struct->sType),
    imageViewType(in_struct->imageViewType)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkPhysicalDeviceImageViewImageFormatInfoEXT::safe_VkPhysicalDeviceImageViewImageFormatInfoEXT() :
    pNext(nullptr)
{}

safe_VkPhysicalDeviceImageViewImageFormatInfoEXT::safe_VkPhysicalDeviceImageViewImageFormatInfoEXT(const safe_VkPhysicalDeviceImageViewImageFormatInfoEXT& src)
{
    sType = src.sType;
    imageViewType = src.imageViewType;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkPhysicalDeviceImageViewImageFormatInfoEXT& safe_VkPhysicalDeviceImageViewImageFormatInfoEXT::operator=(const safe_VkPhysicalDeviceImageViewImageFormatInfoEXT& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    imageViewType = src.imageViewType;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkPhysicalDeviceImageViewImageFormatInfoEXT::~safe_VkPhysicalDeviceImageViewImageFormatInfoEXT()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPhysicalDeviceImageViewImageFormatInfoEXT::initialize(const VkPhysicalDeviceImageViewImageFormatInfoEXT* in_struct)
{
    sType = in_struct->sType;
    imageViewType = in_struct->imageViewType;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkPhysicalDeviceImageViewImageFormatInfoEXT::initialize(const safe_VkPhysicalDeviceImageViewImageFormatInfoEXT* src)
{
    sType = src->sType;
    imageViewType = src->imageViewType;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkFilterCubicImageViewImageFormatPropertiesEXT::safe_VkFilterCubicImageViewImageFormatPropertiesEXT(const VkFilterCubicImageViewImageFormatPropertiesEXT* in_struct) :
    sType(in_struct->sType),
    filterCubic(in_struct->filterCubic),
    filterCubicMinmax(in_struct->filterCubicMinmax)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkFilterCubicImageViewImageFormatPropertiesEXT::safe_VkFilterCubicImageViewImageFormatPropertiesEXT() :
    pNext(nullptr)
{}

safe_VkFilterCubicImageViewImageFormatPropertiesEXT::safe_VkFilterCubicImageViewImageFormatPropertiesEXT(const safe_VkFilterCubicImageViewImageFormatPropertiesEXT& src)
{
    sType = src.sType;
    filterCubic = src.filterCubic;
    filterCubicMinmax = src.filterCubicMinmax;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkFilterCubicImageViewImageFormatPropertiesEXT& safe_VkFilterCubicImageViewImageFormatPropertiesEXT::operator=(const safe_VkFilterCubicImageViewImageFormatPropertiesEXT& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    filterCubic = src.filterCubic;
    filterCubicMinmax = src.filterCubicMinmax;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkFilterCubicImageViewImageFormatPropertiesEXT::~safe_VkFilterCubicImageViewImageFormatPropertiesEXT()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkFilterCubicImageViewImageFormatPropertiesEXT::initialize(const VkFilterCubicImageViewImageFormatPropertiesEXT* in_struct)
{
    sType = in_struct->sType;
    filterCubic = in_struct->filterCubic;
    filterCubicMinmax = in_struct->filterCubicMinmax;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkFilterCubicImageViewImageFormatPropertiesEXT::initialize(const safe_VkFilterCubicImageViewImageFormatPropertiesEXT* src)
{
    sType = src->sType;
    filterCubic = src->filterCubic;
    filterCubicMinmax = src->filterCubicMinmax;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkDeviceQueueGlobalPriorityCreateInfoEXT::safe_VkDeviceQueueGlobalPriorityCreateInfoEXT(const VkDeviceQueueGlobalPriorityCreateInfoEXT* in_struct) :
    sType(in_struct->sType),
    globalPriority(in_struct->globalPriority)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkDeviceQueueGlobalPriorityCreateInfoEXT::safe_VkDeviceQueueGlobalPriorityCreateInfoEXT() :
    pNext(nullptr)
{}

safe_VkDeviceQueueGlobalPriorityCreateInfoEXT::safe_VkDeviceQueueGlobalPriorityCreateInfoEXT(const safe_VkDeviceQueueGlobalPriorityCreateInfoEXT& src)
{
    sType = src.sType;
    globalPriority = src.globalPriority;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkDeviceQueueGlobalPriorityCreateInfoEXT& safe_VkDeviceQueueGlobalPriorityCreateInfoEXT::operator=(const safe_VkDeviceQueueGlobalPriorityCreateInfoEXT& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    globalPriority = src.globalPriority;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkDeviceQueueGlobalPriorityCreateInfoEXT::~safe_VkDeviceQueueGlobalPriorityCreateInfoEXT()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkDeviceQueueGlobalPriorityCreateInfoEXT::initialize(const VkDeviceQueueGlobalPriorityCreateInfoEXT* in_struct)
{
    sType = in_struct->sType;
    globalPriority = in_struct->globalPriority;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkDeviceQueueGlobalPriorityCreateInfoEXT::initialize(const safe_VkDeviceQueueGlobalPriorityCreateInfoEXT* src)
{
    sType = src->sType;
    globalPriority = src->globalPriority;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkImportMemoryHostPointerInfoEXT::safe_VkImportMemoryHostPointerInfoEXT(const VkImportMemoryHostPointerInfoEXT* in_struct) :
    sType(in_struct->sType),
    handleType(in_struct->handleType),
    pHostPointer(in_struct->pHostPointer)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkImportMemoryHostPointerInfoEXT::safe_VkImportMemoryHostPointerInfoEXT() :
    pNext(nullptr),
    pHostPointer(nullptr)
{}

safe_VkImportMemoryHostPointerInfoEXT::safe_VkImportMemoryHostPointerInfoEXT(const safe_VkImportMemoryHostPointerInfoEXT& src)
{
    sType = src.sType;
    handleType = src.handleType;
    pHostPointer = src.pHostPointer;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkImportMemoryHostPointerInfoEXT& safe_VkImportMemoryHostPointerInfoEXT::operator=(const safe_VkImportMemoryHostPointerInfoEXT& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    handleType = src.handleType;
    pHostPointer = src.pHostPointer;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkImportMemoryHostPointerInfoEXT::~safe_VkImportMemoryHostPointerInfoEXT()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkImportMemoryHostPointerInfoEXT::initialize(const VkImportMemoryHostPointerInfoEXT* in_struct)
{
    sType = in_struct->sType;
    handleType = in_struct->handleType;
    pHostPointer = in_struct->pHostPointer;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkImportMemoryHostPointerInfoEXT::initialize(const safe_VkImportMemoryHostPointerInfoEXT* src)
{
    sType = src->sType;
    handleType = src->handleType;
    pHostPointer = src->pHostPointer;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkMemoryHostPointerPropertiesEXT::safe_VkMemoryHostPointerPropertiesEXT(const VkMemoryHostPointerPropertiesEXT* in_struct) :
    sType(in_struct->sType),
    memoryTypeBits(in_struct->memoryTypeBits)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkMemoryHostPointerPropertiesEXT::safe_VkMemoryHostPointerPropertiesEXT() :
    pNext(nullptr)
{}

safe_VkMemoryHostPointerPropertiesEXT::safe_VkMemoryHostPointerPropertiesEXT(const safe_VkMemoryHostPointerPropertiesEXT& src)
{
    sType = src.sType;
    memoryTypeBits = src.memoryTypeBits;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkMemoryHostPointerPropertiesEXT& safe_VkMemoryHostPointerPropertiesEXT::operator=(const safe_VkMemoryHostPointerPropertiesEXT& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    memoryTypeBits = src.memoryTypeBits;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkMemoryHostPointerPropertiesEXT::~safe_VkMemoryHostPointerPropertiesEXT()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkMemoryHostPointerPropertiesEXT::initialize(const VkMemoryHostPointerPropertiesEXT* in_struct)
{
    sType = in_struct->sType;
    memoryTypeBits = in_struct->memoryTypeBits;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkMemoryHostPointerPropertiesEXT::initialize(const safe_VkMemoryHostPointerPropertiesEXT* src)
{
    sType = src->sType;
    memoryTypeBits = src->memoryTypeBits;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkPhysicalDeviceExternalMemoryHostPropertiesEXT::safe_VkPhysicalDeviceExternalMemoryHostPropertiesEXT(const VkPhysicalDeviceExternalMemoryHostPropertiesEXT* in_struct) :
    sType(in_struct->sType),
    minImportedHostPointerAlignment(in_struct->minImportedHostPointerAlignment)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkPhysicalDeviceExternalMemoryHostPropertiesEXT::safe_VkPhysicalDeviceExternalMemoryHostPropertiesEXT() :
    pNext(nullptr)
{}

safe_VkPhysicalDeviceExternalMemoryHostPropertiesEXT::safe_VkPhysicalDeviceExternalMemoryHostPropertiesEXT(const safe_VkPhysicalDeviceExternalMemoryHostPropertiesEXT& src)
{
    sType = src.sType;
    minImportedHostPointerAlignment = src.minImportedHostPointerAlignment;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkPhysicalDeviceExternalMemoryHostPropertiesEXT& safe_VkPhysicalDeviceExternalMemoryHostPropertiesEXT::operator=(const safe_VkPhysicalDeviceExternalMemoryHostPropertiesEXT& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    minImportedHostPointerAlignment = src.minImportedHostPointerAlignment;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkPhysicalDeviceExternalMemoryHostPropertiesEXT::~safe_VkPhysicalDeviceExternalMemoryHostPropertiesEXT()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPhysicalDeviceExternalMemoryHostPropertiesEXT::initialize(const VkPhysicalDeviceExternalMemoryHostPropertiesEXT* in_struct)
{
    sType = in_struct->sType;
    minImportedHostPointerAlignment = in_struct->minImportedHostPointerAlignment;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkPhysicalDeviceExternalMemoryHostPropertiesEXT::initialize(const safe_VkPhysicalDeviceExternalMemoryHostPropertiesEXT* src)
{
    sType = src->sType;
    minImportedHostPointerAlignment = src->minImportedHostPointerAlignment;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkPipelineCompilerControlCreateInfoAMD::safe_VkPipelineCompilerControlCreateInfoAMD(const VkPipelineCompilerControlCreateInfoAMD* in_struct) :
    sType(in_struct->sType),
    compilerControlFlags(in_struct->compilerControlFlags)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkPipelineCompilerControlCreateInfoAMD::safe_VkPipelineCompilerControlCreateInfoAMD() :
    pNext(nullptr)
{}

safe_VkPipelineCompilerControlCreateInfoAMD::safe_VkPipelineCompilerControlCreateInfoAMD(const safe_VkPipelineCompilerControlCreateInfoAMD& src)
{
    sType = src.sType;
    compilerControlFlags = src.compilerControlFlags;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkPipelineCompilerControlCreateInfoAMD& safe_VkPipelineCompilerControlCreateInfoAMD::operator=(const safe_VkPipelineCompilerControlCreateInfoAMD& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    compilerControlFlags = src.compilerControlFlags;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkPipelineCompilerControlCreateInfoAMD::~safe_VkPipelineCompilerControlCreateInfoAMD()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPipelineCompilerControlCreateInfoAMD::initialize(const VkPipelineCompilerControlCreateInfoAMD* in_struct)
{
    sType = in_struct->sType;
    compilerControlFlags = in_struct->compilerControlFlags;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkPipelineCompilerControlCreateInfoAMD::initialize(const safe_VkPipelineCompilerControlCreateInfoAMD* src)
{
    sType = src->sType;
    compilerControlFlags = src->compilerControlFlags;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkCalibratedTimestampInfoEXT::safe_VkCalibratedTimestampInfoEXT(const VkCalibratedTimestampInfoEXT* in_struct) :
    sType(in_struct->sType),
    timeDomain(in_struct->timeDomain)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkCalibratedTimestampInfoEXT::safe_VkCalibratedTimestampInfoEXT() :
    pNext(nullptr)
{}

safe_VkCalibratedTimestampInfoEXT::safe_VkCalibratedTimestampInfoEXT(const safe_VkCalibratedTimestampInfoEXT& src)
{
    sType = src.sType;
    timeDomain = src.timeDomain;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkCalibratedTimestampInfoEXT& safe_VkCalibratedTimestampInfoEXT::operator=(const safe_VkCalibratedTimestampInfoEXT& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    timeDomain = src.timeDomain;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkCalibratedTimestampInfoEXT::~safe_VkCalibratedTimestampInfoEXT()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkCalibratedTimestampInfoEXT::initialize(const VkCalibratedTimestampInfoEXT* in_struct)
{
    sType = in_struct->sType;
    timeDomain = in_struct->timeDomain;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkCalibratedTimestampInfoEXT::initialize(const safe_VkCalibratedTimestampInfoEXT* src)
{
    sType = src->sType;
    timeDomain = src->timeDomain;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkPhysicalDeviceShaderCorePropertiesAMD::safe_VkPhysicalDeviceShaderCorePropertiesAMD(const VkPhysicalDeviceShaderCorePropertiesAMD* in_struct) :
    sType(in_struct->sType),
    shaderEngineCount(in_struct->shaderEngineCount),
    shaderArraysPerEngineCount(in_struct->shaderArraysPerEngineCount),
    computeUnitsPerShaderArray(in_struct->computeUnitsPerShaderArray),
    simdPerComputeUnit(in_struct->simdPerComputeUnit),
    wavefrontsPerSimd(in_struct->wavefrontsPerSimd),
    wavefrontSize(in_struct->wavefrontSize),
    sgprsPerSimd(in_struct->sgprsPerSimd),
    minSgprAllocation(in_struct->minSgprAllocation),
    maxSgprAllocation(in_struct->maxSgprAllocation),
    sgprAllocationGranularity(in_struct->sgprAllocationGranularity),
    vgprsPerSimd(in_struct->vgprsPerSimd),
    minVgprAllocation(in_struct->minVgprAllocation),
    maxVgprAllocation(in_struct->maxVgprAllocation),
    vgprAllocationGranularity(in_struct->vgprAllocationGranularity)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkPhysicalDeviceShaderCorePropertiesAMD::safe_VkPhysicalDeviceShaderCorePropertiesAMD() :
    pNext(nullptr)
{}

safe_VkPhysicalDeviceShaderCorePropertiesAMD::safe_VkPhysicalDeviceShaderCorePropertiesAMD(const safe_VkPhysicalDeviceShaderCorePropertiesAMD& src)
{
    sType = src.sType;
    shaderEngineCount = src.shaderEngineCount;
    shaderArraysPerEngineCount = src.shaderArraysPerEngineCount;
    computeUnitsPerShaderArray = src.computeUnitsPerShaderArray;
    simdPerComputeUnit = src.simdPerComputeUnit;
    wavefrontsPerSimd = src.wavefrontsPerSimd;
    wavefrontSize = src.wavefrontSize;
    sgprsPerSimd = src.sgprsPerSimd;
    minSgprAllocation = src.minSgprAllocation;
    maxSgprAllocation = src.maxSgprAllocation;
    sgprAllocationGranularity = src.sgprAllocationGranularity;
    vgprsPerSimd = src.vgprsPerSimd;
    minVgprAllocation = src.minVgprAllocation;
    maxVgprAllocation = src.maxVgprAllocation;
    vgprAllocationGranularity = src.vgprAllocationGranularity;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkPhysicalDeviceShaderCorePropertiesAMD& safe_VkPhysicalDeviceShaderCorePropertiesAMD::operator=(const safe_VkPhysicalDeviceShaderCorePropertiesAMD& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    shaderEngineCount = src.shaderEngineCount;
    shaderArraysPerEngineCount = src.shaderArraysPerEngineCount;
    computeUnitsPerShaderArray = src.computeUnitsPerShaderArray;
    simdPerComputeUnit = src.simdPerComputeUnit;
    wavefrontsPerSimd = src.wavefrontsPerSimd;
    wavefrontSize = src.wavefrontSize;
    sgprsPerSimd = src.sgprsPerSimd;
    minSgprAllocation = src.minSgprAllocation;
    maxSgprAllocation = src.maxSgprAllocation;
    sgprAllocationGranularity = src.sgprAllocationGranularity;
    vgprsPerSimd = src.vgprsPerSimd;
    minVgprAllocation = src.minVgprAllocation;
    maxVgprAllocation = src.maxVgprAllocation;
    vgprAllocationGranularity = src.vgprAllocationGranularity;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkPhysicalDeviceShaderCorePropertiesAMD::~safe_VkPhysicalDeviceShaderCorePropertiesAMD()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPhysicalDeviceShaderCorePropertiesAMD::initialize(const VkPhysicalDeviceShaderCorePropertiesAMD* in_struct)
{
    sType = in_struct->sType;
    shaderEngineCount = in_struct->shaderEngineCount;
    shaderArraysPerEngineCount = in_struct->shaderArraysPerEngineCount;
    computeUnitsPerShaderArray = in_struct->computeUnitsPerShaderArray;
    simdPerComputeUnit = in_struct->simdPerComputeUnit;
    wavefrontsPerSimd = in_struct->wavefrontsPerSimd;
    wavefrontSize = in_struct->wavefrontSize;
    sgprsPerSimd = in_struct->sgprsPerSimd;
    minSgprAllocation = in_struct->minSgprAllocation;
    maxSgprAllocation = in_struct->maxSgprAllocation;
    sgprAllocationGranularity = in_struct->sgprAllocationGranularity;
    vgprsPerSimd = in_struct->vgprsPerSimd;
    minVgprAllocation = in_struct->minVgprAllocation;
    maxVgprAllocation = in_struct->maxVgprAllocation;
    vgprAllocationGranularity = in_struct->vgprAllocationGranularity;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkPhysicalDeviceShaderCorePropertiesAMD::initialize(const safe_VkPhysicalDeviceShaderCorePropertiesAMD* src)
{
    sType = src->sType;
    shaderEngineCount = src->shaderEngineCount;
    shaderArraysPerEngineCount = src->shaderArraysPerEngineCount;
    computeUnitsPerShaderArray = src->computeUnitsPerShaderArray;
    simdPerComputeUnit = src->simdPerComputeUnit;
    wavefrontsPerSimd = src->wavefrontsPerSimd;
    wavefrontSize = src->wavefrontSize;
    sgprsPerSimd = src->sgprsPerSimd;
    minSgprAllocation = src->minSgprAllocation;
    maxSgprAllocation = src->maxSgprAllocation;
    sgprAllocationGranularity = src->sgprAllocationGranularity;
    vgprsPerSimd = src->vgprsPerSimd;
    minVgprAllocation = src->minVgprAllocation;
    maxVgprAllocation = src->maxVgprAllocation;
    vgprAllocationGranularity = src->vgprAllocationGranularity;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkDeviceMemoryOverallocationCreateInfoAMD::safe_VkDeviceMemoryOverallocationCreateInfoAMD(const VkDeviceMemoryOverallocationCreateInfoAMD* in_struct) :
    sType(in_struct->sType),
    overallocationBehavior(in_struct->overallocationBehavior)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkDeviceMemoryOverallocationCreateInfoAMD::safe_VkDeviceMemoryOverallocationCreateInfoAMD() :
    pNext(nullptr)
{}

safe_VkDeviceMemoryOverallocationCreateInfoAMD::safe_VkDeviceMemoryOverallocationCreateInfoAMD(const safe_VkDeviceMemoryOverallocationCreateInfoAMD& src)
{
    sType = src.sType;
    overallocationBehavior = src.overallocationBehavior;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkDeviceMemoryOverallocationCreateInfoAMD& safe_VkDeviceMemoryOverallocationCreateInfoAMD::operator=(const safe_VkDeviceMemoryOverallocationCreateInfoAMD& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    overallocationBehavior = src.overallocationBehavior;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkDeviceMemoryOverallocationCreateInfoAMD::~safe_VkDeviceMemoryOverallocationCreateInfoAMD()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkDeviceMemoryOverallocationCreateInfoAMD::initialize(const VkDeviceMemoryOverallocationCreateInfoAMD* in_struct)
{
    sType = in_struct->sType;
    overallocationBehavior = in_struct->overallocationBehavior;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkDeviceMemoryOverallocationCreateInfoAMD::initialize(const safe_VkDeviceMemoryOverallocationCreateInfoAMD* src)
{
    sType = src->sType;
    overallocationBehavior = src->overallocationBehavior;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkPhysicalDeviceVertexAttributeDivisorPropertiesEXT::safe_VkPhysicalDeviceVertexAttributeDivisorPropertiesEXT(const VkPhysicalDeviceVertexAttributeDivisorPropertiesEXT* in_struct) :
    sType(in_struct->sType),
    maxVertexAttribDivisor(in_struct->maxVertexAttribDivisor)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkPhysicalDeviceVertexAttributeDivisorPropertiesEXT::safe_VkPhysicalDeviceVertexAttributeDivisorPropertiesEXT() :
    pNext(nullptr)
{}

safe_VkPhysicalDeviceVertexAttributeDivisorPropertiesEXT::safe_VkPhysicalDeviceVertexAttributeDivisorPropertiesEXT(const safe_VkPhysicalDeviceVertexAttributeDivisorPropertiesEXT& src)
{
    sType = src.sType;
    maxVertexAttribDivisor = src.maxVertexAttribDivisor;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkPhysicalDeviceVertexAttributeDivisorPropertiesEXT& safe_VkPhysicalDeviceVertexAttributeDivisorPropertiesEXT::operator=(const safe_VkPhysicalDeviceVertexAttributeDivisorPropertiesEXT& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    maxVertexAttribDivisor = src.maxVertexAttribDivisor;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkPhysicalDeviceVertexAttributeDivisorPropertiesEXT::~safe_VkPhysicalDeviceVertexAttributeDivisorPropertiesEXT()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPhysicalDeviceVertexAttributeDivisorPropertiesEXT::initialize(const VkPhysicalDeviceVertexAttributeDivisorPropertiesEXT* in_struct)
{
    sType = in_struct->sType;
    maxVertexAttribDivisor = in_struct->maxVertexAttribDivisor;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkPhysicalDeviceVertexAttributeDivisorPropertiesEXT::initialize(const safe_VkPhysicalDeviceVertexAttributeDivisorPropertiesEXT* src)
{
    sType = src->sType;
    maxVertexAttribDivisor = src->maxVertexAttribDivisor;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkPipelineVertexInputDivisorStateCreateInfoEXT::safe_VkPipelineVertexInputDivisorStateCreateInfoEXT(const VkPipelineVertexInputDivisorStateCreateInfoEXT* in_struct) :
    sType(in_struct->sType),
    vertexBindingDivisorCount(in_struct->vertexBindingDivisorCount),
    pVertexBindingDivisors(nullptr)
{
    pNext = SafePnextCopy(in_struct->pNext);
    if (in_struct->pVertexBindingDivisors) {
        pVertexBindingDivisors = new VkVertexInputBindingDivisorDescriptionEXT[in_struct->vertexBindingDivisorCount];
        memcpy ((void *)pVertexBindingDivisors, (void *)in_struct->pVertexBindingDivisors, sizeof(VkVertexInputBindingDivisorDescriptionEXT)*in_struct->vertexBindingDivisorCount);
    }
}

safe_VkPipelineVertexInputDivisorStateCreateInfoEXT::safe_VkPipelineVertexInputDivisorStateCreateInfoEXT() :
    pNext(nullptr),
    pVertexBindingDivisors(nullptr)
{}

safe_VkPipelineVertexInputDivisorStateCreateInfoEXT::safe_VkPipelineVertexInputDivisorStateCreateInfoEXT(const safe_VkPipelineVertexInputDivisorStateCreateInfoEXT& src)
{
    sType = src.sType;
    vertexBindingDivisorCount = src.vertexBindingDivisorCount;
    pVertexBindingDivisors = nullptr;
    pNext = SafePnextCopy(src.pNext);
    if (src.pVertexBindingDivisors) {
        pVertexBindingDivisors = new VkVertexInputBindingDivisorDescriptionEXT[src.vertexBindingDivisorCount];
        memcpy ((void *)pVertexBindingDivisors, (void *)src.pVertexBindingDivisors, sizeof(VkVertexInputBindingDivisorDescriptionEXT)*src.vertexBindingDivisorCount);
    }
}

safe_VkPipelineVertexInputDivisorStateCreateInfoEXT& safe_VkPipelineVertexInputDivisorStateCreateInfoEXT::operator=(const safe_VkPipelineVertexInputDivisorStateCreateInfoEXT& src)
{
    if (&src == this) return *this;

    if (pVertexBindingDivisors)
        delete[] pVertexBindingDivisors;
    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    vertexBindingDivisorCount = src.vertexBindingDivisorCount;
    pVertexBindingDivisors = nullptr;
    pNext = SafePnextCopy(src.pNext);
    if (src.pVertexBindingDivisors) {
        pVertexBindingDivisors = new VkVertexInputBindingDivisorDescriptionEXT[src.vertexBindingDivisorCount];
        memcpy ((void *)pVertexBindingDivisors, (void *)src.pVertexBindingDivisors, sizeof(VkVertexInputBindingDivisorDescriptionEXT)*src.vertexBindingDivisorCount);
    }

    return *this;
}

safe_VkPipelineVertexInputDivisorStateCreateInfoEXT::~safe_VkPipelineVertexInputDivisorStateCreateInfoEXT()
{
    if (pVertexBindingDivisors)
        delete[] pVertexBindingDivisors;
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPipelineVertexInputDivisorStateCreateInfoEXT::initialize(const VkPipelineVertexInputDivisorStateCreateInfoEXT* in_struct)
{
    sType = in_struct->sType;
    vertexBindingDivisorCount = in_struct->vertexBindingDivisorCount;
    pVertexBindingDivisors = nullptr;
    pNext = SafePnextCopy(in_struct->pNext);
    if (in_struct->pVertexBindingDivisors) {
        pVertexBindingDivisors = new VkVertexInputBindingDivisorDescriptionEXT[in_struct->vertexBindingDivisorCount];
        memcpy ((void *)pVertexBindingDivisors, (void *)in_struct->pVertexBindingDivisors, sizeof(VkVertexInputBindingDivisorDescriptionEXT)*in_struct->vertexBindingDivisorCount);
    }
}

void safe_VkPipelineVertexInputDivisorStateCreateInfoEXT::initialize(const safe_VkPipelineVertexInputDivisorStateCreateInfoEXT* src)
{
    sType = src->sType;
    vertexBindingDivisorCount = src->vertexBindingDivisorCount;
    pVertexBindingDivisors = nullptr;
    pNext = SafePnextCopy(src->pNext);
    if (src->pVertexBindingDivisors) {
        pVertexBindingDivisors = new VkVertexInputBindingDivisorDescriptionEXT[src->vertexBindingDivisorCount];
        memcpy ((void *)pVertexBindingDivisors, (void *)src->pVertexBindingDivisors, sizeof(VkVertexInputBindingDivisorDescriptionEXT)*src->vertexBindingDivisorCount);
    }
}

safe_VkPhysicalDeviceVertexAttributeDivisorFeaturesEXT::safe_VkPhysicalDeviceVertexAttributeDivisorFeaturesEXT(const VkPhysicalDeviceVertexAttributeDivisorFeaturesEXT* in_struct) :
    sType(in_struct->sType),
    vertexAttributeInstanceRateDivisor(in_struct->vertexAttributeInstanceRateDivisor),
    vertexAttributeInstanceRateZeroDivisor(in_struct->vertexAttributeInstanceRateZeroDivisor)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkPhysicalDeviceVertexAttributeDivisorFeaturesEXT::safe_VkPhysicalDeviceVertexAttributeDivisorFeaturesEXT() :
    pNext(nullptr)
{}

safe_VkPhysicalDeviceVertexAttributeDivisorFeaturesEXT::safe_VkPhysicalDeviceVertexAttributeDivisorFeaturesEXT(const safe_VkPhysicalDeviceVertexAttributeDivisorFeaturesEXT& src)
{
    sType = src.sType;
    vertexAttributeInstanceRateDivisor = src.vertexAttributeInstanceRateDivisor;
    vertexAttributeInstanceRateZeroDivisor = src.vertexAttributeInstanceRateZeroDivisor;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkPhysicalDeviceVertexAttributeDivisorFeaturesEXT& safe_VkPhysicalDeviceVertexAttributeDivisorFeaturesEXT::operator=(const safe_VkPhysicalDeviceVertexAttributeDivisorFeaturesEXT& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    vertexAttributeInstanceRateDivisor = src.vertexAttributeInstanceRateDivisor;
    vertexAttributeInstanceRateZeroDivisor = src.vertexAttributeInstanceRateZeroDivisor;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkPhysicalDeviceVertexAttributeDivisorFeaturesEXT::~safe_VkPhysicalDeviceVertexAttributeDivisorFeaturesEXT()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPhysicalDeviceVertexAttributeDivisorFeaturesEXT::initialize(const VkPhysicalDeviceVertexAttributeDivisorFeaturesEXT* in_struct)
{
    sType = in_struct->sType;
    vertexAttributeInstanceRateDivisor = in_struct->vertexAttributeInstanceRateDivisor;
    vertexAttributeInstanceRateZeroDivisor = in_struct->vertexAttributeInstanceRateZeroDivisor;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkPhysicalDeviceVertexAttributeDivisorFeaturesEXT::initialize(const safe_VkPhysicalDeviceVertexAttributeDivisorFeaturesEXT* src)
{
    sType = src->sType;
    vertexAttributeInstanceRateDivisor = src->vertexAttributeInstanceRateDivisor;
    vertexAttributeInstanceRateZeroDivisor = src->vertexAttributeInstanceRateZeroDivisor;
    pNext = SafePnextCopy(src->pNext);
}
#ifdef VK_USE_PLATFORM_GGP


safe_VkPresentFrameTokenGGP::safe_VkPresentFrameTokenGGP(const VkPresentFrameTokenGGP* in_struct) :
    sType(in_struct->sType),
    frameToken(in_struct->frameToken)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkPresentFrameTokenGGP::safe_VkPresentFrameTokenGGP() :
    pNext(nullptr)
{}

safe_VkPresentFrameTokenGGP::safe_VkPresentFrameTokenGGP(const safe_VkPresentFrameTokenGGP& src)
{
    sType = src.sType;
    frameToken = src.frameToken;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkPresentFrameTokenGGP& safe_VkPresentFrameTokenGGP::operator=(const safe_VkPresentFrameTokenGGP& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    frameToken = src.frameToken;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkPresentFrameTokenGGP::~safe_VkPresentFrameTokenGGP()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPresentFrameTokenGGP::initialize(const VkPresentFrameTokenGGP* in_struct)
{
    sType = in_struct->sType;
    frameToken = in_struct->frameToken;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkPresentFrameTokenGGP::initialize(const safe_VkPresentFrameTokenGGP* src)
{
    sType = src->sType;
    frameToken = src->frameToken;
    pNext = SafePnextCopy(src->pNext);
}
#endif // VK_USE_PLATFORM_GGP


safe_VkPipelineCreationFeedbackCreateInfoEXT::safe_VkPipelineCreationFeedbackCreateInfoEXT(const VkPipelineCreationFeedbackCreateInfoEXT* in_struct) :
    sType(in_struct->sType),
    pPipelineCreationFeedback(nullptr),
    pipelineStageCreationFeedbackCount(in_struct->pipelineStageCreationFeedbackCount),
    pPipelineStageCreationFeedbacks(nullptr)
{
    pNext = SafePnextCopy(in_struct->pNext);
    if (in_struct->pPipelineCreationFeedback) {
        pPipelineCreationFeedback = new VkPipelineCreationFeedbackEXT(*in_struct->pPipelineCreationFeedback);
    }
    if (in_struct->pPipelineStageCreationFeedbacks) {
        pPipelineStageCreationFeedbacks = new VkPipelineCreationFeedbackEXT[in_struct->pipelineStageCreationFeedbackCount];
        memcpy ((void *)pPipelineStageCreationFeedbacks, (void *)in_struct->pPipelineStageCreationFeedbacks, sizeof(VkPipelineCreationFeedbackEXT)*in_struct->pipelineStageCreationFeedbackCount);
    }
}

safe_VkPipelineCreationFeedbackCreateInfoEXT::safe_VkPipelineCreationFeedbackCreateInfoEXT() :
    pNext(nullptr),
    pPipelineCreationFeedback(nullptr),
    pPipelineStageCreationFeedbacks(nullptr)
{}

safe_VkPipelineCreationFeedbackCreateInfoEXT::safe_VkPipelineCreationFeedbackCreateInfoEXT(const safe_VkPipelineCreationFeedbackCreateInfoEXT& src)
{
    sType = src.sType;
    pPipelineCreationFeedback = nullptr;
    pipelineStageCreationFeedbackCount = src.pipelineStageCreationFeedbackCount;
    pPipelineStageCreationFeedbacks = nullptr;
    pNext = SafePnextCopy(src.pNext);
    if (src.pPipelineCreationFeedback) {
        pPipelineCreationFeedback = new VkPipelineCreationFeedbackEXT(*src.pPipelineCreationFeedback);
    }
    if (src.pPipelineStageCreationFeedbacks) {
        pPipelineStageCreationFeedbacks = new VkPipelineCreationFeedbackEXT[src.pipelineStageCreationFeedbackCount];
        memcpy ((void *)pPipelineStageCreationFeedbacks, (void *)src.pPipelineStageCreationFeedbacks, sizeof(VkPipelineCreationFeedbackEXT)*src.pipelineStageCreationFeedbackCount);
    }
}

safe_VkPipelineCreationFeedbackCreateInfoEXT& safe_VkPipelineCreationFeedbackCreateInfoEXT::operator=(const safe_VkPipelineCreationFeedbackCreateInfoEXT& src)
{
    if (&src == this) return *this;

    if (pPipelineCreationFeedback)
        delete pPipelineCreationFeedback;
    if (pPipelineStageCreationFeedbacks)
        delete[] pPipelineStageCreationFeedbacks;
    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    pPipelineCreationFeedback = nullptr;
    pipelineStageCreationFeedbackCount = src.pipelineStageCreationFeedbackCount;
    pPipelineStageCreationFeedbacks = nullptr;
    pNext = SafePnextCopy(src.pNext);
    if (src.pPipelineCreationFeedback) {
        pPipelineCreationFeedback = new VkPipelineCreationFeedbackEXT(*src.pPipelineCreationFeedback);
    }
    if (src.pPipelineStageCreationFeedbacks) {
        pPipelineStageCreationFeedbacks = new VkPipelineCreationFeedbackEXT[src.pipelineStageCreationFeedbackCount];
        memcpy ((void *)pPipelineStageCreationFeedbacks, (void *)src.pPipelineStageCreationFeedbacks, sizeof(VkPipelineCreationFeedbackEXT)*src.pipelineStageCreationFeedbackCount);
    }

    return *this;
}

safe_VkPipelineCreationFeedbackCreateInfoEXT::~safe_VkPipelineCreationFeedbackCreateInfoEXT()
{
    if (pPipelineCreationFeedback)
        delete pPipelineCreationFeedback;
    if (pPipelineStageCreationFeedbacks)
        delete[] pPipelineStageCreationFeedbacks;
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPipelineCreationFeedbackCreateInfoEXT::initialize(const VkPipelineCreationFeedbackCreateInfoEXT* in_struct)
{
    sType = in_struct->sType;
    pPipelineCreationFeedback = nullptr;
    pipelineStageCreationFeedbackCount = in_struct->pipelineStageCreationFeedbackCount;
    pPipelineStageCreationFeedbacks = nullptr;
    pNext = SafePnextCopy(in_struct->pNext);
    if (in_struct->pPipelineCreationFeedback) {
        pPipelineCreationFeedback = new VkPipelineCreationFeedbackEXT(*in_struct->pPipelineCreationFeedback);
    }
    if (in_struct->pPipelineStageCreationFeedbacks) {
        pPipelineStageCreationFeedbacks = new VkPipelineCreationFeedbackEXT[in_struct->pipelineStageCreationFeedbackCount];
        memcpy ((void *)pPipelineStageCreationFeedbacks, (void *)in_struct->pPipelineStageCreationFeedbacks, sizeof(VkPipelineCreationFeedbackEXT)*in_struct->pipelineStageCreationFeedbackCount);
    }
}

void safe_VkPipelineCreationFeedbackCreateInfoEXT::initialize(const safe_VkPipelineCreationFeedbackCreateInfoEXT* src)
{
    sType = src->sType;
    pPipelineCreationFeedback = nullptr;
    pipelineStageCreationFeedbackCount = src->pipelineStageCreationFeedbackCount;
    pPipelineStageCreationFeedbacks = nullptr;
    pNext = SafePnextCopy(src->pNext);
    if (src->pPipelineCreationFeedback) {
        pPipelineCreationFeedback = new VkPipelineCreationFeedbackEXT(*src->pPipelineCreationFeedback);
    }
    if (src->pPipelineStageCreationFeedbacks) {
        pPipelineStageCreationFeedbacks = new VkPipelineCreationFeedbackEXT[src->pipelineStageCreationFeedbackCount];
        memcpy ((void *)pPipelineStageCreationFeedbacks, (void *)src->pPipelineStageCreationFeedbacks, sizeof(VkPipelineCreationFeedbackEXT)*src->pipelineStageCreationFeedbackCount);
    }
}

safe_VkPhysicalDeviceComputeShaderDerivativesFeaturesNV::safe_VkPhysicalDeviceComputeShaderDerivativesFeaturesNV(const VkPhysicalDeviceComputeShaderDerivativesFeaturesNV* in_struct) :
    sType(in_struct->sType),
    computeDerivativeGroupQuads(in_struct->computeDerivativeGroupQuads),
    computeDerivativeGroupLinear(in_struct->computeDerivativeGroupLinear)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkPhysicalDeviceComputeShaderDerivativesFeaturesNV::safe_VkPhysicalDeviceComputeShaderDerivativesFeaturesNV() :
    pNext(nullptr)
{}

safe_VkPhysicalDeviceComputeShaderDerivativesFeaturesNV::safe_VkPhysicalDeviceComputeShaderDerivativesFeaturesNV(const safe_VkPhysicalDeviceComputeShaderDerivativesFeaturesNV& src)
{
    sType = src.sType;
    computeDerivativeGroupQuads = src.computeDerivativeGroupQuads;
    computeDerivativeGroupLinear = src.computeDerivativeGroupLinear;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkPhysicalDeviceComputeShaderDerivativesFeaturesNV& safe_VkPhysicalDeviceComputeShaderDerivativesFeaturesNV::operator=(const safe_VkPhysicalDeviceComputeShaderDerivativesFeaturesNV& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    computeDerivativeGroupQuads = src.computeDerivativeGroupQuads;
    computeDerivativeGroupLinear = src.computeDerivativeGroupLinear;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkPhysicalDeviceComputeShaderDerivativesFeaturesNV::~safe_VkPhysicalDeviceComputeShaderDerivativesFeaturesNV()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPhysicalDeviceComputeShaderDerivativesFeaturesNV::initialize(const VkPhysicalDeviceComputeShaderDerivativesFeaturesNV* in_struct)
{
    sType = in_struct->sType;
    computeDerivativeGroupQuads = in_struct->computeDerivativeGroupQuads;
    computeDerivativeGroupLinear = in_struct->computeDerivativeGroupLinear;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkPhysicalDeviceComputeShaderDerivativesFeaturesNV::initialize(const safe_VkPhysicalDeviceComputeShaderDerivativesFeaturesNV* src)
{
    sType = src->sType;
    computeDerivativeGroupQuads = src->computeDerivativeGroupQuads;
    computeDerivativeGroupLinear = src->computeDerivativeGroupLinear;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkPhysicalDeviceMeshShaderFeaturesNV::safe_VkPhysicalDeviceMeshShaderFeaturesNV(const VkPhysicalDeviceMeshShaderFeaturesNV* in_struct) :
    sType(in_struct->sType),
    taskShader(in_struct->taskShader),
    meshShader(in_struct->meshShader)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkPhysicalDeviceMeshShaderFeaturesNV::safe_VkPhysicalDeviceMeshShaderFeaturesNV() :
    pNext(nullptr)
{}

safe_VkPhysicalDeviceMeshShaderFeaturesNV::safe_VkPhysicalDeviceMeshShaderFeaturesNV(const safe_VkPhysicalDeviceMeshShaderFeaturesNV& src)
{
    sType = src.sType;
    taskShader = src.taskShader;
    meshShader = src.meshShader;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkPhysicalDeviceMeshShaderFeaturesNV& safe_VkPhysicalDeviceMeshShaderFeaturesNV::operator=(const safe_VkPhysicalDeviceMeshShaderFeaturesNV& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    taskShader = src.taskShader;
    meshShader = src.meshShader;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkPhysicalDeviceMeshShaderFeaturesNV::~safe_VkPhysicalDeviceMeshShaderFeaturesNV()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPhysicalDeviceMeshShaderFeaturesNV::initialize(const VkPhysicalDeviceMeshShaderFeaturesNV* in_struct)
{
    sType = in_struct->sType;
    taskShader = in_struct->taskShader;
    meshShader = in_struct->meshShader;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkPhysicalDeviceMeshShaderFeaturesNV::initialize(const safe_VkPhysicalDeviceMeshShaderFeaturesNV* src)
{
    sType = src->sType;
    taskShader = src->taskShader;
    meshShader = src->meshShader;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkPhysicalDeviceMeshShaderPropertiesNV::safe_VkPhysicalDeviceMeshShaderPropertiesNV(const VkPhysicalDeviceMeshShaderPropertiesNV* in_struct) :
    sType(in_struct->sType),
    maxDrawMeshTasksCount(in_struct->maxDrawMeshTasksCount),
    maxTaskWorkGroupInvocations(in_struct->maxTaskWorkGroupInvocations),
    maxTaskTotalMemorySize(in_struct->maxTaskTotalMemorySize),
    maxTaskOutputCount(in_struct->maxTaskOutputCount),
    maxMeshWorkGroupInvocations(in_struct->maxMeshWorkGroupInvocations),
    maxMeshTotalMemorySize(in_struct->maxMeshTotalMemorySize),
    maxMeshOutputVertices(in_struct->maxMeshOutputVertices),
    maxMeshOutputPrimitives(in_struct->maxMeshOutputPrimitives),
    maxMeshMultiviewViewCount(in_struct->maxMeshMultiviewViewCount),
    meshOutputPerVertexGranularity(in_struct->meshOutputPerVertexGranularity),
    meshOutputPerPrimitiveGranularity(in_struct->meshOutputPerPrimitiveGranularity)
{
    pNext = SafePnextCopy(in_struct->pNext);
    for (uint32_t i = 0; i < 3; ++i) {
        maxTaskWorkGroupSize[i] = in_struct->maxTaskWorkGroupSize[i];
    }
    for (uint32_t i = 0; i < 3; ++i) {
        maxMeshWorkGroupSize[i] = in_struct->maxMeshWorkGroupSize[i];
    }
}

safe_VkPhysicalDeviceMeshShaderPropertiesNV::safe_VkPhysicalDeviceMeshShaderPropertiesNV() :
    pNext(nullptr)
{}

safe_VkPhysicalDeviceMeshShaderPropertiesNV::safe_VkPhysicalDeviceMeshShaderPropertiesNV(const safe_VkPhysicalDeviceMeshShaderPropertiesNV& src)
{
    sType = src.sType;
    maxDrawMeshTasksCount = src.maxDrawMeshTasksCount;
    maxTaskWorkGroupInvocations = src.maxTaskWorkGroupInvocations;
    maxTaskTotalMemorySize = src.maxTaskTotalMemorySize;
    maxTaskOutputCount = src.maxTaskOutputCount;
    maxMeshWorkGroupInvocations = src.maxMeshWorkGroupInvocations;
    maxMeshTotalMemorySize = src.maxMeshTotalMemorySize;
    maxMeshOutputVertices = src.maxMeshOutputVertices;
    maxMeshOutputPrimitives = src.maxMeshOutputPrimitives;
    maxMeshMultiviewViewCount = src.maxMeshMultiviewViewCount;
    meshOutputPerVertexGranularity = src.meshOutputPerVertexGranularity;
    meshOutputPerPrimitiveGranularity = src.meshOutputPerPrimitiveGranularity;
    pNext = SafePnextCopy(src.pNext);
    for (uint32_t i = 0; i < 3; ++i) {
        maxTaskWorkGroupSize[i] = src.maxTaskWorkGroupSize[i];
    }
    for (uint32_t i = 0; i < 3; ++i) {
        maxMeshWorkGroupSize[i] = src.maxMeshWorkGroupSize[i];
    }
}

safe_VkPhysicalDeviceMeshShaderPropertiesNV& safe_VkPhysicalDeviceMeshShaderPropertiesNV::operator=(const safe_VkPhysicalDeviceMeshShaderPropertiesNV& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    maxDrawMeshTasksCount = src.maxDrawMeshTasksCount;
    maxTaskWorkGroupInvocations = src.maxTaskWorkGroupInvocations;
    maxTaskTotalMemorySize = src.maxTaskTotalMemorySize;
    maxTaskOutputCount = src.maxTaskOutputCount;
    maxMeshWorkGroupInvocations = src.maxMeshWorkGroupInvocations;
    maxMeshTotalMemorySize = src.maxMeshTotalMemorySize;
    maxMeshOutputVertices = src.maxMeshOutputVertices;
    maxMeshOutputPrimitives = src.maxMeshOutputPrimitives;
    maxMeshMultiviewViewCount = src.maxMeshMultiviewViewCount;
    meshOutputPerVertexGranularity = src.meshOutputPerVertexGranularity;
    meshOutputPerPrimitiveGranularity = src.meshOutputPerPrimitiveGranularity;
    pNext = SafePnextCopy(src.pNext);
    for (uint32_t i = 0; i < 3; ++i) {
        maxTaskWorkGroupSize[i] = src.maxTaskWorkGroupSize[i];
    }
    for (uint32_t i = 0; i < 3; ++i) {
        maxMeshWorkGroupSize[i] = src.maxMeshWorkGroupSize[i];
    }

    return *this;
}

safe_VkPhysicalDeviceMeshShaderPropertiesNV::~safe_VkPhysicalDeviceMeshShaderPropertiesNV()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPhysicalDeviceMeshShaderPropertiesNV::initialize(const VkPhysicalDeviceMeshShaderPropertiesNV* in_struct)
{
    sType = in_struct->sType;
    maxDrawMeshTasksCount = in_struct->maxDrawMeshTasksCount;
    maxTaskWorkGroupInvocations = in_struct->maxTaskWorkGroupInvocations;
    maxTaskTotalMemorySize = in_struct->maxTaskTotalMemorySize;
    maxTaskOutputCount = in_struct->maxTaskOutputCount;
    maxMeshWorkGroupInvocations = in_struct->maxMeshWorkGroupInvocations;
    maxMeshTotalMemorySize = in_struct->maxMeshTotalMemorySize;
    maxMeshOutputVertices = in_struct->maxMeshOutputVertices;
    maxMeshOutputPrimitives = in_struct->maxMeshOutputPrimitives;
    maxMeshMultiviewViewCount = in_struct->maxMeshMultiviewViewCount;
    meshOutputPerVertexGranularity = in_struct->meshOutputPerVertexGranularity;
    meshOutputPerPrimitiveGranularity = in_struct->meshOutputPerPrimitiveGranularity;
    pNext = SafePnextCopy(in_struct->pNext);
    for (uint32_t i = 0; i < 3; ++i) {
        maxTaskWorkGroupSize[i] = in_struct->maxTaskWorkGroupSize[i];
    }
    for (uint32_t i = 0; i < 3; ++i) {
        maxMeshWorkGroupSize[i] = in_struct->maxMeshWorkGroupSize[i];
    }
}

void safe_VkPhysicalDeviceMeshShaderPropertiesNV::initialize(const safe_VkPhysicalDeviceMeshShaderPropertiesNV* src)
{
    sType = src->sType;
    maxDrawMeshTasksCount = src->maxDrawMeshTasksCount;
    maxTaskWorkGroupInvocations = src->maxTaskWorkGroupInvocations;
    maxTaskTotalMemorySize = src->maxTaskTotalMemorySize;
    maxTaskOutputCount = src->maxTaskOutputCount;
    maxMeshWorkGroupInvocations = src->maxMeshWorkGroupInvocations;
    maxMeshTotalMemorySize = src->maxMeshTotalMemorySize;
    maxMeshOutputVertices = src->maxMeshOutputVertices;
    maxMeshOutputPrimitives = src->maxMeshOutputPrimitives;
    maxMeshMultiviewViewCount = src->maxMeshMultiviewViewCount;
    meshOutputPerVertexGranularity = src->meshOutputPerVertexGranularity;
    meshOutputPerPrimitiveGranularity = src->meshOutputPerPrimitiveGranularity;
    pNext = SafePnextCopy(src->pNext);
    for (uint32_t i = 0; i < 3; ++i) {
        maxTaskWorkGroupSize[i] = src->maxTaskWorkGroupSize[i];
    }
    for (uint32_t i = 0; i < 3; ++i) {
        maxMeshWorkGroupSize[i] = src->maxMeshWorkGroupSize[i];
    }
}

safe_VkPhysicalDeviceFragmentShaderBarycentricFeaturesNV::safe_VkPhysicalDeviceFragmentShaderBarycentricFeaturesNV(const VkPhysicalDeviceFragmentShaderBarycentricFeaturesNV* in_struct) :
    sType(in_struct->sType),
    fragmentShaderBarycentric(in_struct->fragmentShaderBarycentric)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkPhysicalDeviceFragmentShaderBarycentricFeaturesNV::safe_VkPhysicalDeviceFragmentShaderBarycentricFeaturesNV() :
    pNext(nullptr)
{}

safe_VkPhysicalDeviceFragmentShaderBarycentricFeaturesNV::safe_VkPhysicalDeviceFragmentShaderBarycentricFeaturesNV(const safe_VkPhysicalDeviceFragmentShaderBarycentricFeaturesNV& src)
{
    sType = src.sType;
    fragmentShaderBarycentric = src.fragmentShaderBarycentric;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkPhysicalDeviceFragmentShaderBarycentricFeaturesNV& safe_VkPhysicalDeviceFragmentShaderBarycentricFeaturesNV::operator=(const safe_VkPhysicalDeviceFragmentShaderBarycentricFeaturesNV& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    fragmentShaderBarycentric = src.fragmentShaderBarycentric;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkPhysicalDeviceFragmentShaderBarycentricFeaturesNV::~safe_VkPhysicalDeviceFragmentShaderBarycentricFeaturesNV()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPhysicalDeviceFragmentShaderBarycentricFeaturesNV::initialize(const VkPhysicalDeviceFragmentShaderBarycentricFeaturesNV* in_struct)
{
    sType = in_struct->sType;
    fragmentShaderBarycentric = in_struct->fragmentShaderBarycentric;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkPhysicalDeviceFragmentShaderBarycentricFeaturesNV::initialize(const safe_VkPhysicalDeviceFragmentShaderBarycentricFeaturesNV* src)
{
    sType = src->sType;
    fragmentShaderBarycentric = src->fragmentShaderBarycentric;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkPhysicalDeviceShaderImageFootprintFeaturesNV::safe_VkPhysicalDeviceShaderImageFootprintFeaturesNV(const VkPhysicalDeviceShaderImageFootprintFeaturesNV* in_struct) :
    sType(in_struct->sType),
    imageFootprint(in_struct->imageFootprint)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkPhysicalDeviceShaderImageFootprintFeaturesNV::safe_VkPhysicalDeviceShaderImageFootprintFeaturesNV() :
    pNext(nullptr)
{}

safe_VkPhysicalDeviceShaderImageFootprintFeaturesNV::safe_VkPhysicalDeviceShaderImageFootprintFeaturesNV(const safe_VkPhysicalDeviceShaderImageFootprintFeaturesNV& src)
{
    sType = src.sType;
    imageFootprint = src.imageFootprint;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkPhysicalDeviceShaderImageFootprintFeaturesNV& safe_VkPhysicalDeviceShaderImageFootprintFeaturesNV::operator=(const safe_VkPhysicalDeviceShaderImageFootprintFeaturesNV& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    imageFootprint = src.imageFootprint;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkPhysicalDeviceShaderImageFootprintFeaturesNV::~safe_VkPhysicalDeviceShaderImageFootprintFeaturesNV()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPhysicalDeviceShaderImageFootprintFeaturesNV::initialize(const VkPhysicalDeviceShaderImageFootprintFeaturesNV* in_struct)
{
    sType = in_struct->sType;
    imageFootprint = in_struct->imageFootprint;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkPhysicalDeviceShaderImageFootprintFeaturesNV::initialize(const safe_VkPhysicalDeviceShaderImageFootprintFeaturesNV* src)
{
    sType = src->sType;
    imageFootprint = src->imageFootprint;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkPipelineViewportExclusiveScissorStateCreateInfoNV::safe_VkPipelineViewportExclusiveScissorStateCreateInfoNV(const VkPipelineViewportExclusiveScissorStateCreateInfoNV* in_struct) :
    sType(in_struct->sType),
    exclusiveScissorCount(in_struct->exclusiveScissorCount),
    pExclusiveScissors(nullptr)
{
    pNext = SafePnextCopy(in_struct->pNext);
    if (in_struct->pExclusiveScissors) {
        pExclusiveScissors = new VkRect2D[in_struct->exclusiveScissorCount];
        memcpy ((void *)pExclusiveScissors, (void *)in_struct->pExclusiveScissors, sizeof(VkRect2D)*in_struct->exclusiveScissorCount);
    }
}

safe_VkPipelineViewportExclusiveScissorStateCreateInfoNV::safe_VkPipelineViewportExclusiveScissorStateCreateInfoNV() :
    pNext(nullptr),
    pExclusiveScissors(nullptr)
{}

safe_VkPipelineViewportExclusiveScissorStateCreateInfoNV::safe_VkPipelineViewportExclusiveScissorStateCreateInfoNV(const safe_VkPipelineViewportExclusiveScissorStateCreateInfoNV& src)
{
    sType = src.sType;
    exclusiveScissorCount = src.exclusiveScissorCount;
    pExclusiveScissors = nullptr;
    pNext = SafePnextCopy(src.pNext);
    if (src.pExclusiveScissors) {
        pExclusiveScissors = new VkRect2D[src.exclusiveScissorCount];
        memcpy ((void *)pExclusiveScissors, (void *)src.pExclusiveScissors, sizeof(VkRect2D)*src.exclusiveScissorCount);
    }
}

safe_VkPipelineViewportExclusiveScissorStateCreateInfoNV& safe_VkPipelineViewportExclusiveScissorStateCreateInfoNV::operator=(const safe_VkPipelineViewportExclusiveScissorStateCreateInfoNV& src)
{
    if (&src == this) return *this;

    if (pExclusiveScissors)
        delete[] pExclusiveScissors;
    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    exclusiveScissorCount = src.exclusiveScissorCount;
    pExclusiveScissors = nullptr;
    pNext = SafePnextCopy(src.pNext);
    if (src.pExclusiveScissors) {
        pExclusiveScissors = new VkRect2D[src.exclusiveScissorCount];
        memcpy ((void *)pExclusiveScissors, (void *)src.pExclusiveScissors, sizeof(VkRect2D)*src.exclusiveScissorCount);
    }

    return *this;
}

safe_VkPipelineViewportExclusiveScissorStateCreateInfoNV::~safe_VkPipelineViewportExclusiveScissorStateCreateInfoNV()
{
    if (pExclusiveScissors)
        delete[] pExclusiveScissors;
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPipelineViewportExclusiveScissorStateCreateInfoNV::initialize(const VkPipelineViewportExclusiveScissorStateCreateInfoNV* in_struct)
{
    sType = in_struct->sType;
    exclusiveScissorCount = in_struct->exclusiveScissorCount;
    pExclusiveScissors = nullptr;
    pNext = SafePnextCopy(in_struct->pNext);
    if (in_struct->pExclusiveScissors) {
        pExclusiveScissors = new VkRect2D[in_struct->exclusiveScissorCount];
        memcpy ((void *)pExclusiveScissors, (void *)in_struct->pExclusiveScissors, sizeof(VkRect2D)*in_struct->exclusiveScissorCount);
    }
}

void safe_VkPipelineViewportExclusiveScissorStateCreateInfoNV::initialize(const safe_VkPipelineViewportExclusiveScissorStateCreateInfoNV* src)
{
    sType = src->sType;
    exclusiveScissorCount = src->exclusiveScissorCount;
    pExclusiveScissors = nullptr;
    pNext = SafePnextCopy(src->pNext);
    if (src->pExclusiveScissors) {
        pExclusiveScissors = new VkRect2D[src->exclusiveScissorCount];
        memcpy ((void *)pExclusiveScissors, (void *)src->pExclusiveScissors, sizeof(VkRect2D)*src->exclusiveScissorCount);
    }
}

safe_VkPhysicalDeviceExclusiveScissorFeaturesNV::safe_VkPhysicalDeviceExclusiveScissorFeaturesNV(const VkPhysicalDeviceExclusiveScissorFeaturesNV* in_struct) :
    sType(in_struct->sType),
    exclusiveScissor(in_struct->exclusiveScissor)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkPhysicalDeviceExclusiveScissorFeaturesNV::safe_VkPhysicalDeviceExclusiveScissorFeaturesNV() :
    pNext(nullptr)
{}

safe_VkPhysicalDeviceExclusiveScissorFeaturesNV::safe_VkPhysicalDeviceExclusiveScissorFeaturesNV(const safe_VkPhysicalDeviceExclusiveScissorFeaturesNV& src)
{
    sType = src.sType;
    exclusiveScissor = src.exclusiveScissor;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkPhysicalDeviceExclusiveScissorFeaturesNV& safe_VkPhysicalDeviceExclusiveScissorFeaturesNV::operator=(const safe_VkPhysicalDeviceExclusiveScissorFeaturesNV& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    exclusiveScissor = src.exclusiveScissor;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkPhysicalDeviceExclusiveScissorFeaturesNV::~safe_VkPhysicalDeviceExclusiveScissorFeaturesNV()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPhysicalDeviceExclusiveScissorFeaturesNV::initialize(const VkPhysicalDeviceExclusiveScissorFeaturesNV* in_struct)
{
    sType = in_struct->sType;
    exclusiveScissor = in_struct->exclusiveScissor;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkPhysicalDeviceExclusiveScissorFeaturesNV::initialize(const safe_VkPhysicalDeviceExclusiveScissorFeaturesNV* src)
{
    sType = src->sType;
    exclusiveScissor = src->exclusiveScissor;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkQueueFamilyCheckpointPropertiesNV::safe_VkQueueFamilyCheckpointPropertiesNV(const VkQueueFamilyCheckpointPropertiesNV* in_struct) :
    sType(in_struct->sType),
    checkpointExecutionStageMask(in_struct->checkpointExecutionStageMask)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkQueueFamilyCheckpointPropertiesNV::safe_VkQueueFamilyCheckpointPropertiesNV() :
    pNext(nullptr)
{}

safe_VkQueueFamilyCheckpointPropertiesNV::safe_VkQueueFamilyCheckpointPropertiesNV(const safe_VkQueueFamilyCheckpointPropertiesNV& src)
{
    sType = src.sType;
    checkpointExecutionStageMask = src.checkpointExecutionStageMask;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkQueueFamilyCheckpointPropertiesNV& safe_VkQueueFamilyCheckpointPropertiesNV::operator=(const safe_VkQueueFamilyCheckpointPropertiesNV& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    checkpointExecutionStageMask = src.checkpointExecutionStageMask;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkQueueFamilyCheckpointPropertiesNV::~safe_VkQueueFamilyCheckpointPropertiesNV()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkQueueFamilyCheckpointPropertiesNV::initialize(const VkQueueFamilyCheckpointPropertiesNV* in_struct)
{
    sType = in_struct->sType;
    checkpointExecutionStageMask = in_struct->checkpointExecutionStageMask;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkQueueFamilyCheckpointPropertiesNV::initialize(const safe_VkQueueFamilyCheckpointPropertiesNV* src)
{
    sType = src->sType;
    checkpointExecutionStageMask = src->checkpointExecutionStageMask;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkCheckpointDataNV::safe_VkCheckpointDataNV(const VkCheckpointDataNV* in_struct) :
    sType(in_struct->sType),
    stage(in_struct->stage),
    pCheckpointMarker(in_struct->pCheckpointMarker)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkCheckpointDataNV::safe_VkCheckpointDataNV() :
    pNext(nullptr),
    pCheckpointMarker(nullptr)
{}

safe_VkCheckpointDataNV::safe_VkCheckpointDataNV(const safe_VkCheckpointDataNV& src)
{
    sType = src.sType;
    stage = src.stage;
    pCheckpointMarker = src.pCheckpointMarker;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkCheckpointDataNV& safe_VkCheckpointDataNV::operator=(const safe_VkCheckpointDataNV& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    stage = src.stage;
    pCheckpointMarker = src.pCheckpointMarker;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkCheckpointDataNV::~safe_VkCheckpointDataNV()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkCheckpointDataNV::initialize(const VkCheckpointDataNV* in_struct)
{
    sType = in_struct->sType;
    stage = in_struct->stage;
    pCheckpointMarker = in_struct->pCheckpointMarker;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkCheckpointDataNV::initialize(const safe_VkCheckpointDataNV* src)
{
    sType = src->sType;
    stage = src->stage;
    pCheckpointMarker = src->pCheckpointMarker;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkPhysicalDeviceShaderIntegerFunctions2FeaturesINTEL::safe_VkPhysicalDeviceShaderIntegerFunctions2FeaturesINTEL(const VkPhysicalDeviceShaderIntegerFunctions2FeaturesINTEL* in_struct) :
    sType(in_struct->sType),
    shaderIntegerFunctions2(in_struct->shaderIntegerFunctions2)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkPhysicalDeviceShaderIntegerFunctions2FeaturesINTEL::safe_VkPhysicalDeviceShaderIntegerFunctions2FeaturesINTEL() :
    pNext(nullptr)
{}

safe_VkPhysicalDeviceShaderIntegerFunctions2FeaturesINTEL::safe_VkPhysicalDeviceShaderIntegerFunctions2FeaturesINTEL(const safe_VkPhysicalDeviceShaderIntegerFunctions2FeaturesINTEL& src)
{
    sType = src.sType;
    shaderIntegerFunctions2 = src.shaderIntegerFunctions2;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkPhysicalDeviceShaderIntegerFunctions2FeaturesINTEL& safe_VkPhysicalDeviceShaderIntegerFunctions2FeaturesINTEL::operator=(const safe_VkPhysicalDeviceShaderIntegerFunctions2FeaturesINTEL& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    shaderIntegerFunctions2 = src.shaderIntegerFunctions2;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkPhysicalDeviceShaderIntegerFunctions2FeaturesINTEL::~safe_VkPhysicalDeviceShaderIntegerFunctions2FeaturesINTEL()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPhysicalDeviceShaderIntegerFunctions2FeaturesINTEL::initialize(const VkPhysicalDeviceShaderIntegerFunctions2FeaturesINTEL* in_struct)
{
    sType = in_struct->sType;
    shaderIntegerFunctions2 = in_struct->shaderIntegerFunctions2;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkPhysicalDeviceShaderIntegerFunctions2FeaturesINTEL::initialize(const safe_VkPhysicalDeviceShaderIntegerFunctions2FeaturesINTEL* src)
{
    sType = src->sType;
    shaderIntegerFunctions2 = src->shaderIntegerFunctions2;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkPerformanceValueDataINTEL::safe_VkPerformanceValueDataINTEL(const VkPerformanceValueDataINTEL* in_struct) :
    value32(in_struct->value32),
    value64(in_struct->value64),
    valueFloat(in_struct->valueFloat),
    valueBool(in_struct->valueBool)
{
    valueString = SafeStringCopy(in_struct->valueString);
}

safe_VkPerformanceValueDataINTEL::safe_VkPerformanceValueDataINTEL() :
    valueString(nullptr)
{}

safe_VkPerformanceValueDataINTEL::safe_VkPerformanceValueDataINTEL(const safe_VkPerformanceValueDataINTEL& src)
{
    value32 = src.value32;
    value64 = src.value64;
    valueFloat = src.valueFloat;
    valueBool = src.valueBool;
    valueString = SafeStringCopy(src.valueString);
}

safe_VkPerformanceValueDataINTEL& safe_VkPerformanceValueDataINTEL::operator=(const safe_VkPerformanceValueDataINTEL& src)
{
    if (&src == this) return *this;

    if (valueString) delete [] valueString;

    value32 = src.value32;
    value64 = src.value64;
    valueFloat = src.valueFloat;
    valueBool = src.valueBool;
    valueString = SafeStringCopy(src.valueString);

    return *this;
}

safe_VkPerformanceValueDataINTEL::~safe_VkPerformanceValueDataINTEL()
{
    if (valueString) delete [] valueString;
}

void safe_VkPerformanceValueDataINTEL::initialize(const VkPerformanceValueDataINTEL* in_struct)
{
    value32 = in_struct->value32;
    value64 = in_struct->value64;
    valueFloat = in_struct->valueFloat;
    valueBool = in_struct->valueBool;
    valueString = SafeStringCopy(in_struct->valueString);
}

void safe_VkPerformanceValueDataINTEL::initialize(const safe_VkPerformanceValueDataINTEL* src)
{
    value32 = src->value32;
    value64 = src->value64;
    valueFloat = src->valueFloat;
    valueBool = src->valueBool;
    valueString = SafeStringCopy(src->valueString);
}

safe_VkInitializePerformanceApiInfoINTEL::safe_VkInitializePerformanceApiInfoINTEL(const VkInitializePerformanceApiInfoINTEL* in_struct) :
    sType(in_struct->sType),
    pUserData(in_struct->pUserData)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkInitializePerformanceApiInfoINTEL::safe_VkInitializePerformanceApiInfoINTEL() :
    pNext(nullptr),
    pUserData(nullptr)
{}

safe_VkInitializePerformanceApiInfoINTEL::safe_VkInitializePerformanceApiInfoINTEL(const safe_VkInitializePerformanceApiInfoINTEL& src)
{
    sType = src.sType;
    pUserData = src.pUserData;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkInitializePerformanceApiInfoINTEL& safe_VkInitializePerformanceApiInfoINTEL::operator=(const safe_VkInitializePerformanceApiInfoINTEL& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    pUserData = src.pUserData;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkInitializePerformanceApiInfoINTEL::~safe_VkInitializePerformanceApiInfoINTEL()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkInitializePerformanceApiInfoINTEL::initialize(const VkInitializePerformanceApiInfoINTEL* in_struct)
{
    sType = in_struct->sType;
    pUserData = in_struct->pUserData;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkInitializePerformanceApiInfoINTEL::initialize(const safe_VkInitializePerformanceApiInfoINTEL* src)
{
    sType = src->sType;
    pUserData = src->pUserData;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkQueryPoolCreateInfoINTEL::safe_VkQueryPoolCreateInfoINTEL(const VkQueryPoolCreateInfoINTEL* in_struct) :
    sType(in_struct->sType),
    performanceCountersSampling(in_struct->performanceCountersSampling)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkQueryPoolCreateInfoINTEL::safe_VkQueryPoolCreateInfoINTEL() :
    pNext(nullptr)
{}

safe_VkQueryPoolCreateInfoINTEL::safe_VkQueryPoolCreateInfoINTEL(const safe_VkQueryPoolCreateInfoINTEL& src)
{
    sType = src.sType;
    performanceCountersSampling = src.performanceCountersSampling;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkQueryPoolCreateInfoINTEL& safe_VkQueryPoolCreateInfoINTEL::operator=(const safe_VkQueryPoolCreateInfoINTEL& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    performanceCountersSampling = src.performanceCountersSampling;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkQueryPoolCreateInfoINTEL::~safe_VkQueryPoolCreateInfoINTEL()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkQueryPoolCreateInfoINTEL::initialize(const VkQueryPoolCreateInfoINTEL* in_struct)
{
    sType = in_struct->sType;
    performanceCountersSampling = in_struct->performanceCountersSampling;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkQueryPoolCreateInfoINTEL::initialize(const safe_VkQueryPoolCreateInfoINTEL* src)
{
    sType = src->sType;
    performanceCountersSampling = src->performanceCountersSampling;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkPerformanceMarkerInfoINTEL::safe_VkPerformanceMarkerInfoINTEL(const VkPerformanceMarkerInfoINTEL* in_struct) :
    sType(in_struct->sType),
    marker(in_struct->marker)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkPerformanceMarkerInfoINTEL::safe_VkPerformanceMarkerInfoINTEL() :
    pNext(nullptr)
{}

safe_VkPerformanceMarkerInfoINTEL::safe_VkPerformanceMarkerInfoINTEL(const safe_VkPerformanceMarkerInfoINTEL& src)
{
    sType = src.sType;
    marker = src.marker;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkPerformanceMarkerInfoINTEL& safe_VkPerformanceMarkerInfoINTEL::operator=(const safe_VkPerformanceMarkerInfoINTEL& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    marker = src.marker;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkPerformanceMarkerInfoINTEL::~safe_VkPerformanceMarkerInfoINTEL()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPerformanceMarkerInfoINTEL::initialize(const VkPerformanceMarkerInfoINTEL* in_struct)
{
    sType = in_struct->sType;
    marker = in_struct->marker;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkPerformanceMarkerInfoINTEL::initialize(const safe_VkPerformanceMarkerInfoINTEL* src)
{
    sType = src->sType;
    marker = src->marker;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkPerformanceStreamMarkerInfoINTEL::safe_VkPerformanceStreamMarkerInfoINTEL(const VkPerformanceStreamMarkerInfoINTEL* in_struct) :
    sType(in_struct->sType),
    marker(in_struct->marker)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkPerformanceStreamMarkerInfoINTEL::safe_VkPerformanceStreamMarkerInfoINTEL() :
    pNext(nullptr)
{}

safe_VkPerformanceStreamMarkerInfoINTEL::safe_VkPerformanceStreamMarkerInfoINTEL(const safe_VkPerformanceStreamMarkerInfoINTEL& src)
{
    sType = src.sType;
    marker = src.marker;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkPerformanceStreamMarkerInfoINTEL& safe_VkPerformanceStreamMarkerInfoINTEL::operator=(const safe_VkPerformanceStreamMarkerInfoINTEL& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    marker = src.marker;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkPerformanceStreamMarkerInfoINTEL::~safe_VkPerformanceStreamMarkerInfoINTEL()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPerformanceStreamMarkerInfoINTEL::initialize(const VkPerformanceStreamMarkerInfoINTEL* in_struct)
{
    sType = in_struct->sType;
    marker = in_struct->marker;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkPerformanceStreamMarkerInfoINTEL::initialize(const safe_VkPerformanceStreamMarkerInfoINTEL* src)
{
    sType = src->sType;
    marker = src->marker;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkPerformanceOverrideInfoINTEL::safe_VkPerformanceOverrideInfoINTEL(const VkPerformanceOverrideInfoINTEL* in_struct) :
    sType(in_struct->sType),
    type(in_struct->type),
    enable(in_struct->enable),
    parameter(in_struct->parameter)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkPerformanceOverrideInfoINTEL::safe_VkPerformanceOverrideInfoINTEL() :
    pNext(nullptr)
{}

safe_VkPerformanceOverrideInfoINTEL::safe_VkPerformanceOverrideInfoINTEL(const safe_VkPerformanceOverrideInfoINTEL& src)
{
    sType = src.sType;
    type = src.type;
    enable = src.enable;
    parameter = src.parameter;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkPerformanceOverrideInfoINTEL& safe_VkPerformanceOverrideInfoINTEL::operator=(const safe_VkPerformanceOverrideInfoINTEL& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    type = src.type;
    enable = src.enable;
    parameter = src.parameter;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkPerformanceOverrideInfoINTEL::~safe_VkPerformanceOverrideInfoINTEL()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPerformanceOverrideInfoINTEL::initialize(const VkPerformanceOverrideInfoINTEL* in_struct)
{
    sType = in_struct->sType;
    type = in_struct->type;
    enable = in_struct->enable;
    parameter = in_struct->parameter;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkPerformanceOverrideInfoINTEL::initialize(const safe_VkPerformanceOverrideInfoINTEL* src)
{
    sType = src->sType;
    type = src->type;
    enable = src->enable;
    parameter = src->parameter;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkPerformanceConfigurationAcquireInfoINTEL::safe_VkPerformanceConfigurationAcquireInfoINTEL(const VkPerformanceConfigurationAcquireInfoINTEL* in_struct) :
    sType(in_struct->sType),
    type(in_struct->type)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkPerformanceConfigurationAcquireInfoINTEL::safe_VkPerformanceConfigurationAcquireInfoINTEL() :
    pNext(nullptr)
{}

safe_VkPerformanceConfigurationAcquireInfoINTEL::safe_VkPerformanceConfigurationAcquireInfoINTEL(const safe_VkPerformanceConfigurationAcquireInfoINTEL& src)
{
    sType = src.sType;
    type = src.type;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkPerformanceConfigurationAcquireInfoINTEL& safe_VkPerformanceConfigurationAcquireInfoINTEL::operator=(const safe_VkPerformanceConfigurationAcquireInfoINTEL& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    type = src.type;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkPerformanceConfigurationAcquireInfoINTEL::~safe_VkPerformanceConfigurationAcquireInfoINTEL()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPerformanceConfigurationAcquireInfoINTEL::initialize(const VkPerformanceConfigurationAcquireInfoINTEL* in_struct)
{
    sType = in_struct->sType;
    type = in_struct->type;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkPerformanceConfigurationAcquireInfoINTEL::initialize(const safe_VkPerformanceConfigurationAcquireInfoINTEL* src)
{
    sType = src->sType;
    type = src->type;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkPhysicalDevicePCIBusInfoPropertiesEXT::safe_VkPhysicalDevicePCIBusInfoPropertiesEXT(const VkPhysicalDevicePCIBusInfoPropertiesEXT* in_struct) :
    sType(in_struct->sType),
    pciDomain(in_struct->pciDomain),
    pciBus(in_struct->pciBus),
    pciDevice(in_struct->pciDevice),
    pciFunction(in_struct->pciFunction)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkPhysicalDevicePCIBusInfoPropertiesEXT::safe_VkPhysicalDevicePCIBusInfoPropertiesEXT() :
    pNext(nullptr)
{}

safe_VkPhysicalDevicePCIBusInfoPropertiesEXT::safe_VkPhysicalDevicePCIBusInfoPropertiesEXT(const safe_VkPhysicalDevicePCIBusInfoPropertiesEXT& src)
{
    sType = src.sType;
    pciDomain = src.pciDomain;
    pciBus = src.pciBus;
    pciDevice = src.pciDevice;
    pciFunction = src.pciFunction;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkPhysicalDevicePCIBusInfoPropertiesEXT& safe_VkPhysicalDevicePCIBusInfoPropertiesEXT::operator=(const safe_VkPhysicalDevicePCIBusInfoPropertiesEXT& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    pciDomain = src.pciDomain;
    pciBus = src.pciBus;
    pciDevice = src.pciDevice;
    pciFunction = src.pciFunction;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkPhysicalDevicePCIBusInfoPropertiesEXT::~safe_VkPhysicalDevicePCIBusInfoPropertiesEXT()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPhysicalDevicePCIBusInfoPropertiesEXT::initialize(const VkPhysicalDevicePCIBusInfoPropertiesEXT* in_struct)
{
    sType = in_struct->sType;
    pciDomain = in_struct->pciDomain;
    pciBus = in_struct->pciBus;
    pciDevice = in_struct->pciDevice;
    pciFunction = in_struct->pciFunction;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkPhysicalDevicePCIBusInfoPropertiesEXT::initialize(const safe_VkPhysicalDevicePCIBusInfoPropertiesEXT* src)
{
    sType = src->sType;
    pciDomain = src->pciDomain;
    pciBus = src->pciBus;
    pciDevice = src->pciDevice;
    pciFunction = src->pciFunction;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkDisplayNativeHdrSurfaceCapabilitiesAMD::safe_VkDisplayNativeHdrSurfaceCapabilitiesAMD(const VkDisplayNativeHdrSurfaceCapabilitiesAMD* in_struct) :
    sType(in_struct->sType),
    localDimmingSupport(in_struct->localDimmingSupport)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkDisplayNativeHdrSurfaceCapabilitiesAMD::safe_VkDisplayNativeHdrSurfaceCapabilitiesAMD() :
    pNext(nullptr)
{}

safe_VkDisplayNativeHdrSurfaceCapabilitiesAMD::safe_VkDisplayNativeHdrSurfaceCapabilitiesAMD(const safe_VkDisplayNativeHdrSurfaceCapabilitiesAMD& src)
{
    sType = src.sType;
    localDimmingSupport = src.localDimmingSupport;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkDisplayNativeHdrSurfaceCapabilitiesAMD& safe_VkDisplayNativeHdrSurfaceCapabilitiesAMD::operator=(const safe_VkDisplayNativeHdrSurfaceCapabilitiesAMD& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    localDimmingSupport = src.localDimmingSupport;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkDisplayNativeHdrSurfaceCapabilitiesAMD::~safe_VkDisplayNativeHdrSurfaceCapabilitiesAMD()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkDisplayNativeHdrSurfaceCapabilitiesAMD::initialize(const VkDisplayNativeHdrSurfaceCapabilitiesAMD* in_struct)
{
    sType = in_struct->sType;
    localDimmingSupport = in_struct->localDimmingSupport;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkDisplayNativeHdrSurfaceCapabilitiesAMD::initialize(const safe_VkDisplayNativeHdrSurfaceCapabilitiesAMD* src)
{
    sType = src->sType;
    localDimmingSupport = src->localDimmingSupport;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkSwapchainDisplayNativeHdrCreateInfoAMD::safe_VkSwapchainDisplayNativeHdrCreateInfoAMD(const VkSwapchainDisplayNativeHdrCreateInfoAMD* in_struct) :
    sType(in_struct->sType),
    localDimmingEnable(in_struct->localDimmingEnable)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkSwapchainDisplayNativeHdrCreateInfoAMD::safe_VkSwapchainDisplayNativeHdrCreateInfoAMD() :
    pNext(nullptr)
{}

safe_VkSwapchainDisplayNativeHdrCreateInfoAMD::safe_VkSwapchainDisplayNativeHdrCreateInfoAMD(const safe_VkSwapchainDisplayNativeHdrCreateInfoAMD& src)
{
    sType = src.sType;
    localDimmingEnable = src.localDimmingEnable;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkSwapchainDisplayNativeHdrCreateInfoAMD& safe_VkSwapchainDisplayNativeHdrCreateInfoAMD::operator=(const safe_VkSwapchainDisplayNativeHdrCreateInfoAMD& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    localDimmingEnable = src.localDimmingEnable;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkSwapchainDisplayNativeHdrCreateInfoAMD::~safe_VkSwapchainDisplayNativeHdrCreateInfoAMD()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkSwapchainDisplayNativeHdrCreateInfoAMD::initialize(const VkSwapchainDisplayNativeHdrCreateInfoAMD* in_struct)
{
    sType = in_struct->sType;
    localDimmingEnable = in_struct->localDimmingEnable;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkSwapchainDisplayNativeHdrCreateInfoAMD::initialize(const safe_VkSwapchainDisplayNativeHdrCreateInfoAMD* src)
{
    sType = src->sType;
    localDimmingEnable = src->localDimmingEnable;
    pNext = SafePnextCopy(src->pNext);
}
#ifdef VK_USE_PLATFORM_FUCHSIA


safe_VkImagePipeSurfaceCreateInfoFUCHSIA::safe_VkImagePipeSurfaceCreateInfoFUCHSIA(const VkImagePipeSurfaceCreateInfoFUCHSIA* in_struct) :
    sType(in_struct->sType),
    flags(in_struct->flags),
    imagePipeHandle(in_struct->imagePipeHandle)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkImagePipeSurfaceCreateInfoFUCHSIA::safe_VkImagePipeSurfaceCreateInfoFUCHSIA() :
    pNext(nullptr)
{}

safe_VkImagePipeSurfaceCreateInfoFUCHSIA::safe_VkImagePipeSurfaceCreateInfoFUCHSIA(const safe_VkImagePipeSurfaceCreateInfoFUCHSIA& src)
{
    sType = src.sType;
    flags = src.flags;
    imagePipeHandle = src.imagePipeHandle;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkImagePipeSurfaceCreateInfoFUCHSIA& safe_VkImagePipeSurfaceCreateInfoFUCHSIA::operator=(const safe_VkImagePipeSurfaceCreateInfoFUCHSIA& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    flags = src.flags;
    imagePipeHandle = src.imagePipeHandle;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkImagePipeSurfaceCreateInfoFUCHSIA::~safe_VkImagePipeSurfaceCreateInfoFUCHSIA()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkImagePipeSurfaceCreateInfoFUCHSIA::initialize(const VkImagePipeSurfaceCreateInfoFUCHSIA* in_struct)
{
    sType = in_struct->sType;
    flags = in_struct->flags;
    imagePipeHandle = in_struct->imagePipeHandle;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkImagePipeSurfaceCreateInfoFUCHSIA::initialize(const safe_VkImagePipeSurfaceCreateInfoFUCHSIA* src)
{
    sType = src->sType;
    flags = src->flags;
    imagePipeHandle = src->imagePipeHandle;
    pNext = SafePnextCopy(src->pNext);
}
#endif // VK_USE_PLATFORM_FUCHSIA

#ifdef VK_USE_PLATFORM_METAL_EXT


safe_VkMetalSurfaceCreateInfoEXT::safe_VkMetalSurfaceCreateInfoEXT(const VkMetalSurfaceCreateInfoEXT* in_struct) :
    sType(in_struct->sType),
    flags(in_struct->flags),
    pLayer(nullptr)
{
    pNext = SafePnextCopy(in_struct->pNext);
    if (in_struct->pLayer) {
        pLayer = new CAMetalLayer(*in_struct->pLayer);
    }
}

safe_VkMetalSurfaceCreateInfoEXT::safe_VkMetalSurfaceCreateInfoEXT() :
    pNext(nullptr),
    pLayer(nullptr)
{}

safe_VkMetalSurfaceCreateInfoEXT::safe_VkMetalSurfaceCreateInfoEXT(const safe_VkMetalSurfaceCreateInfoEXT& src)
{
    sType = src.sType;
    flags = src.flags;
    pLayer = nullptr;
    pNext = SafePnextCopy(src.pNext);
    if (src.pLayer) {
        pLayer = new CAMetalLayer(*src.pLayer);
    }
}

safe_VkMetalSurfaceCreateInfoEXT& safe_VkMetalSurfaceCreateInfoEXT::operator=(const safe_VkMetalSurfaceCreateInfoEXT& src)
{
    if (&src == this) return *this;

    if (pLayer)
        delete pLayer;
    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    flags = src.flags;
    pLayer = nullptr;
    pNext = SafePnextCopy(src.pNext);
    if (src.pLayer) {
        pLayer = new CAMetalLayer(*src.pLayer);
    }

    return *this;
}

safe_VkMetalSurfaceCreateInfoEXT::~safe_VkMetalSurfaceCreateInfoEXT()
{
    if (pLayer)
        delete pLayer;
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkMetalSurfaceCreateInfoEXT::initialize(const VkMetalSurfaceCreateInfoEXT* in_struct)
{
    sType = in_struct->sType;
    flags = in_struct->flags;
    pLayer = nullptr;
    pNext = SafePnextCopy(in_struct->pNext);
    if (in_struct->pLayer) {
        pLayer = new CAMetalLayer(*in_struct->pLayer);
    }
}

void safe_VkMetalSurfaceCreateInfoEXT::initialize(const safe_VkMetalSurfaceCreateInfoEXT* src)
{
    sType = src->sType;
    flags = src->flags;
    pLayer = nullptr;
    pNext = SafePnextCopy(src->pNext);
    if (src->pLayer) {
        pLayer = new CAMetalLayer(*src->pLayer);
    }
}
#endif // VK_USE_PLATFORM_METAL_EXT


safe_VkPhysicalDeviceFragmentDensityMapFeaturesEXT::safe_VkPhysicalDeviceFragmentDensityMapFeaturesEXT(const VkPhysicalDeviceFragmentDensityMapFeaturesEXT* in_struct) :
    sType(in_struct->sType),
    fragmentDensityMap(in_struct->fragmentDensityMap),
    fragmentDensityMapDynamic(in_struct->fragmentDensityMapDynamic),
    fragmentDensityMapNonSubsampledImages(in_struct->fragmentDensityMapNonSubsampledImages)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkPhysicalDeviceFragmentDensityMapFeaturesEXT::safe_VkPhysicalDeviceFragmentDensityMapFeaturesEXT() :
    pNext(nullptr)
{}

safe_VkPhysicalDeviceFragmentDensityMapFeaturesEXT::safe_VkPhysicalDeviceFragmentDensityMapFeaturesEXT(const safe_VkPhysicalDeviceFragmentDensityMapFeaturesEXT& src)
{
    sType = src.sType;
    fragmentDensityMap = src.fragmentDensityMap;
    fragmentDensityMapDynamic = src.fragmentDensityMapDynamic;
    fragmentDensityMapNonSubsampledImages = src.fragmentDensityMapNonSubsampledImages;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkPhysicalDeviceFragmentDensityMapFeaturesEXT& safe_VkPhysicalDeviceFragmentDensityMapFeaturesEXT::operator=(const safe_VkPhysicalDeviceFragmentDensityMapFeaturesEXT& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    fragmentDensityMap = src.fragmentDensityMap;
    fragmentDensityMapDynamic = src.fragmentDensityMapDynamic;
    fragmentDensityMapNonSubsampledImages = src.fragmentDensityMapNonSubsampledImages;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkPhysicalDeviceFragmentDensityMapFeaturesEXT::~safe_VkPhysicalDeviceFragmentDensityMapFeaturesEXT()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPhysicalDeviceFragmentDensityMapFeaturesEXT::initialize(const VkPhysicalDeviceFragmentDensityMapFeaturesEXT* in_struct)
{
    sType = in_struct->sType;
    fragmentDensityMap = in_struct->fragmentDensityMap;
    fragmentDensityMapDynamic = in_struct->fragmentDensityMapDynamic;
    fragmentDensityMapNonSubsampledImages = in_struct->fragmentDensityMapNonSubsampledImages;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkPhysicalDeviceFragmentDensityMapFeaturesEXT::initialize(const safe_VkPhysicalDeviceFragmentDensityMapFeaturesEXT* src)
{
    sType = src->sType;
    fragmentDensityMap = src->fragmentDensityMap;
    fragmentDensityMapDynamic = src->fragmentDensityMapDynamic;
    fragmentDensityMapNonSubsampledImages = src->fragmentDensityMapNonSubsampledImages;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkPhysicalDeviceFragmentDensityMapPropertiesEXT::safe_VkPhysicalDeviceFragmentDensityMapPropertiesEXT(const VkPhysicalDeviceFragmentDensityMapPropertiesEXT* in_struct) :
    sType(in_struct->sType),
    minFragmentDensityTexelSize(in_struct->minFragmentDensityTexelSize),
    maxFragmentDensityTexelSize(in_struct->maxFragmentDensityTexelSize),
    fragmentDensityInvocations(in_struct->fragmentDensityInvocations)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkPhysicalDeviceFragmentDensityMapPropertiesEXT::safe_VkPhysicalDeviceFragmentDensityMapPropertiesEXT() :
    pNext(nullptr)
{}

safe_VkPhysicalDeviceFragmentDensityMapPropertiesEXT::safe_VkPhysicalDeviceFragmentDensityMapPropertiesEXT(const safe_VkPhysicalDeviceFragmentDensityMapPropertiesEXT& src)
{
    sType = src.sType;
    minFragmentDensityTexelSize = src.minFragmentDensityTexelSize;
    maxFragmentDensityTexelSize = src.maxFragmentDensityTexelSize;
    fragmentDensityInvocations = src.fragmentDensityInvocations;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkPhysicalDeviceFragmentDensityMapPropertiesEXT& safe_VkPhysicalDeviceFragmentDensityMapPropertiesEXT::operator=(const safe_VkPhysicalDeviceFragmentDensityMapPropertiesEXT& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    minFragmentDensityTexelSize = src.minFragmentDensityTexelSize;
    maxFragmentDensityTexelSize = src.maxFragmentDensityTexelSize;
    fragmentDensityInvocations = src.fragmentDensityInvocations;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkPhysicalDeviceFragmentDensityMapPropertiesEXT::~safe_VkPhysicalDeviceFragmentDensityMapPropertiesEXT()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPhysicalDeviceFragmentDensityMapPropertiesEXT::initialize(const VkPhysicalDeviceFragmentDensityMapPropertiesEXT* in_struct)
{
    sType = in_struct->sType;
    minFragmentDensityTexelSize = in_struct->minFragmentDensityTexelSize;
    maxFragmentDensityTexelSize = in_struct->maxFragmentDensityTexelSize;
    fragmentDensityInvocations = in_struct->fragmentDensityInvocations;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkPhysicalDeviceFragmentDensityMapPropertiesEXT::initialize(const safe_VkPhysicalDeviceFragmentDensityMapPropertiesEXT* src)
{
    sType = src->sType;
    minFragmentDensityTexelSize = src->minFragmentDensityTexelSize;
    maxFragmentDensityTexelSize = src->maxFragmentDensityTexelSize;
    fragmentDensityInvocations = src->fragmentDensityInvocations;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkRenderPassFragmentDensityMapCreateInfoEXT::safe_VkRenderPassFragmentDensityMapCreateInfoEXT(const VkRenderPassFragmentDensityMapCreateInfoEXT* in_struct) :
    sType(in_struct->sType),
    fragmentDensityMapAttachment(in_struct->fragmentDensityMapAttachment)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkRenderPassFragmentDensityMapCreateInfoEXT::safe_VkRenderPassFragmentDensityMapCreateInfoEXT() :
    pNext(nullptr)
{}

safe_VkRenderPassFragmentDensityMapCreateInfoEXT::safe_VkRenderPassFragmentDensityMapCreateInfoEXT(const safe_VkRenderPassFragmentDensityMapCreateInfoEXT& src)
{
    sType = src.sType;
    fragmentDensityMapAttachment = src.fragmentDensityMapAttachment;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkRenderPassFragmentDensityMapCreateInfoEXT& safe_VkRenderPassFragmentDensityMapCreateInfoEXT::operator=(const safe_VkRenderPassFragmentDensityMapCreateInfoEXT& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    fragmentDensityMapAttachment = src.fragmentDensityMapAttachment;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkRenderPassFragmentDensityMapCreateInfoEXT::~safe_VkRenderPassFragmentDensityMapCreateInfoEXT()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkRenderPassFragmentDensityMapCreateInfoEXT::initialize(const VkRenderPassFragmentDensityMapCreateInfoEXT* in_struct)
{
    sType = in_struct->sType;
    fragmentDensityMapAttachment = in_struct->fragmentDensityMapAttachment;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkRenderPassFragmentDensityMapCreateInfoEXT::initialize(const safe_VkRenderPassFragmentDensityMapCreateInfoEXT* src)
{
    sType = src->sType;
    fragmentDensityMapAttachment = src->fragmentDensityMapAttachment;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkPhysicalDeviceScalarBlockLayoutFeaturesEXT::safe_VkPhysicalDeviceScalarBlockLayoutFeaturesEXT(const VkPhysicalDeviceScalarBlockLayoutFeaturesEXT* in_struct) :
    sType(in_struct->sType),
    scalarBlockLayout(in_struct->scalarBlockLayout)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkPhysicalDeviceScalarBlockLayoutFeaturesEXT::safe_VkPhysicalDeviceScalarBlockLayoutFeaturesEXT() :
    pNext(nullptr)
{}

safe_VkPhysicalDeviceScalarBlockLayoutFeaturesEXT::safe_VkPhysicalDeviceScalarBlockLayoutFeaturesEXT(const safe_VkPhysicalDeviceScalarBlockLayoutFeaturesEXT& src)
{
    sType = src.sType;
    scalarBlockLayout = src.scalarBlockLayout;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkPhysicalDeviceScalarBlockLayoutFeaturesEXT& safe_VkPhysicalDeviceScalarBlockLayoutFeaturesEXT::operator=(const safe_VkPhysicalDeviceScalarBlockLayoutFeaturesEXT& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    scalarBlockLayout = src.scalarBlockLayout;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkPhysicalDeviceScalarBlockLayoutFeaturesEXT::~safe_VkPhysicalDeviceScalarBlockLayoutFeaturesEXT()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPhysicalDeviceScalarBlockLayoutFeaturesEXT::initialize(const VkPhysicalDeviceScalarBlockLayoutFeaturesEXT* in_struct)
{
    sType = in_struct->sType;
    scalarBlockLayout = in_struct->scalarBlockLayout;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkPhysicalDeviceScalarBlockLayoutFeaturesEXT::initialize(const safe_VkPhysicalDeviceScalarBlockLayoutFeaturesEXT* src)
{
    sType = src->sType;
    scalarBlockLayout = src->scalarBlockLayout;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkPhysicalDeviceSubgroupSizeControlFeaturesEXT::safe_VkPhysicalDeviceSubgroupSizeControlFeaturesEXT(const VkPhysicalDeviceSubgroupSizeControlFeaturesEXT* in_struct) :
    sType(in_struct->sType),
    subgroupSizeControl(in_struct->subgroupSizeControl),
    computeFullSubgroups(in_struct->computeFullSubgroups)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkPhysicalDeviceSubgroupSizeControlFeaturesEXT::safe_VkPhysicalDeviceSubgroupSizeControlFeaturesEXT() :
    pNext(nullptr)
{}

safe_VkPhysicalDeviceSubgroupSizeControlFeaturesEXT::safe_VkPhysicalDeviceSubgroupSizeControlFeaturesEXT(const safe_VkPhysicalDeviceSubgroupSizeControlFeaturesEXT& src)
{
    sType = src.sType;
    subgroupSizeControl = src.subgroupSizeControl;
    computeFullSubgroups = src.computeFullSubgroups;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkPhysicalDeviceSubgroupSizeControlFeaturesEXT& safe_VkPhysicalDeviceSubgroupSizeControlFeaturesEXT::operator=(const safe_VkPhysicalDeviceSubgroupSizeControlFeaturesEXT& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    subgroupSizeControl = src.subgroupSizeControl;
    computeFullSubgroups = src.computeFullSubgroups;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkPhysicalDeviceSubgroupSizeControlFeaturesEXT::~safe_VkPhysicalDeviceSubgroupSizeControlFeaturesEXT()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPhysicalDeviceSubgroupSizeControlFeaturesEXT::initialize(const VkPhysicalDeviceSubgroupSizeControlFeaturesEXT* in_struct)
{
    sType = in_struct->sType;
    subgroupSizeControl = in_struct->subgroupSizeControl;
    computeFullSubgroups = in_struct->computeFullSubgroups;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkPhysicalDeviceSubgroupSizeControlFeaturesEXT::initialize(const safe_VkPhysicalDeviceSubgroupSizeControlFeaturesEXT* src)
{
    sType = src->sType;
    subgroupSizeControl = src->subgroupSizeControl;
    computeFullSubgroups = src->computeFullSubgroups;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkPhysicalDeviceSubgroupSizeControlPropertiesEXT::safe_VkPhysicalDeviceSubgroupSizeControlPropertiesEXT(const VkPhysicalDeviceSubgroupSizeControlPropertiesEXT* in_struct) :
    sType(in_struct->sType),
    minSubgroupSize(in_struct->minSubgroupSize),
    maxSubgroupSize(in_struct->maxSubgroupSize),
    maxComputeWorkgroupSubgroups(in_struct->maxComputeWorkgroupSubgroups),
    requiredSubgroupSizeStages(in_struct->requiredSubgroupSizeStages)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkPhysicalDeviceSubgroupSizeControlPropertiesEXT::safe_VkPhysicalDeviceSubgroupSizeControlPropertiesEXT() :
    pNext(nullptr)
{}

safe_VkPhysicalDeviceSubgroupSizeControlPropertiesEXT::safe_VkPhysicalDeviceSubgroupSizeControlPropertiesEXT(const safe_VkPhysicalDeviceSubgroupSizeControlPropertiesEXT& src)
{
    sType = src.sType;
    minSubgroupSize = src.minSubgroupSize;
    maxSubgroupSize = src.maxSubgroupSize;
    maxComputeWorkgroupSubgroups = src.maxComputeWorkgroupSubgroups;
    requiredSubgroupSizeStages = src.requiredSubgroupSizeStages;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkPhysicalDeviceSubgroupSizeControlPropertiesEXT& safe_VkPhysicalDeviceSubgroupSizeControlPropertiesEXT::operator=(const safe_VkPhysicalDeviceSubgroupSizeControlPropertiesEXT& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    minSubgroupSize = src.minSubgroupSize;
    maxSubgroupSize = src.maxSubgroupSize;
    maxComputeWorkgroupSubgroups = src.maxComputeWorkgroupSubgroups;
    requiredSubgroupSizeStages = src.requiredSubgroupSizeStages;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkPhysicalDeviceSubgroupSizeControlPropertiesEXT::~safe_VkPhysicalDeviceSubgroupSizeControlPropertiesEXT()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPhysicalDeviceSubgroupSizeControlPropertiesEXT::initialize(const VkPhysicalDeviceSubgroupSizeControlPropertiesEXT* in_struct)
{
    sType = in_struct->sType;
    minSubgroupSize = in_struct->minSubgroupSize;
    maxSubgroupSize = in_struct->maxSubgroupSize;
    maxComputeWorkgroupSubgroups = in_struct->maxComputeWorkgroupSubgroups;
    requiredSubgroupSizeStages = in_struct->requiredSubgroupSizeStages;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkPhysicalDeviceSubgroupSizeControlPropertiesEXT::initialize(const safe_VkPhysicalDeviceSubgroupSizeControlPropertiesEXT* src)
{
    sType = src->sType;
    minSubgroupSize = src->minSubgroupSize;
    maxSubgroupSize = src->maxSubgroupSize;
    maxComputeWorkgroupSubgroups = src->maxComputeWorkgroupSubgroups;
    requiredSubgroupSizeStages = src->requiredSubgroupSizeStages;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkPipelineShaderStageRequiredSubgroupSizeCreateInfoEXT::safe_VkPipelineShaderStageRequiredSubgroupSizeCreateInfoEXT(const VkPipelineShaderStageRequiredSubgroupSizeCreateInfoEXT* in_struct) :
    sType(in_struct->sType),
    requiredSubgroupSize(in_struct->requiredSubgroupSize)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkPipelineShaderStageRequiredSubgroupSizeCreateInfoEXT::safe_VkPipelineShaderStageRequiredSubgroupSizeCreateInfoEXT() :
    pNext(nullptr)
{}

safe_VkPipelineShaderStageRequiredSubgroupSizeCreateInfoEXT::safe_VkPipelineShaderStageRequiredSubgroupSizeCreateInfoEXT(const safe_VkPipelineShaderStageRequiredSubgroupSizeCreateInfoEXT& src)
{
    sType = src.sType;
    requiredSubgroupSize = src.requiredSubgroupSize;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkPipelineShaderStageRequiredSubgroupSizeCreateInfoEXT& safe_VkPipelineShaderStageRequiredSubgroupSizeCreateInfoEXT::operator=(const safe_VkPipelineShaderStageRequiredSubgroupSizeCreateInfoEXT& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    requiredSubgroupSize = src.requiredSubgroupSize;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkPipelineShaderStageRequiredSubgroupSizeCreateInfoEXT::~safe_VkPipelineShaderStageRequiredSubgroupSizeCreateInfoEXT()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPipelineShaderStageRequiredSubgroupSizeCreateInfoEXT::initialize(const VkPipelineShaderStageRequiredSubgroupSizeCreateInfoEXT* in_struct)
{
    sType = in_struct->sType;
    requiredSubgroupSize = in_struct->requiredSubgroupSize;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkPipelineShaderStageRequiredSubgroupSizeCreateInfoEXT::initialize(const safe_VkPipelineShaderStageRequiredSubgroupSizeCreateInfoEXT* src)
{
    sType = src->sType;
    requiredSubgroupSize = src->requiredSubgroupSize;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkPhysicalDeviceShaderCoreProperties2AMD::safe_VkPhysicalDeviceShaderCoreProperties2AMD(const VkPhysicalDeviceShaderCoreProperties2AMD* in_struct) :
    sType(in_struct->sType),
    shaderCoreFeatures(in_struct->shaderCoreFeatures),
    activeComputeUnitCount(in_struct->activeComputeUnitCount)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkPhysicalDeviceShaderCoreProperties2AMD::safe_VkPhysicalDeviceShaderCoreProperties2AMD() :
    pNext(nullptr)
{}

safe_VkPhysicalDeviceShaderCoreProperties2AMD::safe_VkPhysicalDeviceShaderCoreProperties2AMD(const safe_VkPhysicalDeviceShaderCoreProperties2AMD& src)
{
    sType = src.sType;
    shaderCoreFeatures = src.shaderCoreFeatures;
    activeComputeUnitCount = src.activeComputeUnitCount;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkPhysicalDeviceShaderCoreProperties2AMD& safe_VkPhysicalDeviceShaderCoreProperties2AMD::operator=(const safe_VkPhysicalDeviceShaderCoreProperties2AMD& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    shaderCoreFeatures = src.shaderCoreFeatures;
    activeComputeUnitCount = src.activeComputeUnitCount;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkPhysicalDeviceShaderCoreProperties2AMD::~safe_VkPhysicalDeviceShaderCoreProperties2AMD()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPhysicalDeviceShaderCoreProperties2AMD::initialize(const VkPhysicalDeviceShaderCoreProperties2AMD* in_struct)
{
    sType = in_struct->sType;
    shaderCoreFeatures = in_struct->shaderCoreFeatures;
    activeComputeUnitCount = in_struct->activeComputeUnitCount;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkPhysicalDeviceShaderCoreProperties2AMD::initialize(const safe_VkPhysicalDeviceShaderCoreProperties2AMD* src)
{
    sType = src->sType;
    shaderCoreFeatures = src->shaderCoreFeatures;
    activeComputeUnitCount = src->activeComputeUnitCount;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkPhysicalDeviceCoherentMemoryFeaturesAMD::safe_VkPhysicalDeviceCoherentMemoryFeaturesAMD(const VkPhysicalDeviceCoherentMemoryFeaturesAMD* in_struct) :
    sType(in_struct->sType),
    deviceCoherentMemory(in_struct->deviceCoherentMemory)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkPhysicalDeviceCoherentMemoryFeaturesAMD::safe_VkPhysicalDeviceCoherentMemoryFeaturesAMD() :
    pNext(nullptr)
{}

safe_VkPhysicalDeviceCoherentMemoryFeaturesAMD::safe_VkPhysicalDeviceCoherentMemoryFeaturesAMD(const safe_VkPhysicalDeviceCoherentMemoryFeaturesAMD& src)
{
    sType = src.sType;
    deviceCoherentMemory = src.deviceCoherentMemory;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkPhysicalDeviceCoherentMemoryFeaturesAMD& safe_VkPhysicalDeviceCoherentMemoryFeaturesAMD::operator=(const safe_VkPhysicalDeviceCoherentMemoryFeaturesAMD& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    deviceCoherentMemory = src.deviceCoherentMemory;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkPhysicalDeviceCoherentMemoryFeaturesAMD::~safe_VkPhysicalDeviceCoherentMemoryFeaturesAMD()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPhysicalDeviceCoherentMemoryFeaturesAMD::initialize(const VkPhysicalDeviceCoherentMemoryFeaturesAMD* in_struct)
{
    sType = in_struct->sType;
    deviceCoherentMemory = in_struct->deviceCoherentMemory;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkPhysicalDeviceCoherentMemoryFeaturesAMD::initialize(const safe_VkPhysicalDeviceCoherentMemoryFeaturesAMD* src)
{
    sType = src->sType;
    deviceCoherentMemory = src->deviceCoherentMemory;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkPhysicalDeviceMemoryBudgetPropertiesEXT::safe_VkPhysicalDeviceMemoryBudgetPropertiesEXT(const VkPhysicalDeviceMemoryBudgetPropertiesEXT* in_struct) :
    sType(in_struct->sType)
{
    pNext = SafePnextCopy(in_struct->pNext);
    for (uint32_t i = 0; i < VK_MAX_MEMORY_HEAPS; ++i) {
        heapBudget[i] = in_struct->heapBudget[i];
    }
    for (uint32_t i = 0; i < VK_MAX_MEMORY_HEAPS; ++i) {
        heapUsage[i] = in_struct->heapUsage[i];
    }
}

safe_VkPhysicalDeviceMemoryBudgetPropertiesEXT::safe_VkPhysicalDeviceMemoryBudgetPropertiesEXT() :
    pNext(nullptr)
{}

safe_VkPhysicalDeviceMemoryBudgetPropertiesEXT::safe_VkPhysicalDeviceMemoryBudgetPropertiesEXT(const safe_VkPhysicalDeviceMemoryBudgetPropertiesEXT& src)
{
    sType = src.sType;
    pNext = SafePnextCopy(src.pNext);
    for (uint32_t i = 0; i < VK_MAX_MEMORY_HEAPS; ++i) {
        heapBudget[i] = src.heapBudget[i];
    }
    for (uint32_t i = 0; i < VK_MAX_MEMORY_HEAPS; ++i) {
        heapUsage[i] = src.heapUsage[i];
    }
}

safe_VkPhysicalDeviceMemoryBudgetPropertiesEXT& safe_VkPhysicalDeviceMemoryBudgetPropertiesEXT::operator=(const safe_VkPhysicalDeviceMemoryBudgetPropertiesEXT& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    pNext = SafePnextCopy(src.pNext);
    for (uint32_t i = 0; i < VK_MAX_MEMORY_HEAPS; ++i) {
        heapBudget[i] = src.heapBudget[i];
    }
    for (uint32_t i = 0; i < VK_MAX_MEMORY_HEAPS; ++i) {
        heapUsage[i] = src.heapUsage[i];
    }

    return *this;
}

safe_VkPhysicalDeviceMemoryBudgetPropertiesEXT::~safe_VkPhysicalDeviceMemoryBudgetPropertiesEXT()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPhysicalDeviceMemoryBudgetPropertiesEXT::initialize(const VkPhysicalDeviceMemoryBudgetPropertiesEXT* in_struct)
{
    sType = in_struct->sType;
    pNext = SafePnextCopy(in_struct->pNext);
    for (uint32_t i = 0; i < VK_MAX_MEMORY_HEAPS; ++i) {
        heapBudget[i] = in_struct->heapBudget[i];
    }
    for (uint32_t i = 0; i < VK_MAX_MEMORY_HEAPS; ++i) {
        heapUsage[i] = in_struct->heapUsage[i];
    }
}

void safe_VkPhysicalDeviceMemoryBudgetPropertiesEXT::initialize(const safe_VkPhysicalDeviceMemoryBudgetPropertiesEXT* src)
{
    sType = src->sType;
    pNext = SafePnextCopy(src->pNext);
    for (uint32_t i = 0; i < VK_MAX_MEMORY_HEAPS; ++i) {
        heapBudget[i] = src->heapBudget[i];
    }
    for (uint32_t i = 0; i < VK_MAX_MEMORY_HEAPS; ++i) {
        heapUsage[i] = src->heapUsage[i];
    }
}

safe_VkPhysicalDeviceMemoryPriorityFeaturesEXT::safe_VkPhysicalDeviceMemoryPriorityFeaturesEXT(const VkPhysicalDeviceMemoryPriorityFeaturesEXT* in_struct) :
    sType(in_struct->sType),
    memoryPriority(in_struct->memoryPriority)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkPhysicalDeviceMemoryPriorityFeaturesEXT::safe_VkPhysicalDeviceMemoryPriorityFeaturesEXT() :
    pNext(nullptr)
{}

safe_VkPhysicalDeviceMemoryPriorityFeaturesEXT::safe_VkPhysicalDeviceMemoryPriorityFeaturesEXT(const safe_VkPhysicalDeviceMemoryPriorityFeaturesEXT& src)
{
    sType = src.sType;
    memoryPriority = src.memoryPriority;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkPhysicalDeviceMemoryPriorityFeaturesEXT& safe_VkPhysicalDeviceMemoryPriorityFeaturesEXT::operator=(const safe_VkPhysicalDeviceMemoryPriorityFeaturesEXT& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    memoryPriority = src.memoryPriority;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkPhysicalDeviceMemoryPriorityFeaturesEXT::~safe_VkPhysicalDeviceMemoryPriorityFeaturesEXT()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPhysicalDeviceMemoryPriorityFeaturesEXT::initialize(const VkPhysicalDeviceMemoryPriorityFeaturesEXT* in_struct)
{
    sType = in_struct->sType;
    memoryPriority = in_struct->memoryPriority;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkPhysicalDeviceMemoryPriorityFeaturesEXT::initialize(const safe_VkPhysicalDeviceMemoryPriorityFeaturesEXT* src)
{
    sType = src->sType;
    memoryPriority = src->memoryPriority;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkMemoryPriorityAllocateInfoEXT::safe_VkMemoryPriorityAllocateInfoEXT(const VkMemoryPriorityAllocateInfoEXT* in_struct) :
    sType(in_struct->sType),
    priority(in_struct->priority)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkMemoryPriorityAllocateInfoEXT::safe_VkMemoryPriorityAllocateInfoEXT() :
    pNext(nullptr)
{}

safe_VkMemoryPriorityAllocateInfoEXT::safe_VkMemoryPriorityAllocateInfoEXT(const safe_VkMemoryPriorityAllocateInfoEXT& src)
{
    sType = src.sType;
    priority = src.priority;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkMemoryPriorityAllocateInfoEXT& safe_VkMemoryPriorityAllocateInfoEXT::operator=(const safe_VkMemoryPriorityAllocateInfoEXT& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    priority = src.priority;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkMemoryPriorityAllocateInfoEXT::~safe_VkMemoryPriorityAllocateInfoEXT()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkMemoryPriorityAllocateInfoEXT::initialize(const VkMemoryPriorityAllocateInfoEXT* in_struct)
{
    sType = in_struct->sType;
    priority = in_struct->priority;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkMemoryPriorityAllocateInfoEXT::initialize(const safe_VkMemoryPriorityAllocateInfoEXT* src)
{
    sType = src->sType;
    priority = src->priority;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkPhysicalDeviceDedicatedAllocationImageAliasingFeaturesNV::safe_VkPhysicalDeviceDedicatedAllocationImageAliasingFeaturesNV(const VkPhysicalDeviceDedicatedAllocationImageAliasingFeaturesNV* in_struct) :
    sType(in_struct->sType),
    dedicatedAllocationImageAliasing(in_struct->dedicatedAllocationImageAliasing)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkPhysicalDeviceDedicatedAllocationImageAliasingFeaturesNV::safe_VkPhysicalDeviceDedicatedAllocationImageAliasingFeaturesNV() :
    pNext(nullptr)
{}

safe_VkPhysicalDeviceDedicatedAllocationImageAliasingFeaturesNV::safe_VkPhysicalDeviceDedicatedAllocationImageAliasingFeaturesNV(const safe_VkPhysicalDeviceDedicatedAllocationImageAliasingFeaturesNV& src)
{
    sType = src.sType;
    dedicatedAllocationImageAliasing = src.dedicatedAllocationImageAliasing;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkPhysicalDeviceDedicatedAllocationImageAliasingFeaturesNV& safe_VkPhysicalDeviceDedicatedAllocationImageAliasingFeaturesNV::operator=(const safe_VkPhysicalDeviceDedicatedAllocationImageAliasingFeaturesNV& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    dedicatedAllocationImageAliasing = src.dedicatedAllocationImageAliasing;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkPhysicalDeviceDedicatedAllocationImageAliasingFeaturesNV::~safe_VkPhysicalDeviceDedicatedAllocationImageAliasingFeaturesNV()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPhysicalDeviceDedicatedAllocationImageAliasingFeaturesNV::initialize(const VkPhysicalDeviceDedicatedAllocationImageAliasingFeaturesNV* in_struct)
{
    sType = in_struct->sType;
    dedicatedAllocationImageAliasing = in_struct->dedicatedAllocationImageAliasing;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkPhysicalDeviceDedicatedAllocationImageAliasingFeaturesNV::initialize(const safe_VkPhysicalDeviceDedicatedAllocationImageAliasingFeaturesNV* src)
{
    sType = src->sType;
    dedicatedAllocationImageAliasing = src->dedicatedAllocationImageAliasing;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkPhysicalDeviceBufferDeviceAddressFeaturesEXT::safe_VkPhysicalDeviceBufferDeviceAddressFeaturesEXT(const VkPhysicalDeviceBufferDeviceAddressFeaturesEXT* in_struct) :
    sType(in_struct->sType),
    bufferDeviceAddress(in_struct->bufferDeviceAddress),
    bufferDeviceAddressCaptureReplay(in_struct->bufferDeviceAddressCaptureReplay),
    bufferDeviceAddressMultiDevice(in_struct->bufferDeviceAddressMultiDevice)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkPhysicalDeviceBufferDeviceAddressFeaturesEXT::safe_VkPhysicalDeviceBufferDeviceAddressFeaturesEXT() :
    pNext(nullptr)
{}

safe_VkPhysicalDeviceBufferDeviceAddressFeaturesEXT::safe_VkPhysicalDeviceBufferDeviceAddressFeaturesEXT(const safe_VkPhysicalDeviceBufferDeviceAddressFeaturesEXT& src)
{
    sType = src.sType;
    bufferDeviceAddress = src.bufferDeviceAddress;
    bufferDeviceAddressCaptureReplay = src.bufferDeviceAddressCaptureReplay;
    bufferDeviceAddressMultiDevice = src.bufferDeviceAddressMultiDevice;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkPhysicalDeviceBufferDeviceAddressFeaturesEXT& safe_VkPhysicalDeviceBufferDeviceAddressFeaturesEXT::operator=(const safe_VkPhysicalDeviceBufferDeviceAddressFeaturesEXT& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    bufferDeviceAddress = src.bufferDeviceAddress;
    bufferDeviceAddressCaptureReplay = src.bufferDeviceAddressCaptureReplay;
    bufferDeviceAddressMultiDevice = src.bufferDeviceAddressMultiDevice;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkPhysicalDeviceBufferDeviceAddressFeaturesEXT::~safe_VkPhysicalDeviceBufferDeviceAddressFeaturesEXT()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPhysicalDeviceBufferDeviceAddressFeaturesEXT::initialize(const VkPhysicalDeviceBufferDeviceAddressFeaturesEXT* in_struct)
{
    sType = in_struct->sType;
    bufferDeviceAddress = in_struct->bufferDeviceAddress;
    bufferDeviceAddressCaptureReplay = in_struct->bufferDeviceAddressCaptureReplay;
    bufferDeviceAddressMultiDevice = in_struct->bufferDeviceAddressMultiDevice;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkPhysicalDeviceBufferDeviceAddressFeaturesEXT::initialize(const safe_VkPhysicalDeviceBufferDeviceAddressFeaturesEXT* src)
{
    sType = src->sType;
    bufferDeviceAddress = src->bufferDeviceAddress;
    bufferDeviceAddressCaptureReplay = src->bufferDeviceAddressCaptureReplay;
    bufferDeviceAddressMultiDevice = src->bufferDeviceAddressMultiDevice;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkBufferDeviceAddressInfoEXT::safe_VkBufferDeviceAddressInfoEXT(const VkBufferDeviceAddressInfoEXT* in_struct) :
    sType(in_struct->sType),
    buffer(in_struct->buffer)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkBufferDeviceAddressInfoEXT::safe_VkBufferDeviceAddressInfoEXT() :
    pNext(nullptr)
{}

safe_VkBufferDeviceAddressInfoEXT::safe_VkBufferDeviceAddressInfoEXT(const safe_VkBufferDeviceAddressInfoEXT& src)
{
    sType = src.sType;
    buffer = src.buffer;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkBufferDeviceAddressInfoEXT& safe_VkBufferDeviceAddressInfoEXT::operator=(const safe_VkBufferDeviceAddressInfoEXT& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    buffer = src.buffer;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkBufferDeviceAddressInfoEXT::~safe_VkBufferDeviceAddressInfoEXT()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkBufferDeviceAddressInfoEXT::initialize(const VkBufferDeviceAddressInfoEXT* in_struct)
{
    sType = in_struct->sType;
    buffer = in_struct->buffer;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkBufferDeviceAddressInfoEXT::initialize(const safe_VkBufferDeviceAddressInfoEXT* src)
{
    sType = src->sType;
    buffer = src->buffer;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkBufferDeviceAddressCreateInfoEXT::safe_VkBufferDeviceAddressCreateInfoEXT(const VkBufferDeviceAddressCreateInfoEXT* in_struct) :
    sType(in_struct->sType),
    deviceAddress(in_struct->deviceAddress)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkBufferDeviceAddressCreateInfoEXT::safe_VkBufferDeviceAddressCreateInfoEXT() :
    pNext(nullptr)
{}

safe_VkBufferDeviceAddressCreateInfoEXT::safe_VkBufferDeviceAddressCreateInfoEXT(const safe_VkBufferDeviceAddressCreateInfoEXT& src)
{
    sType = src.sType;
    deviceAddress = src.deviceAddress;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkBufferDeviceAddressCreateInfoEXT& safe_VkBufferDeviceAddressCreateInfoEXT::operator=(const safe_VkBufferDeviceAddressCreateInfoEXT& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    deviceAddress = src.deviceAddress;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkBufferDeviceAddressCreateInfoEXT::~safe_VkBufferDeviceAddressCreateInfoEXT()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkBufferDeviceAddressCreateInfoEXT::initialize(const VkBufferDeviceAddressCreateInfoEXT* in_struct)
{
    sType = in_struct->sType;
    deviceAddress = in_struct->deviceAddress;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkBufferDeviceAddressCreateInfoEXT::initialize(const safe_VkBufferDeviceAddressCreateInfoEXT* src)
{
    sType = src->sType;
    deviceAddress = src->deviceAddress;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkImageStencilUsageCreateInfoEXT::safe_VkImageStencilUsageCreateInfoEXT(const VkImageStencilUsageCreateInfoEXT* in_struct) :
    sType(in_struct->sType),
    stencilUsage(in_struct->stencilUsage)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkImageStencilUsageCreateInfoEXT::safe_VkImageStencilUsageCreateInfoEXT() :
    pNext(nullptr)
{}

safe_VkImageStencilUsageCreateInfoEXT::safe_VkImageStencilUsageCreateInfoEXT(const safe_VkImageStencilUsageCreateInfoEXT& src)
{
    sType = src.sType;
    stencilUsage = src.stencilUsage;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkImageStencilUsageCreateInfoEXT& safe_VkImageStencilUsageCreateInfoEXT::operator=(const safe_VkImageStencilUsageCreateInfoEXT& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    stencilUsage = src.stencilUsage;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkImageStencilUsageCreateInfoEXT::~safe_VkImageStencilUsageCreateInfoEXT()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkImageStencilUsageCreateInfoEXT::initialize(const VkImageStencilUsageCreateInfoEXT* in_struct)
{
    sType = in_struct->sType;
    stencilUsage = in_struct->stencilUsage;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkImageStencilUsageCreateInfoEXT::initialize(const safe_VkImageStencilUsageCreateInfoEXT* src)
{
    sType = src->sType;
    stencilUsage = src->stencilUsage;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkValidationFeaturesEXT::safe_VkValidationFeaturesEXT(const VkValidationFeaturesEXT* in_struct) :
    sType(in_struct->sType),
    enabledValidationFeatureCount(in_struct->enabledValidationFeatureCount),
    pEnabledValidationFeatures(nullptr),
    disabledValidationFeatureCount(in_struct->disabledValidationFeatureCount),
    pDisabledValidationFeatures(nullptr)
{
    pNext = SafePnextCopy(in_struct->pNext);
    if (in_struct->pEnabledValidationFeatures) {
        pEnabledValidationFeatures = new VkValidationFeatureEnableEXT[in_struct->enabledValidationFeatureCount];
        memcpy ((void *)pEnabledValidationFeatures, (void *)in_struct->pEnabledValidationFeatures, sizeof(VkValidationFeatureEnableEXT)*in_struct->enabledValidationFeatureCount);
    }
    if (in_struct->pDisabledValidationFeatures) {
        pDisabledValidationFeatures = new VkValidationFeatureDisableEXT[in_struct->disabledValidationFeatureCount];
        memcpy ((void *)pDisabledValidationFeatures, (void *)in_struct->pDisabledValidationFeatures, sizeof(VkValidationFeatureDisableEXT)*in_struct->disabledValidationFeatureCount);
    }
}

safe_VkValidationFeaturesEXT::safe_VkValidationFeaturesEXT() :
    pNext(nullptr),
    pEnabledValidationFeatures(nullptr),
    pDisabledValidationFeatures(nullptr)
{}

safe_VkValidationFeaturesEXT::safe_VkValidationFeaturesEXT(const safe_VkValidationFeaturesEXT& src)
{
    sType = src.sType;
    enabledValidationFeatureCount = src.enabledValidationFeatureCount;
    pEnabledValidationFeatures = nullptr;
    disabledValidationFeatureCount = src.disabledValidationFeatureCount;
    pDisabledValidationFeatures = nullptr;
    pNext = SafePnextCopy(src.pNext);
    if (src.pEnabledValidationFeatures) {
        pEnabledValidationFeatures = new VkValidationFeatureEnableEXT[src.enabledValidationFeatureCount];
        memcpy ((void *)pEnabledValidationFeatures, (void *)src.pEnabledValidationFeatures, sizeof(VkValidationFeatureEnableEXT)*src.enabledValidationFeatureCount);
    }
    if (src.pDisabledValidationFeatures) {
        pDisabledValidationFeatures = new VkValidationFeatureDisableEXT[src.disabledValidationFeatureCount];
        memcpy ((void *)pDisabledValidationFeatures, (void *)src.pDisabledValidationFeatures, sizeof(VkValidationFeatureDisableEXT)*src.disabledValidationFeatureCount);
    }
}

safe_VkValidationFeaturesEXT& safe_VkValidationFeaturesEXT::operator=(const safe_VkValidationFeaturesEXT& src)
{
    if (&src == this) return *this;

    if (pEnabledValidationFeatures)
        delete[] pEnabledValidationFeatures;
    if (pDisabledValidationFeatures)
        delete[] pDisabledValidationFeatures;
    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    enabledValidationFeatureCount = src.enabledValidationFeatureCount;
    pEnabledValidationFeatures = nullptr;
    disabledValidationFeatureCount = src.disabledValidationFeatureCount;
    pDisabledValidationFeatures = nullptr;
    pNext = SafePnextCopy(src.pNext);
    if (src.pEnabledValidationFeatures) {
        pEnabledValidationFeatures = new VkValidationFeatureEnableEXT[src.enabledValidationFeatureCount];
        memcpy ((void *)pEnabledValidationFeatures, (void *)src.pEnabledValidationFeatures, sizeof(VkValidationFeatureEnableEXT)*src.enabledValidationFeatureCount);
    }
    if (src.pDisabledValidationFeatures) {
        pDisabledValidationFeatures = new VkValidationFeatureDisableEXT[src.disabledValidationFeatureCount];
        memcpy ((void *)pDisabledValidationFeatures, (void *)src.pDisabledValidationFeatures, sizeof(VkValidationFeatureDisableEXT)*src.disabledValidationFeatureCount);
    }

    return *this;
}

safe_VkValidationFeaturesEXT::~safe_VkValidationFeaturesEXT()
{
    if (pEnabledValidationFeatures)
        delete[] pEnabledValidationFeatures;
    if (pDisabledValidationFeatures)
        delete[] pDisabledValidationFeatures;
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkValidationFeaturesEXT::initialize(const VkValidationFeaturesEXT* in_struct)
{
    sType = in_struct->sType;
    enabledValidationFeatureCount = in_struct->enabledValidationFeatureCount;
    pEnabledValidationFeatures = nullptr;
    disabledValidationFeatureCount = in_struct->disabledValidationFeatureCount;
    pDisabledValidationFeatures = nullptr;
    pNext = SafePnextCopy(in_struct->pNext);
    if (in_struct->pEnabledValidationFeatures) {
        pEnabledValidationFeatures = new VkValidationFeatureEnableEXT[in_struct->enabledValidationFeatureCount];
        memcpy ((void *)pEnabledValidationFeatures, (void *)in_struct->pEnabledValidationFeatures, sizeof(VkValidationFeatureEnableEXT)*in_struct->enabledValidationFeatureCount);
    }
    if (in_struct->pDisabledValidationFeatures) {
        pDisabledValidationFeatures = new VkValidationFeatureDisableEXT[in_struct->disabledValidationFeatureCount];
        memcpy ((void *)pDisabledValidationFeatures, (void *)in_struct->pDisabledValidationFeatures, sizeof(VkValidationFeatureDisableEXT)*in_struct->disabledValidationFeatureCount);
    }
}

void safe_VkValidationFeaturesEXT::initialize(const safe_VkValidationFeaturesEXT* src)
{
    sType = src->sType;
    enabledValidationFeatureCount = src->enabledValidationFeatureCount;
    pEnabledValidationFeatures = nullptr;
    disabledValidationFeatureCount = src->disabledValidationFeatureCount;
    pDisabledValidationFeatures = nullptr;
    pNext = SafePnextCopy(src->pNext);
    if (src->pEnabledValidationFeatures) {
        pEnabledValidationFeatures = new VkValidationFeatureEnableEXT[src->enabledValidationFeatureCount];
        memcpy ((void *)pEnabledValidationFeatures, (void *)src->pEnabledValidationFeatures, sizeof(VkValidationFeatureEnableEXT)*src->enabledValidationFeatureCount);
    }
    if (src->pDisabledValidationFeatures) {
        pDisabledValidationFeatures = new VkValidationFeatureDisableEXT[src->disabledValidationFeatureCount];
        memcpy ((void *)pDisabledValidationFeatures, (void *)src->pDisabledValidationFeatures, sizeof(VkValidationFeatureDisableEXT)*src->disabledValidationFeatureCount);
    }
}

safe_VkCooperativeMatrixPropertiesNV::safe_VkCooperativeMatrixPropertiesNV(const VkCooperativeMatrixPropertiesNV* in_struct) :
    sType(in_struct->sType),
    MSize(in_struct->MSize),
    NSize(in_struct->NSize),
    KSize(in_struct->KSize),
    AType(in_struct->AType),
    BType(in_struct->BType),
    CType(in_struct->CType),
    DType(in_struct->DType),
    scope(in_struct->scope)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkCooperativeMatrixPropertiesNV::safe_VkCooperativeMatrixPropertiesNV() :
    pNext(nullptr)
{}

safe_VkCooperativeMatrixPropertiesNV::safe_VkCooperativeMatrixPropertiesNV(const safe_VkCooperativeMatrixPropertiesNV& src)
{
    sType = src.sType;
    MSize = src.MSize;
    NSize = src.NSize;
    KSize = src.KSize;
    AType = src.AType;
    BType = src.BType;
    CType = src.CType;
    DType = src.DType;
    scope = src.scope;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkCooperativeMatrixPropertiesNV& safe_VkCooperativeMatrixPropertiesNV::operator=(const safe_VkCooperativeMatrixPropertiesNV& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    MSize = src.MSize;
    NSize = src.NSize;
    KSize = src.KSize;
    AType = src.AType;
    BType = src.BType;
    CType = src.CType;
    DType = src.DType;
    scope = src.scope;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkCooperativeMatrixPropertiesNV::~safe_VkCooperativeMatrixPropertiesNV()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkCooperativeMatrixPropertiesNV::initialize(const VkCooperativeMatrixPropertiesNV* in_struct)
{
    sType = in_struct->sType;
    MSize = in_struct->MSize;
    NSize = in_struct->NSize;
    KSize = in_struct->KSize;
    AType = in_struct->AType;
    BType = in_struct->BType;
    CType = in_struct->CType;
    DType = in_struct->DType;
    scope = in_struct->scope;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkCooperativeMatrixPropertiesNV::initialize(const safe_VkCooperativeMatrixPropertiesNV* src)
{
    sType = src->sType;
    MSize = src->MSize;
    NSize = src->NSize;
    KSize = src->KSize;
    AType = src->AType;
    BType = src->BType;
    CType = src->CType;
    DType = src->DType;
    scope = src->scope;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkPhysicalDeviceCooperativeMatrixFeaturesNV::safe_VkPhysicalDeviceCooperativeMatrixFeaturesNV(const VkPhysicalDeviceCooperativeMatrixFeaturesNV* in_struct) :
    sType(in_struct->sType),
    cooperativeMatrix(in_struct->cooperativeMatrix),
    cooperativeMatrixRobustBufferAccess(in_struct->cooperativeMatrixRobustBufferAccess)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkPhysicalDeviceCooperativeMatrixFeaturesNV::safe_VkPhysicalDeviceCooperativeMatrixFeaturesNV() :
    pNext(nullptr)
{}

safe_VkPhysicalDeviceCooperativeMatrixFeaturesNV::safe_VkPhysicalDeviceCooperativeMatrixFeaturesNV(const safe_VkPhysicalDeviceCooperativeMatrixFeaturesNV& src)
{
    sType = src.sType;
    cooperativeMatrix = src.cooperativeMatrix;
    cooperativeMatrixRobustBufferAccess = src.cooperativeMatrixRobustBufferAccess;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkPhysicalDeviceCooperativeMatrixFeaturesNV& safe_VkPhysicalDeviceCooperativeMatrixFeaturesNV::operator=(const safe_VkPhysicalDeviceCooperativeMatrixFeaturesNV& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    cooperativeMatrix = src.cooperativeMatrix;
    cooperativeMatrixRobustBufferAccess = src.cooperativeMatrixRobustBufferAccess;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkPhysicalDeviceCooperativeMatrixFeaturesNV::~safe_VkPhysicalDeviceCooperativeMatrixFeaturesNV()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPhysicalDeviceCooperativeMatrixFeaturesNV::initialize(const VkPhysicalDeviceCooperativeMatrixFeaturesNV* in_struct)
{
    sType = in_struct->sType;
    cooperativeMatrix = in_struct->cooperativeMatrix;
    cooperativeMatrixRobustBufferAccess = in_struct->cooperativeMatrixRobustBufferAccess;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkPhysicalDeviceCooperativeMatrixFeaturesNV::initialize(const safe_VkPhysicalDeviceCooperativeMatrixFeaturesNV* src)
{
    sType = src->sType;
    cooperativeMatrix = src->cooperativeMatrix;
    cooperativeMatrixRobustBufferAccess = src->cooperativeMatrixRobustBufferAccess;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkPhysicalDeviceCooperativeMatrixPropertiesNV::safe_VkPhysicalDeviceCooperativeMatrixPropertiesNV(const VkPhysicalDeviceCooperativeMatrixPropertiesNV* in_struct) :
    sType(in_struct->sType),
    cooperativeMatrixSupportedStages(in_struct->cooperativeMatrixSupportedStages)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkPhysicalDeviceCooperativeMatrixPropertiesNV::safe_VkPhysicalDeviceCooperativeMatrixPropertiesNV() :
    pNext(nullptr)
{}

safe_VkPhysicalDeviceCooperativeMatrixPropertiesNV::safe_VkPhysicalDeviceCooperativeMatrixPropertiesNV(const safe_VkPhysicalDeviceCooperativeMatrixPropertiesNV& src)
{
    sType = src.sType;
    cooperativeMatrixSupportedStages = src.cooperativeMatrixSupportedStages;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkPhysicalDeviceCooperativeMatrixPropertiesNV& safe_VkPhysicalDeviceCooperativeMatrixPropertiesNV::operator=(const safe_VkPhysicalDeviceCooperativeMatrixPropertiesNV& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    cooperativeMatrixSupportedStages = src.cooperativeMatrixSupportedStages;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkPhysicalDeviceCooperativeMatrixPropertiesNV::~safe_VkPhysicalDeviceCooperativeMatrixPropertiesNV()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPhysicalDeviceCooperativeMatrixPropertiesNV::initialize(const VkPhysicalDeviceCooperativeMatrixPropertiesNV* in_struct)
{
    sType = in_struct->sType;
    cooperativeMatrixSupportedStages = in_struct->cooperativeMatrixSupportedStages;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkPhysicalDeviceCooperativeMatrixPropertiesNV::initialize(const safe_VkPhysicalDeviceCooperativeMatrixPropertiesNV* src)
{
    sType = src->sType;
    cooperativeMatrixSupportedStages = src->cooperativeMatrixSupportedStages;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkPhysicalDeviceCoverageReductionModeFeaturesNV::safe_VkPhysicalDeviceCoverageReductionModeFeaturesNV(const VkPhysicalDeviceCoverageReductionModeFeaturesNV* in_struct) :
    sType(in_struct->sType),
    coverageReductionMode(in_struct->coverageReductionMode)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkPhysicalDeviceCoverageReductionModeFeaturesNV::safe_VkPhysicalDeviceCoverageReductionModeFeaturesNV() :
    pNext(nullptr)
{}

safe_VkPhysicalDeviceCoverageReductionModeFeaturesNV::safe_VkPhysicalDeviceCoverageReductionModeFeaturesNV(const safe_VkPhysicalDeviceCoverageReductionModeFeaturesNV& src)
{
    sType = src.sType;
    coverageReductionMode = src.coverageReductionMode;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkPhysicalDeviceCoverageReductionModeFeaturesNV& safe_VkPhysicalDeviceCoverageReductionModeFeaturesNV::operator=(const safe_VkPhysicalDeviceCoverageReductionModeFeaturesNV& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    coverageReductionMode = src.coverageReductionMode;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkPhysicalDeviceCoverageReductionModeFeaturesNV::~safe_VkPhysicalDeviceCoverageReductionModeFeaturesNV()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPhysicalDeviceCoverageReductionModeFeaturesNV::initialize(const VkPhysicalDeviceCoverageReductionModeFeaturesNV* in_struct)
{
    sType = in_struct->sType;
    coverageReductionMode = in_struct->coverageReductionMode;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkPhysicalDeviceCoverageReductionModeFeaturesNV::initialize(const safe_VkPhysicalDeviceCoverageReductionModeFeaturesNV* src)
{
    sType = src->sType;
    coverageReductionMode = src->coverageReductionMode;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkPipelineCoverageReductionStateCreateInfoNV::safe_VkPipelineCoverageReductionStateCreateInfoNV(const VkPipelineCoverageReductionStateCreateInfoNV* in_struct) :
    sType(in_struct->sType),
    flags(in_struct->flags),
    coverageReductionMode(in_struct->coverageReductionMode)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkPipelineCoverageReductionStateCreateInfoNV::safe_VkPipelineCoverageReductionStateCreateInfoNV() :
    pNext(nullptr)
{}

safe_VkPipelineCoverageReductionStateCreateInfoNV::safe_VkPipelineCoverageReductionStateCreateInfoNV(const safe_VkPipelineCoverageReductionStateCreateInfoNV& src)
{
    sType = src.sType;
    flags = src.flags;
    coverageReductionMode = src.coverageReductionMode;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkPipelineCoverageReductionStateCreateInfoNV& safe_VkPipelineCoverageReductionStateCreateInfoNV::operator=(const safe_VkPipelineCoverageReductionStateCreateInfoNV& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    flags = src.flags;
    coverageReductionMode = src.coverageReductionMode;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkPipelineCoverageReductionStateCreateInfoNV::~safe_VkPipelineCoverageReductionStateCreateInfoNV()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPipelineCoverageReductionStateCreateInfoNV::initialize(const VkPipelineCoverageReductionStateCreateInfoNV* in_struct)
{
    sType = in_struct->sType;
    flags = in_struct->flags;
    coverageReductionMode = in_struct->coverageReductionMode;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkPipelineCoverageReductionStateCreateInfoNV::initialize(const safe_VkPipelineCoverageReductionStateCreateInfoNV* src)
{
    sType = src->sType;
    flags = src->flags;
    coverageReductionMode = src->coverageReductionMode;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkFramebufferMixedSamplesCombinationNV::safe_VkFramebufferMixedSamplesCombinationNV(const VkFramebufferMixedSamplesCombinationNV* in_struct) :
    sType(in_struct->sType),
    coverageReductionMode(in_struct->coverageReductionMode),
    rasterizationSamples(in_struct->rasterizationSamples),
    depthStencilSamples(in_struct->depthStencilSamples),
    colorSamples(in_struct->colorSamples)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkFramebufferMixedSamplesCombinationNV::safe_VkFramebufferMixedSamplesCombinationNV() :
    pNext(nullptr)
{}

safe_VkFramebufferMixedSamplesCombinationNV::safe_VkFramebufferMixedSamplesCombinationNV(const safe_VkFramebufferMixedSamplesCombinationNV& src)
{
    sType = src.sType;
    coverageReductionMode = src.coverageReductionMode;
    rasterizationSamples = src.rasterizationSamples;
    depthStencilSamples = src.depthStencilSamples;
    colorSamples = src.colorSamples;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkFramebufferMixedSamplesCombinationNV& safe_VkFramebufferMixedSamplesCombinationNV::operator=(const safe_VkFramebufferMixedSamplesCombinationNV& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    coverageReductionMode = src.coverageReductionMode;
    rasterizationSamples = src.rasterizationSamples;
    depthStencilSamples = src.depthStencilSamples;
    colorSamples = src.colorSamples;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkFramebufferMixedSamplesCombinationNV::~safe_VkFramebufferMixedSamplesCombinationNV()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkFramebufferMixedSamplesCombinationNV::initialize(const VkFramebufferMixedSamplesCombinationNV* in_struct)
{
    sType = in_struct->sType;
    coverageReductionMode = in_struct->coverageReductionMode;
    rasterizationSamples = in_struct->rasterizationSamples;
    depthStencilSamples = in_struct->depthStencilSamples;
    colorSamples = in_struct->colorSamples;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkFramebufferMixedSamplesCombinationNV::initialize(const safe_VkFramebufferMixedSamplesCombinationNV* src)
{
    sType = src->sType;
    coverageReductionMode = src->coverageReductionMode;
    rasterizationSamples = src->rasterizationSamples;
    depthStencilSamples = src->depthStencilSamples;
    colorSamples = src->colorSamples;
    pNext = SafePnextCopy(src->pNext);
}

safe_VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT::safe_VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT(const VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT* in_struct) :
    sType(in_struct->sType),
    fragmentShaderSampleInterlock(in_struct->fragmentShaderSampleInterlock),
    fragmentShaderPixelInterlock(in_struct->fragmentShaderPixelInterlock),
    fragmentShaderShadingRateInterlock(in_struct->fragmentShaderShadingRateInterlock)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT::safe_VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT() :
    pNext(nullptr)
{}

safe_VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT::safe_VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT(const safe_VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT& src)
{
    sType = src.sType;
    fragmentShaderSampleInterlock = src.fragmentShaderSampleInterlock;
    fragmentShaderPixelInterlock = src.fragmentShaderPixelInterlock;
    fragmentShaderShadingRateInterlock = src.fragmentShaderShadingRateInterlock;
    pNext = SafePnextCopy(src.pNext);
}

safe_VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT& safe_VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT::operator=(const safe_VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT& src)
{
    if (&src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = src.sType;
    fragmentShaderSampleInterlock = src.fragmentShaderSampleInterlock;
    fragmentShaderPixelInterlock = src.fragmentShaderPixelInterlock;
    fragmentShaderShadingRateInterlock = src.fragmentShaderShadingRateInterlock;
    pNext = SafePnextCopy(src.pNext);

    return *this;
}

safe_VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT::~safe_VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT::initialize(const VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT* in_struct)
{
    sType = in_struct->sType;
    fragmentShaderSampleInterlock = in_struct->fragmentShaderSampleInterlock;
    fragmentShaderPixelInterlock = in_struct->fragmentShaderPixelInterlock;
    fragmentShaderShadingRateInterlock = in_struct->fragmentShaderShadingRateInterlock;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT::initialize(const safe_VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT* src)
{
    sType = src->sType;
    fragmentShaderSampleInterlock = src->fragmentShaderSampleInterlock;
    fragmentShaderPixelInterlock = src->fragmentShaderPixelInterlock;
    fragmentShaderShadingRateInterlock = src->fragmentShaderShadingRateInterlock