# Generating vulkan_wrapper

The script for generating the vulkan_wrapper is based on the work done by @olvaffe for Hologram's dispatch table:
https://github.com/LunarG/VulkanSamples/blob/master/Sample-Programs/Hologram/generate-dispatch-table

The wrapper is used to support applications that don't want to link directly against libvulkan.so, which is not
present on Android before 7.0 (Nougat).

The wrapper only contains core functions and WSI extensions.

To regenerate the wrappers:

    cd scripts
    pushd ../Vulkan-Headers/include/vulkan
    ../../../scripts/generate_vulkan_wrapper.py parse vulkan.h > parsed_header

Copy contents of parsed_header into generate_vulkan_wrapper.py between the sections that read:

    # generated by "generate_vulkan_wrapper.py parse vulkan.h"
    # end of generated code

Then run the script:

    popd
    ./generate_vulkan_wrapper.py ../common/vulkan_wrapper.h
    ./generate_vulkan_wrapper.py ../common/vulkan_wrapper.cpp
    clang-format -i vulkan_wrapper.h
    clang-format -i vulkan_wrapper.cpp
