# PEGTL Documentation

* [Project](https://github.com/ColinH/PEGTL)
* [Getting Started](Getting-Started.md)
  * [Hello, world!](Getting-Started.md#hello-world)
  * [Requirements](Getting-Started.md#requirements)
  * [Compilation](Getting-Started.md#compilation)
  * [Limitations](Getting-Started.md#limitations)
* [Rules and Grammars](Rules-and-Grammars.md)
  * [Combining Existing Rules](Rules-and-Grammars.md#combining-existing-rules)
* [Actions and States](Actions-and-States.md)
  * [Actions](Actions-and-States.md#actions)
  * [States](Actions-and-States.md#states)
  * [Action Specialisation](Actions-and-States.md#action-specialisation)
  * [Changing Actions](Actions-and-States.md#changing-actions)
* [Errors and Exceptions](Errors-and-Exceptions.md)
  * [Failure](Errors-and-Exceptions.md#failure)
  * [Error Messages](Errors-and-Exceptions.md#error-messages)
* [Rule Reference](Rule-Reference.md)
  * [Meta Rules](Rule-Reference.md#meta-rules)
  * [Combinators](Rule-Reference.md#combinators)
  * [Convenience](Rule-Reference.md#convenience)
  * [Atomic Rules](Rule-Reference.md#atomic-rules)
  * [ASCII Rules](Rule-Reference.md#ascii-rules)
  * [UTF-8 Rules](Rule-Reference.md#utf-8-rules)
  * [UTF-16 Rules](Rule-Reference.md#utf-16-rules)
  * [UTF-32 Rules](Rule-Reference.md#utf-32-rules)
  * [Full Index](Rule-Reference.md#full-index)
* [Parser Reference](Parser-Reference.md)
  * [Input Data](Parser-Reference.md#input-data)
  * [Parser Functions](Parser-Reference.md#parser-functions)
  * [Tracer Functions](Parser-Reference.md#tracer-functions)
  * [Parser Classes](Parser-Reference.md#parser-classes)
* [Incremental Input](Incremental-Input.md)
* [Contrib and Examples](Contrib-and-Examples.md)
  * [Contrib](Contrib-and-Examples.md#contrib)
  * [Examples](Contrib-and-Examples.md#examples)
* [Control Hooks](Control-Hooks.md)
  * [Normal Control](Control-Hooks.md#normal-control)
  * [Debug Functions](Control-Hooks.md#debug-functions)
  * [Exception Throwing](Control-Hooks.md#exception-throwing)
  * [Debugging and Tracing](Control-Hooks.md#debugging-and-tracing)
  * [Advanced Control](Control-Hooks.md#advanced-control)
  * [Changing Control](Control-Hooks.md#changing-control)
* [Advanced Rules](Advanced-Rules.md)
  * [Simple Rules](Advanced-Rules.md#simple-rules)
  * [Complex Rules](Advanced-Rules.md#complex-rules)
* [Switching Style](Switching-Style.md)
* [Grammar Analysis](Grammar-Analysis.md)
* [Calculator Example](Calculator-Example.md)
* [Changelog](Changelog.md)
* [2014 Refactoring](2014-Refactoring.md)

Copyright (c) 2014-2016 Dr. Colin Hirsch and Daniel Frey
