.\" $Copyright: $
.\" Copyright (c) 1996 - 2001 by Steve Baker
.\" All Rights reserved
.\"
.\" This software is provided as is without any express or implied
.\" warranties, including, without limitation, the implied warranties
.\" of merchantability and fitness for a particular purpose.
.\"
...
.V= $Header: tree.1 1.4 1996 - 2001 $
.TH TREE 1 "\*(V)" "Manuel du Programmeur UNIX"
.SH NOM
tree \- liste le contenu de rpertoires sous forme d'arborescence
.SH SYNOPSIS
\fBtree\fP [ \fB-adfgilnopqstuxACDFNS\fP ] [ \fB-L\fP \fIniveau\fP [ \fB-R\fP ]] [ \fB-H\fP \fIbaseHREF\fP ] [ \fB-P\fP \fImotif\fP ] [ \fB-I\fP \fImotif\fP ] [ \fIrepertoire\fP ... ]
.br
.SH DESCRIPTION
\fITree\fP est un programme de listage rcursif de rpertoires qui produit
un listage des fichiers indent en profondeur, qui est mis en couleurs  la
manire de \fIdircolors\fP si la variable d'environnement \fBLS_COLORS\fP
est active et que la sortie est un tty. Sans arguments, \fItree\fP liste
les fichiers contenus dans le rpertoire courant. Lorsque des rpertoires
sont donns en argument, \fItree\fP liste tous les fichiers et/ou
rpertoires trouvs dans les rpertoires donns, chacun  son tour. Aprs
avoir affich tous les fichiers et rpertoires trouvs, \fItree\fP renvoie
le nombre total de fichiers et/ou de rpertoires lists. 

Par dfaut, quand un lien symbolique est rencontr, la chemin auquel il
renvoie est affich aprs le nom du lien sous la forme suivante\ :

.br

    nom -> chemin-reel
.br

Si l'on donne l'option `\fB-l\fP' et que le lien symbolique renvoie  un
rpertoire existant, \fItree\fP suivra le chemin du lien symbolique
comme s'il s'agissait d'un vritable rpertoire.

.br

.SH OPTIONS
\fITree\fP comprend les commutateurs suivants en ligne de commande\ :

.TP
.B --help
Donne en sortie un listage verbeux des options d'utilisation
.PP
.TP
.B --version
Sort la version de tree
.PP
.TP
.B --inodes
Affiche le numro d'inode du fichier ou du rpertoire
.PP
.TP
.B --device
Affiche le numro de priphrique auquel le fichier ou le rpertoire
appartient 
.PP
.TP
.B --noreport
Omet d'afficher le compte des fichiers et rpertoires  la fin du listage
arborescent 
.PP
.TP
.B --nolinks
Dsactive les hyperliens en sortie HTML
.PP
.TP
.B -a
Tous les fichiers sont affichs. Par dfaut tree n'affiche pas les fichiers
cachs (ceux qui commencent par un point `.'). En aucun cas, tree n'affiche
les constructeurs de systme de fichiers `.' (rpertoire courant) et `..'
(rpertoire parent). 
.PP
.TP
.B -d
Liste uniquement les rpertoires
.PP
.TP
.B -f
Affiche le chemin complet en prfixe de chaque fichier
.PP
.TP
.B -i
Fait que tree n'affiche pas les lignes d'indentation, ce qui est utile en
conjonction avec l'option \fB-f\fP
.PP
.TP
.B -l
Suit les liens symboliques s'ils pointent sur des rpertoires, comme
s'ils taient des rpertoires. Les liens symboliques qui finiraient de
faon rcursive sont vits, une fois dtects
.PP
.TP
.B -x
Reste exclusivement dans le systme de fichiers courant,  la manire de
\fBfind \fI-xdev\fP
.PP
.TP
\fB-P \fImotif\fP
Liste exclusivement les fichiers correspondant au joker
\fImotif\fP. Remarque\ : vous devez utiliser l'option \fI-a\fP pour prendre 
galement en considration les fichiers commenant par un point `.'. Les
oprateurs de joker valides sont `*' (zro caractre ou plus), `?'
(n'importe quel caractre), `[...]' (n'importe quel caractre parmi ceux
qui sont lists entre crochets (un tiret `-' optionnel peut tre utilis
pour une plage de caractres\ ; par exemple\ : [A-Z])), et `[^...]'
(n'importe quel caractre  l'exclusion de ceux qui sont lists entre
crochets). 
.PP
.TP
.B -I \fImotif\fP
Ne pas lister les fichiers correspondant au joker \fImotif\fP
.PP
.TP
.B -p
Afficher les protections pour chaque fichier (comme avec ls -l)
.PP
.TP
.B -o \fInom-de-fichier\fP
Envoie la sortie vers \fInom-de-fichier\fP
.PP
.TP
.B -s
Affiche la taille de chaque fichier devant son nom
.PP
.TP
.B -u
Affiche le nom d'utilisateur du fichier, ou le numro d'UID si aucun nom
d'utilisateur n'est disponible 
.PP
.TP
.B -g
Affiche le nom de groupe du fichier, ou le numro de GID si aucun nom de
groupe n'est disponible 
.PP
.TP
.B -D
Affiche la date et l'heure de dernire modification du fichier
.PP
.TP
.B -F
Appose un `/' pour les rpertoires, un `=' pour les fichiers de socket, un
`*' pour les fichiers excutables et un `|' pour les FIFO, comme avec ls\ -F 
.PP
.TP
.B -q
Affiche les caractres non affichables dans les noms de fichiers sous forme
de points d'interrogation au lieu de la notation carret par dfaut 
.PP
.TP
.B -N
Affiche les caractres non affichables tels quels au lieu de la notation
carret par dfaut
.PP
.TP
.B -t
Trie la sortie par horaire de dernire modification, au lieu de trier
alphabtiquement 
.PP
.TP
.B -n
Dsactive toujours la mise en couleurs, force par l'option \fB-C\fP
.PP
.TP
.B -C
Active toujours la mise en couleurs, au moyen des couleurs intgres par
dfaut si la variable d'environnement LS_COLORS n'est pas active. Utile
pour mettre en couleurs la sortie vers un tube.
.PP
.TP
.B -A
Active le graphisme ANSI de lignes pour l'affichage des lignes
d'indentation 
.PP
.TP
.B -S
Active le graphisme ASCII de lignes (utile pour utiliser les polices du
mode console de Linux)
.PP
.TP
.B -L \fIniveau\fP
Maximum de profondeur d'affichage de l'arborescence des rpertoires
.PP
.TP
.B -R
Descendre rcursivement dans l'arborescence de chaque niveau de rpertoires  
(voir l'option \fB-L\fP), et pour chacun d'eux excuter de nouveau
\fBtree\fP en y ajoutant `-o 00Tree.html' comme nouvelle option.
.PP
.TP
.B -H \fIbaseHREF\fP
Active la sortie HTML, en incluant des rfrences HTTP. Utile pour les
sites FTP. \fIbaseHREF\fP donne l'emplacement ftp de base lorsque l'on
utilise la sortie HTML. C'est--dire que le rpertoire local peut tre
`/local/ftp/pub', mais il doit tre rfrenc en tant que
`ftp://hostname.organization.domain/pub' (\fIbaseHREF\fP doit tre
`ftp://hostname.organization.domain'). Conseils\ : n'utilisez pas les lignes
ANSI avec cette option, et n'indiquez pas plus d'un rpertoire dans la
liste des rpertoires. Si vous voulez utiliser des couleurs via une feuille
de style CSS, utilisez l'option -C en plus de cette option pour forcer la
sortie en couleurs.
.PP
.br
.SH FICHIERS
/etc/DIR_COLORS		Base de donnes des couleurs systme
.br
~/.dircolors		Base de donnes des couleurs utilisateur
.br

.SH ENVIRONNEMENT
\fBLS_COLORS\fP		Informations sur les couleurs cres par dircolors

.SH AUTEUR
Steve Baker (ice@mama.indstate.edu)
.br
La sortie HTML a t hacke par Francesc Rocher (rocher@econ.udg.es)

.SH BOGUES
Aucun bogue connu. N'a pas t test en profondeur. Pourrait utiliser
quelques options supplmentaires,  la manire de ls. 

.SH VOIR AUSSI
.BR dircolors (1L),
.BR ls (1L),
.BR find (1L)

.SH TRADUCTEUR
Baptiste Mls <baptiste.meles@ens.fr>

N'hsitez pas  reporter respectivement  l'auteur ou au traducteur toute
erreur ou omission dans cette page de manuel.
