% tpm2_checkquote(1) tpm2-tools | General Commands Manual

# NAME

**tpm2_checkquote**(1) - Validates a quote provided by a TPM.

# SYNOPSIS

**tpm2_checkquote** [*OPTIONS*]

# DESCRIPTION

**tpm2_checkquote**(1) - Uses the public portion of the provided key to validate
a quote generated by a TPM. This will validate the signature against the quote
message and, if provided, verify that the qualifying data and PCR values match
those in the quote.

# OPTIONS

  * **-u**, **\--public**=_FILE_:

    File input for the public portion of the signature verification key.

  * **-g**, **\--hash-algorithm**=_ALGORITHM_:

    The hash algorithm used to digest the message.

  * **-m**, **\--message**=_FILE_:

    The quote message that makes up the data that is signed by the TPM.

  * **-s**, **\--signature**=_FILE_:

    The input signature file of the signature to be validated.

  * **-F**, **\--format**=_FORMAT_:

    Signature format. The default is the TPM2.0 **TPMT_SIGNATURE**. Other
    schemes are possible if the data came from an external source like OpenSSL.
    The tool currently only supports rsassa.

  * **-f**, **\--pcr**=_FILE_:

    Optional PCR input file to save the list of PCR values that were included
    in the quote.

  * **-q**, **\--qualification**=_HEX\_STRING\_OR\_PATH_:

    Qualification data for the quote. Can either be a hex string or path.
    This is typically used to add a nonce against replay attacks.

## References

[algorithm specifiers](common/alg.md) details the options for specifying
cryptographic algorithms _ALGORITHM_.

[signature format specifiers](common/signature.md) option used to configure
signature _FORMAT_.

[common options](common/options.md) collection of common options that provide
information many users may expect.

[common tcti options](common/tcti.md) collection of options used to configure
the various known TCTI modules.

# EXAMPLES

## Generate a quote with a TPM, then verify it
```bash
tpm2_createek -c 0x81010009 -G rsa -u ekpub.pem -f pem

tpm2_createak -C 0x81010009 -c 0x8101000a -G rsa -s rsassa -g sha256 \
-u akpub.pem -f pem -n ak.name

tpm2_quote -c 0x8101000a -l sha256:15,16,22 -q abc123 -m quote.out -s sig.out \
-o pcrs.out -g sha256

tpm2_checkquote -u akpub.pem -m quote.out -s sig.out -f pcrs.out -g sha256 \
-q abc123
```

[returns](common/returns.md)

[footer](common/footer.md)
