% tpm2_checkquote(1) tpm2-tools | General Commands Manual
%
% JANUARY 2019

# NAME

**tpm2_checkquote**(1) - Validates a quote provided by a TPM.

# SYNOPSIS

**tpm2_checkquote** [*OPTIONS*]

# DESCRIPTION

**tpm2_checkquote**(1) - Uses the public portion of the provided key to validate a quote 
generated by a TPM. This will validate the signature against the quote message and, if 
provided, verify that the qualifying data and PCR values match those in the quote.

# OPTIONS

  * **-c**, **--pubkey**=_KEY\_CONTEXT\_OBJECT_:

    Context object for the key context used for the operation. Either a file
    or a handle number. See section "Context Object Format".

  * **-G**, **--halg**=_HASH\_ALGORITHM_:

    The hash algorithm used to digest the message.
    Algorithms should follow the "formatting standards", see section
    "Algorithm Specifiers".
    Also, see section "Supported Hash Algorithms" for a list of supported hash
    algorithms.

  * **-m**, **--message**=_MSG\_FILE_:

    The quote message that makes up the data that is signed by the TPM.

  * **-s**, **--sig**=_SIG\_FILE_:

    The input signature file of the signature to be validated.

  * **-f**, **--format**:

    Set the input signature file to a specified format. The default is the TPM2.0 **TPMT_SIGNATURE**
    data format, however different schemes can be selected if the data came from an external
    source like OpenSSL. The tool currently only supports rsassa.

    Algorithms should follow the "formatting standards", see section
    "Algorithm Specifiers".
    Also, see section "Supported Signing Schemes" for a list of supported hash
    algorithms.

  * **-p**, **--pcrs**:

    PCR output file, optional, records the list of PCR values that were included 
    in the quote. 

  * **-q**, **--qualify-data**:

    Data given as a hex string that was used to qualify the quote. This is typically
    used to add a nonce against replay attacks.

[common options](common/options.md)

[common tcti options](common/tcti.md)

[context object format](common/ctxobj.md)

[authorization formatting](common/password.md)

[supported hash algorithms](common/hash.md)

[supported signing schemes](common/signschemes.md)

[algorithm specifiers](common/alg.md)

# EXAMPLES

## Generate a quote with a TPM, then verify it
```
tpm2_createprimary -H e -g sha256 -G rsa -C primary.ctx
tpm2_create -g sha256 -G rsa -u ak.pub -r ak.priv -c primary.ctx
tpm2_load -c primary.ctx  -u ak.pub -r ak.priv -n ak.name -C ak.ctx
tpm2_readpublic -c ak.ctx -o akpub.pem -f pem

tpm2_quote -c ak.ctx -L sha256:15,16,22 -q abc123 -m quote.out -s sig.out -p pcrs.out -G sha256

tpm2_checkquote -c akpub.pem -m quote.out -s sig.out -p pcrs.out -G sha256 -q abc123
```

# RETURNS

0 on success or 1 on failure.

[footer](common/footer.md)
