# P11 Kit Configuration

Below, will be examples and discussion on how to use P11kit with tpm2-pkcs11. This will not be
exhaustive, nor should it be. However, commands not explicitly listed will likely not work as
they are work in progress.

## Prerequisites

In order to use tpm2-pkcs11 with P11kit, one **MUST** have P11kit installed before running
`./configure` and perform a `make install`. Often times, one must be root to do the install,
ie `sudo make install`

During the configure step, tpm2-pkcs11 detects if P11kit is installed, and installs necessary
configuration files and changes library installation paths so it works.

To install p11kit, on Ubuntu, just do:
```
sudo apt-get install p11-kit
```

## Listing Installed Modules


### Initial State
This is the hello world of P11kit. This tests that the module can be seen. We assume a clean slate, it
no TPM2_PKCS11_STORE is present.

```
p11-kit list-modules
p11-kit: tpm2_pkcs11: module failed to initialize, skipping: The device is not present or unplugged
```

This will likely have more output than what is shown here, however, the error message indicates that p11
kit sees the tpm2-pkcs11 library as a *slot* but that the *token* is not present. This state is analogous
to a smart card reader that doesn't have a smart card in it.

### Initializing a Store

Now that we have p11kit seeing the tpm2-pkcs11 library, lets initialize a *store*. This is the process of
configuring the the tpm to pkcs11 bridge so it has tokens and objects for the pkcs11 paradigm.

Start by reading the document on initialization [here](INITIALIZING.md). Only brief commands
will be provided here, so a a basic understanding of the initialization process is paramount.

```bash
# initialize a store
tpm2_ptool.py init --path=~/tmp
action: Created
id: 1

# add a token to the store
tpm2_ptool.py addtoken --pid=1 --label=label --sopin=mysopin --userpin=myuserpin --path=~/tmp
```

No we have an initialized store and a token. Ie we inserted a non-provisioned smart card into the reader.
Now when we list the installed modules, it should be an in inserted and initialized state.

```
p11-kit list-modules
tpm2_pkcs11: libtpm2_pkcs11.so
    library-description:  TPM2.0 Cryptoki
    library-manufacturer:  Intel
    library-version: 42.42
    token: p11kit
        manufacturer: Intel
        model: TPM2 PKCS#11
        serial-number: 0000000000000000
        flags:
               rng
               login-required
               token-initialized
```
**Note**: The details of this output may change, as many of the values are still in development.

## P11tool

The p11tool is used to interact with pkcs11 modules and its API.

It can be installed on Ubuntu via:
```
sudo apt install gnutls-bin
```

**This tutorial assumes you completed the section P11 Kit Configuration**

## Listing Token URLS

p11tool can work of of token URLs. To find our token URL so we can use only that token we run the command:
```
p11tool --list-token-urls
<snip>
pkcs11:model=SW%20%20%20TPM;manufacturer=IBM;serial=0000000000000000;token=label
```

Now we have a URL we can use for subsequent commands and ignore other tokens on your system.

**Note**:I set the variable `token="pkcs11:model=SW%20%20%20TPM;manufacturer=IBM;serial=0000000000000000;token=label"` in
my bash shell before continuing.

## Listing Objects

Let's probe the token and see what objects are on it:
```bash
p11tool --list-all "$token"
No matching objects found
```
In the subsequnt secions, we'll add objects to the token.

### Generating a Random Number

The next example will show how to generate a random number. We'll be piping it through xxd
for display purposes. Be careful running this command without a redirect or pipe to something
like xxd. Dumping raw bytes to the terminal can cause unexpected behaviors.

```
$ p11tool --generate-random=4 $token | xxd
00000000: 02b6 0c20
```

## Creating Objects

Outside of using [tpm2_ptool.py](PKCS11_TOOL.md) to add objects, p11tool supports creating objects
through the PKCS#11 interface.

### Generating RSA Keypair
This will generate an RSA keypair using p11tool:
```
GNUTLS_PIN=myuserpin
p11tool --login --generate-rsa --bits=2048 --label=p11kit "$token"
```

Successful runs should see the following output:
```
-----BEGIN PUBLIC KEY-----
MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEApgP2yAABMnmDb+D6wZRp
J4cqw8efa/Zk8AwHxJ2nAIUgaTIXzB3H0ps7++D0qfRVGJHpq0Qy1sGw+AfAbN4E
kIMcl9SYw1xhGzFws4atcVwggH1hm+v32rezU4JrZ3wP+sZe+qVWHk1oBevSHYMG
Yz7D/B5JEGSHmJTQLEtt0qlTj0lSbVo3w5e5MT6MsC1IiRjT2BlvWsZiOQ+OyKNE
1ziOhuVCXfZOzdVBDSDfT5Zg5PTvcJj+YIONFFrgdzmUF3Y/5xcqe+hgXx7gG3U0
0HhnbGkBA0P0nYGSDubo3D15IzUflCG7PDS4E2V5VtCkIJDyoJ/08bf106mratny
9QIDAQAB
-----END PUBLIC KEY-----
```

### Generating ECC Keypair
This will generate an ECC keypair using p11tool:
```bash
GNUTLS_PIN=myuserpin
p11tool --login --generate-ecc --curve=secp256r1 --label=my-ecc-keypair "$token"
```

Successful runs should see the following output:
```bash
-----BEGIN PUBLIC KEY-----
MFkwEwYHKoZIzj0CAQYIKoZIzj0DAQcDQgAEog3BTlQtVtMGnzJEHTK6xUE1PEKJ
KLmYRAdS3Pj2pi2oAW6pTJo52F0SMTWwpdGSpsFGTqG+MKmXF3pC3JcnHQ==
-----END PUBLIC KEY-----
```

## Destroying Objects
This will show how to delete an object. The first step is having an object to delete on the token
and obtaining a URL to the object you want to delete. Look at the section on *Creating Objects*.

The first step is getting a URL to what you want to delete, we can use the `p11tool --list-all` to find them:
```bash
$ p11tool --list-all "$token"
Object 0:
	URL: pkcs11:model=SW%20%20%20TPM;manufacturer=IBM;serial=0000000000000000;token=label;id=%29%96%2F%DE%18%D2%46%E0%16%4D%89%98%81%DF%7F%C2%EA%D9%59%E9;object=my-ecc-keypair;type=public
	Type: Public key
	Label: my-ecc-keypair
	Flags: CKA_NEVER_EXTRACTABLE; 
	ID: 29:96:2f:de:18:d2:46:e0:16:4d:89:98:81:df:7f:c2:ea:d9:59:e9
```
Note: You only see public objects when not logged in, to see private or secret objects you need to specify the `--login`
option.

Now that we know what object to delete, lets delete it. Ensure you provide the `--login` option and the password:
```bash
url="pkcs11:model=SW%20%20%20TPM;manufacturer=IBM;serial=0000000000000000;token=label;id=%29%96%2F%DE%18%D2%46%E0%16%4D%89%98%81%DF%7F%C2%EA%D9%59%E9;object=my-ecc-keypair;type=public"

$ GNUTLS_PIN=myuserpin p11tool --login --delete "$url"
```

You will then be presented with output verifying the delete:
```
Object 0:
	URL: pkcs11:library-description=TPM2.0%20Cryptoki;library-manufacturer=tpm2-software.github.io;model=SW%20%20%20TPM;manufacturer=IBM;serial=0000000000000000;token=label;id=%29%96%2F%DE%18%D2%46%E0%16%4D%89%98%81%DF%7F%C2%EA%D9%59%E9;object=my-ecc-keypair;type=public
	Type: Public key
	Label: my-ecc-keypair
	Flags: CKA_NEVER_EXTRACTABLE; 
	ID: 29:96:2f:de:18:d2:46:e0:16:4d:89:98:81:df:7f:c2:ea:d9:59:e9

Are you sure you want to delete those objects? (y/N): 
```
Select Y and then hit enter.
```
Are you sure you want to delete those objects? (y/N): y
Re-using cached PIN for token 'label'

1 objects deleted
```

And verify that it's gone:
```
$ p11tool --list-all "$token"
No matching objects found
```
Your output could vary based on what objects are present in your token.

