#FindTNCS.cmake
#
# Created on: 11.07.2009
#     Author: mike
#

FIND_PATH(Tncs_INCLUDE_DIR NAMES tncs PATH_SUFFIXES src)

FIND_LIBRARY(Tncs_LIBRARY tncs)

IF(Tncs_INCLUDE_DIR)
    IF(EXISTS "${Tncs_INCLUDE_DIR}/tncs/version.h")
        FILE(READ "${Tncs_INCLUDE_DIR}/tncs/version.h" _tncs_VERSION_H_CONTENTS)
    
        STRING(REGEX REPLACE ".*#define TNCS_VERSION_MAJOR *([0-9]+).*" "\\1" Tncs_VERSION_MAJOR "${_tncs_VERSION_H_CONTENTS}")
        STRING(REGEX REPLACE ".*#define TNCS_VERSION_MINOR *([0-9]+).*" "\\1" Tncs_VERSION_MINOR "${_tncs_VERSION_H_CONTENTS}")
        STRING(REGEX REPLACE ".*#define TNCS_VERSION_PATCH *([0-9]+).*" "\\1" Tncs_VERSION_PATCH "${_tncs_VERSION_H_CONTENTS}")
        STRING(REGEX REPLACE ".*#define TNCS_VERSION_TWEAK *([0-9]+).*" "\\1" Tncs_VERSION_TWEAK "${_tncs_VERSION_H_CONTENTS}")
        STRING(REGEX REPLACE ".*#define TNCS_VERSION_SUPPLEMENT *\"([^\"]*)\".*" "\\1" Tncs_VERSION_SUPPLEMENT "${_tncs_VERSION_H_CONTENTS}")
    
        STRING(REGEX REPLACE ".*#define TNCS_VERSION \"([^\"]+)\".*" "\\1" Tncs_VERSION "${_tncs_VERSION_H_CONTENTS}")
    ELSE()
        INCLUDE("${Tncs_INCLUDE_DIR}/../tncsVersion.cmake")
        LIST(APPEND Tncs_INCLUDE_DIRS "${Tncs_INCLUDE_DIR}/../include")
        GET_FILENAME_COMPONENT(TMP_Tncs_LIBRARY_DIR "${Tncs_LIBRARY}" PATH)
        LIST(APPEND Tncs_INCLUDE_DIRS "${TMP_Tncs_LIBRARY_DIR}")
        
        SET(Tncs_VERSION "${Tncs_VERSION_MAJOR}.${Tncs_VERSION_MINOR}.${Tncs_VERSION_PATCH}")
        IF (Tncs_VERSION_TWEAK)
            SET(Tncs_VERSION "${Tncs_VERSION}.${Tncs_VERSION_TWEAK}")
        ENDIF (Tncs_VERSION_TWEAK)
        IF (Tncs_VERSION_SUPPLEMENT)
            SET(Tncs_VERSION "${Tncs_VERSION}-${Tncs_VERSION_SUPPLEMENT}")
        ENDIF (Tncs_VERSION_SUPPLEMENT)
    ENDIF()
ENDIF()

IF (Tncs_INCLUDE_DIR AND Tncs_LIBRARY)
   SET(Tncs_FOUND TRUE)
ENDIF (Tncs_INCLUDE_DIR AND Tncs_LIBRARY)

IF(Tncs_FOUND)
    IF(Tncs_FIND_VERSION_MAJOR AND NOT Tncs_FIND_VERSION_MAJOR EQUAL "${Tncs_VERSION_MAJOR}")
        IF(Tncs_FIND_VERSION_EXACT OR Tncs_FIND_VERSION_MAJOR GREATER "${Tncs_VERSION_MAJOR}")
            SET(Tncs_FOUND FALSE)
        ENDIF()
    ELSE()
        IF(Tncs_FIND_VERSION_MINOR AND NOT Tncs_FIND_VERSION_MINOR EQUAL "${Tncs_VERSION_MINOR}")
            IF(Tncs_FIND_VERSION_EXACT OR Tncs_FIND_VERSION_MINOR GREATER "${Tncs_VERSION_MINOR}")
                SET(Tncs_FOUND FALSE)
            ENDIF()
        ELSE()
            IF(Tncs_FIND_VERSION_PATCH AND NOT Tncs_FIND_VERSION_PATCH EQUAL "${Tncs_VERSION_PATCH}")
                IF(Tncs_FIND_VERSION_EXACT OR Tncs_FIND_VERSION_PATCH GREATER "${Tncs_VERSION_PATCH}")
                    SET(Tncs_FOUND FALSE)
                ENDIF()
            ELSE()
                IF(Tncs_FIND_VERSION_TWEAK AND NOT Tncs_FIND_VERSION_TWEAK EQUAL "${Tncs_VERSION_TWEAK}")
                    IF(Tncs_FIND_VERSION_EXACT OR Tncs_FIND_VERSION_TWEAK GREATER "${Tncs_VERSION_TWEAK}")
                        SET(Tncs_FOUND FALSE)
                    ENDIF()
                ENDIF()
            ENDIF()
        ENDIF()
    ENDIF()
ENDIF(Tncs_FOUND)

# log4cxx
FIND_PACKAGE(Log4cxx REQUIRED)
IF (Log4cxx_FOUND)
    LIST(APPEND Tncs_INCLUDE_DIRS "${Log4cxx_INCLUDE_DIR}")
    LIST(APPEND Tncs_LIBRARIES "${Log4cxx_LIBRARY}")
ELSE (Log4cxx_FOUND)
    SET(Tncs_FOUND FALSE)
ENDIF (Log4cxx_FOUND)

# xerces-c
FIND_PACKAGE(XercesC REQUIRED)
IF (XercesC_FOUND)
    LIST(APPEND Tncs_INCLUDE_DIRS "${XercesC_INCLUDE_DIR}")
    LIST(APPEND Tncs_LIBRARIES "${XercesC_LIBRARY}")
ELSE (XercesC_FOUND)
    SET(Tncs_FOUND FALSE)
ENDIF (XercesC_FOUND)

# ltdl
FIND_PACKAGE(LTDL REQUIRED)
IF (LTDL_FOUND)
    LIST(APPEND Tncs_INCLUDE_DIRS "${LTDL_INCLUDE_DIR}")
    LIST(APPEND Tncs_LIBRARIES "${LTDL_LIBRARY}")
ELSE (LTDL_FOUND)
    SET(Tncs_FOUND FALSE)
ENDIF (LTDL_FOUND)

IF (Tncs_FOUND)
    LIST(APPEND Tncs_INCLUDE_DIRS "${Tncs_INCLUDE_DIR}")
    LIST(APPEND Tncs_LIBRARIES "${Tncs_LIBRARY}")

   IF (NOT Tncs_FIND_QUIETLY)
      MESSAGE(STATUS "Found tncs: ${Tncs_LIBRARY} (${Tncs_VERSION})")
   ENDIF (NOT Tncs_FIND_QUIETLY)
ELSE (Tncs_FOUND)
   IF (NOT Tncs_INCLUDE_DIR AND NOT Tncs_LIBRARY)
       SET(TMP_REASON "Include and Library not found.")
   ELSEIF(Tncs_INCLUDE_DIR AND NOT Tncs_LIBRARY)
       SET(TMP_REASON "Library not found.")
   ELSEIF(NOT Tncs_INCLUDE_DIR AND Tncs_LIBRARY)
       SET(TMP_REASON "Include not found.")
   ELSEIF(NOT Log4cxx_FOUND)
       SET(TMP_REASON "Log4cxx not found.")
   ELSEIF(NOT XercesC_FOUND)
       SET(TMP_REASON "XercesC not found.")
   ELSEIF(NOT LTDL_FOUND)
       SET(TMP_REASON "LTDL not found.")
   ELSE (NOT Tncs_INCLUDE_DIR AND NOT Tncs_LIBRARY)
       SET(TMP_REASON "Version ${Tncs_FIND_VERSION} not found.")
   ENDIF(NOT Tncs_INCLUDE_DIR AND NOT Tncs_LIBRARY)

   IF (Tncs_FIND_REQUIRED)
      MESSAGE(FATAL_ERROR "Could not find tncs. Reason: ${TMP_REASON}")
   ELSE (Tncs_FIND_REQUIRED)
      MESSAGE(STATUS "Could not find tncs. Reason: ${TMP_REASON}")
   ENDIF (Tncs_FIND_REQUIRED)
ENDIF (Tncs_FOUND)
