# Find the native LTDL includes and library
#
# This module defines
#  LTDL_INCLUDE_DIR, where to find ltdl.h, etc.
#  LTDL_LIBRARY, where to find the LTDL library.
#  LTDL_FOUND, If false, do not try to use LTDL.
 
FIND_PATH(LTDL_INCLUDE_DIR ltdl.h)

FIND_LIBRARY(LTDL_LIBRARY ltdl) 

IF (LTDL_INCLUDE_DIR AND LTDL_LIBRARY)
   SET(LTDL_FOUND TRUE)
ELSE(LTDL_INCLUDE_DIR AND LTDL_LIBRARY)
   SET(LTDL_FOUND FALSE)
ENDIF (LTDL_INCLUDE_DIR AND LTDL_LIBRARY)

IF (LTDL_FOUND)
   IF (NOT LTDL_FIND_QUIETLY)
      MESSAGE(STATUS "Found LTDL: ${LTDL_LIBRARY}")
   ENDIF (NOT LTDL_FIND_QUIETLY)
ELSE (LTDL_FOUND)
   IF (LTDL_FIND_REQUIRED)
      MESSAGE(FATAL_ERROR "Could not find LTDL")
   ENDIF (LTDL_FIND_REQUIRED)
ENDIF (LTDL_FOUND)
