FIND_PATH(Log4cxx_INCLUDE_DIR log4cxx)

FIND_LIBRARY(Log4cxx_LIBRARY log4cxx) 

IF (Log4cxx_INCLUDE_DIR AND Log4cxx_LIBRARY)
    SET(Log4cxx_FOUND TRUE)
ENDIF (Log4cxx_INCLUDE_DIR AND Log4cxx_LIBRARY)

IF(Log4cxx_FOUND)
    FILE(READ "${Log4cxx_INCLUDE_DIR}/log4cxx/logger.h" TMP_LOG4CXX_CONTENT_LOGGER_H)
    IF(NOT TMP_LOG4CXX_CONTENT_LOGGER_H MATCHES "#define LOG4CXX_TRACE")
        SET(Log4cxx_FOUND FALSE)
    ENDIF(NOT TMP_LOG4CXX_CONTENT_LOGGER_H MATCHES "#define LOG4CXX_TRACE")
ENDIF(Log4cxx_FOUND)

IF (Log4cxx_FOUND)
    LIST(APPEND Log4cxx_INCLUDE_DIRS "${Log4cxx_INCLUDE_DIR}")
    LIST(APPEND Log4cxx_LIBRARIES "${Log4cxx_LIBRARY}")
    
    IF (NOT Log4cxx_FIND_QUIETLY)
       MESSAGE(STATUS "Found Log4cxx: ${Log4cxx_LIBRARY}")
    ENDIF (NOT Log4cxx_FIND_QUIETLY)
ELSE (Log4cxx_FOUND)
    IF (Log4cxx_FIND_REQUIRED)
        MESSAGE(FATAL_ERROR "Could not find Log4cxx (>=0.10)")
    ENDIF (Log4cxx_FIND_REQUIRED)
ENDIF (Log4cxx_FOUND)
