/*
 * Tlog-play command-line parsing.
 *
 * vim:nomodifiable
 * 
 * ************************* WARNING! DO NOT EDIT! *************************
 * This file is automatically generated from play_conf_cmd.c.m4.
 * *************************************************************************
 *
 * Copyright (C) 2016 Red Hat
 *
 * This file is part of tlog.
 *
 * Tlog is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Tlog is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with tlog; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <config.h>
#include <tlog/play_conf_validate.h>
#include <tlog/play_conf_cmd.h>
#include <tlog/json_misc.h>
#include <tlog/rc.h>
#include <tlog/misc.h>
#include <libgen.h>
#include <stdio.h>
#include <unistd.h>
#include <getopt.h>
#include <string.h>
#include <inttypes.h>
#include <assert.h>

static const char *tlog_play_conf_cmd_help_fmt =
    "Usage: %1$s [OPTION...]\n"
    "Play back a terminal I/O recording done by tlog-rec.\n"
    "\n"
    "General options:\n"
    "    -h, --help                  Output a command-line usage message and exit\n"
    "    -v, --version               Output version information and exit\n"
    "    --configuration             Output program configuration in JSON and exit\n"
    "    -s, --speed=NUMBER          Set playback speed multiplier to NUMBER\n"
    "    -f, --follow                Wait for and play back new messages\n"
    "    -g, --goto=STRING           Fast-forward to STRING time (start/end/HH:MM:SS.sss)\n"
    "    -p, --paused                Start playback paused\n"
    "    -r, --reader=STRING         Use STRING log reader (file/journal/es, default file)\n"
    "    --persist                   Ignore quit key and signals from keyboard\n"
    "    --lax                       Ignore missing (dropped) log messages\n"
    "\n"
    "File reader options:\n"
    "    -i, --file-path=FILE        Read log from FILE file\n"
    "    -m, --file-match=STRING     Playback explicit recording id specified in STRING\n"
    "\n"
    "Elasticsearch reader options:\n"
    "    --es-baseurl=STRING         Elasticsearch URL without query or fragment parts\n"
    "    --es-query=STRING           Elasticsearch query\n"
    "    --es-verbose                Enable verbose output on Elasticsearch HTTP client\n"
    "\n"
    "Systemd journal reader options:\n"
    "    -S, --journal-since=SECONDS Start searching journal at SECONDS since epoch\n"
    "    -U, --journal-until=SECONDS Stop searching journal at SECONDS since epoch\n"
    "    -M, --journal-match=STRING  Add STRING to journal match symbol list\n"
    "";

static tlog_grc
tlog_play_conf_cmd_load_args(struct tlog_errs **perrs,
                            struct json_object *conf,
                            const char *help,
                            int argc, char **argv)
{
    /* Option codes */
    enum opt {
        OPT_HELP = 'h',
        OPT_VERSION = 'v',
        OPT_SPEED = 's',
        OPT_FOLLOW = 'f',
        OPT_GOTO = 'g',
        OPT_PAUSED = 'p',
        OPT_READER = 'r',
        OPT_FILE_PATH = 'i',
        OPT_FILE_MATCH = 'm',
        OPT_JOURNAL_SINCE = 'S',
        OPT_JOURNAL_UNTIL = 'U',
        OPT_JOURNAL_MATCH = 'M',
        OPT_CONFIGURATION = 0x100,
        OPT_ES_BASEURL,
        OPT_ES_QUERY,
        OPT_ES_VERBOSE,
        OPT_PERSIST,
        OPT_LAX,
    };

    /* Description of short options */
    static const char *shortopts = "+:h::v::s:f::g:p::r:i:m:S:U:M:";

    /* Description of long options */
    static const struct option longopts[] = {
        {
            .name = "help",
            .val = OPT_HELP,
            .has_arg = optional_argument,
        },
        {
            .name = "version",
            .val = OPT_VERSION,
            .has_arg = optional_argument,
        },
        {
            .name = "configuration",
            .val = OPT_CONFIGURATION,
            .has_arg = optional_argument,
        },
        {
            .name = "speed",
            .val = OPT_SPEED,
            .has_arg = required_argument,
        },
        {
            .name = "follow",
            .val = OPT_FOLLOW,
            .has_arg = optional_argument,
        },
        {
            .name = "goto",
            .val = OPT_GOTO,
            .has_arg = required_argument,
        },
        {
            .name = "paused",
            .val = OPT_PAUSED,
            .has_arg = optional_argument,
        },
        {
            .name = "reader",
            .val = OPT_READER,
            .has_arg = required_argument,
        },
        {
            .name = "file-path",
            .val = OPT_FILE_PATH,
            .has_arg = required_argument,
        },
        {
            .name = "file-match",
            .val = OPT_FILE_MATCH,
            .has_arg = required_argument,
        },
        {
            .name = "es-baseurl",
            .val = OPT_ES_BASEURL,
            .has_arg = required_argument,
        },
        {
            .name = "es-query",
            .val = OPT_ES_QUERY,
            .has_arg = required_argument,
        },
        {
            .name = "es-verbose",
            .val = OPT_ES_VERBOSE,
            .has_arg = optional_argument,
        },
        {
            .name = "journal-since",
            .val = OPT_JOURNAL_SINCE,
            .has_arg = required_argument,
        },
        {
            .name = "journal-until",
            .val = OPT_JOURNAL_UNTIL,
            .has_arg = required_argument,
        },
        {
            .name = "journal-match",
            .val = OPT_JOURNAL_MATCH,
            .has_arg = required_argument,
        },
        {
            .name = "persist",
            .val = OPT_PERSIST,
            .has_arg = optional_argument,
        },
        {
            .name = "lax",
            .val = OPT_LAX,
            .has_arg = optional_argument,
        },
        {
            .name = NULL
        }
    };

    tlog_grc grc;
    int opterr_orig;
    int optind_orig;
    int optcode;
    const char *optname;
    const char *optpath;
    int64_t val_int;
    double val_double;
    struct json_object *prev_val;
    struct json_object *val = NULL;
    struct json_object *entry_val = NULL;
    struct json_object *args = NULL;
    int end;
    int i;

    /* May be unused if there are no corresponding parameters */
    (void)val_int;
    (void)val_double;
    (void)end;

    /* Ask getopt_long to not print an error message */
    opterr_orig = opterr;
    opterr = 0;

    /* Ask getopt_long to start from the first argument */
    optind_orig = optind;
    optind = 1;

    /* While there are options */
    while ((optcode = getopt_long(argc, argv, 
                                  shortopts, longopts, NULL)) >= 0) {
        switch (optcode) {
        case OPT_HELP:
            optname = "-h/--help";
            optpath = "help";
            grc = tlog_json_object_object_get_path(conf, optpath, &prev_val, NULL);
            if (grc != TLOG_RC_OK) {
                TLOG_ERRS_RAISECF(grc,
                                  "Failed retrieving %s option value", optname);
            }
            if (optarg == NULL ||
                strcasecmp(optarg, "yes") == 0 ||
                strcasecmp(optarg, "on") == 0 ||
                strcasecmp(optarg, "true") == 0) {
                val = json_object_new_boolean(true);
            } else if (strcasecmp(optarg, "no") == 0 ||
                       strcasecmp(optarg, "off") == 0 ||
                       strcasecmp(optarg, "false") == 0) {
                val = json_object_new_boolean(false);
            } else {
                grc = TLOG_RC_FAILURE;
                TLOG_ERRS_RAISEF("Invalid %s option value: %s,\n"
                                 "expecting yes/on/true or no/off/false\n%s",
                                 optname, optarg, help);
            }
            break;

        case OPT_VERSION:
            optname = "-v/--version";
            optpath = "version";
            grc = tlog_json_object_object_get_path(conf, optpath, &prev_val, NULL);
            if (grc != TLOG_RC_OK) {
                TLOG_ERRS_RAISECF(grc,
                                  "Failed retrieving %s option value", optname);
            }
            if (optarg == NULL ||
                strcasecmp(optarg, "yes") == 0 ||
                strcasecmp(optarg, "on") == 0 ||
                strcasecmp(optarg, "true") == 0) {
                val = json_object_new_boolean(true);
            } else if (strcasecmp(optarg, "no") == 0 ||
                       strcasecmp(optarg, "off") == 0 ||
                       strcasecmp(optarg, "false") == 0) {
                val = json_object_new_boolean(false);
            } else {
                grc = TLOG_RC_FAILURE;
                TLOG_ERRS_RAISEF("Invalid %s option value: %s,\n"
                                 "expecting yes/on/true or no/off/false\n%s",
                                 optname, optarg, help);
            }
            break;

        case OPT_CONFIGURATION:
            optname = "--configuration";
            optpath = "configuration";
            grc = tlog_json_object_object_get_path(conf, optpath, &prev_val, NULL);
            if (grc != TLOG_RC_OK) {
                TLOG_ERRS_RAISECF(grc,
                                  "Failed retrieving %s option value", optname);
            }
            if (optarg == NULL ||
                strcasecmp(optarg, "yes") == 0 ||
                strcasecmp(optarg, "on") == 0 ||
                strcasecmp(optarg, "true") == 0) {
                val = json_object_new_boolean(true);
            } else if (strcasecmp(optarg, "no") == 0 ||
                       strcasecmp(optarg, "off") == 0 ||
                       strcasecmp(optarg, "false") == 0) {
                val = json_object_new_boolean(false);
            } else {
                grc = TLOG_RC_FAILURE;
                TLOG_ERRS_RAISEF("Invalid %s option value: %s,\n"
                                 "expecting yes/on/true or no/off/false\n%s",
                                 optname, optarg, help);
            }
            break;

        case OPT_SPEED:
            optname = "-s/--speed";
            optpath = "speed";
            grc = tlog_json_object_object_get_path(conf, optpath, &prev_val, NULL);
            if (grc != TLOG_RC_OK) {
                TLOG_ERRS_RAISECF(grc,
                                  "Failed retrieving %s option value", optname);
            }
            assert(optarg != NULL);
            if (optarg == NULL) {
                grc = TLOG_RC_FAILURE;
                TLOG_ERRS_RAISEF("Option %s has no value", optname);
            }
            if (sscanf(optarg, "%lf %n", &val_double, &end) < 1 ||
                optarg[end] != 0 || val_double < 0) {
                grc = TLOG_RC_FAILURE;
                TLOG_ERRS_RAISEF("Invalid %s option value: %s\n%s",
                                 optname, optarg, help);
            }
            val = json_object_new_double(val_double);
            break;

        case OPT_FOLLOW:
            optname = "-f/--follow";
            optpath = "follow";
            grc = tlog_json_object_object_get_path(conf, optpath, &prev_val, NULL);
            if (grc != TLOG_RC_OK) {
                TLOG_ERRS_RAISECF(grc,
                                  "Failed retrieving %s option value", optname);
            }
            if (optarg == NULL ||
                strcasecmp(optarg, "yes") == 0 ||
                strcasecmp(optarg, "on") == 0 ||
                strcasecmp(optarg, "true") == 0) {
                val = json_object_new_boolean(true);
            } else if (strcasecmp(optarg, "no") == 0 ||
                       strcasecmp(optarg, "off") == 0 ||
                       strcasecmp(optarg, "false") == 0) {
                val = json_object_new_boolean(false);
            } else {
                grc = TLOG_RC_FAILURE;
                TLOG_ERRS_RAISEF("Invalid %s option value: %s,\n"
                                 "expecting yes/on/true or no/off/false\n%s",
                                 optname, optarg, help);
            }
            break;

        case OPT_GOTO:
            optname = "-g/--goto";
            optpath = "goto";
            grc = tlog_json_object_object_get_path(conf, optpath, &prev_val, NULL);
            if (grc != TLOG_RC_OK) {
                TLOG_ERRS_RAISECF(grc,
                                  "Failed retrieving %s option value", optname);
            }
            assert(optarg != NULL);
            if (optarg == NULL) {
                grc = TLOG_RC_FAILURE;
                TLOG_ERRS_RAISEF("Option %s has no value", optname);
            }
            val = json_object_new_string(optarg);
            break;

        case OPT_PAUSED:
            optname = "-p/--paused";
            optpath = "paused";
            grc = tlog_json_object_object_get_path(conf, optpath, &prev_val, NULL);
            if (grc != TLOG_RC_OK) {
                TLOG_ERRS_RAISECF(grc,
                                  "Failed retrieving %s option value", optname);
            }
            if (optarg == NULL ||
                strcasecmp(optarg, "yes") == 0 ||
                strcasecmp(optarg, "on") == 0 ||
                strcasecmp(optarg, "true") == 0) {
                val = json_object_new_boolean(true);
            } else if (strcasecmp(optarg, "no") == 0 ||
                       strcasecmp(optarg, "off") == 0 ||
                       strcasecmp(optarg, "false") == 0) {
                val = json_object_new_boolean(false);
            } else {
                grc = TLOG_RC_FAILURE;
                TLOG_ERRS_RAISEF("Invalid %s option value: %s,\n"
                                 "expecting yes/on/true or no/off/false\n%s",
                                 optname, optarg, help);
            }
            break;

        case OPT_READER:
            optname = "-r/--reader";
            optpath = "reader";
            grc = tlog_json_object_object_get_path(conf, optpath, &prev_val, NULL);
            if (grc != TLOG_RC_OK) {
                TLOG_ERRS_RAISECF(grc,
                                  "Failed retrieving %s option value", optname);
            }
            {
                const char *list[] = {"file",
                                      "journal",
                                      "es"};
                size_t i;
                assert(optarg != NULL);
                if (optarg == NULL) {
                    grc = TLOG_RC_FAILURE;
                    TLOG_ERRS_RAISEF("Option %s has no value", optname);
                }
                for (i = 0;
                     i < TLOG_ARRAY_SIZE(list) && strcmp(optarg, list[i]) != 0;
                     i++);
                if (i >= TLOG_ARRAY_SIZE(list)) {
                    grc = TLOG_RC_FAILURE;
                    TLOG_ERRS_RAISEF("Invalid %s option value: %s\n%s",
                                     optname, optarg, help);
                }
            }
            val = json_object_new_string(optarg);
            break;

        case OPT_FILE_PATH:
            optname = "-i/--file-path";
            optpath = "file.path";
            grc = tlog_json_object_object_get_path(conf, optpath, &prev_val, NULL);
            if (grc != TLOG_RC_OK) {
                TLOG_ERRS_RAISECF(grc,
                                  "Failed retrieving %s option value", optname);
            }
            assert(optarg != NULL);
            if (optarg == NULL) {
                grc = TLOG_RC_FAILURE;
                TLOG_ERRS_RAISEF("Option %s has no value", optname);
            }
            val = json_object_new_string(optarg);
            break;

        case OPT_FILE_MATCH:
            optname = "-m/--file-match";
            optpath = "file.match";
            grc = tlog_json_object_object_get_path(conf, optpath, &prev_val, NULL);
            if (grc != TLOG_RC_OK) {
                TLOG_ERRS_RAISECF(grc,
                                  "Failed retrieving %s option value", optname);
            }
            assert(optarg != NULL);
            if (optarg == NULL) {
                grc = TLOG_RC_FAILURE;
                TLOG_ERRS_RAISEF("Option %s has no value", optname);
            }
            val = json_object_new_string(optarg);
            break;

        case OPT_ES_BASEURL:
            optname = "--es-baseurl";
            optpath = "es.baseurl";
            grc = tlog_json_object_object_get_path(conf, optpath, &prev_val, NULL);
            if (grc != TLOG_RC_OK) {
                TLOG_ERRS_RAISECF(grc,
                                  "Failed retrieving %s option value", optname);
            }
            assert(optarg != NULL);
            if (optarg == NULL) {
                grc = TLOG_RC_FAILURE;
                TLOG_ERRS_RAISEF("Option %s has no value", optname);
            }
            val = json_object_new_string(optarg);
            break;

        case OPT_ES_QUERY:
            optname = "--es-query";
            optpath = "es.query";
            grc = tlog_json_object_object_get_path(conf, optpath, &prev_val, NULL);
            if (grc != TLOG_RC_OK) {
                TLOG_ERRS_RAISECF(grc,
                                  "Failed retrieving %s option value", optname);
            }
            assert(optarg != NULL);
            if (optarg == NULL) {
                grc = TLOG_RC_FAILURE;
                TLOG_ERRS_RAISEF("Option %s has no value", optname);
            }
            val = json_object_new_string(optarg);
            break;

        case OPT_ES_VERBOSE:
            optname = "--es-verbose";
            optpath = "es.verbose";
            grc = tlog_json_object_object_get_path(conf, optpath, &prev_val, NULL);
            if (grc != TLOG_RC_OK) {
                TLOG_ERRS_RAISECF(grc,
                                  "Failed retrieving %s option value", optname);
            }
            if (optarg == NULL ||
                strcasecmp(optarg, "yes") == 0 ||
                strcasecmp(optarg, "on") == 0 ||
                strcasecmp(optarg, "true") == 0) {
                val = json_object_new_boolean(true);
            } else if (strcasecmp(optarg, "no") == 0 ||
                       strcasecmp(optarg, "off") == 0 ||
                       strcasecmp(optarg, "false") == 0) {
                val = json_object_new_boolean(false);
            } else {
                grc = TLOG_RC_FAILURE;
                TLOG_ERRS_RAISEF("Invalid %s option value: %s,\n"
                                 "expecting yes/on/true or no/off/false\n%s",
                                 optname, optarg, help);
            }
            break;

        case OPT_JOURNAL_SINCE:
            optname = "-S/--journal-since";
            optpath = "journal.since";
            grc = tlog_json_object_object_get_path(conf, optpath, &prev_val, NULL);
            if (grc != TLOG_RC_OK) {
                TLOG_ERRS_RAISECF(grc,
                                  "Failed retrieving %s option value", optname);
            }
            assert(optarg != NULL);
            if (optarg == NULL) {
                grc = TLOG_RC_FAILURE;
                TLOG_ERRS_RAISEF("Option %s has no value", optname);
            }
            if (sscanf(optarg, "%" SCNd64 " %n", &val_int, &end) < 1 ||
                optarg[end] != 0 || val_int < 0) {
                grc = TLOG_RC_FAILURE;
                TLOG_ERRS_RAISEF("Invalid %s option value: %s\n%s",
                                 optname, optarg, help);
            }
            val = json_object_new_int64(val_int);
            break;

        case OPT_JOURNAL_UNTIL:
            optname = "-U/--journal-until";
            optpath = "journal.until";
            grc = tlog_json_object_object_get_path(conf, optpath, &prev_val, NULL);
            if (grc != TLOG_RC_OK) {
                TLOG_ERRS_RAISECF(grc,
                                  "Failed retrieving %s option value", optname);
            }
            assert(optarg != NULL);
            if (optarg == NULL) {
                grc = TLOG_RC_FAILURE;
                TLOG_ERRS_RAISEF("Option %s has no value", optname);
            }
            if (sscanf(optarg, "%" SCNd64 " %n", &val_int, &end) < 1 ||
                optarg[end] != 0 || val_int < 0) {
                grc = TLOG_RC_FAILURE;
                TLOG_ERRS_RAISEF("Invalid %s option value: %s\n%s",
                                 optname, optarg, help);
            }
            val = json_object_new_int64(val_int);
            break;

        case OPT_JOURNAL_MATCH:
            optname = "-M/--journal-match";
            optpath = "journal.match";
            grc = tlog_json_object_object_get_path(conf, optpath, &prev_val, NULL);
            if (grc != TLOG_RC_OK) {
                TLOG_ERRS_RAISECF(grc,
                                  "Failed retrieving %s option value", optname);
            }
            assert(optarg != NULL);
            if (optarg == NULL) {
                grc = TLOG_RC_FAILURE;
                TLOG_ERRS_RAISEF("Option %s has no value", optname);
            }
            entry_val = json_object_new_string(optarg);
            if (entry_val == NULL) {
                grc = TLOG_GRC_ERRNO;
                TLOG_ERRS_RAISECF(grc, "Failed creating %s option value", optname);
            }
            if (prev_val == NULL) {
                val = json_object_new_array();
                if (val == NULL) {
                    grc = TLOG_GRC_ERRNO;
                    TLOG_ERRS_RAISECF(grc, "Failed creating %s option value", optname);
                }
            } else {
                val = prev_val;
            }
            if (json_object_array_add(val, entry_val) != 0) {
                grc = TLOG_GRC_ERRNO;
                TLOG_ERRS_RAISECF(grc, "Failed adding %s option value entry", optname);
            }
            entry_val = NULL;
            break;

        case OPT_PERSIST:
            optname = "--persist";
            optpath = "persist";
            grc = tlog_json_object_object_get_path(conf, optpath, &prev_val, NULL);
            if (grc != TLOG_RC_OK) {
                TLOG_ERRS_RAISECF(grc,
                                  "Failed retrieving %s option value", optname);
            }
            if (optarg == NULL ||
                strcasecmp(optarg, "yes") == 0 ||
                strcasecmp(optarg, "on") == 0 ||
                strcasecmp(optarg, "true") == 0) {
                val = json_object_new_boolean(true);
            } else if (strcasecmp(optarg, "no") == 0 ||
                       strcasecmp(optarg, "off") == 0 ||
                       strcasecmp(optarg, "false") == 0) {
                val = json_object_new_boolean(false);
            } else {
                grc = TLOG_RC_FAILURE;
                TLOG_ERRS_RAISEF("Invalid %s option value: %s,\n"
                                 "expecting yes/on/true or no/off/false\n%s",
                                 optname, optarg, help);
            }
            break;

        case OPT_LAX:
            optname = "--lax";
            optpath = "lax";
            grc = tlog_json_object_object_get_path(conf, optpath, &prev_val, NULL);
            if (grc != TLOG_RC_OK) {
                TLOG_ERRS_RAISECF(grc,
                                  "Failed retrieving %s option value", optname);
            }
            if (optarg == NULL ||
                strcasecmp(optarg, "yes") == 0 ||
                strcasecmp(optarg, "on") == 0 ||
                strcasecmp(optarg, "true") == 0) {
                val = json_object_new_boolean(true);
            } else if (strcasecmp(optarg, "no") == 0 ||
                       strcasecmp(optarg, "off") == 0 ||
                       strcasecmp(optarg, "false") == 0) {
                val = json_object_new_boolean(false);
            } else {
                grc = TLOG_RC_FAILURE;
                TLOG_ERRS_RAISEF("Invalid %s option value: %s,\n"
                                 "expecting yes/on/true or no/off/false\n%s",
                                 optname, optarg, help);
            }
            break;

        case ':':
            for (i = 0; i < (int)TLOG_ARRAY_SIZE(longopts); i++) {
                if (longopts[i].val == optopt) {
                    break;
                }
            }
            grc = TLOG_RC_FAILURE;
            if (i < (int)TLOG_ARRAY_SIZE(longopts)) {
                if (longopts[i].val < 0x100) {
                    TLOG_ERRS_RAISEF("Option -%c/--%s argument is missing\n%s",
                                     longopts[i].val, longopts[i].name, help);
                } else {
                    TLOG_ERRS_RAISEF("Option --%s argument is missing\n%s",
                                     longopts[i].name, help);
                }
            } else {
                TLOG_ERRS_RAISEF("Option -%c argument is missing\n%s",
                                 optopt, help);
            }

        case '?':
            grc = TLOG_RC_FAILURE;
            if (optopt == 0) {
                TLOG_ERRS_RAISEF("Unknown option encountered\n%s",
                                 help);
            } else {
                TLOG_ERRS_RAISEF("Unknown option encountered: -%c\n%s",
                                 optopt, help);
            }

        default:
            grc = TLOG_RC_FAILURE;
            TLOG_ERRS_RAISEF("Unknown option code: %d", optcode);
        }

        if (val == NULL) {
            grc = TLOG_GRC_ERRNO;
            TLOG_ERRS_RAISECF(grc, "Failed creating %s option value", optname);
        }
        if (val != prev_val) {
            grc = tlog_json_object_object_add_path(conf, optpath, val);
            if (grc != TLOG_RC_OK) {
                TLOG_ERRS_RAISECF(grc, "Failed storing %s option value", optname);
            }
        }
        val = NULL;
    }

    /* Add other arguments */
    args = json_object_new_array();
    if (args == NULL) {
        grc = TLOG_GRC_ERRNO;
        TLOG_ERRS_RAISECS(grc, "Failed creating positional argument list");
    }
    for (i = 0; optind < argc; i++, optind++) {
        val = json_object_new_string(argv[optind]);
        if (val == NULL) {
            grc = TLOG_GRC_ERRNO;
            TLOG_ERRS_RAISECS(grc, "Failed creating argument value");
        }
        if (json_object_array_put_idx(args, i, val) < 0) {
            grc = TLOG_GRC_ERRNO;
            TLOG_ERRS_RAISECF(grc, "Failed storing argument #%d", i);
        }
        val = NULL;
    }
    grc = tlog_json_object_object_add_path(conf, "args", args);
    if (grc != TLOG_RC_OK) {
        TLOG_ERRS_RAISECS(grc, "Failed storing argument list");
    }
    args = NULL;

    /* Validate the result */
    grc = tlog_play_conf_validate(perrs, conf, TLOG_CONF_ORIGIN_ARGS);
    if (grc != TLOG_RC_OK) {
        TLOG_ERRS_RAISES("Failed to validate loaded configuration");
    }

    grc = TLOG_RC_OK;

cleanup:
    json_object_put(args);
    json_object_put(entry_val);
    json_object_put(val);
    optind = optind_orig;
    opterr = opterr_orig;
    return grc;
}

tlog_grc
tlog_play_conf_cmd_load(struct tlog_errs **perrs,
                        char **phelp, struct json_object **pconf,
                        int argc, char **argv)
{
    tlog_grc grc;
    char *progpath = NULL;
    char *progname = NULL;
    char *help = NULL;
    struct json_object *conf = NULL;

    assert(phelp != NULL);
    assert(pconf != NULL);
    assert(argv != NULL);

    /* Create empty configuration */
    conf = json_object_new_object();
    if (conf == NULL) {
        grc = TLOG_GRC_ERRNO;
        TLOG_ERRS_RAISECS(grc, "Failed creating configuration object");
    }

    /* Extract program name */
    progpath = strdup(argv[0]);
    if (progpath == NULL) {
        grc = TLOG_GRC_ERRNO;
        TLOG_ERRS_RAISECS(grc, "Failed allocating a copy of program path");
    }
    progname = strdup(basename(progpath));
    if (progname == NULL) {
        grc = TLOG_GRC_ERRNO;
        TLOG_ERRS_RAISECS(grc, "Failed allocating program name");
    }

    /* Extract options and positional arguments */
    if (asprintf(&help, tlog_play_conf_cmd_help_fmt, progname) < 0) {
        grc = TLOG_GRC_ERRNO;
        TLOG_ERRS_RAISECS(grc, "Failed formatting help message");
    }
    grc = tlog_play_conf_cmd_load_args(perrs, conf, help, argc, argv);
    if (grc != TLOG_RC_OK) {
        TLOG_ERRS_RAISES("Failed extracting configuration "
                         "from options and arguments");
    }

    /* Validate the result */
    grc = tlog_play_conf_validate(perrs, conf, TLOG_CONF_ORIGIN_ARGS);
    if (grc != TLOG_RC_OK) {
        TLOG_ERRS_RAISES("Validation of loaded configuration failed");
    }

    *phelp = help;
    help = NULL;
    *pconf = conf;
    conf = NULL;
    grc = TLOG_RC_OK;

cleanup:
    free(help);
    free(progname);
    free(progpath);
    json_object_put(conf);
    return grc;
}
