/*
 * Tlog-rec command-line parsing.
 *
 * vim:nomodifiable
 * 
 * ************************* WARNING! DO NOT EDIT! *************************
 * This file is automatically generated from rec_conf_cmd.c.m4.
 * *************************************************************************
 *
 * Copyright (C) 2016 Red Hat
 *
 * This file is part of tlog.
 *
 * Tlog is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Tlog is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with tlog; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <config.h>
#include <tlog/rec_conf_validate.h>
#include <tlog/rec_conf_cmd.h>
#include <tlog/json_misc.h>
#include <tlog/rc.h>
#include <tlog/misc.h>
#include <libgen.h>
#include <stdio.h>
#include <unistd.h>
#include <getopt.h>
#include <string.h>
#include <inttypes.h>
#include <assert.h>

static const char *tlog_rec_conf_cmd_help_fmt =
    "Usage: %1$s [OPTION...] [CMD_FILE [CMD_ARG...]]\n"
    "Record terminal I/O of a program or a user shell.\n"
    "\n"
    "General options:\n"
    "    -h, --help                  Output a command-line usage message and exit\n"
    "    -v, --version               Output version information and exit\n"
    "    --configuration             Output program configuration in JSON and exit\n"
    "    --latency=SECONDS           Cache captured data SECONDS seconds before logging\n"
    "    --payload=BYTES             Limit encoded data to BYTES bytes\n"
    "    -w, --writer=STRING         Use STRING log writer (journal/syslog/file, default file)\n"
    "    --semaphore=FILE            Write \"READY\" to FILE when recording is setup\n"
    "\n"
    "Logged data set options:\n"
    "    --log-input[=BOOL]          Enable/disable logging user input\n"
    "    --log-output[=BOOL]         Enable/disable logging program output\n"
    "    --log-window[=BOOL]         Enable/disable logging terminal window size changes\n"
    "\n"
    "Logging limit options:\n"
    "    --limit-rate=NUMBER         Set logging rate limit to NUMBER of message bytes/sec\n"
    "    --limit-burst=NUMBER        Set logging burst limit to NUMBER of message bytes\n"
    "    --limit-action=STRING       Perform STRING action above limits (pass/delay/drop)\n"
    "\n"
    "File writer options:\n"
    "    -o, --file-path=FILE        Log to FILE file\n"
    "\n"
    "Syslog writer options:\n"
    "    --syslog-facility=STRING    Log with STRING syslog facility\n"
    "    --syslog-priority=STRING    Log with STRING syslog priority\n"
    "\n"
    "Journal writer options:\n"
    "    --journal-priority=STRING   Log with STRING syslog-style priority\n"
    "    --journal-augment[=BOOL]    Enable/disable adding extra journal fields\n"
    "";

static tlog_grc
tlog_rec_conf_cmd_load_args(struct tlog_errs **perrs,
                            struct json_object *conf,
                            const char *help,
                            int argc, char **argv)
{
    /* Option codes */
    enum opt {
        OPT_HELP = 'h',
        OPT_VERSION = 'v',
        OPT_FILE_PATH = 'o',
        OPT_WRITER = 'w',
        OPT_CONFIGURATION = 0x100,
        OPT_LATENCY,
        OPT_PAYLOAD,
        OPT_LOG_INPUT,
        OPT_LOG_OUTPUT,
        OPT_LOG_WINDOW,
        OPT_LIMIT_RATE,
        OPT_LIMIT_BURST,
        OPT_LIMIT_ACTION,
        OPT_SYSLOG_FACILITY,
        OPT_SYSLOG_PRIORITY,
        OPT_JOURNAL_PRIORITY,
        OPT_JOURNAL_AUGMENT,
        OPT_SEMAPHORE,
    };

    /* Description of short options */
    static const char *shortopts = "+:h::v::o:w:";

    /* Description of long options */
    static const struct option longopts[] = {
        {
            .name = "help",
            .val = OPT_HELP,
            .has_arg = optional_argument,
        },
        {
            .name = "version",
            .val = OPT_VERSION,
            .has_arg = optional_argument,
        },
        {
            .name = "configuration",
            .val = OPT_CONFIGURATION,
            .has_arg = optional_argument,
        },
        {
            .name = "latency",
            .val = OPT_LATENCY,
            .has_arg = required_argument,
        },
        {
            .name = "payload",
            .val = OPT_PAYLOAD,
            .has_arg = required_argument,
        },
        {
            .name = "log-input",
            .val = OPT_LOG_INPUT,
            .has_arg = optional_argument,
        },
        {
            .name = "log-output",
            .val = OPT_LOG_OUTPUT,
            .has_arg = optional_argument,
        },
        {
            .name = "log-window",
            .val = OPT_LOG_WINDOW,
            .has_arg = optional_argument,
        },
        {
            .name = "limit-rate",
            .val = OPT_LIMIT_RATE,
            .has_arg = required_argument,
        },
        {
            .name = "limit-burst",
            .val = OPT_LIMIT_BURST,
            .has_arg = required_argument,
        },
        {
            .name = "limit-action",
            .val = OPT_LIMIT_ACTION,
            .has_arg = required_argument,
        },
        {
            .name = "file-path",
            .val = OPT_FILE_PATH,
            .has_arg = required_argument,
        },
        {
            .name = "syslog-facility",
            .val = OPT_SYSLOG_FACILITY,
            .has_arg = required_argument,
        },
        {
            .name = "syslog-priority",
            .val = OPT_SYSLOG_PRIORITY,
            .has_arg = required_argument,
        },
        {
            .name = "journal-priority",
            .val = OPT_JOURNAL_PRIORITY,
            .has_arg = required_argument,
        },
        {
            .name = "journal-augment",
            .val = OPT_JOURNAL_AUGMENT,
            .has_arg = optional_argument,
        },
        {
            .name = "writer",
            .val = OPT_WRITER,
            .has_arg = required_argument,
        },
        {
            .name = "semaphore",
            .val = OPT_SEMAPHORE,
            .has_arg = required_argument,
        },
        {
            .name = NULL
        }
    };

    tlog_grc grc;
    int opterr_orig;
    int optind_orig;
    int optcode;
    const char *optname;
    const char *optpath;
    int64_t val_int;
    double val_double;
    struct json_object *prev_val;
    struct json_object *val = NULL;
    struct json_object *entry_val = NULL;
    struct json_object *args = NULL;
    int end;
    int i;

    /* May be unused if there are no corresponding parameters */
    (void)val_int;
    (void)val_double;
    (void)end;

    /* Ask getopt_long to not print an error message */
    opterr_orig = opterr;
    opterr = 0;

    /* Ask getopt_long to start from the first argument */
    optind_orig = optind;
    optind = 1;

    /* While there are options */
    while ((optcode = getopt_long(argc, argv, 
                                  shortopts, longopts, NULL)) >= 0) {
        switch (optcode) {
        case OPT_HELP:
            optname = "-h/--help";
            optpath = "help";
            grc = tlog_json_object_object_get_path(conf, optpath, &prev_val, NULL);
            if (grc != TLOG_RC_OK) {
                TLOG_ERRS_RAISECF(grc,
                                  "Failed retrieving %s option value", optname);
            }
            if (optarg == NULL ||
                strcasecmp(optarg, "yes") == 0 ||
                strcasecmp(optarg, "on") == 0 ||
                strcasecmp(optarg, "true") == 0) {
                val = json_object_new_boolean(true);
            } else if (strcasecmp(optarg, "no") == 0 ||
                       strcasecmp(optarg, "off") == 0 ||
                       strcasecmp(optarg, "false") == 0) {
                val = json_object_new_boolean(false);
            } else {
                grc = TLOG_RC_FAILURE;
                TLOG_ERRS_RAISEF("Invalid %s option value: %s,\n"
                                 "expecting yes/on/true or no/off/false\n%s",
                                 optname, optarg, help);
            }
            break;

        case OPT_VERSION:
            optname = "-v/--version";
            optpath = "version";
            grc = tlog_json_object_object_get_path(conf, optpath, &prev_val, NULL);
            if (grc != TLOG_RC_OK) {
                TLOG_ERRS_RAISECF(grc,
                                  "Failed retrieving %s option value", optname);
            }
            if (optarg == NULL ||
                strcasecmp(optarg, "yes") == 0 ||
                strcasecmp(optarg, "on") == 0 ||
                strcasecmp(optarg, "true") == 0) {
                val = json_object_new_boolean(true);
            } else if (strcasecmp(optarg, "no") == 0 ||
                       strcasecmp(optarg, "off") == 0 ||
                       strcasecmp(optarg, "false") == 0) {
                val = json_object_new_boolean(false);
            } else {
                grc = TLOG_RC_FAILURE;
                TLOG_ERRS_RAISEF("Invalid %s option value: %s,\n"
                                 "expecting yes/on/true or no/off/false\n%s",
                                 optname, optarg, help);
            }
            break;

        case OPT_CONFIGURATION:
            optname = "--configuration";
            optpath = "configuration";
            grc = tlog_json_object_object_get_path(conf, optpath, &prev_val, NULL);
            if (grc != TLOG_RC_OK) {
                TLOG_ERRS_RAISECF(grc,
                                  "Failed retrieving %s option value", optname);
            }
            if (optarg == NULL ||
                strcasecmp(optarg, "yes") == 0 ||
                strcasecmp(optarg, "on") == 0 ||
                strcasecmp(optarg, "true") == 0) {
                val = json_object_new_boolean(true);
            } else if (strcasecmp(optarg, "no") == 0 ||
                       strcasecmp(optarg, "off") == 0 ||
                       strcasecmp(optarg, "false") == 0) {
                val = json_object_new_boolean(false);
            } else {
                grc = TLOG_RC_FAILURE;
                TLOG_ERRS_RAISEF("Invalid %s option value: %s,\n"
                                 "expecting yes/on/true or no/off/false\n%s",
                                 optname, optarg, help);
            }
            break;

        case OPT_LATENCY:
            optname = "--latency";
            optpath = "latency";
            grc = tlog_json_object_object_get_path(conf, optpath, &prev_val, NULL);
            if (grc != TLOG_RC_OK) {
                TLOG_ERRS_RAISECF(grc,
                                  "Failed retrieving %s option value", optname);
            }
            assert(optarg != NULL);
            if (optarg == NULL) {
                grc = TLOG_RC_FAILURE;
                TLOG_ERRS_RAISEF("Option %s has no value", optname);
            }
            if (sscanf(optarg, "%" SCNd64 " %n", &val_int, &end) < 1 ||
                optarg[end] != 0 || val_int < 1) {
                grc = TLOG_RC_FAILURE;
                TLOG_ERRS_RAISEF("Invalid %s option value: %s\n%s",
                                 optname, optarg, help);
            }
            val = json_object_new_int64(val_int);
            break;

        case OPT_PAYLOAD:
            optname = "--payload";
            optpath = "payload";
            grc = tlog_json_object_object_get_path(conf, optpath, &prev_val, NULL);
            if (grc != TLOG_RC_OK) {
                TLOG_ERRS_RAISECF(grc,
                                  "Failed retrieving %s option value", optname);
            }
            assert(optarg != NULL);
            if (optarg == NULL) {
                grc = TLOG_RC_FAILURE;
                TLOG_ERRS_RAISEF("Option %s has no value", optname);
            }
            if (sscanf(optarg, "%" SCNd64 " %n", &val_int, &end) < 1 ||
                optarg[end] != 0 || val_int < 32) {
                grc = TLOG_RC_FAILURE;
                TLOG_ERRS_RAISEF("Invalid %s option value: %s\n%s",
                                 optname, optarg, help);
            }
            val = json_object_new_int64(val_int);
            break;

        case OPT_LOG_INPUT:
            optname = "--log-input";
            optpath = "log.input";
            grc = tlog_json_object_object_get_path(conf, optpath, &prev_val, NULL);
            if (grc != TLOG_RC_OK) {
                TLOG_ERRS_RAISECF(grc,
                                  "Failed retrieving %s option value", optname);
            }
            if (optarg == NULL ||
                strcasecmp(optarg, "yes") == 0 ||
                strcasecmp(optarg, "on") == 0 ||
                strcasecmp(optarg, "true") == 0) {
                val = json_object_new_boolean(true);
            } else if (strcasecmp(optarg, "no") == 0 ||
                       strcasecmp(optarg, "off") == 0 ||
                       strcasecmp(optarg, "false") == 0) {
                val = json_object_new_boolean(false);
            } else {
                grc = TLOG_RC_FAILURE;
                TLOG_ERRS_RAISEF("Invalid %s option value: %s,\n"
                                 "expecting yes/on/true or no/off/false\n%s",
                                 optname, optarg, help);
            }
            break;

        case OPT_LOG_OUTPUT:
            optname = "--log-output";
            optpath = "log.output";
            grc = tlog_json_object_object_get_path(conf, optpath, &prev_val, NULL);
            if (grc != TLOG_RC_OK) {
                TLOG_ERRS_RAISECF(grc,
                                  "Failed retrieving %s option value", optname);
            }
            if (optarg == NULL ||
                strcasecmp(optarg, "yes") == 0 ||
                strcasecmp(optarg, "on") == 0 ||
                strcasecmp(optarg, "true") == 0) {
                val = json_object_new_boolean(true);
            } else if (strcasecmp(optarg, "no") == 0 ||
                       strcasecmp(optarg, "off") == 0 ||
                       strcasecmp(optarg, "false") == 0) {
                val = json_object_new_boolean(false);
            } else {
                grc = TLOG_RC_FAILURE;
                TLOG_ERRS_RAISEF("Invalid %s option value: %s,\n"
                                 "expecting yes/on/true or no/off/false\n%s",
                                 optname, optarg, help);
            }
            break;

        case OPT_LOG_WINDOW:
            optname = "--log-window";
            optpath = "log.window";
            grc = tlog_json_object_object_get_path(conf, optpath, &prev_val, NULL);
            if (grc != TLOG_RC_OK) {
                TLOG_ERRS_RAISECF(grc,
                                  "Failed retrieving %s option value", optname);
            }
            if (optarg == NULL ||
                strcasecmp(optarg, "yes") == 0 ||
                strcasecmp(optarg, "on") == 0 ||
                strcasecmp(optarg, "true") == 0) {
                val = json_object_new_boolean(true);
            } else if (strcasecmp(optarg, "no") == 0 ||
                       strcasecmp(optarg, "off") == 0 ||
                       strcasecmp(optarg, "false") == 0) {
                val = json_object_new_boolean(false);
            } else {
                grc = TLOG_RC_FAILURE;
                TLOG_ERRS_RAISEF("Invalid %s option value: %s,\n"
                                 "expecting yes/on/true or no/off/false\n%s",
                                 optname, optarg, help);
            }
            break;

        case OPT_LIMIT_RATE:
            optname = "--limit-rate";
            optpath = "limit.rate";
            grc = tlog_json_object_object_get_path(conf, optpath, &prev_val, NULL);
            if (grc != TLOG_RC_OK) {
                TLOG_ERRS_RAISECF(grc,
                                  "Failed retrieving %s option value", optname);
            }
            assert(optarg != NULL);
            if (optarg == NULL) {
                grc = TLOG_RC_FAILURE;
                TLOG_ERRS_RAISEF("Option %s has no value", optname);
            }
            if (sscanf(optarg, "%" SCNd64 " %n", &val_int, &end) < 1 ||
                optarg[end] != 0 || val_int < 0) {
                grc = TLOG_RC_FAILURE;
                TLOG_ERRS_RAISEF("Invalid %s option value: %s\n%s",
                                 optname, optarg, help);
            }
            val = json_object_new_int64(val_int);
            break;

        case OPT_LIMIT_BURST:
            optname = "--limit-burst";
            optpath = "limit.burst";
            grc = tlog_json_object_object_get_path(conf, optpath, &prev_val, NULL);
            if (grc != TLOG_RC_OK) {
                TLOG_ERRS_RAISECF(grc,
                                  "Failed retrieving %s option value", optname);
            }
            assert(optarg != NULL);
            if (optarg == NULL) {
                grc = TLOG_RC_FAILURE;
                TLOG_ERRS_RAISEF("Option %s has no value", optname);
            }
            if (sscanf(optarg, "%" SCNd64 " %n", &val_int, &end) < 1 ||
                optarg[end] != 0 || val_int < 0) {
                grc = TLOG_RC_FAILURE;
                TLOG_ERRS_RAISEF("Invalid %s option value: %s\n%s",
                                 optname, optarg, help);
            }
            val = json_object_new_int64(val_int);
            break;

        case OPT_LIMIT_ACTION:
            optname = "--limit-action";
            optpath = "limit.action";
            grc = tlog_json_object_object_get_path(conf, optpath, &prev_val, NULL);
            if (grc != TLOG_RC_OK) {
                TLOG_ERRS_RAISECF(grc,
                                  "Failed retrieving %s option value", optname);
            }
            {
                const char *list[] = {"pass",
                                      "delay",
                                      "drop"};
                size_t i;
                assert(optarg != NULL);
                if (optarg == NULL) {
                    grc = TLOG_RC_FAILURE;
                    TLOG_ERRS_RAISEF("Option %s has no value", optname);
                }
                for (i = 0;
                     i < TLOG_ARRAY_SIZE(list) && strcmp(optarg, list[i]) != 0;
                     i++);
                if (i >= TLOG_ARRAY_SIZE(list)) {
                    grc = TLOG_RC_FAILURE;
                    TLOG_ERRS_RAISEF("Invalid %s option value: %s\n%s",
                                     optname, optarg, help);
                }
            }
            val = json_object_new_string(optarg);
            break;

        case OPT_FILE_PATH:
            optname = "-o/--file-path";
            optpath = "file.path";
            grc = tlog_json_object_object_get_path(conf, optpath, &prev_val, NULL);
            if (grc != TLOG_RC_OK) {
                TLOG_ERRS_RAISECF(grc,
                                  "Failed retrieving %s option value", optname);
            }
            assert(optarg != NULL);
            if (optarg == NULL) {
                grc = TLOG_RC_FAILURE;
                TLOG_ERRS_RAISEF("Option %s has no value", optname);
            }
            val = json_object_new_string(optarg);
            break;

        case OPT_SYSLOG_FACILITY:
            optname = "--syslog-facility";
            optpath = "syslog.facility";
            grc = tlog_json_object_object_get_path(conf, optpath, &prev_val, NULL);
            if (grc != TLOG_RC_OK) {
                TLOG_ERRS_RAISECF(grc,
                                  "Failed retrieving %s option value", optname);
            }
            {
                const char *list[] = {"auth",
                                      "authpriv",
                                      "cron",
                                      "daemon",
                                      "ftp",
                                      "kern",
                                      "local0",
                                      "local1",
                                      "local2",
                                      "local3",
                                      "local4",
                                      "local5",
                                      "local6",
                                      "local7",
                                      "lpr",
                                      "mail",
                                      "news",
                                      "syslog",
                                      "user",
                                      "uucp"};
                size_t i;
                assert(optarg != NULL);
                if (optarg == NULL) {
                    grc = TLOG_RC_FAILURE;
                    TLOG_ERRS_RAISEF("Option %s has no value", optname);
                }
                for (i = 0;
                     i < TLOG_ARRAY_SIZE(list) && strcmp(optarg, list[i]) != 0;
                     i++);
                if (i >= TLOG_ARRAY_SIZE(list)) {
                    grc = TLOG_RC_FAILURE;
                    TLOG_ERRS_RAISEF("Invalid %s option value: %s\n%s",
                                     optname, optarg, help);
                }
            }
            val = json_object_new_string(optarg);
            break;

        case OPT_SYSLOG_PRIORITY:
            optname = "--syslog-priority";
            optpath = "syslog.priority";
            grc = tlog_json_object_object_get_path(conf, optpath, &prev_val, NULL);
            if (grc != TLOG_RC_OK) {
                TLOG_ERRS_RAISECF(grc,
                                  "Failed retrieving %s option value", optname);
            }
            {
                const char *list[] = {"emerg",
                                      "alert",
                                      "crit",
                                      "err",
                                      "warning",
                                      "notice",
                                      "info",
                                      "debug"};
                size_t i;
                assert(optarg != NULL);
                if (optarg == NULL) {
                    grc = TLOG_RC_FAILURE;
                    TLOG_ERRS_RAISEF("Option %s has no value", optname);
                }
                for (i = 0;
                     i < TLOG_ARRAY_SIZE(list) && strcmp(optarg, list[i]) != 0;
                     i++);
                if (i >= TLOG_ARRAY_SIZE(list)) {
                    grc = TLOG_RC_FAILURE;
                    TLOG_ERRS_RAISEF("Invalid %s option value: %s\n%s",
                                     optname, optarg, help);
                }
            }
            val = json_object_new_string(optarg);
            break;

        case OPT_JOURNAL_PRIORITY:
            optname = "--journal-priority";
            optpath = "journal.priority";
            grc = tlog_json_object_object_get_path(conf, optpath, &prev_val, NULL);
            if (grc != TLOG_RC_OK) {
                TLOG_ERRS_RAISECF(grc,
                                  "Failed retrieving %s option value", optname);
            }
            {
                const char *list[] = {"emerg",
                                      "alert",
                                      "crit",
                                      "err",
                                      "warning",
                                      "notice",
                                      "info",
                                      "debug"};
                size_t i;
                assert(optarg != NULL);
                if (optarg == NULL) {
                    grc = TLOG_RC_FAILURE;
                    TLOG_ERRS_RAISEF("Option %s has no value", optname);
                }
                for (i = 0;
                     i < TLOG_ARRAY_SIZE(list) && strcmp(optarg, list[i]) != 0;
                     i++);
                if (i >= TLOG_ARRAY_SIZE(list)) {
                    grc = TLOG_RC_FAILURE;
                    TLOG_ERRS_RAISEF("Invalid %s option value: %s\n%s",
                                     optname, optarg, help);
                }
            }
            val = json_object_new_string(optarg);
            break;

        case OPT_JOURNAL_AUGMENT:
            optname = "--journal-augment";
            optpath = "journal.augment";
            grc = tlog_json_object_object_get_path(conf, optpath, &prev_val, NULL);
            if (grc != TLOG_RC_OK) {
                TLOG_ERRS_RAISECF(grc,
                                  "Failed retrieving %s option value", optname);
            }
            if (optarg == NULL ||
                strcasecmp(optarg, "yes") == 0 ||
                strcasecmp(optarg, "on") == 0 ||
                strcasecmp(optarg, "true") == 0) {
                val = json_object_new_boolean(true);
            } else if (strcasecmp(optarg, "no") == 0 ||
                       strcasecmp(optarg, "off") == 0 ||
                       strcasecmp(optarg, "false") == 0) {
                val = json_object_new_boolean(false);
            } else {
                grc = TLOG_RC_FAILURE;
                TLOG_ERRS_RAISEF("Invalid %s option value: %s,\n"
                                 "expecting yes/on/true or no/off/false\n%s",
                                 optname, optarg, help);
            }
            break;

        case OPT_WRITER:
            optname = "-w/--writer";
            optpath = "writer";
            grc = tlog_json_object_object_get_path(conf, optpath, &prev_val, NULL);
            if (grc != TLOG_RC_OK) {
                TLOG_ERRS_RAISECF(grc,
                                  "Failed retrieving %s option value", optname);
            }
            {
                const char *list[] = {"journal",
                                      "syslog",
                                      "file"};
                size_t i;
                assert(optarg != NULL);
                if (optarg == NULL) {
                    grc = TLOG_RC_FAILURE;
                    TLOG_ERRS_RAISEF("Option %s has no value", optname);
                }
                for (i = 0;
                     i < TLOG_ARRAY_SIZE(list) && strcmp(optarg, list[i]) != 0;
                     i++);
                if (i >= TLOG_ARRAY_SIZE(list)) {
                    grc = TLOG_RC_FAILURE;
                    TLOG_ERRS_RAISEF("Invalid %s option value: %s\n%s",
                                     optname, optarg, help);
                }
            }
            val = json_object_new_string(optarg);
            break;

        case OPT_SEMAPHORE:
            optname = "--semaphore";
            optpath = "semaphore";
            grc = tlog_json_object_object_get_path(conf, optpath, &prev_val, NULL);
            if (grc != TLOG_RC_OK) {
                TLOG_ERRS_RAISECF(grc,
                                  "Failed retrieving %s option value", optname);
            }
            assert(optarg != NULL);
            if (optarg == NULL) {
                grc = TLOG_RC_FAILURE;
                TLOG_ERRS_RAISEF("Option %s has no value", optname);
            }
            val = json_object_new_string(optarg);
            break;

        case ':':
            for (i = 0; i < (int)TLOG_ARRAY_SIZE(longopts); i++) {
                if (longopts[i].val == optopt) {
                    break;
                }
            }
            grc = TLOG_RC_FAILURE;
            if (i < (int)TLOG_ARRAY_SIZE(longopts)) {
                if (longopts[i].val < 0x100) {
                    TLOG_ERRS_RAISEF("Option -%c/--%s argument is missing\n%s",
                                     longopts[i].val, longopts[i].name, help);
                } else {
                    TLOG_ERRS_RAISEF("Option --%s argument is missing\n%s",
                                     longopts[i].name, help);
                }
            } else {
                TLOG_ERRS_RAISEF("Option -%c argument is missing\n%s",
                                 optopt, help);
            }

        case '?':
            grc = TLOG_RC_FAILURE;
            if (optopt == 0) {
                TLOG_ERRS_RAISEF("Unknown option encountered\n%s",
                                 help);
            } else {
                TLOG_ERRS_RAISEF("Unknown option encountered: -%c\n%s",
                                 optopt, help);
            }

        default:
            grc = TLOG_RC_FAILURE;
            TLOG_ERRS_RAISEF("Unknown option code: %d", optcode);
        }

        if (val == NULL) {
            grc = TLOG_GRC_ERRNO;
            TLOG_ERRS_RAISECF(grc, "Failed creating %s option value", optname);
        }
        if (val != prev_val) {
            grc = tlog_json_object_object_add_path(conf, optpath, val);
            if (grc != TLOG_RC_OK) {
                TLOG_ERRS_RAISECF(grc, "Failed storing %s option value", optname);
            }
        }
        val = NULL;
    }

    /* Add other arguments */
    args = json_object_new_array();
    if (args == NULL) {
        grc = TLOG_GRC_ERRNO;
        TLOG_ERRS_RAISECS(grc, "Failed creating positional argument list");
    }
    for (i = 0; optind < argc; i++, optind++) {
        val = json_object_new_string(argv[optind]);
        if (val == NULL) {
            grc = TLOG_GRC_ERRNO;
            TLOG_ERRS_RAISECS(grc, "Failed creating argument value");
        }
        if (json_object_array_put_idx(args, i, val) < 0) {
            grc = TLOG_GRC_ERRNO;
            TLOG_ERRS_RAISECF(grc, "Failed storing argument #%d", i);
        }
        val = NULL;
    }
    grc = tlog_json_object_object_add_path(conf, "args", args);
    if (grc != TLOG_RC_OK) {
        TLOG_ERRS_RAISECS(grc, "Failed storing argument list");
    }
    args = NULL;

    /* Validate the result */
    grc = tlog_rec_conf_validate(perrs, conf, TLOG_CONF_ORIGIN_ARGS);
    if (grc != TLOG_RC_OK) {
        TLOG_ERRS_RAISES("Failed to validate loaded configuration");
    }

    grc = TLOG_RC_OK;

cleanup:
    json_object_put(args);
    json_object_put(entry_val);
    json_object_put(val);
    optind = optind_orig;
    opterr = opterr_orig;
    return grc;
}

tlog_grc
tlog_rec_conf_cmd_load(struct tlog_errs **perrs,
                       char **phelp, struct json_object **pconf,
                       int argc, char **argv)
{
    tlog_grc grc;
    char *progpath = NULL;
    char *progname = NULL;
    char *help = NULL;
    struct json_object *conf = NULL;

    assert(phelp != NULL);
    assert(pconf != NULL);
    assert(argv != NULL);

    /* Create empty configuration */
    conf = json_object_new_object();
    if (conf == NULL) {
        grc = TLOG_GRC_ERRNO;
        TLOG_ERRS_RAISECS(grc, "Failed creating configuration object");
    }

    /* Extract program name */
    progpath = strdup(argv[0]);
    if (progpath == NULL) {
        grc = TLOG_GRC_ERRNO;
        TLOG_ERRS_RAISECS(grc, "Failed allocating a copy of program path");
    }
    progname = strdup(basename(progpath));
    if (progname == NULL) {
        grc = TLOG_GRC_ERRNO;
        TLOG_ERRS_RAISECS(grc, "Failed allocating program name");
    }

    /* Extract options and positional arguments */
    if (asprintf(&help, tlog_rec_conf_cmd_help_fmt, progname) < 0) {
        grc = TLOG_GRC_ERRNO;
        TLOG_ERRS_RAISECS(grc, "Failed formatting help message");
    }
    grc = tlog_rec_conf_cmd_load_args(perrs, conf, help, argc, argv);
    if (grc != TLOG_RC_OK) {
        TLOG_ERRS_RAISES("Failed extracting configuration "
                         "from options and arguments");
    }

    /* Validate the result */
    grc = tlog_rec_conf_validate(perrs, conf, TLOG_CONF_ORIGIN_ARGS);
    if (grc != TLOG_RC_OK) {
        TLOG_ERRS_RAISES("Validation of loaded configuration failed");
    }

    *phelp = help;
    help = NULL;
    *pconf = conf;
    conf = NULL;
    grc = TLOG_RC_OK;

cleanup:
    free(help);
    free(progname);
    free(progpath);
    json_object_put(conf);
    return grc;
}
