/* Copyright (C) 2002-2005 RealVNC Ltd.  All Rights Reserved.
 * Copyright (C) 2012-2013 D. R. Commander.  All Rights Reserved.
 * Copyright (C) 2013 Brian P. Hinz
 *
 * This is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this software; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301,
 * USA.
 */

//
// Keysyms - defines X keysyms for non-character keys.  All keysyms
// corresponding to characters should be generated by calling
// UnicodeToKeysym.translate().
//

package com.tigervnc.rfb;

public class Keysyms {

  public static final int ISO_Level3_Shift = 0xFE03;
  public static final int BackSpace = 0xFF08;
  public static final int Tab = 0xFF09;
  public static final int Linefeed = 0xFF0A;
  public static final int Clear = 0xFF0B;
  public static final int Return = 0xFF0D;
  public static final int Pause = 0xFF13;
  public static final int Scroll_Lock = 0xFF14;
  public static final int Sys_Req = 0xFF15;
  public static final int Escape = 0xFF1B;
  public static final int Delete = 0xFFFF;

  public static final int Multi_key = 0xFF20;  /* Multi-key character compose */
  public static final int Codeinput = 0xFF37;
  public static final int SingleCandidate = 0xFF3C;
  public static final int MultipleCandidate = 0xFF3D;
  public static final int PreviousCandidate = 0xFF3E;

  public static final int Kanji = 0xFF21;  /* Kanji, Kanji convert */
  public static final int Muhenkan = 0xFF22;  /* Cancel Conversion */
  public static final int Henkan_Mode = 0xFF23;  /* Start/Stop Conversion */
  public static final int Henkan = 0xFF23;  /* Alias for Henkan_Mode */
  public static final int Romaji = 0xFF24;  /* to Romaji */
  public static final int Hiragana = 0xFF25;  /* to Hiragana */
  public static final int Katakana = 0xFF26;  /* to Katakana */
  public static final int Hiragana_Katakana = 0xFF27;  /* Hiragana/Katakana toggle */
  public static final int Zenkaku = 0xFF28;  /* to Zenkaku */
  public static final int Hankaku = 0xFF29;  /* to Hankaku */
  public static final int Zenkaku_Hankaku = 0xFF2A;  /* Zenkaku/Hankaku toggle */
  public static final int Touroku = 0xFF2B;  /* Add to Dictionary */
  public static final int Massyo = 0xFF2C;  /* Delete from Dictionary */
  public static final int Kana_Lock = 0xFF2D;  /* Kana Lock */
  public static final int Kana_Shift = 0xFF2E;  /* Kana Shift */
  public static final int Eisu_Shift = 0xFF2F;  /* Alphanumeric Shift */
  public static final int Eisu_toggle = 0xFF30;  /* Alphanumeric toggle */
  public static final int Kanji_Bangou = 0xFF37;  /* Codeinput */
  public static final int Zen_Koho = 0xFF3D;  /* Multiple/All Candidate(s) */
  public static final int Mae_Koho = 0xFF3E;  /* Previous Candidate */

  public static final int Home = 0xFF50;
  public static final int Left = 0xFF51;
  public static final int Up = 0xFF52;
  public static final int Right = 0xFF53;
  public static final int Down = 0xFF54;
  public static final int Prior = 0xFF55;
  public static final int Page_Up = 0xFF55;
  public static final int Next = 0xFF56;
  public static final int Page_Down = 0xFF56;
  public static final int End = 0xFF57;
  public static final int Begin = 0xFF58;

  public static final int Select = 0xFF60;
  public static final int Print = 0xFF61;
  public static final int Execute = 0xFF62;
  public static final int Insert = 0xFF63;
  public static final int Undo = 0xFF65;
  public static final int Redo = 0xFF66;
  public static final int Menu = 0xFF67;
  public static final int Find = 0xFF68;
  public static final int Cancel = 0xFF69;
  public static final int Help = 0xFF6A;
  public static final int Break = 0xFF6B;
  public static final int Mode_switch = 0xFF7E;
  public static final int script_switch = 0xFF7E;
  public static final int Num_Lock = 0xFF7F;

  public static final int F1 = 0xFFBE;
  public static final int F2 = 0xFFBF;
  public static final int F3 = 0xFFC0;
  public static final int F4 = 0xFFC1;
  public static final int F5 = 0xFFC2;
  public static final int F6 = 0xFFC3;
  public static final int F7 = 0xFFC4;
  public static final int F8 = 0xFFC5;
  public static final int F9 = 0xFFC6;
  public static final int F10 = 0xFFC7;
  public static final int F11 = 0xFFC8;
  public static final int F12 = 0xFFC9;
  public static final int F13 = 0xFFCA;
  public static final int F14 = 0xFFCB;
  public static final int F15 = 0xFFCC;
  public static final int F16 = 0xFFCD;
  public static final int F17 = 0xFFCE;
  public static final int F18 = 0xFFCF;
  public static final int F19 = 0xFFD0;
  public static final int F20 = 0xFFD1;
  public static final int F21 = 0xFFD2;
  public static final int F22 = 0xFFD3;
  public static final int F23 = 0xFFD4;
  public static final int F24 = 0xFFD5;

  public static final int Shift_L = 0xFFE1;
  public static final int Shift_R = 0xFFE2;
  public static final int Control_L = 0xFFE3;
  public static final int Control_R = 0xFFE4;
  public static final int Meta_L = 0xFFE7;
  public static final int Meta_R = 0xFFE8;
  public static final int Alt_L = 0xFFE9;
  public static final int Alt_R = 0xFFEA;

  public static final int Super_L = 0xFFEB;
  public static final int Caps_Lock = 0xFFE5;

  public static final int KP_Enter = 0xFF8D;
  public static final int KP_Home = 0xFF95;
  public static final int KP_Left = 0xFF96;
  public static final int KP_Up = 0xFF97;
  public static final int KP_Right = 0xFF98;
  public static final int KP_Down = 0xFF99;
  public static final int KP_Page_Up = 0xFF9A;
  public static final int KP_Page_Down = 0xFF9B;
  public static final int KP_End = 0xFF9C;
  public static final int KP_Begin = 0xFF9D;
  public static final int KP_Insert = 0xFF9E;
  public static final int KP_Delete = 0xFF9F;
  public static final int KP_0 = 0xFFB0;
  public static final int KP_1 = 0xFFB1;
  public static final int KP_2 = 0xFFB2;
  public static final int KP_3 = 0xFFB3;
  public static final int KP_4 = 0xFFB4;
  public static final int KP_5 = 0xFFB5;
  public static final int KP_6 = 0xFFB6;
  public static final int KP_7 = 0xFFB7;
  public static final int KP_8 = 0xFFB8;
  public static final int KP_9 = 0xFFB9;
  public static final int KP_Decimal = 0xFFAE;
  public static final int KP_Add = 0xFFAB;
  public static final int KP_Subtract = 0xFFAD;
  public static final int KP_Multiply = 0xFFAA;
  public static final int KP_Divide = 0xFFAF;
}
