/*
 * Decompiled with CFR 0.152.
 */
package demo;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Window;
import javax.swing.JPanel;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.DialShape;
import org.jfree.chart.plot.MeterInterval;
import org.jfree.chart.plot.MeterPlot;
import org.jfree.data.Range;
import org.jfree.data.general.DefaultValueDataset;
import org.jfree.data.general.ValueDataset;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RefineryUtilities;

public class MeterChartDemo3
extends ApplicationFrame {
    public MeterChartDemo3(String string) {
        super(string);
        JPanel jPanel = MeterChartDemo3.createDemoPanel();
        jPanel.setPreferredSize(new Dimension(500, 270));
        this.setContentPane(jPanel);
    }

    private static JFreeChart createChart(String string, ValueDataset valueDataset, DialShape dialShape) {
        MeterPlot meterPlot = new MeterPlot(valueDataset);
        meterPlot.setDialShape(dialShape);
        meterPlot.setRange(new Range(0.0, 60.0));
        meterPlot.addInterval(new MeterInterval("Normal", new Range(0.0, 35.0), Color.lightGray, new BasicStroke(2.0f), new Color(0, 255, 0, 64)));
        meterPlot.addInterval(new MeterInterval("Warning", new Range(35.0, 50.0), Color.lightGray, new BasicStroke(2.0f), new Color(255, 255, 0, 64)));
        meterPlot.addInterval(new MeterInterval("Critical", new Range(50.0, 60.0), Color.lightGray, new BasicStroke(2.0f), new Color(255, 0, 0, 128)));
        meterPlot.setNeedlePaint(Color.darkGray);
        meterPlot.setDialBackgroundPaint(Color.white);
        meterPlot.setDialOutlinePaint(Color.gray);
        meterPlot.setMeterAngle(260);
        meterPlot.setTickLabelsVisible(true);
        meterPlot.setTickLabelFont(new Font("Dialog", 1, 10));
        meterPlot.setTickLabelPaint(Color.darkGray);
        meterPlot.setTickSize(5.0);
        meterPlot.setTickPaint(Color.lightGray);
        meterPlot.setValuePaint(Color.black);
        meterPlot.setValueFont(new Font("Dialog", 1, 14));
        JFreeChart jFreeChart = new JFreeChart(string, JFreeChart.DEFAULT_TITLE_FONT, meterPlot, true);
        ChartUtilities.applyCurrentTheme(jFreeChart);
        return jFreeChart;
    }

    public static JPanel createDemoPanel() {
        JPanel jPanel = new JPanel(new GridLayout(1, 3));
        DefaultValueDataset defaultValueDataset = new DefaultValueDataset(23.0);
        ChartPanel chartPanel = new ChartPanel(MeterChartDemo3.createChart("DialShape.PIE", defaultValueDataset, DialShape.PIE));
        ChartPanel chartPanel2 = new ChartPanel(MeterChartDemo3.createChart("DialShape.CHORD", defaultValueDataset, DialShape.CHORD));
        ChartPanel chartPanel3 = new ChartPanel(MeterChartDemo3.createChart("DialShape.CIRCLE", defaultValueDataset, DialShape.CIRCLE));
        jPanel.add(chartPanel);
        jPanel.add(chartPanel2);
        jPanel.add(chartPanel3);
        return jPanel;
    }

    public static void main(String[] stringArray) {
        MeterChartDemo3 meterChartDemo3 = new MeterChartDemo3("JFreeChart: MeterChartDemo3.java");
        meterChartDemo3.pack();
        RefineryUtilities.centerFrameOnScreen((Window)((Object)meterChartDemo3));
        meterChartDemo3.setVisible(true);
    }
}

