/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.util.junit;

import java.awt.Polygon;
import java.awt.Shape;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.util.ShapeUtilities;

public class ShapeUtilitiesTests
extends TestCase {
    static /* synthetic */ Class class$org$jfree$util$junit$ShapeUtilitiesTests;

    public static Test suite() {
        return new TestSuite(class$org$jfree$util$junit$ShapeUtilitiesTests == null ? (class$org$jfree$util$junit$ShapeUtilitiesTests = ShapeUtilitiesTests.class$("org.jfree.util.junit.ShapeUtilitiesTests")) : class$org$jfree$util$junit$ShapeUtilitiesTests);
    }

    public ShapeUtilitiesTests(String name) {
        super(name);
    }

    public void testEqualLine2Ds() {
        ShapeUtilitiesTests.assertTrue((boolean)ShapeUtilities.equal((Line2D)null, (Line2D)null));
        Line2D l1 = new Line2D.Float(1.0f, 2.0f, 3.0f, 4.0f);
        Line2D.Float l2 = new Line2D.Float(1.0f, 2.0f, 3.0f, 4.0f);
        ShapeUtilitiesTests.assertTrue((boolean)ShapeUtilities.equal(l1, l2));
        l1 = new Line2D.Float(4.0f, 3.0f, 2.0f, 1.0f);
        ShapeUtilitiesTests.assertFalse((boolean)ShapeUtilities.equal(l1, l2));
        l2 = new Line2D.Float(4.0f, 3.0f, 2.0f, 1.0f);
        ShapeUtilitiesTests.assertTrue((boolean)ShapeUtilities.equal(l1, l2));
        l1 = new Line2D.Double(4.0, 3.0, 2.0, 1.0);
        ShapeUtilitiesTests.assertTrue((boolean)ShapeUtilities.equal(l1, l2));
    }

    public void testEqualShapes() {
        Shape s1 = null;
        Shape s2 = null;
        ShapeUtilitiesTests.assertTrue((boolean)ShapeUtilities.equal(s1, s2));
        s1 = new Line2D.Double(1.0, 2.0, 3.0, 4.0);
        ShapeUtilitiesTests.assertFalse((boolean)ShapeUtilities.equal(s1, s2));
        s2 = new Line2D.Double(1.0, 2.0, 3.0, 4.0);
        ShapeUtilitiesTests.assertTrue((boolean)ShapeUtilities.equal(s1, s2));
        ShapeUtilitiesTests.assertFalse((boolean)s1.equals(s2));
        s1 = new Rectangle2D.Double(1.0, 2.0, 3.0, 4.0);
        ShapeUtilitiesTests.assertFalse((boolean)ShapeUtilities.equal(s1, s2));
        s2 = new Rectangle2D.Double(1.0, 2.0, 3.0, 4.0);
        ShapeUtilitiesTests.assertTrue((boolean)ShapeUtilities.equal(s1, s2));
        ShapeUtilitiesTests.assertTrue((boolean)s1.equals(s2));
        s1 = new Ellipse2D.Double(1.0, 2.0, 3.0, 4.0);
        ShapeUtilitiesTests.assertFalse((boolean)ShapeUtilities.equal(s1, s2));
        s2 = new Ellipse2D.Double(1.0, 2.0, 3.0, 4.0);
        ShapeUtilitiesTests.assertTrue((boolean)ShapeUtilities.equal(s1, s2));
        s1 = new Arc2D.Double(1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 2);
        ShapeUtilitiesTests.assertFalse((boolean)ShapeUtilities.equal(s1, s2));
        s2 = new Arc2D.Double(1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 2);
        ShapeUtilitiesTests.assertTrue((boolean)ShapeUtilities.equal(s1, s2));
        Polygon p1 = new Polygon(new int[]{0, 1, 0}, new int[]{1, 0, 1}, 3);
        Polygon p2 = new Polygon(new int[]{1, 1, 0}, new int[]{1, 0, 1}, 3);
        s1 = p1;
        s2 = p2;
        ShapeUtilitiesTests.assertFalse((boolean)ShapeUtilities.equal(s1, s2));
        p2 = new Polygon(new int[]{0, 1, 0}, new int[]{1, 0, 1}, 3);
        s2 = p2;
        ShapeUtilitiesTests.assertTrue((boolean)ShapeUtilities.equal(s1, s2));
        GeneralPath g1 = new GeneralPath();
        g1.moveTo(1.0f, 2.0f);
        g1.lineTo(3.0f, 4.0f);
        g1.curveTo(5.0f, 6.0f, 7.0f, 8.0f, 9.0f, 10.0f);
        g1.quadTo(1.0f, 2.0f, 3.0f, 4.0f);
        g1.closePath();
        s1 = g1;
        ShapeUtilitiesTests.assertFalse((boolean)ShapeUtilities.equal(s1, s2));
        GeneralPath g2 = new GeneralPath();
        g2.moveTo(1.0f, 2.0f);
        g2.lineTo(3.0f, 4.0f);
        g2.curveTo(5.0f, 6.0f, 7.0f, 8.0f, 9.0f, 10.0f);
        g2.quadTo(1.0f, 2.0f, 3.0f, 4.0f);
        g2.closePath();
        s2 = g2;
        ShapeUtilitiesTests.assertTrue((boolean)ShapeUtilities.equal(s1, s2));
        ShapeUtilitiesTests.assertFalse((boolean)s1.equals(s2));
    }

    public void testIntersects() {
        Rectangle2D.Float r1 = new Rectangle2D.Float(0.0f, 0.0f, 100.0f, 100.0f);
        Rectangle2D.Float r2 = new Rectangle2D.Float(0.0f, 0.0f, 100.0f, 100.0f);
        ShapeUtilitiesTests.assertTrue((boolean)ShapeUtilities.intersects(r1, r2));
        ((Rectangle2D)r1).setRect(100.0, 0.0, 100.0, 0.0);
        ShapeUtilitiesTests.assertTrue((boolean)ShapeUtilities.intersects(r1, r2));
        ShapeUtilitiesTests.assertTrue((boolean)ShapeUtilities.intersects(r2, r1));
        ((Rectangle2D)r1).setRect(0.0, 0.0, 0.0, 0.0);
        ShapeUtilitiesTests.assertTrue((boolean)ShapeUtilities.intersects(r1, r2));
        ShapeUtilitiesTests.assertTrue((boolean)ShapeUtilities.intersects(r2, r1));
        ((Rectangle2D)r1).setRect(50.0, 50.0, 10.0, 0.0);
        ShapeUtilitiesTests.assertTrue((boolean)ShapeUtilities.intersects(r1, r2));
        ShapeUtilitiesTests.assertTrue((boolean)ShapeUtilities.intersects(r2, r1));
    }

    public void testEqualGeneralPaths() {
        GeneralPath g1 = new GeneralPath();
        g1.moveTo(1.0f, 2.0f);
        g1.lineTo(3.0f, 4.0f);
        g1.curveTo(5.0f, 6.0f, 7.0f, 8.0f, 9.0f, 10.0f);
        g1.quadTo(1.0f, 2.0f, 3.0f, 4.0f);
        g1.closePath();
        GeneralPath g2 = new GeneralPath();
        g2.moveTo(1.0f, 2.0f);
        g2.lineTo(3.0f, 4.0f);
        g2.curveTo(5.0f, 6.0f, 7.0f, 8.0f, 9.0f, 10.0f);
        g2.quadTo(1.0f, 2.0f, 3.0f, 4.0f);
        g2.closePath();
        ShapeUtilitiesTests.assertTrue((boolean)ShapeUtilities.equal(g1, g2));
        g2 = new GeneralPath();
        g2.moveTo(11.0f, 22.0f);
        g2.lineTo(3.0f, 4.0f);
        g2.curveTo(5.0f, 6.0f, 7.0f, 8.0f, 9.0f, 10.0f);
        g2.quadTo(1.0f, 2.0f, 3.0f, 4.0f);
        g2.closePath();
        ShapeUtilitiesTests.assertFalse((boolean)ShapeUtilities.equal(g1, g2));
        g2 = new GeneralPath();
        g2.moveTo(1.0f, 2.0f);
        g2.lineTo(33.0f, 44.0f);
        g2.curveTo(5.0f, 6.0f, 7.0f, 8.0f, 9.0f, 10.0f);
        g2.quadTo(1.0f, 2.0f, 3.0f, 4.0f);
        g2.closePath();
        ShapeUtilitiesTests.assertFalse((boolean)ShapeUtilities.equal(g1, g2));
        g2 = new GeneralPath();
        g2.moveTo(1.0f, 2.0f);
        g2.lineTo(3.0f, 4.0f);
        g2.curveTo(55.0f, 66.0f, 77.0f, 88.0f, 99.0f, 100.0f);
        g2.quadTo(1.0f, 2.0f, 3.0f, 4.0f);
        g2.closePath();
        ShapeUtilitiesTests.assertFalse((boolean)ShapeUtilities.equal(g1, g2));
        g2 = new GeneralPath();
        g2.moveTo(1.0f, 2.0f);
        g2.lineTo(3.0f, 4.0f);
        g2.curveTo(5.0f, 6.0f, 7.0f, 8.0f, 9.0f, 10.0f);
        g2.quadTo(11.0f, 22.0f, 33.0f, 44.0f);
        g2.closePath();
        ShapeUtilitiesTests.assertFalse((boolean)ShapeUtilities.equal(g1, g2));
        g2 = new GeneralPath();
        g2.moveTo(1.0f, 2.0f);
        g2.lineTo(3.0f, 4.0f);
        g2.curveTo(5.0f, 6.0f, 7.0f, 8.0f, 9.0f, 10.0f);
        g2.quadTo(1.0f, 2.0f, 3.0f, 4.0f);
        g2.lineTo(3.0f, 4.0f);
        g2.closePath();
        ShapeUtilitiesTests.assertFalse((boolean)ShapeUtilities.equal(g1, g2));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

