package test.ignore;

import org.testng.ITestNGListener;
import org.testng.TestNG;
import org.testng.annotations.Test;
import test.InvokedMethodListener;
import test.SimpleBaseTest;
import test.ignore.ignorePackage.IgnorePackageSample;
import test.ignore.ignorePackage.subPackage.SubPackageSample;

import static org.assertj.core.api.Assertions.assertThat;

public class IgnoreTest extends SimpleBaseTest {

    @Test
    public void ignore_class_should_not_run_tests() {
        TestNG tng = create(IgnoreClassSample.class);
        InvokedMethodListener listener = new InvokedMethodListener();
        tng.addListener((ITestNGListener) listener);
        tng.run();

        // assertThat(listener.getInvokedMethods()).isEmpty();
        // parentTest is not expected but we are not able to find the annotation on child classes without the test instance
        assertThat(listener.getInvokedMethods()).containsExactly(
                "parentTest"
        );
    }

    @Test
    public void ignore_class_with_inheritance_should_not_run_tests() {
        TestNG tng = create(ChildSample.class);
        InvokedMethodListener listener = new InvokedMethodListener();
        tng.addListener((ITestNGListener) listener);
        tng.run();

        assertThat(listener.getInvokedMethods()).isEmpty();
    }

    @Test
    public void ignore_test_should_not_run_test() {
        TestNG tng = create(IgnoreTestSample.class);
        InvokedMethodListener listener = new InvokedMethodListener();
        tng.addListener((ITestNGListener) listener);
        tng.run();

        assertThat(listener.getInvokedMethods()).containsExactly(
                "test"
        );
    }

    @Test
    public void ignore_package_should_not_run_test() {
        TestNG tng = create(IgnorePackageSample.class, SubPackageSample.class);
        InvokedMethodListener listener = new InvokedMethodListener();
        tng.addListener((ITestNGListener) listener);
        tng.run();

        assertThat(listener.getInvokedMethods()).isEmpty();
    }
}
