/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.ant;

import org.apache.ivy.Ivy;
import org.apache.ivy.util.AbstractMessageLogger;
import org.apache.ivy.util.Checks;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.Task;

public class AntMessageLogger
extends AbstractMessageLogger {
    private static final int PROGRESS_LOG_PERIOD = 1500;
    private ProjectComponent projectComponent;
    private long lastProgressFlush = 0L;
    private StringBuffer buf = new StringBuffer();

    public static void register(Task task, final Ivy ivy) {
        AntMessageLogger logger = new AntMessageLogger((ProjectComponent)task);
        ivy.getLoggerEngine().pushLogger(logger);
        task.getProject().addBuildListener(new BuildListener(){
            private int stackDepth = 0;

            public void buildFinished(BuildEvent event) {
            }

            public void buildStarted(BuildEvent event) {
            }

            public void targetStarted(BuildEvent event) {
            }

            public void targetFinished(BuildEvent event) {
            }

            public void taskStarted(BuildEvent event) {
                ++this.stackDepth;
            }

            public void taskFinished(BuildEvent event) {
                --this.stackDepth;
                if (this.stackDepth == 0) {
                    ivy.getLoggerEngine().popLogger();
                    event.getProject().removeBuildListener((BuildListener)this);
                }
            }

            public void messageLogged(BuildEvent event) {
            }
        });
    }

    protected AntMessageLogger(ProjectComponent antProjectComponent) {
        Checks.checkNotNull(antProjectComponent, "antProjectComponent");
        this.projectComponent = antProjectComponent;
    }

    public void log(String msg, int level) {
        this.projectComponent.log(msg, level);
    }

    public void rawlog(String msg, int level) {
        this.projectComponent.getProject().log(msg, level);
    }

    public void doProgress() {
        this.buf.append(".");
        if (this.lastProgressFlush == 0L) {
            this.lastProgressFlush = System.currentTimeMillis();
        }
        if (System.currentTimeMillis() - this.lastProgressFlush > 1500L) {
            this.projectComponent.log(this.buf.toString());
            this.buf.setLength(0);
            this.lastProgressFlush = System.currentTimeMillis();
        }
    }

    public void doEndProgress(String msg) {
        this.projectComponent.log(this.buf + msg);
        this.buf.setLength(0);
        this.lastProgressFlush = 0L;
    }

    public String toString() {
        return "AntMessageLogger:" + this.projectComponent;
    }
}

