/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.jpa;

import java.util.LinkedList;
import java.util.List;
import org.springframework.instrument.classloading.ResourceOverridingShadowingClassLoader;

class OrmXmlOverridingShadowingClassLoader
extends ResourceOverridingShadowingClassLoader {
    public static final String DEFAULT_ORM_XML_LOCATION = "META-INF/orm.xml";
    private final List<String> providerPrefixes = new LinkedList<String>();

    public OrmXmlOverridingShadowingClassLoader(ClassLoader loader, String realOrmXmlLocation) {
        super(loader);
        this.providerPrefixes.add("oracle.toplink.essentials");
        this.override(DEFAULT_ORM_XML_LOCATION, realOrmXmlLocation);
    }

    protected boolean isClassNameExcludedFromShadowing(String className) {
        for (String providerPrefix : this.providerPrefixes) {
            if (!className.startsWith(providerPrefix)) continue;
            return true;
        }
        return className.startsWith("junit");
    }
}

