/*
 * Decompiled with CFR 0.152.
 */
package net.jini.jeri.kerberos;

import com.sun.jini.logging.Levels;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.net.Socket;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.security.auth.AuthPermission;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosPrincipal;
import net.jini.core.constraint.ClientAuthentication;
import net.jini.core.constraint.ClientMaxPrincipal;
import net.jini.core.constraint.ClientMaxPrincipalType;
import net.jini.core.constraint.ClientMinPrincipal;
import net.jini.core.constraint.ClientMinPrincipalType;
import net.jini.core.constraint.Confidentiality;
import net.jini.core.constraint.ConnectionAbsoluteTime;
import net.jini.core.constraint.ConnectionRelativeTime;
import net.jini.core.constraint.ConstraintAlternatives;
import net.jini.core.constraint.Delegation;
import net.jini.core.constraint.Integrity;
import net.jini.core.constraint.InvocationConstraint;
import net.jini.core.constraint.InvocationConstraints;
import net.jini.core.constraint.ServerAuthentication;
import net.jini.core.constraint.ServerMinPrincipal;
import net.jini.io.UnsupportedConstraintException;
import net.jini.security.AuthenticationPermission;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.MessageProp;
import org.ietf.jgss.Oid;

class KerberosUtil {
    static final Oid krb5MechOid;
    static final Oid krb5NameType;
    static final InvocationConstraints INTEGRITY_REQUIRED_CONSTRAINTS;
    static final InvocationConstraints INTEGRITY_PREFERRED_CONSTRAINTS;
    private static final boolean[] BOOL_TABLE;
    private static final Map depends;

    private KerberosUtil() {
    }

    static boolean canGetSubject() {
        try {
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                sm.checkPermission(new AuthPermission("getSubject"));
            }
            return true;
        }
        catch (SecurityException e) {
            return false;
        }
    }

    static boolean isSupportedConstraintType(InvocationConstraint c) {
        return depends.get(c.getClass()) != null;
    }

    static boolean isSupportableConstraint(InvocationConstraint c) {
        if (c instanceof ConstraintAlternatives) {
            Set alts = ((ConstraintAlternatives)c).elements();
            Class<?> type = null;
            Iterator iter = alts.iterator();
            while (iter.hasNext()) {
                InvocationConstraint alt = (InvocationConstraint)iter.next();
                if (type == null) {
                    type = alt.getClass();
                } else if (type != alt.getClass()) {
                    return false;
                }
                if (!KerberosUtil.isSupportableConstraint(alt)) continue;
                return true;
            }
            return false;
        }
        if (!KerberosUtil.isSupportedConstraintType(c)) {
            return false;
        }
        if (c instanceof Integrity) {
            return c == Integrity.YES;
        }
        if (c instanceof ClientAuthentication) {
            return c == ClientAuthentication.YES;
        }
        if (c instanceof ServerAuthentication) {
            return c == ServerAuthentication.YES;
        }
        if (c instanceof ClientMinPrincipal) {
            Set elems = ((ClientMinPrincipal)c).elements();
            if (elems.size() > 1) {
                return false;
            }
            return elems.iterator().next() instanceof KerberosPrincipal;
        }
        if (c instanceof ClientMinPrincipalType) {
            Set elems = ((ClientMinPrincipalType)c).elements();
            if (elems.size() > 1) {
                return false;
            }
            return elems.contains(KerberosPrincipal.class);
        }
        if (c instanceof ClientMaxPrincipal) {
            Set elems = ((ClientMaxPrincipal)c).elements();
            Iterator iter = elems.iterator();
            while (iter.hasNext()) {
                if (!(iter.next() instanceof KerberosPrincipal)) continue;
                return true;
            }
            return false;
        }
        if (c instanceof ClientMaxPrincipalType) {
            Set elems = ((ClientMaxPrincipalType)c).elements();
            return elems.contains(KerberosPrincipal.class);
        }
        if (c instanceof ServerMinPrincipal) {
            Set elems = ((ServerMinPrincipal)c).elements();
            if (elems.size() > 1) {
                return false;
            }
            return elems.iterator().next() instanceof KerberosPrincipal;
        }
        return true;
    }

    static boolean isSatisfiable(Config config, InvocationConstraint c) {
        if (c instanceof ConstraintAlternatives) {
            Set elems = ((ConstraintAlternatives)c).elements();
            Iterator iter = elems.iterator();
            while (iter.hasNext()) {
                InvocationConstraint elem = (InvocationConstraint)iter.next();
                if (!KerberosUtil.isSatisfiable(config, elem)) continue;
                return true;
            }
            return false;
        }
        if (!KerberosUtil.isSupportedConstraintType(c)) {
            return false;
        }
        if (c instanceof Integrity) {
            return c == Integrity.YES;
        }
        if (c instanceof Confidentiality) {
            return config.encry == (c == Confidentiality.YES);
        }
        if (c instanceof ClientAuthentication) {
            return c == ClientAuthentication.YES;
        }
        if (c instanceof ServerAuthentication) {
            return c == ServerAuthentication.YES;
        }
        if (c instanceof Delegation) {
            return config.deleg == (c == Delegation.YES);
        }
        if (c instanceof ClientMinPrincipal) {
            Set elems = ((ClientMinPrincipal)c).elements();
            if (elems.size() > 1) {
                return false;
            }
            return elems.contains(config.clientPrincipal);
        }
        if (c instanceof ClientMinPrincipalType) {
            Set elems = ((ClientMinPrincipalType)c).elements();
            if (elems.size() > 1) {
                return false;
            }
            return elems.contains(KerberosPrincipal.class);
        }
        if (c instanceof ClientMaxPrincipal) {
            Set elems = ((ClientMaxPrincipal)c).elements();
            return elems.contains(config.clientPrincipal);
        }
        if (c instanceof ClientMaxPrincipalType) {
            Set elems = ((ClientMaxPrincipalType)c).elements();
            return elems.contains(KerberosPrincipal.class);
        }
        if (c instanceof ServerMinPrincipal) {
            Set elems = ((ServerMinPrincipal)c).elements();
            if (elems.size() > 1) {
                return false;
            }
            return elems.contains(config.serverPrincipal);
        }
        return true;
    }

    static boolean collectCpCandidates(InvocationConstraint c, Set cpCandidates) {
        boolean isPrincipalConstraint = false;
        HashSet cpset = new HashSet();
        if (c instanceof ConstraintAlternatives) {
            Set alts = ((ConstraintAlternatives)c).elements();
            Iterator iter = alts.iterator();
            while (iter.hasNext()) {
                Set elems;
                c = (InvocationConstraint)iter.next();
                if (c instanceof ClientMinPrincipal) {
                    isPrincipalConstraint = true;
                    elems = ((ClientMinPrincipal)c).elements();
                    Object cp = elems.iterator().next();
                    if (elems.size() > 1 || !(cp instanceof KerberosPrincipal)) continue;
                    cpset.add(cp);
                    continue;
                }
                if (!(c instanceof ClientMaxPrincipal)) continue;
                isPrincipalConstraint = true;
                elems = ((ClientMaxPrincipal)c).elements();
                Iterator jter = elems.iterator();
                while (jter.hasNext()) {
                    Object elem = jter.next();
                    if (!(elem instanceof KerberosPrincipal)) continue;
                    cpset.add(elem);
                }
            }
        } else if (c instanceof ClientMinPrincipal) {
            isPrincipalConstraint = true;
            Set elems = ((ClientMinPrincipal)c).elements();
            Object cp = elems.iterator().next();
            if (elems.size() > 1 || !(cp instanceof KerberosPrincipal)) {
                return false;
            }
            cpset.add(cp);
        } else if (c instanceof ClientMaxPrincipal) {
            isPrincipalConstraint = true;
            Set elems = ((ClientMaxPrincipal)c).elements();
            Iterator iter = elems.iterator();
            while (iter.hasNext()) {
                Object elem = iter.next();
                if (!(elem instanceof KerberosPrincipal)) continue;
                cpset.add(elem);
            }
        }
        if (isPrincipalConstraint) {
            if (cpCandidates.size() == 0) {
                if (cpset.size() > 0) {
                    cpCandidates.addAll(cpset);
                    return true;
                }
                return false;
            }
            cpCandidates.retainAll(cpset);
            return cpCandidates.size() > 0;
        }
        return true;
    }

    static void checkAuthPermission(KerberosPrincipal local, KerberosPrincipal peer, String action) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            Set<KerberosPrincipal> localps = Collections.singleton(local);
            Set<KerberosPrincipal> peerps = null;
            if (peer != null) {
                peerps = Collections.singleton(peer);
            }
            AuthenticationPermission perm = new AuthenticationPermission(localps, peerps, action);
            sm.checkPermission(perm);
        }
    }

    static void checkAuthPermission(AuthenticationPermission perm) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(perm);
        }
    }

    static boolean containsConstraint(Set constraints, InvocationConstraint candidate) {
        Iterator iter = constraints.iterator();
        while (iter.hasNext()) {
            InvocationConstraint c = (InvocationConstraint)iter.next();
            if (c instanceof ConstraintAlternatives) {
                Set elems = ((ConstraintAlternatives)c).elements();
                return elems.contains(candidate);
            }
            if (!c.equals(candidate)) continue;
            return true;
        }
        return false;
    }

    static GSSCredential getGSSCredential(Subject subj, final KerberosPrincipal principal, final GSSManager manager, final int usage) throws GSSException {
        try {
            return (GSSCredential)Subject.doAs(subj, new PrivilegedExceptionAction(){

                public Object run() throws GSSException {
                    GSSName name = manager.createName(principal.getName(), krb5NameType);
                    return manager.createCredential(name, Integer.MAX_VALUE, krb5MechOid, usage);
                }
            });
        }
        catch (PrivilegedActionException pe) {
            throw (GSSException)pe.getException();
        }
    }

    static void secureThrow(Exception detailedException, UnsupportedConstraintException genericException) throws UnsupportedConstraintException {
        if (KerberosUtil.canGetSubject()) {
            if (detailedException instanceof SecurityException) {
                throw (SecurityException)detailedException;
            }
            throw (UnsupportedConstraintException)detailedException;
        }
        throw genericException;
    }

    static void logThrow(Logger logger, Level level, Class sourceClass, String sourceMethod, String msg, Object[] params, Throwable e) {
        LogRecord r = new LogRecord(level, msg);
        r.setLoggerName(logger.getName());
        r.setSourceClassName(sourceClass.getName());
        r.setSourceMethodName(sourceMethod);
        r.setParameters(params);
        r.setThrown(e);
        logger.log(r);
    }

    static {
        try {
            krb5MechOid = new Oid("1.2.840.113554.1.2.2");
            krb5NameType = new Oid("1.2.840.113554.1.2.2.1");
        }
        catch (GSSException e) {
            throw new ExceptionInInitializerError(e);
        }
        INTEGRITY_REQUIRED_CONSTRAINTS = new InvocationConstraints(Integrity.YES, null);
        INTEGRITY_PREFERRED_CONSTRAINTS = new InvocationConstraints(null, Integrity.YES);
        BOOL_TABLE = new boolean[]{false, true};
        depends = new HashMap();
        InvocationConstraint[] deps = new InvocationConstraint[]{};
        depends.put(ConnectionAbsoluteTime.class, deps);
        depends.put(ConnectionRelativeTime.class, deps);
        depends.put(Integrity.class, deps);
        depends.put(Confidentiality.class, deps);
        depends.put(ClientAuthentication.class, deps);
        depends.put(ServerAuthentication.class, deps);
        deps = new InvocationConstraint[]{ClientAuthentication.YES};
        depends.put(ClientMinPrincipal.class, deps);
        depends.put(ClientMinPrincipalType.class, deps);
        depends.put(ClientMaxPrincipal.class, deps);
        depends.put(ClientMaxPrincipalType.class, deps);
        depends.put(Delegation.class, deps);
        deps = new InvocationConstraint[]{ServerAuthentication.YES};
        depends.put(ServerMinPrincipal.class, deps);
    }

    static class SoftCache {
        private final LRUHashMap hash;
        private ReferenceQueue queue = new ReferenceQueue();

        SoftCache() {
            this(Integer.MAX_VALUE, 8);
        }

        SoftCache(int maxCacheSize) {
            this(maxCacheSize, 8);
        }

        SoftCache(int maxCacheSize, int initialCapacity) {
            this.hash = new LRUHashMap(maxCacheSize, initialCapacity);
        }

        public synchronized Object put(Object key, Object value) {
            this.processQueue();
            ValueCell vc = ValueCell.create(key, value, this.queue);
            return ValueCell.strip(this.hash.put(key, vc), true);
        }

        public synchronized Object get(Object key) {
            this.processQueue();
            return ValueCell.strip(this.hash.get(key), false);
        }

        public synchronized Object remove(Object key) {
            this.processQueue();
            return ValueCell.strip(this.hash.remove(key), true);
        }

        public synchronized void clear() {
            this.processQueue();
            this.hash.clear();
        }

        private void processQueue() {
            ValueCell vc;
            while ((vc = (ValueCell)this.queue.poll()) != null) {
                if (!vc.isValid()) continue;
                this.hash.remove(vc.key);
            }
        }

        private static class ValueCell
        extends SoftReference {
            private static Object INVALID_KEY = new Object();
            private Object key;

            private ValueCell(Object key, Object value, ReferenceQueue queue) {
                super(value, queue);
                this.key = key;
            }

            private static ValueCell create(Object key, Object value, ReferenceQueue queue) {
                if (value == null) {
                    return null;
                }
                return new ValueCell(key, value, queue);
            }

            private static Object strip(Object val, boolean drop) {
                if (val == null) {
                    return null;
                }
                ValueCell vc = (ValueCell)val;
                Object o = vc.get();
                if (drop) {
                    vc.drop();
                }
                return o;
            }

            private boolean isValid() {
                return this.key != INVALID_KEY;
            }

            private void drop() {
                this.clear();
                this.key = INVALID_KEY;
            }
        }

        private class LRUHashMap
        extends LinkedHashMap {
            private int maxCacheSize;

            LRUHashMap(int maxCacheSize, int initialCapacity) {
                super(initialCapacity, 0.75f, true);
                if (maxCacheSize < 0) {
                    throw new IllegalArgumentException("negative cache size");
                }
                this.maxCacheSize = maxCacheSize;
            }

            protected boolean removeEldestEntry(Map.Entry eldest) {
                if (this.size() > this.maxCacheSize) {
                    ValueCell.strip(eldest.getValue(), true);
                    return true;
                }
                return false;
            }
        }
    }

    static class ConnectionOutputStream
    extends OutputStream {
        private static final int bufSize = 8000;
        private final byte[] buf = new byte[8000];
        private int curLen = 0;
        private final Connection connection;

        ConnectionOutputStream(Connection connection) {
            this.connection = connection;
        }

        public synchronized void write(int b) throws IOException {
            if (this.curLen == 8000) {
                this.connection.write(this.buf, 0, this.curLen);
                this.curLen = 0;
            }
            this.buf[this.curLen++] = (byte)b;
        }

        public synchronized void write(byte[] b, int off, int len) throws IOException {
            if (b == null) {
                throw new NullPointerException();
            }
            if (off < 0 || len < 0 || off + len > b.length) {
                throw new IndexOutOfBoundsException();
            }
            if (this.curLen + len >= 8000) {
                int count = 8000 - this.curLen;
                System.arraycopy(b, off, this.buf, this.curLen, count);
                off += count;
                len -= count;
                this.connection.write(this.buf, 0, 8000);
                this.curLen = 0;
            }
            while (len > 8000) {
                this.connection.write(b, off, 8000);
                off += 8000;
                len -= 8000;
            }
            System.arraycopy(b, off, this.buf, this.curLen, len);
            this.curLen += len;
        }

        public synchronized void flush() throws IOException {
            if (this.curLen > 0) {
                this.connection.write(this.buf, 0, this.curLen);
                this.curLen = 0;
            }
            this.connection.flush();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() throws IOException {
            try {
                this.flush();
            }
            finally {
                this.connection.dis.close();
            }
        }
    }

    static class ConnectionInputStream
    extends InputStream {
        private byte[] buf = new byte[0];
        private int offset = 0;
        private final Connection connection;

        ConnectionInputStream(Connection connection) {
            this.connection = connection;
        }

        public synchronized int read() throws IOException {
            if (this.offset == this.buf.length) {
                do {
                    this.buf = this.connection.read();
                } while (this.buf.length == 0);
                this.offset = 0;
            }
            return this.buf[this.offset++];
        }

        public synchronized int read(byte[] b, int off, int len) throws IOException {
            if (b == null) {
                throw new NullPointerException();
            }
            if (off < 0 || len < 0 || off + len > b.length) {
                throw new IndexOutOfBoundsException();
            }
            if (this.offset == this.buf.length) {
                do {
                    this.buf = this.connection.read();
                } while (this.buf.length == 0);
                this.offset = 0;
            }
            int bytes = Math.min(this.buf.length - this.offset, len);
            System.arraycopy(this.buf, this.offset, b, off, bytes);
            this.offset += bytes;
            return bytes;
        }

        public synchronized int available() throws IOException {
            return this.buf.length - this.offset;
        }

        public void close() throws IOException {
            this.connection.dis.close();
        }
    }

    static class Connection {
        protected static final int INTEGRITY_QOP = 2;
        protected static final int PRIVACY_QOP = 0;
        protected final Socket sock;
        protected DataInputStream dis;
        protected DataOutputStream dos;
        KerberosPrincipal clientPrincipal;
        protected GSSContext gssContext;
        protected boolean doEncryption;
        protected boolean doDelegation;
        protected Logger connectionLogger;

        Connection(Socket sock) throws IOException {
            this.sock = sock;
            this.dis = new DataInputStream(sock.getInputStream());
            this.dos = new DataOutputStream(sock.getOutputStream());
        }

        public void close() {
            this.connectionLogger.log(Level.FINE, "closing {0}", this);
            try {
                this.sock.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void write(byte[] buf, int offset, int len) throws IOException {
            MessageProp prop = this.doEncryption ? new MessageProp(0, true) : new MessageProp(2, false);
            byte[] token = null;
            try {
                try {
                    GSSContext gSSContext = this.gssContext;
                    synchronized (gSSContext) {
                        token = this.gssContext.wrap(buf, offset, len, prop);
                    }
                }
                catch (GSSException ge) {
                    IOException ioe = new IOException("Failed to wrap buf into GSS token.");
                    ioe.initCause(ge);
                    throw ioe;
                }
                if (this.doEncryption != prop.getPrivacy()) {
                    throw new IOException("Returned token encryption property is: " + prop.getPrivacy() + ",\nwhile connection " + "encryption requirement is: " + this.doEncryption);
                }
                if (this.connectionLogger.isLoggable(Level.FINEST)) {
                    this.connectionLogger.log(Level.FINEST, "wrapped " + len + " bytes (" + (this.doEncryption ? "" : "not ") + "encrypted) " + "into a " + token.length + " bytes token and " + "sending it over the network");
                }
                this.dos.writeInt(token.length);
                this.dos.write(token);
            }
            catch (IOException ioe) {
                if (this.connectionLogger.isLoggable(Levels.FAILED)) {
                    KerberosUtil.logThrow(this.connectionLogger, Levels.FAILED, this.getClass(), "write", "failed to wrap buf of size {0} into a GSS token,\nconnection is {1},\nthrows ", new Object[]{new Integer(len), this}, ioe);
                }
                throw ioe;
            }
        }

        void flush() throws IOException {
            this.dos.flush();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        byte[] read() throws IOException {
            try {
                byte[] bytes;
                MessageProp prop = new MessageProp(0, false);
                byte[] token = new byte[this.dis.readInt()];
                this.dis.readFully(token);
                try {
                    GSSContext gSSContext = this.gssContext;
                    synchronized (gSSContext) {
                        bytes = this.gssContext.unwrap(token, 0, token.length, prop);
                    }
                }
                catch (GSSException e) {
                    IOException ioe = new IOException("Failed to unwrap a GSS token of length " + token.length);
                    ioe.initCause(e);
                    throw ioe;
                }
                this.doEncryption = prop.getPrivacy();
                if (this.connectionLogger.isLoggable(Level.FINEST)) {
                    this.connectionLogger.log(Level.FINEST, "received a " + token.length + " bytes token (" + (this.doEncryption ? "" : "not ") + "encrypted), " + bytes.length + " bytes when " + "unwrapped");
                }
                return bytes;
            }
            catch (IOException ioe) {
                if (this.connectionLogger.isLoggable(Levels.FAILED)) {
                    KerberosUtil.logThrow(this.connectionLogger, Levels.FAILED, this.getClass(), "read", "read fails on connection {0}, throws", new Object[]{this}, ioe);
                }
                throw ioe;
            }
        }
    }

    static final class ConfigIter {
        private final Set clientPrincipals;
        private final KerberosPrincipal serverPrincipal;
        private Iterator cpIter;
        private final boolean canDeleg;
        private int configId;
        private int numConfigs;

        ConfigIter(Set clientPrincipals, KerberosPrincipal serverPrincipal, boolean canDeleg) {
            this.clientPrincipals = clientPrincipals;
            this.serverPrincipal = serverPrincipal;
            this.canDeleg = canDeleg;
            this.configId = 0;
            this.numConfigs = clientPrincipals.size() * 2;
            if (canDeleg) {
                this.numConfigs *= 2;
            }
        }

        boolean hasNext() {
            return this.configId < this.numConfigs;
        }

        Config next() {
            Config config;
            if (this.configId >= this.numConfigs) {
                throw new NoSuchElementException();
            }
            if (this.configId % this.clientPrincipals.size() == 0) {
                this.cpIter = this.clientPrincipals.iterator();
            }
            KerberosPrincipal cp = (KerberosPrincipal)this.cpIter.next();
            int encryId = this.configId / this.clientPrincipals.size() % 2;
            if (this.canDeleg) {
                int delegId = this.configId / this.clientPrincipals.size() / 2;
                config = new Config(cp, this.serverPrincipal, BOOL_TABLE[encryId], BOOL_TABLE[delegId]);
            } else {
                config = new Config(cp, this.serverPrincipal, BOOL_TABLE[encryId], false);
            }
            ++this.configId;
            return config;
        }
    }

    static final class Config {
        KerberosPrincipal clientPrincipal;
        KerberosPrincipal serverPrincipal;
        boolean encry;
        boolean deleg;
        int prefCount;

        Config(KerberosPrincipal clientPrincipal, KerberosPrincipal serverPrincipal, boolean encry, boolean deleg) {
            this.clientPrincipal = clientPrincipal;
            this.serverPrincipal = serverPrincipal;
            this.encry = encry;
            this.deleg = deleg;
        }

        public String toString() {
            return "Config[clientPrincipal=" + this.clientPrincipal + " serverPrincipal=" + this.serverPrincipal + " encry=" + this.encry + " deleg=" + this.deleg + " prefCount=" + this.prefCount + "]";
        }
    }
}

