/*
 * Decompiled with CFR 0.152.
 */
package com.google.doclava;

import com.google.clearsilver.jsilver.data.Data;
import com.google.doclava.ClassInfo;
import com.google.doclava.ContainerInfo;
import com.google.doclava.ParsedTagInfo;
import com.google.doclava.Project;
import com.google.doclava.SourcePositionInfo;
import com.google.doclava.TagInfo;
import com.google.doclava.TypeInfo;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ThrowsTagInfo
extends ParsedTagInfo {
    private static final Pattern PATTERN = Pattern.compile("(\\S+)\\s+(.*)", 32);
    private ClassInfo mException;

    public ThrowsTagInfo(String name, String kind, String text, ContainerInfo base, SourcePositionInfo sp) {
        super(name, kind, text, base, sp);
    }

    @Override
    public void initVisible(Project project) {
        super.initVisible(project);
        String text = this.text();
        ContainerInfo base = this.getContainer();
        Matcher m = PATTERN.matcher(text);
        if (m.matches()) {
            this.setCommentText(m.group(2));
            String className = m.group(1);
            if (base instanceof ClassInfo) {
                this.mException = ((ClassInfo)base).findClass(className, project);
            }
            if (this.mException == null) {
                this.mException = project.getClassByName(className);
            }
        }
    }

    public ThrowsTagInfo(String name, String kind, String text, ClassInfo exception, String exceptionComment, ContainerInfo base, SourcePositionInfo sp) {
        super(name, kind, text, base, sp);
        this.mException = exception;
        this.setCommentText(exceptionComment);
    }

    public ClassInfo exception() {
        return this.mException;
    }

    public TypeInfo exceptionType() {
        return this.mException != null ? this.mException.asTypeInfo() : null;
    }

    public static void makeHDF(Data data, String base, List<ThrowsTagInfo> tags) {
        int i = 0;
        for (ThrowsTagInfo info : tags) {
            TagInfo.makeHDF(data, base + '.' + i + ".comment", info.commentTags());
            if (info.exceptionType() != null) {
                info.exceptionType().makeHDF(data, base + "." + i + ".type");
            }
            ++i;
        }
    }
}

