/*
 * Decompiled with CFR 0.152.
 */
package com.google.doclava;

import com.google.clearsilver.jsilver.data.Data;
import com.google.doclava.Errors;
import com.google.doclava.InheritedTags;
import com.google.doclava.Project;
import com.google.doclava.SourcePositionInfo;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TagInfo {
    private final String mName;
    private final String mText;
    private final SourcePositionInfo mPosition;
    private String mKind;

    TagInfo(String n, String k, String t, SourcePositionInfo sp) {
        this.mName = n;
        this.mText = t;
        this.mPosition = sp;
        this.mKind = k;
    }

    public void initVisible(Project project) {
    }

    String name() {
        return this.mName;
    }

    String text() {
        return this.mText;
    }

    String kind() {
        return this.mKind;
    }

    SourcePositionInfo position() {
        return this.mPosition;
    }

    void setKind(String kind) {
        this.mKind = kind;
    }

    public void makeHDF(Data data, String base) {
        data.setValue(base + ".name", this.name());
        data.setValue(base + ".text", this.text());
        data.setValue(base + ".kind", this.kind());
    }

    public static void makeHDF(Data data, String base, List<? extends TagInfo> tags) {
        TagInfo.makeHDF(data, base, tags, null, 0, 0);
    }

    public static void makeHDF(Data data, String base, InheritedTags tags) {
        TagInfo.makeHDF(data, base, tags.tags(), tags.inherited(), 0, 0);
    }

    private static int makeHDF(Data data, String base, List<? extends TagInfo> tags, InheritedTags inherited, int j, int depth) {
        if (tags.isEmpty() && inherited != null) {
            j = TagInfo.makeHDF(data, base, inherited.tags(), inherited.inherited(), j, depth + 1);
        } else {
            int i = 0;
            while (i < tags.size()) {
                TagInfo t = tags.get(i);
                if (inherited != null && t.name().equals("@inheritDoc")) {
                    j = TagInfo.makeHDF(data, base, inherited.tags(), inherited.inherited(), j, depth + 1);
                } else {
                    if (t.name().equals("@inheritDoc")) {
                        Errors.error(Errors.BAD_INHERITDOC, t.mPosition, "@inheritDoc on class/method that is not inherited");
                    }
                    t.makeHDF(data, base + "." + j);
                }
                ++i;
                ++j;
            }
        }
        return j;
    }

    static boolean tagsEqual(List<TagInfo> first, List<TagInfo> second) {
        if (first.size() != second.size()) {
            return false;
        }
        for (int i = 0; i < first.size(); ++i) {
            if (!first.get((int)i).mName.equals(second.get((int)i).mName)) {
                return false;
            }
            if (!first.get((int)i).mKind.equals(second.get((int)i).mKind)) {
                return false;
            }
            if (first.get((int)i).mText.equals(second.get((int)i).mText)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return this.mName + ":" + this.mText;
    }
}

