/*
 * Decompiled with CFR 0.152.
 */
package com.google.doclava;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.doclava.AnnotationInstanceInfo;
import com.google.doclava.AnnotationValueInfo;
import com.google.doclava.ClassInfo;
import com.google.doclava.ContainerInfo;
import com.google.doclava.FieldInfo;
import com.google.doclava.MethodInfo;
import com.google.doclava.PackageInfo;
import com.google.doclava.ParamTagInfo;
import com.google.doclava.ParameterInfo;
import com.google.doclava.Project;
import com.google.doclava.SeeTagInfo;
import com.google.doclava.SourcePositionInfo;
import com.google.doclava.TagInfo;
import com.google.doclava.TextTagInfo;
import com.google.doclava.ThrowsTagInfo;
import com.google.doclava.TypeInfo;
import com.sun.javadoc.AnnotationDesc;
import com.sun.javadoc.AnnotationTypeDoc;
import com.sun.javadoc.AnnotationTypeElementDoc;
import com.sun.javadoc.AnnotationValue;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.ExecutableMemberDoc;
import com.sun.javadoc.FieldDoc;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.PackageDoc;
import com.sun.javadoc.ParamTag;
import com.sun.javadoc.Parameter;
import com.sun.javadoc.RootDoc;
import com.sun.javadoc.SeeTag;
import com.sun.javadoc.SourcePosition;
import com.sun.javadoc.Tag;
import com.sun.javadoc.ThrowsTag;
import com.sun.javadoc.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ProjectBuilder {
    private final Map<String, TypeInfo> typesByName = new HashMap<String, TypeInfo>();
    private final Map<PackageDoc, PackageInfo> packages = new HashMap<PackageDoc, PackageInfo>();
    private final Map<ClassDoc, ClassInfo> classes = new HashMap<ClassDoc, ClassInfo>();
    private final Map<ExecutableMemberDoc, MethodInfo> methods = new HashMap<ExecutableMemberDoc, MethodInfo>();
    private final Map<FieldDoc, FieldInfo> fields = new HashMap<FieldDoc, FieldInfo>();
    private final Map<AnnotationDesc, AnnotationInstanceInfo> annotationInstances = new HashMap<AnnotationDesc, AnnotationInstanceInfo>();
    private List<ClassNeedingInit> mClassesNeedingInit = new ArrayList<ClassNeedingInit>();
    private final HashMap<AnnotationValue, AnnotationValueInfo> mAnnotationValues = new HashMap();
    private HashSet<AnnotationValue> mAnnotationValuesNeedingInit = new HashSet();

    public Project build(final RootDoc rootDoc) {
        ArrayList<ClassInfo> classInfos = new ArrayList<ClassInfo>();
        for (ClassDoc classDoc : rootDoc.classes()) {
            classInfos.add(this.obtainClass(classDoc));
        }
        ArrayList<ClassInfo> classesNeedingInit2 = new ArrayList<ClassInfo>();
        while (!this.mClassesNeedingInit.isEmpty()) {
            ClassNeedingInit classNeedingInit = this.mClassesNeedingInit.remove(this.mClassesNeedingInit.size() - 1);
            this.initClass(classNeedingInit.c, classNeedingInit.cl);
            classesNeedingInit2.add(classNeedingInit.cl);
        }
        this.mClassesNeedingInit = null;
        this.finishAnnotationValueInit();
        final ImmutableList<TagInfo> rootTags = ImmutableList.copyOf(this.convertTags(rootDoc.inlineTags(), null));
        final ImmutableMap<ClassDoc, ClassInfo> classDocToClass = ImmutableMap.copyOf(this.classes);
        final ImmutableMap<PackageDoc, PackageInfo> packageDocToPackage = ImmutableMap.copyOf(this.packages);
        final ImmutableList rootClasses = ImmutableList.copyOf(classInfos);
        final ImmutableList<FieldInfo> allFields = ImmutableList.copyOf(this.fields.values());
        final ImmutableList<MethodInfo> allMethods = ImmutableList.copyOf(this.methods.values());
        return new Project(){

            @Override
            public ClassInfo getClassByName(String name) {
                return (ClassInfo)classDocToClass.get(rootDoc.classNamed(name));
            }

            @Override
            public ClassInfo getClassReference(ClassDoc classDoc) {
                if (classDoc == null) {
                    return null;
                }
                ClassInfo classInfo = (ClassInfo)classDocToClass.get(classDoc);
                if (classInfo != null) {
                    return classInfo;
                }
                classInfo = ProjectBuilder.this.docToInfo(classDoc);
                classInfo.setTypeInfo(ProjectBuilder.typeToTypeInfo((Type)classDoc, classInfo));
                return classInfo;
            }

            @Override
            public PackageInfo getPackage(String name) {
                PackageDoc doc = rootDoc.packageNamed(name);
                return (PackageInfo)packageDocToPackage.get(doc);
            }

            @Override
            public List<ClassInfo> rootClasses() {
                return rootClasses;
            }

            @Override
            public List<ClassInfo> allClasses() {
                return new ArrayList<ClassInfo>(classDocToClass.values());
            }

            @Override
            public List<ClassInfo> getClasses(ClassDoc[] classes) {
                if (classes == null) {
                    return null;
                }
                ArrayList<ClassInfo> result = new ArrayList<ClassInfo>();
                for (ClassDoc classDoc : classes) {
                    result.add(this.obtainClass(classDoc));
                }
                return result;
            }

            private ClassInfo obtainClass(ClassDoc classDoc) {
                ClassInfo classInfo = (ClassInfo)classDocToClass.get(classDoc);
                if (classInfo == null) {
                    throw new IllegalArgumentException("Not found: " + classDoc);
                }
                return classInfo;
            }

            @Override
            public List<FieldInfo> getAllFields() {
                return allFields;
            }

            @Override
            public List<MethodInfo> getAllMethods() {
                return allMethods;
            }

            @Override
            public List<TagInfo> getRootTags() {
                return rootTags;
            }
        };
    }

    private void initClass(ClassDoc c, ClassInfo cl) {
        Object[] annotationElements = c instanceof AnnotationTypeDoc ? ((AnnotationTypeDoc)c).elements() : new MethodDoc[]{};
        cl.init(this.obtainType((Type)c), this.convertClasses(c.interfaces()), this.convertTypes(c.interfaceTypes()), this.convertClasses(c.innerClasses()), this.convertMethods((ExecutableMemberDoc[])c.constructors(false)), this.convertMethods((ExecutableMemberDoc[])c.methods(false)), this.convertMethods((ExecutableMemberDoc[])annotationElements), this.convertFields(c.fields(false)), this.convertFields(c.enumConstants()), this.obtainPackage(c.containingPackage()), this.obtainClass(c.containingClass()), this.obtainClass(c.superclass()), this.obtainType(c.superclassType()), this.convertAnnotationInstances(c.annotations()), this.convertClasses(c.innerClasses(false)));
    }

    private TagInfo convertTag(Tag tag) {
        return new TextTagInfo(tag.name(), tag.kind(), tag.text(), this.convertSourcePosition(tag.position()));
    }

    private ThrowsTagInfo convertThrowsTag(ThrowsTag tag, ContainerInfo base) {
        return new ThrowsTagInfo(tag.name(), tag.text(), tag.kind(), this.obtainClass(tag.exception()), tag.exceptionComment(), base, this.convertSourcePosition(tag.position()));
    }

    private ParamTagInfo convertParamTag(ParamTag tag, ContainerInfo base) {
        return new ParamTagInfo(tag.name(), tag.kind(), tag.text(), tag.isTypeParameter(), tag.parameterComment(), tag.parameterName(), base, this.convertSourcePosition(tag.position()));
    }

    private SeeTagInfo convertSeeTag(SeeTag tag, ContainerInfo base) {
        return new SeeTagInfo(tag.name(), tag.kind(), tag.text(), base, this.convertSourcePosition(tag.position()));
    }

    private SourcePositionInfo convertSourcePosition(SourcePosition sp) {
        if (sp == null) {
            return null;
        }
        return new SourcePositionInfo(sp.file().toString(), sp.line(), sp.column());
    }

    private List<TagInfo> convertTags(Tag[] tags, ContainerInfo base) {
        ArrayList<TagInfo> result = new ArrayList<TagInfo>();
        for (Tag tag : tags) {
            if (tag instanceof SeeTag) {
                result.add(this.convertSeeTag((SeeTag)tag, base));
                continue;
            }
            if (tag instanceof ThrowsTag) {
                result.add(this.convertThrowsTag((ThrowsTag)tag, base));
                continue;
            }
            if (tag instanceof ParamTag) {
                result.add(this.convertParamTag((ParamTag)tag, base));
                continue;
            }
            result.add(this.convertTag(tag));
        }
        return result;
    }

    private List<ClassInfo> convertClasses(ClassDoc[] classes) {
        if (classes == null) {
            return null;
        }
        ArrayList<ClassInfo> result = new ArrayList<ClassInfo>();
        for (ClassDoc classDoc : classes) {
            result.add(this.obtainClass(classDoc));
        }
        return result;
    }

    private ParameterInfo convertParameter(Parameter p, SourcePosition pos) {
        if (p == null) {
            return null;
        }
        return new ParameterInfo(p.name(), p.typeName(), this.obtainType(p.type()), this.convertSourcePosition(pos));
    }

    private List<ParameterInfo> convertParameters(Parameter[] p, ExecutableMemberDoc m) {
        ArrayList<ParameterInfo> result = new ArrayList<ParameterInfo>();
        SourcePosition pos = m.position();
        for (Parameter parameter : p) {
            result.add(this.convertParameter(parameter, pos));
        }
        return result;
    }

    private List<TypeInfo> convertTypes(Type[] p) {
        if (p == null) {
            return null;
        }
        ArrayList<TypeInfo> result = new ArrayList<TypeInfo>();
        for (Type type : p) {
            result.add(this.obtainType(type));
        }
        return result;
    }

    private ClassInfo obtainClass(ClassDoc input) {
        if (input == null) {
            return null;
        }
        ClassInfo result = this.classes.get(input);
        if (result != null) {
            return result;
        }
        if (input.name() == null || input.name().equals("")) {
            return null;
        }
        result = this.docToInfo(input);
        if (this.mClassesNeedingInit != null) {
            this.mClassesNeedingInit.add(new ClassNeedingInit(input, result));
        }
        this.classes.put(input, result);
        if (this.mClassesNeedingInit == null) {
            this.initClass(input, result);
        }
        return result;
    }

    private ClassInfo docToInfo(ClassDoc input) {
        return new ClassInfo(input, input.getRawCommentText(), this.convertSourcePosition(input.position()), input.isPublic(), input.isProtected(), input.isPackagePrivate(), input.isPrivate(), input.isStatic(), input.isInterface(), input.isAbstract(), input.isOrdinaryClass(), input.isException(), input.isError(), input.isEnum(), input instanceof AnnotationTypeDoc, input.isFinal(), input.isIncluded(), input.name(), input.qualifiedName());
    }

    private <T extends ExecutableMemberDoc> List<MethodInfo> convertMethods(T[] methods) {
        if (methods == null) {
            return null;
        }
        ArrayList<MethodInfo> result = new ArrayList<MethodInfo>();
        for (T methodDoc : methods) {
            result.add(this.obtainMethod((ExecutableMemberDoc)methodDoc));
        }
        return result;
    }

    private MethodInfo obtainMethod(ExecutableMemberDoc o) {
        String kind;
        MethodInfo result = this.methods.get(o);
        if (result != null) {
            return result;
        }
        if (o == null) {
            return null;
        }
        boolean isAbstract = false;
        MethodInfo overriddenMethod = null;
        TypeInfo returnType = null;
        AnnotationValueInfo annotationElementValue = null;
        if (o instanceof MethodDoc) {
            MethodDoc doc = (MethodDoc)o;
            isAbstract = doc.isAbstract();
            overriddenMethod = this.obtainMethod((ExecutableMemberDoc)doc.overriddenMethod());
            returnType = this.obtainType(doc.returnType());
            if (o instanceof AnnotationTypeElementDoc) {
                kind = "annotationElement";
                AnnotationTypeElementDoc a = (AnnotationTypeElementDoc)o;
                annotationElementValue = this.obtainAnnotationValue(a.defaultValue(), result);
            } else {
                kind = "method";
            }
        } else {
            kind = "constructor";
        }
        ClassInfo containingClass = this.obtainClass(o.containingClass());
        result = new MethodInfo(o.getRawCommentText(), this.convertTypes((Type[])o.typeParameters()), o.name(), o.signature(), containingClass, containingClass, o.isPublic(), o.isProtected(), o.isPackagePrivate(), o.isPrivate(), o.isFinal(), o.isStatic(), o.isSynthetic(), isAbstract, o.isSynchronized(), o.isNative(), kind, o.flatSignature(), overriddenMethod, returnType, this.convertParameters(o.parameters(), o), this.convertClasses(o.thrownExceptions()), this.convertSourcePosition(o.position()), this.convertAnnotationInstances(o.annotations()));
        result.setVarargs(o.isVarArgs());
        result.init(annotationElementValue);
        this.methods.put(o, result);
        return result;
    }

    private List<FieldInfo> convertFields(FieldDoc[] fields) {
        if (fields == null) {
            return null;
        }
        ArrayList<FieldInfo> result = new ArrayList<FieldInfo>();
        for (FieldDoc fieldDoc : fields) {
            result.add(this.obtainField(fieldDoc));
        }
        return result;
    }

    private FieldInfo obtainField(FieldDoc f) {
        FieldInfo result = this.fields.get(f);
        if (result != null) {
            return result;
        }
        result = new FieldInfo(f.name(), this.obtainClass(f.containingClass()), this.obtainClass(f.containingClass()), f.isPublic(), f.isProtected(), f.isPackagePrivate(), f.isPrivate(), f.isFinal(), f.isStatic(), f.isTransient(), f.isVolatile(), f.isSynthetic(), this.obtainType(f.type()), f.getRawCommentText(), f.constantValue(), this.convertSourcePosition(f.position()), this.convertAnnotationInstances(f.annotations()));
        this.fields.put(f, result);
        return result;
    }

    private PackageInfo obtainPackage(PackageDoc p) {
        PackageInfo result = this.packages.get(p);
        if (result == null) {
            result = new PackageInfo(p, p.name(), this.convertSourcePosition(p.position()));
            this.packages.put(p, result);
        }
        return result;
    }

    private TypeInfo obtainType(Type type) {
        if (type == null) {
            return null;
        }
        String string = this.typeToString(type);
        TypeInfo typeInfo = this.typesByName.get(string);
        if (typeInfo != null) {
            return typeInfo;
        }
        typeInfo = ProjectBuilder.typeToTypeInfo(type, this.obtainClass(type.asClassDoc()));
        this.typesByName.put(string, typeInfo);
        if (type.asParameterizedType() != null) {
            typeInfo.setTypeArguments(this.convertTypes(type.asParameterizedType().typeArguments()));
        } else if (type instanceof ClassDoc) {
            typeInfo.setTypeArguments(this.convertTypes((Type[])((ClassDoc)type).typeParameters()));
        } else if (type.asTypeVariable() != null) {
            typeInfo.setBounds(null, this.convertTypes(type.asTypeVariable().bounds()));
            typeInfo.setIsTypeVariable(true);
        } else if (type.asWildcardType() != null) {
            typeInfo.setIsWildcard(true);
            typeInfo.setBounds(this.convertTypes(type.asWildcardType().superBounds()), this.convertTypes(type.asWildcardType().extendsBounds()));
        }
        return typeInfo;
    }

    private String typeToString(Type t) {
        StringBuilder result = new StringBuilder();
        result.append(t.getClass().getName()).append("/").append(t).append("/");
        if (t.asParameterizedType() != null) {
            result.append(t.asParameterizedType()).append("/");
            if (t.asParameterizedType().typeArguments() != null) {
                for (Type ty : t.asParameterizedType().typeArguments()) {
                    result.append(ty).append("/");
                }
            }
        } else {
            result.append("NoParameterizedType//");
        }
        if (t.asTypeVariable() != null) {
            result.append(t.asTypeVariable()).append("/");
            if (t.asTypeVariable().bounds() != null) {
                for (Type ty : t.asTypeVariable().bounds()) {
                    result.append(ty).append("/");
                }
            }
        } else {
            result.append("NoTypeVariable//");
        }
        if (t.asWildcardType() != null) {
            result.append(t.asWildcardType()).append("/");
            if (t.asWildcardType().superBounds() != null) {
                for (Type ty : t.asWildcardType().superBounds()) {
                    result.append(ty).append("/");
                }
            }
            if (t.asWildcardType().extendsBounds() != null) {
                for (Type ty : t.asWildcardType().extendsBounds()) {
                    result.append(ty).append("/");
                }
            }
        } else {
            result.append("NoWildCardType//");
        }
        return result.toString();
    }

    private static TypeInfo typeToTypeInfo(Type t, ClassInfo classInfo) {
        String simpleTypeName = t instanceof ClassDoc ? ((ClassDoc)t).name() : t.simpleTypeName();
        return new TypeInfo(t.isPrimitive(), t.dimension(), simpleTypeName, t.qualifiedTypeName(), classInfo);
    }

    private AnnotationInstanceInfo[] convertAnnotationInstances(AnnotationDesc[] orig) {
        AnnotationInstanceInfo[] out = new AnnotationInstanceInfo[orig.length];
        for (int i = 0; i < orig.length; ++i) {
            out[i] = this.obtainAnnotationInstance(orig[i]);
        }
        return out;
    }

    private AnnotationInstanceInfo obtainAnnotationInstance(AnnotationDesc a) {
        AnnotationInstanceInfo result = this.annotationInstances.get(a);
        if (result != null) {
            return result;
        }
        ClassInfo annotationType = this.obtainClass((ClassDoc)a.annotationType());
        AnnotationDesc.ElementValuePair[] ev = a.elementValues();
        AnnotationValueInfo[] elementValues = new AnnotationValueInfo[ev.length];
        for (int i = 0; i < ev.length; ++i) {
            elementValues[i] = this.obtainAnnotationValue(ev[i].value(), this.obtainMethod((ExecutableMemberDoc)ev[i].element()));
        }
        result = new AnnotationInstanceInfo(annotationType, elementValues);
        this.annotationInstances.put(a, result);
        return result;
    }

    private AnnotationValueInfo obtainAnnotationValue(AnnotationValue o, MethodInfo element) {
        if (o == null) {
            return null;
        }
        AnnotationValueInfo v = this.mAnnotationValues.get(o);
        if (v != null) {
            return v;
        }
        v = new AnnotationValueInfo(element);
        this.mAnnotationValues.put(o, v);
        if (this.mAnnotationValuesNeedingInit != null) {
            this.mAnnotationValuesNeedingInit.add(o);
        } else {
            this.initAnnotationValue(o, v);
        }
        return v;
    }

    private void initAnnotationValue(AnnotationValue o, AnnotationValueInfo v) {
        AnnotationValueInfo[] converted;
        Object orig = o.value();
        if (orig instanceof Type) {
            converted = this.obtainType((Type)orig);
        } else if (orig instanceof FieldDoc) {
            converted = this.obtainField((FieldDoc)orig);
        } else if (orig instanceof AnnotationDesc) {
            converted = this.obtainAnnotationInstance((AnnotationDesc)orig);
        } else if (orig instanceof AnnotationValue[]) {
            AnnotationValue[] old = (AnnotationValue[])orig;
            AnnotationValueInfo[] array = new AnnotationValueInfo[old.length];
            for (int i = 0; i < array.length; ++i) {
                array[i] = this.obtainAnnotationValue(old[i], null);
            }
            converted = array;
        } else {
            converted = orig;
        }
        v.init(converted);
    }

    private void finishAnnotationValueInit() {
        while (this.mAnnotationValuesNeedingInit.size() > 0) {
            HashSet<AnnotationValue> set = this.mAnnotationValuesNeedingInit;
            this.mAnnotationValuesNeedingInit = new HashSet();
            for (AnnotationValue o : set) {
                AnnotationValueInfo v = this.mAnnotationValues.get(o);
                this.initAnnotationValue(o, v);
            }
        }
        this.mAnnotationValuesNeedingInit = null;
    }

    private class ClassNeedingInit {
        ClassDoc c;
        ClassInfo cl;

        ClassNeedingInit(ClassDoc c, ClassInfo cl) {
            this.c = c;
            this.cl = cl;
        }
    }
}

