/*
 * Decompiled with CFR 0.152.
 */
package com.google.clearsilver.jsilver.syntax;

import com.google.clearsilver.jsilver.exceptions.JSilverBadSyntaxException;
import com.google.clearsilver.jsilver.syntax.analysis.AnalysisAdapter;
import com.google.clearsilver.jsilver.syntax.analysis.DepthFirstAdapter;
import com.google.clearsilver.jsilver.syntax.node.ADataCommand;
import com.google.clearsilver.jsilver.syntax.node.AInlineCommand;
import com.google.clearsilver.jsilver.syntax.node.ANoopCommand;
import com.google.clearsilver.jsilver.syntax.node.PCommand;
import com.google.clearsilver.jsilver.syntax.node.TData;

public class InlineRewriter
extends DepthFirstAdapter {
    private static AnalysisAdapter WHITESPACE_STRIPPER = new DepthFirstAdapter(){

        public void caseADataCommand(ADataCommand node) {
            TData data = node.getData();
            if (InlineRewriter.isAllWhitespace(data.getText())) {
                node.replaceBy(new ANoopCommand());
                return;
            }
            throw new JSilverBadSyntaxException("literal text in an inline block may only contain whitespace", data.getText(), null, data.getLine(), data.getPos(), null);
        }

        public void caseAInlineCommand(AInlineCommand node) {
            PCommand command = node.getCommand();
            node.replaceBy(command);
            command.apply(this);
        }
    };

    private static boolean isAllWhitespace(String s) {
        for (int i = 0; i < s.length(); ++i) {
            if (Character.isWhitespace(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public void caseAInlineCommand(AInlineCommand node) {
        node.getCommand().apply(WHITESPACE_STRIPPER);
        node.replaceBy(node.getCommand());
    }
}

