/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider.certpath;

import java.io.IOException;
import java.io.Serializable;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.PublicKey;
import java.security.cert.CertPathBuilderException;
import java.security.cert.CertPathBuilderResult;
import java.security.cert.CertPathBuilderSpi;
import java.security.cert.CertPathParameters;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertStore;
import java.security.cert.CertStoreException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.PKIXCertPathChecker;
import java.security.cert.PolicyNode;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.security.interfaces.DSAPublicKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import javax.security.auth.x500.X500Principal;
import sun.security.provider.certpath.AdjacencyList;
import sun.security.provider.certpath.BasicChecker;
import sun.security.provider.certpath.CertPathHelper;
import sun.security.provider.certpath.CrlRevocationChecker;
import sun.security.provider.certpath.ForwardBuilder;
import sun.security.provider.certpath.ForwardState;
import sun.security.provider.certpath.PolicyChecker;
import sun.security.provider.certpath.PolicyNodeImpl;
import sun.security.provider.certpath.ReverseBuilder;
import sun.security.provider.certpath.ReverseState;
import sun.security.provider.certpath.SunCertPathBuilderException;
import sun.security.provider.certpath.SunCertPathBuilderParameters;
import sun.security.provider.certpath.SunCertPathBuilderResult;
import sun.security.provider.certpath.Vertex;
import sun.security.util.Debug;
import sun.security.x509.PKIXExtensions;

public final class SunCertPathBuilder
extends CertPathBuilderSpi {
    private static final Debug debug = Debug.getInstance("certpath");
    private PKIXBuilderParameters buildParams;
    private CertificateFactory cf;
    private boolean pathCompleted = false;
    private X500Principal targetSubjectDN;
    private PolicyNode policyTreeResult;
    private TrustAnchor trustAnchor;
    private PublicKey finalPublicKey;
    private X509CertSelector targetSel;

    public SunCertPathBuilder() throws CertPathBuilderException {
        try {
            this.cf = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException certificateException) {
            throw new CertPathBuilderException(certificateException);
        }
    }

    public CertPathBuilderResult engineBuild(CertPathParameters certPathParameters) throws CertPathBuilderException, InvalidAlgorithmParameterException {
        Iterator iterator;
        Serializable serializable;
        Object object;
        if (debug != null) {
            debug.println("SunCertPathBuilder.engineBuild(" + certPathParameters + ")");
        }
        if (!(certPathParameters instanceof PKIXBuilderParameters)) {
            throw new InvalidAlgorithmParameterException("inappropriate parameter type, must be an instance of PKIXBuilderParameters");
        }
        boolean bl2 = true;
        if (certPathParameters instanceof SunCertPathBuilderParameters) {
            bl2 = ((SunCertPathBuilderParameters)certPathParameters).getBuildForward();
        }
        if (debug != null) {
            debug.println("buildForward = " + bl2);
        }
        this.buildParams = (PKIXBuilderParameters)certPathParameters;
        Iterator<TrustAnchor> iterator2 = this.buildParams.getTrustAnchors().iterator();
        if (!iterator2.hasNext()) {
            throw new InvalidAlgorithmParameterException("must specify at least one trust anchor");
        }
        while (iterator2.hasNext()) {
            object = iterator2.next();
            if (((TrustAnchor)object).getNameConstraints() == null) continue;
            String string = "name constraints in trust anchor not supported";
            throw new InvalidAlgorithmParameterException(string);
        }
        object = this.buildParams.getTargetCertConstraints();
        if (!(object instanceof X509CertSelector)) {
            throw new InvalidAlgorithmParameterException("the targetCertConstraints parameter must be an X509CertSelector");
        }
        this.targetSel = (X509CertSelector)object;
        this.targetSubjectDN = CertPathHelper.getSubject(this.targetSel);
        if (this.targetSubjectDN == null && (serializable = this.targetSel.getCertificate()) != null) {
            this.targetSubjectDN = ((X509Certificate)serializable).getSubjectX500Principal();
        }
        if (this.targetSubjectDN == null) {
            Object object2;
            serializable = new HashSet();
            iterator = this.buildParams.getCertStores().iterator();
            while (iterator.hasNext()) {
                object2 = iterator.next();
                try {
                    serializable.addAll(((CertStore)object2).getCertificates(this.targetSel));
                    if (serializable.size() <= 1) continue;
                    throw new InvalidAlgorithmParameterException("targetSubject parameter not set and target constraints do not uniquely identify a certificate");
                }
                catch (CertStoreException certStoreException) {
                }
            }
            iterator = serializable.iterator();
            if (iterator.hasNext()) {
                object2 = (X509Certificate)((Object)iterator.next());
                this.targetSubjectDN = ((X509Certificate)object2).getSubjectX500Principal();
            }
        }
        if (this.targetSubjectDN == null) {
            throw new InvalidAlgorithmParameterException("Could not determine unique target subject");
        }
        this.pathCompleted = false;
        this.trustAnchor = null;
        this.finalPublicKey = null;
        this.policyTreeResult = null;
        serializable = new LinkedList();
        iterator = new ArrayList();
        try {
            if (bl2) {
                this.buildForward((List)((Object)iterator), (LinkedList)serializable);
            } else {
                this.buildReverse((List)((Object)iterator), (LinkedList)serializable);
            }
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.println("SunCertPathBuilder.engineBuild() exception in build");
                exception.printStackTrace();
            }
            throw new SunCertPathBuilderException("unable to find valid certification path to requested target", exception, new AdjacencyList((List)((Object)iterator)));
        }
        try {
            if (this.pathCompleted) {
                if (debug != null) {
                    debug.println("SunCertPathBuilder.engineBuild() pathCompleted");
                }
                Collections.reverse(serializable);
                return new SunCertPathBuilderResult(this.cf.generateCertPath((List<? extends Certificate>)((Object)serializable)), this.trustAnchor, this.policyTreeResult, this.finalPublicKey, new AdjacencyList((List)((Object)iterator)));
            }
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.println("SunCertPathBuilder.engineBuild() exception in wrap-up");
                exception.printStackTrace();
            }
            throw new SunCertPathBuilderException("unable to find valid certification path to requested target", exception, new AdjacencyList((List)((Object)iterator)));
        }
        throw new SunCertPathBuilderException("unable to find valid certification path to requested target", new AdjacencyList((List)((Object)iterator)));
    }

    private boolean anchorIsTarget(TrustAnchor trustAnchor, X509CertSelector x509CertSelector) {
        X509Certificate x509Certificate = trustAnchor.getTrustedCert();
        if (x509Certificate != null) {
            return x509CertSelector.match(x509Certificate);
        }
        return false;
    }

    private void buildForward(List list, LinkedList linkedList) throws GeneralSecurityException, IOException {
        if (debug != null) {
            debug.println("SunCertPathBuilder.buildForward()...");
        }
        ForwardState forwardState = new ForwardState();
        forwardState.initState(this.buildParams.getCertPathCheckers());
        list.clear();
        list.add(new LinkedList());
        forwardState.crlChecker = new CrlRevocationChecker(null, this.buildParams.getCertStores(), this.buildParams.getSigProvider(), this.buildParams.getDate());
        this.depthFirstSearchForward(this.targetSubjectDN, forwardState, new ForwardBuilder(this.buildParams, this.targetSubjectDN), list, linkedList);
        if (debug != null) {
            debug.println("SunCertPathBuilder.buildForward() returned from depthFirstSearchForward()");
        }
    }

    private void buildReverse(List list, LinkedList linkedList) throws Exception {
        if (debug != null) {
            debug.println("SunCertPathBuilder.buildReverse()...");
            debug.println("SunCertPathBuilder.buildReverse() InitialPolicies: " + this.buildParams.getInitialPolicies());
        }
        ReverseState reverseState = new ReverseState();
        list.clear();
        list.add(new LinkedList());
        Iterator<TrustAnchor> iterator = this.buildParams.getTrustAnchors().iterator();
        while (iterator.hasNext()) {
            TrustAnchor trustAnchor = iterator.next();
            if (this.anchorIsTarget(trustAnchor, this.targetSel)) {
                this.trustAnchor = trustAnchor;
                this.pathCompleted = true;
                this.finalPublicKey = trustAnchor.getTrustedCert().getPublicKey();
                break;
            }
            reverseState.initState(this.buildParams.getMaxPathLength(), this.buildParams.isExplicitPolicyRequired(), this.buildParams.isPolicyMappingInhibited(), this.buildParams.isAnyPolicyInhibited(), this.buildParams.getCertPathCheckers());
            reverseState.updateState(trustAnchor);
            reverseState.crlChecker = new CrlRevocationChecker(null, this.buildParams.getCertStores(), this.buildParams.getSigProvider(), this.buildParams.getDate());
            try {
                this.depthFirstSearchReverse(null, reverseState, new ReverseBuilder(this.buildParams, this.targetSubjectDN), list, linkedList);
                break;
            }
            catch (Exception exception) {
                if (iterator.hasNext()) continue;
                throw exception;
            }
        }
        if (debug != null) {
            debug.println("SunCertPathBuilder.buildReverse() returned from depthFirstSearchReverse()");
            debug.println("SunCertPathBuilder.buildReverse() certPathList.size: " + linkedList.size());
        }
    }

    private LinkedList addVertices(Collection collection, List list) {
        LinkedList linkedList = (LinkedList)list.get(list.size() - 1);
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            X509Certificate x509Certificate = (X509Certificate)iterator.next();
            Vertex vertex = new Vertex(x509Certificate);
            linkedList.add(vertex);
        }
        return linkedList;
    }

    void depthFirstSearchForward(X500Principal x500Principal, ForwardState forwardState, ForwardBuilder forwardBuilder, List list, LinkedList linkedList) throws GeneralSecurityException, IOException {
        if (debug != null) {
            debug.println("SunCertPathBuilder.depthFirstSearchForward(" + x500Principal + ", " + forwardState.toString() + ")");
        }
        LinkedList linkedList2 = this.addVertices(forwardBuilder.getMatchingCerts(forwardState), list);
        if (debug != null) {
            debug.println("SunCertPathBuilder.depthFirstSearchForward(): certs.size=" + linkedList2.size());
        }
        ListIterator listIterator = linkedList2.listIterator();
        block4: while (listIterator.hasNext()) {
            ForwardState forwardState2 = (ForwardState)forwardState.clone();
            Vertex vertex = (Vertex)listIterator.next();
            X509Certificate x509Certificate = (X509Certificate)vertex.getCertificate();
            try {
                forwardBuilder.verifyCert(x509Certificate, forwardState2, linkedList);
            }
            catch (GeneralSecurityException generalSecurityException) {
                if (debug != null) {
                    debug.println("SunCertPathBuilder.depthFirstSearchForward(): validation failed: " + generalSecurityException);
                }
                vertex.setThrowable(generalSecurityException);
                continue;
            }
            if (forwardBuilder.isPathCompleted(x509Certificate)) {
                BasicChecker basicChecker = null;
                if (debug != null) {
                    debug.println("SunCertPathBuilder.depthFirstSearchForward(): commencing final verification");
                }
                PKIXCertPathChecker pKIXCertPathChecker = null;
                X509Certificate x509Certificate2 = null;
                ArrayList<X509Certificate> arrayList = new ArrayList<X509Certificate>(linkedList);
                if (forwardBuilder.trustAnchor.getTrustedCert() == null) {
                    arrayList.add(0, x509Certificate);
                }
                int n2 = 0;
                HashSet<String> hashSet = new HashSet<String>(1);
                hashSet.add("2.5.29.32.0");
                PolicyNodeImpl policyNodeImpl = new PolicyNodeImpl(null, "2.5.29.32.0", null, false, hashSet, false);
                PolicyChecker policyChecker = new PolicyChecker(this.buildParams.getInitialPolicies(), arrayList.size(), this.buildParams.isExplicitPolicyRequired(), this.buildParams.isPolicyMappingInhibited(), this.buildParams.isAnyPolicyInhibited(), this.buildParams.getPolicyQualifiersRejected(), policyNodeImpl);
                ArrayList<PKIXCertPathChecker> arrayList2 = new ArrayList<PKIXCertPathChecker>(this.buildParams.getCertPathCheckers());
                arrayList2.add(n2, policyChecker);
                ++n2;
                if (forwardState2.keyParamsNeeded()) {
                    PublicKey publicKey = x509Certificate.getPublicKey();
                    if (forwardBuilder.trustAnchor.getTrustedCert() == null) {
                        publicKey = forwardBuilder.trustAnchor.getCAPublicKey();
                        if (debug != null) {
                            debug.println("SunCertPathBuilder.depthFirstSearchForward using buildParams public key: " + publicKey.toString());
                        }
                    }
                    basicChecker = new BasicChecker(publicKey, x509Certificate.getSubjectX500Principal(), this.buildParams.getDate(), this.buildParams.getSigProvider(), true);
                    arrayList2.add(n2, basicChecker);
                    ++n2;
                    if (this.buildParams.isRevocationEnabled()) {
                        arrayList2.add(n2, new CrlRevocationChecker(publicKey, this.buildParams.getCertStores(), this.buildParams.getSigProvider(), this.buildParams.getDate()));
                        ++n2;
                    }
                }
                for (int i2 = 0; i2 < arrayList.size(); ++i2) {
                    Set set;
                    x509Certificate2 = (X509Certificate)arrayList.get(i2);
                    if (debug != null) {
                        debug.println("current subject = " + x509Certificate2.getSubjectX500Principal());
                    }
                    if ((set = x509Certificate2.getCriticalExtensionOIDs()) == null) {
                        set = Collections.EMPTY_SET;
                    }
                    for (int i3 = 0; i3 < arrayList2.size(); ++i3) {
                        pKIXCertPathChecker = (PKIXCertPathChecker)arrayList2.get(i3);
                        if (i3 >= n2 && pKIXCertPathChecker.isForwardCheckingSupported()) continue;
                        if (i2 == 0) {
                            pKIXCertPathChecker.init(false);
                        }
                        try {
                            pKIXCertPathChecker.check(x509Certificate2, set);
                            continue;
                        }
                        catch (CertPathValidatorException certPathValidatorException) {
                            if (debug != null) {
                                debug.println("SunCertPathBuilder.depthFirstSearchForward(): final verification failed: " + certPathValidatorException);
                            }
                            vertex.setThrowable(certPathValidatorException);
                            continue block4;
                        }
                    }
                    Iterator<PKIXCertPathChecker> iterator = this.buildParams.getCertPathCheckers().iterator();
                    while (iterator.hasNext()) {
                        Set<String> set2;
                        PKIXCertPathChecker pKIXCertPathChecker2 = iterator.next();
                        if (!pKIXCertPathChecker2.isForwardCheckingSupported() || (set2 = pKIXCertPathChecker2.getSupportedExtensions()) == null) continue;
                        Iterator<String> iterator2 = set2.iterator();
                        while (iterator2.hasNext()) {
                            set.remove(iterator2.next());
                        }
                    }
                    if (set.isEmpty()) continue;
                    set.remove(PKIXExtensions.BasicConstraints_Id.toString());
                    set.remove(PKIXExtensions.NameConstraints_Id.toString());
                    set.remove(PKIXExtensions.CertificatePolicies_Id.toString());
                    set.remove(PKIXExtensions.PolicyMappings_Id.toString());
                    set.remove(PKIXExtensions.PolicyConstraints_Id.toString());
                    set.remove(PKIXExtensions.InhibitAnyPolicy_Id.toString());
                    set.remove(PKIXExtensions.SubjectAlternativeName_Id.toString());
                    set.remove(PKIXExtensions.KeyUsage_Id.toString());
                    set.remove(PKIXExtensions.ExtendedKeyUsage_Id.toString());
                    if (set.isEmpty()) continue;
                    throw new CertPathValidatorException("unrecognized critical extension(s)");
                }
                if (debug != null) {
                    debug.println("SunCertPathBuilder.depthFirstSearchForward(): final verification succeeded - path completed!");
                }
                this.pathCompleted = true;
                if (forwardBuilder.trustAnchor.getTrustedCert() == null) {
                    forwardBuilder.addCertToPath(x509Certificate, linkedList);
                }
                this.trustAnchor = forwardBuilder.trustAnchor;
                this.finalPublicKey = basicChecker != null ? basicChecker.getPublicKey() : x509Certificate.getPublicKey();
                this.policyTreeResult = policyChecker.getPolicyTree();
                return;
            }
            forwardBuilder.addCertToPath(x509Certificate, linkedList);
            forwardState2.updateState(x509Certificate);
            list.add(new LinkedList());
            vertex.setIndex(list.size() - 1);
            this.depthFirstSearchForward(x509Certificate.getIssuerX500Principal(), forwardState2, forwardBuilder, list, linkedList);
            if (this.pathCompleted) {
                return;
            }
            if (debug != null) {
                debug.println("SunCertPathBuilder.depthFirstSearchForward(): backtracking");
            }
            forwardBuilder.removeFinalCertFromPath(linkedList);
        }
    }

    void depthFirstSearchReverse(X500Principal x500Principal, ReverseState reverseState, ReverseBuilder reverseBuilder, List list, LinkedList linkedList) throws GeneralSecurityException, IOException {
        if (debug != null) {
            debug.println("SunCertPathBuilder.depthFirstSearchReverse(" + x500Principal + ", " + reverseState.toString() + ")");
        }
        LinkedList linkedList2 = this.addVertices(reverseBuilder.getMatchingCerts(reverseState), list);
        if (debug != null) {
            debug.println("SunCertPathBuilder.depthFirstSearchReverse(): certs.size=" + linkedList2.size());
        }
        ListIterator listIterator = linkedList2.listIterator();
        while (listIterator.hasNext()) {
            ReverseState reverseState2 = (ReverseState)reverseState.clone();
            Vertex vertex = (Vertex)listIterator.next();
            X509Certificate x509Certificate = (X509Certificate)vertex.getCertificate();
            try {
                reverseBuilder.verifyCert(x509Certificate, reverseState2, linkedList);
            }
            catch (GeneralSecurityException generalSecurityException) {
                if (debug != null) {
                    debug.println("SunCertPathBuilder.depthFirstSearchReverse(): validation failed: " + generalSecurityException);
                }
                vertex.setThrowable(generalSecurityException);
                continue;
            }
            if (!reverseState.isInitial()) {
                reverseBuilder.addCertToPath(x509Certificate, linkedList);
            }
            this.trustAnchor = reverseState.trustAnchor;
            if (reverseBuilder.isPathCompleted(x509Certificate)) {
                if (debug != null) {
                    debug.println("SunCertPathBuilder.depthFirstSearchReverse(): path completed!");
                }
                this.pathCompleted = true;
                PolicyNodeImpl policyNodeImpl = reverseState2.rootNode;
                if (policyNodeImpl == null) {
                    this.policyTreeResult = null;
                } else {
                    this.policyTreeResult = policyNodeImpl.copyTree();
                    ((PolicyNodeImpl)this.policyTreeResult).setImmutable();
                }
                this.finalPublicKey = x509Certificate.getPublicKey();
                if (this.finalPublicKey instanceof DSAPublicKey && ((DSAPublicKey)this.finalPublicKey).getParams() == null) {
                    this.finalPublicKey = BasicChecker.makeInheritedParamsKey(this.finalPublicKey, reverseState.pubKey);
                }
                return;
            }
            reverseState2.updateState(x509Certificate);
            list.add(new LinkedList());
            vertex.setIndex(list.size() - 1);
            this.depthFirstSearchReverse(x509Certificate.getSubjectX500Principal(), reverseState2, reverseBuilder, list, linkedList);
            if (this.pathCompleted) {
                return;
            }
            if (debug != null) {
                debug.println("SunCertPathBuilder.depthFirstSearchReverse(): backtracking");
            }
            if (reverseState.isInitial()) continue;
            reverseBuilder.removeFinalCertFromPath(linkedList);
        }
        if (debug != null) {
            debug.println("SunCertPathBuilder.depthFirstSearchReverse() all certs in this adjacency list checked");
        }
    }
}

