/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.ui;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import org.isqlviewer.swing.WizardPanel;
import org.isqlviewer.util.BasicUtilities;

public abstract class WizardContainer
extends JDialog {
    public final String STEP_FINAL = "final.step";
    public static final GridBagConstraints UI_CONSTRAINT = new GridBagConstraints(0, 0, 0, 0, 0.0, 0.0, 0, 0, new Insets(1, 1, 1, 1), 0, 0);
    private JButton btnNext = new JButton();
    private JButton btnPrev = new JButton();
    private JButton btnExit = new JButton();
    private JButton btnHome = new JButton();
    private JLabel lblBanner = new JLabel("");
    private JLabel lblComment = new JLabel("");
    private JLabel lblIcon = new JLabel(BasicUtilities.loadIconResource("Database24"));
    private StepPanel contentPane = new StepPanel(null);
    private JPanel pnlBanner = new JPanel(new GridBagLayout());
    private JPanel pnlToolbr = new JPanel(new GridBagLayout());
    private boolean isWizardStarted = false;
    private ArrayList steps = new ArrayList();

    public WizardContainer(Frame frame) {
        super(frame, true);
        this.initUI();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addUserComponent(String string, Component component) {
        ArrayList arrayList = this.steps;
        synchronized (arrayList) {
            this.steps.add(string);
            this.contentPane.add(component, string);
            if (this.isWizardStarted) {
                this.contentPane.showCard(this.getCurrentStep());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertStepAfter(String string, String string2, Component component) {
        ArrayList arrayList = this.steps;
        synchronized (arrayList) {
            int n2 = this.steps.indexOf(string);
            try {
                this.steps.add(++n2, string2);
                this.contentPane.add(component, string2);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.contentPane.add(component, string2);
            if (this.isWizardStarted) {
                this.contentPane.showCard(this.getCurrentStep());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeUserComponent(String string) {
        String string2 = this.getCurrentStep();
        if (string2.equals(string)) {
            return;
        }
        ArrayList arrayList = this.steps;
        synchronized (arrayList) {
            Component component = this.contentPane.getCard(string);
            if (component != null) {
                this.steps.remove(string);
                this.contentPane.remove(component);
                if (this.isWizardStarted) {
                    this.contentPane.showCard(this.getCurrentStep());
                }
            }
        }
    }

    public void setBanner(String string) {
        this.lblBanner.setText(string);
    }

    public void setComment(String string) {
        this.lblComment.setText(string);
    }

    public void setIcon(Icon icon) {
        this.lblIcon.setIcon(icon);
    }

    public void startWizard() {
        if (this.steps.size() >= 1) {
            this.showStep((String)this.steps.get(0));
            this.isWizardStarted = true;
        }
    }

    public void showStep(String string) {
        if (string == null) {
            return;
        }
        String string2 = this.getCurrentStep();
        this.contentPane.showCard(string);
        this.processStepChange(string, string.equals("final.step"), string2);
    }

    public void setNextStepEnabled(boolean bl2) {
        this.btnNext.setEnabled(bl2);
    }

    public void setPreviousStepEnabled(boolean bl2) {
        this.btnPrev.setEnabled(bl2);
    }

    public void setHomeAllowable(boolean bl2) {
        this.btnHome.setVisible(bl2);
        this.btnHome.setEnabled(bl2);
    }

    public abstract void processStepChange(String var1, boolean var2, String var3);

    public boolean isStepValid(String string) {
        return string != null;
    }

    public String getCurrentStep() {
        return this.contentPane.getCurrentCard();
    }

    public void processWindowEvent(WindowEvent windowEvent) {
        switch (windowEvent.getID()) {
            case 200: {
                this.contentPane.showFirstCard();
            }
        }
        super.processWindowEvent(windowEvent);
    }

    private void initUI() {
        this.setDefaultCloseOperation(2);
        JPanel jPanel = (JPanel)this.getContentPane();
        jPanel.setLayout(new GridBagLayout());
        this.configureToolbar();
        this.configureBanner();
        WizardContainer.constrain(0, 0, 1, 1, 0.0, 0.0, 10, 0);
        jPanel.add(Box.createHorizontalStrut(5), UI_CONSTRAINT);
        WizardContainer.constrain(1, 0, 1, 1, 1.0, 0.0, 10, 2);
        jPanel.add((Component)this.pnlBanner, UI_CONSTRAINT);
        WizardContainer.constrain(2, 0, 1, 1, 0.0, 0.0, 10, 0);
        jPanel.add(Box.createHorizontalStrut(5), UI_CONSTRAINT);
        WizardContainer.constrain(0, 1, 3, 1, 1.0, 1.0, 10, 1);
        jPanel.add((Component)this.contentPane, UI_CONSTRAINT);
        WizardContainer.constrain(0, 2, 1, 1, 0.0, 0.0, 10, 0);
        jPanel.add(Box.createHorizontalStrut(5), UI_CONSTRAINT);
        WizardContainer.constrain(1, 2, 1, 1, 1.0, 0.0, 10, 2);
        jPanel.add((Component)this.pnlToolbr, UI_CONSTRAINT);
        WizardContainer.constrain(2, 2, 1, 1, 0.0, 0.0, 10, 0);
        jPanel.add(Box.createHorizontalStrut(5), UI_CONSTRAINT);
    }

    private void configureToolbar() {
        this.btnHome.addActionListener(this.contentPane);
        this.btnPrev.addActionListener(this.contentPane);
        this.btnNext.addActionListener(this.contentPane);
        this.btnExit.addActionListener(this.contentPane);
        this.btnHome.setText(BasicUtilities.getString("Wizard_Home_Text"));
        this.btnPrev.setText(BasicUtilities.getString("Wizard_Prev_Text"));
        this.btnNext.setText(BasicUtilities.getString("Wizard_Next_Text"));
        this.btnExit.setText(BasicUtilities.getString("Wizard_Cancel_Text"));
        this.btnHome.setToolTipText(BasicUtilities.getString("Wizard_Home_Tip"));
        this.btnPrev.setToolTipText(BasicUtilities.getString("Wizard_Prev_Tip"));
        this.btnNext.setToolTipText(BasicUtilities.getString("Wizard_Next_Tip"));
        this.btnExit.setToolTipText(BasicUtilities.getString("Wizard_Cancel_Tip"));
        WizardContainer.constrain(0, 0, 1, 1, 1.0, 0.0, 10, 0);
        this.pnlToolbr.add(Box.createHorizontalGlue(), UI_CONSTRAINT);
        WizardContainer.constrain(1, 0, 1, 1, 0.0, 0.0, 13, 0);
        this.pnlToolbr.add((Component)this.btnHome, UI_CONSTRAINT);
        WizardContainer.constrain(2, 0, 1, 1, 0.0, 0.0, 13, 0);
        this.pnlToolbr.add((Component)this.btnPrev, UI_CONSTRAINT);
        WizardContainer.constrain(3, 0, 1, 1, 0.0, 0.0, 13, 0);
        this.pnlToolbr.add((Component)this.btnNext, UI_CONSTRAINT);
        WizardContainer.constrain(4, 0, 1, 1, 0.0, 0.0, 13, 0);
        this.pnlToolbr.add((Component)this.btnExit, UI_CONSTRAINT);
    }

    private void configureBanner() {
        this.pnlBanner.setBorder(BorderFactory.createLineBorder(UIManager.getColor("TextArea.foreground"), 1));
        this.pnlBanner.setBackground(UIManager.getColor("TextArea.background"));
        this.pnlBanner.setForeground(UIManager.getColor("TextArea.foreground"));
        this.lblBanner.setFont(this.lblBanner.getFont().deriveFont(1, 16.0f));
        this.lblBanner.setForeground(this.pnlBanner.getForeground());
        this.lblBanner.setBackground(this.pnlBanner.getBackground());
        this.lblComment.setFont(this.lblComment.getFont().deriveFont(2, 12.0f));
        this.lblComment.setForeground(this.pnlBanner.getForeground());
        this.lblComment.setBackground(this.pnlBanner.getBackground());
        WizardContainer.constrain(0, 0, 1, 2, 0.0, 0.0, 10, 0);
        this.pnlBanner.add(Box.createHorizontalStrut(12), UI_CONSTRAINT);
        WizardContainer.constrain(0, 0, 2, 1, 1.0, 0.0, 17, 2);
        this.pnlBanner.add((Component)this.lblBanner, UI_CONSTRAINT);
        WizardContainer.constrain(1, 1, 1, 1, 1.0, 0.0, 17, 2);
        this.pnlBanner.add((Component)this.lblComment, UI_CONSTRAINT);
        WizardContainer.constrain(2, 0, 1, 2, 0.0, 0.0, 10, 0);
        this.pnlBanner.add((Component)this.lblIcon, UI_CONSTRAINT);
        WizardContainer.constrain(3, 0, 1, 2, 0.0, 0.0, 10, 0);
        this.pnlBanner.add(Box.createHorizontalStrut(12), UI_CONSTRAINT);
    }

    public static void constrain(int n2, int n3, int n4, int n5, double d2, double d3, int n6, int n7) {
        WizardContainer.UI_CONSTRAINT.gridx = n2;
        WizardContainer.UI_CONSTRAINT.gridy = n3;
        WizardContainer.UI_CONSTRAINT.gridwidth = n4;
        WizardContainer.UI_CONSTRAINT.gridheight = n5;
        WizardContainer.UI_CONSTRAINT.weightx = d2;
        WizardContainer.UI_CONSTRAINT.weighty = d3;
        WizardContainer.UI_CONSTRAINT.anchor = n6;
        WizardContainer.UI_CONSTRAINT.fill = n7;
    }

    public static class 1 {
    }

    private class StepPanel
    extends WizardPanel
    implements ActionListener {
        private StepPanel() {
        }

        public void showCard(Component component) {
            int n2;
            int n3;
            if (component.getParent() != this) {
                this.add(component);
            }
            if ((n3 = this.getVisibleChildIndex()) != -1) {
                this.getComponent(n3).setVisible(false);
            }
            if ((n2 = WizardContainer.this.steps.indexOf(component.getName())) == 0) {
                WizardContainer.this.btnPrev.setEnabled(false);
                if (WizardContainer.this.btnHome.isVisible()) {
                    WizardContainer.this.btnHome.setEnabled(false);
                }
            } else {
                WizardContainer.this.btnPrev.setEnabled(true);
                if (WizardContainer.this.btnHome.isVisible()) {
                    WizardContainer.this.btnHome.setEnabled(true);
                }
            }
            if (n2 == WizardContainer.this.steps.size() - 1) {
                WizardContainer.this.btnNext.setText(BasicUtilities.getString("Wizard_Finish_Text"));
            } else {
                WizardContainer.this.btnNext.setText(BasicUtilities.getString("Wizard_Next_Text"));
            }
            component.setVisible(true);
            this.fireStateChanged(new ChangeEvent(this));
            this.revalidate();
            this.repaint();
        }

        public void showCard(String string) {
            int n2 = this.getComponentCount();
            for (int i2 = 0; i2 < n2; ++i2) {
                Component component = this.getComponent(i2);
                if (!component.getName().equals(string)) continue;
                this.showCard(component);
                break;
            }
        }

        public void showNextCard() {
            if (this.getComponentCount() <= 0) {
                return;
            }
            try {
                String string = this.getCurrentCard();
                int n2 = WizardContainer.this.steps.indexOf(string);
                if (n2 >= WizardContainer.this.steps.size() - 1) {
                    this.showLastCard();
                } else {
                    string = (String)WizardContainer.this.steps.get(++n2);
                    this.showCard(string);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        public void showPreviousCard() {
            if (this.getComponentCount() <= 0) {
                return;
            }
            try {
                String string = this.getCurrentCard();
                int n2 = WizardContainer.this.steps.indexOf(string);
                if (n2 >= 1) {
                    string = (String)WizardContainer.this.steps.get(--n2);
                    this.showCard(string);
                } else {
                    this.showFirstCard();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        public void showFirstCard() {
            if (this.getComponentCount() <= 0) {
                return;
            }
            try {
                String string = (String)WizardContainer.this.steps.get(0);
                this.showCard(string);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        public void showLastCard() {
            if (this.getComponentCount() <= 0) {
                return;
            }
            try {
                String string = (String)WizardContainer.this.steps.get(WizardContainer.this.steps.size() - 1);
                this.showCard(string);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            String string = this.getCurrentCard();
            if (object == WizardContainer.this.btnHome) {
                this.showFirstCard();
                WizardContainer.this.processStepChange(this.getCurrentCard(), false, string);
                return;
            }
            if (object == WizardContainer.this.btnPrev) {
                this.showPreviousCard();
                WizardContainer.this.processStepChange(this.getCurrentCard(), false, string);
                return;
            }
            if (object == WizardContainer.this.btnNext && WizardContainer.this.isStepValid(this.getCurrentCard())) {
                if (WizardContainer.this.steps.indexOf(this.getCurrentCard()) == WizardContainer.this.steps.size() - 1) {
                    WizardContainer.this.processStepChange("final.step", true, string);
                    WizardContainer.this.dispatchEvent(new WindowEvent(WizardContainer.this, 201));
                    return;
                }
                this.showNextCard();
                WizardContainer.this.processStepChange(this.getCurrentCard(), false, string);
                return;
            }
            if (object == WizardContainer.this.btnExit) {
                WizardContainer.this.dispatchEvent(new WindowEvent(WizardContainer.this, 201));
                return;
            }
        }

        public /* synthetic */ StepPanel(1 var2_2) {
            this();
        }
    }
}

