/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.isqlviewer.sql.DatabaseConnection;
import org.isqlviewer.sql.JDBCUtilities;
import org.isqlviewer.util.BasicUtilities;

public class TableSelector
extends JComponent
implements ActionListener {
    private static final GridBagConstraints UI_CONSTRAINT = new GridBagConstraints(0, 0, 0, 0, 0.0, 0.0, 0, 0, new Insets(1, 1, 1, 1), 0, 0);
    private DefaultComboBoxModel mdlCatalogs = new DefaultComboBoxModel();
    private DefaultComboBoxModel mdlSchemas = new DefaultComboBoxModel();
    private DefaultComboBoxModel mdlTables;
    private JComboBox jcbCatalogs = new JComboBox(this.mdlCatalogs);
    private JComboBox jcbSchemas = new JComboBox(this.mdlSchemas);
    private JComboBox jcbTables;
    private DatabaseMetaData dmd;
    private boolean isLoadingTables = false;
    private String lastTable = null;
    private String lastCatalog = null;
    private String lastSchema = null;
    private transient Vector changeListeners;

    public TableSelector(DatabaseMetaData databaseMetaData, boolean bl2) {
        this.dmd = databaseMetaData;
        if (bl2) {
            this.mdlTables = new DefaultComboBoxModel();
            this.jcbTables = new JComboBox(this.mdlTables);
            this.configureCombobox(this.jcbTables);
        }
        this.initCatlogs();
        this.initSchemas();
        try {
            this.initUI(bl2);
        }
        catch (Throwable throwable) {
            BasicUtilities.HandleException(throwable);
        }
        if (this.mdlSchemas == null && this.mdlCatalogs == null && !bl2) {
            this.dmd = null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        String string = (String)((JComboBox)object).getSelectedItem();
        String string2 = null;
        if (this.isLoadingTables) {
            return;
        }
        if (object == this.jcbCatalogs) {
            String string3 = string2 = this.lastCatalog == null ? "" : this.lastCatalog;
            if (string2.equals(string)) return;
            this.lastCatalog = string;
            this.loadTableNames();
        } else if (object == this.jcbSchemas) {
            String string4 = string2 = this.lastSchema == null ? "" : this.lastSchema;
            if (string2.equals(string)) return;
            this.lastSchema = string;
            this.loadTableNames();
        } else if (object == this.jcbTables) {
            String string5 = string2 = this.lastTable == null ? "" : this.lastTable;
            if (string2.equals(string)) return;
            this.lastTable = string;
        }
        this.fireStateChanged(new ChangeEvent(this));
    }

    public void setEnabled(boolean bl2) {
        if (this.jcbTables != null) {
            this.jcbTables.setEnabled(bl2);
        }
        if (this.jcbCatalogs != null) {
            this.jcbCatalogs.setEnabled(bl2);
        }
        if (this.jcbSchemas != null) {
            this.jcbSchemas.setEnabled(bl2);
        }
    }

    public boolean compareSelection(TableSelector tableSelector) {
        return !(this.jcbCatalogs.isEnabled() && tableSelector.jcbCatalogs.isEnabled() && !tableSelector.getSelectedCatalog().equalsIgnoreCase(this.getSelectedCatalog()) || this.jcbSchemas.isEnabled() && tableSelector.jcbSchemas.isEnabled() && !tableSelector.getSelectedSchema().equalsIgnoreCase(this.getSelectedSchema()) || this.jcbTables != null && tableSelector.jcbTables != null && !tableSelector.getSelectedTable().equalsIgnoreCase(this.getSelectedTable()));
    }

    public void updateMetaData(DatabaseConnection databaseConnection) {
        if (databaseConnection == null) {
            this.mdlTables.removeAllElements();
            this.mdlSchemas.removeAllElements();
            this.mdlCatalogs.removeAllElements();
            this.setEnabled(false);
        } else {
            this.dmd = databaseConnection.getDatabaseInformation();
            this.setEnabled(true);
            this.initCatlogs();
            this.initSchemas();
            this.setSelectedCatalog(databaseConnection.getCatalog());
            this.setSelectedSchema(databaseConnection.getSchema());
        }
    }

    public void setSelectedCatalog(String string) {
        if (string == null) {
            if (this.mdlCatalogs.getSize() >= 1) {
                this.jcbCatalogs.setSelectedIndex(0);
            }
        } else if (this.jcbCatalogs.isEnabled() && this.mdlCatalogs.getIndexOf(string) >= 0) {
            this.mdlCatalogs.setSelectedItem(string);
        }
    }

    public void setSelectedSchema(String string) {
        if (string == null) {
            if (this.mdlSchemas.getSize() >= 1) {
                this.jcbSchemas.setSelectedIndex(0);
            }
        } else if (this.jcbSchemas.isEnabled() && this.mdlSchemas.getIndexOf(string) >= 0) {
            this.mdlSchemas.setSelectedItem(string);
        }
    }

    public void setSelectedTable(String string) {
        if (this.mdlTables == null) {
            return;
        }
        if (string == null) {
            if (this.mdlTables.getSize() >= 1) {
                this.jcbTables.setSelectedIndex(0);
            }
        } else if (this.jcbTables.isEnabled() && this.mdlTables.getIndexOf(string) >= 0) {
            this.mdlTables.setSelectedItem(string);
        }
    }

    public void setTablesEditable(boolean bl2) {
        if (this.jcbTables != null) {
            this.jcbTables.setEditable(bl2);
        }
    }

    public String getSelectedTable() {
        if (this.mdlTables == null) {
            return null;
        }
        return (String)this.mdlTables.getSelectedItem();
    }

    public String getQualifiedTable() {
        String string = this.getSelectedSchema();
        if (string != null) {
            return string + "." + this.getSelectedTable();
        }
        return this.getSelectedTable();
    }

    public String getSelectedCatalog() {
        if (this.mdlCatalogs == null || this.mdlCatalogs.getSize() == 0) {
            return null;
        }
        return (String)this.mdlCatalogs.getSelectedItem();
    }

    public String getSelectedSchema() {
        if (this.mdlSchemas == null || this.mdlSchemas.getSize() == 0) {
            return null;
        }
        return (String)this.mdlSchemas.getSelectedItem();
    }

    public void removeChangeListener(ChangeListener changeListener) {
        if (this.changeListeners != null && this.changeListeners.contains(changeListener)) {
            Vector vector = (Vector)this.changeListeners.clone();
            vector.removeElement(changeListener);
            this.changeListeners = vector;
        }
    }

    public void addChangeListener(ChangeListener changeListener) {
        Vector vector;
        Vector vector2 = vector = this.changeListeners == null ? new Vector(2) : (Vector)this.changeListeners.clone();
        if (!vector.contains(changeListener)) {
            vector.addElement(changeListener);
            this.changeListeners = vector;
        }
    }

    public void fireStateChanged(ChangeEvent changeEvent) {
        if (this.changeListeners != null) {
            Vector vector = this.changeListeners;
            int n2 = vector.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                try {
                    ((ChangeListener)vector.elementAt(i2)).stateChanged(changeEvent);
                    continue;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }

    private void initUI(boolean bl2) {
        this.setLayout(new GridBagLayout());
        TableSelector.constrain(0, 0, 1, 1, 0.0, 0.0, 10, 0);
        this.add((Component)new JLabel(BasicUtilities.getString("Select_Catalog")), UI_CONSTRAINT);
        TableSelector.constrain(1, 0, 1, 1, 1.0, 0.0, 10, 2);
        this.add((Component)this.jcbCatalogs, UI_CONSTRAINT);
        TableSelector.constrain(2, 0, 1, 1, 0.0, 0.0, 10, 0);
        this.add((Component)new JLabel(BasicUtilities.getString("Select_Schema")), UI_CONSTRAINT);
        TableSelector.constrain(3, 0, 1, 1, 1.0, 0.0, 10, 2);
        this.add((Component)this.jcbSchemas, UI_CONSTRAINT);
        if (bl2) {
            TableSelector.constrain(0, 1, 1, 1, 0.0, 0.0, 10, 0);
            this.add((Component)new JLabel(BasicUtilities.getString("Select_Table")), UI_CONSTRAINT);
            TableSelector.constrain(1, 1, 3, 1, 1.0, 0.0, 10, 2);
            this.add((Component)this.jcbTables, UI_CONSTRAINT);
            if (this.mdlTables.getSize() >= 1) {
                this.jcbTables.setSelectedIndex(0);
            }
        }
        if (this.mdlCatalogs.getSize() >= 1) {
            this.jcbCatalogs.setSelectedIndex(0);
        }
        if (this.mdlSchemas.getSize() >= 1) {
            this.jcbSchemas.setSelectedIndex(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initCatlogs() {
        ResultSet resultSet = null;
        try {
            resultSet = this.dmd.getCatalogs();
            Object[] objectArray = JDBCUtilities.getSingleColumn(resultSet, 1, null).toArray();
            this.mdlCatalogs.removeAllElements();
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                String string;
                if (objectArray[i2] == null || (string = objectArray[i2].toString()).trim().length() < 1) continue;
                this.mdlCatalogs.addElement(string.trim());
            }
            this.configureCombobox(this.jcbCatalogs);
            this.jcbCatalogs.setEnabled(this.mdlCatalogs.getSize() >= 1);
        }
        catch (Throwable throwable) {
        }
        finally {
            try {
                resultSet.close();
            }
            catch (Throwable throwable) {}
            resultSet = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadTableNames() {
        if (this.mdlTables == null || this.jcbTables == null || this.dmd == null || this.isLoadingTables) {
            return;
        }
        ResultSet resultSet = null;
        String string = this.getSelectedCatalog();
        String string2 = this.getSelectedSchema();
        this.isLoadingTables = true;
        try {
            resultSet = this.dmd.getTables(string, string2, "%", null);
            Object[] objectArray = JDBCUtilities.getSingleColumn(resultSet, "TABLE_NAME", null);
            this.mdlTables.removeAllElements();
            if (objectArray != null) {
                for (int i2 = 0; i2 < objectArray.length; ++i2) {
                    this.mdlTables.addElement(objectArray[i2]);
                }
            }
            this.mdlTables.setSelectedItem(objectArray[0]);
        }
        catch (Throwable throwable) {
        }
        finally {
            try {
                resultSet.close();
            }
            catch (Throwable throwable) {}
            resultSet = null;
            this.isLoadingTables = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initSchemas() {
        ResultSet resultSet = null;
        try {
            resultSet = this.dmd.getSchemas();
            Object[] objectArray = JDBCUtilities.getSingleColumn(resultSet, "TABLE_SCHEM", null);
            this.mdlSchemas.removeAllElements();
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                String string;
                String string2 = string = objectArray[i2] == null ? "" : objectArray[i2].toString();
                if (string.trim().length() < 1) continue;
                this.mdlSchemas.addElement(string.trim());
            }
            this.configureCombobox(this.jcbSchemas);
            this.jcbSchemas.setSelectedItem(this.dmd.getUserName());
            this.jcbSchemas.setEnabled(this.mdlSchemas.getSize() >= 1);
        }
        catch (Throwable throwable) {
            this.jcbSchemas.setEnabled(false);
        }
        finally {
            try {
                resultSet.close();
            }
            catch (Throwable throwable) {}
            resultSet = null;
        }
    }

    private void configureCombobox(JComboBox jComboBox) {
        jComboBox.addActionListener(this);
        jComboBox.setMaximumRowCount(5);
        jComboBox.setEditable(false);
    }

    private static void constrain(int n2, int n3, int n4, int n5, double d2, double d3, int n6, int n7) {
        TableSelector.UI_CONSTRAINT.gridx = n2;
        TableSelector.UI_CONSTRAINT.gridy = n3;
        TableSelector.UI_CONSTRAINT.gridwidth = n4;
        TableSelector.UI_CONSTRAINT.gridheight = n5;
        TableSelector.UI_CONSTRAINT.weightx = d2;
        TableSelector.UI_CONSTRAINT.weighty = d3;
        TableSelector.UI_CONSTRAINT.anchor = n6;
        TableSelector.UI_CONSTRAINT.fill = n7;
    }
}

