/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.swing;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.InputMap;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JWindow;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.MouseInputAdapter;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.isqlviewer.core.model.SuggestionListModel;
import org.isqlviewer.swing.WindowWillShowListener;
import org.isqlviewer.util.BasicUtilities;

public class SuggestionWindow
extends JWindow {
    private static final String CONTEXT_HELP_INVOCATION = "context-help-invocation";
    private JList lstSuggestions = new JList();
    private JTextComponent txtEditor = null;
    private JScrollPane jsp = new JScrollPane(this.lstSuggestions);
    private SuggestionListModel model = null;
    private Support support = new Support(null);
    private KeyListenerProxy keyProxy = new KeyListenerProxy(this);
    private int invokeIndex = -1;
    private JLabel titleLabel = new JLabel();
    private ArrayList keyBindings = new ArrayList();
    private InvokeAction invokeAction = new InvokeAction(null);
    private WindowWillShowListener wwsl = null;

    public SuggestionWindow() {
        this((Window)null);
    }

    public SuggestionWindow(Window window) {
        super(window);
        JPanel jPanel = new JPanel(new BorderLayout());
        this.setContentPane(jPanel);
        jPanel.setBorder(BorderFactory.createLineBorder(Color.BLACK, 2));
        jPanel.add((Component)this.jsp, "Center");
        jPanel.add((Component)this.titleLabel, "North");
        this.jsp.setHorizontalScrollBarPolicy(32);
        this.jsp.setVerticalScrollBarPolicy(22);
        this.lstSuggestions.setBackground(UIManager.getColor("ToolTip.background"));
        this.lstSuggestions.setForeground(UIManager.getColor("ToolTip.foreground"));
        this.lstSuggestions.setSelectionBackground(this.lstSuggestions.getForeground());
        this.lstSuggestions.setSelectionForeground(this.lstSuggestions.getBackground());
        this.lstSuggestions.setSelectionMode(0);
        this.lstSuggestions.addKeyListener(this.support);
        this.lstSuggestions.addMouseListener(this.support);
        this.pack();
    }

    public void setModel(SuggestionListModel suggestionListModel) {
        if (this.isVisible()) {
            throw new IllegalStateException();
        }
        SuggestionListModel suggestionListModel2 = null;
        try {
            suggestionListModel2 = (SuggestionListModel)this.lstSuggestions.getModel();
        }
        catch (ClassCastException classCastException) {
            suggestionListModel2 = null;
        }
        if (suggestionListModel2 != null) {
            suggestionListModel2.removeListDataListener(this.support);
            suggestionListModel2 = null;
        }
        if (suggestionListModel == null) {
            suggestionListModel = new NullSuggestionModel(null);
        }
        this.model = suggestionListModel;
        this.model.addListDataListener(this.support);
        this.lstSuggestions.setModel(this.model);
    }

    public void setRenderer(ListCellRenderer listCellRenderer) {
        if (listCellRenderer != null) {
            this.lstSuggestions.setCellRenderer(listCellRenderer);
        } else {
            this.lstSuggestions.setCellRenderer(new DefaultListCellRenderer());
        }
    }

    public void setTextComponent(JTextComponent jTextComponent) {
        if (!this.isVisible()) {
            KeyStroke keyStroke;
            Iterator iterator;
            ActionMap actionMap;
            InputMap inputMap;
            if (this.txtEditor != null) {
                this.txtEditor.removeKeyListener(this.invokeAction);
                this.txtEditor.removeKeyListener(this.keyProxy);
                inputMap = this.txtEditor.getInputMap(0);
                actionMap = this.txtEditor.getActionMap();
                iterator = this.keyBindings.iterator();
                while (iterator.hasNext()) {
                    keyStroke = (KeyStroke)iterator.next();
                    inputMap.remove(keyStroke);
                    actionMap.remove(CONTEXT_HELP_INVOCATION);
                }
            }
            this.txtEditor = jTextComponent;
            if (this.txtEditor != null) {
                this.txtEditor.addKeyListener(this.invokeAction);
                this.txtEditor.addKeyListener(this.keyProxy);
                inputMap = this.txtEditor.getInputMap(0);
                actionMap = this.txtEditor.getActionMap();
                iterator = this.keyBindings.iterator();
                while (iterator.hasNext()) {
                    keyStroke = (KeyStroke)iterator.next();
                    inputMap.put(keyStroke, CONTEXT_HELP_INVOCATION);
                    actionMap.put(CONTEXT_HELP_INVOCATION, this.invokeAction);
                }
            }
            return;
        }
        throw new IllegalStateException();
    }

    public void setTitle(String string) {
        this.titleLabel.setText(string);
    }

    public void setWindowListener(WindowWillShowListener windowWillShowListener) {
        this.wwsl = windowWillShowListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addKeyBinding(KeyStroke keyStroke) {
        if (this.isVisible()) {
            throw new IllegalStateException();
        }
        if (!this.isInvocationBinding(keyStroke)) {
            boolean bl2 = false;
            Serializable serializable = this.keyBindings;
            synchronized (serializable) {
                bl2 = this.keyBindings.add(keyStroke);
            }
            if (bl2 && this.txtEditor != null) {
                serializable = this.txtEditor.getInputMap(0);
                ActionMap actionMap = this.txtEditor.getActionMap();
                ((InputMap)serializable).put(keyStroke, CONTEXT_HELP_INVOCATION);
                actionMap.put(CONTEXT_HELP_INVOCATION, this.invokeAction);
            }
            return bl2;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeBinding(KeyStroke keyStroke) {
        if (!this.isVisible()) {
            boolean bl2 = false;
            Serializable serializable = this.keyBindings;
            synchronized (serializable) {
                bl2 = this.keyBindings.remove(keyStroke);
            }
            if (bl2 && this.txtEditor != null) {
                serializable = this.txtEditor.getInputMap(0);
                ActionMap actionMap = this.txtEditor.getActionMap();
                ((InputMap)serializable).remove(keyStroke);
                actionMap.remove(CONTEXT_HELP_INVOCATION);
            }
            return bl2;
        }
        throw new IllegalStateException();
    }

    public boolean getFocusableWindowState() {
        return false;
    }

    public void setVisible(boolean bl2) {
        super.setVisible(bl2);
        if (bl2) {
            this.txtEditor.addKeyListener(this.keyProxy);
            this.txtEditor.addCaretListener(this.support);
            this.model.addListDataListener(this.support);
        } else {
            this.invokeIndex = -1;
            if (this.model != null) {
                this.model.removeListDataListener(this.support);
            }
            if (this.txtEditor != null) {
                this.txtEditor.removeKeyListener(this.keyProxy);
                this.txtEditor.removeCaretListener(this.support);
            }
        }
    }

    public void show(Component component, int n2, int n3) {
        if (this.model == null || component == null || this.txtEditor == null) {
            BasicUtilities.beep();
            return;
        }
        Point point = new Point(n2, n3);
        Point point2 = null;
        try {
            point2 = component.getLocationOnScreen();
        }
        catch (Throwable throwable) {
            point2 = new Point(0, 0);
        }
        int n4 = this.txtEditor.viewToModel(point);
        point.translate(0, this.txtEditor.getFont().getSize() + 3);
        try {
            this.model.updateSuggestion(this.txtEditor.getDocument(), n4);
        }
        catch (Throwable throwable) {
            BasicUtilities.HandleException(throwable);
            BasicUtilities.beep();
            return;
        }
        if (this.lstSuggestions.getModel().getSize() >= 1 && n4 >= 0) {
            this.lstSuggestions.setSelectedIndex(0);
            int n5 = Math.min(7, this.lstSuggestions.getModel().getSize());
            Dimension dimension = this.lstSuggestions.getPreferredSize();
            Dimension dimension2 = new Dimension(dimension.width + 24, this.lstSuggestions.getCellBounds((int)0, (int)n5).height);
            this.jsp.setPreferredSize(dimension2);
            point.translate(point2.x, point2.y);
            this.setLocation(point);
            if (!this.isVisible()) {
                this.invokeIndex = n4;
            }
            this.setVisible(true);
            this.txtEditor.requestFocus();
            this.txtEditor.setCaretPosition(n4);
        } else {
            BasicUtilities.beep();
        }
    }

    private boolean isInvocationBinding(KeyStroke keyStroke) {
        Iterator iterator = this.keyBindings.iterator();
        while (iterator.hasNext()) {
            boolean bl2;
            KeyStroke keyStroke2 = (KeyStroke)iterator.next();
            boolean bl3 = keyStroke.getKeyChar() == keyStroke2.getKeyChar();
            boolean bl4 = bl2 = keyStroke.getModifiers() == keyStroke2.getModifiers();
            if (!bl3 || !bl2) continue;
            return true;
        }
        return false;
    }

    public static class 1 {
    }

    private static class NullSuggestionModel
    extends SuggestionListModel {
        private NullSuggestionModel() {
        }

        public int applySuggestion(Object object, Document document, int n2, int n3) {
            return 0;
        }

        public void updateSuggestion(Document document, int n2) {
        }

        public /* synthetic */ NullSuggestionModel(1 var1_1) {
            this();
        }
    }

    private static class KeyListenerProxy
    implements KeyListener {
        private SuggestionWindow window = null;

        public KeyListenerProxy(SuggestionWindow suggestionWindow) {
            this.window = suggestionWindow;
        }

        public void keyPressed(KeyEvent keyEvent) {
            this.transferKeyEvent(keyEvent);
        }

        public void keyReleased(KeyEvent keyEvent) {
            this.transferKeyEvent(keyEvent);
        }

        public void keyTyped(KeyEvent keyEvent) {
            this.transferKeyEvent(keyEvent);
        }

        private void transferKeyEvent(KeyEvent keyEvent) {
            KeyStroke keyStroke = KeyStroke.getKeyStrokeForEvent(keyEvent);
            if (this.window.isVisible() && !this.window.isInvocationBinding(keyStroke)) {
                switch (keyStroke.getKeyCode()) {
                    case 27: {
                        this.window.setVisible(false);
                        try {
                            Document document = this.window.txtEditor.getDocument();
                            int n2 = this.window.txtEditor.getCaretPosition();
                            int n3 = this.window.invokeIndex;
                            this.window.model.applySuggestion(null, document, n3, n2);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        keyEvent.consume();
                        break;
                    }
                    case 10: 
                    case 33: 
                    case 34: 
                    case 38: 
                    case 40: {
                        this.window.lstSuggestions.dispatchEvent(keyEvent);
                        keyEvent.consume();
                        break;
                    }
                }
            }
        }
    }

    private class InvokeAction
    extends AbstractAction
    implements KeyListener {
        private KeyStroke last = null;

        private InvokeAction() {
        }

        public void keyPressed(KeyEvent keyEvent) {
            this.last = KeyStroke.getKeyStrokeForEvent(keyEvent);
        }

        public void keyReleased(KeyEvent keyEvent) {
            this.last = KeyStroke.getKeyStrokeForEvent(keyEvent);
        }

        public void keyTyped(KeyEvent keyEvent) {
            this.last = KeyStroke.getKeyStrokeForEvent(keyEvent);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            block7: {
                try {
                    JTextComponent jTextComponent = (JTextComponent)actionEvent.getSource();
                    if (jTextComponent == null) {
                        return;
                    }
                    if (jTextComponent.hasFocus()) {
                        if (SuggestionWindow.this.wwsl != null) {
                            try {
                                KeyEvent keyEvent = new KeyEvent(jTextComponent, actionEvent.getID(), actionEvent.getWhen(), this.last.getModifiers(), this.last.getKeyCode(), this.last.getKeyChar());
                                SuggestionWindow.this.wwsl.windowWillShow(SuggestionWindow.this, keyEvent);
                            }
                            catch (Throwable throwable) {
                                BasicUtilities.beep();
                                return;
                            }
                        }
                        int n2 = jTextComponent.getCaretPosition();
                        Point point = jTextComponent.modelToView(n2).getLocation();
                        SuggestionWindow.this.show(jTextComponent, point.x, point.y);
                        break block7;
                    }
                    BasicUtilities.beep();
                }
                catch (Throwable throwable) {
                    BasicUtilities.HandleException(throwable, "InvokeAction::actionPerformed()");
                }
            }
        }

        public /* synthetic */ InvokeAction(1 var2_2) {
            this();
        }
    }

    private class Support
    extends MouseInputAdapter
    implements ListDataListener,
    KeyListener,
    CaretListener {
        private boolean isSelecting = false;

        private Support() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void select() {
            this.isSelecting = true;
            try {
                Document document = SuggestionWindow.this.txtEditor.getDocument();
                Object e2 = SuggestionWindow.this.lstSuggestions.getSelectedValue();
                int n2 = SuggestionWindow.this.model.applySuggestion(e2, document, SuggestionWindow.this.invokeIndex, SuggestionWindow.this.txtEditor.getCaretPosition());
                if (n2 < 0) {
                } else if (n2 > document.getLength()) {
                    SuggestionWindow.this.txtEditor.setCaretPosition(document.getLength());
                } else {
                    SuggestionWindow.this.txtEditor.setCaretPosition(n2);
                }
            }
            catch (Throwable throwable) {
                BasicUtilities.beep();
                BasicUtilities.HandleException(throwable);
            }
            finally {
                this.isSelecting = false;
                SuggestionWindow.this.setVisible(false);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void caretUpdate(CaretEvent caretEvent) {
            if (SuggestionWindow.this.isVisible() && !this.isSelecting) {
                try {
                    SuggestionWindow.this.model.updateSuggestion(SuggestionWindow.this.txtEditor.getDocument(), caretEvent.getDot());
                }
                catch (Throwable throwable) {
                }
                finally {
                    this.contentsChanged(null);
                }
            }
        }

        public void keyPressed(KeyEvent keyEvent) {
            this.checkKeyEvent(keyEvent);
        }

        public void keyReleased(KeyEvent keyEvent) {
            this.checkKeyEvent(keyEvent);
        }

        public void keyTyped(KeyEvent keyEvent) {
            this.checkKeyEvent(keyEvent);
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            int n2 = mouseEvent.getClickCount();
            if (n2 == 2) {
                this.select();
            }
        }

        public void contentsChanged(ListDataEvent listDataEvent) {
            if (SuggestionWindow.this.model.getSize() >= 1 && SuggestionWindow.this.isVisible()) {
                SuggestionWindow.this.lstSuggestions.setSelectedIndex(0);
            }
        }

        public void intervalAdded(ListDataEvent listDataEvent) {
            this.contentsChanged(listDataEvent);
        }

        public void intervalRemoved(ListDataEvent listDataEvent) {
            this.contentsChanged(listDataEvent);
        }

        private void checkKeyEvent(KeyEvent keyEvent) {
            if (SuggestionWindow.this.isVisible()) {
                KeyStroke keyStroke = KeyStroke.getKeyStrokeForEvent(keyEvent);
                switch (keyStroke.getKeyCode()) {
                    case 10: {
                        this.select();
                        break;
                    }
                }
            }
        }

        public /* synthetic */ Support(1 var2_2) {
            this();
        }
    }
}

