/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.swing;

import java.awt.Component;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.FileOutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import org.isqlviewer.core.SystemConfig;
import org.isqlviewer.util.Base64Decoder;
import org.isqlviewer.util.Base64Encoder;
import org.isqlviewer.util.BasicUtilities;
import org.isqlviewer.util.StringUtilities;

public class JTextPopup
extends JPopupMenu
implements MouseListener,
ActionListener {
    private JMenuItem pu_cut = new JMenuItem(BasicUtilities.getString("Cut"));
    private JMenuItem pu_copy = new JMenuItem(BasicUtilities.getString("Copy"));
    private JMenuItem pu_paste = new JMenuItem(BasicUtilities.getString("Paste"));
    private JMenuItem pu_clear = new JMenuItem(BasicUtilities.getString("Clear_All"));
    private JMenuItem pu_save = new JMenuItem(BasicUtilities.getString("Save_To_File"));
    private JMenuItem pu_selectAll = new JMenuItem(BasicUtilities.getString("Select_All"));
    private JMenuItem mnuDecodeUnicode = new JMenuItem(BasicUtilities.getString("Decode_UNICODE_Seq"));
    private JMenuItem mnuEncodeUnicode = new JMenuItem(BasicUtilities.getString("Encode_UNICODE_Seq"));
    private JMenuItem mnuBase64Encode = new JMenuItem(BasicUtilities.getString("Encode_Base64"));
    private JMenuItem mnuBase64Decode = new JMenuItem(BasicUtilities.getString("Decode_Base64"));
    private JMenuItem mnuLong2Date = new JMenuItem(BasicUtilities.getString("Convert_Milliseconds_To_Date"));
    private JMenuItem mnuDate2Long = new JMenuItem(BasicUtilities.getString("Convert_Date_To_Milliseconds"));
    private JTextComponent console;
    private SimpleDateFormat sdf = new SimpleDateFormat("");

    public JTextPopup() {
        this.add(this.pu_cut);
        this.add(this.pu_copy);
        this.add(this.pu_paste);
        this.add(this.pu_save);
        this.addSeparator();
        JMenu jMenu = new JMenu(BasicUtilities.getString("Text_Tools"));
        jMenu.add(this.mnuBase64Decode);
        jMenu.add(this.mnuBase64Encode);
        jMenu.add(this.mnuDecodeUnicode);
        jMenu.add(this.mnuEncodeUnicode);
        jMenu.add(this.mnuDate2Long);
        jMenu.add(this.mnuLong2Date);
        this.add(jMenu);
        this.add(this.pu_clear);
        this.add(this.pu_selectAll);
        if (!BasicUtilities.isMac()) {
            this.pu_selectAll.setIcon(BasicUtilities.loadIconResource("Spacer16"));
            this.pu_cut.setIcon(BasicUtilities.loadIconResource("Cut16"));
            this.pu_copy.setIcon(BasicUtilities.loadIconResource("Copy16"));
            this.pu_paste.setIcon(BasicUtilities.loadIconResource("Paste16"));
            this.pu_clear.setIcon(BasicUtilities.loadIconResource("Spacer16"));
            this.pu_save.setIcon(BasicUtilities.loadIconResource("Save16"));
            jMenu.setIcon(BasicUtilities.loadIconResource("Spacer16"));
        }
        this.pu_paste.setAccelerator(BasicUtilities.createKeyStroke(86, BasicUtilities.CMD_MASK));
        this.pu_copy.setAccelerator(BasicUtilities.createKeyStroke(67, BasicUtilities.CMD_MASK));
        this.pu_selectAll.setAccelerator(BasicUtilities.createKeyStroke(65, BasicUtilities.CMD_MASK));
        this.pu_cut.setAccelerator(BasicUtilities.createKeyStroke(88, BasicUtilities.CMD_MASK));
        this.pu_selectAll.addActionListener(this);
        this.pu_cut.addActionListener(this);
        this.pu_copy.addActionListener(this);
        this.pu_paste.addActionListener(this);
        this.pu_clear.addActionListener(this);
        this.pu_save.addActionListener(this);
        this.mnuBase64Decode.addActionListener(this);
        this.mnuBase64Encode.addActionListener(this);
        this.mnuDecodeUnicode.addActionListener(this);
        this.mnuEncodeUnicode.addActionListener(this);
        this.mnuDate2Long.addActionListener(this);
        this.mnuLong2Date.addActionListener(this);
    }

    public final JMenu toJMenu() {
        JMenu jMenu = new JMenu(BasicUtilities.getString("Edit"));
        jMenu.add(this.pu_cut);
        jMenu.add(this.pu_copy);
        jMenu.add(this.pu_paste);
        jMenu.add(this.pu_save);
        jMenu.addSeparator();
        JMenu jMenu2 = new JMenu(BasicUtilities.getString("Text_Tools"));
        jMenu2.add(this.mnuBase64Decode);
        jMenu2.add(this.mnuBase64Encode);
        jMenu2.add(this.mnuDecodeUnicode);
        jMenu2.add(this.mnuEncodeUnicode);
        this.add(jMenu2);
        jMenu.add(this.pu_clear);
        jMenu.add(this.pu_selectAll);
        return jMenu;
    }

    public final void removeJTextComponent(JTextComponent jTextComponent) {
        this.console = null;
        jTextComponent.removeMouseListener(this);
    }

    public final void addJTextComponent(JTextComponent jTextComponent) {
        this.addJTextComponent(jTextComponent, true);
    }

    public final void addJTextComponent(JTextComponent jTextComponent, boolean bl2) {
        this.console = jTextComponent;
        if (bl2) {
            jTextComponent.addMouseListener(this);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
        if (this.console == null) {
            return;
        }
        boolean bl2 = true;
        boolean bl3 = (actionEvent.getModifiers() & 1) != 1;
        String string = this.console.getSelectedText();
        if (string == null) {
            string = this.console.getText();
            bl2 = false;
        }
        if (jMenuItem == this.pu_copy) {
            this.console.copy();
        } else if (jMenuItem == this.pu_paste) {
            this.console.paste();
        } else if (jMenuItem == this.pu_selectAll) {
            this.console.selectAll();
        } else if (jMenuItem == this.pu_cut) {
            this.console.copy();
            if (this.console.isEditable()) {
                this.console.cut();
            }
        } else if (jMenuItem == this.mnuBase64Encode) {
            try {
                string = new Base64Encoder(string, bl3).processString();
            }
            catch (Throwable throwable) {
                BasicUtilities.beep();
                return;
            }
            if (this.console.isEditable()) {
                if (bl2) {
                    this.console.replaceSelection(string);
                } else {
                    this.console.setText(string);
                }
            } else {
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                StringSelection stringSelection = new StringSelection(string);
                clipboard.setContents(stringSelection, stringSelection);
                System.out.println(BasicUtilities.getString("Encoding_To_Clipboard"));
            }
        } else if (jMenuItem == this.mnuBase64Decode) {
            try {
                string = new Base64Decoder(string, bl3).processString();
            }
            catch (Throwable throwable) {
                BasicUtilities.beep();
                return;
            }
            if (this.console.isEditable()) {
                if (bl2) {
                    this.console.replaceSelection(string);
                } else {
                    this.console.setText(string);
                }
            } else {
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                StringSelection stringSelection = new StringSelection(string);
                clipboard.setContents(stringSelection, stringSelection);
                System.out.println(BasicUtilities.getString("Decoding_To_Clipboard"));
            }
        } else if (jMenuItem == this.mnuEncodeUnicode) {
            string = StringUtilities.decode(string);
            if (this.console.isEditable()) {
                if (bl2) {
                    this.console.replaceSelection(string);
                } else {
                    this.console.setText(string);
                }
            } else {
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                StringSelection stringSelection = new StringSelection(string);
                clipboard.setContents(stringSelection, stringSelection);
                System.out.println(BasicUtilities.getString("Encoding_To_Clipboard"));
            }
        } else if (jMenuItem == this.mnuDecodeUnicode) {
            string = StringUtilities.encode(string, false, false);
            if (this.console.isEditable()) {
                if (bl2) {
                    this.console.replaceSelection(string);
                } else {
                    this.console.setText(string);
                }
            } else {
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                StringSelection stringSelection = new StringSelection(string);
                clipboard.setContents(stringSelection, stringSelection);
                System.out.println(BasicUtilities.getString("Decoding_To_Clipboard"));
            }
        } else if (jMenuItem == this.mnuLong2Date) {
            this.sdf.applyPattern(SystemConfig.getInstance().getFormatForSQLType(93));
            try {
                string = this.sdf.format(new Date(Long.parseLong(string)));
            }
            catch (Throwable throwable) {
                BasicUtilities.beep();
                return;
            }
            if (this.console.isEditable()) {
                if (bl2) {
                    this.console.replaceSelection(string);
                } else {
                    this.console.setText(string);
                }
            } else {
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                StringSelection stringSelection = new StringSelection(string);
                clipboard.setContents(stringSelection, stringSelection);
                System.out.println(BasicUtilities.getString("Decoding_To_Clipboard"));
            }
        } else if (jMenuItem == this.mnuDate2Long) {
            this.sdf.applyPattern(SystemConfig.getInstance().getFormatForSQLType(93));
            try {
                string = Long.toString(this.sdf.parse(string).getTime());
            }
            catch (Throwable throwable) {
                BasicUtilities.beep();
                return;
            }
            if (this.console.isEditable()) {
                if (bl2) {
                    this.console.replaceSelection(string);
                } else {
                    this.console.setText(string);
                }
            } else {
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                StringSelection stringSelection = new StringSelection(string);
                clipboard.setContents(stringSelection, stringSelection);
                System.out.println(BasicUtilities.getString("Decoding_To_Clipboard"));
            }
        } else if (jMenuItem == this.pu_clear) {
            if (this.console.isEnabled()) {
                this.console.setText("");
                this.console.setCaretPosition(0);
            }
        } else if (jMenuItem == this.pu_save) {
            this.Save();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void Save() {
        try {
            File file = BasicUtilities.saveSystemFile(this);
            if (file == null) {
                return;
            }
            if (!file.exists()) {
                file.createNewFile();
            }
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            fileOutputStream.write(this.console.getText().getBytes());
            fileOutputStream.close();
            fileOutputStream = null;
            file = null;
        }
        catch (Exception exception) {
        }
        finally {
            System.gc();
            System.runFinalization();
        }
    }

    public void show(Component component, int n2, int n3) {
        if (component instanceof JTextComponent && component.isEnabled()) {
            this.console = (JTextComponent)component;
            this.pu_paste.setEnabled(this.console.isEditable());
            SwingUtilities.updateComponentTreeUI(this);
            super.show(component, n2, n3);
        } else {
            BasicUtilities.beep();
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.doPopup(mouseEvent);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        this.doPopup(mouseEvent);
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.doPopup(mouseEvent);
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public boolean doPopup(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            mouseEvent.consume();
            return true;
        }
        return false;
    }
}

