/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.swing;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.IllegalComponentStateException;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JTabbedPane;
import javax.swing.event.MouseInputAdapter;
import org.isqlviewer.swing.CompoundIcon;
import org.isqlviewer.util.BasicUtilities;

public class ITabbedPane
extends JTabbedPane {
    public static final int ACTION_TAB_CLICKED = 64768;
    public static final int ACTION_TAB_DBL_CLICKED = 64769;
    private static final String CLIENT_IS_LOCKED = "ITabbedPane.isLocked";
    public int maxtabcount = -1;
    public int oldestIndex = -1;
    private Hashtable iconCache;
    public static final Icon LOCK_ICON = BasicUtilities.loadIconResource("Lock16");
    public static final Icon CLOSE_ICON = BasicUtilities.loadIconResource("Close16");
    private transient Vector actionListeners;

    public ITabbedPane() {
        this(1, 5);
    }

    public ITabbedPane(int n2) {
        this(n2, 5);
    }

    public ITabbedPane(int n2, int n3) {
        super(n2);
        this.maxtabcount = n3;
        this.iconCache = new Hashtable(this.maxtabcount);
        MouseHandler mouseHandler = new MouseHandler(null);
        this.addMouseListener(mouseHandler);
        this.addMouseMotionListener(mouseHandler);
    }

    public void addTab(String string, Component component) {
        this.addTab(string, null, component, null);
    }

    public void addTab(String string, Icon icon, Component component) {
        this.addTab(string, new CompoundIcon(CLOSE_ICON, icon), component, null);
    }

    public void addTab(String string, Icon icon, Component component, String string2) {
        if (this.getTabCount() < this.maxtabcount) {
            if (component instanceof JComponent) {
                JComponent jComponent = (JComponent)component;
                jComponent.putClientProperty(CLIENT_IS_LOCKED, Boolean.FALSE);
            }
            super.addTab("Running Query...", new CompoundIcon(null, icon), component, string2);
            this.invalidate();
            this.repaint();
            this.fireStateChanged();
        } else {
            int n2 = this.locateFirstUnlockedTab();
            if (n2 >= 0 && n2 < this.getTabCount()) {
                this.setTitleAt(n2, "Running Query...");
                this.setIconAt(n2, new CompoundIcon(null, icon));
                this.setComponentAt(n2, component);
                this.setToolTipTextAt(n2, string2);
                this.invalidate();
                this.repaint();
                this.fireStateChanged();
            } else {
                throw new IllegalStateException();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIconAt(int n2, Icon icon) {
        try {
            CompoundIcon compoundIcon = (CompoundIcon)this.getIconAt(n2);
            compoundIcon.setRightIcon(icon);
        }
        catch (Throwable throwable) {
        }
        finally {
            this.invalidate();
            this.repaint();
        }
    }

    public void removeTabAt(int n2) {
        String string;
        String string2;
        int n3;
        if (this.isTabLocked(n2) && (n3 = JOptionPane.showConfirmDialog(this, string2 = BasicUtilities.getString("LockedTab_Close_Warning"), string = BasicUtilities.getString("Warning"), 0)) == 1) {
            return;
        }
        this.iconCache.remove(this.getComponentAt(n2));
        super.removeTabAt(n2);
        this.invalidate();
        this.repaint();
        this.fireStateChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllTabs() {
        ITabbedPane iTabbedPane = this;
        synchronized (iTabbedPane) {
            for (int i2 = this.getTabCount() - 1; i2 >= 0; --i2) {
                this.removeTabAt(i2);
            }
        }
    }

    public boolean isEmpty() {
        return this.getTabCount() == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeUnlockedTabs() {
        ITabbedPane iTabbedPane = this;
        synchronized (iTabbedPane) {
            for (int i2 = this.getTabCount() - 1; i2 >= 0; --i2) {
                if (this.isTabLocked(i2)) continue;
                this.removeTabAt(i2);
            }
        }
    }

    public String getSelectedToolTip() {
        int n2 = this.getSelectedIndex();
        if (n2 >= 0) {
            return this.getToolTipTextAt(n2);
        }
        return null;
    }

    public void setMaxTabCount(int n2) {
        if (n2 < 1) {
            throw new IllegalArgumentException(Integer.toString(n2));
        }
        if (n2 >= this.maxtabcount) {
            this.maxtabcount = n2;
        } else {
            while (this.maxtabcount > n2 && this.getTabCount() > n2) {
                this.removeTabAt(0);
            }
            this.maxtabcount = n2;
        }
    }

    public void removeSelectedTab() {
        int n2 = this.getSelectedIndex();
        if (n2 >= 0) {
            this.removeTabAt(n2);
        }
    }

    public void lockSelectedTab() {
        int n2 = this.getSelectedIndex();
        if (n2 >= 0) {
            this.lockTab(n2);
        }
    }

    public void unlockSelectedTab() {
        int n2 = this.getSelectedIndex();
        if (n2 >= 0) {
            this.unlockTab(n2);
        }
    }

    public int getIndexOfTitle(String string) {
        if (string != null) {
            for (int i2 = 0; i2 < this.getTabCount(); ++i2) {
                if (!string.equals(this.getTitleAt(i2))) continue;
                return i2;
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setClosableTab(int n2, boolean bl2) {
        if (n2 < 0 || n2 >= this.getTabCount()) {
            return;
        }
        try {
            CompoundIcon compoundIcon = (CompoundIcon)this.getIconAt(n2);
            compoundIcon.setLeftIcon(bl2 ? CLOSE_ICON : null);
        }
        catch (Throwable throwable) {
        }
        finally {
            this.invalidate();
            this.repaint();
        }
    }

    public boolean isTabLocked(int n2) {
        if (n2 >= 0) {
            Component component = this.getComponent(n2);
            if (component instanceof JComponent) {
                JComponent jComponent = (JComponent)component;
                Boolean bl2 = (Boolean)jComponent.getClientProperty(CLIENT_IS_LOCKED);
                return bl2 == null ? false : bl2;
            }
            return false;
        }
        throw new IllegalArgumentException(Integer.toString(n2));
    }

    public void unlockTab(int n2) {
        Component component;
        if (n2 >= 0 && this.isTabLocked(n2) && (component = this.getComponent(n2)) instanceof JComponent) {
            JComponent jComponent = (JComponent)component;
            jComponent.putClientProperty(CLIENT_IS_LOCKED, Boolean.FALSE);
            Icon icon = (Icon)this.iconCache.get(component);
            this.setIconAt(n2, icon);
            this.validateTree();
            this.repaint();
        }
    }

    public void lockTab(int n2) {
        if (n2 >= 0 && !this.isTabLocked(n2)) {
            Component component = this.getComponent(n2);
            if (component instanceof JComponent) {
                Icon icon;
                JComponent jComponent = (JComponent)component;
                jComponent.putClientProperty(CLIENT_IS_LOCKED, Boolean.TRUE);
                CompoundIcon compoundIcon = (CompoundIcon)this.getIconAt(n2);
                if (compoundIcon != null && (icon = compoundIcon.getRightIcon()) != null) {
                    this.iconCache.put(jComponent, icon);
                }
                compoundIcon.setRightIcon(LOCK_ICON);
                this.validateTree();
                this.repaint();
            } else {
                String string = BasicUtilities.getString("Resultcontainer_Component_Error");
                throw new IllegalComponentStateException(string);
            }
        }
    }

    public void removeActionListener(ActionListener actionListener) {
        if (this.actionListeners != null && this.actionListeners.contains(actionListener)) {
            Vector vector = (Vector)this.actionListeners.clone();
            vector.removeElement(actionListener);
            this.actionListeners = vector;
        }
    }

    public void addActionListener(ActionListener actionListener) {
        Vector vector;
        Vector vector2 = vector = this.actionListeners == null ? new Vector(2) : (Vector)this.actionListeners.clone();
        if (!vector.contains(actionListener)) {
            vector.addElement(actionListener);
            this.actionListeners = vector;
        }
    }

    public int locateFirstUnlockedTab() {
        if (this.oldestIndex >= this.getTabCount() || this.oldestIndex < 0) {
            this.oldestIndex = 0;
        }
        for (int i2 = this.oldestIndex; i2 < this.getTabCount(); ++i2) {
            if (this.isTabLocked(i2)) continue;
            this.oldestIndex = i2 + 1;
            return i2;
        }
        this.oldestIndex = -1;
        return -1;
    }

    public void fireActionPerformed(ActionEvent actionEvent) {
        if (this.actionListeners != null) {
            Vector vector = this.actionListeners;
            int n2 = vector.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                try {
                    ((ActionListener)vector.elementAt(i2)).actionPerformed(actionEvent);
                    continue;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }

    public static class 1 {
    }

    private class MouseHandler
    extends MouseInputAdapter {
        private MouseHandler() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (ITabbedPane.this.getSelectedIndex() < 0) {
                return;
            }
            if (mouseEvent.getClickCount() == 2 && ITabbedPane.this.getSelectedIndex() >= 0) {
                ITabbedPane.this.fireActionPerformed(new ActionEvent(ITabbedPane.this, 64769, ITabbedPane.this.getSelectedToolTip(), mouseEvent.getModifiers()));
            } else if (mouseEvent.getClickCount() == 1) {
                int n2 = ITabbedPane.this.getSelectedIndex();
                Rectangle rectangle = ITabbedPane.this.getUI().getTabBounds(ITabbedPane.this, n2);
                if (!rectangle.contains(mouseEvent.getPoint())) {
                    return;
                }
                CompoundIcon compoundIcon = (CompoundIcon)ITabbedPane.this.getIconAt(n2);
                if (compoundIcon != null) {
                    if (compoundIcon.isOverIcon(mouseEvent.getX(), mouseEvent.getY())) {
                        ITabbedPane.this.removeSelectedTab();
                        ITabbedPane.this.setCursor(Cursor.getPredefinedCursor(0));
                        return;
                    }
                    ActionEvent actionEvent = new ActionEvent(ITabbedPane.this, 64768, "", mouseEvent.getModifiers());
                    ITabbedPane.this.fireActionPerformed(actionEvent);
                } else {
                    ActionEvent actionEvent = new ActionEvent(ITabbedPane.this, 64768, "", mouseEvent.getModifiers());
                    ITabbedPane.this.fireActionPerformed(actionEvent);
                }
            }
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            try {
                if (ITabbedPane.this.getTabCount() >= 1) {
                    int n2 = ITabbedPane.this.getSelectedIndex();
                    Rectangle rectangle = ITabbedPane.this.getUI().getTabBounds(ITabbedPane.this, n2);
                    if (!rectangle.contains(mouseEvent.getPoint())) {
                        if (ITabbedPane.this.getCursor().getType() != 0) {
                            ITabbedPane.this.setCursor(Cursor.getPredefinedCursor(0));
                        }
                        return;
                    }
                    CompoundIcon compoundIcon = (CompoundIcon)ITabbedPane.this.getIconAt(n2);
                    ITabbedPane.this.repaint(rectangle);
                    if (compoundIcon != null && compoundIcon.isOverIcon(mouseEvent.getX(), mouseEvent.getY())) {
                        ITabbedPane.this.setCursor(Cursor.getPredefinedCursor(12));
                        return;
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (ITabbedPane.this.getCursor().getType() != 0) {
                ITabbedPane.this.setCursor(Cursor.getPredefinedCursor(0));
            }
        }

        public /* synthetic */ MouseHandler(1 var2_2) {
            this();
        }
    }
}

