/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.sql;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.sql.DataSource;
import org.isqlviewer.sql.DatabaseConnection;
import org.isqlviewer.util.BasicUtilities;

public class J2EEAdapterDriver
implements Driver {
    private static final int SQL_STATE_LOOKUP = 1;
    private static final int SQL_STATE_INIT = 0;
    private static final int VENDOR_CODE = 74615;
    private static final String URL_PREFIX = "jdbc:j2ee:";
    private Context j2eeContext = null;
    private DataSource dataSource = null;
    private String url = null;

    public Connection connect(String string, Properties properties) throws SQLException {
        String string2;
        try {
            this.j2eeContext = new InitialContext(properties);
        }
        catch (Throwable throwable) {
            throw new SQLException(throwable.getMessage(), Integer.toHexString(0), 74615);
        }
        try {
            string2 = string.substring(URL_PREFIX.length());
            this.dataSource = (DataSource)this.j2eeContext.lookup(string2);
        }
        catch (Throwable throwable) {
            throw new SQLException(throwable.getMessage(), Integer.toHexString(1), 74615);
        }
        this.url = string;
        if (DriverManager.getLogWriter() != null) {
            try {
                this.dataSource.setLogWriter(DriverManager.getLogWriter());
            }
            catch (SQLException sQLException) {
                BasicUtilities.HandleException(sQLException);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        string2 = properties.getProperty("user", "").trim();
        String string3 = properties.getProperty("password", "").trim();
        if (string2.length() == 0 && string3.length() == 0) {
            return this.dataSource.getConnection();
        }
        return this.dataSource.getConnection(string2, string3);
    }

    public boolean acceptsURL(String string) {
        if (string == null || !string.startsWith(URL_PREFIX)) {
            return false;
        }
        String string2 = string.substring(URL_PREFIX.length());
        return string2.trim().length() >= 1;
    }

    public DriverPropertyInfo[] getPropertyInfo(String string, Properties properties) {
        ArrayList<DriverPropertyInfo> arrayList = new ArrayList<DriverPropertyInfo>();
        DriverPropertyInfo driverPropertyInfo = null;
        String string2 = null;
        string2 = properties.getProperty("user", "");
        driverPropertyInfo = new DriverPropertyInfo("user", string2);
        driverPropertyInfo.description = "";
        driverPropertyInfo.required = true;
        driverPropertyInfo.choices = null;
        arrayList.add(driverPropertyInfo);
        string2 = properties.getProperty("password", "");
        driverPropertyInfo = new DriverPropertyInfo("password", string2);
        driverPropertyInfo.description = "";
        driverPropertyInfo.required = true;
        driverPropertyInfo.choices = null;
        arrayList.add(driverPropertyInfo);
        string2 = properties.getProperty("java.naming.provider.url", System.getProperty("java.naming.provider.url", ""));
        driverPropertyInfo = new DriverPropertyInfo("java.naming.provider.url", string2);
        driverPropertyInfo.description = BasicUtilities.getString(DatabaseConnection.resourceBundle, "Provider_URL_Desc");
        driverPropertyInfo.required = false;
        driverPropertyInfo.choices = null;
        arrayList.add(driverPropertyInfo);
        string2 = properties.getProperty("java.naming.factory.initial", System.getProperty("java.naming.factory.initial", ""));
        driverPropertyInfo = new DriverPropertyInfo("java.naming.factory.initial", string2);
        driverPropertyInfo.description = BasicUtilities.getString(DatabaseConnection.resourceBundle, "Init_Cntxt_Desc");
        driverPropertyInfo.required = false;
        driverPropertyInfo.choices = null;
        arrayList.add(driverPropertyInfo);
        string2 = properties.getProperty("java.naming.authoritative", System.getProperty("java.naming.authoritative", ""));
        driverPropertyInfo = new DriverPropertyInfo("java.naming.authoritative", string2);
        driverPropertyInfo.description = BasicUtilities.getString(DatabaseConnection.resourceBundle, "Context_Auth_Desc");
        driverPropertyInfo.required = false;
        driverPropertyInfo.choices = new String[]{"", Boolean.toString(true), Boolean.toString(false)};
        arrayList.add(driverPropertyInfo);
        string2 = properties.getProperty("java.naming.batchsize", System.getProperty("java.naming.batchsize", ""));
        driverPropertyInfo = new DriverPropertyInfo("java.naming.batchsize", string2);
        driverPropertyInfo.description = BasicUtilities.getString(DatabaseConnection.resourceBundle, "Context_BatchSize_Desc");
        driverPropertyInfo.required = false;
        driverPropertyInfo.choices = null;
        arrayList.add(driverPropertyInfo);
        string2 = properties.getProperty("java.naming.dns.url", System.getProperty("java.naming.dns.url", ""));
        driverPropertyInfo = new DriverPropertyInfo("java.naming.dns.url", string2);
        driverPropertyInfo.description = BasicUtilities.getString(DatabaseConnection.resourceBundle, "Context_DNSURL_Desc");
        driverPropertyInfo.required = false;
        driverPropertyInfo.choices = null;
        arrayList.add(driverPropertyInfo);
        string2 = properties.getProperty("java.naming.factory.object", System.getProperty("java.naming.factory.object", ""));
        driverPropertyInfo = new DriverPropertyInfo("java.naming.factory.object", string2);
        driverPropertyInfo.description = BasicUtilities.getString(DatabaseConnection.resourceBundle, "Context_ObjFactory_Desc");
        driverPropertyInfo.required = false;
        driverPropertyInfo.choices = null;
        arrayList.add(driverPropertyInfo);
        string2 = properties.getProperty("java.naming.referral", System.getProperty("java.naming.referral", ""));
        driverPropertyInfo = new DriverPropertyInfo("java.naming.referral", string2);
        driverPropertyInfo.description = BasicUtilities.getString(DatabaseConnection.resourceBundle, "Context_Referral_Desc");
        driverPropertyInfo.required = false;
        driverPropertyInfo.choices = new String[]{"follow", "ignore", "throw", ""};
        arrayList.add(driverPropertyInfo);
        string2 = properties.getProperty("java.naming.security.authentication", System.getProperty("java.naming.security.authentication", ""));
        driverPropertyInfo = new DriverPropertyInfo("java.naming.security.authentication", string2);
        driverPropertyInfo.description = BasicUtilities.getString(DatabaseConnection.resourceBundle, "Context_SecAuth_Desc");
        driverPropertyInfo.required = false;
        driverPropertyInfo.choices = new String[]{"none", "simple", "strong", ""};
        arrayList.add(driverPropertyInfo);
        string2 = properties.getProperty("java.naming.security.credentials", System.getProperty("java.naming.security.credentials", ""));
        driverPropertyInfo = new DriverPropertyInfo("java.naming.security.credentials", string2);
        driverPropertyInfo.description = BasicUtilities.getString(DatabaseConnection.resourceBundle, "Context_SecCred_Desc");
        driverPropertyInfo.required = false;
        driverPropertyInfo.choices = null;
        arrayList.add(driverPropertyInfo);
        string2 = properties.getProperty("java.naming.security.principal", System.getProperty("java.naming.security.principal", ""));
        driverPropertyInfo = new DriverPropertyInfo("java.naming.security.principal", string2);
        driverPropertyInfo.description = BasicUtilities.getString(DatabaseConnection.resourceBundle, "Context_SecPrin_Desc");
        driverPropertyInfo.required = false;
        driverPropertyInfo.choices = null;
        arrayList.add(driverPropertyInfo);
        string2 = properties.getProperty("java.naming.security.protocol", System.getProperty("java.naming.security.protocol", ""));
        driverPropertyInfo = new DriverPropertyInfo("java.naming.security.protocol", string2);
        driverPropertyInfo.description = BasicUtilities.getString(DatabaseConnection.resourceBundle, "Context_SecProto_Desc");
        driverPropertyInfo.required = false;
        driverPropertyInfo.choices = null;
        arrayList.add(driverPropertyInfo);
        string2 = properties.getProperty("java.naming.factory.state", System.getProperty("java.naming.factory.state", ""));
        driverPropertyInfo = new DriverPropertyInfo("java.naming.factory.state", string2);
        driverPropertyInfo.description = BasicUtilities.getString(DatabaseConnection.resourceBundle, "Context_StateFactory_Desc");
        driverPropertyInfo.required = false;
        driverPropertyInfo.choices = null;
        arrayList.add(driverPropertyInfo);
        string2 = properties.getProperty("java.naming.factory.url.pkgs", System.getProperty("java.naming.factory.url.pkgs", ""));
        driverPropertyInfo = new DriverPropertyInfo("java.naming.factory.url.pkgs", string2);
        driverPropertyInfo.description = BasicUtilities.getString(DatabaseConnection.resourceBundle, "Context_URLPrefix_Desc");
        driverPropertyInfo.required = false;
        driverPropertyInfo.choices = null;
        arrayList.add(driverPropertyInfo);
        return arrayList.toArray(new DriverPropertyInfo[0]);
    }

    public int getMajorVersion() {
        return 1;
    }

    public int getMinorVersion() {
        return 1;
    }

    public boolean jdbcCompliant() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finalize() throws Throwable {
        super.finalize();
        try {
            PrintWriter printWriter = DriverManager.getLogWriter();
            if (printWriter != null) {
                printWriter.println(BasicUtilities.getString(DatabaseConnection.resourceBundle, "J2EEContext_Close", this.url));
            }
            this.j2eeContext.close();
        }
        catch (Throwable throwable) {
        }
        finally {
            this.j2eeContext = null;
        }
    }
}

