/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.sql;

import com.j_spaces.core.IJSpace;
import com.j_spaces.jdbc.driver.GConnection;
import com.j_spaces.kernel.JSpaceUtilities;
import com.j_spaces.tools.spacebrowser.SpaceBrowser;
import java.lang.reflect.Method;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.swing.JOptionPane;
import org.isqlviewer.event.DatabaseEvent;
import org.isqlviewer.event.DatabaseListener;
import org.isqlviewer.event.ProgressEvent;
import org.isqlviewer.event.ProgressListener;
import org.isqlviewer.sql.DriverPool;
import org.isqlviewer.sql.JDBCUtilities;
import org.isqlviewer.sql.ResultSetViewer;
import org.isqlviewer.util.BasicUtilities;
import org.isqlviewer.util.StringTokenizer;
import org.isqlviewer.util.StringUtilities;

public final class DatabaseConnection {
    private Driver gsJDBCDriver = null;
    private String gsJDBCurl = null;
    private Connection gsConnection = null;
    private IJSpace gsSpaceProxy = null;
    private boolean useSingleSpace = true;
    private static final Hashtable QUERY_THREADS = new Hashtable(0, 0.95f);
    public static ResourceBundle resourceBundle = null;
    private ArrayList listenerList = null;
    private String[] tableTypes = null;
    private String preferredSchema = null;
    private GConnection databaseCnx = null;
    private DatabaseMetaData cnxMetaData = null;
    private SQLException lastError;
    private boolean supportsTransactions = false;
    private boolean supportsBatch = false;
    private boolean supportMultiResults = false;
    private boolean supportsSavePoints = false;
    private Properties props = new Properties();
    private Properties configuration = new Properties();
    private HashMap metaCache;
    private String cnxAlias;
    private String jdbcURL;
    private Driver jdbcDriver;
    private HashMap stmtMap = new HashMap();
    private int maxStatements = 1;

    public DatabaseConnection(String string, Properties properties) throws SQLException {
        this.jdbcURL = string;
        this.props.putAll((Map<?, ?>)properties);
        this.jdbcDriver = DriverPool.getDriver(string);
        this.logDriverInformation();
    }

    public DatabaseConnection() {
    }

    public DatabaseConnection(Driver driver, Properties properties, IJSpace iJSpace) {
        this.gsSpaceProxy = iJSpace;
        this.props.putAll((Map<?, ?>)properties);
        try {
            this.gsJDBCDriver = driver;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.logDriverInformation();
    }

    public DatabaseConnection(String string, String string2) {
        this.gsJDBCurl = string2;
        try {
            this.gsJDBCDriver = (Driver)Class.forName(string, false, null).newInstance();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.logDriverInformation();
    }

    public DatabaseConnection(Driver driver, String string) {
        this.gsJDBCurl = string;
        this.gsJDBCDriver = driver;
        this.logDriverInformation();
    }

    public DatabaseConnection(String string, String string2, String string3) throws SQLException {
        this.jdbcURL = string;
        this.updateAutheticationTokens(string2, string3);
        this.jdbcDriver = DriverPool.getDriver(string);
        this.logDriverInformation();
    }

    public boolean equals(Object object) {
        return this == object;
    }

    public PreparedStatement createPreparedStatement(String string, int n2, int n3) throws SQLException {
        PreparedStatement preparedStatement = this.databaseCnx.prepareStatement(string, n2, n3);
        this.configureStatement(preparedStatement);
        return preparedStatement;
    }

    public PreparedStatement createPreparedStatement(String string) throws SQLException {
        PreparedStatement preparedStatement = this.databaseCnx.prepareStatement(string);
        this.configureStatement(preparedStatement);
        return preparedStatement;
    }

    public Statement createStatement() throws SQLException {
        Statement statement = this.databaseCnx.createStatement();
        this.configureStatement(statement);
        return statement;
    }

    public Statement createStatement(int n2, int n3) throws SQLException {
        Statement statement = this.databaseCnx.createStatement(n2, n3);
        this.configureStatement(statement);
        return statement;
    }

    public void configureOptions(Properties properties) {
        this.configuration.clear();
        if (properties == null) {
            return;
        }
        this.configuration.putAll((Map<?, ?>)properties);
    }

    public void disposeStatement(String string) {
        ResultSetRetreiver resultSetRetreiver = (ResultSetRetreiver)this.stmtMap.remove(string);
        if (resultSetRetreiver != null) {
            String string2 = BasicUtilities.getString(resourceBundle, "Statement_Dispose", string);
            this.logEvent(string2);
            this.finalizeStatement(resultSetRetreiver.sqlStatement, false);
            QUERY_THREADS.remove(string.toUpperCase());
        }
        resultSetRetreiver = null;
    }

    public void cancelStatement(String string) {
        ResultSetRetreiver resultSetRetreiver = (ResultSetRetreiver)this.stmtMap.remove(string);
        if (resultSetRetreiver != null) {
            Thread thread = DatabaseConnection.getThreadForName(string);
            if (thread != null) {
                thread.interrupt();
            }
            this.finalizeStatement(resultSetRetreiver.sqlStatement, true);
            QUERY_THREADS.remove(string.toUpperCase());
        }
        resultSetRetreiver = null;
    }

    public boolean gsConnect(Driver driver, String string) throws SQLException {
        this.gsJDBCDriver = driver;
        this.gsJDBCurl = string;
        return this.gsConnect();
    }

    public boolean gsConnect() throws SQLException {
        if (!this.isClosed()) {
            this.disconnect();
        }
        try {
            this.databaseCnx = GConnection.getInstance(this.gsSpaceProxy);
            this.gsJDBCurl = this.databaseCnx.getUrl();
            this.databaseCnx.setUseSingleSpace(this.useSingleSpace);
        }
        catch (Exception exception) {
            String[] stringArray = new String[]{exception.getMessage(), this.gsJDBCurl};
            String string = BasicUtilities.getString(resourceBundle, "Connection_SQL_Exception", stringArray);
            throw new SQLException(string);
        }
        catch (Throwable throwable) {
            String string = BasicUtilities.getString(resourceBundle, "Connection_Exception", this.gsJDBCurl);
            BasicUtilities.HandleException(throwable, string, this.getDebugOn());
            return false;
        }
        try {
            if (this.getPreferredHoldability() != Integer.MAX_VALUE) {
                this.databaseCnx.setHoldability(this.getPreferredHoldability());
                this.databaseCnx.setUseSingleSpace(true);
                this.gsConnection = this.databaseCnx;
            }
        }
        catch (SQLException sQLException) {
            this.trace("Connection::setHoldability", sQLException);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.cnxMetaData = this.databaseCnx.getMetaData();
        }
        catch (SQLException sQLException) {
            this.trace("Connection::getMetaData", sQLException);
            this.cnxMetaData = null;
        }
        catch (Throwable throwable) {
            this.trace("Connection::getMetaData", throwable);
            this.cnxMetaData = null;
        }
        return true;
    }

    public Connection getGSConnection() {
        return this.databaseCnx;
    }

    public void updateAutheticationTokens(String string, String string2) {
        if (!this.isClosed()) {
            throw new IllegalStateException(BasicUtilities.getString(resourceBundle, "Already_Connected"));
        }
        this.props.put("user", string == null ? "" : string);
        this.props.put("password", string2 == null ? "" : string2);
    }

    public DriverPropertyInfo[] getDriverProperties(Properties properties) throws SQLException {
        if (this.jdbcDriver != null) {
            return this.jdbcDriver.getPropertyInfo(this.jdbcURL, properties);
        }
        return new DriverPropertyInfo[0];
    }

    public Driver getDriver() {
        return this.jdbcDriver;
    }

    public void changeCatalog(String string) throws SQLException {
        block4: {
            if (this.isClosed()) {
                throw new IllegalStateException(BasicUtilities.getString(resourceBundle, "Connection_Unavailable"));
            }
            try {
                this.databaseCnx.setCatalog(string);
                this.fireDatabaseEvent(new DatabaseEvent(this, 5));
            }
            catch (SQLException sQLException) {
                this.HandleSQLException(sQLException);
                throw sQLException;
            }
            catch (Throwable throwable) {
                if (!this.getVerboseOn()) break block4;
                String string2 = BasicUtilities.getString(resourceBundle, "Catalog_Change_Error", string);
                BasicUtilities.HandleException(throwable, string2, this.getDebugOn());
            }
        }
    }

    public void setTransactionIsolation(int n2) throws SQLException {
        if (this.isClosed()) {
            throw new IllegalStateException(BasicUtilities.getString(resourceBundle, "Connection_Unavailable"));
        }
        try {
            this.databaseCnx.setTransactionIsolation(n2);
        }
        catch (SQLException sQLException) {
            this.HandleSQLException(sQLException);
            throw sQLException;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public String getCatalog() {
        if (this.isClosed()) {
            throw new IllegalStateException(BasicUtilities.getString(resourceBundle, "Connection_Unavailable"));
        }
        try {
            return this.databaseCnx.getCatalog();
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public String getSchema() {
        if (this.isClosed()) {
            throw new IllegalStateException(BasicUtilities.getString(resourceBundle, "Connection_Unavailable"));
        }
        return this.preferredSchema;
    }

    public void setPreferredSchema(String string) {
        this.preferredSchema = string;
    }

    public boolean isBatchSupported() {
        if (this.isClosed()) {
            throw new IllegalStateException(BasicUtilities.getString(resourceBundle, "Connection_Unavailable"));
        }
        return this.supportsBatch;
    }

    public boolean isTransactionsSupported() {
        if (this.isClosed()) {
            throw new IllegalStateException(BasicUtilities.getString(resourceBundle, "Connection_Unavailable"));
        }
        return this.supportsTransactions;
    }

    public boolean isSavePointsSupported() {
        if (this.isClosed()) {
            throw new IllegalStateException(BasicUtilities.getString(resourceBundle, "Connection_Unavailable"));
        }
        return this.supportsSavePoints;
    }

    public synchronized void setAutoCommit(boolean bl2) {
        block4: {
            if (this.isClosed()) {
                throw new IllegalStateException(BasicUtilities.getString(resourceBundle, "Connection_Unavailable"));
            }
            try {
                String[] stringArray = new String[]{this.getConnectionName(), Boolean.toString(bl2)};
                this.logEvent(BasicUtilities.getString(resourceBundle, "AutoCommitMode_Change", stringArray));
                this.databaseCnx.setAutoCommit(bl2);
                this.fireDatabaseEvent(new DatabaseEvent(this, 4));
            }
            catch (SQLException sQLException) {
                this.HandleSQLException(sQLException);
            }
            catch (Throwable throwable) {
                if (!this.getVerboseOn()) break block4;
                BasicUtilities.HandleException(throwable, null, this.getDebugOn());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performRollBack() {
        block7: {
            if (this.isClosed()) {
                throw new IllegalStateException(BasicUtilities.getString(resourceBundle, "Connection_Unavailable"));
            }
            try {
                this.logEvent(BasicUtilities.getString(resourceBundle, "Rollback_Notice", this.getConnectionName()));
                GConnection gConnection = this.databaseCnx;
                synchronized (gConnection) {
                    this.databaseCnx.rollback();
                }
                this.fireDatabaseEvent(new DatabaseEvent(this, 2));
            }
            catch (SQLException sQLException) {
                this.HandleSQLException(sQLException);
            }
            catch (Throwable throwable) {
                if (!this.getVerboseOn()) break block7;
                BasicUtilities.HandleException(throwable, null, this.getDebugOn());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SQLWarning getWarnings() {
        if (this.isClosed()) {
            throw new IllegalStateException(BasicUtilities.getString(resourceBundle, "Connection_Unavailable"));
        }
        try {
            SQLWarning sQLWarning = this.databaseCnx.getWarnings();
            return sQLWarning;
        }
        catch (SQLException sQLException) {
            this.HandleSQLException(sQLException);
            SQLWarning sQLWarning = null;
            return sQLWarning;
        }
        catch (Throwable throwable) {
            if (this.getVerboseOn()) {
                BasicUtilities.HandleException(throwable, null, this.getDebugOn());
            }
            SQLWarning sQLWarning = null;
            try {
                this.databaseCnx.clearWarnings();
            }
            catch (Throwable throwable2) {
                // empty catch block
            }
            return sQLWarning;
        }
        finally {
            try {
                this.databaseCnx.clearWarnings();
            }
            catch (Throwable throwable) {}
        }
    }

    public Map getTypeMap() {
        if (this.isClosed()) {
            throw new IllegalStateException(BasicUtilities.getString(resourceBundle, "Connection_Unavailable"));
        }
        try {
            return this.databaseCnx.getTypeMap();
        }
        catch (SQLException sQLException) {
            this.HandleSQLException(sQLException);
            return null;
        }
        catch (Throwable throwable) {
            if (this.getVerboseOn()) {
                BasicUtilities.HandleException(throwable, null, this.getDebugOn());
            }
            return null;
        }
    }

    public int getTransactionIsolation() {
        if (this.isClosed()) {
            throw new IllegalStateException(BasicUtilities.getString(resourceBundle, "Connection_Unavailable"));
        }
        try {
            return this.databaseCnx.getTransactionIsolation();
        }
        catch (Throwable throwable) {
            return 0;
        }
    }

    public boolean getAutoCommit() {
        if (this.isClosed()) {
            throw new IllegalStateException(BasicUtilities.getString(resourceBundle, "Connection_Unavailable"));
        }
        try {
            return this.databaseCnx.getAutoCommit();
        }
        catch (Throwable throwable) {
            return true;
        }
    }

    public void setConnectionName(String string) {
        this.cnxAlias = new String(string.getBytes());
    }

    public String getConnectionName() {
        return this.gsJDBCurl;
    }

    public int getMaxStatements() {
        return this.maxStatements;
    }

    public int getActiveStatements() {
        return this.stmtMap.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performCommit() {
        block8: {
            if (this.isClosed()) {
                throw new IllegalStateException(BasicUtilities.getString(resourceBundle, "Connection_Unavailable"));
            }
            try {
                this.logEvent(BasicUtilities.getString(resourceBundle, "Commit_Notice", this.getConnectionName()));
                GConnection gConnection = this.databaseCnx;
                synchronized (gConnection) {
                    if (!this.getAutoCommit()) {
                        this.databaseCnx.commit();
                    }
                }
                this.fireDatabaseEvent(new DatabaseEvent(this, 1));
            }
            catch (SQLException sQLException) {
                this.HandleSQLException(sQLException);
            }
            catch (Throwable throwable) {
                if (!this.getVerboseOn()) break block8;
                BasicUtilities.HandleException(throwable, null, this.getDebugOn());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void disconnect() {
        this.flushConnectionInfo();
        if (this.databaseCnx == null) {
            return;
        }
        DatabaseConnection.interruptQueries();
        DatabaseConnection databaseConnection = this;
        synchronized (databaseConnection) {
            if (!this.getAutoCommit()) {
                this.log(BasicUtilities.getString(resourceBundle, "Commit_On_Close_Notice"));
                this.performCommit();
            }
            Iterator iterator = this.stmtMap.keySet().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                this.disposeStatement(string);
                iterator.remove();
            }
            try {
                this.databaseCnx.clearWarnings();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                this.databaseCnx.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.databaseCnx = null;
            this.cnxMetaData = null;
        }
        this.fireDatabaseEvent(new DatabaseEvent(this, 0));
        this.logEvent(BasicUtilities.getString(resourceBundle, "Disconnect_Notice", this.getConnectionName()));
    }

    public void logDriverInformation() {
        this.log(BasicUtilities.getString(resourceBundle, "Driver_Information", new String[]{this.gsJDBCDriver.getClass().getName(), Integer.toString(this.gsJDBCDriver.getMajorVersion()), Integer.toString(this.gsJDBCDriver.getMinorVersion())}));
        if (this.gsJDBCDriver.jdbcCompliant()) {
            this.log(BasicUtilities.getString(resourceBundle, "Driver_Is_Compliant"));
        } else {
            this.log(BasicUtilities.getString(resourceBundle, "Driver_Is_Not_Compliant"));
        }
    }

    public final synchronized boolean isClosed() {
        if (this.databaseCnx != null) {
            try {
                return this.databaseCnx.isClosed();
            }
            catch (SQLException sQLException) {
                this.HandleSQLException(sQLException);
                this.databaseCnx = null;
                return true;
            }
            catch (Throwable throwable) {
                BasicUtilities.HandleException(throwable);
                this.databaseCnx = null;
                return true;
            }
        }
        return true;
    }

    public SQLException getLastError() {
        return this.lastError;
    }

    public DatabaseMetaData getDatabaseInformation() {
        return this.cnxMetaData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushConnectionInfo() {
        if (this.metaCache != null) {
            HashMap hashMap = this.metaCache;
            synchronized (hashMap) {
                this.metaCache.clear();
                this.metaCache = null;
            }
        }
    }

    public synchronized Map getConnectionInformation() {
        if (this.metaCache == null) {
            try {
                if (this.gsConnection == null) {
                    this.gsConnect();
                }
                DatabaseMetaData databaseMetaData = this.databaseCnx.getMetaData();
                Class<?> clazz = databaseMetaData.getClass();
                Method[] methodArray = clazz.getMethods();
                this.metaCache = new HashMap();
                Object[] objectArray = new Object[]{};
                for (int i2 = 0; i2 < methodArray.length; ++i2) {
                    String string = methodArray[i2].getName();
                    try {
                        Object object;
                        Class<?> clazz2 = methodArray[i2].getReturnType();
                        if (!clazz2.isPrimitive() && !clazz2.getName().endsWith("String")) continue;
                        if (string.startsWith("get")) {
                            string = string.substring(3);
                        }
                        this.metaCache.put(string, (object = methodArray[i2].invoke((Object)databaseMetaData, objectArray)) != null ? object.toString() : null);
                        continue;
                    }
                    catch (AbstractMethodError abstractMethodError) {
                        this.metaCache.put(string, BasicUtilities.getString(resourceBundle, "Unsupported_Method"));
                        continue;
                    }
                    catch (Throwable throwable) {
                        if (throwable instanceof SQLException) {
                            this.HandleSQLException((SQLException)throwable);
                            continue;
                        }
                        if (!this.getDebugOn()) continue;
                        BasicUtilities.HandleException(throwable, "getConnectionInformation()", this.getVerboseOn());
                    }
                }
            }
            catch (Exception exception) {
                BasicUtilities.HandleException(exception);
            }
        }
        return this.metaCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDatabaseListener(DatabaseListener databaseListener) {
        if (this.listenerList != null && this.listenerList.contains(databaseListener)) {
            ArrayList arrayList = this.listenerList;
            synchronized (arrayList) {
                this.listenerList.remove(databaseListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDatabaseListener(DatabaseListener databaseListener) {
        if (this.listenerList == null) {
            this.listenerList = new ArrayList(1);
        }
        if (!this.listenerList.contains(databaseListener)) {
            ArrayList arrayList = this.listenerList;
            synchronized (arrayList) {
                this.listenerList.add(databaseListener);
            }
        }
    }

    public int getMaxRowCount() {
        try {
            String string = this.configuration.getProperty("jdbc.max-rows");
            Integer n2 = Integer.decode(string);
            return n2;
        }
        catch (Throwable throwable) {
            return 0;
        }
    }

    public int getPreferredHoldability() {
        try {
            String string = this.configuration.getProperty("jdbc.resultset-holdability");
            Integer n2 = Integer.decode(string);
            return n2;
        }
        catch (Throwable throwable) {
            return Integer.MAX_VALUE;
        }
    }

    public int getMaxFieldSize() {
        try {
            String string = this.configuration.getProperty("jdbc.max-fieldsize");
            Integer n2 = Integer.decode(string);
            return n2;
        }
        catch (Throwable throwable) {
            return 0;
        }
    }

    public int getQueryTimeout() {
        try {
            String string = this.configuration.getProperty("jdbc.timeout-query");
            Integer n2 = Integer.decode(string);
            return n2;
        }
        catch (Throwable throwable) {
            return 0;
        }
    }

    public boolean getVerboseOn() {
        try {
            String string = this.configuration.getProperty("jdbc.verbose-enabled");
            Boolean bl2 = Boolean.valueOf(string);
            return bl2;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public boolean getDebugOn() {
        try {
            String string = this.configuration.getProperty("jdbc.debug-enabled");
            Boolean bl2 = Boolean.valueOf(string);
            return bl2;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public boolean isGeneratedKeysEnabled() {
        try {
            String string = this.configuration.getProperty("jdbc.resultsetkeys-enabled");
            Boolean bl2 = Boolean.valueOf(string);
            return bl2;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public boolean getQueryEchoOn() {
        try {
            String string = this.configuration.getProperty("jdbc.echo-query");
            Boolean bl2 = Boolean.valueOf(string);
            return bl2;
        }
        catch (Throwable throwable) {
            this.trace("getQueryEchoOn()", throwable);
            return false;
        }
    }

    public boolean getAutoReconnect() {
        try {
            String string = this.configuration.getProperty("jdbc.keepalive-enabled");
            Boolean bl2 = Boolean.valueOf(string);
            return bl2;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public boolean getEscapeProcessingOn() {
        try {
            String string = this.configuration.getProperty("jdbc.escapeProc-enabled");
            Boolean bl2 = Boolean.valueOf(string);
            return bl2;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public int getFetchMode() {
        try {
            String string = this.configuration.getProperty("jdbc.reverseFetch-enabled");
            Integer n2 = Integer.decode(string);
            return n2;
        }
        catch (Throwable throwable) {
            return 1002;
        }
    }

    public int getLoginTimeout() {
        return DriverManager.getLoginTimeout();
    }

    public final void logEvent(String string) {
        if (this.getVerboseOn()) {
            this.log(string);
        }
    }

    public String executeStaticRequest(String string, ResultSetViewer resultSetViewer) {
        return this.executeStaticRequest(string, resultSetViewer, 1004, 1007);
    }

    public String executeStaticRequest(String string, ResultSetViewer resultSetViewer, int n2, int n3) {
        try {
            if (this.gsConnection == null) {
                this.gsConnect();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        String string2 = Long.toHexString(System.currentTimeMillis()).toUpperCase();
        String string3 = "isql.{0}.{1}";
        string2 = MessageFormat.format(string3, this.getConnectionName(), string2);
        ResultSetRetreiver resultSetRetreiver = new ResultSetRetreiver(string2, resultSetViewer, null, string);
        resultSetRetreiver.setResultsetType(n2);
        resultSetRetreiver.setResultsetConcurrency(n3);
        Thread thread = new Thread((Runnable)resultSetRetreiver, string2);
        QUERY_THREADS.put(string2.toUpperCase(), thread);
        thread.start();
        return string2;
    }

    public String executeStatement(Statement statement, String string, ResultSetViewer resultSetViewer) {
        String string2 = Long.toHexString(System.currentTimeMillis()).toUpperCase();
        String string3 = "isql.{0}.{1}";
        string2 = MessageFormat.format(string3, this.getConnectionName(), string2);
        ResultSetRetreiver resultSetRetreiver = new ResultSetRetreiver(string2, resultSetViewer, statement, string);
        Thread thread = new Thread((Runnable)resultSetRetreiver, string2);
        QUERY_THREADS.put(string2.toUpperCase(), thread);
        thread.start();
        return string2;
    }

    public String executePreparedRequest(String string, Object[] objectArray, int[] nArray, ResultSetViewer resultSetViewer) throws SQLException {
        return this.executePreparedRequest(string, objectArray, nArray, resultSetViewer, 1004, 1007);
    }

    public String executePreparedRequest(String string, Object[] objectArray, int[] nArray, ResultSetViewer resultSetViewer, int n2, int n3) throws SQLException {
        if (this.isClosed()) {
            throw new IllegalStateException(BasicUtilities.getString(resourceBundle, "Connection_Unavailable"));
        }
        PreparedStatement preparedStatement = null;
        if (resultSetViewer == null) {
            resultSetViewer = new NullResultSetViewer(this);
        }
        try {
            preparedStatement = this.cnxMetaData.supportsResultSetConcurrency(n2, n3) ? this.createPreparedStatement(string, n2, n3) : this.createPreparedStatement(string);
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (Throwable throwable) {
            throw new SQLException(throwable.getMessage());
        }
        if (preparedStatement != null) {
            JDBCUtilities.configurePreparedStatement(preparedStatement, objectArray, nArray, false);
            SQLWarning sQLWarning = preparedStatement.getWarnings();
            if (sQLWarning != null) {
                resultSetViewer.recieveStatementWarnings(preparedStatement, sQLWarning);
                preparedStatement.clearWarnings();
            }
            String string2 = Long.toHexString(System.currentTimeMillis()).toUpperCase();
            String string3 = "isql.{0}.{1}";
            string2 = MessageFormat.format(string3, this.getConnectionName(), string2);
            ResultSetRetreiver resultSetRetreiver = new ResultSetRetreiver(string2, resultSetViewer, preparedStatement, string);
            resultSetRetreiver.setResultsetType(n2);
            resultSetRetreiver.setResultsetConcurrency(n3);
            Thread thread = new Thread((Runnable)resultSetRetreiver, string2);
            QUERY_THREADS.put(string2.toUpperCase(), thread);
            thread.start();
            return string2;
        }
        throw new SQLException();
    }

    public int[] executeBatch(Collection collection) throws SQLException {
        return this.executeBatch(collection, !this.supportsBatch, this.supportsTransactions, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] executeBatch(Collection collection, boolean bl2, boolean bl3, ProgressListener progressListener) throws SQLException {
        if (this.isClosed()) {
            throw new IllegalStateException(BasicUtilities.getString(resourceBundle, "Connection_Unavailable"));
        }
        if (collection.isEmpty()) {
            throw new IllegalStateException(BasicUtilities.getString(resourceBundle, "Cannot_Execute_Empty_Batch"));
        }
        ProgressEvent progressEvent = new ProgressEvent(this, 0, collection.size());
        Statement statement = null;
        int[] nArray = new int[collection.size()];
        int n2 = 0;
        if (bl3) {
            this.setAutoCommit(false);
        }
        Iterator iterator = collection.iterator();
        if (bl2) {
            while (iterator.hasNext()) {
                try {
                    statement = this.createStatement();
                    String string = (String)iterator.next();
                    long l2 = System.currentTimeMillis();
                    if (this.getQueryEchoOn()) {
                        String[] stringArray = new String[2];
                        stringArray[0] = BasicUtilities.getString(resourceBundle, "Basic_Query");
                        try {
                            stringArray[1] = this.databaseCnx.nativeSQL(string == null ? "" : string);
                        }
                        catch (Throwable throwable) {
                            stringArray[1] = string == null ? "" : string;
                        }
                        this.log(BasicUtilities.getString(resourceBundle, "Query_Echo", stringArray));
                        stringArray = null;
                    }
                    progressEvent.setProgress(n2);
                    statement.execute(string);
                    int n3 = statement.getUpdateCount();
                    nArray[n2++] = n3;
                    this.logEvent(BasicUtilities.getString(resourceBundle, "Row_Affected_Count", Integer.toString(n3)));
                    this.finalizeStatement(statement, false);
                    if (progressListener != null) {
                        progressListener.progressUpdated(progressEvent);
                        try {
                            if (Thread.currentThread().isInterrupted()) {
                                throw new InterruptedException();
                            }
                            DatabaseConnection databaseConnection = this;
                            synchronized (databaseConnection) {
                                this.wait(5L);
                            }
                        }
                        catch (InterruptedException interruptedException) {
                            if (bl3) {
                                this.performRollBack();
                            }
                            return null;
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                    l2 = System.currentTimeMillis() - l2;
                    this.logEvent(BasicUtilities.getString(resourceBundle, "Execution_Statistic", Long.toString(l2)));
                }
                catch (SQLException sQLException) {
                    this.HandleSQLException(sQLException);
                    this.finalizeStatement(statement, true);
                    if (!bl3) continue;
                    this.performRollBack();
                    throw sQLException;
                }
                catch (Throwable throwable) {
                    BasicUtilities.HandleException(throwable, BasicUtilities.getString(resourceBundle, "Unexpected_Batch_Error"), this.getDebugOn());
                    this.finalizeStatement(statement, true);
                    if (!bl3) continue;
                    this.performRollBack();
                    return null;
                }
            }
            if (bl3) {
                this.performCommit();
            }
        } else {
            DatabaseConnection databaseConnection;
            statement = this.createStatement();
            int n4 = 0;
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                this.logEvent(BasicUtilities.getString(resourceBundle, "Adding_Batch_Statement", Integer.toString(++n4)));
                try {
                    statement.addBatch(string);
                    progressEvent.setProgress(n4);
                    if (progressListener == null) continue;
                    progressListener.progressUpdated(progressEvent);
                    try {
                        if (Thread.currentThread().isInterrupted()) {
                            throw new InterruptedException();
                        }
                        databaseConnection = this;
                        synchronized (databaseConnection) {
                            this.wait(5L);
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        this.finalizeStatement(statement, true);
                        if (bl3) {
                            this.performRollBack();
                        }
                        return null;
                    }
                    catch (Throwable throwable) {
                    }
                }
                catch (SQLException sQLException) {
                    this.HandleSQLException(sQLException);
                    if (!bl3) continue;
                    this.performRollBack();
                    throw sQLException;
                }
                catch (Throwable throwable) {
                    BasicUtilities.HandleException(throwable, BasicUtilities.getString(resourceBundle, "Unexpected_Batch_Error"), this.getDebugOn());
                    if (!bl3) continue;
                    this.performRollBack();
                    this.finalizeStatement(statement, true);
                    return null;
                }
            }
            try {
                long l3 = System.currentTimeMillis();
                nArray = statement.executeBatch();
                l3 = System.currentTimeMillis() - l3;
                this.logEvent(BasicUtilities.getString(resourceBundle, "Batch_Execution_Statistic", Long.toString(l3)));
                if (bl3) {
                    this.performCommit();
                }
                this.finalizeStatement(statement, false);
            }
            catch (SQLException sQLException) {
                this.HandleSQLException(sQLException);
                this.finalizeStatement(statement, true);
                if (bl3) {
                    this.performRollBack();
                }
                throw sQLException;
            }
            catch (Throwable throwable) {
                BasicUtilities.HandleException(throwable, BasicUtilities.getString(resourceBundle, "Unexpected_Batch_Error"), this.getDebugOn());
                if (bl3) {
                    this.performRollBack();
                }
                this.finalizeStatement(statement, true);
                databaseConnection = null;
                return databaseConnection;
            }
            finally {
                this.setAutoCommit(true);
            }
        }
        return nArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object[] getAvailableCatalogs() {
        Object[] objectArray;
        if (this.isClosed()) {
            throw new IllegalStateException(BasicUtilities.getString(resourceBundle, "Connection_Unavailable"));
        }
        ResultSet resultSet = null;
        try {
            resultSet = this.cnxMetaData.getCatalogs();
            objectArray = JDBCUtilities.getSingleColumn(resultSet, 1, null).toArray();
        }
        catch (Throwable throwable) {
            try {
                BasicUtilities.HandleException(throwable);
                Object[] objectArray2 = new String[]{};
                return objectArray2;
            }
            catch (Throwable throwable2) {
                throw throwable2;
            }
            finally {
                try {
                    resultSet.close();
                }
                catch (Throwable throwable3) {}
            }
        }
        try {
            resultSet.close();
            return objectArray;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return objectArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object[] getAvailableSchemas() {
        Object[] objectArray;
        if (this.isClosed()) {
            throw new IllegalStateException(BasicUtilities.getString(resourceBundle, "Connection_Unavailable"));
        }
        ResultSet resultSet = null;
        try {
            resultSet = this.cnxMetaData.getSchemas();
            objectArray = JDBCUtilities.getSingleColumn(resultSet, "TABLE_SCHEM", null);
        }
        catch (Throwable throwable) {
            try {
                BasicUtilities.HandleException(throwable);
                Object[] objectArray2 = null;
                return objectArray2;
            }
            catch (Throwable throwable2) {
                throw throwable2;
            }
            finally {
                try {
                    resultSet.close();
                }
                catch (Throwable throwable3) {}
            }
        }
        try {
            resultSet.close();
            return objectArray;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return objectArray;
    }

    public Object[] getAvailableTables() {
        if (this.isClosed()) {
            throw new IllegalStateException(BasicUtilities.getString(resourceBundle, "Connection_Unavailable"));
        }
        try {
            return this.getAvailableTables(this.getCatalog());
        }
        catch (Throwable throwable) {
            BasicUtilities.HandleException(throwable);
            return new String[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object[] getAvailableTables(String string) {
        Object[] objectArray;
        if (this.isClosed()) {
            throw new IllegalStateException(BasicUtilities.getString(resourceBundle, "Connection_Unavailable"));
        }
        ResultSet resultSet = null;
        try {
            resultSet = this.cnxMetaData.getTables(string, this.getSchema(), "%", this.tableTypes);
            objectArray = JDBCUtilities.getSingleColumn(resultSet, "TABLE_NAME", null);
        }
        catch (Throwable throwable) {
            try {
                BasicUtilities.HandleException(throwable, "DatabaseConnection::getAvailableTables(" + string + ")", this.getDebugOn());
                Object[] objectArray2 = new String[]{};
                return objectArray2;
            }
            catch (Throwable throwable2) {
                throw throwable2;
            }
            finally {
                try {
                    resultSet.close();
                }
                catch (Throwable throwable3) {}
            }
        }
        try {
            resultSet.close();
            return objectArray;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return objectArray;
    }

    public String[] getTableTypes() {
        if (this.isClosed()) {
            throw new IllegalStateException(BasicUtilities.getString(resourceBundle, "Connection_Unavailable"));
        }
        return this.tableTypes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object[] getProcedures() {
        Object[] objectArray;
        if (this.isClosed()) {
            throw new IllegalStateException(BasicUtilities.getString(resourceBundle, "Connection_Unavailable"));
        }
        ResultSet resultSet = null;
        try {
            resultSet = this.getDatabaseInformation().getProcedures(this.getCatalog(), null, null);
            objectArray = JDBCUtilities.getSingleColumn(resultSet, "PROCEDURE_NAME", null);
        }
        catch (Throwable throwable) {
            try {
                BasicUtilities.HandleException(throwable, null, this.getDebugOn());
                Object[] objectArray2 = new Object[]{};
                return objectArray2;
            }
            catch (Throwable throwable2) {
                throw throwable2;
            }
            finally {
                try {
                    resultSet.close();
                }
                catch (Throwable throwable3) {}
            }
        }
        try {
            resultSet.close();
            return objectArray;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return objectArray;
    }

    public final void log(String string) {
        System.out.println(string);
    }

    public final void trace(String string, Throwable throwable) {
        if (DriverManager.getLogWriter() != null) {
            BasicUtilities.HandleException(throwable, string, true, DriverManager.getLogWriter());
            if (throwable instanceof SQLException) {
                this.lastError = (SQLException)throwable;
            }
        }
    }

    public synchronized boolean re_init() throws SQLException {
        this.logEvent(BasicUtilities.getString(resourceBundle, "Keep_Alive_Message"));
        this.disconnect();
        return this.gsConnect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finalize() throws Throwable {
        this.disconnect();
        try {
            DriverPool.deregisterDriver(this.jdbcDriver);
        }
        catch (Throwable throwable) {
        }
        finally {
            this.jdbcDriver = null;
            this.jdbcURL = null;
            this.cnxAlias = null;
            this.props.clear();
            this.props = null;
        }
        super.finalize();
    }

    public void fireDatabaseEvent(DatabaseEvent databaseEvent) {
        if (this.listenerList != null) {
            Iterator iterator = this.listenerList.iterator();
            while (iterator.hasNext()) {
                DatabaseListener databaseListener = (DatabaseListener)iterator.next();
                try {
                    databaseListener.processDatabaseEvent(databaseEvent);
                }
                catch (Throwable throwable) {}
            }
        }
    }

    private void HandleSQLException(SQLException sQLException) {
        if (!this.getVerboseOn() || sQLException == null) {
            return;
        }
        String[] stringArray = new String[]{sQLException.getMessage() != null ? sQLException.getMessage().trim() : "null", Integer.toString(sQLException.getErrorCode()), sQLException.getSQLState() == null ? "null" : sQLException.getSQLState()};
        System.err.println(BasicUtilities.getString(resourceBundle, "SQL_Exception", stringArray));
        stringArray = null;
        if (this.getDebugOn()) {
            sQLException.printStackTrace(System.err);
        }
        this.lastError = sQLException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void configureStatement(Statement statement) {
        if (statement != null) {
            Statement statement2 = statement;
            synchronized (statement2) {
                try {
                    if (this.getQueryTimeout() >= 0) {
                        statement.setQueryTimeout(this.getQueryTimeout());
                    }
                }
                catch (SQLException sQLException) {
                    this.trace("Statement::setQueryTimeout()", sQLException);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                try {
                    statement.setEscapeProcessing(this.getEscapeProcessingOn());
                }
                catch (SQLException sQLException) {
                    this.trace("Statement::setEscapeProcessing()", sQLException);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                try {
                    if (this.getMaxFieldSize() >= 1) {
                        statement.setMaxFieldSize(this.getMaxFieldSize());
                    }
                }
                catch (SQLException sQLException) {
                    this.trace("Statement::setMaxFieldSize()", sQLException);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                try {
                    if (this.getMaxRowCount() >= 1) {
                        statement.setMaxRows(this.getMaxRowCount());
                    }
                }
                catch (SQLException sQLException) {
                    this.trace("Statement::setMaxRows()", sQLException);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                try {
                    if (this.getFetchMode() != 1002) {
                        statement.setFetchDirection(this.getFetchMode());
                    }
                }
                catch (SQLException sQLException) {
                    this.trace("Statement::setFetchDirection()", sQLException);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finalizeStatement(Statement statement, boolean bl2) {
        if (statement == null) {
            return;
        }
        Statement statement2 = statement;
        synchronized (statement2) {
            try {
                if (bl2) {
                    statement.cancel();
                }
            }
            catch (SQLException sQLException) {
                this.trace("Statement::cancel", sQLException);
            }
            catch (Throwable throwable) {
                String string = BasicUtilities.getString(resourceBundle, "Unexcepted_Statement_Cancel_Error");
                BasicUtilities.HandleException(throwable, string, this.getDebugOn());
            }
            try {
                statement.clearBatch();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                statement.clearWarnings();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                statement.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private static Thread getThreadForName(String string) {
        return (Thread)QUERY_THREADS.get(string.toUpperCase());
    }

    private static String getStringHoldability(int n2) {
        switch (n2) {
            case 1: {
                return BasicUtilities.getString(resourceBundle, "Holding_Cursors_Across_Commits");
            }
            case 2: {
                return BasicUtilities.getString(resourceBundle, "Closing_Cursors_Across_Commits");
            }
        }
        return BasicUtilities.getString(resourceBundle, "Unknown_or_Holdability_Is_UnSupported");
    }

    private static void interruptQueries() {
        Iterator iterator = QUERY_THREADS.keySet().iterator();
        while (iterator.hasNext()) {
            Object k2 = iterator.next();
            Thread thread = (Thread)QUERY_THREADS.get(k2);
            thread.interrupt();
            try {
                thread.join(1000L);
            }
            catch (Throwable throwable) {}
        }
    }

    public boolean initialize() {
        return false;
    }

    public void setUseSingleSpace(boolean bl2) {
        this.useSingleSpace = bl2;
    }

    public IJSpace getGsSpaceProxy() {
        return this.gsSpaceProxy;
    }

    public static /* synthetic */ void access$200(DatabaseConnection databaseConnection, Statement statement) {
        databaseConnection.configureStatement(statement);
    }

    public static /* synthetic */ DatabaseMetaData access$400(DatabaseConnection databaseConnection) {
        return databaseConnection.cnxMetaData;
    }

    public static /* synthetic */ boolean access$500(DatabaseConnection databaseConnection) {
        return databaseConnection.supportMultiResults;
    }

    static {
        try {
            resourceBundle = ResourceBundle.getBundle("org.isqlviewer.sql.ResourceStrings");
        }
        catch (Throwable throwable) {
            System.err.println("** Fatal Error ** iSQL-Viewer ResourceBundle(org.isqlviewer.sql.ResourceStrings) is unavailable exiting....");
            System.exit(-1);
        }
    }

    private static class NullResultSetViewer
    implements ResultSetViewer {
        private DatabaseConnection reference = null;

        public NullResultSetViewer(DatabaseConnection databaseConnection) {
            this.reference = databaseConnection;
        }

        public void handleSQLException(ResultSet resultSet, SQLException sQLException) {
            this.reference.HandleSQLException(sQLException);
        }

        public void handleStatementInterrupted(String string) {
        }

        public void processGeneratedKeys(String string, ResultSet resultSet, String string2) {
        }

        public void processResultSet(String string, ResultSet resultSet, String string2, int n2, IJSpace iJSpace) {
        }

        public void processRowUpdates(String string, int n2, String string2) {
        }

        public void recieveResultsetWarnings(ResultSet resultSet, SQLWarning sQLWarning) {
            this.reference.HandleSQLException(sQLWarning);
        }

        public void recieveStatementWarnings(Statement statement, SQLWarning sQLWarning) {
            this.reference.HandleSQLException(sQLWarning);
        }

        public void statementInitialized(String string) {
        }

        public boolean supportsGeneratedKeys() {
            return false;
        }

        public boolean supportsUpdateableResultSets() {
            return false;
        }
    }

    private class ResultSetRetreiver
    implements Runnable {
        private ResultSetViewer viewer = null;
        private Statement sqlStatement = null;
        private String SQL = null;
        private String localID = null;
        private boolean multiQuery = false;
        private boolean closeStatement = true;
        private int type = 1003;
        private int concur = 1007;
        static /* synthetic */ Class class$java$lang$ClassNotFoundException;

        public ResultSetRetreiver(String string, ResultSetViewer resultSetViewer, Statement statement, String string2) {
            this.viewer = resultSetViewer == null ? new NullResultSetViewer(DatabaseConnection.this) : resultSetViewer;
            this.localID = string;
            this.sqlStatement = statement;
            this.SQL = string2;
            this.multiQuery = !(this.sqlStatement instanceof CallableStatement) && !(this.sqlStatement instanceof PreparedStatement);
        }

        public void setResultsetType(int n2) {
            this.type = n2;
        }

        public void setResultsetConcurrency(int n2) {
            this.concur = n2;
        }

        public String getLocalID() {
            return this.localID;
        }

        private void dispatchInterruption() {
            if (this.viewer != null) {
                this.viewer.handleStatementInterrupted(this.localID);
            }
        }

        private String echoStatementInfo(String string) {
            if (DatabaseConnection.this.getQueryEchoOn()) {
                String[] stringArray = new String[2];
                stringArray[0] = this.sqlStatement instanceof CallableStatement ? BasicUtilities.getString(resourceBundle, "Callable_Statement") : (this.sqlStatement instanceof PreparedStatement ? BasicUtilities.getString(resourceBundle, "Prepared_Statement") : BasicUtilities.getString(resourceBundle, "Basic_Query"));
                try {
                    stringArray[1] = DatabaseConnection.this.databaseCnx.nativeSQL(string == null ? "" : string);
                }
                catch (Throwable throwable) {
                    stringArray[1] = string == null ? "" : string;
                }
                String string2 = stringArray[1];
                stringArray[1] = StringUtilities.formatBreak(80, string2, "\t", false);
                DatabaseConnection.this.log(BasicUtilities.getString(resourceBundle, "Query_Echo", stringArray));
                return string2;
            }
            try {
                return DatabaseConnection.this.databaseCnx.nativeSQL(string == null ? "" : string);
            }
            catch (Throwable throwable) {
                DatabaseConnection.this.trace(MessageFormat.format("Connection:nativeSQL(''{0}'')", string), throwable);
                return "";
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        private void doQuery(String var1_1, String var2_2) throws Exception {
            block82: {
                var3_3 = false;
                if (DatabaseConnection.this.getActiveStatements() > DatabaseConnection.this.getMaxStatements()) {
                    var4_4 = BasicUtilities.getString(DatabaseConnection.resourceBundle, "Max_Statement_Exceeded");
                    var5_11 = Integer.toString(DatabaseConnection.this.getActiveStatements()).concat(">").concat(Integer.toString(DatabaseConnection.this.getMaxStatements()));
                    throw new SQLException(var4_4, var5_11, 74615);
                }
                if (this.multiQuery || this.sqlStatement == null) {
                    try {
                        var4_5 = DatabaseConnection.access$100(DatabaseConnection.this).getMetaData();
                        this.sqlStatement = var4_5.supportsResultSetConcurrency(this.type, this.concur) ? DatabaseConnection.this.createStatement(this.type, this.concur) : DatabaseConnection.this.createStatement();
                    }
                    catch (SQLException var4_6) {
                        throw var4_6;
                    }
                    catch (Throwable var4_7) {
                        var5_12 = BasicUtilities.getString(DatabaseConnection.resourceBundle, "Default_Statement_Disabled");
                        throw new SQLException(var5_12);
                    }
                    DatabaseConnection.access$200(DatabaseConnection.this, this.sqlStatement);
                }
                if (Thread.interrupted()) {
                    this.dispatchInterruption();
                    return;
                }
                if (this.concur == 1008) {
                    try {
                        this.sqlStatement.setCursorName(this.localID);
                    }
                    catch (SQLException var4_8) {
                        DatabaseConnection.access$300(DatabaseConnection.this, var4_8);
                    }
                    catch (Throwable var4_9) {
                        // empty catch block
                    }
                }
                var4_10 = Runtime.getRuntime().freeMemory();
                var6_13 = System.currentTimeMillis();
                var8_14 = false;
                if (this.sqlStatement instanceof PreparedStatement) {
                    var9_15 = (PreparedStatement)this.sqlStatement;
                    var3_3 = var9_15.execute();
                } else if (DatabaseConnection.this.isGeneratedKeysEnabled()) {
                    try {
                        if (DatabaseConnection.access$400(DatabaseConnection.this).supportsGetGeneratedKeys()) {
                            var3_3 = this.sqlStatement.execute(var1_1, 1);
                            var8_14 = true;
                            break block82;
                        }
                        var9_15 = BasicUtilities.getString(DatabaseConnection.resourceBundle, "Query_With_Keys_Not_Supported");
                        DatabaseConnection.this.log((String)var9_15);
                        var3_3 = this.sqlStatement.execute(var1_1, 2);
                    }
                    catch (Throwable var9_16) {
                        var10_17 = BasicUtilities.getString(DatabaseConnection.resourceBundle, "Query_With_Keys_Failed");
                        DatabaseConnection.this.log(var10_17);
                        var3_3 = this.sqlStatement.execute(var1_1);
                    }
                } else {
                    var3_3 = this.sqlStatement.execute(var1_1);
                }
            }
            var6_13 = System.currentTimeMillis() - var6_13;
            var9_15 = StringUtilities.getHumanReadableSize(var4_10 -= Runtime.getRuntime().freeMemory());
            DatabaseConnection.this.log(BasicUtilities.getString(DatabaseConnection.resourceBundle, "Execution_Statistic", Long.toString(var6_13)));
            DatabaseConnection.this.log(BasicUtilities.getString(DatabaseConnection.resourceBundle, "Memory_Statistic", (String)var9_15));
            var10_18 = -1;
            if (!var3_3) {
                try {
                    var10_18 = this.sqlStatement.getUpdateCount();
                }
                catch (SQLException var11_19) {
                    DatabaseConnection.access$300(DatabaseConnection.this, var11_19);
                    var10_18 = -1;
                }
                catch (Throwable var11_20) {
                    BasicUtilities.HandleException(var11_20, "Statement::getUpdateCount()");
                    var10_18 = -1;
                }
            } else {
                var10_18 = -1;
            }
            var11_22 = 0;
            do {
                var12_23 = null;
                if (var3_3) {
                    block83: {
                        var12_23 = this.sqlStatement.getResultSet();
                        try {
                            var6_13 = System.currentTimeMillis();
                            var4_10 = Runtime.getRuntime().freeMemory();
                            this.viewer.processResultSet(this.localID, (ResultSet)var12_23, var2_2, var11_22, DatabaseConnection.this.getGsSpaceProxy());
                            var6_13 = System.currentTimeMillis() - var6_13;
                            var9_15 = StringUtilities.getHumanReadableSize(var4_10 -= Runtime.getRuntime().freeMemory());
                            DatabaseConnection.this.log(BasicUtilities.getString(DatabaseConnection.resourceBundle, "Memory_Statistic", (String)var9_15));
                            DatabaseConnection.this.log(BasicUtilities.getString(DatabaseConnection.resourceBundle, "Rendering_Statistic", Long.toString(var6_13)));
                        }
                        catch (Throwable var13_30) {
                            if (!DatabaseConnection.this.getVerboseOn()) break block83;
                            BasicUtilities.HandleException(var13_30, "ResultSetViewer::processResultSet");
                        }
                    }
                    try {
                        var13_29 = var12_23.getWarnings();
                        if (var13_29 == null) ** GOTO lbl115
                        this.viewer.recieveResultsetWarnings((ResultSet)var12_23, var13_29);
                    }
                    catch (SQLException var13_32) {
                        DatabaseConnection.access$300(DatabaseConnection.this, var13_32);
                    }
                    finally {
                        try {
                            var12_23.clearWarnings();
                        }
                        catch (Throwable var13_33) {}
                    }
                } else if (var10_18 >= 0) {
                    block84: {
                        try {
                            var6_13 = System.currentTimeMillis();
                            this.viewer.processRowUpdates(this.localID, var10_18, var2_2);
                            var6_13 = System.currentTimeMillis() - var6_13;
                            DatabaseConnection.this.log(BasicUtilities.getString(DatabaseConnection.resourceBundle, "Rendering_Statistic", Long.toString(var6_13)));
                        }
                        catch (Throwable var13_34) {
                            if (!DatabaseConnection.this.getVerboseOn()) break block84;
                            BasicUtilities.HandleException(var13_34, "ResultSetViewer::processResultSet");
                        }
                    }
                    DatabaseConnection.this.logEvent(BasicUtilities.getString(DatabaseConnection.resourceBundle, "Row_Affected_Count", Integer.toString(var10_18)));
                }
lbl115:
                // 6 sources

                if (this.viewer.supportsGeneratedKeys() && var8_14) {
                    try {
                        var12_23 = this.sqlStatement.getGeneratedKeys();
                        this.viewer.processGeneratedKeys(this.localID, (ResultSet)var12_23, var2_2);
                    }
                    catch (Throwable var13_36) {
                        if (DatabaseConnection.this.getVerboseOn()) {
                            BasicUtilities.HandleException(var13_36, "ResultSetViewer::processResultSet");
                        }
                    }
                    finally {
                        try {
                            var12_23.close();
                        }
                        catch (Throwable var13_35) {}
                    }
                }
                if (!DatabaseConnection.access$500(DatabaseConnection.this)) {
                    v0 = var13_38 = this.viewer.supportsUpdateableResultSets() == false;
                    if (!JDBCUtilities.isUpdatable((ResultSet)var12_23) || var13_38) {
                        try {
                            if (var12_23 == null) break;
                            DatabaseConnection.this.logEvent(BasicUtilities.getString(DatabaseConnection.resourceBundle, "ResultSet_Closing"));
                            var12_23.close();
                        }
                        catch (SQLException var14_43) {
                            DatabaseConnection.access$300(DatabaseConnection.this, var14_43);
                        }
                        break;
                    }
                    this.closeStatement = false;
                    DatabaseConnection.this.logEvent(BasicUtilities.getString(DatabaseConnection.resourceBundle, "ResultSet_Closing_Skip"));
                    break;
                }
                var3_3 = this.sqlStatement.getMoreResults();
                if (var12_23 != null && var3_3) {
                    try {
                        var12_23.close();
                    }
                    catch (SQLException var13_39) {
                        DatabaseConnection.access$300(DatabaseConnection.this, var13_39);
                    }
                }
                if (!var3_3) {
                    try {
                        var10_18 = this.sqlStatement.getUpdateCount();
                    }
                    catch (SQLException var13_40) {
                        DatabaseConnection.access$300(DatabaseConnection.this, var13_40);
                        var10_18 = -1;
                    }
                    catch (Throwable var13_41) {
                        var10_18 = -1;
                    }
                    continue;
                }
                var10_18 = -1;
            } while (var3_3 || var10_18 != -1);
            if (this.viewer != null) {
                try {
                    var12_23 = this.sqlStatement.getWarnings();
                    if (var12_23 != null) {
                        this.viewer.recieveStatementWarnings(this.sqlStatement, (SQLWarning)var12_23);
                    }
                }
                catch (SQLException var12_25) {
                    DatabaseConnection.access$300(DatabaseConnection.this, var12_25);
                }
                catch (Throwable var12_27) {
                    BasicUtilities.HandleException(var12_27);
                }
                finally {
                    try {
                        this.sqlStatement.clearWarnings();
                    }
                    catch (Throwable var12_26) {}
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                if (DatabaseConnection.this.databaseCnx.isClosed() && DatabaseConnection.this.getAutoReconnect()) {
                    DatabaseConnection.this.re_init();
                }
            }
            catch (Throwable throwable) {
                DatabaseConnection.this.log(BasicUtilities.getString(resourceBundle, "Connection_Unavailable"));
                return;
            }
            try {
                DatabaseConnection.this.databaseCnx.clearWarnings();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            Object object = DatabaseConnection.this.stmtMap;
            synchronized (object) {
                DatabaseConnection.this.stmtMap.put(this.getLocalID(), this);
            }
            this.viewer.statementInitialized(this.localID);
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                this.dispatchInterruption();
                return;
            }
            object = new StringTokenizer(this.SQL, ";", false, true);
            ((StringTokenizer)object).setQuotesEnabled(true);
            try {
                while (((StringTokenizer)object).hasMoreTokens()) {
                    String string = ((StringTokenizer)object).nextToken().trim();
                    if (string.length() == 0) continue;
                    String string2 = this.echoStatementInfo(string);
                    this.doQuery(string, string2);
                }
            }
            catch (InterruptedException interruptedException) {
                DatabaseConnection.this.cancelStatement(this.getLocalID());
                return;
            }
            catch (SQLException sQLException) {
                DatabaseConnection.this.HandleSQLException(sQLException);
                this.viewer.handleSQLException(null, sQLException);
                DatabaseConnection.this.disposeStatement(this.getLocalID());
                String string = null;
                Class<?> clazz = class$java$lang$ClassNotFoundException;
                if (clazz == null) {
                    clazz = class$java$lang$ClassNotFoundException = new ClassNotFoundException[0].getClass().getComponentType();
                }
                if ((string = JSpaceUtilities.getCauseExceptionMessageFromHierarchy(sQLException, clazz)) != null) {
                    JOptionPane.showMessageDialog(SpaceBrowser.getInstance(), "The following class was not found. Please add it to the classpath:\n" + string, "Class Not Found", 2);
                } else {
                    SpaceBrowser.showException("Query", sQLException);
                }
            }
            catch (Exception exception) {
                BasicUtilities.HandleException(exception);
                DatabaseConnection.this.disposeStatement(this.getLocalID());
                SpaceBrowser.showException("Query", exception);
            }
            catch (Error error) {
                BasicUtilities.HandleException(error);
                DatabaseConnection.this.disposeStatement(this.getLocalID());
                SpaceBrowser.getInstance().getISQLPane().getWorkBench().getResultDelegate().cancelButtonPressed();
                SpaceBrowser.showException("Query", error);
            }
            finally {
                if (this.closeStatement) {
                    DatabaseConnection.this.disposeStatement(this.getLocalID());
                }
                System.runFinalization();
                if (((StringTokenizer)object).hasMoreTokens()) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        this.dispatchInterruption();
                        return;
                    }
                }
            }
        }
    }
}

