/*
 * Decompiled with CFR 0.152.
 */
package org.garret.perst.impl;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import org.garret.perst.IFile;
import org.garret.perst.StorageError;
import org.garret.perst.impl.Bytes;
import org.garret.perst.impl.Page;
import org.garret.perst.impl.ReplicationMasterStorageImpl;

public class ReplicationMasterFile
implements IFile,
Runnable {
    public static int LINGER_TIME = 10;
    public static int MAX_CONNECT_ATTEMPTS = 10;
    public static int CONNECTION_TIMEOUT = 1000;
    Object mutex;
    OutputStream[] out;
    InputStream[] in;
    Socket[] sockets;
    byte[] txBuf;
    byte[] rcBuf;
    IFile file;
    String[] hosts;
    int nHosts;
    int port;
    boolean ack;
    boolean listening;
    Thread listenThread;
    ServerSocket listenSocket;
    ReplicationMasterStorageImpl storage;

    public ReplicationMasterFile(ReplicationMasterStorageImpl replicationMasterStorageImpl, IFile iFile) {
        this(replicationMasterStorageImpl, iFile, replicationMasterStorageImpl.port, replicationMasterStorageImpl.hosts, replicationMasterStorageImpl.replicationAck);
    }

    public ReplicationMasterFile(IFile iFile, String[] stringArray, boolean bl2) {
        this(null, iFile, -1, stringArray, bl2);
    }

    private ReplicationMasterFile(ReplicationMasterStorageImpl replicationMasterStorageImpl, IFile iFile, int n2, String[] stringArray, boolean bl2) {
        this.storage = replicationMasterStorageImpl;
        this.file = iFile;
        this.hosts = stringArray;
        this.ack = bl2;
        this.port = n2;
        this.mutex = new Object();
        this.sockets = new Socket[stringArray.length];
        this.out = new OutputStream[stringArray.length];
        if (bl2) {
            this.in = new InputStream[stringArray.length];
            this.rcBuf = new byte[1];
        }
        this.txBuf = new byte[4104];
        this.nHosts = 0;
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            this.connect(i2);
        }
        if (n2 >= 0) {
            try {
                this.listenSocket = new ServerSocket(n2);
            }
            catch (IOException iOException) {
                throw new StorageError(28);
            }
            this.listening = true;
            this.listenThread = new Thread(this);
            this.listenThread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (true) {
            Socket socket = null;
            try {
                socket = this.listenSocket.accept();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            Object object = this.mutex;
            synchronized (object) {
                if (!this.listening) {
                    return;
                }
            }
            if (socket == null) continue;
            try {
                socket.setSoLinger(true, LINGER_TIME);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                socket.setTcpNoDelay(true);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.addConnection(socket);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addConnection(Socket socket) {
        OutputStream outputStream = null;
        InputStream inputStream = null;
        try {
            outputStream = socket.getOutputStream();
            if (this.ack) {
                inputStream = socket.getInputStream();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return;
        }
        Object object = this.mutex;
        synchronized (object) {
            Closeable[] closeableArray;
            int n2 = this.hosts.length;
            String[] stringArray = new String[n2 + 1];
            System.arraycopy(this.hosts, 0, stringArray, 0, n2);
            stringArray[n2] = socket.getRemoteSocketAddress().toString();
            this.hosts = stringArray;
            OutputStream[] outputStreamArray = new OutputStream[n2 + 1];
            System.arraycopy(this.out, 0, outputStreamArray, 0, n2);
            outputStreamArray[n2] = outputStream;
            this.out = outputStreamArray;
            if (this.ack) {
                closeableArray = new InputStream[n2 + 1];
                System.arraycopy(this.in, 0, closeableArray, 0, n2);
                closeableArray[n2] = inputStream;
                this.in = closeableArray;
            }
            closeableArray = new Socket[n2 + 1];
            System.arraycopy(this.sockets, 0, closeableArray, 0, n2);
            closeableArray[n2] = socket;
            this.sockets = closeableArray;
            ++this.nHosts;
            SynchronizeThread synchronizeThread = new SynchronizeThread(n2);
            synchronizeThread.start();
        }
    }

    public int getNumberOfAvailableHosts() {
        return this.nHosts;
    }

    protected void connect(int n2) {
        String string = this.hosts[n2];
        int n3 = string.indexOf(58);
        int n4 = Integer.parseInt(string.substring(n3 + 1));
        string = string.substring(0, n3);
        Socket socket = null;
        try {
            int n5 = this.storage != null ? this.storage.slaveConnectionTimeout : MAX_CONNECT_ATTEMPTS;
            for (int i2 = 0; i2 < n5; ++i2) {
                try {
                    socket = new Socket(InetAddress.getByName(string), n4);
                    if (socket == null) {
                        Thread.sleep(CONNECTION_TIMEOUT);
                        continue;
                    }
                    break;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (socket != null) {
            try {
                try {
                    socket.setSoLinger(true, LINGER_TIME);
                }
                catch (NoSuchMethodError noSuchMethodError) {
                    // empty catch block
                }
                try {
                    socket.setTcpNoDelay(true);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.sockets[n2] = socket;
                this.out[n2] = socket.getOutputStream();
                if (this.ack) {
                    this.in[n2] = socket.getInputStream();
                }
                ++this.nHosts;
            }
            catch (IOException iOException) {
                this.handleError(this.hosts[n2]);
                this.sockets[n2] = null;
                this.out[n2] = null;
            }
        }
    }

    public boolean handleError(String string) {
        System.err.println("Failed to establish connection with host " + string);
        return this.storage != null && this.storage.listener != null ? this.storage.listener.replicationError(string) : false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(long l2, byte[] byArray) {
        Object object = this.mutex;
        synchronized (object) {
            block8: for (int i2 = 0; i2 < this.out.length; ++i2) {
                while (this.out[i2] != null) {
                    try {
                        Socket socket = this.sockets[i2];
                        synchronized (socket) {
                            Bytes.pack8(this.txBuf, 0, l2);
                            System.arraycopy(byArray, 0, this.txBuf, 8, byArray.length);
                            this.out[i2].write(this.txBuf);
                            if (!this.ack || l2 != 0L || this.in[i2].read(this.rcBuf) == 1) {
                                continue block8;
                            }
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    this.out[i2] = null;
                    this.sockets[i2] = null;
                    --this.nHosts;
                    if (!this.handleError(this.hosts[i2])) continue block8;
                    this.connect(i2);
                }
            }
        }
        this.file.write(l2, byArray);
    }

    public int read(long l2, byte[] byArray) {
        return this.file.read(l2, byArray);
    }

    public void sync() {
        this.file.sync();
    }

    public boolean tryLock(boolean bl2) {
        return this.file.tryLock(bl2);
    }

    public void lock(boolean bl2) {
        this.file.lock(bl2);
    }

    public void unlock() {
        this.file.unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (this.listenThread != null) {
            Object object = this.mutex;
            synchronized (object) {
                this.listening = false;
            }
            try {
                object = new Socket("localhost", this.port);
                ((Socket)object).close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                this.listenThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            try {
                this.listenSocket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.file.close();
        Bytes.pack8(this.txBuf, 0, -1L);
        for (int i2 = 0; i2 < this.out.length; ++i2) {
            if (this.sockets[i2] == null) continue;
            try {
                this.out[i2].write(this.txBuf);
                this.out[i2].close();
                if (this.in != null) {
                    this.in[i2].close();
                }
                this.sockets[i2].close();
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public long length() {
        return this.file.length();
    }

    class SynchronizeThread
    extends Thread {
        int i;

        SynchronizeThread(int n2) {
            this.i = n2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Socket socket;
            long l2 = ReplicationMasterFile.this.storage.getDatabaseSize();
            OutputStream outputStream = null;
            InputStream inputStream = null;
            Object object = ReplicationMasterFile.this.mutex;
            synchronized (object) {
                socket = ReplicationMasterFile.this.sockets[this.i];
                if (socket == null) {
                    return;
                }
                outputStream = ReplicationMasterFile.this.out[this.i];
                if (ReplicationMasterFile.this.ack) {
                    inputStream = ReplicationMasterFile.this.in[this.i];
                }
            }
            for (long i2 = 0L; i2 < l2; i2 += 4096L) {
                Object object2;
                Page page = ReplicationMasterFile.this.storage.pool.getPage(i2);
                try {
                    object2 = socket;
                    synchronized (object2) {
                        Bytes.pack8(ReplicationMasterFile.this.txBuf, 0, i2);
                        System.arraycopy(page.data, 0, ReplicationMasterFile.this.txBuf, 8, 4096);
                        ReplicationMasterFile.this.storage.pool.unfix(page);
                        outputStream.write(ReplicationMasterFile.this.txBuf);
                        if (!ReplicationMasterFile.this.ack || i2 != 0L || inputStream.read(ReplicationMasterFile.this.rcBuf) == 1) {
                            continue;
                        }
                    }
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                object2 = ReplicationMasterFile.this.mutex;
                synchronized (object2) {
                    if (ReplicationMasterFile.this.sockets[this.i] != null) {
                        ReplicationMasterFile.this.handleError(ReplicationMasterFile.this.hosts[this.i]);
                        ReplicationMasterFile.this.sockets[this.i] = null;
                        ReplicationMasterFile.this.out[this.i] = null;
                        --ReplicationMasterFile.this.nHosts;
                    }
                    return;
                }
            }
            Socket socket2 = socket;
            synchronized (socket2) {
                Bytes.pack8(ReplicationMasterFile.this.txBuf, 0, -2L);
                try {
                    outputStream.write(ReplicationMasterFile.this.txBuf);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
    }
}

