/*
 * Decompiled with CFR 0.152.
 */
package org.garret.perst.impl;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileLock;
import org.garret.perst.IFile;
import org.garret.perst.StorageError;

public class OSFile
implements IFile {
    protected RandomAccessFile file;
    protected boolean noFlush;
    private FileLock lck;

    public void write(long l2, byte[] byArray) {
        try {
            this.file.seek(l2);
            this.file.write(byArray, 0, byArray.length);
        }
        catch (IOException iOException) {
            throw new StorageError(3, iOException);
        }
    }

    public int read(long l2, byte[] byArray) {
        try {
            this.file.seek(l2);
            return this.file.read(byArray, 0, byArray.length);
        }
        catch (IOException iOException) {
            throw new StorageError(3, iOException);
        }
    }

    public void sync() {
        if (!this.noFlush) {
            try {
                this.file.getFD().sync();
            }
            catch (IOException iOException) {
                throw new StorageError(3, iOException);
            }
        }
    }

    public void close() {
        try {
            this.file.close();
        }
        catch (IOException iOException) {
            throw new StorageError(3, iOException);
        }
    }

    public boolean tryLock(boolean bl2) {
        try {
            this.lck = this.file.getChannel().tryLock(0L, Long.MAX_VALUE, bl2);
            return this.lck != null;
        }
        catch (IOException iOException) {
            return true;
        }
    }

    public void lock(boolean bl2) {
        try {
            this.lck = this.file.getChannel().lock(0L, Long.MAX_VALUE, bl2);
        }
        catch (IOException iOException) {
            throw new StorageError(21, iOException);
        }
    }

    public void unlock() {
        try {
            this.lck.release();
        }
        catch (IOException iOException) {
            throw new StorageError(21, iOException);
        }
    }

    public OSFile(String string, boolean bl2, boolean bl3) {
        this.noFlush = bl3;
        try {
            this.file = new RandomAccessFile(string, bl2 ? "r" : "rw");
        }
        catch (IOException iOException) {
            throw new StorageError(3, iOException);
        }
    }

    public long length() {
        try {
            return this.file.length();
        }
        catch (IOException iOException) {
            return -1L;
        }
    }
}

