/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.tools.cluster.view;

import com.j_spaces.core.cluster.ClusterPolicy;
import com.j_spaces.kernel.JSpaceUtilities;
import com.j_spaces.obf.li;
import com.j_spaces.tools.IRefreshable;
import com.j_spaces.tools.cluster.ClusterMemberInfo;
import com.j_spaces.tools.cluster.EditCluster;
import com.j_spaces.tools.cluster.FileFilterExt;
import com.j_spaces.tools.cluster.GroupInfo;
import com.j_spaces.tools.cluster.view.ClusterPanel;
import com.j_spaces.tools.cluster.view.ClusterTree;
import com.j_spaces.tools.cluster.view.ClusterViewMenuBar;
import com.j_spaces.tools.cluster.view.GroupPanel;
import com.j_spaces.tools.cluster.view.ServiceManagerImpl;
import com.j_spaces.tools.spacebrowser.SpaceBrowser;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Toolkit;
import java.io.File;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.filechooser.FileFilter;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import net.jini.core.lookup.ServiceID;
import org.w3c.dom.Document;

public class ClusterViewDlg
extends JFrame {
    private String m_clusterName;
    private GroupInfo[] m_groupsInfo;
    private ClusterMemberInfo[] m_membersInfo;
    private ClusterPanel m_clusterPanel;
    private JPanel m_panCenter;
    private ClusterViewMenuBar m_menuBar;
    private SpaceBrowser spaceBrowser;
    private ServiceManagerImpl m_serviceManager;
    private JFileChooser m_fileChooser;
    private EditCluster curEditCluster;
    private Map _clusterWrappersMap;
    private CardLayout centerPanelCardLayout;
    private GroupPanel groupPanel;
    private static final int CLUSTERS_MEMBER_COUNT_SWITCH_ZOOM = 5;
    public static final String CLUSTER_MEMBERS_VIEW = "CLUSTER_MEMEBER_VIEW";
    public static final String CLUSTER_ROOT_VIEW = "CLUSTER_ROOT_VIEW";
    private static Logger _logger = Logger.getLogger("com.gigaspaces.ui.cluster.view");

    public ClusterViewDlg(SpaceBrowser spaceBrowser) {
        block2: {
            this.centerPanelCardLayout = new CardLayout();
            this.groupPanel = null;
            try {
                this.spaceBrowser = spaceBrowser;
                this.m_serviceManager = new ServiceManagerImpl();
                this.m_menuBar = new ClusterViewMenuBar(this);
                this._clusterWrappersMap = new HashMap();
                JSpaceUtilities.setLocationRelativeTo(this, spaceBrowser);
                this.init();
                IRefreshable[] iRefreshableArray = new IRefreshable[]{this.groupPanel.getGraphPanel()};
                this.m_serviceManager.setRefreshModules(iRefreshableArray);
            }
            catch (Exception exception) {
                if (!_logger.isLoggable(Level.FINE)) break block2;
                _logger.log(Level.FINE, exception.toString(), exception);
            }
        }
    }

    private void init() {
        this.m_clusterPanel = ClusterPanel.getInstance();
        this.m_menuBar.selectDefaultSpeedMenu();
        this.m_panCenter = new JPanel(this.centerPanelCardLayout);
        this.groupPanel = new GroupPanel(this);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this.groupPanel, "Center");
        this.m_panCenter.add(CLUSTER_MEMBERS_VIEW, jPanel);
        this.m_panCenter.add(CLUSTER_ROOT_VIEW, this.m_clusterPanel);
    }

    public void clearCurrentCluster() {
        this.curEditCluster = null;
        this.m_clusterPanel.clearCurGroupInfo();
        this.groupPanel.clearCurGroupInfo();
        this.m_serviceManager.clearCurMembersInfo();
    }

    public EditCluster getCurEditCluster() {
        return this.curEditCluster;
    }

    public JMenu getMenu() {
        return this.m_menuBar.getMenu();
    }

    public SpaceBrowser getBrowser() {
        return this.spaceBrowser;
    }

    public JPanel getClusterPanel() {
        return this.m_panCenter;
    }

    public void setClusterView(EditCluster editCluster, boolean bl2, boolean bl3) {
        try {
            boolean bl4;
            boolean bl5 = bl4 = editCluster == null || this.curEditCluster != editCluster;
            if (bl4 || bl2) {
                this.curEditCluster = editCluster;
                this.m_clusterName = editCluster.getClusterName();
                this.m_groupsInfo = editCluster.getClusterGroups();
                this.m_membersInfo = editCluster.getClusterMembers();
                if (bl2) {
                    this.m_clusterPanel.setClusterPanel(this, this.m_groupsInfo, this.m_membersInfo);
                    this.groupPanel.setPanelEnabled(false);
                }
                ClusterTree clusterTree = null;
                ClusterWrapper clusterWrapper = (ClusterWrapper)this._clusterWrappersMap.get(this.m_clusterName);
                if (clusterWrapper == null) {
                    clusterTree = new ClusterTree(this, this.m_clusterName, this.m_groupsInfo, this.spaceBrowser);
                    this.putCluster(editCluster, clusterTree);
                } else {
                    clusterTree = this.getClusterTree(this.m_clusterName);
                }
                this.m_serviceManager.setClusterTreeReference(clusterTree);
                if (bl4) {
                    this.m_serviceManager.setStaticClusterMembers(this.m_membersInfo);
                    this.m_serviceManager.paused(false, false);
                }
            }
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this.spaceBrowser, exception.toString(), "Error", 0);
            this.spaceBrowser.debug(exception);
        }
    }

    public void increaseZoom() {
        this.groupPanel.increaseZoom();
    }

    public void decreaseZoom() {
        this.groupPanel.decreaseZoom();
    }

    public String toString() {
        return this.m_clusterName;
    }

    public String getClusterName() {
        return this.m_clusterName;
    }

    public GroupInfo[] getAllGroups() {
        return this.m_groupsInfo;
    }

    public ClusterMemberInfo[] getAllMembers() {
        return this.m_membersInfo;
    }

    public ServiceManagerImpl getServiceManager() {
        return this.m_serviceManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void selectClusterFile() {
        Object object;
        File file = null;
        if (this.spaceBrowser != null) {
            file = this.spaceBrowser.chooseFile();
        } else {
            if (this.m_fileChooser == null) {
                object = new FileFilterExt("xml", "Cluster XML file");
                this.m_fileChooser = new JFileChooser(li.a() + File.separatorChar + "config");
                this.m_fileChooser.addChoosableFileFilter((FileFilter)object);
            }
            if (this.m_fileChooser.showOpenDialog(this.spaceBrowser) != 0) {
                return;
            }
            file = this.m_fileChooser.getSelectedFile();
        }
        if (file == null) {
            return;
        }
        object = file.getPath();
        if (!((String)object).endsWith(".xml")) {
            object = (String)object + ".xml";
        }
        try {
            this.spaceBrowser.setCursor(Cursor.getPredefinedCursor(3));
            EditCluster editCluster = new EditCluster((String)object);
            DefaultMutableTreeNode defaultMutableTreeNode = this.setClusterToBrowser(editCluster, true);
            String string = editCluster.getClusterName();
            this.getClusterTree(string).showHighLevelNode(defaultMutableTreeNode, null);
        }
        catch (Exception exception) {
            SpaceBrowser.expDialog.showException("cluster configuration parsing", exception);
        }
        finally {
            this.spaceBrowser.setCursor(new Cursor(0));
        }
    }

    private DefaultMutableTreeNode setClusterToBrowser(EditCluster editCluster, boolean bl2) {
        this.setClusterView(editCluster, bl2, false);
        String string = editCluster.getClusterName();
        ClusterTree clusterTree = this.getClusterTree(string);
        JTree jTree = clusterTree.getTree();
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)jTree.getModel();
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)defaultTreeModel.getRoot();
        this.spaceBrowser.addClusterTree(clusterTree, defaultMutableTreeNode, editCluster, this, bl2);
        if (bl2) {
            this.spaceBrowser.showClusterPanel(editCluster, false);
        }
        return defaultMutableTreeNode;
    }

    public void setSpaceID(String string, ServiceID serviceID, String string2) {
        ClusterWrapper clusterWrapper = (ClusterWrapper)this._clusterWrappersMap.get(string);
        if (clusterWrapper != null) {
            EditCluster editCluster = clusterWrapper.getEditCluster();
            editCluster.setSpaceIDToMember(serviceID, string2);
        }
        this.groupPanel.setSpaceIDToNode(serviceID, string2);
    }

    public void addCluster(String string, InputStream inputStream, String string2, boolean bl2, ClusterPolicy clusterPolicy) throws Exception {
        if (this.containsCluster(string)) {
            return;
        }
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.parse(inputStream);
        this.setClusterToBrowser(new EditCluster(string2, document, clusterPolicy), bl2);
    }

    public void putCluster(EditCluster editCluster, ClusterTree clusterTree) {
        String string = editCluster.getClusterName();
        if (!this._clusterWrappersMap.containsKey(string)) {
            this._clusterWrappersMap.put(string, new ClusterWrapper(clusterTree, editCluster));
        }
    }

    public void removeCluster(String string) {
        this._clusterWrappersMap.remove(string);
        this.curEditCluster = null;
    }

    public boolean containsCluster(String string) {
        return this._clusterWrappersMap.containsKey(string);
    }

    public ClusterTree getClusterTree(String string) {
        return ((ClusterWrapper)this._clusterWrappersMap.get(string)).getClusterTree();
    }

    public void setGroupInfo(GroupInfo groupInfo) {
        this.groupPanel.setGroupInfo(groupInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setClusterTreeNode(String string) {
        try {
            Object object;
            DefaultMutableTreeNode defaultMutableTreeNode;
            Object[] objectArray;
            String string2;
            boolean bl2;
            this.spaceBrowser.setCursor(Cursor.getPredefinedCursor(3));
            Toolkit.getDefaultToolkit().sync();
            JTree jTree = this.spaceBrowser.getContainerTree();
            int n2 = 0;
            String string3 = "";
            TreePath treePath = null;
            boolean bl3 = false;
            Object object2 = null;
            while (!bl3) {
                treePath = jTree.getPathForRow(n2);
                string3 = treePath.getLastPathComponent().toString();
                object2 = treePath.getPathComponent(1);
                if (string3.equals(this.m_clusterName) && object2.toString().equals("Clusters")) {
                    bl3 = true;
                    continue;
                }
                ++n2;
            }
            jTree.expandPath(treePath);
            while (jTree.getPathForRow(n2) != null && !(bl2 = (string2 = JSpaceUtilities.createClusterGuiId(objectArray = (defaultMutableTreeNode = (DefaultMutableTreeNode)(object = (treePath = jTree.getPathForRow(n2)).getLastPathComponent())).getPath())).equals(string))) {
                ++n2;
            }
            object = jTree.getPathForRow(n2);
            if (object != null) {
                jTree.expandPath((TreePath)object);
                jTree.setSelectionPath((TreePath)object);
                if (!((DefaultMutableTreeNode)((TreePath)object).getLastPathComponent()).isLeaf()) {
                    this.spaceBrowser.doNodeSelected((TreePath)object);
                }
            }
        }
        catch (Exception exception) {
            this.spaceBrowser.debug(exception);
        }
        finally {
            this.spaceBrowser.setCursor(new Cursor(0));
        }
    }

    public GroupPanel getGroupPanel() {
        return this.groupPanel;
    }

    public void stopAllGraphTreads() {
        this.m_clusterPanel.getGraphPanel().stop();
        this.groupPanel.getGraphPanel().stop();
    }

    public void startGraphTread(String string) {
        this.stopAllGraphTreads();
        this.groupPanel.getGraphPanel().start();
        this.m_clusterPanel.getGraphPanel().start();
    }

    public boolean isExistMember(String string) {
        for (int i2 = 0; i2 < this.m_membersInfo.length; ++i2) {
            if (!this.m_membersInfo[i2].memberName.equals(string)) continue;
            return true;
        }
        return false;
    }

    public synchronized EditCluster updateDynamicClusterMembers(String string, List list) {
        ClusterWrapper clusterWrapper = (ClusterWrapper)this._clusterWrappersMap.get(string);
        ClusterTree clusterTree = clusterWrapper.getClusterTree();
        if (clusterTree.updateTree(list)) {
            EditCluster editCluster = clusterWrapper.getEditCluster();
            editCluster.updateClusterActiveMembers(list);
            return editCluster;
        }
        return null;
    }

    private class ClusterWrapper {
        private ClusterTree _clusterTree;
        private EditCluster _editCluster;

        public ClusterWrapper(ClusterTree clusterTree, EditCluster editCluster) {
            this._clusterTree = clusterTree;
            this._editCluster = editCluster;
        }

        public EditCluster getEditCluster() {
            return this._editCluster;
        }

        public void setEditCluster(EditCluster editCluster) {
            this._editCluster = editCluster;
        }

        public ClusterTree getClusterTree() {
            return this._clusterTree;
        }
    }
}

