/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.jms;

import com.j_spaces.core.IJSpace;
import com.j_spaces.jms.GSConnectionFactoryImpl;
import com.j_spaces.jms.GSConnectionMetaDataImpl;
import com.j_spaces.jms.GSSessionImpl;
import com.j_spaces.jms.utils.StringsUtils;
import java.rmi.RemoteException;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.Connection;
import javax.jms.ConnectionConsumer;
import javax.jms.ConnectionMetaData;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.IllegalStateException;
import javax.jms.InvalidClientIDException;
import javax.jms.JMSException;
import javax.jms.ServerSessionPool;
import javax.jms.Session;
import javax.jms.Topic;
import net.jini.core.lease.LeaseDeniedException;
import net.jini.core.transaction.Transaction;
import net.jini.core.transaction.TransactionFactory;
import net.jini.core.transaction.server.ServerTransaction;

public abstract class GSConnectionImpl
implements Connection {
    private String m_clientID;
    private ExceptionListener errorHandler;
    public boolean closing = false;
    public boolean closed = false;
    public boolean stopped = true;
    private volatile int sessionsC = 0;
    private String cnxKey;
    private Vector sessions;
    private GSConnectionMetaDataImpl m_metaData;
    public GSConnectionFactoryImpl connFacParent;
    private boolean m_modified = false;
    private boolean m_clientIdSet = false;
    private int m_compressionMinSize;
    private static Logger _logger = Logger.getLogger("com.gigaspaces.jms");

    public GSConnectionImpl(GSConnectionFactoryImpl gSConnectionFactoryImpl) throws JMSException {
        this.connFacParent = gSConnectionFactoryImpl;
        this.sessions = new Vector();
        this.m_compressionMinSize = this.connFacParent.getAdmin().getCompressionMinSize();
    }

    public Session createSession(boolean bl2, int n2) throws JMSException {
        throw new JMSException("Forbidden call to GSConnectionImpl.createSession(). You should Call its subclass");
    }

    public String getClientID() throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("Forbidden call on a closed connection.");
        }
        this.setModified();
        return this.m_clientID;
    }

    public void setClientID(String string) throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("Forbidden call on a closed connection.");
        }
        boolean bl2 = this.isValidExtClientID(string);
        if (this.m_clientIdSet || bl2 && !this.isValidExtClientID(this.m_clientID)) {
            throw new IllegalStateException("The client id has already been set");
        }
        if (!bl2) {
            throw new InvalidClientIDException("Attempt to set the invalid client id:  " + string);
        }
        if (this.m_modified) {
            throw new IllegalStateException("The client identifier must be set before any other operation is performed");
        }
        this.m_clientID = string;
        this.m_clientIdSet = true;
    }

    private boolean isValidExtClientID(String string) {
        return !string.startsWith("tc_") && !string.startsWith("qc_") && !string.startsWith("xatc_") && !string.startsWith("xaqc_") && !StringsUtils.isEmpty(string);
    }

    public void updateClientIDInternally(String string) throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("Forbidden call on a closed connection.");
        }
        this.m_clientID = string;
    }

    public void setModified() {
        this.m_modified = true;
    }

    public ConnectionMetaData getMetaData() throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("Forbidden call on a closed connection.");
        }
        if (this.m_metaData == null) {
            this.m_metaData = new GSConnectionMetaDataImpl();
        }
        this.setModified();
        return this.m_metaData;
    }

    public ExceptionListener getExceptionListener() throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("Forbidden call on a closed connection.");
        }
        this.setModified();
        return this.errorHandler;
    }

    public void setExceptionListener(ExceptionListener exceptionListener) throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("Forbidden call on a closed connection.");
        }
        this.setModified();
        this.errorHandler = exceptionListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSession(GSSessionImpl gSSessionImpl) {
        GSConnectionImpl gSConnectionImpl = this;
        synchronized (gSConnectionImpl) {
            this.sessions.addElement(gSSessionImpl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSession(GSSessionImpl gSSessionImpl) {
        GSConnectionImpl gSConnectionImpl = this;
        synchronized (gSConnectionImpl) {
            this.sessions.remove(gSSessionImpl);
            gSSessionImpl = null;
        }
    }

    public void onException(JMSException jMSException) throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("Forbidden call on a closed connection.");
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("calling ExceptionListener.onException()");
        }
        if (this.errorHandler != null) {
            this.errorHandler.onException(jMSException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws JMSException {
        GSConnectionImpl gSConnectionImpl = this;
        synchronized (gSConnectionImpl) {
            this.ensureOpen();
            this.setModified();
            if (this.stopped) {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.fine("GSConnectionImpl.start()  starting connection: " + this.toString());
                }
                for (int i2 = 0; i2 < this.sessions.size(); ++i2) {
                    GSSessionImpl gSSessionImpl = (GSSessionImpl)this.sessions.get(i2);
                    gSSessionImpl.c();
                }
                this.stopped = false;
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.fine("GSConnectionImpl.start()  connection was started: " + this.toString());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws JMSException {
        GSConnectionImpl gSConnectionImpl = this;
        synchronized (gSConnectionImpl) {
            this.ensureOpen();
            this.setModified();
            if (!this.stopped) {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.fine("GSConnectionImpl.stop()  stopping connection: " + this.toString());
                }
                for (int i2 = 0; i2 < this.sessions.size(); ++i2) {
                    GSSessionImpl gSSessionImpl = (GSSessionImpl)this.sessions.get(i2);
                    gSSessionImpl.b();
                }
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.fine("GSConnectionImpl.stop()  connection was stopped: " + this.getCnxKey());
                }
                this.stopped = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws JMSException {
        GSConnectionImpl gSConnectionImpl = this;
        synchronized (gSConnectionImpl) {
            if (!this.closed) {
                this.closing = true;
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.fine("GSConnectionImpl.close()  closing connection: " + this.toString());
                }
                this.stop();
                while (!this.sessions.isEmpty()) {
                    GSSessionImpl gSSessionImpl = (GSSessionImpl)this.sessions.elementAt(0);
                    try {
                        gSSessionImpl.close();
                    }
                    catch (JMSException jMSException) {}
                }
                this.getConnFacParent().removeConnection(this);
                this.closed = true;
                this.closing = false;
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.fine("GSConnectionImpl.close() connection was closed: " + this.toString());
                }
            }
        }
    }

    public boolean isStopped() {
        return this.stopped;
    }

    public void ensureOpen() throws IllegalStateException {
        if (this.closed) {
            throw new IllegalStateException("Forbidden call on a closed connection.");
        }
    }

    public ConnectionConsumer createConnectionConsumer(Destination destination, String string, ServerSessionPool serverSessionPool, int n2) throws JMSException {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("GSConnectionImpl.createConnectionConsumer() method is not implemented. ");
        }
        return null;
    }

    public ConnectionConsumer createDurableConnectionConsumer(Topic topic, String string, String string2, ServerSessionPool serverSessionPool, int n2) throws JMSException {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("GSConnectionImpl.createDurableConnectionConsumer() method is not implemented. ");
        }
        return null;
    }

    public String nextSessionId() {
        if (this.sessionsC == Integer.MAX_VALUE) {
            this.sessionsC = 0;
        }
        ++this.sessionsC;
        return this.cnxKey + "_sess_" + this.sessionsC;
    }

    public String getFixedSessionId() {
        if (this.sessionsC == Integer.MAX_VALUE) {
            this.sessionsC = 0;
        }
        ++this.sessionsC;
        return this.cnxKey + "_sess_" + this.sessionsC;
    }

    public IJSpace getSpace() {
        return this.connFacParent.getSpace();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Transaction getTransaction(long l2) throws JMSException {
        Transaction transaction;
        GSConnectionImpl gSConnectionImpl = this;
        synchronized (gSConnectionImpl) {
            try {
                Transaction.Created created = TransactionFactory.create(this.connFacParent.getLocalTransactionManager(), l2);
                transaction = created.transaction;
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.fine("GSConnectionImpl.getTransaction() leaseTime: " + l2 + "  |  TX.id: " + ((ServerTransaction)transaction).id + "|  TX.mgr: " + ((ServerTransaction)transaction).mgr.toString());
                }
            }
            catch (LeaseDeniedException leaseDeniedException) {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, "Exception inside GSConnectionImpl.getTransaction() : " + leaseDeniedException.toString(), leaseDeniedException);
                }
                JMSException jMSException = new JMSException("LeaseDeniedException : " + leaseDeniedException.getMessage());
                jMSException.setLinkedException(leaseDeniedException);
                throw jMSException;
            }
            catch (RemoteException remoteException) {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, "Exception inside GSConnectionImpl.getTransaction() : " + remoteException.toString(), remoteException);
                }
                JMSException jMSException = new JMSException("RemoteException : " + remoteException.getMessage());
                jMSException.setLinkedException(remoteException);
                throw jMSException;
            }
        }
        return transaction;
    }

    public String getCnxKey() {
        return this.cnxKey;
    }

    public void setCnxKey(String string) {
        this.cnxKey = string;
    }

    public String toString() {
        return "GSConnectionImpl || client  ID: " + this.m_clientID + " || connection ID: " + this.getCnxKey();
    }

    public GSConnectionFactoryImpl getConnFacParent() {
        return this.connFacParent;
    }

    public int getCompressionMinSize() {
        return this.m_compressionMinSize;
    }
}

