/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.core.cluster.sync_replication;

import java.io.Serializable;
import java.lang.reflect.Field;

public class SyncReplPolicy
implements Serializable {
    private static final long serialVersionUID = 1L;
    private long asyncIntervalToCheck = 4000L;
    public static final String DEFAULT_IP_GROUP = "224.0.0.1";
    public static final int DEFAULT_PORT = 28672;
    public static final int DEFAULT_MULTICAST_TTL = 4;
    public static final long DEFAULT_TODO_QUEUE_TIMEOUT = 2000L;
    public static final long DEFAULT_RESPONSE_TIMEOUT = 2600L;
    public static final long DEFAULT_ACK_INTERVAL = 1000L;
    public static final long DEFAULT_ASYNC_ONE_WAY_HEARTBEAT_INTERVAL = 2000L;
    public static final int DEFAULT_UNICAST_MIN_WORK_THREADS = 4;
    public static final int DEFAULT_UNICAST_MAX_WORK_THREADS = 64;
    public static final int DEFAULT_MULTICAST_MIN_WORK_THREADS = 4;
    public static final int DEFAULT_MULTICAST_MAX_WORK_THREADS = 16;
    public String nodeName;
    private long responseTimeout = 2600L;
    private long ackIntervalTime = 1000L;
    private String multicastIpGroup = "224.0.0.1";
    private int multicastPort = 28672;
    private int ttl = 4;
    private int unicastMinThreadPoolSize = 4;
    private int unicastMaxThreadPoolSize = 64;
    private int multicastMinThreadPoolSize = 4;
    private int multicastMaxThreadPoolSize = 16;
    private long todoQueueTimeout = 2000L;
    private long asyncOneWayHeartBeatInterval = 2000L;
    private boolean isAdaptiveMulticast = true;
    private boolean isHoldTxnLockUntilSyncReplication = false;

    public boolean isHoldTxnLockUntilSyncReplication() {
        return this.isHoldTxnLockUntilSyncReplication;
    }

    public void setHoldTxnLockUntilSyncReplication(boolean bl2) {
        this.isHoldTxnLockUntilSyncReplication = bl2;
    }

    public void setAsyncOneWayHeartBeatInterval(long l2) {
        this.asyncOneWayHeartBeatInterval = l2;
    }

    public long getAsyncOneWayHeartBeatInterval() {
        return this.asyncOneWayHeartBeatInterval;
    }

    public long getAsyncIntervalToCheck() {
        return this.asyncIntervalToCheck;
    }

    public SyncReplPolicy(String string) {
        this.nodeName = string;
    }

    public String getMulticastIpGroup() {
        return this.multicastIpGroup;
    }

    public int getMulticastPort() {
        return this.multicastPort;
    }

    public int getMulticastTTL() {
        return this.ttl;
    }

    public void setMulticastTTL(int n2) {
        this.ttl = n2;
    }

    public void setNodeName(String string) {
        this.nodeName = string;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public int getMulticastMaxThreadPoolSize() {
        return this.multicastMaxThreadPoolSize;
    }

    public void setMulticastMaxThreadPoolSize(int n2) {
        this.multicastMaxThreadPoolSize = n2;
    }

    public int getMulticastMinThreadPoolSize() {
        return this.multicastMinThreadPoolSize;
    }

    public void setMulticastMinThreadPoolSize(int n2) {
        this.multicastMinThreadPoolSize = n2;
    }

    public long getResponseTimeout() {
        return this.responseTimeout;
    }

    public long getTodoQueueTimeout() {
        return this.todoQueueTimeout;
    }

    public void setTodoQueueTimeout(long l2) {
        this.todoQueueTimeout = l2;
        this.responseTimeout = l2 + (long)((double)l2 * 0.3);
        this.ackIntervalTime = l2 / 3L;
        this.asyncIntervalToCheck = l2 * 3L;
        this.asyncOneWayHeartBeatInterval = l2;
    }

    public void setAdaptiveMulticast(boolean bl2) {
        this.isAdaptiveMulticast = bl2;
    }

    public boolean isAdaptiveMulticast() {
        return this.isAdaptiveMulticast;
    }

    public int getUnicastMaxThreadPoolSize() {
        return this.unicastMaxThreadPoolSize;
    }

    public void setUnicastMaxThreadPoolSize(int n2) {
        this.unicastMaxThreadPoolSize = n2;
    }

    public int getUnicastMinThreadPoolSize() {
        return this.unicastMinThreadPoolSize;
    }

    public void setUnicastMinThreadPoolSize(int n2) {
        this.unicastMinThreadPoolSize = n2;
    }

    public long getAckIntervalTime() {
        return this.ackIntervalTime;
    }

    public void setMulticastIpGroup(String string) {
        this.multicastIpGroup = string;
    }

    public void setMulticastPort(int n2) {
        this.multicastPort = n2;
    }

    public String getDump() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\n------------- SYNC-REPL DUMP [" + this.nodeName + "] ------------------");
        try {
            Field[] fieldArray = this.getClass().getDeclaredFields();
            for (int i2 = 0; i2 < fieldArray.length; ++i2) {
                stringBuffer.append("\n" + fieldArray[i2].getName() + " : " + fieldArray[i2].get(this));
            }
        }
        catch (Exception exception) {
            return exception.toString();
        }
        stringBuffer.append("\n------------- SYNC-REPL DUMP [" + this.nodeName + "] ------------------");
        return stringBuffer.toString();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\n------------Sync Replication Policy---------\n");
        stringBuffer.append("Async Interval To Check -\t" + this.asyncIntervalToCheck + "\n");
        stringBuffer.append("Node Name -\t" + this.nodeName + "\n");
        stringBuffer.append("Response Timeout -\t" + this.responseTimeout + "\n");
        stringBuffer.append("ack Interval Time -\t" + this.ackIntervalTime + "\n");
        stringBuffer.append("Multicast IP Group -\t" + this.multicastIpGroup + "\n");
        stringBuffer.append("Multicast Port -\t" + this.multicastPort + "\n");
        stringBuffer.append("ttl -\t" + this.ttl + "\n");
        stringBuffer.append("Unicast Min Thread Pool Size -\t" + this.unicastMinThreadPoolSize + "\n");
        stringBuffer.append("Unicast Max Thread Pool Size -\t" + this.unicastMaxThreadPoolSize + "\n");
        stringBuffer.append("Multicast Min Thread Pool Size -\t" + this.multicastMinThreadPoolSize + "\n");
        stringBuffer.append("Multicast Max Thread Pool Size -\t" + this.multicastMaxThreadPoolSize + "\n");
        stringBuffer.append("Todo Queue Timeout -\t" + this.todoQueueTimeout + "\n");
        stringBuffer.append("Async One Way Heart Beat Interval -\t" + this.asyncOneWayHeartBeatInterval + "\n");
        stringBuffer.append("Is Adaptive Multicast -\t" + this.isAdaptiveMulticast + "\n");
        stringBuffer.append("Is Hold Txn Lock Until Sync Replication -\t" + this.isHoldTxnLockUntilSyncReplication + "\n");
        return stringBuffer.toString();
    }
}

