/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.admin.cli;

import com.gigaspaces.admin.cli.GS;
import com.j_spaces.core.IJSpace;
import com.j_spaces.core.NoSuchNameException;
import com.j_spaces.core.admin.IRemoteJSpaceAdmin;
import com.j_spaces.core.client.FinderException;
import com.j_spaces.core.client.IDirectSpaceProxy;
import com.j_spaces.core.client.SpaceFinder;
import com.j_spaces.core.client.SpaceURL;
import com.j_spaces.core.client.SpaceURLParser;
import com.j_spaces.core.cluster.ClusterPolicy;
import com.j_spaces.core.cluster.FailOverPolicy;
import com.j_spaces.core.cluster.LoadBalancingPolicy;
import com.j_spaces.core.cluster.ReplicationPolicy;
import com.j_spaces.kernel.JSpaceUtilities;
import com.j_spaces.lookup.entry.ClusterName;
import com.j_spaces.lookup.entry.ContainerName;
import com.j_spaces.lookup.entry.HostName;
import com.j_spaces.lookup.entry.State;
import com.j_spaces.tools.cluster.ClusterMemberInfo;
import java.net.MalformedURLException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.core.entry.Entry;
import net.jini.core.lookup.ServiceItem;
import net.jini.entry.AbstractEntry;
import net.jini.lookup.entry.Name;

public class CLIFinder {
    public static final Logger _logger = Logger.getLogger("com.gigaspaces.admin");

    public static Object find(SpaceURL spaceURL, int n2) throws RemoteException, FinderException {
        String string = spaceURL.getProtocol();
        if (string.equals("jini:")) {
            String string2 = spaceURL.getSpaceName();
            if (string2 != null) {
                String string3;
                String string4 = spaceURL.getContainerName();
                ServiceItem[] serviceItemArray = CLIFinder.findSpacesByJini(string4, string2, string3 = spaceURL.getHost(), n2);
                if (serviceItemArray == null || serviceItemArray.length == 0) {
                    return null;
                }
                return serviceItemArray[0].service;
            }
            ServiceItem[] serviceItemArray = CLIFinder.a(spaceURL);
            if (serviceItemArray == null) {
                return null;
            }
            return serviceItemArray[0].service;
        }
        if (string.equals("rmi:")) {
            Object object = SpaceFinder.find(spaceURL);
            if (object instanceof IJSpace && n2 >= 0 && ((IRemoteJSpaceAdmin)((Object)((IDirectSpaceProxy)object).getRemoteJSpace())).getState() != n2) {
                object = null;
            }
            return object;
        }
        return null;
    }

    public static ServiceItem[] findAllSpaceServices() {
        return GS.getServiceFinder().findSpaces(null, null);
    }

    public static ServiceItem[] findSpaceServices(int n2) {
        Entry[] entryArray = null;
        if (n2 >= 0) {
            entryArray = new Entry[1];
            State state = new State(n2);
            entryArray[0] = state;
        }
        return GS.getServiceFinder().findSpaces(null, entryArray);
    }

    public static ServiceItem[] findSpaceServices(String string, int n2) throws RemoteException, FinderException {
        IJSpace iJSpace;
        SpaceURL spaceURL = null;
        try {
            spaceURL = SpaceURLParser.parseURL(string);
        }
        catch (MalformedURLException malformedURLException) {
            throw new FinderException(malformedURLException.toString());
        }
        String string2 = spaceURL.getProtocol();
        if (string2.equals("jini:")) {
            String string3;
            String string4;
            String string5 = spaceURL.getContainerName();
            ServiceItem[] serviceItemArray = CLIFinder.findSpacesByJini(string5, string4 = spaceURL.getSpaceName(), string3 = spaceURL.getHost(), n2);
            if (serviceItemArray.length == 0) {
                System.out.println("Space '" + string4 + "' under container '" + string5 + "' that running on host '" + string3 + "' was not found.");
                return null;
            }
            return serviceItemArray;
        }
        if (string2.equals("rmi:") && (iJSpace = (IJSpace)SpaceFinder.find(string)) != null && (n2 < 0 || n2 >= 0 && ((IRemoteJSpaceAdmin)((Object)((IDirectSpaceProxy)iJSpace).getRemoteJSpace())).getState() == n2)) {
            ServiceItem serviceItem = CLIFinder.createSpaceServiceItem(iJSpace, null);
            return new ServiceItem[]{serviceItem};
        }
        return null;
    }

    public static ServiceItem[] findSpacesByJini(String string, String string2, String string3, int n2) {
        ArrayList<AbstractEntry> arrayList = new ArrayList<AbstractEntry>(3);
        if (!JSpaceUtilities.isEmpty(string) && !"*".equals(string)) {
            arrayList.add(new ContainerName(string));
        }
        if (!JSpaceUtilities.isEmpty(string2) && !"*".equals(string2)) {
            arrayList.add(new Name(string2));
        }
        if (!JSpaceUtilities.isEmpty(string3) && !"*".equals(string3)) {
            arrayList.add(new HostName(string3));
        }
        if (n2 >= 0) {
            arrayList.add(new State(n2));
        }
        Entry[] entryArray = arrayList.toArray(new Entry[0]);
        ServiceItem[] serviceItemArray = GS.getServiceFinder().findSpaces(null, entryArray);
        return serviceItemArray;
    }

    private static ServiceItem[] a(SpaceURL spaceURL) throws FinderException {
        String string = spaceURL.getContainerName();
        String string2 = spaceURL.getHost();
        ArrayList<AbstractEntry> arrayList = new ArrayList<AbstractEntry>(2);
        if (!JSpaceUtilities.isEmpty(string) && !"*".equals(string)) {
            arrayList.add(new Name(string));
        }
        if (!JSpaceUtilities.isEmpty(string2) && !"*".equals(string2)) {
            arrayList.add(new HostName(string2));
        }
        Entry[] entryArray = arrayList.toArray(new Entry[0]);
        ServiceItem[] serviceItemArray = GS.getServiceFinder().find(null, entryArray);
        if (serviceItemArray.length == 0) {
            System.out.println("Container '" + string + "' running on host '" + string2 + "' was not found.");
            return null;
        }
        return serviceItemArray;
    }

    public static ServiceItem[] findClusterMembers(ClusterPolicy clusterPolicy, int n2) {
        ServiceItem[] serviceItemArray;
        Set set = CLIFinder.a(clusterPolicy);
        Iterator iterator = set.iterator();
        String string = "jini:";
        if (iterator.hasNext()) {
            serviceItemArray = ((ClusterMemberInfo)iterator.next()).memberURL;
            string = serviceItemArray.getProtocol();
        }
        serviceItemArray = null;
        if (string.equals("jini:")) {
            String string2 = clusterPolicy.m_ClusterName;
            ClusterName clusterName = new ClusterName(string2);
            Entry[] entryArray = new Entry[n2 < 0 ? 1 : 2];
            entryArray[0] = clusterName;
            if (n2 >= 0) {
                State state = new State(n2);
                entryArray[1] = state;
            }
            serviceItemArray = GS.getServiceFinder().findSpaces(null, entryArray);
        } else if (string.equals("rmi:")) {
            iterator = set.iterator();
            ArrayList<ServiceItem> arrayList = new ArrayList<ServiceItem>(set.size());
            while (iterator.hasNext()) {
                ClusterMemberInfo clusterMemberInfo = (ClusterMemberInfo)iterator.next();
                SpaceURL spaceURL = clusterMemberInfo.memberURL;
                try {
                    IJSpace iJSpace = (IJSpace)SpaceFinder.find(spaceURL);
                    if (n2 >= 0 && ((IRemoteJSpaceAdmin)((Object)((IDirectSpaceProxy)iJSpace).getRemoteJSpace())).getState() != n2) continue;
                    ServiceItem serviceItem = CLIFinder.createSpaceServiceItem(iJSpace, null);
                    arrayList.add(serviceItem);
                }
                catch (Exception exception) {
                    System.out.println("Failed to find space cluster member:" + spaceURL);
                    _logger.log(Level.SEVERE, exception.toString(), exception);
                }
            }
            serviceItemArray = arrayList.toArray(new ServiceItem[0]);
        }
        return serviceItemArray;
    }

    public static Map getClusterMembersSpaceProxies(ClusterPolicy clusterPolicy) throws RemoteException, FinderException, NoSuchNameException {
        Set set = CLIFinder.a(clusterPolicy);
        int n2 = set.size();
        HashMap<String, IJSpace> hashMap = new HashMap<String, IJSpace>(n2);
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            ClusterMemberInfo clusterMemberInfo = (ClusterMemberInfo)iterator.next();
            IJSpace iJSpace = (IJSpace)CLIFinder.find(clusterMemberInfo.memberURL, 1);
            hashMap.put(clusterMemberInfo.memberName, iJSpace);
        }
        return hashMap;
    }

    private static Set a(ClusterPolicy clusterPolicy) {
        Set set;
        HashSet hashSet = new HashSet();
        FailOverPolicy failOverPolicy = clusterPolicy.m_FailOverPolicy;
        LoadBalancingPolicy loadBalancingPolicy = clusterPolicy.m_LoadBalancingPolicy;
        ReplicationPolicy replicationPolicy = clusterPolicy.m_ReplicationPolicy;
        List list = null;
        List list2 = null;
        if (failOverPolicy != null) {
            list = failOverPolicy.failOverGroupMembersURLs;
            list2 = failOverPolicy.failOverGroupMembersNames;
            set = CLIFinder.a(list, list2);
            hashSet.addAll(set);
        }
        if (loadBalancingPolicy != null) {
            list = loadBalancingPolicy.loadBalanceGroupMembersURLs;
            list2 = loadBalancingPolicy.loadBalanceGroupMembersNames;
            set = CLIFinder.a(list, list2);
            hashSet.addAll(set);
        }
        if (replicationPolicy != null) {
            list = replicationPolicy.m_ReplicationGroupMembersURLs;
            list2 = replicationPolicy.m_ReplicationGroupMembersNames;
            set = CLIFinder.a(list, list2);
            hashSet.addAll(set);
        }
        return hashSet;
    }

    private static Set a(List list, List list2) {
        if (list == null) {
            return new HashSet(1);
        }
        HashSet<ClusterMemberInfo> hashSet = new HashSet<ClusterMemberInfo>(list.size());
        int n2 = list.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            SpaceURL spaceURL = (SpaceURL)list.get(i2);
            String string = (String)list2.get(i2);
            ClusterMemberInfo clusterMemberInfo = new ClusterMemberInfo(string, spaceURL, null, null, null, false);
            hashSet.add(clusterMemberInfo);
        }
        return hashSet;
    }

    public static ServiceItem createSpaceServiceItem(IJSpace iJSpace, String string) {
        if (string == null) {
            string = iJSpace.getName();
        }
        Entry[] entryArray = new Entry[1];
        Name name = new Name(string);
        entryArray[0] = name;
        ServiceItem serviceItem = new ServiceItem(null, iJSpace, entryArray);
        return serviceItem;
    }
}

