/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.ui.prefs;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.border.TitledBorder;
import org.isqlviewer.swing.JFileList;
import org.isqlviewer.ui.AbstractPropertyPage;
import org.isqlviewer.ui.PreferencesEditor;
import org.isqlviewer.ui.prefs.ProxyPropertyPage;
import org.isqlviewer.util.BasicUtilities;

public final class AdvancedPropertyPage
extends AbstractPropertyPage
implements ActionListener {
    private JCheckBox chkWebEnable = new JCheckBox();
    private JComboBox jcbTypes = new JComboBox<Object>(new Object[]{BasicUtilities.getString("Version_Type_Stable"), BasicUtilities.getString("Version_Type_Both")});
    private JButton btnReset = new JButton(BasicUtilities.getString("Reset"));
    private JFileList jflClasspath = new JFileList();
    private PreferencesEditor editor = null;

    public AdvancedPropertyPage(PreferencesEditor preferencesEditor) {
        try {
            this.editor = preferencesEditor;
            this.initUI();
            this.addChild(new ProxyPropertyPage());
        }
        catch (Throwable throwable) {
            BasicUtilities.HandleException(throwable, "PropertiesAdvanced::<init>");
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object.equals(this.chkWebEnable)) {
            this.jcbTypes.setEnabled(this.chkWebEnable.isSelected());
        } else if (object.equals(this.btnReset)) {
            int n2 = JOptionPane.showConfirmDialog(this, BasicUtilities.getString("Reset_Warning"));
            if (n2 == 0) {
                prefs.clearAll();
                this.editor.resetPages();
            }
            this.jcbTypes.setEnabled(this.chkWebEnable.isSelected());
        }
    }

    public String getPropertyPageName() {
        return BasicUtilities.getString("Advanced_Tab_Label");
    }

    public void saveProperties() {
        super.saveProperties();
        prefs.putInt("advanced.versioncheck-type", this.jcbTypes.getSelectedIndex());
    }

    public void updatePage() {
        this.jcbTypes.setSelectedIndex(prefs.getInt("advanced.versioncheck-type"));
        this.jcbTypes.setEnabled(this.chkWebEnable.isSelected());
    }

    public void initUI() {
        this.setLayout(new GridBagLayout());
        this.chkWebEnable.addActionListener(this);
        this.jcbTypes.addActionListener(this);
        this.btnReset.addActionListener(this);
        this.btnReset.setToolTipText(BasicUtilities.getString("Reset_Tip"));
        this.chkWebEnable.setText(BasicUtilities.getString("Enable_AutoWebCheck"));
        this.chkWebEnable.setToolTipText(BasicUtilities.getString("Enable_AutoWebCheck_Tip"));
        this.setPropertyForComponent(this.chkWebEnable, "advanced.versioncheck-enabled");
        this.setPropertyForComponent(this.jflClasspath, "advanced.classpath");
        this.jflClasspath.setBorder(new TitledBorder(BasicUtilities.getString("Path_Pane_Title")));
        this.jflClasspath.addFileFilter(new JFileList.ClasspathFileFilter());
        AdvancedPropertyPage.constrain(1, 0, 3, 1, 0.0, 0.0, 17, 0);
        this.add(Box.createVerticalStrut(6), UI_CONSTRAINT);
        AdvancedPropertyPage.constrain(0, 0, 1, 6, 0.0, 0.0, 17, 0);
        this.add(Box.createHorizontalStrut(12), UI_CONSTRAINT);
        AdvancedPropertyPage.constrain(1, 1, 2, 1, 0.0, 0.0, 17, 1);
        this.add((Component)this.chkWebEnable, UI_CONSTRAINT);
        AdvancedPropertyPage.constrain(3, 1, 1, 2, 0.0, 0.0, 17, 0);
        this.add((Component)this.btnReset, UI_CONSTRAINT);
        AdvancedPropertyPage.constrain(2, 2, 1, 1, 0.0, 0.0, 17, 0);
        this.add((Component)this.jcbTypes, UI_CONSTRAINT);
        AdvancedPropertyPage.constrain(1, 3, 3, 1, 0.0, 0.0, 10, 2);
        this.add(AdvancedPropertyPage.createHorizSeperator(), UI_CONSTRAINT);
        AdvancedPropertyPage.constrain(1, 3, 3, 1, 0.0, 0.0, 17, 0);
        this.add(Box.createVerticalStrut(24), UI_CONSTRAINT);
        AdvancedPropertyPage.constrain(1, 4, 3, 1, 1.0, 1.0, 17, 1);
        this.add((Component)this.jflClasspath, UI_CONSTRAINT);
        AdvancedPropertyPage.constrain(1, 5, 3, 1, 0.0, 0.0, 17, 0);
        this.add(Box.createVerticalStrut(6), UI_CONSTRAINT);
        AdvancedPropertyPage.constrain(5, 0, 1, 6, 0.0, 0.0, 17, 0);
        this.add(Box.createHorizontalStrut(12), UI_CONSTRAINT);
    }
}

