/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.ui;

import com.j_spaces.core.IJSpace;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.io.PrintStream;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import org.isqlviewer.core.SQLBookmark;
import org.isqlviewer.core.ServiceDefinition;
import org.isqlviewer.core.ServiceProvider;
import org.isqlviewer.core.SystemConfig;
import org.isqlviewer.core.jetfire.ImportConfig;
import org.isqlviewer.core.jetfire.ImportRunner;
import org.isqlviewer.core.model.BookmarkTreeModel;
import org.isqlviewer.core.model.EnhancedTableModel;
import org.isqlviewer.core.model.ResultSetTableModel;
import org.isqlviewer.event.ProgressEvent;
import org.isqlviewer.sql.DatabaseConnection;
import org.isqlviewer.sql.ResultSetViewer;
import org.isqlviewer.swing.ActionPanel;
import org.isqlviewer.swing.BookmarkTreeCellRenderer;
import org.isqlviewer.swing.ImportEditor;
import org.isqlviewer.swing.ProgressPanel;
import org.isqlviewer.ui.AppController;
import org.isqlviewer.ui.SQLEditor;
import org.isqlviewer.ui.WizardContainer;
import org.isqlviewer.util.BasicUtilities;
import org.isqlviewer.util.StringUtilities;

public class DataMigrator
extends WizardContainer {
    private static final String STEP_SERVICE_PICK = "services";
    private static final String STEP_TYPE_PICK = "type-pick";
    private static final String STEP_IMPORT_MAP = "import-map";
    private static final String STEP_PROGRESS = "progress";
    private static final int TYPE_BOOKMARK = 0;
    private static final int TYPE_MANUAL = 1;
    private static final int TYPE_TABLE = 2;
    private static final String KEY_SRC_SERVICE = "source-service";
    private static final String KEY_DST_SERVICE = "dest-service";
    private static final String KEY_SRC_CATALOG = "source-catalog";
    private static final String KEY_SRC_TYPE = "source-type";
    private static final String KEY_SRC_VALUE = "source-value";
    private static final String KEY_DATASOURCE_MODEL = "datasource-model";
    private static final String KEY_IMPORT_CONFIG = "import-config";
    private ServiceSelection serviceSelection = new ServiceSelection();
    private MigTypeSelection typeSelection = new MigTypeSelection();
    private ImportEditor importEditor = null;
    private HashMap migrateConfig = new HashMap();
    private Thread importThread;
    private ProgressPanel progressPanel = new ProgressPanel();

    public DataMigrator(JFrame jFrame, AppController appController) {
        super(jFrame);
        this.addUserComponent(STEP_SERVICE_PICK, this.serviceSelection);
        this.addUserComponent(STEP_TYPE_PICK, this.typeSelection);
        this.addUserComponent(STEP_PROGRESS, this.progressPanel);
        this.startWizard();
    }

    public void processWindowEvent(WindowEvent windowEvent) {
        if (windowEvent.getID() == 200) {
            this.setSize(new Dimension(800, 600));
            this.setLocationRelativeTo(this.getOwner());
        } else if (windowEvent.getID() == 201) {
            // empty if block
        }
        super.processWindowEvent(windowEvent);
    }

    public boolean isStepValid(String string) {
        if (string.equals(STEP_SERVICE_PICK)) {
            return this.serviceSelection.isConfigured();
        }
        if (string.equals(STEP_TYPE_PICK)) {
            return this.typeSelection.isConfigured();
        }
        return super.isStepValid(string);
    }

    public void processStepChange(String string, boolean bl2, String string2) {
        if (!bl2) {
            if (string.equals(STEP_PROGRESS)) {
                int n2;
                this.typeSelection.saveState(this.migrateConfig);
                this.setPreviousStepEnabled(false);
                this.setBanner(BasicUtilities.getString("Jetfire_Progress_Banner"));
                this.setComment(BasicUtilities.getString("Jetfire_Progress_Comment"));
                this.setIcon(BasicUtilities.loadIconResource("JetFire24"));
                int n3 = n2 = string2.equals(STEP_TYPE_PICK) ? 1 : 2;
                if (this.importEditor != null) {
                    this.migrateConfig.put(KEY_IMPORT_CONFIG, this.importEditor.getImportConfig());
                }
                ImportWorker importWorker = new ImportWorker(n2);
                this.importThread = new Thread((Runnable)importWorker, "jetfire");
                this.importThread.start();
            } else if (string.equals(STEP_SERVICE_PICK)) {
                this.setIcon(BasicUtilities.loadIconResource("WebComponent24"));
                this.setBanner(BasicUtilities.getString("Jetfire_Service_Banner"));
                this.setComment(BasicUtilities.getString("Jetfire_Service_Comment"));
            } else if (string.equals(STEP_TYPE_PICK)) {
                this.serviceSelection.saveState(this.migrateConfig);
                try {
                    String string3;
                    ServiceDefinition serviceDefinition = (ServiceDefinition)this.migrateConfig.get(KEY_DST_SERVICE);
                    DatabaseConnection databaseConnection = serviceDefinition.createConnection();
                    databaseConnection.gsConnect();
                    serviceDefinition = (ServiceDefinition)this.migrateConfig.get(KEY_SRC_SERVICE);
                    databaseConnection = serviceDefinition.createConnection();
                    databaseConnection.gsConnect();
                    if (this.migrateConfig.containsKey(KEY_SRC_CATALOG) && (string3 = (String)this.migrateConfig.get(KEY_SRC_CATALOG)) != null && string3.trim().length() >= 1) {
                        databaseConnection.changeCatalog(string3);
                    }
                    this.typeSelection.setService(databaseConnection, this);
                }
                catch (Throwable throwable) {
                    BasicUtilities.showExceptionPopup(this, throwable, throwable.getMessage());
                }
                this.setIcon(BasicUtilities.loadIconResource("Import24"));
                this.setBanner(BasicUtilities.getString("QBuild_Where_Select_Banner"));
                this.setComment(BasicUtilities.getString("QBuild_Where_Select_Comment"));
            } else if (string.equals(STEP_IMPORT_MAP)) {
                this.setIcon(BasicUtilities.loadIconResource("WebComponent24"));
                this.setBanner(BasicUtilities.getString("Jetfire_Service_Banner"));
                this.setComment(BasicUtilities.getString("Jetfire_Service_Comment"));
                this.removeUserComponent(STEP_PROGRESS);
                this.progressPanel.reset();
                this.addUserComponent(STEP_PROGRESS, this.progressPanel);
            }
        }
    }

    private class ImportWorker
    implements Runnable,
    ResultSetViewer {
        public static final int MODE_DATA_LOAD = 1;
        public static final int MODE_DATA_IMPORT = 2;
        private int opMode = 0;
        private PrintStream err = DataMigrator.access$000(DataMigrator.this).getErrStream();
        private PrintStream out = DataMigrator.access$000(DataMigrator.this).getOutStream();

        public ImportWorker(int n2) {
            if (n2 != 1 && n2 != 2) {
                throw new IllegalArgumentException();
            }
            this.opMode = n2;
        }

        public void run() {
            DataMigrator.this.setPreviousStepEnabled(false);
            DataMigrator.this.setNextStepEnabled(false);
            switch (this.opMode) {
                case 1: {
                    try {
                        this.runFilter();
                    }
                    catch (Throwable throwable) {
                        BasicUtilities.HandleException(throwable, "ImportProcess:runFilter()", true, this.err);
                    }
                    break;
                }
                case 2: {
                    ServiceDefinition serviceDefinition = (ServiceDefinition)DataMigrator.this.migrateConfig.get(DataMigrator.KEY_DST_SERVICE);
                    try {
                        ImportConfig importConfig = (ImportConfig)DataMigrator.this.migrateConfig.get(DataMigrator.KEY_IMPORT_CONFIG);
                        EnhancedTableModel enhancedTableModel = (EnhancedTableModel)DataMigrator.this.migrateConfig.get(DataMigrator.KEY_DATASOURCE_MODEL);
                        DatabaseConnection databaseConnection = serviceDefinition.createConnection();
                        ImportRunner importRunner = new ImportRunner(importConfig, databaseConnection);
                        importRunner.setSourceData(enhancedTableModel);
                        importRunner.setStdErr(this.err);
                        importRunner.setStdOut(this.out);
                        importRunner.runImport();
                    }
                    catch (Throwable throwable) {
                        BasicUtilities.HandleException(throwable, "ImportProcess:runImport()");
                    }
                    this.out.println(BasicUtilities.getString("Import_Finish_Info"));
                    break;
                }
            }
            DataMigrator.this.progressPanel.progressUpdated(new ProgressEvent(this, 1, 1));
            DataMigrator.this.setPreviousStepEnabled(true);
            DataMigrator.this.setNextStepEnabled(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleSQLException(ResultSet resultSet, SQLException sQLException) {
            String string = BasicUtilities.getString("JetFire_Query_Error", sQLException.getMessage());
            BasicUtilities.HandleException((Throwable)sQLException, string, false, this.err);
            this.out.println(string);
            ProgressEvent progressEvent = new ProgressEvent(this, 1, 1);
            progressEvent.setNote(string);
            DataMigrator.this.progressPanel.progressUpdated(progressEvent);
            ImportWorker importWorker = this;
            synchronized (importWorker) {
                this.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleStatementInterrupted(String string) {
            BasicUtilities.HandleException(new Throwable());
            String string2 = BasicUtilities.getString("JetFire_Query_Cancelled", string);
            this.out.println(string2);
            ProgressEvent progressEvent = new ProgressEvent(this, 1, 1);
            progressEvent.setNote(string2);
            DataMigrator.this.progressPanel.progressUpdated(progressEvent);
            ImportWorker importWorker = this;
            synchronized (importWorker) {
                this.notify();
            }
        }

        public void processGeneratedKeys(String string, ResultSet resultSet, String string2) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void processResultSet(String string, ResultSet resultSet, String string2, int n2, IJSpace iJSpace) {
            String[] stringArray = new String[]{string, string2, Integer.toString(n2)};
            this.out.println(BasicUtilities.getString("JetFire_Processing_Results", stringArray));
            ResultSetTableModel resultSetTableModel = new ResultSetTableModel(resultSet, this, true);
            DataMigrator.this.migrateConfig.put(DataMigrator.KEY_DATASOURCE_MODEL, resultSetTableModel);
            stringArray = new String[]{Integer.toString(resultSetTableModel.getRowCount()), Integer.toString(resultSetTableModel.getColumnCount())};
            this.out.println(BasicUtilities.getString("JetFire_Processing_Finished", stringArray));
            ImportWorker importWorker = this;
            synchronized (importWorker) {
                this.notify();
            }
        }

        public void processRowUpdates(String string, int n2, String string2) {
        }

        public void recieveResultsetWarnings(ResultSet resultSet, SQLWarning sQLWarning) {
            BasicUtilities.HandleException(new Throwable(), "ResultSet Warnings", true, this.err);
        }

        public void recieveStatementWarnings(Statement statement, SQLWarning sQLWarning) {
            BasicUtilities.HandleException(new Throwable(), "Statement Warnings", true, this.err);
        }

        public void statementInitialized(String string) {
            String string2 = BasicUtilities.getString("JetFire_Query_Initialized", string);
            this.out.println(string2);
            ProgressEvent progressEvent = new ProgressEvent(this, -1, 1);
            progressEvent.setNote(string2);
            DataMigrator.this.progressPanel.progressUpdated(progressEvent);
        }

        public boolean supportsGeneratedKeys() {
            return false;
        }

        public boolean supportsUpdateableResultSets() {
            return false;
        }

        public void executeBookmark(SQLBookmark sQLBookmark, DatabaseConnection databaseConnection) {
            if (sQLBookmark != null) {
                SQLBookmark sQLBookmark2 = (SQLBookmark)sQLBookmark.clone();
                String string = this.processSQLParameters(sQLBookmark2.getSQL());
                if (string == null) {
                    return;
                }
                sQLBookmark2.setSQL(string);
                if (sQLBookmark.hasParameters()) {
                    try {
                        PreparedStatement preparedStatement = sQLBookmark2.toPreparedStatement(databaseConnection);
                        sQLBookmark.updateLastAcessTime();
                        sQLBookmark.updateUseCount();
                        databaseConnection.executeStatement(preparedStatement, sQLBookmark2.getSQL(), this);
                    }
                    catch (Throwable throwable) {
                        BasicUtilities.HandleException(throwable);
                    }
                } else {
                    sQLBookmark.updateLastAcessTime();
                    sQLBookmark.updateUseCount();
                    databaseConnection.executeStaticRequest(sQLBookmark2.getSQL(), this);
                }
                sQLBookmark2 = null;
            } else {
                BasicUtilities.beep();
            }
        }

        public String processSQLParameters(String string) {
            String[] stringArray = StringUtilities.getSQLParameters(string);
            HashMap<String, String> hashMap = new HashMap<String, String>();
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                String string2 = stringArray[i2];
                String string3 = JOptionPane.showInputDialog(DataMigrator.this, (Object)BasicUtilities.getString("SQL_Param_Prompt", string2));
                if (string3 == null) {
                    System.out.println(BasicUtilities.getString("Query_Cancelled"));
                    hashMap.clear();
                    hashMap = null;
                    stringArray = null;
                    return null;
                }
                hashMap.put(string2, string3);
            }
            String string4 = StringUtilities.applySQLParameters(hashMap, string);
            hashMap.clear();
            hashMap = null;
            stringArray = null;
            return string4;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void runFilter() throws Exception {
            Object object;
            ServiceDefinition serviceDefinition = (ServiceDefinition)DataMigrator.this.migrateConfig.get(DataMigrator.KEY_SRC_SERVICE);
            DatabaseConnection databaseConnection = serviceDefinition.createConnection();
            String string = (String)DataMigrator.this.migrateConfig.get(DataMigrator.KEY_SRC_TYPE);
            int n2 = Integer.parseInt(string);
            switch (n2) {
                case 0: {
                    object = (SQLBookmark)DataMigrator.this.migrateConfig.get(DataMigrator.KEY_SRC_VALUE);
                    this.executeBookmark((SQLBookmark)object, databaseConnection);
                    break;
                }
                case 1: {
                    String string2 = (String)DataMigrator.this.migrateConfig.get(DataMigrator.KEY_SRC_VALUE);
                    databaseConnection.executeStaticRequest(string2, this);
                    break;
                }
                case 2: {
                    String string3 = (String)DataMigrator.this.migrateConfig.get(DataMigrator.KEY_SRC_VALUE);
                    String string4 = MessageFormat.format("SELECT * FROM {0}", string3);
                    databaseConnection.executeStaticRequest(string4, this);
                }
            }
            object = this;
            synchronized (object) {
                this.wait();
            }
            serviceDefinition = null;
            if (DataMigrator.this.migrateConfig.containsKey(DataMigrator.KEY_DATASOURCE_MODEL)) {
                serviceDefinition = (ServiceDefinition)DataMigrator.this.migrateConfig.get(DataMigrator.KEY_DST_SERVICE);
                databaseConnection = serviceDefinition.createConnection();
                DataMigrator.this.importEditor = new ImportEditor(databaseConnection);
                DataMigrator.this.importEditor.setData((EnhancedTableModel)DataMigrator.this.migrateConfig.get(DataMigrator.KEY_DATASOURCE_MODEL));
                DataMigrator.this.addUserComponent(DataMigrator.STEP_IMPORT_MAP, DataMigrator.this.importEditor);
            }
            this.out.println(BasicUtilities.getString("Jetfire_DataLoad_Finished", databaseConnection.getConnectionName()));
        }
    }

    private static class MigTypeSelection
    extends ActionPanel {
        private DefaultComboBoxModel mdlTables = null;
        private DefaultComboBoxModel mdlSchemas = null;
        private JComboBox jcbSchemas = null;
        private JComboBox jcbTables = null;
        private ButtonGroup choice = new ButtonGroup();
        private JRadioButton jrbBookmark = new JRadioButton(BasicUtilities.getString("JetFire_Bookmark_Type"));
        private JRadioButton jrbManual = new JRadioButton(BasicUtilities.getString("JetFire_Manual_Type"));
        private JRadioButton jrbTable = new JRadioButton(BasicUtilities.getString("JetFire_Table_Type"));
        private JTextField txtSchema = new JTextField();
        private JTextField txtTable = new JTextField();
        private JTree jtrBookmarks = new JTree();
        private SQLEditor editor = new SQLEditor();
        private HashMap tableMappings = new HashMap();

        public MigTypeSelection() {
            this.initUI();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setService(DatabaseConnection databaseConnection, Window window) {
            try {
                this.editor.configureWithConnection(databaseConnection);
                this.editor.createContextHelp(window);
                this.loadTables(databaseConnection);
            }
            catch (Throwable throwable) {
                String string = BasicUtilities.getString("JetFire_Test_Failed", databaseConnection.getConnectionName());
                BasicUtilities.showExceptionPopup(this, throwable, string);
            }
            finally {
                this.invalidate();
                this.repaint();
            }
        }

        public void saveState(HashMap hashMap) {
            String string = this.choice.getSelection().getActionCommand();
            hashMap.put(DataMigrator.KEY_SRC_TYPE, string);
            switch (Integer.parseInt(string)) {
                case 0: {
                    hashMap.put(DataMigrator.KEY_SRC_VALUE, this.jtrBookmarks.getLastSelectedPathComponent());
                    break;
                }
                case 1: {
                    hashMap.put(DataMigrator.KEY_SRC_VALUE, this.editor.getText());
                    break;
                }
                case 2: {
                    String string2;
                    String string3 = this.jcbSchemas == null ? this.txtSchema.getText().trim() : (String)this.jcbSchemas.getSelectedItem();
                    String string4 = string2 = this.jcbTables == null ? this.txtTable.getText().trim() : (String)this.jcbTables.getSelectedItem();
                    if (string3 == null || string3.length() == 0) {
                        hashMap.put(DataMigrator.KEY_SRC_VALUE, string2);
                        break;
                    }
                    string2 = string3.concat(".").concat(string2);
                    hashMap.put(DataMigrator.KEY_SRC_VALUE, string2);
                }
            }
        }

        public boolean isConfigured() {
            String string = this.choice.getSelection().getActionCommand();
            boolean bl2 = false;
            String string2 = null;
            switch (Integer.parseInt(string)) {
                case 0: {
                    Object object = this.jtrBookmarks.getLastSelectedPathComponent();
                    string2 = BasicUtilities.getString("JetFire_Please_Select_a_Bookmark");
                    bl2 = object instanceof SQLBookmark;
                    break;
                }
                case 1: {
                    bl2 = this.editor.getText().trim().length() >= 1;
                    string2 = BasicUtilities.getString("JetFire_Please_Enter_a_Valid_SQL_Query");
                    break;
                }
                case 2: {
                    String string3;
                    String string4 = this.jcbSchemas == null ? this.txtSchema.getText().trim() : (String)this.jcbSchemas.getSelectedItem();
                    String string5 = string3 = this.jcbTables == null ? this.txtTable.getText().trim() : (String)this.jcbTables.getSelectedItem();
                    if (string4 != null && string4.length() >= 1) {
                        string3 = string4.concat(".").concat(string3);
                    }
                    string2 = BasicUtilities.getString("JetFire_Please_Enter_a_Valid_Table_Name");
                    boolean bl3 = bl2 = string3.length() >= 1;
                }
            }
            if (!bl2) {
                JOptionPane.showMessageDialog(this, string2);
            }
            return bl2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void processActionEvent(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object instanceof JRadioButton) {
                this.jtrBookmarks.setEnabled(this.jrbBookmark.isSelected());
                this.editor.setEnabled(this.jrbManual.isSelected());
                boolean bl2 = this.jrbTable.isSelected();
                if (this.jcbSchemas != null && this.mdlSchemas.getSize() >= 1) {
                    this.jcbSchemas.setEnabled(bl2);
                } else if (this.jcbSchemas == null) {
                    this.txtSchema.setEnabled(bl2);
                }
                if (this.jcbTables != null && this.mdlTables.getSize() >= 1) {
                    this.jcbTables.setEnabled(bl2);
                } else if (this.jcbSchemas == null) {
                    this.txtTable.setEnabled(bl2);
                }
            } else if (this.jcbSchemas != null && this.jcbSchemas.getSelectedIndex() >= 0) {
                String string = (String)this.jcbSchemas.getSelectedItem();
                DefaultComboBoxModel defaultComboBoxModel = this.mdlTables;
                synchronized (defaultComboBoxModel) {
                    this.mdlTables.removeAllElements();
                    ArrayList arrayList = (ArrayList)this.tableMappings.get(string);
                    Iterator iterator = arrayList.iterator();
                    while (iterator.hasNext()) {
                        try {
                            this.mdlTables.addElement(iterator.next());
                        }
                        catch (ConcurrentModificationException concurrentModificationException) {
                            // empty catch block
                            break;
                        }
                    }
                }
                boolean bl3 = this.mdlTables.getSize() >= 1 && this.jrbTable.isSelected();
                this.jcbTables.setEnabled(bl3);
            }
        }

        private void initUI() {
            this.setLayout(new GridBagLayout());
            JLabel jLabel = null;
            WizardContainer.constrain(0, 0, 2, 1, 0.0, 0.0, 17, 0);
            jLabel = new JLabel(BasicUtilities.getString("JetFire_Select_Load_Type"));
            this.add((Component)jLabel, WizardContainer.UI_CONSTRAINT);
            WizardContainer.constrain(0, 1, 2, 1, 0.0, 0.0, 17, 0);
            this.add((Component)this.jrbBookmark, WizardContainer.UI_CONSTRAINT);
            WizardContainer.constrain(1, 2, 2, 1, 0.5, 0.5, 17, 1);
            this.add((Component)new JScrollPane(this.jtrBookmarks), WizardContainer.UI_CONSTRAINT);
            WizardContainer.constrain(0, 3, 2, 1, 0.0, 0.0, 17, 0);
            this.add((Component)this.jrbManual, WizardContainer.UI_CONSTRAINT);
            WizardContainer.constrain(1, 4, 2, 1, 0.5, 0.5, 17, 1);
            this.add((Component)this.editor, WizardContainer.UI_CONSTRAINT);
            WizardContainer.constrain(0, 5, 2, 1, 0.0, 0.0, 17, 0);
            this.add((Component)this.jrbTable, WizardContainer.UI_CONSTRAINT);
            WizardContainer.constrain(1, 6, 1, 1, 0.0, 0.0, 17, 0);
            this.add((Component)new JLabel(BasicUtilities.getString("JetFire_Select_Schema")), WizardContainer.UI_CONSTRAINT);
            WizardContainer.constrain(2, 6, 1, 1, 0.1, 0.0, 17, 2);
            this.add((Component)this.txtSchema, WizardContainer.UI_CONSTRAINT);
            WizardContainer.constrain(1, 7, 1, 1, 0.0, 0.0, 17, 0);
            this.add((Component)new JLabel(BasicUtilities.getString("JetFire_Select_Table")), WizardContainer.UI_CONSTRAINT);
            WizardContainer.constrain(2, 7, 1, 1, 0.1, 0.0, 17, 2);
            this.add((Component)this.txtTable, WizardContainer.UI_CONSTRAINT);
            WizardContainer.constrain(0, 0, 1, 8, 0.0, 0.0, 17, 0);
            this.add(Box.createHorizontalStrut(16), WizardContainer.UI_CONSTRAINT);
            WizardContainer.constrain(0, 8, 3, 1, 0.0, 1.0, 17, 3);
            this.add(Box.createVerticalGlue(), WizardContainer.UI_CONSTRAINT);
            this.choice.add(this.jrbBookmark);
            this.choice.add(this.jrbManual);
            this.choice.add(this.jrbTable);
            this.jrbBookmark.setActionCommand(Integer.toString(0));
            this.jrbManual.setActionCommand(Integer.toString(1));
            this.jrbTable.setActionCommand(Integer.toString(2));
            this.jrbBookmark.addActionListener(this);
            this.jrbManual.addActionListener(this);
            this.jrbTable.addActionListener(this);
            BookmarkTreeCellRenderer bookmarkTreeCellRenderer = new BookmarkTreeCellRenderer();
            BookmarkTreeModel bookmarkTreeModel = SystemConfig.getInstance().getBookmarks();
            this.jtrBookmarks.setModel(bookmarkTreeModel);
            this.jtrBookmarks.setEditable(false);
            this.jtrBookmarks.setCellRenderer(bookmarkTreeCellRenderer);
            this.jtrBookmarks.setRootVisible(false);
            this.jtrBookmarks.setDragEnabled(false);
            if (!bookmarkTreeModel.isEmpty()) {
                this.jrbBookmark.setSelected(true);
            } else {
                this.jrbBookmark.setEnabled(false);
                this.jtrBookmarks.setEnabled(false);
                this.jrbManual.setEnabled(true);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void loadTables(DatabaseConnection databaseConnection) {
            if (this.mdlSchemas == null) {
                this.mdlSchemas = new DefaultComboBoxModel();
                this.jcbSchemas = new JComboBox(this.mdlSchemas);
                this.jcbSchemas.addActionListener(this);
            }
            if (this.mdlTables == null) {
                this.mdlTables = new DefaultComboBoxModel();
                this.jcbTables = new JComboBox(this.mdlTables);
            }
            if (databaseConnection.isClosed()) {
                throw new IllegalStateException(BasicUtilities.getString("No_Database_Connection_Available"));
            }
            this.mdlTables.removeAllElements();
            ResultSet resultSet = null;
            try {
                DatabaseMetaData databaseMetaData = databaseConnection.getDatabaseInformation();
                resultSet = databaseMetaData.getTables(databaseConnection.getCatalog(), "%", "%", databaseConnection.getTableTypes());
                while (resultSet.next()) {
                    ArrayList arrayList;
                    String string = resultSet.getString("TABLE_SCHEM");
                    String string2 = resultSet.getString("TABLE_NAME");
                    if (!this.tableMappings.containsKey(string)) {
                        arrayList = new ArrayList();
                        arrayList.add(string2);
                        this.tableMappings.put(string, arrayList);
                        this.mdlSchemas.addElement(string);
                        continue;
                    }
                    arrayList = (ArrayList)this.tableMappings.get(string);
                    arrayList.add(string2);
                }
                this.jcbSchemas.setEnabled(false);
                this.jcbTables.setEnabled(false);
                this.jcbSchemas.setSelectedItem(databaseConnection.getSchema());
                if (this.mdlTables.getSize() >= 1) {
                    this.jcbTables.setSelectedIndex(0);
                }
                this.remove(this.txtSchema);
                WizardContainer.constrain(2, 6, 1, 1, 0.1, 0.0, 17, 2);
                this.add((Component)this.jcbSchemas, WizardContainer.UI_CONSTRAINT);
                this.remove(this.txtTable);
                WizardContainer.constrain(2, 7, 1, 1, 0.1, 0.0, 17, 2);
                this.add((Component)this.jcbTables, WizardContainer.UI_CONSTRAINT);
            }
            catch (Throwable throwable) {
                this.remove(this.jcbTables);
                WizardContainer.constrain(2, 7, 1, 1, 0.1, 0.0, 17, 2);
                this.add((Component)this.txtTable, WizardContainer.UI_CONSTRAINT);
                String string = BasicUtilities.getString("JetFire_Tables_Failed");
                BasicUtilities.showExceptionPopup(this, throwable, string);
                this.jcbTables = null;
                this.mdlTables = null;
            }
            finally {
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (Throwable throwable) {}
                }
            }
        }
    }

    private static class ToggleRenderer
    extends DefaultListCellRenderer {
        private DefaultComboBoxModel other = null;

        public Component getListCellRendererComponent(JList jList, Object object, int n2, boolean bl2, boolean bl3) {
            super.getListCellRendererComponent((JList<?>)jList, object, n2, bl2, bl3);
            if (object != null && object.equals(this.other.getSelectedItem())) {
                this.setFont(jList.getFont().deriveFont(1));
            }
            this.setIcon(BasicUtilities.loadIconResource("Server16"));
            return this;
        }

        public ToggleRenderer(DefaultComboBoxModel defaultComboBoxModel) {
            this.other = defaultComboBoxModel;
        }
    }

    private static class ServiceSelection
    extends ActionPanel
    implements ActionListener {
        private DefaultComboBoxModel mdlSources = new DefaultComboBoxModel();
        private DefaultComboBoxModel mdlDest = new DefaultComboBoxModel();
        private DefaultComboBoxModel mdlCatalogs = null;
        private ServiceProvider serviceProvider = SystemConfig.getInstance().getServiceProvider();
        private JComboBox jcbSourceService = new JComboBox(this.mdlSources);
        private JComboBox jcbDestService = new JComboBox(this.mdlDest);
        private JComboBox jcbCatalogs = new JComboBox();
        private JTextField txtCatalog = new JTextField();
        private JCheckBox chkCatalog = new JCheckBox(BasicUtilities.getString("JetFire_Select_Src_Catalog"));
        private JButton btnLoadCatalogs = new JButton(BasicUtilities.getString("JetFire_Load_Catalogs"));
        private JButton btnTestSrc = new JButton(BasicUtilities.getString("JetFire_Test_Service"));
        private JButton btnTestDst = new JButton(BasicUtilities.getString("JetFire_Test_Service"));

        public ServiceSelection() {
            this.initUI();
        }

        public void saveState(HashMap hashMap) {
            String string = null;
            string = this.jcbDestService.getSelectedItem().toString();
            hashMap.put(DataMigrator.KEY_DST_SERVICE, this.serviceProvider.serviceForName(string));
            string = this.jcbSourceService.getSelectedItem().toString();
            hashMap.put(DataMigrator.KEY_SRC_SERVICE, this.serviceProvider.serviceForName(string));
            if (this.chkCatalog.isSelected()) {
                if (this.jcbCatalogs != null) {
                    hashMap.put(DataMigrator.KEY_SRC_CATALOG, this.jcbCatalogs.getSelectedItem());
                } else {
                    hashMap.put(DataMigrator.KEY_SRC_CATALOG, this.txtCatalog.getText().trim());
                }
            } else {
                hashMap.remove(DataMigrator.KEY_SRC_CATALOG);
            }
        }

        public boolean isConfigured() {
            Object object = this.jcbSourceService.getSelectedItem();
            Object object2 = this.jcbDestService.getSelectedItem();
            return object != null && object2 != null;
        }

        public void processActionEvent(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == this.btnLoadCatalogs) {
                this.loadCatalogs();
            } else if (object == this.btnTestDst) {
                this.testService(this.jcbDestService.getSelectedItem().toString(), true);
            } else if (object == this.btnTestSrc) {
                this.testService(this.jcbSourceService.getSelectedItem().toString(), true);
            } else if (object == this.chkCatalog) {
                boolean bl2 = this.chkCatalog.isSelected();
                if (this.jcbCatalogs != null) {
                    this.jcbCatalogs.setEnabled(bl2);
                } else {
                    this.txtCatalog.setEnabled(bl2);
                }
                this.btnLoadCatalogs.setEnabled(bl2);
            } else if (object == this.jcbSourceService) {
                this.chkCatalog.setSelected(false);
                this.txtCatalog.setEnabled(false);
                this.btnLoadCatalogs.setEnabled(false);
                this.txtCatalog.setText("");
                if (this.jcbCatalogs != null) {
                    this.remove(this.jcbCatalogs);
                    WizardContainer.constrain(2, 2, 1, 1, 0.1, 0.0, 17, 2);
                    this.add((Component)this.txtCatalog, WizardContainer.UI_CONSTRAINT);
                    this.jcbCatalogs = null;
                    this.mdlCatalogs = null;
                }
            }
        }

        private void initUI() {
            this.setLayout(new GridBagLayout());
            JLabel jLabel = null;
            WizardContainer.constrain(0, 0, 2, 1, 0.0, 0.0, 17, 0);
            jLabel = new JLabel(BasicUtilities.getString("JetFire_Select_Src_Service"));
            this.add((Component)jLabel, WizardContainer.UI_CONSTRAINT);
            WizardContainer.constrain(1, 1, 2, 1, 0.0, 0.0, 17, 2);
            this.add((Component)this.jcbSourceService, WizardContainer.UI_CONSTRAINT);
            WizardContainer.constrain(3, 1, 1, 1, 0.0, 0.0, 17, 0);
            this.add((Component)this.btnTestSrc, WizardContainer.UI_CONSTRAINT);
            WizardContainer.constrain(1, 2, 1, 1, 0.0, 0.0, 13, 0);
            this.add((Component)this.chkCatalog, WizardContainer.UI_CONSTRAINT);
            WizardContainer.constrain(2, 2, 1, 1, 0.5, 0.0, 17, 2);
            this.add((Component)this.txtCatalog, WizardContainer.UI_CONSTRAINT);
            WizardContainer.constrain(3, 2, 1, 1, 0.0, 0.0, 17, 0);
            this.add((Component)this.btnLoadCatalogs, WizardContainer.UI_CONSTRAINT);
            WizardContainer.constrain(0, 3, 4, 1, 0.0, 0.0, 17, 0);
            this.add(Box.createVerticalStrut(22), WizardContainer.UI_CONSTRAINT);
            jLabel = new JLabel(BasicUtilities.getString("JetFire_Select_Dst_Service"));
            WizardContainer.constrain(0, 4, 2, 1, 0.0, 0.0, 17, 0);
            this.add((Component)jLabel, WizardContainer.UI_CONSTRAINT);
            WizardContainer.constrain(1, 5, 2, 1, 0.0, 0.0, 17, 2);
            this.add((Component)this.jcbDestService, WizardContainer.UI_CONSTRAINT);
            WizardContainer.constrain(3, 5, 1, 1, 0.0, 0.0, 17, 0);
            this.add((Component)this.btnTestDst, WizardContainer.UI_CONSTRAINT);
            WizardContainer.constrain(0, 0, 1, 6, 0.0, 0.0, 17, 0);
            this.add(Box.createHorizontalStrut(16), WizardContainer.UI_CONSTRAINT);
            WizardContainer.constrain(0, 6, 4, 1, 0.0, 1.0, 17, 3);
            this.add(Box.createVerticalGlue(), WizardContainer.UI_CONSTRAINT);
            WizardContainer.constrain(4, 0, 1, 7, 1.0, 0.0, 17, 2);
            this.add(Box.createHorizontalGlue(), WizardContainer.UI_CONSTRAINT);
            Collection collection = this.serviceProvider.getRegisteredServices(true);
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                Object e2 = iterator.next();
                this.mdlSources.addElement(e2);
                this.mdlDest.addElement(e2);
            }
            this.jcbDestService.setRenderer(new ToggleRenderer(this.mdlSources));
            this.jcbSourceService.setRenderer(new ToggleRenderer(this.mdlDest));
            this.btnLoadCatalogs.setToolTipText(BasicUtilities.getString("JetFire_Load_Catalogs_Tip"));
            this.chkCatalog.setToolTipText(BasicUtilities.getString("JetFire_Use_Catalogs_Tip"));
            this.btnTestDst.setToolTipText(BasicUtilities.getString("JetFire_Test_Service_Tip"));
            this.btnTestSrc.setToolTipText(BasicUtilities.getString("JetFire_Test_Service_Tip"));
            this.jcbSourceService.setToolTipText(BasicUtilities.getString("JetFire_Select_Service_Tip"));
            this.jcbDestService.setToolTipText(BasicUtilities.getString("JetFire_Select_Service_Tip"));
            this.txtCatalog.setToolTipText(BasicUtilities.getString("JetFire_Catalog_Edit_Tip"));
            this.btnLoadCatalogs.addActionListener(this);
            this.btnTestSrc.addActionListener(this);
            this.btnTestDst.addActionListener(this);
            this.chkCatalog.addActionListener(this);
            this.jcbSourceService.addActionListener(this);
            this.configureCombobox(this.jcbDestService);
            this.configureCombobox(this.jcbSourceService);
        }

        private void configureCombobox(JComboBox jComboBox) {
            jComboBox.setMaximumRowCount(4);
            jComboBox.setSelectedIndex(0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        private boolean testService(String string, boolean bl2) {
            ServiceDefinition serviceDefinition;
            block15: {
                serviceDefinition = null;
                serviceDefinition = this.serviceProvider.serviceForName(string);
                DatabaseConnection databaseConnection = serviceDefinition.createConnection();
                if (!databaseConnection.gsConnect()) break block15;
                if (bl2) {
                    String string2 = BasicUtilities.getString("JetFire_Test_OK", string);
                    JOptionPane.showMessageDialog(this, string2, "", 1);
                }
                boolean bl3 = true;
                try {
                    serviceDefinition.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                return bl3;
            }
            String string3 = BasicUtilities.getString("JetFire_Test_Failed", string);
            JOptionPane.showMessageDialog(this, string3, "", 0);
            boolean bl4 = false;
            try {
                serviceDefinition.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return bl4;
            catch (Throwable throwable) {
                try {
                    String string4 = BasicUtilities.getString("JetFire_Test_Failed", string);
                    BasicUtilities.showExceptionPopup(this, throwable, string4);
                    boolean bl5 = false;
                    return bl5;
                }
                catch (Throwable throwable2) {
                    throw throwable2;
                }
                finally {
                    try {
                        serviceDefinition.close();
                    }
                    catch (Throwable throwable3) {}
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void loadCatalogs() {
            block14: {
                if (this.mdlCatalogs == null) {
                    this.mdlCatalogs = new DefaultComboBoxModel();
                    this.jcbCatalogs = new JComboBox(this.mdlCatalogs);
                }
                String string = this.jcbSourceService.getSelectedItem().toString();
                ServiceDefinition serviceDefinition = null;
                try {
                    serviceDefinition = this.serviceProvider.serviceForName(string);
                    DatabaseConnection databaseConnection = serviceDefinition.createConnection();
                    if (databaseConnection.gsConnect()) {
                        Object[] objectArray = databaseConnection.getAvailableCatalogs();
                        for (int i2 = 0; i2 < objectArray.length; ++i2) {
                            this.mdlCatalogs.addElement(objectArray[i2]);
                        }
                        this.jcbCatalogs.setEnabled(this.mdlCatalogs.getSize() >= 1);
                        this.remove(this.txtCatalog);
                        WizardContainer.constrain(2, 2, 1, 1, 0.1, 0.0, 17, 2);
                        this.add((Component)this.jcbCatalogs, WizardContainer.UI_CONSTRAINT);
                        break block14;
                    }
                    throw new IllegalStateException();
                }
                catch (Throwable throwable) {
                    this.remove(this.jcbCatalogs);
                    WizardContainer.constrain(2, 2, 1, 1, 0.1, 0.0, 17, 2);
                    this.add((Component)this.txtCatalog, WizardContainer.UI_CONSTRAINT);
                    String string2 = BasicUtilities.getString("JetFire_Catalogs_Failed", string);
                    BasicUtilities.showExceptionPopup(this, throwable, string2);
                    this.jcbCatalogs = null;
                    this.mdlCatalogs = null;
                }
                finally {
                    try {
                        serviceDefinition.close();
                    }
                    catch (Throwable throwable) {}
                }
            }
        }
    }
}

