/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.core.jetfire;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.Map;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import org.isqlviewer.core.jetfire.AbstractImportPlugin;
import org.isqlviewer.core.jetfire.ImportConfig;
import org.isqlviewer.core.jetfire.ImportProcessor;
import org.isqlviewer.sql.JDBCUtilities;
import org.isqlviewer.util.BasicUtilities;

public class LookupPlugin
extends AbstractImportPlugin
implements ActionListener {
    private DefaultComboBoxModel mdlColumns = new DefaultComboBoxModel();
    private DefaultComboBoxModel mdlTables = new DefaultComboBoxModel();
    private JComboBox jcbColumns = new JComboBox(this.mdlColumns);
    private JComboBox jcbTables = new JComboBox(this.mdlTables);
    private JTextField txtWhereClause = new JTextField("");
    private JCheckBox chkAllowNulls = new JCheckBox(BasicUtilities.getString("Import_SQL_Allow_Nulls"));
    private static final String KEY_TABLE = "table";
    private static final String KEY_COLUMN = "column";
    private static final String KEY_ALLOW_NULLS = "allow-nulls";
    private static final String KEY_WHERE = "where";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.jcbTables) {
            DatabaseMetaData databaseMetaData = this.connection.getDatabaseInformation();
            ResultSet resultSet = null;
            String string = this.connection.getCatalog();
            String string2 = this.connection.getSchema();
            String string3 = (String)this.jcbTables.getSelectedItem();
            this.mdlColumns.removeAllElements();
            try {
                resultSet = databaseMetaData.getColumns(string, string2, string3, "%");
                while (resultSet.next()) {
                    this.mdlColumns.addElement(resultSet.getString("COLUMN_NAME"));
                }
            }
            catch (Throwable throwable) {
                BasicUtilities.beep();
                BasicUtilities.HandleException(throwable);
            }
            finally {
                try {
                    resultSet.close();
                }
                catch (Throwable throwable) {}
                resultSet = null;
            }
        }
    }

    public ImportConfig.Entry createEntry() {
        ImportConfig.Entry entry = new ImportConfig.Entry(this);
        entry.put(KEY_ALLOW_NULLS, new Boolean(this.chkAllowNulls.isSelected()));
        Object object = this.jcbColumns.getSelectedItem();
        if (object != null) {
            entry.put(KEY_COLUMN, object);
        } else {
            entry.put(KEY_COLUMN, "");
        }
        object = this.jcbTables.getSelectedItem();
        if (object != null) {
            entry.put(KEY_TABLE, object);
        } else {
            entry.put(KEY_TABLE, "");
        }
        entry.setProperty(KEY_WHERE, this.txtWhereClause.getText());
        return entry;
    }

    public void setEntry(ImportConfig.Entry entry) {
        if (entry.containsKey(KEY_ALLOW_NULLS)) {
            try {
                Boolean bl2 = (Boolean)entry.get(KEY_ALLOW_NULLS);
                this.chkAllowNulls.setSelected(bl2);
            }
            catch (Throwable throwable) {
                this.chkAllowNulls.setSelected(false);
            }
        }
        this.jcbColumns.setSelectedItem(entry.get(KEY_COLUMN));
        this.jcbTables.setSelectedItem(entry.get(KEY_TABLE));
        this.txtWhereClause.setText(entry.getProperty(KEY_WHERE, ""));
    }

    public void installEditor(Container container) {
        container.setLayout(new GridBagLayout());
        LookupPlugin.constrain(0, 0, 1, 3, 0.0, 0.0, 10, 0);
        container.add(Box.createHorizontalStrut(16), UI_CONSTRAINT);
        LookupPlugin.constrain(1, 0, 1, 1, 0.0, 0.0, 13, 0);
        container.add((Component)new JLabel(BasicUtilities.getString("Import_Lookup_Table")), UI_CONSTRAINT);
        LookupPlugin.constrain(2, 0, 1, 1, 1.0, 0.0, 10, 2);
        container.add((Component)this.jcbTables, UI_CONSTRAINT);
        LookupPlugin.constrain(1, 1, 1, 1, 0.0, 0.0, 13, 0);
        container.add((Component)new JLabel(BasicUtilities.getString("Import_Lookup_Column")), UI_CONSTRAINT);
        LookupPlugin.constrain(2, 1, 1, 1, 1.0, 0.0, 10, 2);
        container.add((Component)this.jcbColumns, UI_CONSTRAINT);
        LookupPlugin.constrain(1, 2, 1, 1, 0.0, 0.0, 10, 0);
        container.add((Component)new JLabel(BasicUtilities.getString("Import_Lookup_Where")), UI_CONSTRAINT);
        LookupPlugin.constrain(2, 2, 1, 1, 1.0, 0.0, 10, 2);
        container.add((Component)this.txtWhereClause, UI_CONSTRAINT);
        LookupPlugin.constrain(2, 3, 1, 1, 1.0, 0.0, 10, 2);
        container.add((Component)this.chkAllowNulls, UI_CONSTRAINT);
        LookupPlugin.constrain(3, 0, 1, 3, 0.0, 0.0, 10, 0);
        container.add(Box.createHorizontalStrut(16), UI_CONSTRAINT);
        LookupPlugin.constrain(0, 4, 4, 1, 1.0, 1.0, 10, 3);
        container.add(Box.createVerticalGlue(), UI_CONSTRAINT);
        this.jcbTables.addActionListener(this);
        Object[] objectArray = this.connection.getAvailableTables();
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            this.mdlTables.addElement(objectArray[i2]);
        }
        if (this.mdlTables.getSize() >= 1) {
            this.jcbTables.setSelectedIndex(0);
        }
        this.chkAllowNulls.setToolTipText(BasicUtilities.getString("Import_SQL_Allow_Nulls_Tip"));
        this.txtWhereClause.setToolTipText(BasicUtilities.getString("Import_Lookup_Where_Tip"));
        this.jcbColumns.setToolTipText(BasicUtilities.getString("Import_Lookup_Column_Tip"));
        this.jcbTables.setToolTipText(BasicUtilities.getString("Import_Lookup_Table_Tip"));
    }

    public ImportProcessor createProcessor() {
        return new LookupProcessor(this);
    }

    public String getDescription() {
        return BasicUtilities.getString("Import_SQL_Lookup");
    }

    private static class LookupProcessor
    implements ImportProcessor {
        private static final String SELECT = "SELECT {0} FROM {1} {2}";
        private ImportConfig.Entry current = null;
        private LookupPlugin reference = null;

        public LookupProcessor(LookupPlugin lookupPlugin) {
            this.reference = lookupPlugin;
        }

        public boolean canSkip() {
            return false;
        }

        public int prepareImport(int n2, int n3, Map map, PreparedStatement preparedStatement, int n4) throws SQLException {
            block29: {
                if (!this.current.containsKey(LookupPlugin.KEY_COLUMN) || !this.current.containsKey(LookupPlugin.KEY_TABLE)) {
                    this.reference.info(BasicUtilities.getString("Lookup_Bad_Entry"));
                    return 2;
                }
                Statement statement = preparedStatement.getConnection().createStatement();
                ResultSet resultSet = null;
                try {
                    Object object;
                    String string = this.current.getProperty(LookupPlugin.KEY_TABLE);
                    String string2 = this.current.getProperty(LookupPlugin.KEY_COLUMN);
                    String string3 = this.current.getProperty(LookupPlugin.KEY_WHERE, "");
                    if (string3.trim().length() >= 1) {
                        string3 = "WHERE ".concat(string3);
                    }
                    Object[] objectArray = new String[]{string2, string, string3};
                    String string4 = MessageFormat.format(SELECT, objectArray);
                    boolean bl2 = false;
                    try {
                        object = (Boolean)this.current.get(LookupPlugin.KEY_ALLOW_NULLS);
                        bl2 = (Boolean)object;
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    this.reference.info(BasicUtilities.getString("Lookup_Query", string4));
                    resultSet = statement.executeQuery(string4);
                    if (resultSet.next()) {
                        object = resultSet.getMetaData();
                        int n5 = resultSet.findColumn(string2);
                        int n6 = object.getColumnType(n5);
                        Object object2 = JDBCUtilities.getValueForType(resultSet, n6, n5);
                        if (!bl2 && object2 == null) {
                            int n7 = 1;
                            return n7;
                        }
                        JDBCUtilities.configurePreparedStatement(preparedStatement, n3, object2, n4, false);
                        break block29;
                    }
                    int n8 = bl2 ? 3 : 1;
                    return n8;
                }
                catch (SQLException sQLException) {
                    throw sQLException;
                }
                catch (Throwable throwable) {
                    throw new SQLException(throwable.getMessage());
                }
                finally {
                    try {
                        resultSet.close();
                    }
                    catch (Throwable throwable) {}
                    resultSet = null;
                    try {
                        statement.close();
                    }
                    catch (Throwable throwable) {}
                    statement = null;
                }
            }
            return 0;
        }

        public void setEntry(ImportConfig.Entry entry) {
            this.current = null;
            this.current = entry;
        }
    }
}

