/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.core.filters;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.prefs.Preferences;
import javax.swing.Icon;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.TableModel;
import org.isqlviewer.core.filters.AbstractTableFilter;
import org.isqlviewer.core.model.EnhancedTableModel;
import org.isqlviewer.util.Base64Encoder;
import org.isqlviewer.util.BasicUtilities;
import org.isqlviewer.util.ExtensionFileFilter;
import org.isqlviewer.util.StringUtilities;

public class HTMLTableFilter
extends AbstractTableFilter {
    public FileFilter[] getSupportedFileTypes(int n2) {
        return new FileFilter[]{new ExtensionFileFilter(this.getString("HTML_Extension"), this.getString("HTML_Desc")), new ExtensionFileFilter(this.getString("HTM_Extension"), this.getString("HTML_Desc"))};
    }

    public boolean isModeSupported(int n2) {
        switch (n2) {
            case 1: {
                return true;
            }
        }
        return false;
    }

    public String getName() {
        return BasicUtilities.getString("HTML_Handler_Name");
    }

    public boolean isFileRequired(int n2) {
        return true;
    }

    public Icon getUserIcon() {
        return BasicUtilities.loadIconResource("Html16");
    }

    public int filterIn(EnhancedTableModel enhancedTableModel, File file, InputStream inputStream) {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int filterOut(Object object, File file, OutputStream outputStream) throws IOException, InterruptedException {
        int n2;
        if (!(object instanceof TableModel)) {
            return 0;
        }
        TableModel tableModel = (TableModel)object;
        int n3 = 0;
        n3 = tableModel instanceof EnhancedTableModel ? ((EnhancedTableModel)tableModel).getTrueRowCount() : tableModel.getRowCount();
        Preferences preferences = this.getConfiguration(1);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("");
        String string = null;
        Charset charset = this.getPreferredCharset(1);
        PrintWriter printWriter = new PrintWriter((Writer)new OutputStreamWriter(outputStream, charset), true);
        this.setProgressMax(n3);
        string = BasicUtilities.getString("HTML_Include_CSS_Name");
        boolean bl2 = preferences.getBoolean(string, true);
        string = BasicUtilities.getString("HTML_EmbeddBlobs_Name");
        boolean bl3 = preferences.getBoolean(string, true);
        string = BasicUtilities.getString("HTML_Title_Name");
        String string2 = preferences.get(string, BasicUtilities.getString("HTML_Title_Value"));
        printWriter.println("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01//EN\" \"http://www.w3.org/TR/html4/strict.dtd\">");
        printWriter.println("<html lang=\"" + Locale.getDefault().getISO3Language() + "\" >");
        printWriter.println(" <head>");
        printWriter.println("  <meta http-equiv=\"Content-Type\" content=\"text/html; charset=" + charset.name() + "\"> ");
        printWriter.println("  <meta content=\"iSQL-Viewer-2.1.8 name=generator\">");
        printWriter.println("  <title>" + string2 + "</title>");
        if (bl2) {
            printWriter.println("  <style type=\"text/css\" > ");
            printWriter.println("   BODY { ");
            printWriter.println("    background-color : #F3F3F3;");
            printWriter.println("    text-decoration : none;");
            printWriter.println("    margin : 0px 0px 0px 0px; ");
            printWriter.println("    font : 13px Verdana, Tahoma, Arial, Helvetica, sans-serif;");
            printWriter.println("   }");
            printWriter.println("   TH { ");
            printWriter.println("    font-family : Verdana, Tahoma, Arial, Helvetica, sans-serif;");
            printWriter.println("    font-size: 12px;");
            printWriter.println("    color : #FFFFFF;");
            printWriter.println("    text-decoration : none;");
            printWriter.println("    background-color  : #426794;");
            printWriter.println("   }");
            printWriter.println("   HR {");
            printWriter.println("    width: 95%;");
            printWriter.println("    color  : #426794;");
            printWriter.println("    background-color  : #426794;");
            printWriter.println("   }");
            printWriter.println("   TABLE { ");
            printWriter.println("    color : #FFFFFF;");
            printWriter.println("    text-decoration : none;");
            printWriter.println("    background-color  : #426794;");
            printWriter.println("    text-align : center;");
            printWriter.println("   }");
            printWriter.println("   TD { ");
            printWriter.println("    background-color : #FEFEFE;");
            printWriter.println("    text-align : inherit;");
            printWriter.println("    font-family : Verdana, Tahoma, Arial, Helvetica, sans-serif;");
            printWriter.println("    font-size: 11px;");
            printWriter.println("    color  : #000000;");
            printWriter.println("   }");
            printWriter.println("   .alt { ");
            printWriter.println("    background-color : #CFCFCF;");
            printWriter.println("    text-align : inherit;");
            printWriter.println("    font-family : Verdana, Tahoma, Arial, Helvetica, sans-serif;");
            printWriter.println("    font-size: 11px;");
            printWriter.println("    color  : #000000;");
            printWriter.println("   }");
            printWriter.println("   .footer { ");
            printWriter.println("    font-family : Verdana, Tahoma, Arial, Helvetica, sans-serif;");
            printWriter.println("    font-size: 8px;");
            printWriter.println("    text-align: center;");
            printWriter.println("    color  : #000000;");
            printWriter.println("   }");
            printWriter.println("  </style> ");
        }
        printWriter.println(" </head>");
        printWriter.println(" <body>");
        printWriter.println("  <div>");
        printWriter.println("   <table width=\"100%\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\">");
        printWriter.println("    <tr>");
        printWriter.println("     <td style=\"background-color: #426794; color : #FFFFFF;\">");
        printWriter.println("      <table width=\"100%\" border=\"0\" cellspacing=\"2\" cellpadding=\"2\">");
        printWriter.println("       <tr>");
        printWriter.println("        <th>");
        printWriter.println("         " + BasicUtilities.getString("Number_Of_Records", "" + tableModel.getRowCount()));
        printWriter.println("        </th>");
        printWriter.println("       </tr>");
        printWriter.println("       <tr>");
        printWriter.println("        <td style=\"background-color: #F3F3F3; color : #000000;\">");
        printWriter.println("         <table width=\"100%\" border=\"0\" cellspacing=\"1\" cellpadding=\"1\">");
        printWriter.println("          <tr>");
        for (n2 = 0; n2 < tableModel.getColumnCount(); ++n2) {
            printWriter.print("           <th>");
            printWriter.print(StringUtilities.encodeXMLEntities(tableModel.getColumnName(n2)) + "&nbsp;");
            printWriter.println("</th>");
        }
        printWriter.println("          </tr>");
        for (n2 = 0; n2 < tableModel.getRowCount(); ++n2) {
            printWriter.println("          <tr>");
            for (int i2 = 0; i2 < tableModel.getColumnCount(); ++i2) {
                printWriter.print("           <td" + (n2 % 2 == 0 ? "" : " class=\"alt\"") + ">");
                Object object2 = tableModel.getValueAt(n2, i2);
                String string3 = null;
                if (object2 != null) {
                    FileOutputStream fileOutputStream;
                    Object object3;
                    Object object4;
                    Object object5;
                    if (object2 instanceof Timestamp) {
                        object5 = this.sysConfig.getFormatForSQLType(93);
                        simpleDateFormat.applyPattern((String)object5);
                        string3 = simpleDateFormat.format((Timestamp)object2);
                    } else if (object2 instanceof Time) {
                        object5 = this.sysConfig.getFormatForSQLType(92);
                        simpleDateFormat.applyPattern((String)object5);
                        string3 = simpleDateFormat.format((Time)object2);
                    } else if (object2 instanceof Date) {
                        object5 = this.sysConfig.getFormatForSQLType(91);
                        simpleDateFormat.applyPattern((String)object5);
                        string3 = simpleDateFormat.format((Date)object2);
                    } else if (object2 instanceof Blob) {
                        object5 = (Blob)object2;
                        try {
                            if (bl3) {
                                object4 = new ByteArrayOutputStream(1024);
                                object3 = new Base64Encoder(object5.getBinaryStream(), (OutputStream)object4);
                                ((Base64Encoder)object3).process();
                                string3 = ((ByteArrayOutputStream)object4).toString();
                                ((ByteArrayOutputStream)object4).reset();
                                ((ByteArrayOutputStream)object4).close();
                            }
                            object4 = new File(file.getParentFile(), file.getName() + "_files");
                            ((File)object4).mkdirs();
                            object3 = new File((File)object4, tableModel.getColumnName(i2) + "_" + Integer.toString(n2) + ".bin");
                            if (((File)object3).exists()) {
                                ((File)object3).delete();
                            }
                            this.debug(((File)object3).getAbsolutePath());
                            if (((File)object3).createNewFile()) {
                                fileOutputStream = new FileOutputStream((File)object3);
                                BasicUtilities.copyStream(object5.getBinaryStream(), fileOutputStream);
                                printWriter.print("<a href=\"./" + file.getName() + "_files/" + ((File)object3).getName() + "\">" + tableModel.getColumnName(i2) + "</a>");
                                fileOutputStream.flush();
                                fileOutputStream.close();
                            }
                            printWriter.print("<div style=\"width: 95%; border-width: medium; border-style:solid; border-color:#FF0000;\">&nbsp;</div>");
                        }
                        catch (Throwable throwable) {
                            this.debug("", throwable);
                            throw new IOException(throwable.getMessage());
                        }
                    } else if (object2 instanceof Clob) {
                        object5 = (Clob)object2;
                        try {
                            if (bl3) {
                                object4 = new ByteArrayOutputStream((int)object5.length());
                                BasicUtilities.copyStream(object5.getAsciiStream(), (OutputStream)object4);
                                string3 = ((ByteArrayOutputStream)object4).toString();
                                ((ByteArrayOutputStream)object4).reset();
                                ((ByteArrayOutputStream)object4).close();
                            }
                            object4 = new File(file.getParentFile(), file.getName() + "_files");
                            ((File)object4).mkdirs();
                            object3 = new File((File)object4, tableModel.getColumnName(i2) + "_" + Integer.toString(n2) + ".txt");
                            if (((File)object3).exists()) {
                                ((File)object3).delete();
                            }
                            this.debug(((File)object3).getAbsolutePath());
                            if (((File)object3).createNewFile()) {
                                fileOutputStream = new FileOutputStream((File)object3);
                                BasicUtilities.copyStream(object5.getAsciiStream(), fileOutputStream);
                                printWriter.print("<a href=\"./" + file.getName() + "_files/" + ((File)object3).getName() + "\">" + tableModel.getColumnName(i2) + "</a>");
                                fileOutputStream.flush();
                                fileOutputStream.close();
                            }
                            printWriter.print("<div style=\"width: 95%; border-width: medium; border-style:solid; border-color:#FF0000;\">&nbsp;</div>");
                        }
                        catch (Throwable throwable) {
                            this.debug("", throwable);
                            throw new IOException(throwable.getMessage());
                        }
                    } else {
                        string3 = object2.toString();
                    }
                    if (string3 != null) {
                        printWriter.print(StringUtilities.encodeXMLEntities(string3) + "&nbsp;");
                    }
                } else {
                    printWriter.print("<div style=\"width: 95%; border-width: medium; border-style:solid; border-color:#FF0000;\">&nbsp;</div>");
                }
                printWriter.println("</td>");
            }
            printWriter.println("          </tr>");
            printWriter.flush();
            this.fireProgressUpdated(n2);
            try {
                this.checkIfCancelled();
                continue;
            }
            catch (InterruptedException interruptedException) {
                try {
                    printWriter.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw interruptedException;
            }
        }
        printWriter.println("         </table>");
        printWriter.println("         <hr/>");
        printWriter.println("         <div class=\"footer\"><em>iSQL-Viewer 2.1.8</em></div>");
        printWriter.println("        </td>");
        printWriter.println("       </tr>");
        printWriter.println("      </table>");
        printWriter.println("     </td>");
        printWriter.println("    </tr>");
        printWriter.println("   </table>");
        printWriter.println("  </div>");
        printWriter.println(" </body>");
        printWriter.println("</html>");
        try {
            printWriter.flush();
            printWriter.close();
        }
        catch (Exception exception) {
        }
        finally {
            printWriter = null;
        }
        this.fireProgressUpdated(tableModel.getRowCount());
        return 1;
    }

    public void loadProperties(int n2) {
        switch (n2) {
            case 1: {
                String string = this.getString("HTML_Title_Name");
                String string2 = this.getString("HTML_Title_Desc");
                this.addProperty(string, null, "", false, string2);
                string = this.getString("HTML_Include_CSS_Name");
                string2 = this.getString("HTML_Include_CSS_Desc");
                this.addProperty(string, CHOICE_BOOLEAN, "true", false, string2);
                string = this.getString("HTML_Insert_Class_Name");
                string2 = this.getString("HTML_Insert_Class_Desc");
                this.addProperty(string, CHOICE_BOOLEAN, "true", false, string2);
                string = this.getString("HTML_IncludeHeader_Name");
                string2 = this.getString("HTML_IncludeHeader_Desc");
                this.addProperty(string, CHOICE_BOOLEAN, "true", false, string2);
                string = this.getString("HTML_EmbeddBlobs_Name");
                string2 = this.getString("HTML_EmbeddBlobs_Desc");
                this.addProperty(string, CHOICE_BOOLEAN, "true", false, string2);
                break;
            }
        }
    }
}

