/*
 * Decompiled with CFR 0.152.
 */
package org.garret.perst.impl;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import org.garret.perst.IPersistent;
import org.garret.perst.impl.OidHashTable;

public class PinWeakHashTable
implements OidHashTable {
    Entry[] table;
    static final float loadFactor = 0.75f;
    int count;
    int threshold;
    boolean flushing;

    public PinWeakHashTable(int n2) {
        this.threshold = (int)((float)n2 * 0.75f);
        this.table = new Entry[n2];
    }

    public synchronized boolean remove(int n2) {
        Entry[] entryArray = this.table;
        int n3 = (n2 & Integer.MAX_VALUE) % entryArray.length;
        Entry entry = entryArray[n3];
        Entry entry2 = null;
        while (entry != null) {
            if (entry.oid == n2) {
                if (entry2 != null) {
                    entry2.next = entry.next;
                } else {
                    entryArray[n3] = entry.next;
                }
                entry.clear();
                --this.count;
                return true;
            }
            entry2 = entry;
            entry = entry.next;
        }
        return false;
    }

    protected Reference createReference(Object object) {
        return new WeakReference<Object>(object);
    }

    public synchronized void put(int n2, IPersistent iPersistent) {
        Reference reference = this.createReference(iPersistent);
        Entry[] entryArray = this.table;
        int n3 = (n2 & Integer.MAX_VALUE) % entryArray.length;
        Entry entry = entryArray[n3];
        while (entry != null) {
            if (entry.oid == n2) {
                entry.ref = reference;
                return;
            }
            entry = entry.next;
        }
        if (this.count >= this.threshold && !this.flushing) {
            this.rehash();
            entryArray = this.table;
            n3 = (n2 & Integer.MAX_VALUE) % entryArray.length;
        }
        entryArray[n3] = new Entry(n2, reference, entryArray[n3]);
        ++this.count;
    }

    public synchronized IPersistent get(int n2) {
        Entry[] entryArray = this.table;
        int n3 = (n2 & Integer.MAX_VALUE) % entryArray.length;
        Entry entry = entryArray[n3];
        while (entry != null) {
            if (entry.oid == n2) {
                if (entry.pin != null) {
                    return entry.pin;
                }
                return (IPersistent)entry.ref.get();
            }
            entry = entry.next;
        }
        return null;
    }

    public synchronized void flush() {
        this.flushing = true;
        for (int i2 = 0; i2 < this.table.length; ++i2) {
            Entry entry = this.table[i2];
            while (entry != null) {
                IPersistent iPersistent = entry.pin;
                if (iPersistent != null) {
                    entry.pin = null;
                    iPersistent.store();
                }
                entry = entry.next;
            }
        }
        this.flushing = false;
        if (this.count >= this.threshold) {
            this.rehash();
        }
    }

    public synchronized void invalidate() {
        for (int i2 = 0; i2 < this.table.length; ++i2) {
            Entry entry = this.table[i2];
            while (entry != null) {
                IPersistent iPersistent = entry.pin;
                if (iPersistent != null) {
                    entry.pin = null;
                    iPersistent.invalidate();
                }
                entry = entry.next;
            }
            this.table[i2] = null;
        }
        this.count = 0;
    }

    public synchronized void clear() {
        Entry[] entryArray = this.table;
        for (int i2 = 0; i2 < entryArray.length; ++i2) {
            entryArray[i2] = null;
        }
        this.count = 0;
    }

    void rehash() {
        Object object;
        Entry[] entryArray;
        Object object2;
        int n2 = this.table.length;
        Entry[] entryArray2 = this.table;
        int n3 = n2;
        while (--n3 >= 0) {
            object2 = null;
            Entry[] entryArray3 = entryArray2[n3];
            while (entryArray3 != null) {
                entryArray = entryArray3.next;
                object = entryArray3.ref.get();
                if ((object == null || object.isDeleted()) && entryArray3.pin == null) {
                    --this.count;
                    entryArray3.clear();
                    if (object2 == null) {
                        entryArray2[n3] = entryArray;
                    } else {
                        object2.next = entryArray;
                    }
                } else {
                    object2 = entryArray3;
                }
                entryArray3 = entryArray;
            }
        }
        if (this.count <= this.threshold >>> 1) {
            return;
        }
        int n4 = n2 * 2 + 1;
        entryArray = new Entry[n4];
        this.threshold = (int)((float)n4 * 0.75f);
        this.table = entryArray;
        n3 = n2;
        while (--n3 >= 0) {
            object2 = entryArray2[n3];
            while (object2 != null) {
                object = object2;
                object2 = object2.next;
                int n5 = (object.oid & Integer.MAX_VALUE) % n4;
                object.next = entryArray[n5];
                entryArray[n5] = object;
            }
        }
    }

    public synchronized void setDirty(IPersistent iPersistent) {
        int n2 = iPersistent.getOid();
        Entry[] entryArray = this.table;
        int n3 = (n2 & Integer.MAX_VALUE) % entryArray.length;
        Entry entry = entryArray[n3];
        while (entry != null) {
            if (entry.oid == n2) {
                entry.pin = iPersistent;
                return;
            }
            entry = entry.next;
        }
    }

    public synchronized void clearDirty(IPersistent iPersistent) {
        int n2 = iPersistent.getOid();
        Entry[] entryArray = this.table;
        int n3 = (n2 & Integer.MAX_VALUE) % entryArray.length;
        Entry entry = entryArray[n3];
        while (entry != null) {
            if (entry.oid == n2) {
                entry.pin = null;
                return;
            }
            entry = entry.next;
        }
    }

    public int size() {
        return this.count;
    }

    static class Entry {
        Entry next;
        Reference ref;
        int oid;
        IPersistent pin;

        void clear() {
            this.ref.clear();
            this.ref = null;
            this.pin = null;
            this.next = null;
        }

        Entry(int n2, Reference reference, Entry entry) {
            this.next = entry;
            this.oid = n2;
            this.ref = reference;
        }
    }
}

