/*
 * Decompiled with CFR 0.152.
 */
package org.garret.perst.impl;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import org.garret.perst.Assert;
import org.garret.perst.FieldIndex;
import org.garret.perst.IPersistent;
import org.garret.perst.Key;
import org.garret.perst.StorageError;
import org.garret.perst.impl.Btree;
import org.garret.perst.impl.BtreeKey;
import org.garret.perst.impl.BtreePage;
import org.garret.perst.impl.ClassDescriptor;
import org.garret.perst.impl.QueryImpl;
import org.garret.perst.impl.StorageImpl;

class BtreeFieldIndex
extends Btree
implements FieldIndex {
    String className;
    String fieldName;
    long autoincCount;
    transient Class cls;
    transient Field fld;

    BtreeFieldIndex() {
    }

    private final void locateField() {
        this.fld = ClassDescriptor.locateField(this.cls, this.fieldName);
        if (this.fld == null) {
            throw new StorageError(20, this.className + "." + this.fieldName);
        }
    }

    public Class getIndexedClass() {
        return this.cls;
    }

    public Field[] getKeyFields() {
        return new Field[]{this.fld};
    }

    public void onLoad() {
        this.cls = ClassDescriptor.loadClass(this.getStorage(), this.className);
        this.locateField();
    }

    BtreeFieldIndex(Class clazz, String string, boolean bl2) {
        this(clazz, string, bl2, 0L);
    }

    BtreeFieldIndex(Class clazz, String string, boolean bl2, long l2) {
        this.cls = clazz;
        this.unique = bl2;
        this.fieldName = string;
        this.className = ClassDescriptor.getClassName(clazz);
        this.autoincCount = l2;
        this.locateField();
        this.type = BtreeFieldIndex.checkType(this.fld.getType());
    }

    private Key extractKey(IPersistent iPersistent) {
        try {
            Field field = this.fld;
            Key key = null;
            switch (this.type) {
                case 0: {
                    key = new Key(field.getBoolean(iPersistent));
                    break;
                }
                case 1: {
                    key = new Key(field.getByte(iPersistent));
                    break;
                }
                case 3: {
                    key = new Key(field.getShort(iPersistent));
                    break;
                }
                case 2: {
                    key = new Key(field.getChar(iPersistent));
                    break;
                }
                case 4: {
                    key = new Key(field.getInt(iPersistent));
                    break;
                }
                case 10: {
                    IPersistent iPersistent2 = (IPersistent)field.get(iPersistent);
                    if (iPersistent2 != null && !iPersistent2.isPersistent()) {
                        this.getStorage().makePersistent(iPersistent2);
                    }
                    key = new Key(iPersistent2);
                    break;
                }
                case 5: {
                    key = new Key(field.getLong(iPersistent));
                    break;
                }
                case 9: {
                    key = new Key((Date)field.get(iPersistent));
                    break;
                }
                case 6: {
                    key = new Key(field.getFloat(iPersistent));
                    break;
                }
                case 7: {
                    key = new Key(field.getDouble(iPersistent));
                    break;
                }
                case 8: {
                    key = new Key(((String)field.get(iPersistent)).toCharArray());
                    break;
                }
                default: {
                    Assert.failed("Invalid type");
                }
            }
            return key;
        }
        catch (Exception exception) {
            throw new StorageError(17, exception);
        }
    }

    public boolean put(IPersistent iPersistent) {
        return super.insert(this.extractKey(iPersistent), iPersistent, false) >= 0;
    }

    public IPersistent set(IPersistent iPersistent) {
        return super.set(this.extractKey(iPersistent), iPersistent);
    }

    public void remove(IPersistent iPersistent) {
        super.remove(new BtreeKey(this.extractKey(iPersistent), iPersistent.getOid()));
    }

    public boolean containsObject(IPersistent iPersistent) {
        Key key = this.extractKey(iPersistent);
        if (this.unique) {
            return super.get(key) != null;
        }
        IPersistent[] iPersistentArray = this.get(key, key);
        for (int i2 = 0; i2 < iPersistentArray.length; ++i2) {
            if (iPersistentArray[i2] != iPersistent) continue;
            return true;
        }
        return false;
    }

    public boolean contains(IPersistent iPersistent) {
        Key key = this.extractKey(iPersistent);
        if (this.unique) {
            return super.get(key) != null;
        }
        IPersistent[] iPersistentArray = this.get(key, key);
        for (int i2 = 0; i2 < iPersistentArray.length; ++i2) {
            if (!iPersistentArray[i2].equals(iPersistent)) continue;
            return true;
        }
        return false;
    }

    public synchronized void append(IPersistent iPersistent) {
        Key key;
        try {
            switch (this.type) {
                case 4: {
                    key = new Key((int)this.autoincCount);
                    this.fld.setInt(iPersistent, (int)this.autoincCount);
                    break;
                }
                case 5: {
                    key = new Key(this.autoincCount);
                    this.fld.setLong(iPersistent, this.autoincCount);
                    break;
                }
                default: {
                    throw new StorageError(8, this.fld.getType());
                }
            }
        }
        catch (Exception exception) {
            throw new StorageError(17, exception);
        }
        ++this.autoincCount;
        iPersistent.modify();
        super.insert(key, iPersistent, false);
    }

    public IPersistent[] get(Key key, Key key2) {
        ArrayList arrayList = new ArrayList();
        if (this.root != 0) {
            BtreePage.find((StorageImpl)this.getStorage(), this.root, this.checkKey(key), this.checkKey(key2), this, this.height, arrayList);
        }
        return (IPersistent[])arrayList.toArray((Object[])Array.newInstance(this.cls, arrayList.size()));
    }

    public IPersistent[] toPersistentArray() {
        IPersistent[] iPersistentArray = (IPersistent[])Array.newInstance(this.cls, this.nElems);
        if (this.root != 0) {
            BtreePage.traverseForward((StorageImpl)this.getStorage(), this.root, this.type, this.height, iPersistentArray, 0);
        }
        return iPersistentArray;
    }

    public Iterator select(String string) {
        QueryImpl queryImpl = new QueryImpl(this.getStorage());
        return queryImpl.select(this.cls, this.iterator(), string);
    }
}

