/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.gs.beanutils.converters;

import org.apache.commons.gs.beanutils.ConversionException;
import org.apache.commons.gs.beanutils.Converter;

public final class ShortConverter
implements Converter {
    private Object defaultValue = null;
    private boolean useDefault = true;

    public ShortConverter() {
        this.defaultValue = null;
        this.useDefault = false;
    }

    public ShortConverter(Object object) {
        this.defaultValue = object;
        this.useDefault = true;
    }

    public Object convert(Class clazz, Object object) {
        if (object == null) {
            if (this.useDefault) {
                return this.defaultValue;
            }
            throw new ConversionException("No value specified");
        }
        if (object instanceof Short) {
            return object;
        }
        if (object instanceof Number) {
            return new Short(((Number)object).shortValue());
        }
        try {
            return new Short(object.toString());
        }
        catch (Exception exception) {
            if (this.useDefault) {
                return this.defaultValue;
            }
            throw new ConversionException(exception);
        }
    }
}

