/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.tools.spacebrowser.statistics;

import com.j_spaces.core.IJSpace;
import com.j_spaces.core.admin.StatisticsAdmin;
import com.j_spaces.core.filters.StatisticsContext;
import com.j_spaces.tools.IRefreshable;
import com.j_spaces.tools.spacebrowser.SpaceBrowser;
import com.j_spaces.tools.spacebrowser.SpaceTreeNode;
import com.j_spaces.tools.spacebrowser.statistics.ColorMap;
import com.j_spaces.tools.spacebrowser.statistics.LineGraph;
import com.j_spaces.tools.spacebrowser.statistics.PieGraph;
import com.j_spaces.tools.spacebrowser.utils.RefreshPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.ConnectException;
import java.rmi.ConnectIOException;
import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.MatteBorder;
import javax.swing.border.TitledBorder;

public class StatisticPanel
extends JPanel
implements IRefreshable {
    private PieGraph pie;
    private LineGraph lineGraph;
    private LineGraph tpGraph;
    private JPanel chartControlPanel;
    private JPanel chartsPanel;
    private SpaceBrowser browser;
    private Hashtable pieElements = new Hashtable();
    private Hashtable lineElements = new Hashtable();
    private GraphElements pieElementsOBJ;
    private GraphElements lineElementsOBJ;
    private JButton clearButton;
    private IJSpace space;
    private Object spaceObj;
    private ArrayList pieData;
    private Object admin = null;
    private StatisticsAdmin stats;
    private int readValueTP = 0;
    private int writeValueTP = 0;
    private int updateValueTP = 0;
    private int takeValueTP = 0;
    private int notifyRegistrationValueTP = 0;
    private int notifySentValueTP = 0;
    private int notifyAckValueTP = 0;
    public static final String RESOURCE_DIR = "/image/browser";
    public static final String START_IMG = "/startedRuntime.gif";
    public static final String STOP_IMG = "/stoppedRuntime.gif";
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.ui.spacebrowser");
    private boolean isExceptionShown = false;
    private RefreshPanel refreshPanel;

    public StatisticPanel(SpaceBrowser spaceBrowser) {
        this.setBackground(Color.WHITE);
        this.clearButton = new JButton("Clear Graph");
        this.browser = spaceBrowser;
        this.chartsPanel = new JPanel();
        this.chartsPanel.setLayout(new GridLayout(2, 1));
        this.spaceObj = spaceBrowser.getSelectedSpaceNode().getSpaceObjectID();
        try {
            this.pieElementsOBJ = (GraphElements)this.pieElements.get(this.spaceObj);
            this.lineElementsOBJ = (GraphElements)this.lineElements.get(this.spaceObj);
            if (this.pieElementsOBJ == null) {
                this.pieElementsOBJ = new GraphElements("Legend", false, null);
                this.pieElements.put(this.spaceObj, this.pieElementsOBJ);
                this.lineElementsOBJ = new GraphElements("Graph Scalling", true, null);
                this.lineElements.put(this.spaceObj, this.lineElementsOBJ);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.setPreferredSize(new Dimension(800, 600));
        this.setBackground(Color.WHITE);
        this.setLayout(new BorderLayout());
        this.pie = new PieGraph(this.spaceObj);
        this.lineGraph = new LineGraph();
        this.lineGraph.setBorder(new TitledBorder("Operations Statistics History"));
        this.tpGraph = new LineGraph();
        this.tpGraph.setBorder(new TitledBorder("TP Statistics History"));
        this.setBackground(Color.WHITE);
        this.pie.setBackground(Color.WHITE);
        this.chartsPanel.setBackground(Color.WHITE);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(2, 1));
        jPanel.add(this.pieElementsOBJ);
        jPanel.add(this.lineElementsOBJ);
        this.chartControlPanel = new JPanel(new BorderLayout());
        this.chartControlPanel.add((Component)jPanel, "Center");
        this.chartControlPanel.add((Component)this.clearButton, "South");
        SpaceTreeNode spaceTreeNode = spaceBrowser.getSelectedSpaceNode();
        this.space = (IJSpace)spaceTreeNode.proxy();
        try {
            this.admin = this.space.getAdmin();
            if (!(this.admin instanceof StatisticsAdmin)) {
                return;
            }
            this.stats = (StatisticsAdmin)this.admin;
            if (!this.stats.isStatisticsAvailable()) {
                String string = "Statistics for Space \"" + spaceTreeNode.getProxyName() + "\" not Available. Please Start the Statistics Filter.";
                JOptionPane.showConfirmDialog(spaceBrowser, string, "Space Statistics", -1);
                return;
            }
        }
        catch (RemoteException remoteException) {
            return;
        }
        this.clearButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                StatisticPanel.this.lineGraph.clearGraph();
                StatisticPanel.this.tpGraph.clearGraph();
            }
        });
        this.refreshPanel = new RefreshPanel(this, true);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        jPanel2.setBackground(Color.WHITE);
        jPanel2.setBorder(new TitledBorder("Operations Statistics Status"));
        jPanel2.add((Component)this.pie, "Center");
        this.chartsPanel.add(jPanel2);
        this.chartsPanel.add(this.lineGraph);
        this.add((Component)this.chartsPanel, "Center");
        this.add((Component)this.refreshPanel, "North");
        this.add((Component)this.chartControlPanel, "East");
    }

    public void replaceGraph(boolean bl2) {
        if (bl2) {
            if (this.lineGraph.isValid()) {
                this.chartsPanel.remove(this.lineGraph);
                this.chartsPanel.add(this.tpGraph);
                this.chartsPanel.validate();
            }
        } else if (this.tpGraph.isValid()) {
            this.chartsPanel.remove(this.tpGraph);
            this.chartsPanel.add(this.lineGraph);
            this.chartsPanel.validate();
        }
    }

    public void refresh() {
        block19: {
            this.pieData = new ArrayList();
            try {
                this.pieElementsOBJ.updateBackgrounds();
                this.lineElementsOBJ.updateBackgrounds();
                if (this.stats.isStatisticsAvailable()) {
                    StatisticsContext statisticsContext = this.stats.getStatistics(new Integer(2));
                    StatisticsContext statisticsContext2 = this.stats.getStatistics(new Integer(12));
                    StatisticsContext statisticsContext3 = this.stats.getStatistics(new Integer(0));
                    StatisticsContext statisticsContext4 = this.stats.getStatistics(new Integer(9));
                    StatisticsContext statisticsContext5 = this.stats.getStatistics(new Integer(4));
                    StatisticsContext statisticsContext6 = this.stats.getStatistics(new Integer(15));
                    StatisticsContext statisticsContext7 = this.stats.getStatistics(new Integer(16));
                    StatisticsContext statisticsContext8 = this.stats.getStatistics(new Integer(3));
                    StatisticsContext statisticsContext9 = this.stats.getStatistics(new Integer(14));
                    int n2 = statisticsContext == null ? 0 : (int)statisticsContext.getCurrentCount();
                    int n3 = statisticsContext2 == null ? 0 : (int)statisticsContext2.getCurrentCount();
                    int n4 = statisticsContext3 == null ? 0 : (int)statisticsContext3.getCurrentCount();
                    int n5 = statisticsContext4 == null ? 0 : (int)statisticsContext4.getCurrentCount();
                    int n6 = statisticsContext8 == null ? 0 : (int)statisticsContext8.getCurrentCount();
                    int n7 = statisticsContext9 == null ? 0 : (int)statisticsContext9.getCurrentCount();
                    int n8 = statisticsContext5 == null ? 0 : (int)statisticsContext5.getCurrentCount();
                    int n9 = statisticsContext6 == null ? 0 : (int)statisticsContext6.getCurrentCount();
                    int n10 = statisticsContext7 == null ? 0 : (int)statisticsContext7.getCurrentCount();
                    n6 += n7;
                    n2 += n3;
                    Map map = ColorMap.instance().getColorMapping();
                    if (this.pieElementsOBJ.writeCBox.isSelected()) {
                        this.pieData.add(this.pie.getPieValue(n4, (Color)map.get("Write")));
                    }
                    if (this.pieElementsOBJ.updateCBox.isSelected()) {
                        this.pieData.add(this.pie.getPieValue(n5, (Color)map.get("Update")));
                    }
                    if (this.pieElementsOBJ.readCBox.isSelected()) {
                        this.pieData.add(this.pie.getPieValue(n2, (Color)map.get("Read")));
                    }
                    if (this.pieElementsOBJ.takeCBox.isSelected()) {
                        this.pieData.add(this.pie.getPieValue(n6, (Color)map.get("Take")));
                    }
                    if (this.pieElementsOBJ.notifySentCBox.isSelected()) {
                        this.pieData.add(this.pie.getPieValue(n9, (Color)map.get("Notify sent")));
                    }
                    if (this.pieElementsOBJ.notifyAcknowledgedCBox.isSelected()) {
                        this.pieData.add(this.pie.getPieValue(n10, (Color)map.get("Notify ack.")));
                    }
                    if (this.pieElementsOBJ.notifyRegistrationCBox.isSelected()) {
                        this.pieData.add(this.pie.getPieValue(n8, (Color)map.get("Notify registration")));
                    }
                    int n11 = this.refreshPanel.getSleepInterval() / 1000;
                    this.pie.setPie(this.pieData, n11);
                    n2 = (int)(this.lineElementsOBJ.readScalling.getSelected() * (float)n2);
                    n4 = (int)(this.lineElementsOBJ.writeScalling.getSelected() * (float)n4);
                    n5 = (int)(this.lineElementsOBJ.updateScalling.getSelected() * (float)n5);
                    n6 = (int)(this.lineElementsOBJ.takeScalling.getSelected() * (float)n6);
                    n8 = (int)(this.lineElementsOBJ.notifyRegistrationScalling.getSelected() * (float)n8);
                    n9 = (int)(this.lineElementsOBJ.notifySentScalling.getSelected() * (float)n9);
                    n10 = (int)(this.lineElementsOBJ.notifyAckScalling.getSelected() * (float)n10);
                    this.lineGraph.addTracepoint(0, n2, this.lineElementsOBJ.readCBox.isSelected());
                    int n12 = (n2 - this.readValueTP) / n11;
                    this.tpGraph.addTracepoint(0, n12 < 0 ? 0 : n12, this.lineElementsOBJ.readCBox.isSelected());
                    this.lineGraph.addTracepoint(1, n4, this.lineElementsOBJ.writeCBox.isSelected());
                    n12 = (n4 - this.writeValueTP) / n11;
                    this.tpGraph.addTracepoint(1, n12 < 0 ? 0 : n12, this.lineElementsOBJ.writeCBox.isSelected());
                    this.lineGraph.addTracepoint(2, n5, this.lineElementsOBJ.updateCBox.isSelected());
                    n12 = (n5 - this.updateValueTP) / n11;
                    this.tpGraph.addTracepoint(2, n12 < 0 ? 0 : n12, this.lineElementsOBJ.updateCBox.isSelected());
                    this.lineGraph.addTracepoint(4, n6, this.lineElementsOBJ.takeCBox.isSelected());
                    n12 = (n6 - this.takeValueTP) / n11;
                    this.tpGraph.addTracepoint(4, n12 < 0 ? 0 : n12, this.lineElementsOBJ.takeCBox.isSelected());
                    this.lineGraph.addTracepoint(3, n8, this.lineElementsOBJ.notifyRegistrationCBox.isSelected());
                    n12 = (n8 - this.notifyRegistrationValueTP) / n11;
                    this.tpGraph.addTracepoint(3, n12 < 0 ? 0 : n12, this.lineElementsOBJ.notifyRegistrationCBox.isSelected());
                    this.lineGraph.addTracepoint(5, n9, this.lineElementsOBJ.notifySentCBox.isSelected());
                    n12 = (n9 - this.notifySentValueTP) / n11;
                    this.tpGraph.addTracepoint(5, n12 < 0 ? 0 : n12, this.lineElementsOBJ.notifySentCBox.isSelected());
                    this.lineGraph.addTracepoint(6, n10, this.lineElementsOBJ.notifyAcknowledgedCBox.isSelected());
                    n12 = (n10 - this.notifyAckValueTP) / n11;
                    this.tpGraph.addTracepoint(6, n12 < 0 ? 0 : n12, this.lineElementsOBJ.notifyAcknowledgedCBox.isSelected());
                    this.readValueTP = n2;
                    this.writeValueTP = n4;
                    this.updateValueTP = n5;
                    this.takeValueTP = n6;
                    this.notifyRegistrationValueTP = n8;
                    this.notifySentValueTP = n9;
                    this.notifyAckValueTP = n10;
                    this.lineGraph.updateColors();
                    this.lineGraph.doStep(1);
                    this.tpGraph.updateColors();
                    this.tpGraph.doStep(1);
                }
            }
            catch (NoSuchObjectException noSuchObjectException) {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, noSuchObjectException.toString(), noSuchObjectException);
                }
            }
            catch (ConnectException connectException) {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, connectException.toString(), connectException);
                }
            }
            catch (ConnectIOException connectIOException) {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, connectIOException.toString(), connectIOException);
                }
            }
            catch (Exception exception) {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, exception.toString(), exception);
                }
                if (this.isExceptionShown) break block19;
                SpaceBrowser.showException(exception.toString(), exception);
                this.isExceptionShown = true;
            }
        }
        if (this.lineElementsOBJ.tpRadio.isSelected()) {
            this.replaceGraph(true);
        } else {
            this.replaceGraph(false);
        }
    }

    public boolean isRunning() {
        return false;
    }

    public void start() {
    }

    public void stop() {
    }

    public void stopRefresh() {
        this.refreshPanel.stopStatusRuntime();
    }

    private static class ScallingCombo
    extends JPanel {
        public JComboBox scallingCombo;
        public JLabel scal = new JLabel("Scale:");

        public ScallingCombo(Color color) {
            this.setLayout(new BorderLayout());
            this.setBackground(color);
            this.scallingCombo = new JComboBox<Object>(new Object[]{"1", "0.1", "0.01", "0.001", "10", "100", "1000"});
            this.add((Component)new JLabel("Scale:"), "West");
            this.add((Component)this.scallingCombo, "Center");
            Dimension dimension = new Dimension(55, 20);
            this.scallingCombo.setPreferredSize(dimension);
            this.scallingCombo.setMaximumSize(dimension);
            this.scallingCombo.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                }
            });
        }

        public float getSelected() {
            return new Float((String)this.scallingCombo.getSelectedItem()).floatValue();
        }
    }

    private static class GraphElements
    extends JPanel {
        private JCheckBox writeCBox = new JCheckBox("Write");
        private JCheckBox readCBox = new JCheckBox("Read");
        private JCheckBox takeCBox = new JCheckBox("Take");
        private JCheckBox updateCBox = new JCheckBox("Update");
        private JCheckBox notifyRegistrationCBox = new JCheckBox("Notify registration");
        private JCheckBox notifySentCBox = new JCheckBox("Notify sent");
        private JCheckBox notifyAcknowledgedCBox = new JCheckBox("Notify ack.");
        private ColorPane writeColor;
        private ColorPane readColor;
        private ColorPane takeColor;
        private ColorPane notifyRegistrationColor;
        private ColorPane notifySentColor;
        private ColorPane notifyAckColor;
        private ColorPane updateColor;
        private Map colorMapping = ColorMap.instance().getColorMapping();
        private ScallingCombo writeScalling = new ScallingCombo((Color)this.colorMapping.get("Write"));
        private ScallingCombo readScalling = new ScallingCombo((Color)this.colorMapping.get("Read"));
        private ScallingCombo takeScalling = new ScallingCombo((Color)this.colorMapping.get("Take"));
        private ScallingCombo notifyRegistrationScalling = new ScallingCombo((Color)this.colorMapping.get("Notify registration"));
        private ScallingCombo notifySentScalling = new ScallingCombo((Color)this.colorMapping.get("Notify sent"));
        private ScallingCombo notifyAckScalling = new ScallingCombo((Color)this.colorMapping.get("Notify ack."));
        private ScallingCombo updateScalling = new ScallingCombo((Color)this.colorMapping.get("Update"));
        private ButtonGroup graphType = new ButtonGroup();
        public JRadioButton opertionRadio = new JRadioButton("Total Operations Count History");
        public JRadioButton tpRadio = new JRadioButton("TP[Operations/Sec] History");
        private Box gridBox = new Box(1);
        private JPanel optionPanel;

        private GraphElements(String string, boolean bl2) {
            Dimension dimension;
            this.setLayout(new BoxLayout(this, 1));
            this.optionPanel = new JPanel(new GridLayout(3, 0));
            this.setBorder(new TitledBorder(string));
            this.writeColor = new ColorPane();
            this.readColor = new ColorPane();
            this.takeColor = new ColorPane();
            this.notifyRegistrationColor = new ColorPane();
            this.notifySentColor = new ColorPane();
            this.notifyAckColor = new ColorPane();
            this.updateColor = new ColorPane();
            this.updateBackgrounds();
            this.graphType.add(this.opertionRadio);
            this.graphType.add(this.tpRadio);
            this.writeCBox.setSelected(true);
            this.readCBox.setSelected(true);
            this.updateCBox.setSelected(true);
            this.notifyRegistrationCBox.setSelected(true);
            this.notifySentCBox.setSelected(true);
            this.notifyAcknowledgedCBox.setSelected(true);
            this.takeCBox.setSelected(true);
            Dimension dimension2 = new Dimension(185, 20);
            Box box = new Box(0);
            Box box2 = new Box(0);
            Box box3 = new Box(0);
            Box box4 = new Box(0);
            Box box5 = new Box(0);
            Box box6 = new Box(0);
            Box box7 = new Box(0);
            box.setPreferredSize(dimension2);
            box.setMaximumSize(dimension2);
            box2.setPreferredSize(dimension2);
            box2.setMaximumSize(dimension2);
            box3.setPreferredSize(dimension2);
            box3.setMaximumSize(dimension2);
            box4.setPreferredSize(dimension2);
            box4.setMaximumSize(dimension2);
            box5.setPreferredSize(dimension2);
            box5.setMaximumSize(dimension2);
            box6.setPreferredSize(dimension2);
            box6.setMaximumSize(dimension2);
            box7.setPreferredSize(dimension2);
            box7.setMaximumSize(dimension2);
            box.add(this.writeCBox);
            if (bl2) {
                box.add(this.writeScalling.scallingCombo);
            } else {
                box.add(this.writeColor);
            }
            box2.add(this.readCBox);
            if (bl2) {
                box2.add(this.readScalling.scallingCombo);
            } else {
                box2.add(this.readColor);
            }
            box6.add(this.takeCBox);
            if (bl2) {
                box6.add(this.takeScalling.scallingCombo);
            } else {
                box6.add(this.takeColor);
            }
            box7.add(this.updateCBox);
            if (bl2) {
                box7.add(this.updateScalling.scallingCombo);
            } else {
                box7.add(this.updateColor);
            }
            box3.add(this.notifyRegistrationCBox);
            if (bl2) {
                box3.add(this.notifyRegistrationScalling.scallingCombo);
            } else {
                box3.add(this.notifyRegistrationColor);
            }
            box4.add(this.notifySentCBox);
            if (bl2) {
                box4.add(this.notifySentScalling.scallingCombo);
            } else {
                box4.add(this.notifySentColor);
            }
            box5.add(this.notifyAcknowledgedCBox);
            if (bl2) {
                box5.add(this.notifyAckScalling.scallingCombo);
            } else {
                box5.add(this.notifyAckColor);
            }
            this.gridBox.add(box);
            this.gridBox.add(box7);
            this.gridBox.add(box2);
            this.gridBox.add(box6);
            this.gridBox.add(box3);
            this.gridBox.add(box4);
            this.gridBox.add(box5);
            this.gridBox.add(Box.createVerticalGlue());
            if (bl2) {
                this.tpRadio.setSelected(true);
                this.optionPanel.add(new JLabel("presents:"));
                this.optionPanel.add(this.tpRadio);
                this.optionPanel.add(this.opertionRadio);
                dimension = new Dimension(180, 50);
            } else {
                dimension = new Dimension(180, 1);
            }
            this.optionPanel.setPreferredSize(dimension);
            this.optionPanel.setMinimumSize(dimension);
            this.optionPanel.setMaximumSize(dimension);
            Dimension dimension3 = new Dimension(185, 140);
            this.gridBox.setPreferredSize(dimension3);
            this.gridBox.setMinimumSize(dimension3);
            this.gridBox.setMaximumSize(dimension3);
            this.add(this.gridBox);
            if (bl2) {
                this.add(Box.createVerticalStrut(40));
            }
            this.add(this.optionPanel);
            this.setCheckBoxesSize();
            this.setComboBoxesSize();
        }

        private void setCheckBoxesSize() {
            Dimension dimension = new Dimension(125, 20);
            this.writeCBox.setPreferredSize(dimension);
            this.readCBox.setPreferredSize(dimension);
            this.takeCBox.setPreferredSize(dimension);
            this.notifyRegistrationCBox.setPreferredSize(dimension);
            this.notifySentCBox.setPreferredSize(dimension);
            this.notifyAcknowledgedCBox.setPreferredSize(dimension);
            this.updateCBox.setPreferredSize(dimension);
            this.writeCBox.setMinimumSize(dimension);
            this.readCBox.setMinimumSize(dimension);
            this.takeCBox.setMinimumSize(dimension);
            this.notifyRegistrationCBox.setMinimumSize(dimension);
            this.notifySentCBox.setMinimumSize(dimension);
            this.notifyAcknowledgedCBox.setMinimumSize(dimension);
            this.updateCBox.setMinimumSize(dimension);
            this.writeCBox.setMaximumSize(dimension);
            this.readCBox.setMaximumSize(dimension);
            this.takeCBox.setMaximumSize(dimension);
            this.notifyRegistrationCBox.setMaximumSize(dimension);
            this.notifySentCBox.setMaximumSize(dimension);
            this.notifyAcknowledgedCBox.setMaximumSize(dimension);
            this.updateCBox.setMaximumSize(dimension);
        }

        private void setComboBoxesSize() {
            Dimension dimension = new Dimension(50, 20);
            this.writeScalling.setPreferredSize(dimension);
            this.readScalling.setPreferredSize(dimension);
            this.takeScalling.setPreferredSize(dimension);
            this.notifyRegistrationScalling.setPreferredSize(dimension);
            this.notifySentScalling.setPreferredSize(dimension);
            this.notifyAckScalling.setPreferredSize(dimension);
            this.updateScalling.setPreferredSize(dimension);
            this.writeScalling.setMaximumSize(dimension);
            this.readScalling.setMaximumSize(dimension);
            this.takeScalling.setMaximumSize(dimension);
            this.notifyRegistrationScalling.setMaximumSize(dimension);
            this.notifySentScalling.setMaximumSize(dimension);
            this.notifyAckScalling.setMaximumSize(dimension);
            this.updateScalling.setMaximumSize(dimension);
        }

        public void updateBackgrounds() {
            this.colorMapping = ColorMap.instance().getColorMapping();
            this.writeColor.setBackground((Color)this.colorMapping.get("Write"));
            this.takeColor.setBackground((Color)this.colorMapping.get("Take"));
            this.readColor.setBackground((Color)this.colorMapping.get("Read"));
            this.updateColor.setBackground((Color)this.colorMapping.get("Update"));
            this.notifyRegistrationColor.setBackground((Color)this.colorMapping.get("Notify registration"));
            this.notifySentColor.setBackground((Color)this.colorMapping.get("Notify sent"));
            this.notifyAckColor.setBackground((Color)this.colorMapping.get("Notify ack."));
            this.writeScalling.setBackground((Color)this.colorMapping.get("Write"));
            this.takeScalling.setBackground((Color)this.colorMapping.get("Take"));
            this.readScalling.setBackground((Color)this.colorMapping.get("Read"));
            this.updateScalling.setBackground((Color)this.colorMapping.get("Update"));
            this.notifyRegistrationScalling.setBackground((Color)this.colorMapping.get("Notify registration"));
            this.notifySentScalling.setBackground((Color)this.colorMapping.get("Notify sent"));
            this.notifyAckScalling.setBackground((Color)this.colorMapping.get("Notify ack."));
        }

        public /* synthetic */ GraphElements(String string, boolean bl2, 1 var3_3) {
            this(string, bl2);
        }

        private class ColorPane
        extends JPanel {
            public ColorPane() {
                this.setBorder(new MatteBorder(new Insets(6, 0, 3, 6), SystemColor.control));
                Dimension dimension = new Dimension(55, 20);
                this.setPreferredSize(dimension);
                this.setMaximumSize(dimension);
            }
        }
    }
}

