/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.tools.cluster.view;

import com.j_spaces.tools.cluster.GroupInfo;
import com.j_spaces.tools.cluster.view.ClusterPanel;
import com.j_spaces.tools.cluster.view.GraphPanel;
import com.j_spaces.tools.cluster.view.MembersLegend;
import com.j_spaces.tools.cluster.view.Node;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;

public class GroupsGraphPanel
extends GraphPanel {
    private ClusterPanel m_owner;
    private GroupInfo[] m_groups;
    private static GroupsGraphPanel instance;

    public GroupsGraphPanel() {
        this.setFont(new Font("Dialog", 1, 10));
        this.nodeDistance = this.nodeRadius + 5;
    }

    public static GroupsGraphPanel getInstance() {
        if (instance == null) {
            instance = new GroupsGraphPanel();
        }
        return instance;
    }

    public void setGroupsGraphPanel(ClusterPanel clusterPanel, GroupInfo[] groupInfoArray) {
        this.stop();
        this.setGraphPanel(clusterPanel, 85, 80);
        this.m_owner = clusterPanel;
        this.m_groups = groupInfoArray;
        this.reset();
        for (int i2 = 0; i2 < groupInfoArray.length; ++i2) {
            this.addNode(groupInfoArray[i2]);
        }
        this.start();
    }

    public void addNode(GroupInfo groupInfo) {
        super.addNode(groupInfo.groupName, groupInfo.getClusterName(), groupInfo.groupName, null, false);
        this.setPolicies((Node)this.nodesList.get(this.nnodes - 1), groupInfo.repInfo, groupInfo.loadBalInfo, groupInfo.failOverInfo);
    }

    public void setPolicies(Node node, Object object, Object object2, Object object3) {
        node.policies = new String();
        if (object != null) {
            node.policies = node.policies + "R";
        }
        if (object2 != null) {
            if (node.policies.length() > 0) {
                node.policies = node.policies + ", ";
            }
            node.policies = node.policies + "LB";
        }
        if (object3 != null) {
            if (node.policies.length() > 0) {
                node.policies = node.policies + ", ";
            }
            node.policies = node.policies + "FO";
        }
    }

    public void paintNode(Graphics graphics, Node node, FontMetrics fontMetrics) {
        int n2 = (int)node.x;
        int n3 = (int)node.y;
        String string = node.lbl;
        int n4 = (int)((double)(this.nodeRadius / fontMetrics.getAscent()) * 1.5);
        if (n4 > string.length()) {
            n4 = string.length();
        }
        string = string.substring(0, n4) + "...";
        graphics.setColor(Color.gray);
        int n5 = this.nodeRadius;
        int n6 = this.nodeRadius;
        graphics.fillOval(n2 - n5 / 2, n3 - n6 / 2, n5, n6);
        if (node.equals(this.pick) || node.fixed) {
            graphics.setColor(MembersLegend.getColor("Target"));
            graphics.drawOval(n2 - n5 / 2, n3 - n6 / 2, n5 - 1, n6 - 1);
        }
        graphics.setColor(Color.black);
        graphics.drawString(string, n2 - n5 / 3, n3 - (n6 - 4) / 5 + fontMetrics.getAscent());
        graphics.drawString(node.policies, n2 - (n5 - 10) / 3, n3 - (n6 - 4) / 5 + fontMetrics.getAscent() + 17);
    }

    public void performNodeAction(Node node) {
        this.m_owner.setClusterTreeNode(node.lbl);
    }
}

